/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.sql.util.StringUtil;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountControlAttribute;
import com.kingdee.eas.basedata.master.account.AccountTypeCollection;
import com.kingdee.eas.basedata.master.account.AccountTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountTypeInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountType;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrTypeInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SaleGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ContrastAccountViewFactory;
import com.kingdee.eas.fi.ar.IContrastAccountView;
import com.kingdee.eas.fi.ar.ImportException;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.util.ImportDataUtil;
import com.kingdee.eas.fi.ar.verifyStatusEnum;
import com.kingdee.eas.fi.arap.app.ARAPImportHelper;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class OtherBillDataImport
extends AbstractDataTransmission {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.OtherBillDataImport");
    protected Map infoMap = new HashMap(100);
    protected String curKey;
    protected boolean isImportDataByRule = false;
    private final int MAX_CACH_VALUE = 1000;
    protected CurrencyInfo baseCurrency = null;
    protected CompanyOrgUnitInfo currentCompany = null;
    protected String cuId = null;
    protected PeriodInfo startPeriod = null;
    protected PeriodInfo currentPeriod = null;
    protected boolean isInitBill = false;
    protected boolean arIsStart = true;
    protected boolean isFinish = false;
    protected boolean isConnSCM = false;
    protected List idList = new ArrayList();
    protected CoreBaseInfo coreInfo = null;
    protected Map isContrastAccountCache = new HashMap(10);
    protected Map companyCache = new HashMap(10);
    protected Map currencyCache = new HashMap(10);
    protected Map sysStatusCtrolCache = new HashMap(10);
    protected Map paymentTypeCache = new HashMap(10);
    protected Map asstActTypeCache = new HashMap(10);
    protected Map billTypeCache = new HashMap(10);
    protected Map accountViewCache = new HashMap(10);
    protected Map paramCache = new HashMap(10);
    protected Map exchangeRateCache = new HashMap(10);
    protected Map checkOrgPermissionCache = new HashMap(10);
    protected Map multiMeasureUnitCache = new HashMap(10);
    protected Map asstAttrValueCache = new HashMap(10);
    protected Map settlementTypeCache = new HashMap(10);
    protected Map adminOrgCache = new HashMap(10);
    protected Map personCache = new HashMap(10);
    protected Map saleGroupCache = new HashMap(10);
    protected Map saleOrgCache = new HashMap(10);
    protected Map asstActCache = new HashMap(10);
    protected Map isExistAsstActCache = new HashMap(10);
    protected Map checkAsstActStatusCache = new HashMap(10);
    protected Map cashDiscountCache = new HashMap(10);
    protected Map measureUnitCache = new HashMap(10);
    protected Map materialCache = new HashMap(10);
    protected Map expenseItemCache = new HashMap(10);
    protected Map templeFieldNameCache = new HashMap();
    protected final String[] DATE_FIELDS = new String[]{"FBillDate", "FBizDate"};
    protected final String[] DATE_OBJS = new String[]{"billDate", "bizDate"};
    protected final String[] STRING_FIELDS = new String[]{"FAsstActNumber", "FAbstractName"};
    protected final String[] STRING_OBJS = new String[]{"asstActNumber", "abstractName"};
    protected final String[] ENTRY_STRING_FIELDS = new String[]{"FEntry_remark", "FEntry_coreBillNumber"};
    protected final String[] ENTRY_STRING_OBJS = new String[]{"remark", "coreBillNumber"};
    protected SystemEnum defaultSysEnum;
    protected SystemStatusCtrolInfo invStatus = null;
    protected SystemStatusCtrolInfo cachedSysStatus = null;
    protected SystemStatusCtrolInfo otherSysStatus = null;
    public static String NOT_MATCHED = "Not Matched";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        return null;
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        int blockSize = hsData.size();
        for (int i = 0; i < blockSize; ++i) {
            Map entry = (Map)hsData.get(new Integer(i));
            Object object = entry.get("FSeq");
            if (object == null || !(object instanceof DataToken)) continue;
            DataToken dataToken = (DataToken)object;
            if (dataToken.data == null || "".equals(dataToken.data.toString().trim())) continue;
            dataToken.data = Integer.valueOf(dataToken.data.toString());
        }
        return super.transmit(hsData, ctx);
    }

    protected void initDatas(Context ctx, Hashtable hsData, boolean isAR) throws TaskExternalException, BOSException, OtherBillBizException, ImportException {
        if (this.templeFieldNameCache.size() == 0) {
            String templeNumber = isAR ? "AROtherBill" : "APOtherBill";
            this.templeFieldNameCache = ARAPImportHelper.getTempleFieldNameMap(ctx, templeNumber);
        }
        if (hsData.get("templateFieldMap") == null) {
            hsData.put("templateFieldMap", this.templeFieldNameCache);
        }
        this.defaultSysEnum = isAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        this.currentCompany = this.getCompanyByCache(ctx, hsData, "FCompany_number");
        this.cuId = this.currentCompany.getCU().getId().toString();
        this.isConnSCM = Boolean.valueOf(this.getParamByCache(ctx, isAR ? "AR_SCM_001" : "AP_SCM_001", this.currentCompany.getId().toString()));
        String isSCMBill = this.getContextParameter("isSCMBill") == null ? "" : this.getContextParameter("isSCMBill").toString();
        boolean isSCM = Boolean.valueOf(isSCMBill);
        if (isSCM && !this.isConnSCM) {
            this.defaultSysEnum = SystemEnum.INVENTORYMANAGEMENT;
        }
        this.cachedSysStatus = this.getSysStatusCtrolInfoByCache(ctx, this.defaultSysEnum);
        if (this.cachedSysStatus == null || this.cachedSysStatus.getStartPeriod() == null || this.cachedSysStatus.getCurrentPeriod() == null) {
            throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{this.currentCompany.getName() + " " + this.defaultSysEnum.getAlias()});
        }
        this.startPeriod = this.cachedSysStatus.getStartPeriod();
        this.arIsStart = this.cachedSysStatus.isIsStart();
        this.currentPeriod = this.cachedSysStatus.getCurrentPeriod();
        this.baseCurrency = this.currentCompany.getBaseCurrency();
        if (this.baseCurrency == null) {
            throw new ImportException(ImportException.CANNOTGETLOCALCURRENCY);
        }
        this.isImportDataByRule = this.getImportParamByCache(ctx);
    }

    protected void checkOrgPermission(Context ctx, boolean isAR, boolean isInit) throws TaskExternalException {
        OrgType orgType = OrgType.Company;
        String permItemName = null;
        permItemName = isInit ? (isAR ? "fi_ar_InitBill_import" : "fi_ap_InitBill_import") : (isAR ? "fi_ar_ArOtherBill_Import" : "fi_ap_ApOtherBill_import");
        try {
            FullOrgUnitCollection orgCol;
            ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
            ObjectUuidPK cuId = new ObjectUuidPK(this.currentCompany.getCU().getId().toString());
            String key = permItemName + treePK.toString() + cuId.toString();
            if (this.checkOrgPermissionCache.get(key) != null) {
                orgCol = (FullOrgUnitCollection)this.checkOrgPermissionCache.get(key);
            } else {
                IPermission permission = PermissionFactory.getLocalInstance((Context)ctx);
                orgCol = permission.getAuthorizedOrgOfCU((IObjectPK)cuId, ctx.getCaller(), OrgType.Company, (IObjectPK)treePK, permItemName);
                this.checkOrgPermissionCache.put(key, orgCol);
            }
            boolean isHasPerm = false;
            for (int i = 0; i < orgCol.size(); ++i) {
                FullOrgUnitInfo orgInfo = orgCol.get(i);
                if (!orgInfo.getId().toString().equals(this.currentCompany.getId().toString())) continue;
                isHasPerm = true;
            }
            if (!isHasPerm) {
                throw new TaskExternalException(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARImportData", (String)"MULTIORGIMPORT", (Locale)ctx.getLocale(), (Object[])new Object[]{this.currentCompany.getNumber()}));
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e));
        }
    }

    protected boolean checkAsstAccID(Context ctx, AsstActTypeInfo asstActTypeInfo, Hashtable hsData, ArApBillBaseInfo otherBillInfo) throws TaskExternalException {
        String tableName;
        boolean flag = false;
        String str = ARAPImportHelper.getDataString(hsData, "FAsstActNumber");
        if (str == null) {
            throw new TaskExternalException(OtherBillDataImport.getString("AR", "FAsstActNumber_IsNull", ctx));
        }
        String fId = null;
        String fName = null;
        String fNumber = null;
        if (str != null && asstActTypeInfo != null && asstActTypeInfo.getDefaultQueryName() != null && (tableName = asstActTypeInfo.getRealtionDataObject()) != null && tableName.length() > 0) {
            try {
                Map asstActInfo = this.getAsstActByCache(ctx, str, asstActTypeInfo);
                fId = (String)asstActInfo.get("fid");
                fName = (String)asstActInfo.get("fname");
                fNumber = (String)asstActInfo.get("fnumber");
                if (!(StringUtils.isEmpty((String)fId) || StringUtils.isEmpty((String)fName) || StringUtils.isEmpty((String)fNumber))) {
                    flag = true;
                }
            }
            catch (Exception e) {
                throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), (Throwable)e);
            }
        }
        otherBillInfo.setAsstActID(fId);
        otherBillInfo.setAsstActName(fName);
        otherBillInfo.setAsstActNumber(fNumber);
        return flag;
    }

    protected Map getAsstActByCache(Context ctx, String asstactNumber, AsstActTypeInfo asstActType) throws TaskExternalException {
        HashMap<String, String> asstactInfo;
        boolean flag = false;
        try {
            String key = asstActType.getRealtionDataObject() + asstactNumber + (asstActType.getGlAsstActTypeGrp() == null ? "" : asstActType.getGlAsstActTypeGrp().getId().toString());
            if (this.asstActCache.get(key) != null) {
                asstactInfo = (HashMap<String, String>)this.asstActCache.get(key);
            } else {
                RowSet rs = null;
                String fId = null;
                String fName = null;
                String fNumber = null;
                asstactInfo = new HashMap<String, String>();
                rs = ARAPImportHelper.getAsstActInfo(ctx, asstactNumber, asstActType);
                while (rs.next()) {
                    fId = rs.getString("fid");
                    fName = rs.getString("fname");
                    fNumber = rs.getString("fnumber");
                }
                asstactInfo.put("fid", fId);
                asstactInfo.put("fname", fName);
                asstactInfo.put("fnumber", fNumber);
                this.asstActCache.put(key, asstactInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return asstactInfo;
    }

    protected boolean checkAsstActStatus(Context ctx, AsstActTypeInfo asstActType, String asstActId) throws BOSException, EASBizException {
        try {
            String relationDataObject = ARAPImportHelper.getRelationDataObject(ctx, asstActType);
            boolean fCust = relationDataObject.equalsIgnoreCase("T_BD_Customer");
            boolean fSupp = relationDataObject.equalsIgnoreCase("T_BD_Supplier");
            if (fCust || fSupp) {
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT FUsedStatus from ").append(relationDataObject);
                sb.append(" WHERE FID = '").append(asstActId).append("'");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
                boolean result = true;
                while (rs.next()) {
                    result = rs.getInt("FUsedStatus") == 1;
                }
                return result;
            }
            return true;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected boolean checkBillDate(ArApBillBaseInfo otherBillInfo, Context ctx) throws TaskExternalException {
        boolean ret = true;
        Date bizDate = otherBillInfo.getBizDate();
        if (bizDate == null) {
            Boolean isAr = this.isAr(otherBillInfo);
            throw new TaskExternalException(OtherBillDataImport.getString("AR", "BizDateIsNull", ctx));
        }
        Date billDate = otherBillInfo.getBillDate();
        if (billDate.before(bizDate)) {
            ret = false;
        }
        return ret;
    }

    protected Boolean isAr(ArApBillBaseInfo otherBillInfo) {
        return otherBillInfo.getBOSType().toString().equals(OtherBillInfo.getBosType().toString());
    }

    protected boolean checkIsPositiveRate(String fieldName, String amt) {
        String temp = null;
        if (fieldName != null && fieldName.length() > 4) {
            temp = fieldName.substring(fieldName.length() - 4);
            if (!fieldName.equalsIgnoreCase("FEntry_discountRate") && temp != null && temp.equalsIgnoreCase("rate")) {
                return ImportDataUtil.isPlusData(amt);
            }
        }
        return true;
    }

    protected boolean checkIsVerifyamount(String fieldName) {
        boolean temp = false;
        if (fieldName != null && fieldName.equalsIgnoreCase("FEntry_verifyAmount")) {
            temp = true;
        }
        return temp;
    }

    protected boolean checkIsVerifyamountLocal(String fieldName) {
        boolean temp = false;
        if (fieldName != null && fieldName.equalsIgnoreCase("FEntry_verifyamountLocal")) {
            temp = true;
        }
        return temp;
    }

    protected CompanyOrgUnitInfo getCompanyByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        String companyNumber = ARAPImportHelper.getDataString(hsData, field);
        CompanyOrgUnitInfo info = null;
        if (this.companyCache.get(companyNumber) != null) {
            info = (CompanyOrgUnitInfo)this.companyCache.get(companyNumber);
        } else {
            info = ARAPImportHelper.getCompany(ctx, hsData, field);
            this.companyCache.put(companyNumber, info);
        }
        if (!info.isIsBizUnit()) {
            throw new TaskExternalException(ARAPImportHelper.getString("COMPANY_IS_NOT_BIZUNIT", ctx));
        }
        return info;
    }

    protected CurrencyInfo getCurrencyByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        String currencyNumber = ARAPImportHelper.getDataString(hsData, field);
        CurrencyInfo info = null;
        if (this.currencyCache.get(currencyNumber) != null) {
            return (CurrencyInfo)this.currencyCache.get(currencyNumber);
        }
        info = ARAPImportHelper.getCurrencyInfo(ctx, hsData, field);
        this.currencyCache.put(currencyNumber, info);
        return info;
    }

    protected SettlementTypeInfo getSettlementTypeInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        String settlementTypeNumber = ARAPImportHelper.getDataString(hsData, field);
        SettlementTypeInfo info = null;
        if (this.settlementTypeCache.get(settlementTypeNumber) != null) {
            return (SettlementTypeInfo)this.settlementTypeCache.get(settlementTypeNumber);
        }
        info = ARAPImportHelper.getSettlementTypeInfo(ctx, hsData, field);
        this.settlementTypeCache.put(settlementTypeNumber, info);
        return info;
    }

    public AdminOrgUnitInfo getAdminOrgUnitInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        AdminOrgUnitInfo adminOrgUnitInfo;
        String adminOrgUnitNumber = ARAPImportHelper.getDataString(hsData, field);
        String key = adminOrgUnitNumber + this.cuId;
        try {
            if (this.adminOrgCache.get(key) != null) {
                adminOrgUnitInfo = (AdminOrgUnitInfo)this.adminOrgCache.get(key);
            } else {
                adminOrgUnitInfo = ARAPImportHelper.getAdminOrgUnitInfo(ctx, hsData, field, this.cuId);
                this.adminOrgCache.put(key, adminOrgUnitInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return adminOrgUnitInfo;
    }

    public PersonInfo getPersonInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        PersonInfo personInfo;
        String personNumber = ARAPImportHelper.getDataString(hsData, field);
        String key = personNumber + this.cuId;
        try {
            if (this.personCache.get(key) != null) {
                personInfo = (PersonInfo)this.personCache.get(key);
            } else {
                personInfo = ARAPImportHelper.getPersonInfo(ctx, hsData, field, this.cuId);
                this.personCache.put(key, personInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return personInfo;
    }

    public SaleGroupInfo getSaleGroupInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        SaleGroupInfo saleGroupInfo;
        String saleGroupNumber = ARAPImportHelper.getDataString(hsData, field);
        String key = saleGroupNumber + this.cuId;
        try {
            if (this.saleGroupCache.get(key) != null) {
                saleGroupInfo = (SaleGroupInfo)this.saleGroupCache.get(key);
            } else {
                saleGroupInfo = ARAPImportHelper.getSaleGroupInfo(ctx, hsData, field, this.cuId);
                this.saleGroupCache.put(key, saleGroupInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return saleGroupInfo;
    }

    public SaleOrgUnitInfo getSaleOrgInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        SaleOrgUnitInfo saleOrgInfo;
        String saleOrgNumber = ARAPImportHelper.getDataString(hsData, field);
        String key = saleOrgNumber + this.cuId;
        try {
            if (this.saleOrgCache.get(key) != null) {
                saleOrgInfo = (SaleOrgUnitInfo)this.saleOrgCache.get(key);
            } else {
                saleOrgInfo = ARAPImportHelper.getSaleOrgUnitInfo(ctx, hsData, field, this.cuId);
                this.saleOrgCache.put(key, saleOrgInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return saleOrgInfo;
    }

    public CashDiscountInfo getCashDiscountInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        CashDiscountInfo cashDiscountInfo;
        String cashDiscountNumber;
        String key = cashDiscountNumber = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (this.cashDiscountCache.get(key) != null) {
                cashDiscountInfo = (CashDiscountInfo)this.cashDiscountCache.get(key);
            } else {
                cashDiscountInfo = ARAPImportHelper.getCashDiscountInfo(ctx, hsData, field);
                this.cashDiscountCache.put(key, cashDiscountInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), e.getCause());
        }
        return cashDiscountInfo;
    }

    public MeasureUnitInfo getMeasureUnitInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        MeasureUnitInfo measureUnitInfo;
        String measureUnitNumber;
        String key = measureUnitNumber = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (this.measureUnitCache.get(key) != null) {
                measureUnitInfo = (MeasureUnitInfo)this.measureUnitCache.get(key);
            } else {
                measureUnitInfo = ARAPImportHelper.getMeasureUnitInfo(ctx, hsData, field);
                this.measureUnitCache.put(key, measureUnitInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), e.getCause());
        }
        return measureUnitInfo;
    }

    public MaterialInfo getMaterialInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        MaterialInfo materialInfo;
        String materialNumber;
        String key = materialNumber = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (this.materialCache.get(key) != null) {
                materialInfo = (MaterialInfo)this.materialCache.get(key);
            } else {
                materialInfo = ARAPImportHelper.getMaterialInfo(ctx, hsData, field);
                if (this.materialCache.size() > 1000) {
                    this.materialCache.clear();
                }
                this.materialCache.put(key, materialInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), e.getCause());
        }
        return materialInfo;
    }

    public ExpenseTypeInfo getExpenseItemInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        ExpenseTypeInfo expenseItemInfo;
        String expenseItemNumber;
        String key = expenseItemNumber = ARAPImportHelper.getDataString(hsData, field);
        try {
            if (this.expenseItemCache.get(key) != null) {
                expenseItemInfo = (ExpenseTypeInfo)this.expenseItemCache.get(key);
            } else {
                expenseItemInfo = ARAPImportHelper.getExpenseItemInfo(ctx, hsData, "FEntry$expenseItem_number");
                this.expenseItemCache.put(key, expenseItemInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), e.getCause());
        }
        return expenseItemInfo;
    }

    public Boolean isExistAsstActByCompanyByCache(Context ctx, CompanyOrgUnitInfo companyInfo, AsstActTypeInfo asstActInfo, String asstActId) throws TaskExternalException {
        boolean isExistAsstAct = false;
        try {
            String key = companyInfo.getId().toString() + asstActInfo.getId().toString() + asstActId;
            if (this.isExistAsstActCache.get(key) != null) {
                isExistAsstAct = (Boolean)this.isExistAsstActCache.get(key);
            } else {
                isExistAsstAct = ARAPImportHelper.isExistAsstActByCompany(ctx, companyInfo, asstActInfo, asstActId);
                this.isExistAsstActCache.put(key, isExistAsstAct);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), e.getCause());
        }
        return isExistAsstAct;
    }

    public Boolean checkAsstActStatusByCache(Context ctx, AsstActTypeInfo asstActInfo, String asstActId) throws TaskExternalException {
        boolean isExistAsstAct = false;
        try {
            String key = asstActInfo.getId().toString() + asstActId;
            if (this.checkAsstActStatusCache.get(key) != null) {
                isExistAsstAct = (Boolean)this.checkAsstActStatusCache.get(key);
            } else {
                isExistAsstAct = this.checkAsstActStatus(ctx, asstActInfo, asstActId);
                this.checkAsstActStatusCache.put(key, isExistAsstAct);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(ArApBillUtil.printExceptionMsg(e), e.getCause());
        }
        return isExistAsstAct;
    }

    protected SystemStatusCtrolInfo getSysStatusCtrolInfoByCache(Context ctx, SystemEnum system) throws BOSException {
        SystemStatusCtrolInfo sscInfo;
        if (this.currentCompany == null) {
            return null;
        }
        String key = this.currentCompany.getNumber() + system.getValue();
        if (this.sysStatusCtrolCache.get(key) != null) {
            sscInfo = (SystemStatusCtrolInfo)this.sysStatusCtrolCache.get(key);
        } else {
            sscInfo = ArApBillHelper.getSysStatusCtrolInfo(ctx, this.currentCompany, system);
            this.sysStatusCtrolCache.put(key, sscInfo);
        }
        return sscInfo;
    }

    protected PaymentTypeInfo getPaymentTypeInfoByCache(Context ctx, Hashtable hsData, String field, Boolean isAr) throws TaskExternalException, BOSException {
        PaymentTypeInfo paymentTypeInfo;
        String paymentTypeNumber = ARAPImportHelper.getDataString(hsData, field);
        if (this.paymentTypeCache.get(paymentTypeNumber) != null) {
            paymentTypeInfo = (PaymentTypeInfo)this.paymentTypeCache.get(paymentTypeNumber);
        } else {
            paymentTypeInfo = ARAPImportHelper.getPaymentTypeInfo(ctx, hsData, field);
            this.paymentTypeCache.put(paymentTypeNumber, paymentTypeInfo);
        }
        if (isAr.booleanValue()) {
            if (paymentTypeInfo != null && ("2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5".equals(paymentTypeInfo.getId().toString()) || "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5".equals(paymentTypeInfo.getId().toString()))) {
                throw new TaskExternalException(OtherBillDataImport.getString("AR", "PaymentType_Is_Error", ctx));
            }
        } else if (paymentTypeInfo != null && ("91f078d7-fb90-4827-83e2-3538237b67a06BCA0AB5".equals(paymentTypeInfo.getId().toString()) || "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(paymentTypeInfo.getId().toString()))) {
            throw new TaskExternalException(OtherBillDataImport.getString("AP", "PaymentType_Is_Error", ctx));
        }
        return paymentTypeInfo;
    }

    protected AsstActTypeInfo getAsstActTypeInfoByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException, BOSException {
        AsstActTypeInfo asstActTypeInfo;
        String asstActType = ARAPImportHelper.getDataString(hsData, field);
        if (this.asstActTypeCache.get(asstActType) != null) {
            asstActTypeInfo = (AsstActTypeInfo)this.asstActTypeCache.get(asstActType);
        } else {
            asstActTypeInfo = ARAPImportHelper.getAsstActTypeInfo(ctx, hsData, field);
            this.asstActTypeCache.put(asstActType, asstActTypeInfo);
        }
        return asstActTypeInfo;
    }

    protected BillTypeInfo getBillTypeByCache(Context ctx, Hashtable hsData, String field) throws TaskExternalException {
        BillTypeInfo billTypeInfo;
        String billNumber = ARAPImportHelper.getDataString(hsData, field);
        if (this.billTypeCache.get(billNumber) != null) {
            billTypeInfo = (BillTypeInfo)this.billTypeCache.get(billNumber);
        } else {
            billTypeInfo = ARAPImportHelper.getBillType(ctx, hsData, field);
            this.billTypeCache.put(billNumber, billTypeInfo);
        }
        return billTypeInfo;
    }

    protected AccountViewInfo getAccountViewInfoByCache(Context ctx, Hashtable hsData, String field, String companyId, String currencyId) throws TaskExternalException, BOSException {
        AccountViewInfo accountViewInfo;
        String accountView = ARAPImportHelper.getDataString(hsData, field);
        String key = accountView + companyId;
        if (this.accountViewCache.get(key) != null) {
            accountViewInfo = (AccountViewInfo)this.accountViewCache.get(key);
        } else {
            accountViewInfo = OtherBillDataImport.getAccountViewInfo(ctx, hsData, field, companyId, currencyId);
            this.accountViewCache.put(key, accountViewInfo);
        }
        return accountViewInfo;
    }

    protected boolean getImportParamByCache(Context ctx) {
        boolean importDataByRule = false;
        if (this.paramCache.get("importDataByRule") != null) {
            importDataByRule = (Boolean)this.paramCache.get("importDataByRule");
        } else {
            importDataByRule = ARAPImportHelper.getImportParam(ctx);
            this.paramCache.put("importDataByRule", importDataByRule);
        }
        return importDataByRule;
    }

    protected String getParamByCache(Context ctx, String paramKey, String companyId) throws TaskExternalException {
        try {
            String paramValue;
            String key = paramKey + companyId;
            if (this.paramCache.get(key) != null) {
                paramValue = (String)this.paramCache.get(key);
            } else {
                ObjectUuidPK pk = StringUtils.isEmpty((String)companyId) ? null : new ObjectUuidPK(companyId);
                paramValue = ParamManager.getParamValue((Context)ctx, (IObjectPK)pk, (String)paramKey);
                this.paramCache.put(key, paramValue);
            }
            return paramValue;
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    protected ExchangeRateInfo getExchangeRateInfoByCache(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo currencyInfo) throws Exception {
        ExchangeRateInfo exchangeRateInfo = null;
        if (companyOrgUnitInfo == null || currencyInfo == null) {
            return null;
        }
        String key = companyOrgUnitInfo.getId().toString() + currencyInfo.getId().toString();
        if (this.exchangeRateCache.get(key) != null) {
            exchangeRateInfo = (ExchangeRateInfo)this.exchangeRateCache.get(key);
        } else {
            exchangeRateInfo = ARAPImportHelper.getExchangeRateInfo(ctx, companyOrgUnitInfo, currencyInfo);
            this.exchangeRateCache.put(key, exchangeRateInfo);
        }
        return exchangeRateInfo;
    }

    protected MultiMeasureUnitInfo getMultiMeasureUnitByCache(Context ctx, MeasureUnitInfo mui, MaterialInfo mi) throws TaskExternalException {
        MultiMeasureUnitInfo mmu = null;
        try {
            if (mui == null && mi == null) {
                return null;
            }
            String key = mui.getId().toString() + mi.getId().toString();
            if (this.multiMeasureUnitCache.get(key) != null) {
                mmu = (MultiMeasureUnitInfo)this.multiMeasureUnitCache.get(key);
            } else {
                mmu = ARAPImportHelper.getMulUnit(ctx, mui, mi);
                this.multiMeasureUnitCache.put(key, mmu);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return mmu;
    }

    protected BigDecimal getBaseUnitQty(Context ctx, MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty) throws BaseException {
        BigDecimal coefficient;
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        MultiMeasureUnitInfo mulUnit = this.getMultiMeasureUnitByCache(ctx, mui, mi);
        if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
            baseQty = qty.multiply(coefficient);
            MeasureUnitInfo baseUnit = mi.getBaseUnit();
            if (baseUnit == null) {
                IMaterial im = MaterialFactory.getLocalInstance((Context)ctx);
                baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
            }
            mulUnit = this.getMultiMeasureUnitByCache(ctx, baseUnit, mi);
            int precision = mulUnit.getQtyPrecision();
            baseQty = baseQty.setScale(precision, 4);
        }
        return baseQty;
    }

    protected AsstAttrValueInfo getAsstAttrValueInfoByCache(Context ctx, Hashtable hsData, String field, AsstAttrTypeInfo assistAttr) throws TaskExternalException {
        String number = ARAPImportHelper.getDataString(hsData, field);
        String key = number + assistAttr.getId().toString();
        AsstAttrValueInfo asstAttrValueInfo = null;
        try {
            if (this.asstAttrValueCache.get(key) != null) {
                asstAttrValueInfo = (AsstAttrValueInfo)this.asstAttrValueCache.get(key);
            } else {
                asstAttrValueInfo = this.getAsstAttrValueInfo(ctx, hsData, field, assistAttr);
                if (this.asstAttrValueCache.size() > 1000) {
                    this.asstAttrValueCache.clear();
                }
                this.asstAttrValueCache.put(key, asstAttrValueInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return asstAttrValueInfo;
    }

    protected AsstAttrValueInfo getAsstAttrValueInfo(Context ctx, Hashtable hsData, String field, AsstAttrTypeInfo assistAttr) throws TaskExternalException, BOSException {
        String number = ARAPImportHelper.getDataString(hsData, field);
        AsstAttrValueInfo info = null;
        if (number != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
            SelectorItemCollection si = new SelectorItemCollection();
            si.add(new SelectorItemInfo("id"));
            si.add(new SelectorItemInfo("basictype.id"));
            si.add(new SelectorItemInfo("compondingtype.id"));
            ev.setFilter(fi);
            ev.setSelector(si);
            IAsstAttrValue iAsstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
            AsstAttrValueCollection collection = iAsstAttrValue.getAsstAttrValueCollection(ev);
            if (collection != null && collection.size() > 0) {
                info = collection.get(0);
                if (info != null) {
                    String infoType = null;
                    if (info.getBasictype() != null) {
                        infoType = info.getBasictype().getId().toString();
                    } else if (info.getCompondingtype() != null) {
                        infoType = info.getCompondingtype().getId().toString();
                    }
                    if (!assistAttr.getId().toString().equals(infoType)) {
                        ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
                    }
                }
            } else {
                ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
            }
        }
        return info;
    }

    protected void checkIsContrastAccountByCache(Context ctx, CompanyOrgUnitInfo company, AccountViewInfo account, Boolean isAR) throws BOSException, EASBizException {
        AccountControlAttribute accountControl;
        String key = "";
        boolean isContrast = false;
        IContrastAccountView iContrastAcct = ContrastAccountViewFactory.getLocalInstance((Context)ctx);
        AccountControlAttribute accountControlAttribute = accountControl = isAR != false ? AccountControlAttribute.AR : AccountControlAttribute.AP;
        if (account != null) {
            key = company.getCU().getId().toString() + company.getId().toString() + account.getId().toString() + accountControl.getValue();
            if (this.isContrastAccountCache.get(key) != null) {
                isContrast = (Boolean)this.isContrastAccountCache.get(key);
            } else {
                isContrast = iContrastAcct.isContrastAccount(company.getCU().getId().toString(), company.getId().toString(), account.getId().toString(), accountControl);
                this.isContrastAccountCache.put(key, isContrast);
            }
            if (!isContrast) {
                if (isAR.booleanValue()) {
                    throw new OtherBillBizException(OtherBillBizException.ACCOUNT_NOT_CONTRAST);
                }
                throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.ACCOUNT_NOT_CONTRAST);
            }
        }
    }

    protected void clearQtyZeroFields(ArApBillEntryBaseInfo entryInfo) {
        entryInfo.setQuantity(BigDecimal.ZERO);
        entryInfo.setAssistQty(BigDecimal.ZERO);
        entryInfo.setPrice(BigDecimal.ZERO);
        entryInfo.setTaxPrice(BigDecimal.ZERO);
        entryInfo.setRealPrice(BigDecimal.ZERO);
        entryInfo.setActualPrice(BigDecimal.ZERO);
        entryInfo.setDiscountAmount(BigDecimal.ZERO);
        entryInfo.setDiscountAmountLocal(BigDecimal.ZERO);
        entryInfo.setDiscountRate(BigDecimal.ZERO);
        entryInfo.setDiscountType(DiscountModeEnum.NULL);
    }

    protected void setMakeInvoiceReqRelationFields(ArApBillEntryBaseInfo entryInfo) {
        entryInfo.setInvoiceReqQty(BigDecimal.ZERO);
        entryInfo.setInvoiceReqBaseQty(BigDecimal.ZERO);
        entryInfo.setUnInvoiceReqQty(entryInfo.getQuantity());
        entryInfo.setUnInvoiceReqBaseQty(entryInfo.getBaseQty());
        entryInfo.setInvoiceReqAmount(BigDecimal.ZERO);
        entryInfo.setInvoiceReqAmountLocal(BigDecimal.ZERO);
        entryInfo.setUnInvoiceReqAmount(entryInfo.getRecievePayAmount());
        entryInfo.setUnInvoiceReqAmountLocal(entryInfo.getRecievePayAmountLocal());
    }

    protected void setBillAmtFromEntry(ArApBillBaseInfo otherBillInfo) {
        boolean isAR = OtherBillInfo.getBosType().toString().equals(otherBillInfo.getBOSType().toString());
        ArApBillEntryBaseCollection c = new ArApBillEntryBaseCollection();
        if (isAR) {
            c.addObjectCollection((IObjectCollection)((OtherBillentryCollection)((Object)otherBillInfo.get("entry"))));
        } else {
            c.addObjectCollection((IObjectCollection)((com.kingdee.eas.fi.ap.OtherBillentryCollection)((Object)otherBillInfo.get("entry"))));
        }
        BigDecimal temp = new BigDecimal(0);
        BigDecimal tempAmountLocal = new BigDecimal(0);
        BigDecimal tempVeriy = new BigDecimal(0);
        BigDecimal tempUnVeriy = new BigDecimal(0);
        BigDecimal tempVerifyAmountLocal = new BigDecimal(0);
        BigDecimal tempUnVeriyAmountLocal = new BigDecimal(0);
        BigDecimal tempTotalAmount = new BigDecimal(0);
        BigDecimal tempTotalTax = new BigDecimal(0);
        BigDecimal tempTotalAmountLocal = new BigDecimal(0);
        BigDecimal tempTotalTaxLocal = new BigDecimal(0);
        BigDecimal tempBadAmount = new BigDecimal(0);
        BigDecimal tempBadAmountLocal = new BigDecimal(0);
        Iterator itrEntry = c.iterator();
        while (itrEntry.hasNext()) {
            ArApBillEntryBaseInfo entryTmp = (ArApBillEntryBaseInfo)itrEntry.next();
            temp = temp.add(entryTmp.getRecievePayAmount());
            tempAmountLocal = tempAmountLocal.add(entryTmp.getRecievePayAmountLocal());
            tempUnVeriy = tempUnVeriy.add(entryTmp.getUnVerifyAmount());
            tempVeriy = tempVeriy.add(entryTmp.getVerifyAmount());
            tempVerifyAmountLocal = tempVerifyAmountLocal.add(entryTmp.getVerifyAmountLocal());
            tempUnVeriyAmountLocal = tempUnVeriyAmountLocal.add(entryTmp.getUnVerifyAmountLocal());
            tempTotalAmount = tempTotalAmount.add(entryTmp.getAmount());
            tempTotalTax = tempTotalTax.add(entryTmp.getTaxAmount());
            tempTotalAmountLocal = tempTotalAmountLocal.add(entryTmp.getAmountLocal());
            tempTotalTaxLocal = tempTotalTaxLocal.add(entryTmp.getTaxAmountLocal());
            if (!isAR) continue;
            tempBadAmount = tempBadAmount.add(entryTmp.getBigDecimal("badAmount"));
            tempBadAmountLocal = tempBadAmountLocal.add(entryTmp.getBigDecimal("badAmountLocal"));
        }
        otherBillInfo.setAmount(temp);
        otherBillInfo.setAmountLocal(tempAmountLocal);
        otherBillInfo.setUnVerifyAmount(tempUnVeriy);
        otherBillInfo.setVerifyAmount(tempVeriy);
        otherBillInfo.setVerifyAmountLocal(tempVerifyAmountLocal);
        otherBillInfo.setUnVerifyAmountLocal(tempUnVeriyAmountLocal);
        otherBillInfo.setTotalAmount(tempTotalAmount);
        otherBillInfo.setTotalTax(tempTotalTax);
        otherBillInfo.setTotalTaxAmount(tempTotalAmount.add(tempTotalTax));
        otherBillInfo.setTotalAmountLocal(tempTotalAmountLocal);
        otherBillInfo.setTotalTaxLocal(tempTotalTaxLocal);
        if (isAR) {
            otherBillInfo.put("totalBadAmount", tempBadAmount);
            otherBillInfo.put("totalBadAmountLocal", tempBadAmountLocal);
        }
        if (otherBillInfo.getVerifyAmount().compareTo(BigDecimal.ZERO) == 0) {
            otherBillInfo.setVerifyStatus(verifyStatusEnum.UNVERIFY);
        } else if (otherBillInfo.getVerifyAmount().compareTo(otherBillInfo.getAmount()) == 0) {
            otherBillInfo.setVerifyStatus(verifyStatusEnum.VERIFIED);
        } else {
            otherBillInfo.setVerifyStatus(verifyStatusEnum.SOME_VERIFIED);
        }
    }

    protected boolean getDataboolean(Hashtable hsData, String field) {
        String str = ARAPImportHelper.getDataString(hsData, field);
        if (str == null) {
            return false;
        }
        return str.equalsIgnoreCase("Y") || str.equals("1") || str.equalsIgnoreCase("true") || str.equalsIgnoreCase("\u662f") || str.equalsIgnoreCase("YES");
    }

    protected void checkDate(Context ctx, Date date, String field) throws TaskExternalException {
        if ("FBillDate".equalsIgnoreCase(field)) {
            if (date == null) {
                throw new TaskExternalException(OtherBillDataImport.getString("AR", "DateIsNull", ctx));
            }
        } else if ("FBizDate".equalsIgnoreCase(field) && date == null) {
            throw new TaskExternalException(OtherBillDataImport.getString("AR", "BizDateIsNull", ctx));
        }
    }

    protected void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected void checkFieldisNull(Context ctx, Hashtable hsData, String[] fields) throws TaskExternalException {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            String amount = ARAPImportHelper.getDataString(hsData, fields[i]);
            if (!StringUtils.isEmpty((String)amount)) continue;
            ARAPImportHelper.throwFieldNullMsg(ctx, hsData, fields[i]);
        }
    }

    public static AccountViewInfo getAccountViewInfo(Context ctx, Hashtable hsData, String field, String companyID, String currencyID) throws TaskExternalException, BOSException {
        AccountViewInfo info = null;
        try {
            String number = ARAPImportHelper.getDataString(hsData, field);
            if (number != null) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                if (companyID == null) {
                    company = ContextUtil.getCurrentFIUnit((Context)ctx);
                    companyID = company.getId().toString();
                } else {
                    company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyID));
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                view.setFilter(fi);
                AccountViewCollection collection = OtherBillDataImport.getAccountViewCollection(ctx, companyID, view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; !(i >= collection.size() || (info = collection.get(i)).getAccountTableID() != null && company.getAccountTable() != null && info.getAccountTableID().getId().toString().equals(company.getAccountTable().getId().toString())); ++i) {
                        if (i != collection.size() - 1) continue;
                        ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
                    }
                } else {
                    ARAPImportHelper.throwFieldErrorMsg(ctx, hsData, field);
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return info;
    }

    public static AccountViewCollection getAccountViewCollection(Context ctx, String companyId, EntityViewInfo viewInfo) throws BOSException, EASBizException {
        ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo comInfo = iCompany.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        String strCUId = comInfo.getId().toString();
        String acctTableId = null;
        if (comInfo.getAccountTable() != null) {
            acctTableId = comInfo.getAccountTable().getId().toString();
        }
        IAccountView iAccountView = AccountViewFactory.getLocalInstance((Context)ctx);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("companyID.id", (Object)strCUId));
        if (acctTableId != null) {
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("accountTableID", (Object)acctTableId));
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("accountTableId", (Object)acctTableId));
            evi.setFilter(fi);
            IAccountType iAccountType = AccountTypeFactory.getLocalInstance((Context)ctx);
            AccountTypeCollection atCol = iAccountType.getAccountTypeCollection(evi);
            if (atCol != null && atCol.size() > 0) {
                HashSet<String> acctTypeIdSet = new HashSet<String>();
                for (int i = 0; i < atCol.size(); ++i) {
                    AccountTypeInfo atInfo = atCol.get(i);
                    String acctTypeId = atInfo.getId().toString();
                    acctTypeIdSet.add(acctTypeId);
                }
                viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("accountTypeId", acctTypeIdSet, CompareType.INCLUDE));
            }
        }
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("accountCurrency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.id"));
        selector.add(new SelectorItemInfo("accountCurrency.currency.name"));
        selector.add(new SelectorItemInfo("accountingcurrency"));
        viewInfo.getSorter().add(new SorterItemInfo("number"));
        return iAccountView.getAccountViewCollection(viewInfo);
    }

    public int getSubmitType() {
        return 1;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        String filterStr = null;
        if (this.getContextMap().get("filter") != null) {
            filterStr = this.getContextMap().get("filter").toString();
        }
        if (this.getContextMap().get("filterItems") != null) {
            filterStr = this.getContextMap().get("filterItems").toString();
        }
        if (this.getContextMap().get("bizCommonQueryFilter") != null) {
            filterStr = this.getContextMap().get("bizCommonQueryFilter").toString();
        }
        if (!StringUtils.isEmpty((String)filterStr)) {
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                logger.error((Object)e.getMessage());
            }
        }
        return filter;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        boolean rs = true;
        if (firstData != null && currentData != null) {
            String[] mainFields = this.getMainFields();
            if (mainFields == null) {
                return false;
            }
            for (int i = 0; i < mainFields.length; ++i) {
                String mainField = mainFields[i];
                String firstMainField = StringUtil.cnulls(firstData.get(mainField));
                String currentMainField = StringUtil.cnulls(currentData.get(mainField));
                if (firstMainField.isEmpty() && currentMainField.isEmpty()) {
                    rs = false;
                    continue;
                }
                if (firstMainField.equals(currentMainField)) continue;
                rs = false;
            }
        } else {
            rs = false;
        }
        return rs;
    }

    public String[] getMainFields() {
        return new String[]{"FNumber", "FCompany_number"};
    }

    public static String getString(String SysType, String resName, Context ctx) {
        String AR_RESOURCE_PATH = "com.kingdee.eas.fi.ar.ARImportData";
        String AP_RESOURCE_PATH = "com.kingdee.eas.fi.ap.APImportData";
        String value = "";
        if (SysType.equals("AR")) {
            value = ResourceBase.getString((String)AR_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        } else if (SysType.equals("AP")) {
            value = ResourceBase.getString((String)AP_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        }
        if (SysType.equals("AP") && ("Missing Resource".equals(value) || NOT_MATCHED.equals(value))) {
            value = ResourceBase.getString((String)AR_RESOURCE_PATH, (String)resName, (Locale)ctx.getLocale());
        }
        return value;
    }

    protected void checkVerifyAmount(Context ctx, ArApBillBaseInfo otherBillInfo, ArApBillEntryBaseInfo entryInfo, CurrencyInfo currency, int scale) throws Exception, TaskExternalException {
        String exceptionMsg;
        ExchangeRateInfo exgRateInfo = null;
        int exgRatescale = scale;
        if (this.currentCompany != null && currency != null) {
            exgRateInfo = this.getExchangeRateInfoByCache(ctx, this.currentCompany, currency);
        }
        if (exgRateInfo != null) {
            exgRatescale = exgRateInfo.getPrecision();
            if (exgRateInfo.getExchangeAux() != null) {
                exgRatescale = exgRateInfo.getExchangeAux().getPrecision();
            }
        }
        if (!StringUtils.isEmpty((String)(exceptionMsg = ArApBillHelper.checkEntryAmountForInitBill(ctx, otherBillInfo, exgRatescale, exgRateInfo, entryInfo)))) {
            throw new TaskExternalException(exceptionMsg);
        }
    }
}

