/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.CompanyShutAccountInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.ShutAccountDetailInfo;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ArApShutAccountBizException;
import com.kingdee.eas.fi.arap.ShutAccount;
import com.kingdee.eas.fi.arap.app.AbstractShutAccountControllerBean;
import com.kingdee.eas.fi.arap.util.ArApMutextUtils;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.cas.validate.currency.IShutAccountBillCheck;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.util.PermissionUtil;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.Uuid;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ShutAccountControllerBean
extends AbstractShutAccountControllerBean {
    private static final BOSObjectType logObjectType = new ShutAccount().getType();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.ShutAccountControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _shutAccount(Context ctx, CompanyOrgUnitInfo companyInfo, Map param) throws BOSException, EASBizException {
        SystemEnum systemEnum = this.getSystemEnum();
        if (null == systemEnum) {
            return;
        }
        SystemStatusCtrolInfo controlInfo = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyInfo, systemEnum);
        if (null == controlInfo || null == controlInfo.getCurrentPeriod()) {
            throw new OtherBillBizException(OtherBillBizException.CURRENTPERIODISNULL, new Object[]{systemEnum});
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)logObjectType, null, (String)String.valueOf(controlInfo.getCurrentPeriod()), (String)this.getShutAccountLogItem(), (String)companyInfo.getId().toString());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Uuid mutexId = this.requireMutex(ctx, iMutex, companyInfo);
        try {
            this.checkShutAccount(ctx, companyInfo, controlInfo.getCurrentPeriod());
            ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            iSystemStatusCtrol.close(systemEnum, companyInfo, true);
        }
        finally {
            iMutex.releaseMutex(mutexId);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _unshutAccount(Context ctx, CompanyOrgUnitInfo companyInfo, Map param) throws BOSException, EASBizException {
        SystemEnum systemEnum = this.getSystemEnum();
        SystemStatusCtrolInfo controlInfo = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyInfo, systemEnum);
        if (null == controlInfo || null == controlInfo.getCurrentPeriod()) {
            throw new OtherBillBizException(OtherBillBizException.CURRENTPERIODISNULL, new Object[]{systemEnum});
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, null, (BOSObjectType)logObjectType, null, (String)String.valueOf(controlInfo.getCurrentPeriod()), (String)this.getUnshutAccountLogItem(), (String)companyInfo.getId().toString());
        IMutexServiceControl iMutex = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Uuid mutexId = this.requireMutex(ctx, iMutex, companyInfo);
        try {
            ISystemStatusCtrol iSystemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
            iSystemStatusCtrol.close(systemEnum, companyInfo, false);
        }
        finally {
            iMutex.releaseMutex(mutexId);
        }
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
    }

    @Override
    protected CompanyShutAccountInfo _getCompanyShutInfo(Context ctx, String userId, Set companyIds) throws BOSException, EASBizException {
        SystemEnum systemEnum = this.getSystemEnum();
        String permissonItem = this.getPermissionItem();
        HashSet unitIdSet = PermissionUtil.getAuthorizedOrgIDSetByType((Context)ctx, (IObjectPK)new ObjectUuidPK(userId), (String)permissonItem, (OrgViewType)OrgViewType.COMPANY);
        if (!companyIds.isEmpty()) {
            HashSet set = new HashSet();
            for (Object companyId : companyIds) {
                if (!unitIdSet.contains(companyId)) continue;
                set.add(companyId);
            }
            unitIdSet = set;
        }
        if (unitIdSet.isEmpty()) {
            return new CompanyShutAccountInfo();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select co.fname_l2 as companyOrgUnitName,co.fnumber as companyOrgUnitNumber,p.fnumber as period ,");
        sql.append(" sysStaCtr.FISCLOSEDACCOUNT as status ,'' as notes ,co.fid as companyID from T_BD_SystemStatusCtrol sysStaCtr inner join T_BD_SystemStatus sysSta ");
        sql.append(" on sysStaCtr.FSystemStatusID = sysSta.FID ");
        sql.append(" inner join T_Org_company co on sysStaCtr.FCompanyID = co.fid ");
        sql.append(" inner join T_bd_period p on sysStaCtr.FCURRENTPERIODID = p.fid ");
        sql.append(" inner join T_ORG_BaseUnit UNIT on co.fid = UNIT.fid");
        sql.append(" LEFT OUTER JOIN T_ORG_OUPartFI AS PARTFI ON UNIT.FPartFIID = PARTFI.FID");
        sql.append(" where PARTFI.FIsBizUnit = 1 and sysSta.FName= '");
        sql.append(systemEnum.getValue());
        sql.append("'  and sysStaCtr.FIsStart=1 and co.fid in (");
        ArrayList Temp = new ArrayList(unitIdSet);
        String companyID = CollectionUtil.convertList2String(Temp, (String)",", (boolean)true);
        sql.append(companyID);
        sql.append(")");
        IRowSet iRowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        CompanyShutAccountInfo shutInfo = new CompanyShutAccountInfo();
        ArrayList<ShutAccountDetailInfo> detailList = new ArrayList<ShutAccountDetailInfo>();
        shutInfo.setList(detailList);
        try {
            while (iRowSet.next()) {
                ShutAccountDetailInfo detail = new ShutAccountDetailInfo();
                detail.setCompanyId(iRowSet.getString("companyID"));
                detail.setCompanyName(iRowSet.getString("companyOrgUnitName"));
                detail.setCompanyNumber(iRowSet.getString("companyOrgUnitNumber"));
                detail.setPeriod(iRowSet.getString("period"));
                detail.setStatus(iRowSet.getBoolean("status"));
                detailList.add(detail);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return shutInfo;
    }

    private void checkShutAccount(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        SystemEnum systemEnum = this.getSystemEnum();
        IShutAccountBillCheck checker = this.getChecker(ctx);
        if (null == checker) {
            return;
        }
        if (null == currentPeriod) {
            throw new OtherBillBizException(OtherBillBizException.CURRENTPERIODISNULL, new Object[]{systemEnum});
        }
        checker.doCheck(companyInfo, currentPeriod);
        if (checker.hasError()) {
            throw new ArApShutAccountBizException(ArApShutAccountBizException.ILLEGAL_BILL_EXIST, new Object[]{checker.getErrorMsg()});
        }
    }

    @Override
    protected void _checkBeforeAddBill(Context ctx, CompanyOrgUnitInfo company, Date billDate) throws BOSException, EASBizException {
        if (company == null) {
            return;
        }
        SystemEnum systemEnum = this.getSystemEnum();
        ISystemStatusCtrol iSystemStatusControl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean isClosed = iSystemStatusControl.isClosed(this.getSystemEnum(), company);
        if (!isClosed) {
            return;
        }
        PeriodInfo currentPeriod = iSystemStatusControl.getCacheCurrentPeriod(systemEnum.getValue(), company.getId().toString());
        Timestamp endDate = currentPeriod.getEndDate();
        endDate.setHours(23);
        endDate.setMinutes(59);
        endDate.setSeconds(59);
        if (billDate != null && endDate.after(billDate)) {
            throw new ArApShutAccountBizException(ArApShutAccountBizException.SYSTEM_SHUT_BILL_ADD_FORBIDDEN, new Object[]{company.getName(), systemEnum});
        }
    }

    @Override
    protected void _checkBeforeBizProcess(Context ctx, CompanyOrgUnitInfo company, Date billDate) throws BOSException, EASBizException {
        SystemEnum systemEnum = this.getSystemEnum();
        ISystemStatusCtrol iSystemStatusControl = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        boolean isClosed = iSystemStatusControl.isClosed(this.getSystemEnum(), company);
        if (!isClosed) {
            return;
        }
        PeriodInfo currentPeriod = iSystemStatusControl.getCacheCurrentPeriod(systemEnum.getValue(), company.getId().toString());
        Timestamp endDate = currentPeriod.getEndDate();
        endDate.setHours(23);
        endDate.setMinutes(59);
        endDate.setSeconds(59);
        if (endDate.after(billDate)) {
            throw new ArApShutAccountBizException(ArApShutAccountBizException.SYSTEM_SHUT_BIZ_PROCESS_FORBIDDEN, new Object[]{systemEnum, company.getName()});
        }
    }

    protected IShutAccountBillCheck getChecker(Context ctx) {
        return null;
    }

    protected String getShutAccountLogItem() {
        return null;
    }

    protected String getUnshutAccountLogItem() {
        return null;
    }

    protected SystemEnum getSystemEnum() {
        return null;
    }

    protected String getPermissionItem() {
        return null;
    }

    protected String getMutexName() {
        return null;
    }

    private Uuid requireMutex(Context ctx, IMutexServiceControl iMutex, CompanyOrgUnitInfo companyInfo) throws EASBizException {
        String mutexName;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Uuid mutexID = Uuid.create();
        MutexParameter mp = ArApMutextUtils.getMutexParameter(ctx, mutexID, mutexName = this.getMutexName(), mutexName, MutexLockType.EXCLUSIVE_LOCK, companyInfo.getId(), userInfo.getId(), ctx.getAIS());
        boolean isLocked = iMutex.requestMutex(mp);
        if (!isLocked) {
            throw new ArApShutAccountBizException(ArApShutAccountBizException.MUTEX_EXIST);
        }
        return mutexID;
    }
}

