/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceHelper;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.SrcBillAutoInvHelper;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class SrcBillAutoInvGeneraor {
    public abstract String getSrcBOSType();

    public abstract String getDestBOSType();

    public boolean hasVatBot(Context ctx) throws BOSException, EASBizException {
        String destBosType;
        String srcBosType = this.getSrcBOSType();
        IObjectCollection mappings = BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBosType, (String)(destBosType = this.getDestBOSType()), new HashMap());
        if (mappings == null || mappings.size() == 0) {
            return false;
        }
        IBOTMapping iMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        String selectCls = "select rules.ruleSegments.destPropertyName, rules.ruleSegments.expression where id = '";
        BOTMappingInfo mappingInfo2 = null;
        for (BOTMappingInfo mappingInfo2 : mappings) {
            mappingInfo2 = iMapping.getBOTMappingInfo(selectCls + mappingInfo2.getId() + "'");
            if (!InvoiceHelper.isVATMapping(mappingInfo2)) continue;
            return true;
        }
        return false;
    }

    public boolean isBotShowUI(Context ctx, String mappingId) throws BOSException, EASBizException {
        IBOTMapping iMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        BOTMappingInfo mappingInfo = iMapping.getBOTMappingInfo("select id, isShowEditUI where id = '" + mappingId + "' ");
        if (mappingInfo != null) {
            return mappingInfo.getIsShowEditUI() == 1;
        }
        return false;
    }

    public String getWFBotMappingId(Context ctx) throws BOSException, EASBizException {
        BOTMappingInfo mappingInfo = (BOTMappingInfo)this.getBotMapping(ctx, true, null);
        return mappingInfo.getId().toString();
    }

    public IObjectValue getBotMapping(Context ctx, boolean fWF, InvoiceTypeEnum typeEnum) throws BOSException, EASBizException {
        String destBosType;
        String srcBosType = this.getSrcBOSType();
        IObjectCollection mappings = BOTMappingHelper.getMappingForSelect((Context)ctx, (String)srcBosType, (String)(destBosType = this.getDestBOSType()), new HashMap());
        if (mappings == null || mappings.size() == 0) {
            throw new BOTPException(BOTPException.NOMAPPING);
        }
        if (typeEnum == null && mappings.size() > 1) {
            throw new InvoiceException(InvoiceException.MANY_BOTMAPPINGS);
        }
        if (typeEnum == null && mappings.size() == 1) {
            return mappings.getObject(0);
        }
        IBOTMapping iMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
        String selectCls = "select rules.ruleSegments.destPropertyName, rules.ruleSegments.expression where id = '";
        int typeRuleCount = 0;
        BOTMappingInfo typeMappingInfo = null;
        for (BOTMappingInfo mappingInfo : mappings) {
            BOTMappingInfo mapRulesInfo = iMapping.getBOTMappingInfo(selectCls + mappingInfo.getId() + "'");
            boolean fVatRule = InvoiceHelper.isVATMapping(mapRulesInfo);
            if ((!InvoiceTypeEnum.VAT.equals((Object)typeEnum) || !fVatRule) && (!InvoiceTypeEnum.GENERAL.equals((Object)typeEnum) || fVatRule)) continue;
            if (fWF) {
                return mappingInfo;
            }
            typeMappingInfo = mappingInfo;
            if (typeRuleCount + 1 > 1) {
                throw new InvoiceException(InvoiceException.MANY_BOTMAPPINGS);
            }
            ++typeRuleCount;
        }
        if (typeRuleCount == 0) {
            throw new BOTPException(BOTPException.NOMAPPING);
        }
        return typeMappingInfo;
    }

    public String transVatFromSrcBill(Context ctx, BOSUuid srcBillId, String mappingId) throws BOSException, EASBizException {
        ArrayList<BOSUuid> ids = new ArrayList<BOSUuid>();
        ids.add(srcBillId);
        BTPTransformResult btpResult = this.transVatFromSrcBills(ctx, ids, BOSUuid.read((String)mappingId));
        IObjectCollection destBills = btpResult.getBills();
        if (destBills == null || destBills.size() == 0) {
            return null;
        }
        return destBills.getObject(0).getString("id");
    }

    public BTPTransformResult transVatFromSrcBills(Context ctx, List srcBillIds, BOSUuid mappingId) throws BOSException, EASBizException {
        BOSObjectType srcType = BOSObjectType.create((String)this.getSrcBOSType());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet idSet = new HashSet(srcBillIds);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IDynamicObject iDyn = DynamicObjectFactory.getLocalInstance((Context)ctx);
        IObjectCollection bills = iDyn.getCollection(srcType, view);
        CoreBillBaseCollection srcBills = new CoreBillBaseCollection();
        srcBills.addObjectCollection(bills);
        ObjectUuidPK mappingPK = new ObjectUuidPK(mappingId);
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        BTPTransformResult btpResult = iBTPManager.transformForBotp(srcBills, this.getDestBOSType(), (IObjectPK)mappingPK);
        BOTRelationCollection botRelationCols = btpResult.getBOTRelationCollection();
        IObjectCollection destBillCols = btpResult.getBills();
        if (destBillCols != null && destBillCols.size() > 0) {
            int count = destBillCols.size();
            for (int i = 0; i < count; ++i) {
                InvoiceInfo destBillInfo = (InvoiceInfo)destBillCols.getObject(i);
                SrcBillAutoInvHelper.setInvoiceInfoFields(ctx, destBillInfo);
                iBTPManager.saveRelations((CoreBillBaseInfo)destBillInfo, botRelationCols);
            }
        }
        return btpResult;
    }
}

