/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.VerificationEnum;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.VerificationBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.ar.VerificationBillentryInfo;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.IVerificationBillBase;
import com.kingdee.eas.fi.arap.VerificationBillBaseEntryInfo;
import com.kingdee.eas.fi.arap.VerificationBillBaseInfo;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.Helper;
import com.kingdee.eas.fi.cas.IPaymentBillType;
import com.kingdee.eas.fi.cas.IReceivingBillType;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.app.intf.impl.DefaultBillNumberImpl;
import com.kingdee.eas.scm.framework.util.DBParamUtil;
import com.kingdee.eas.scm.framework.writeoff.AbstractWriteOffStrategy;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VerificationStrategy
extends AbstractWriteOffStrategy {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.framework.writeoff");
    IPaymentBillType ipayType = null;
    IReceivingBillType irecType = null;
    private Map<String, IObjectValue> acctActMap = null;
    private Map<String, PaymentBillTypeInfo> payTypeMap = new HashMap<String, PaymentBillTypeInfo>();
    private Map<String, ReceivingBillTypeInfo> recTypeMap = new HashMap<String, ReceivingBillTypeInfo>();
    private Map<String, PeriodInfo> periodMap = new HashMap<String, PeriodInfo>();
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");

    public List buildWriteOffBillInfo(Context ctx, Map mainMap, Map secMap, MappingConditionEntryInfo conditionEntryInfo, WriteOffCommonParams params) throws BOSException, EASBizException {
        Iterator<Object> it;
        params.put((Object)"exRateMap", new HashMap());
        CoreBaseCollection billColl = new CoreBaseCollection();
        VerificationBillBaseInfo billInfo = null;
        if (params.get((Object)"isBillInnerVerify") != null && Boolean.TRUE.equals(params.get((Object)"isBillInnerVerify"))) {
            CoreBaseCollection innerBillColl;
            it = mainMap.values().iterator();
            while (it.hasNext()) {
                innerBillColl = this.buildInnerSameSideBillInfo(ctx, (List)it.next(), params);
                if (innerBillColl == null || innerBillColl.size() <= 0) continue;
                billColl.addCollection(innerBillColl);
            }
            it = secMap.values().iterator();
            while (it.hasNext()) {
                innerBillColl = this.buildInnerSameSideBillInfo(ctx, (List)it.next(), params);
                if (innerBillColl == null || innerBillColl.size() <= 0) continue;
                billColl.addCollection(innerBillColl);
            }
        } else if (this.isManualVerify(String.valueOf(conditionEntryInfo.getId()))) {
            if (!params.isFlowWriteOff()) {
                for (Object key : mainMap.keySet()) {
                    billInfo = null;
                    if (mainMap.get(key) != null || secMap.get(key) != null) {
                        billInfo = this.buildManualBillInfo(ctx, (List)mainMap.get(key), (List)secMap.get(key), params);
                    }
                    if (billInfo == null) continue;
                    billColl.add((CoreBaseInfo)billInfo);
                }
            }
        } else {
            if (params.isSameSideFirst()) {
                it = mainMap.values().iterator();
                while (it.hasNext()) {
                    billInfo = this.buildSameSideBillInfo(ctx, (List)it.next(), params);
                    if (billInfo == null) continue;
                    billColl.add((CoreBaseInfo)billInfo);
                }
                it = secMap.values().iterator();
                while (it.hasNext()) {
                    billInfo = this.buildSameSideBillInfo(ctx, (List)it.next(), params);
                    if (billInfo == null) continue;
                    billColl.add((CoreBaseInfo)billInfo);
                }
            }
            ArrayList<VerificationBillBaseEntryInfo> mainPositive = new ArrayList<VerificationBillBaseEntryInfo>();
            ArrayList<VerificationBillBaseEntryInfo> mainNegative = new ArrayList<VerificationBillBaseEntryInfo>();
            ArrayList<VerificationBillBaseEntryInfo> secPositive = new ArrayList<VerificationBillBaseEntryInfo>();
            ArrayList<VerificationBillBaseEntryInfo> secNegative = new ArrayList<VerificationBillBaseEntryInfo>();
            VerificationBillBaseEntryInfo entryInfo2 = null;
            Map.Entry me2 = null;
            for (Map.Entry me2 : mainMap.entrySet()) {
                if (!secMap.containsKey(me2.getKey())) continue;
                mainPositive.clear();
                mainNegative.clear();
                secPositive.clear();
                secNegative.clear();
                for (VerificationBillBaseEntryInfo entryInfo2 : (List)me2.getValue()) {
                    if (entryInfo2.getThisVerificateAmt().signum() > 0) {
                        mainPositive.add(entryInfo2);
                        continue;
                    }
                    mainNegative.add(entryInfo2);
                }
                for (VerificationBillBaseEntryInfo entryInfo2 : (List)secMap.get(me2.getKey())) {
                    if (entryInfo2.getThisVerificateAmt().signum() > 0) {
                        secPositive.add(entryInfo2);
                        continue;
                    }
                    secNegative.add(entryInfo2);
                }
                billInfo = this.buildTwoSideBillInfo(ctx, mainPositive, secPositive, conditionEntryInfo, params);
                if (billInfo != null) {
                    billColl.add((CoreBaseInfo)billInfo);
                }
                if ((billInfo = this.buildTwoSideBillInfo(ctx, mainNegative, secNegative, conditionEntryInfo, params)) == null) continue;
                billColl.add((CoreBaseInfo)billInfo);
            }
        }
        ArrayList result = new ArrayList();
        if (billColl.size() > 0) {
            CoreBaseCollection ssBillColl = new CoreBaseCollection();
            IObjectCollection entryColl = null;
            VerificationBillBaseEntryInfo entryInfo = null;
            VerificationBillBaseEntryInfo entryInfo2 = null;
            Iterator it2 = billColl.iterator();
            while (it2.hasNext()) {
                billInfo = (VerificationBillBaseInfo)it2.next();
                entryColl = (IObjectCollection)billInfo.get("entrys");
                entryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject(0);
                entryInfo2 = (VerificationBillBaseEntryInfo)entryColl.getObject(1);
                if (!entryInfo.isVeriType()) continue;
                if (!entryInfo.getAcctCussID().equals((Object)entryInfo2.getAcctCussID())) {
                    return result;
                }
                if (billInfo instanceof VerificationBillInfo) {
                    billInfo.setVerificationType(VerificationEnum.AR_Rec);
                    if (!VerificateBillTypeEnum.OtherPaymentBill.equals((Object)entryInfo.getBillType()) && !VerificateBillTypeEnum.PaymentBill.equals((Object)entryInfo.getBillType())) continue;
                    ssBillColl.add((CoreBaseInfo)this.changeBillInfo(ctx, billInfo));
                    it2.remove();
                    continue;
                }
                if (!(billInfo instanceof com.kingdee.eas.fi.ap.VerificationBillInfo)) continue;
                billInfo.setVerificationType(VerificationEnum.AP_Pay);
                if (!VerificateBillTypeEnum.OtherReceiveBill.equals((Object)entryInfo.getBillType()) && !VerificateBillTypeEnum.ReceiveBill.equals((Object)entryInfo.getBillType())) continue;
                ssBillColl.add((CoreBaseInfo)this.changeBillInfo(ctx, billInfo));
                it2.remove();
            }
            IVerificationBillBase iBill = null;
            PeriodInfo curPeriodInfo = null;
            if (this.isAr(params)) {
                if (billColl.size() > 0) {
                    iBill = VerificationBillFactory.getLocalInstance(ctx);
                    curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
                    this.submit(ctx, billColl, iBill, curPeriodInfo, result, params);
                }
                if (ssBillColl.size() > 0) {
                    iBill = com.kingdee.eas.fi.ap.VerificationBillFactory.getLocalInstance(ctx);
                    curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
                    this.submit(ctx, ssBillColl, iBill, curPeriodInfo, result, params);
                }
            } else {
                if (billColl.size() > 0) {
                    iBill = com.kingdee.eas.fi.ap.VerificationBillFactory.getLocalInstance(ctx);
                    curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
                    this.submit(ctx, billColl, iBill, curPeriodInfo, result, params);
                }
                if (ssBillColl.size() > 0) {
                    iBill = VerificationBillFactory.getLocalInstance(ctx);
                    curPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
                    this.submit(ctx, ssBillColl, iBill, curPeriodInfo, result, params);
                }
            }
        }
        return result;
    }

    protected VerificationBillBaseInfo changeBillInfo(Context ctx, VerificationBillBaseInfo billInfo) throws BOSException {
        VerificationBillBaseInfo resultInfo = null;
        boolean isChangeAP = false;
        if (billInfo instanceof VerificationBillInfo) {
            resultInfo = new com.kingdee.eas.fi.ap.VerificationBillInfo();
            isChangeAP = true;
        } else {
            resultInfo = new VerificationBillInfo();
        }
        resultInfo.setCU(billInfo.getCU());
        resultInfo.setCompany(billInfo.getCompany());
        resultInfo.setMainAcctCussID(billInfo.getMainAcctCussID());
        resultInfo.setMainAcctCussName(billInfo.getMainAcctCussName());
        resultInfo.setMainAcctCussType(billInfo.getMainAcctCussType());
        resultInfo.setMainBillType(billInfo.getMainBillType());
        resultInfo.setMainCurrency(billInfo.getMainCurrency());
        resultInfo.setSecondAcctCussID(billInfo.getSecondAcctCussID());
        resultInfo.setSecondAcctCussName(billInfo.getSecondAcctCussName());
        resultInfo.setSecondAcctCussType(billInfo.getSecondAcctCussType());
        resultInfo.setSecondBillType(billInfo.getSecondBillType());
        resultInfo.setSecondCurrency(billInfo.getSecondCurrency());
        resultInfo.setIsSameCurrency(billInfo.isIsSameCurrency());
        resultInfo.setIsSameCode(billInfo.isIsSameCode());
        resultInfo.setVerificationType(isChangeAP ? VerificationEnum.AP_Pay : VerificationEnum.AR_Rec);
        resultInfo.setCreator(billInfo.getCreator());
        resultInfo.setCreateTime(billInfo.getCreateTime());
        resultInfo.setIsCashSalePur(billInfo.isIsCashSalePur());
        resultInfo.setMainThisVerificateAmt(billInfo.getMainThisVerificateAmt());
        resultInfo.setMainThisVerificateAmtLoc(billInfo.getMainThisVerificateAmtLoc());
        resultInfo.setSecondThisVerificateAmt(billInfo.getSecondThisVerificateAmt());
        resultInfo.setSecondThisVerificateAmtLoc(billInfo.getSecondThisVerificateAmtLoc());
        resultInfo.setGainAndLoss(billInfo.getGainAndLoss());
        IObjectCollection entryColl = (IObjectCollection)billInfo.get("entrys");
        IObjectCollection resultEntryColl = (IObjectCollection)resultInfo.get("entrys");
        VerificationBillBaseEntryInfo entryInfo = null;
        VerificationBillBaseEntryInfo resultEntryInfo = null;
        int size = entryColl.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject(i);
            resultEntryInfo = isChangeAP ? new com.kingdee.eas.fi.ap.VerificationBillentryInfo() : new VerificationBillentryInfo();
            resultEntryInfo.setBillType(entryInfo.getBillType());
            resultEntryInfo.setBillSubType(entryInfo.getBillSubType());
            resultEntryInfo.setBillID(entryInfo.getBillID());
            resultEntryInfo.setEntryID(entryInfo.getEntryID());
            resultEntryInfo.setBillDate(entryInfo.getBillDate());
            resultEntryInfo.setBillNumber(entryInfo.getBillNumber());
            resultEntryInfo.setAcctCussID(entryInfo.getAcctCussID());
            resultEntryInfo.setComment(entryInfo.getComment());
            resultEntryInfo.setThisVerificateAmt(entryInfo.getThisVerificateAmt());
            resultEntryInfo.setThisVerificateAmtLoc(entryInfo.getThisVerificateAmtLoc());
            resultEntryInfo.setGainAndLoss(entryInfo.getGainAndLoss());
            resultEntryInfo.setMaterialName(entryInfo.getMaterialName());
            resultEntryInfo.setMaterialNumber(entryInfo.getMaterialNumber());
            resultEntryInfo.setMaterialId(entryInfo.getMaterialId());
            resultEntryInfo.setAcctCussType(entryInfo.getAcctCussType());
            resultEntryInfo.setCurrency(entryInfo.getCurrency());
            resultEntryInfo.setAccount(entryInfo.getAccount());
            resultEntryInfo.setAdminOrgUnit(entryInfo.getAdminOrgUnit());
            resultEntryInfo.setPerson(entryInfo.getPerson());
            resultEntryInfo.setOppAccount(entryInfo.getOppAccount());
            resultEntryInfo.setVeriType(entryInfo.isVeriType());
            resultEntryInfo.setVeriRecPayTypeName(entryInfo.getVeriRecPayTypeName());
            resultEntryInfo.setVeriRecPayTypeNumber(entryInfo.getVeriRecPayTypeNumber());
            resultEntryInfo.setVeriRecPayTypeId(entryInfo.getVeriRecPayTypeId());
            resultEntryInfo.setIsFromBOTP(entryInfo.isIsFromBOTP());
            resultEntryColl.addObject((IObjectValue)resultEntryInfo);
        }
        return resultInfo;
    }

    protected void submit(Context ctx, CoreBaseCollection billColl, IVerificationBillBase iBill, PeriodInfo curPeriodInfo, List result, WriteOffCommonParams params) throws BOSException, EASBizException {
        boolean isCloseCodeRule = false;
        ICodingRuleManager iCodingRule = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        VerificationBillBaseInfo billInfo = null;
        IObjectCollection entryColl = null;
        Date maxDate = null;
        String[] numberArr = null;
        try {
            BOSUuid asstActId;
            int j;
            int k;
            int i;
            int size = billColl.size();
            if (size > 0) {
                DefaultBillNumberImpl numberImpl = new DefaultBillNumberImpl();
                isCloseCodeRule = numberImpl.isCloseCodeRule(ctx);
                billInfo = (VerificationBillBaseInfo)billColl.getObject(0);
                numberArr = numberImpl.getBatchNumber(ctx, (IObjectValue)billInfo, params.getCompanyId(), size, SystemEnum.ACCOUNTSRECEIVABLE);
            }
            if (null == numberArr || numberArr.length == 0 || numberArr.length != size) {
                StringBuilder buf = new StringBuilder(150);
                buf.append("getBatchNumber for [").append(size).append("] bills, but only get [").append(null == numberArr ? 0 : numberArr.length).append("] billNumbers, Please check! ");
                throw new IllegalArgumentException(buf.toString());
            }
            VerificationBillBaseEntryInfo entry = null;
            HashSet<String> asstActIds = new HashSet<String>(size);
            for (i = 0; i < size; ++i) {
                billInfo = (VerificationBillBaseInfo)billColl.getObject(i);
                entryColl = (IObjectCollection)billInfo.get("entrys");
                k = entryColl.size();
                for (j = 0; j < k; ++j) {
                    entry = (VerificationBillBaseEntryInfo)entryColl.getObject(j);
                    asstActId = entry.getAcctCussID();
                    if (null == asstActId) continue;
                    asstActIds.add(asstActId.toString());
                }
            }
            if (null != this.acctActMap) {
                asstActIds.removeAll(this.acctActMap.keySet());
                this.acctActMap.putAll(ArApBillUtil.batchGetAsstAct(ctx, asstActIds));
            } else {
                this.acctActMap = ArApBillUtil.batchGetAsstAct(ctx, asstActIds);
            }
            for (i = 0; i < size; ++i) {
                billInfo = (VerificationBillBaseInfo)billColl.getObject(i);
                billInfo.setNumber(numberArr[i]);
                entryColl = (IObjectCollection)billInfo.get("entrys");
                k = entryColl.size();
                for (j = 0; j < k; ++j) {
                    entry = (VerificationBillBaseEntryInfo)entryColl.getObject(j);
                    entry.setId(null);
                    if (maxDate == null || maxDate.compareTo(entry.getBillDate()) < 0) {
                        maxDate = entry.getBillDate();
                    }
                    if (null == (asstActId = entry.getAcctCussID()) || null == this.acctActMap) continue;
                    ArApBillUtil.setAsstActNameMultiLang(ctx, this.acctActMap.get(asstActId.toString()), entry);
                }
                billInfo.setBizDate(ArApBillHelper.getVerifiedDate(maxDate, curPeriodInfo));
                if (params.getBizDate() != null && params.getBizDate().compareTo(maxDate) >= 0) {
                    billInfo.setBizDate(params.getBizDate());
                }
                this.checkArApSysPeriodByDate(ctx, billInfo.getBizDate(), billInfo.getCompany(), params, curPeriodInfo);
            }
            if (null != this.acctActMap) {
                this.acctActMap.clear();
            }
            IObjectPK[] pks = iBill.submitBatchData(billColl);
            result.addAll(Arrays.asList(pks));
        }
        catch (Exception e) {
            if (!isCloseCodeRule) {
                int size = billColl.size();
                for (int i = 0; i < size; ++i) {
                    billInfo = (VerificationBillBaseInfo)billColl.getObject(i);
                    if (billInfo.getNumber() == null || "".equals(billInfo.getNumber())) continue;
                    iCodingRule.recycleNumberReqNew((IObjectValue)billInfo, params.getCompanyId(), null, null, billInfo.getNumber(), null);
                }
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)((Object)e);
            }
            throw new BOSException((Throwable)e);
        }
    }

    protected VerificationBillBaseInfo buildManualBillInfo(Context ctx, List mainList, List secList, WriteOffCommonParams params) throws BOSException, EASBizException {
        VerificationBillBaseInfo billInfo = null;
        billInfo = this.isAr(params) ? new VerificationBillInfo() : new com.kingdee.eas.fi.ap.VerificationBillInfo();
        IObjectCollection entryColl = (IObjectCollection)billInfo.get("entrys");
        VerificationBillBaseEntryInfo mainEntryInfo2 = null;
        VerificationBillBaseEntryInfo secEntryInfo2 = null;
        if (mainList != null) {
            for (VerificationBillBaseEntryInfo mainEntryInfo2 : mainList) {
                entryColl.addObject((IObjectValue)mainEntryInfo2);
            }
        }
        if (secList != null) {
            for (VerificationBillBaseEntryInfo secEntryInfo2 : secList) {
                entryColl.addObject((IObjectValue)secEntryInfo2);
            }
        }
        if (entryColl.size() > 1) {
            this.setBillInfo(ctx, billInfo, mainEntryInfo2 == null ? secEntryInfo2 : mainEntryInfo2, secEntryInfo2 == null ? mainEntryInfo2 : secEntryInfo2, params, mainList == null || mainList.size() == 0 || secList == null || secList.size() == 0);
            return billInfo;
        }
        return null;
    }

    protected boolean isManualVerify(String entryId) {
        if (entryId == null) {
            return false;
        }
        String[] mappingId = new String[]{ArApConstants.AP2AR_MANUAL_ID, ArApConstants.AP2PAY_MANUAL_ID, ArApConstants.PREPAY2PREREC_MANUAL_ID, ArApConstants.PROPAY2PROREC_MANUAL_ID, ArApConstants.AR2AP_MANUAL_ID, ArApConstants.AR2REC_MANUAL_ID, ArApConstants.PREREC2PREPAY_MANUAL_ID, ArApConstants.PROREC2PROPAY_MANUAL_ID};
        int len = mappingId.length;
        for (int i = 0; i < len; ++i) {
            if (!entryId.equals(mappingId[i])) continue;
            return true;
        }
        return false;
    }

    protected VerificationBillBaseInfo buildTwoSideBillInfo(Context ctx, List mainList, List secList, MappingConditionEntryInfo conditionEntryInfo, WriteOffCommonParams params) throws BOSException, EASBizException {
        if (!conditionEntryInfo.isIsMappingQtyAmt()) {
            BigDecimal mainAmt = SysConstant.BIGZERO;
            Iterator it = mainList.iterator();
            while (it.hasNext()) {
                mainAmt = mainAmt.add(((VerificationBillBaseEntryInfo)it.next()).getThisVerificateAmt());
            }
            BigDecimal secAmt = SysConstant.BIGZERO;
            Iterator it2 = secList.iterator();
            while (it2.hasNext()) {
                secAmt = secAmt.add(((VerificationBillBaseEntryInfo)it2.next()).getThisVerificateAmt());
            }
            if (mainAmt.compareTo(secAmt) != 0) {
                return null;
            }
        }
        VerificationBillBaseInfo billInfo = null;
        billInfo = this.isAr(params) ? new VerificationBillInfo() : new com.kingdee.eas.fi.ap.VerificationBillInfo();
        IObjectCollection entryColl = (IObjectCollection)billInfo.get("entrys");
        VerificationBillBaseEntryInfo mainEntryInfo2 = null;
        VerificationBillBaseEntryInfo secEntryInfo = null;
        ArrayList removeItem = new ArrayList();
        for (VerificationBillBaseEntryInfo mainEntryInfo2 : mainList) {
            removeItem.clear();
            int size = secList.size();
            for (int i = 0; i < size; ++i) {
                secEntryInfo = (VerificationBillBaseEntryInfo)secList.get(i);
                if ((!params.isFlowWriteOff() || mainEntryInfo2.getBillID().toString().equals(params.getFlowWfBillId()) || secEntryInfo.getBillID().toString().equals(params.getFlowWfBillId())) && this.addEntryInfo(ctx, entryColl, mainEntryInfo2, secEntryInfo, removeItem, false, params)) break;
            }
            if (removeItem.size() > 0) {
                secList.removeAll(removeItem);
            }
            if (secList.size() != 0) continue;
        }
        if (entryColl.size() > 0) {
            this.setBillInfo(ctx, billInfo, mainEntryInfo2, secEntryInfo, params, false);
            return billInfo;
        }
        return null;
    }

    protected void setBillInfo(Context ctx, VerificationBillBaseInfo billInfo, VerificationBillBaseEntryInfo mainEntryInfo, VerificationBillBaseEntryInfo secEntryInfo, WriteOffCommonParams params, boolean isSameSide) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
        company.setId(BOSUuid.read((String)params.getCompanyId()));
        billInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        billInfo.setCompany(company);
        billInfo.setMainBillType(mainEntryInfo.getBillType());
        billInfo.setSecondBillType(secEntryInfo.getBillType());
        billInfo.setIsSameCode(mainEntryInfo.getAcctCussID().equals((Object)secEntryInfo.getAcctCussID()));
        billInfo.setVerificationType((VerificationEnum)params.get((Object)"veriType"));
        this.setVerificationType(billInfo, params, isSameSide);
        billInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setCreateTime(new Timestamp(Calendar.getInstance().getTimeInMillis()));
        billInfo.setIsCashSalePur("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(mainEntryInfo.getString("paymentTypeId")) || "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5".equals(mainEntryInfo.getString("paymentTypeId")));
        this.setGainAndLoss(billInfo, isSameSide);
    }

    protected void setVerificationType(VerificationBillBaseInfo billInfo, WriteOffCommonParams params, boolean isSameSide) {
        VerificationBillBaseEntryInfo entryInfo2 = null;
        HashSet<String> mainAcctCussSet = new HashSet<String>();
        HashSet<String> secAcctCussSet = new HashSet<String>();
        BOSUuid mainAcctCussID = null;
        BOSUuid secAcctCussID = null;
        String mainAcctCussName = null;
        String secAcctCussName = null;
        AsstActTypeInfo mainAcctCussType = null;
        AsstActTypeInfo secAcctCussType = null;
        CurrencyInfo mainCurrency = null;
        CurrencyInfo secCurrency = null;
        for (VerificationBillBaseEntryInfo entryInfo2 : (IObjectCollection)billInfo.get("entrys")) {
            if (isSameSide) {
                entryInfo2.setVeriType(true);
                if (entryInfo2.getThisVerificateAmt().signum() > 0) {
                    mainAcctCussSet.add(entryInfo2.getAcctCussID().toString());
                    mainAcctCussID = entryInfo2.getAcctCussID();
                    mainAcctCussName = entryInfo2.getAcctCussName();
                    mainAcctCussType = entryInfo2.getAcctCussType();
                    mainCurrency = entryInfo2.getCurrency();
                    continue;
                }
                secAcctCussSet.add(entryInfo2.getAcctCussID().toString());
                secAcctCussID = entryInfo2.getAcctCussID();
                secAcctCussName = entryInfo2.getAcctCussName();
                secAcctCussType = entryInfo2.getAcctCussType();
                secCurrency = entryInfo2.getCurrency();
                continue;
            }
            if (entryInfo2.getBillType().equals((Object)billInfo.getMainBillType())) {
                mainAcctCussSet.add(entryInfo2.getAcctCussID().toString());
                mainAcctCussID = entryInfo2.getAcctCussID();
                mainAcctCussName = entryInfo2.getAcctCussName();
                mainAcctCussType = entryInfo2.getAcctCussType();
                mainCurrency = entryInfo2.getCurrency();
                continue;
            }
            secAcctCussSet.add(entryInfo2.getAcctCussID().toString());
            secAcctCussID = entryInfo2.getAcctCussID();
            secAcctCussName = entryInfo2.getAcctCussName();
            secAcctCussType = entryInfo2.getAcctCussType();
            secCurrency = entryInfo2.getCurrency();
        }
        if (mainAcctCussSet.size() != secAcctCussSet.size()) {
            billInfo.setVerificationType((VerificationEnum)params.get((Object)"veriTypeAB"));
        } else {
            for (String acct : mainAcctCussSet) {
                if (secAcctCussSet.contains(acct)) continue;
                billInfo.setVerificationType((VerificationEnum)params.get((Object)"veriTypeAB"));
                break;
            }
        }
        billInfo.setMainAcctCussType(mainAcctCussType);
        billInfo.setMainAcctCussID(mainAcctCussID);
        billInfo.setMainAcctCussName(mainAcctCussName);
        billInfo.setMainCurrency(mainCurrency);
        billInfo.setSecondAcctCussType(secAcctCussType);
        billInfo.setSecondAcctCussID(secAcctCussID);
        billInfo.setSecondAcctCussName(secAcctCussName);
        billInfo.setSecondCurrency(secCurrency);
        billInfo.setIsSameCurrency(ArApBillHelper.idEquals((CoreBaseInfo)mainCurrency, (CoreBaseInfo)secCurrency));
    }

    protected boolean addEntryInfo(Context ctx, IObjectCollection entryColl, VerificationBillBaseEntryInfo mainEntryInfo, VerificationBillBaseEntryInfo secEntryInfo, List removeItem, boolean isSameSide, WriteOffCommonParams params) throws BOSException, EASBizException {
        Map exRateMap = (Map)params.get((Object)"exRateMap");
        VerificationBillBaseEntryInfo tempEntryInfo = null;
        Boolean isDiffCurrency = !mainEntryInfo.getCurrency().getId().toString().equals(secEntryInfo.getCurrency().getId().toString());
        if (isDiffCurrency.booleanValue()) {
            if (!entryColl.containsKey((Object)mainEntryInfo.getId())) {
                if (isSameSide) {
                    mainEntryInfo.setVeriType(true);
                }
                entryColl.addObject((IObjectValue)mainEntryInfo);
            }
            if (!entryColl.containsKey((Object)secEntryInfo.getId())) {
                if (isSameSide) {
                    secEntryInfo.setVeriType(true);
                }
                entryColl.addObject((IObjectValue)secEntryInfo);
            }
            return true;
        }
        if (mainEntryInfo.getThisVerificateAmt().abs().compareTo(secEntryInfo.getThisVerificateAmt().abs()) == 0) {
            if (entryColl.containsKey((Object)mainEntryInfo.getId())) {
                tempEntryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject((Object)mainEntryInfo.getId());
                tempEntryInfo.setThisVerificateAmt(tempEntryInfo.getThisVerificateAmt().add(mainEntryInfo.getThisVerificateAmt()));
                tempEntryInfo.setThisVerificateAmtLoc(tempEntryInfo.getThisVerificateAmtLoc().add(mainEntryInfo.getThisVerificateAmtLoc()));
            } else {
                if (isSameSide) {
                    mainEntryInfo.setVeriType(true);
                }
                entryColl.addObject((IObjectValue)mainEntryInfo);
            }
            if (entryColl.containsKey((Object)secEntryInfo.getId())) {
                tempEntryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject((Object)secEntryInfo.getId());
                tempEntryInfo.setThisVerificateAmt(tempEntryInfo.getThisVerificateAmt().add(secEntryInfo.getThisVerificateAmt()));
                tempEntryInfo.setThisVerificateAmtLoc(tempEntryInfo.getThisVerificateAmtLoc().add(secEntryInfo.getThisVerificateAmtLoc()));
            } else {
                if (isSameSide) {
                    secEntryInfo.setVeriType(true);
                }
                entryColl.addObject((IObjectValue)secEntryInfo);
            }
            if (isSameSide) {
                removeItem.add(mainEntryInfo);
            }
            removeItem.add(secEntryInfo);
            return true;
        }
        if (mainEntryInfo.getThisVerificateAmt().abs().compareTo(secEntryInfo.getThisVerificateAmt().abs()) > 0) {
            ExchangeRateInfo erInfo = null;
            if (!exRateMap.containsKey(mainEntryInfo.getCurrency().getId().toString() + mainEntryInfo.getString("baseCurrencyId")) && !mainEntryInfo.getCurrency().getId().toString().equals(mainEntryInfo.getString("baseCurrencyId"))) {
                erInfo = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRate((IObjectPK)new ObjectUuidPK(mainEntryInfo.getString("baseExchangeTableId")), (IObjectPK)new ObjectUuidPK(mainEntryInfo.getCurrency().getId().toString()), (IObjectPK)new ObjectUuidPK(mainEntryInfo.getString("baseCurrencyId")), DateTimeUtils.truncateDate((Date)new Date()));
                exRateMap.put(mainEntryInfo.getCurrency().getId().toString() + mainEntryInfo.getString("baseCurrencyId"), erInfo);
            } else if (!mainEntryInfo.getCurrency().getId().toString().equals(mainEntryInfo.getString("baseCurrencyId"))) {
                erInfo = (ExchangeRateInfo)exRateMap.get(mainEntryInfo.getCurrency().getId().toString() + mainEntryInfo.getString("baseCurrencyId"));
            }
            BigDecimal thisVerificateAmtLoc = null;
            thisVerificateAmtLoc = erInfo == null || ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)erInfo.getExchangeAux().getConvertMode()) ? secEntryInfo.getThisVerificateAmt().multiply(mainEntryInfo.getBigDecimal("exchangeRate")).setScale(mainEntryInfo.getInt("basePrecision"), 4) : secEntryInfo.getThisVerificateAmt().divide(mainEntryInfo.getBigDecimal("exchangeRate"), mainEntryInfo.getInt("basePrecision"), 4);
            if (entryColl.containsKey((Object)mainEntryInfo.getId())) {
                tempEntryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject((Object)mainEntryInfo.getId());
                tempEntryInfo.setThisVerificateAmt(tempEntryInfo.getThisVerificateAmt().add(isSameSide ? secEntryInfo.getThisVerificateAmt().negate() : secEntryInfo.getThisVerificateAmt()));
                tempEntryInfo.setThisVerificateAmtLoc(tempEntryInfo.getThisVerificateAmtLoc().add(isSameSide ? thisVerificateAmtLoc.negate() : thisVerificateAmtLoc));
            } else {
                tempEntryInfo = (VerificationBillBaseEntryInfo)mainEntryInfo.clone();
                tempEntryInfo.setThisVerificateAmt(isSameSide ? secEntryInfo.getThisVerificateAmt().negate() : secEntryInfo.getThisVerificateAmt());
                tempEntryInfo.setThisVerificateAmtLoc(isSameSide ? thisVerificateAmtLoc.negate() : thisVerificateAmtLoc);
                if (isSameSide) {
                    tempEntryInfo.setVeriType(true);
                }
                entryColl.addObject((IObjectValue)tempEntryInfo);
            }
            if (entryColl.containsKey((Object)secEntryInfo.getId())) {
                tempEntryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject((Object)secEntryInfo.getId());
                tempEntryInfo.setThisVerificateAmt(tempEntryInfo.getThisVerificateAmt().add(secEntryInfo.getThisVerificateAmt()));
                tempEntryInfo.setThisVerificateAmtLoc(tempEntryInfo.getThisVerificateAmtLoc().add(secEntryInfo.getThisVerificateAmtLoc()));
            } else {
                if (isSameSide) {
                    secEntryInfo.setVeriType(true);
                }
                entryColl.addObject((IObjectValue)secEntryInfo);
            }
            mainEntryInfo.setThisVerificateAmt(mainEntryInfo.getThisVerificateAmt().subtract(isSameSide ? secEntryInfo.getThisVerificateAmt().negate() : secEntryInfo.getThisVerificateAmt()));
            mainEntryInfo.setThisVerificateAmtLoc(mainEntryInfo.getThisVerificateAmtLoc().subtract(isSameSide ? thisVerificateAmtLoc.negate() : thisVerificateAmtLoc));
            removeItem.add(secEntryInfo);
        } else if (mainEntryInfo.getThisVerificateAmt().abs().compareTo(secEntryInfo.getThisVerificateAmt().abs()) < 0) {
            ExchangeRateInfo erInfo = null;
            if (!exRateMap.containsKey(secEntryInfo.getCurrency().getId().toString() + secEntryInfo.getString("baseCurrencyId")) && !secEntryInfo.getCurrency().getId().toString().equals(secEntryInfo.getString("baseCurrencyId"))) {
                erInfo = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRate((IObjectPK)new ObjectUuidPK(secEntryInfo.getString("baseExchangeTableId")), (IObjectPK)new ObjectUuidPK(secEntryInfo.getCurrency().getId().toString()), (IObjectPK)new ObjectUuidPK(secEntryInfo.getString("baseCurrencyId")), DateTimeUtils.truncateDate((Date)new Date()));
                exRateMap.put(secEntryInfo.getCurrency().getId().toString() + secEntryInfo.getString("baseCurrencyId"), erInfo);
            } else if (!secEntryInfo.getCurrency().getId().toString().equals(secEntryInfo.getString("baseCurrencyId"))) {
                erInfo = (ExchangeRateInfo)exRateMap.get(secEntryInfo.getCurrency().getId().toString() + secEntryInfo.getString("baseCurrencyId"));
            }
            BigDecimal thisVerificateAmtLoc = null;
            thisVerificateAmtLoc = erInfo == null || ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)erInfo.getExchangeAux().getConvertMode()) ? mainEntryInfo.getThisVerificateAmt().multiply(secEntryInfo.getBigDecimal("exchangeRate")).setScale(secEntryInfo.getInt("basePrecision"), 4) : mainEntryInfo.getThisVerificateAmt().divide(secEntryInfo.getBigDecimal("exchangeRate"), secEntryInfo.getInt("basePrecision"), 4);
            if (entryColl.containsKey((Object)mainEntryInfo.getId())) {
                tempEntryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject((Object)mainEntryInfo.getId());
                tempEntryInfo.setThisVerificateAmt(tempEntryInfo.getThisVerificateAmt().add(mainEntryInfo.getThisVerificateAmt()));
                tempEntryInfo.setThisVerificateAmtLoc(tempEntryInfo.getThisVerificateAmtLoc().add(mainEntryInfo.getThisVerificateAmtLoc()));
            } else {
                if (isSameSide) {
                    mainEntryInfo.setVeriType(true);
                }
                entryColl.addObject((IObjectValue)mainEntryInfo);
            }
            if (entryColl.containsKey((Object)secEntryInfo.getId())) {
                tempEntryInfo = (VerificationBillBaseEntryInfo)entryColl.getObject((Object)secEntryInfo.getId());
                tempEntryInfo.setThisVerificateAmt(tempEntryInfo.getThisVerificateAmt().add(isSameSide ? mainEntryInfo.getThisVerificateAmt().negate() : mainEntryInfo.getThisVerificateAmt()));
                tempEntryInfo.setThisVerificateAmtLoc(tempEntryInfo.getThisVerificateAmtLoc().add(isSameSide ? thisVerificateAmtLoc.negate() : thisVerificateAmtLoc));
            } else {
                tempEntryInfo = (VerificationBillBaseEntryInfo)secEntryInfo.clone();
                tempEntryInfo.setThisVerificateAmt(isSameSide ? mainEntryInfo.getThisVerificateAmt().negate() : mainEntryInfo.getThisVerificateAmt());
                tempEntryInfo.setThisVerificateAmtLoc(isSameSide ? thisVerificateAmtLoc.negate() : thisVerificateAmtLoc);
                if (isSameSide) {
                    tempEntryInfo.setVeriType(true);
                }
                entryColl.addObject((IObjectValue)tempEntryInfo);
            }
            secEntryInfo.setThisVerificateAmt(secEntryInfo.getThisVerificateAmt().subtract(isSameSide ? mainEntryInfo.getThisVerificateAmt().negate() : mainEntryInfo.getThisVerificateAmt()));
            secEntryInfo.setThisVerificateAmtLoc(secEntryInfo.getThisVerificateAmtLoc().subtract(isSameSide ? thisVerificateAmtLoc.negate() : thisVerificateAmtLoc));
            if (isSameSide) {
                removeItem.add(mainEntryInfo);
            }
            return true;
        }
        return false;
    }

    protected CoreBaseCollection buildInnerSameSideBillInfo(Context ctx, List list, WriteOffCommonParams params) throws BOSException, EASBizException {
        CoreBaseCollection billColl = new CoreBaseCollection();
        HashMap positive = new HashMap();
        HashMap negative = new HashMap();
        VerificationBillBaseEntryInfo entryInfo2 = null;
        List<VerificationBillBaseEntryInfo> entryList = null;
        for (VerificationBillBaseEntryInfo entryInfo2 : list) {
            if ("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(entryInfo2.getString("paymentTypeId")) || "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5".equals(entryInfo2.getString("paymentTypeId"))) {
                return null;
            }
            if (entryInfo2.getThisVerificateAmt().signum() > 0) {
                entryList = positive.containsKey(entryInfo2.getBillID().toString()) ? (List)positive.get(entryInfo2.getBillID().toString()) : new ArrayList<VerificationBillBaseEntryInfo>();
                entryList.add(entryInfo2);
                positive.put(entryInfo2.getBillID().toString(), entryList);
                continue;
            }
            entryList = negative.containsKey(entryInfo2.getBillID().toString()) ? (List)negative.get(entryInfo2.getBillID().toString()) : new ArrayList();
            entryList.add(entryInfo2);
            negative.put(entryInfo2.getBillID().toString(), entryList);
        }
        if (positive.size() > 0 && negative.size() > 0) {
            VerificationBillBaseInfo billInfo = null;
            VerificationBillBaseEntryInfo mainEntryInfo2 = null;
            VerificationBillBaseEntryInfo secEntryInfo = null;
            ArrayList removeItem = new ArrayList();
            Map.Entry me2 = null;
            for (Map.Entry me2 : positive.entrySet()) {
                if (!negative.containsKey(me2.getKey())) continue;
                billInfo = this.isAr(params) ? new VerificationBillInfo() : new com.kingdee.eas.fi.ap.VerificationBillInfo();
                IObjectCollection entryColl = (IObjectCollection)billInfo.get("entrys");
                for (VerificationBillBaseEntryInfo mainEntryInfo2 : (List)me2.getValue()) {
                    removeItem.clear();
                    entryList = (List)negative.get(me2.getKey());
                    int size = entryList.size();
                    for (int i = 0; i < size; ++i) {
                        secEntryInfo = (VerificationBillBaseEntryInfo)entryList.get(i);
                        if ((!params.isFlowWriteOff() || mainEntryInfo2.getBillID().toString().equals(params.getFlowWfBillId()) || secEntryInfo.getBillID().toString().equals(params.getFlowWfBillId())) && this.addEntryInfo(ctx, entryColl, mainEntryInfo2, secEntryInfo, removeItem, true, params)) break;
                    }
                    if (removeItem.size() <= 0) continue;
                    entryList.removeAll(removeItem);
                    list.removeAll(removeItem);
                }
                if (entryColl.size() <= 0) continue;
                this.setBillInfo(ctx, billInfo, mainEntryInfo2, secEntryInfo, params, true);
                billColl.add((CoreBaseInfo)billInfo);
            }
        }
        return billColl;
    }

    private boolean isSetEmpty(Set<?> set) {
        return null == set || set.size() == 0;
    }

    private void batchCachedBillType(Context ctx, Set<String> payTypeIds, Set<String> recTypeIds) throws BOSException, EASBizException {
        int i;
        PaymentBillTypeCollection coll;
        EntityViewInfo ev = new EntityViewInfo();
        ev.getSelector().add("*");
        FilterInfo filter = new FilterInfo();
        ev.setFilter(filter);
        if (null == this.ipayType) {
            this.ipayType = PaymentBillTypeFactory.getLocalInstance((Context)ctx);
        }
        if (!this.isSetEmpty(payTypeIds)) {
            payTypeIds.removeAll(this.payTypeMap.keySet());
        }
        if (!this.isSetEmpty(payTypeIds)) {
            filter.getFilterItems().add(new FilterItemInfo("id", payTypeIds, CompareType.INCLUDE));
            coll = this.ipayType.getPaymentBillTypeCollection(ev);
            PaymentBillTypeInfo payType = null;
            for (i = 0; i < coll.size(); ++i) {
                payType = coll.get(i);
                this.payTypeMap.put(payType.getId().toString(), payType);
            }
        }
        if (null == this.irecType) {
            this.irecType = ReceivingBillTypeFactory.getLocalInstance((Context)ctx);
        }
        if (!this.isSetEmpty(recTypeIds)) {
            recTypeIds.removeAll(this.recTypeMap.keySet());
        }
        if (!this.isSetEmpty(recTypeIds)) {
            filter.getFilterItems().add(new FilterItemInfo("id", recTypeIds, CompareType.INCLUDE));
            coll = this.irecType.getReceivingBillTypeCollection(ev);
            ReceivingBillTypeInfo recType = null;
            for (i = 0; i < coll.size(); ++i) {
                recType = coll.get(i);
                this.recTypeMap.put(recType.getId().toString(), recType);
            }
        }
    }

    protected VerificationBillBaseInfo buildSameSideBillInfo(Context ctx, List list, WriteOffCommonParams params) throws BOSException, EASBizException {
        boolean isFromBOTP = params.get((Object)"isFromBOTP") != null && (Boolean)params.get((Object)"isFromBOTP") != false;
        ArrayList<VerificationBillBaseEntryInfo> positive = new ArrayList<VerificationBillBaseEntryInfo>();
        ArrayList<VerificationBillBaseEntryInfo> negative = new ArrayList<VerificationBillBaseEntryInfo>();
        BOSUuid veriRecPayTypeId = null;
        HashSet<String> payTypeIds = new HashSet<String>();
        HashSet<String> recTypeIds = new HashSet<String>();
        VerificationBillBaseEntryInfo entryInfo2 = null;
        for (VerificationBillBaseEntryInfo entryInfo2 : list) {
            veriRecPayTypeId = entryInfo2.getVeriRecPayTypeId();
            if (null != veriRecPayTypeId) {
                if ("3E93295B".equals(veriRecPayTypeId.getType().toString())) {
                    payTypeIds.add(veriRecPayTypeId.toString());
                }
                if ("2AA8DB35".equals(veriRecPayTypeId.getType().toString())) {
                    recTypeIds.add(veriRecPayTypeId.toString());
                }
            }
            if (!isFromBOTP && ("cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5".equals(entryInfo2.getString("paymentTypeId")) || "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5".equals(entryInfo2.getString("paymentTypeId")))) {
                return null;
            }
            if (entryInfo2.getThisVerificateAmt().signum() > 0) {
                positive.add(entryInfo2);
                continue;
            }
            negative.add(entryInfo2);
        }
        if (positive.size() > 0 && negative.size() > 0) {
            this.batchCachedBillType(ctx, payTypeIds, recTypeIds);
            boolean recPayFlag = false;
            boolean preRecPayFlag = false;
            VerificationBillBaseInfo billInfo = null;
            billInfo = this.isAr(params) ? new VerificationBillInfo() : new com.kingdee.eas.fi.ap.VerificationBillInfo();
            IObjectCollection entryColl = (IObjectCollection)billInfo.get("entrys");
            VerificationBillBaseEntryInfo mainEntryInfo = null;
            VerificationBillBaseEntryInfo secEntryInfo = null;
            ArrayList removeItem = new ArrayList();
            PaymentBillTypeInfo pay = null;
            ReceivingBillTypeInfo rec = null;
            Iterator it = positive.iterator();
            while (it.hasNext()) {
                recPayFlag = false;
                preRecPayFlag = false;
                pay = null;
                rec = null;
                mainEntryInfo = (VerificationBillBaseEntryInfo)it.next();
                veriRecPayTypeId = mainEntryInfo.getVeriRecPayTypeId();
                if (null != veriRecPayTypeId) {
                    if ("3E93295B".equals(veriRecPayTypeId.getType().toString())) {
                        pay = this.payTypeMap.get(veriRecPayTypeId.toString());
                    }
                    if ("2AA8DB35".equals(veriRecPayTypeId.getType().toString())) {
                        rec = this.recTypeMap.get(veriRecPayTypeId.toString());
                    }
                }
                if (pay != null && pay.isIsPurPay() || rec != null && rec.isIsSaleRec()) {
                    recPayFlag = true;
                } else if (pay != null && pay.isIsPrePay() || rec != null && rec.isIsPreRec()) {
                    preRecPayFlag = true;
                }
                removeItem.clear();
                int size = negative.size();
                for (int i = 0; i < size; ++i) {
                    secEntryInfo = (VerificationBillBaseEntryInfo)negative.get(i);
                    pay = null;
                    rec = null;
                    veriRecPayTypeId = secEntryInfo.getVeriRecPayTypeId();
                    if (null != veriRecPayTypeId) {
                        if ("3E93295B".equals(veriRecPayTypeId.getType().toString())) {
                            pay = this.payTypeMap.get(veriRecPayTypeId.toString());
                        }
                        if ("2AA8DB35".equals(veriRecPayTypeId.getType().toString())) {
                            rec = this.recTypeMap.get(veriRecPayTypeId.toString());
                        }
                    }
                    if (!(params.isFlowWriteOff() && !mainEntryInfo.getBillID().toString().equals(params.getFlowWfBillId()) && !secEntryInfo.getBillID().toString().equals(params.getFlowWfBillId()) || (pay != null && pay.isIsPurPay() || rec != null && rec.isIsSaleRec()) && preRecPayFlag || (pay != null && pay.isIsPrePay() || rec != null && rec.isIsPreRec()) && recPayFlag || !this.addEntryInfo(ctx, entryColl, mainEntryInfo, secEntryInfo, removeItem, true, params))) break;
                }
                if (removeItem.size() > 0) {
                    negative.removeAll(removeItem);
                    list.removeAll(removeItem);
                }
                if (negative.size() != 0) continue;
            }
            if (entryColl.size() > 0) {
                this.setBillInfo(ctx, billInfo, mainEntryInfo, secEntryInfo, params, true);
                return billInfo;
            }
        }
        return null;
    }

    protected void setGainAndLoss(VerificationBillBaseInfo billInfo, boolean isSameSide) {
        BigDecimal mainAmt = SysConstant.BIGZERO;
        BigDecimal mainAmtLoc = SysConstant.BIGZERO;
        BigDecimal secAmt = SysConstant.BIGZERO;
        BigDecimal secAmtLoc = SysConstant.BIGZERO;
        VerificationBillBaseEntryInfo entryInfo2 = null;
        ArrayList<VerificationBillBaseEntryInfo> mainEntryColl = new ArrayList<VerificationBillBaseEntryInfo>();
        for (VerificationBillBaseEntryInfo entryInfo2 : (IObjectCollection)billInfo.get("entrys")) {
            if (isSameSide) {
                entryInfo2.setVeriType(true);
                if (entryInfo2.getThisVerificateAmt().signum() > 0) {
                    mainAmt = mainAmt.add(entryInfo2.getThisVerificateAmt());
                    mainAmtLoc = mainAmtLoc.add(entryInfo2.getThisVerificateAmtLoc());
                    mainEntryColl.add(entryInfo2);
                    continue;
                }
                secAmt = secAmt.add(entryInfo2.getThisVerificateAmt());
                secAmtLoc = secAmtLoc.add(entryInfo2.getThisVerificateAmtLoc());
                continue;
            }
            if (entryInfo2.getBillType().equals((Object)billInfo.getMainBillType())) {
                mainAmt = mainAmt.add(entryInfo2.getThisVerificateAmt());
                mainAmtLoc = mainAmtLoc.add(entryInfo2.getThisVerificateAmtLoc());
                mainEntryColl.add(entryInfo2);
                continue;
            }
            secAmt = secAmt.add(entryInfo2.getThisVerificateAmt());
            secAmtLoc = secAmtLoc.add(entryInfo2.getThisVerificateAmtLoc());
        }
        BigDecimal mainGainAndLoss = isSameSide ? secAmtLoc.add(mainAmtLoc).negate() : secAmtLoc.subtract(mainAmtLoc);
        int scale = entryInfo2.getInt("basePrecision");
        if (mainGainAndLoss.signum() != 0) {
            BigDecimal thisGainAndLoss = SysConstant.BIGZERO;
            BigDecimal sumGainAndLoss = SysConstant.BIGZERO;
            int size = mainEntryColl.size();
            for (int i = 0; i < size; ++i) {
                entryInfo2 = (VerificationBillBaseEntryInfo)mainEntryColl.get(i);
                thisGainAndLoss = i == size - 1 ? mainGainAndLoss.subtract(sumGainAndLoss) : entryInfo2.getThisVerificateAmtLoc().multiply(mainGainAndLoss).divide(mainAmtLoc, scale, 4);
                entryInfo2.setGainAndLoss(thisGainAndLoss);
                sumGainAndLoss = sumGainAndLoss.add(thisGainAndLoss);
            }
        }
        billInfo.setMainThisVerificateAmt(mainAmt);
        billInfo.setMainThisVerificateAmtLoc(mainAmtLoc);
        billInfo.setSecondThisVerificateAmt(secAmt);
        billInfo.setSecondThisVerificateAmtLoc(secAmtLoc);
        billInfo.setGainAndLoss(mainGainAndLoss);
    }

    public IObjectValue buildWriteOffEntryInfo(Context ctx, IRowSet rs, WriteOffCommonInfo info, WriteOffCommonParams params) throws SQLException {
        AccountViewInfo oppAccount;
        AccountViewInfo account;
        VerificationBillBaseEntryInfo entryInfo = (VerificationBillBaseEntryInfo)this.buildBasicWriteOffEntryInfo(ctx, rs, info, params);
        if (null == entryInfo) {
            return entryInfo;
        }
        BOSUuid billId = BOSUuid.read((String)rs.getString("id"));
        String bosType = billId.getType().toString();
        boolean isArAp = VerificationStrategy.isArAp(bosType);
        if (isArAp) {
            entryInfo.setComment(rs.getString("abstractName"));
            if (rs.getString("material.id") != null) {
                entryInfo.setMaterialName(rs.getString("material.name"));
                entryInfo.setMaterialNumber(rs.getString("material.number"));
                entryInfo.setMaterialId(BOSUuid.read((String)rs.getString("material.id")));
            } else if (rs.getString("expenseItem.id") != null) {
                entryInfo.setMaterialName(rs.getString("expenseItem.name"));
                entryInfo.setMaterialNumber(rs.getString("expenseItem.number"));
                entryInfo.setMaterialId(BOSUuid.read((String)rs.getString("expenseItem.id")));
            } else {
                entryInfo.setMaterialName(rs.getString("material.name"));
            }
            if (rs.getString("account.id") != null) {
                account = new AccountViewInfo();
                account.setId(BOSUuid.read((String)rs.getString("account.id")));
                entryInfo.setAccount(account);
            }
            if (rs.getString("oppAccount.id") != null) {
                oppAccount = new AccountViewInfo();
                oppAccount.setId(BOSUuid.read((String)rs.getString("oppAccount.id")));
                entryInfo.setOppAccount(oppAccount);
            }
        } else if ("FA44FD5B".equals(bosType)) {
            if (rs.getString("expenseType.id") != null) {
                entryInfo.setMaterialName(rs.getString("expenseType.name"));
                entryInfo.setMaterialNumber(rs.getString("expenseType.number"));
                entryInfo.setMaterialId(BOSUuid.read((String)rs.getString("expenseType.id")));
            }
            entryInfo.setComment(rs.getString("description"));
            if (rs.getString("payeeAccount.id") != null) {
                account = new AccountViewInfo();
                account.setId(BOSUuid.read((String)rs.getString("payeeAccount.id")));
                entryInfo.setAccount(account);
            }
            if (rs.getString("entryOppAccount.id") != null) {
                oppAccount = new AccountViewInfo();
                oppAccount.setId(BOSUuid.read((String)rs.getString("entryOppAccount.id")));
                entryInfo.setOppAccount(oppAccount);
            }
            entryInfo.setVeriRecPayTypeName(rs.getString("entryRecBillType.name"));
            entryInfo.setVeriRecPayTypeNumber(rs.getString("entryRecBillType.number"));
        } else if ("40284E81".equals(bosType)) {
            entryInfo.setComment(rs.getString("description"));
            if (rs.getString("expenseType.id") != null) {
                entryInfo.setMaterialName(rs.getString("expenseType.name"));
                entryInfo.setMaterialNumber(rs.getString("expenseType.number"));
                entryInfo.setMaterialId(BOSUuid.read((String)rs.getString("expenseType.id")));
            }
            if (rs.getString("payerAccount.id") != null) {
                account = new AccountViewInfo();
                account.setId(BOSUuid.read((String)rs.getString("payerAccount.id")));
                entryInfo.setAccount(account);
            }
            if (rs.getString("entryOppAccount.id") != null) {
                oppAccount = new AccountViewInfo();
                oppAccount.setId(BOSUuid.read((String)rs.getString("entryOppAccount.id")));
                entryInfo.setOppAccount(oppAccount);
            }
            entryInfo.setVeriRecPayTypeName(rs.getString("payBillType.name"));
            entryInfo.setVeriRecPayTypeNumber(rs.getString("payBillType.number"));
        }
        if (rs.getString("adminOrgUnit.id") != null) {
            AdminOrgUnitInfo adminOrgUnit = new AdminOrgUnitInfo();
            adminOrgUnit.setId(BOSUuid.read((String)rs.getString("adminOrgUnit.id")));
            entryInfo.setAdminOrgUnit(adminOrgUnit);
        }
        if (rs.getString("person.id") != null) {
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)rs.getString("person.id")));
            entryInfo.setPerson(person);
        }
        entryInfo.setBigDecimal("lastExhangeRate", rs.getBigDecimal("lastExhangeRate"));
        return entryInfo;
    }

    public SelectorItemCollection getSelector(String bosType, WriteOffCommonParams params) {
        SelectorItemCollection sic = this.getPreMatchSelector(bosType, params);
        String[] selectors = null;
        if (VerificationStrategy.isArAp(bosType)) {
            selectors = new String[]{"abstractName", "material.name", "material.number", "material.id", "expenseItem.name", "expenseItem.number", "expenseItem.id", "account.id", "adminOrgUnit.id", "person.id", "oppAccount.id", "lastExhangeRate"};
        } else if ("FA44FD5B".equals(bosType)) {
            selectors = new String[]{"description", "payeeAccount.id", "adminOrgUnit.id", "person.id", "entryOppAccount.id", "entryRecBillType.name", "entryRecBillType.number", "expenseType.name", "expenseType.id", "expenseType.number", "lastExhangeRate"};
        } else if ("40284E81".equals(bosType)) {
            selectors = new String[]{"description", "payerAccount.id", "adminOrgUnit.id", "person.id", "oppAccount.id", "entryOppAccount.id", "payBillType.name", "payBillType.number", "expenseType.name", "expenseType.id", "expenseType.number", "lastExhangeRate"};
        }
        if (selectors != null) {
            int len = selectors.length;
            for (int i = 0; i < len; ++i) {
                sic.add(new SelectorItemInfo((String)selectors[i]));
            }
        }
        return sic;
    }

    private String genPeriodCacheKey(Date date, CompanyOrgUnitInfo companyInfo, SystemEnum system) {
        StringBuilder buf = new StringBuilder(200);
        if (null != date) {
            buf.append(this.sdf.format(date));
        }
        buf.append("_");
        if (null != companyInfo) {
            buf.append(companyInfo.getId().toString());
        }
        buf.append("_");
        if (null != system) {
            buf.append(system.getValue());
        }
        return buf.toString();
    }

    private PeriodInfo getPeriodInfo(Context ctx, Date bizDate, CompanyOrgUnitInfo company, SystemEnum system) throws EASBizException, BOSException {
        String cacheKey = this.genPeriodCacheKey(bizDate, company, system);
        if (!this.periodMap.containsKey(cacheKey)) {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bizDate, (CompanyOrgUnitInfo)company, (SystemEnum)system);
            this.periodMap.put(cacheKey, periodInfo);
        }
        return this.periodMap.get(cacheKey);
    }

    private void checkArApSysPeriodByDate(Context ctx, Date bizDate, CompanyOrgUnitInfo cou, WriteOffCommonParams params, PeriodInfo curPeriodInfo) throws EASBizException, BOSException {
        if (bizDate == null || cou == null || params == null) {
            return;
        }
        PeriodInfo arPeriodInfo = null;
        PeriodInfo apPeriodInfo = null;
        PeriodInfo curApPeriodInfo = null;
        PeriodInfo curArPeriodInfo = null;
        if (params.get((Object)"veriType") != null && params.get((Object)"veriType") instanceof VerificationEnum) {
            VerificationEnum venum = (VerificationEnum)params.get((Object)"veriType");
            if (VerificationEnum.AP_AR == venum || VerificationEnum.AR_AP == venum || VerificationEnum.PrePay_PreRec == venum || VerificationEnum.PreRec_PrePay == venum || VerificationEnum.Pay_Rec == venum || VerificationEnum.Rec_Pay == venum) {
                arPeriodInfo = this.getPeriodInfo(ctx, bizDate, cou, SystemEnum.ACCOUNTSRECEIVABLE);
                apPeriodInfo = this.getPeriodInfo(ctx, bizDate, cou, SystemEnum.ACCOUNTSPAYABLE);
                if (this.isAr(params)) {
                    curArPeriodInfo = curPeriodInfo;
                    curApPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSPAYABLE, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
                } else {
                    curArPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.ACCOUNTSRECEIVABLE, (IObjectPK)new ObjectUuidPK(BOSUuid.read((String)params.getCompanyId())));
                    curApPeriodInfo = curPeriodInfo;
                }
            } else if (VerificationEnum.AP_Pay == venum) {
                apPeriodInfo = this.getPeriodInfo(ctx, bizDate, cou, SystemEnum.ACCOUNTSPAYABLE);
                curApPeriodInfo = curPeriodInfo;
            } else if (VerificationEnum.AR_Rec == venum) {
                arPeriodInfo = this.getPeriodInfo(ctx, bizDate, cou, SystemEnum.ACCOUNTSRECEIVABLE);
                curArPeriodInfo = curPeriodInfo;
            }
            if (this.isBeforeCurPeriod(apPeriodInfo, curApPeriodInfo)) {
                throw new OtherBillBizException(OtherBillBizException.SETTLE_FAIL, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"detail_title_6p", (Locale)ctx.getLocale())});
            }
            if (this.isBeforeCurPeriod(arPeriodInfo, curArPeriodInfo)) {
                throw new OtherBillBizException(OtherBillBizException.SETTLE_FAIL, new Object[]{ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArReport", (String)"detail_title_6", (Locale)ctx.getLocale())});
            }
        }
    }

    private boolean isBeforeCurPeriod(PeriodInfo startPeriod, PeriodInfo periodInfo) {
        if (startPeriod == null || periodInfo == null) {
            return false;
        }
        if (startPeriod.getPeriodYear() < periodInfo.getPeriodYear()) {
            return true;
        }
        return startPeriod.getPeriodYear() == periodInfo.getPeriodYear() && startPeriod.getPeriodNumber() < periodInfo.getPeriodNumber();
    }

    public SelectorItemCollection getPreMatchSelector(String bosType, WriteOffCommonParams params) {
        SelectorItemCollection sic = new SelectorItemCollection();
        String[] selectors = null;
        if (VerificationStrategy.isArAp(bosType)) {
            selectors = new String[]{"billDate", "asstActID", "asstActName", "asstActType.id", "currency.id", "billType", "entry.lockUnVerifyAmt", "entry.lockUnVerifyAmtLocal", "paymentType.id", "baseCurrency.id", "company.baseExchangeTable.id", "exchangeRate", "baseCurrency.precision"};
        } else if ("FA44FD5B".equals(bosType)) {
            selectors = new String[]{"bizDate", "payerID", "payerName", "payerType.id", "currency.id", "entryRecBillType.id", "entryRecBillType.isSaleRec", "entryRecBillType.isPreRec", "entryRecBillType.isProxyRec", "entries.unLockAmt", "entries.unLockLocAmt", "paymentType.id", "baseCurrency.id", "company.baseExchangeTable.id", "exchangeRate", "baseCurrency.precision"};
        } else if ("40284E81".equals(bosType)) {
            selectors = new String[]{"bizDate", "payeeID", "payeeName", "payeeType.id", "currency.id", "payBillType.id", "payBillType.isPurPay", "payBillType.isPrePay", "payBillType.isProxyPay", "entries.unLockAmt", "entries.unLockLocAmt", "paymentType.id", "baseCurrency.id", "company.baseExchangeTable.id", "exchangeRate", "baseCurrency.precision"};
        }
        if (selectors != null) {
            int len = selectors.length;
            for (int i = 0; i < len; ++i) {
                sic.add(new SelectorItemInfo((String)selectors[i]));
            }
        }
        return sic;
    }

    public IRowSet getPreMatchRowSet(Context ctx, SelectorItemCollection sic, String tmpTable, String orderSql) throws BOSException, EASBizException {
        if (null == ctx || null == sic || StringUtils.isEmpty((String)tmpTable)) {
            return null;
        }
        StringBuilder buf = new StringBuilder(sic.size() * 44);
        for (int i = 0; i < sic.size(); ++i) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(VerificationStrategy.getLinkedField((String)sic.get(i).toString()));
        }
        String select = "SELECT " + buf.toString() + " FROM " + tmpTable + " " + orderSql;
        return DbUtil.executeQuery((Context)ctx, (String)select);
    }

    protected boolean isAr(WriteOffCommonParams params) {
        return this.getBoolean(params, "isAR");
    }

    protected boolean getBoolean(WriteOffCommonParams params, String key) {
        return params.get((Object)key) != null && (Boolean)params.get((Object)key) != false;
    }

    public static boolean isArAp(String bosType) {
        return "FC910EF3".equals(bosType) || "48DA3A71".equals(bosType);
    }

    public IObjectValue buildBasicWriteOffEntryInfo(Context ctx, IRowSet rs, WriteOffCommonInfo info, WriteOffCommonParams params) throws SQLException {
        AsstActTypeInfo asstActType;
        boolean isHeadView = this.getBoolean(params, "isHeadView");
        VerificationBillBaseEntryInfo entryInfo = null;
        if (this.isAr(params)) {
            entryInfo = new VerificationBillentryInfo();
            entryInfo.setId(BOSUuid.create((String)"E8E08EAC"));
        } else {
            entryInfo = new com.kingdee.eas.fi.ap.VerificationBillentryInfo();
            entryInfo.setId(BOSUuid.create((String)"763E6D2A"));
        }
        boolean isPreVerify = this.getBoolean(params, "isPreVerify");
        if (isPreVerify) {
            entryInfo.setIsPreVerify(true);
        }
        boolean isFromBOTP = this.getBoolean(params, "isFromBOTP");
        entryInfo.setIsFromBOTP(isFromBOTP);
        BOSUuid billId = BOSUuid.read((String)rs.getString("id"));
        String bosType = billId.getType().toString();
        boolean isArAp = VerificationStrategy.isArAp(bosType);
        entryInfo.setBillID(billId);
        entryInfo.setEntryID(BOSUuid.read((String)(isArAp ? rs.getString("entry.id") : rs.getString("entries.id"))));
        entryInfo.setBillNumber(rs.getString("number"));
        boolean isBillInnerVerify = this.getBoolean(params, "isBillInnerVerify");
        if (info != null && !isBillInnerVerify) {
            if (isHeadView) {
                BigDecimal lockAmtLocal;
                if (info.getAmount().signum() == 0) {
                    return null;
                }
                BigDecimal lockAmt = isArAp ? rs.getBigDecimal("entry.lockUnVerifyAmt") : rs.getBigDecimal("entries.unLockAmt");
                BigDecimal bigDecimal = lockAmtLocal = isArAp ? rs.getBigDecimal("entry.lockUnVerifyAmtLocal") : rs.getBigDecimal("entries.unLockLocAmt");
                if (info.getAmount().abs().compareTo(lockAmt.abs()) > 0) {
                    entryInfo.setThisVerificateAmt(lockAmt);
                    entryInfo.setThisVerificateAmtLoc(lockAmtLocal);
                } else {
                    entryInfo.setThisVerificateAmt(info.getAmount());
                    entryInfo.setThisVerificateAmtLoc(info.getLocalAmount());
                }
                info.setAmount(info.getAmount().subtract(entryInfo.getThisVerificateAmt()));
                info.setLocalAmount(info.getLocalAmount().subtract(entryInfo.getThisVerificateAmtLoc()));
            } else {
                entryInfo.setThisVerificateAmt(info.getAmount());
                entryInfo.setThisVerificateAmtLoc(info.getLocalAmount());
            }
        } else {
            entryInfo.setThisVerificateAmt(isArAp ? rs.getBigDecimal("entry.lockUnVerifyAmt") : rs.getBigDecimal("entries.unLockAmt"));
            entryInfo.setThisVerificateAmtLoc(isArAp ? rs.getBigDecimal("entry.lockUnVerifyAmtLocal") : rs.getBigDecimal("entries.unLockLocAmt"));
        }
        if (isArAp) {
            if ("FC910EF3".equals(bosType)) {
                entryInfo.setBillType(VerificateBillTypeEnum.OtherReceiveBill);
                entryInfo.setBillSubType(Helper.changeBillType(true, rs.getInt("billType")));
            } else {
                entryInfo.setBillType(VerificateBillTypeEnum.OtherPaymentBill);
                entryInfo.setBillSubType(Helper.changeBillType(false, rs.getInt("billType")));
            }
            entryInfo.setAcctCussID(BOSUuid.read((String)rs.getString("asstActID")));
            entryInfo.setAcctCussName(rs.getString("asstActName"));
            asstActType = new AsstActTypeInfo();
            asstActType.setId(BOSUuid.read((String)rs.getString("asstActType.id")));
            entryInfo.setAcctCussType(asstActType);
            entryInfo.setVeriRecPayTypeName(entryInfo.getBillSubType().getAlias(ctx.getLocale()));
            entryInfo.setBillDate(rs.getDate("billDate"));
            entryInfo.setAcctCussID(BOSUuid.read((String)rs.getString("asstActID")));
        } else if ("FA44FD5B".equals(bosType)) {
            entryInfo.setBillType(VerificateBillTypeEnum.ReceiveBill);
            if (rs.getBoolean("entryRecBillType.isSaleRec")) {
                entryInfo.setBillSubType(entryInfo.getThisVerificateAmt().signum() > 0 ? VerificateBillTypeEnum.REC_AR_SELL_REC : VerificateBillTypeEnum.REC_AR_REFUNDMENT_SELL_REC);
            } else if (rs.getBoolean("entryRecBillType.isPreRec")) {
                entryInfo.setBillSubType(entryInfo.getThisVerificateAmt().signum() > 0 ? VerificateBillTypeEnum.REC_AR_PRE_REC : VerificateBillTypeEnum.REC_AR_REFUNDMENT_PRE_REC);
            } else if (rs.getBoolean("entryRecBillType.isProxyRec")) {
                entryInfo.setBillSubType(entryInfo.getThisVerificateAmt().signum() > 0 ? VerificateBillTypeEnum.REC_AR_AGENT : VerificateBillTypeEnum.REC_AR_REFUNDMENT_AGENT);
            }
            entryInfo.setBillDate(rs.getDate("bizDate"));
            if (rs.getString("payerID") != null) {
                entryInfo.setAcctCussID(BOSUuid.read((String)rs.getString("payerID")));
            }
            entryInfo.setAcctCussName(rs.getString("payerName"));
            asstActType = new AsstActTypeInfo();
            asstActType.setId(BOSUuid.read((String)rs.getString("payerType.id")));
            entryInfo.setAcctCussType(asstActType);
            entryInfo.setVeriRecPayTypeId(BOSUuid.read((String)rs.getString("entryRecBillType.id")));
        } else if ("40284E81".equals(bosType)) {
            entryInfo.setBillType(VerificateBillTypeEnum.PaymentBill);
            if (rs.getBoolean("payBillType.isPurPay")) {
                entryInfo.setBillSubType(entryInfo.getThisVerificateAmt().signum() > 0 ? VerificateBillTypeEnum.PAY_AP_STOCK_PAYMENT : VerificateBillTypeEnum.PAY_AP_REFUNDMENT_STOCK_PAYMENT);
            } else if (rs.getBoolean("payBillType.isPrePay")) {
                entryInfo.setBillSubType(entryInfo.getThisVerificateAmt().signum() > 0 ? VerificateBillTypeEnum.PAY_AP_PRE_PAYMENT : VerificateBillTypeEnum.PAY_AP_REFUNDMENT_PRE_PAYMENT);
            } else if (rs.getBoolean("payBillType.isProxyPay")) {
                entryInfo.setBillSubType(entryInfo.getThisVerificateAmt().signum() > 0 ? VerificateBillTypeEnum.PAY_AP_AGENT : VerificateBillTypeEnum.PAY_AP_REFUNDMENT_AGENT);
            }
            entryInfo.setBillDate(rs.getDate("bizDate"));
            entryInfo.setAcctCussID(BOSUuid.read((String)rs.getString("payeeID")));
            entryInfo.setAcctCussName(rs.getString("payeeName"));
            asstActType = new AsstActTypeInfo();
            asstActType.setId(BOSUuid.read((String)rs.getString("payeeType.id")));
            entryInfo.setAcctCussType(asstActType);
            entryInfo.setVeriRecPayTypeId(BOSUuid.read((String)rs.getString("payBillType.id")));
        }
        CurrencyInfo currency = new CurrencyInfo();
        currency.setId(BOSUuid.read((String)rs.getString("currency.id")));
        entryInfo.setCurrency(currency);
        entryInfo.setString("paymentTypeId", rs.getString("paymentType.id"));
        entryInfo.setString("baseCurrencyId", rs.getString("baseCurrency.id"));
        entryInfo.setString("baseExchangeTableId", rs.getString("company.baseExchangeTable.id"));
        entryInfo.setBigDecimal("exchangeRate", rs.getBigDecimal("exchangeRate"));
        entryInfo.setInt("basePrecision", rs.getInt("baseCurrency.precision"));
        return entryInfo;
    }

    public boolean isUsePreMatch(Context ctx, WriteOffCommonParams params) {
        VerificationEnum veriType = (VerificationEnum)params.get((Object)"veriType");
        return DBParamUtil.isUsePreMatch((Context)ctx) && (VerificationEnum.AP_Pay.equals((Object)veriType) || VerificationEnum.AR_Rec.equals((Object)veriType));
    }
}

