/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.arap.app.balance.ArApBillAccountBalanceCalculator;
import com.kingdee.eas.fi.arap.util.ArApExtensionUtil;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.app.engine.BalanceModelCache;
import com.kingdee.util.StringUtils;
import org.apache.log4j.Logger;

public class ArApBalanceCalculatorFactory {
    public static final String className = ArApBalanceCalculatorFactory.class.getName();
    public static Logger logger = Logger.getLogger((String)className);

    public static ArApBillAccountBalanceCalculator getArApBillAccountBalanceCalculator(Context ctx, boolean isAr, ContrastGLQueryParam param) throws BOSException, EASBizException {
        String balanceModelId = isAr ? "p4AAAABcSQIj1GIy" : "p4AAAABhNrkj1GIy";
        BalanceModelInfo balanceModelInfo = BalanceModelCache.getBalanceModelInfo((Context)ctx, (String)balanceModelId);
        if (!UseStatusEnum.ACTIVE.equals((Object)balanceModelInfo.getState())) {
            throw new BalanceModelException(BalanceModelException.BALANCEMODELISNOTACTIVE);
        }
        String serviceClass = ArApExtensionUtil.getExtServiceClassName(ctx, className, SourceTypeEnum.AR);
        ArApBillAccountBalanceCalculator calculator = null;
        if (StringUtils.isEmpty((String)serviceClass)) {
            calculator = new ArApBillAccountBalanceCalculator(ctx, balanceModelInfo, isAr, param);
        } else {
            try {
                calculator = (ArApBillAccountBalanceCalculator)((Object)Class.forName(serviceClass).newInstance());
                calculator.setAr(isAr).setParam(param).setCtx(ctx).setBalanceModelInfo(balanceModelInfo);
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new BOSException("getArApBillAccountBalanceCalculator encounter an error:\r\n" + e.getMessage(), (Throwable)e);
            }
        }
        return calculator;
    }
}

