/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.balance;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.ApBillAccountBalanceFactory;
import com.kingdee.eas.fi.ar.ArBillAccountBalanceFactory;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.ar.util.CommonUtils;
import com.kingdee.eas.fi.arap.ARAPContrastBizException;
import com.kingdee.eas.fi.arap.app.balance.ArApBillAccountBalanceSQLBuilder;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.scm.framework.balance.BalanceDataModelInfo;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.balance.BalanceModelInfo;
import com.kingdee.eas.scm.framework.balance.app.engine.ISQLBuilder;
import com.kingdee.eas.scm.framework.balance.app.engine.InvokeTime;
import com.kingdee.eas.scm.framework.balance.app.engine.PeriodBalanceCalculator;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ArApBillAccountBalanceCalculator
extends PeriodBalanceCalculator {
    public final String FIELD_SCENE_NUMBER = "FsceneNumber";
    public final String OPPOSITE_POSITIVE_SCENE_NUMBER_SUFFIX = "-Positive";
    private Set<String> recPaySceneNumberSet = null;
    private Set<String> recPayDebitSceneNumberSet = null;
    private Set<String> recPayCreditSceneNumberSet = null;
    private Set<String> bizBillSceneNumberSet = null;
    private String recPaySceneNumberCondition = null;
    private String arApContrastByBillAccountInsertSQL = null;
    public final String COUNTED_FILTER = " FISCOUNTED = 1 \r\n";
    public final String NOT_COUNT_FILTER = " FISCOUNTED = 0 \r\n";
    private String recPayTempTable = null;
    private String tempAcctBalTable = null;
    private String finalAcctBalTable = null;
    private boolean isAr = false;
    private ContrastGLQueryParam param = null;
    private String createId = null;
    private String createTime = null;
    protected SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public final String BALANCE_GROUP_BY_COLUMNS = " FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT ";
    public final String BALANCE_GROUP_BY_COLUMNS_WITH_BALTYPE = " FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT , FBALTYPE";
    public final String REC_PAY_GROUP_BY_COLUMNS = " FBILLID, FBILLNUMBER, FRECPAYBILLTYPEID, \r\n FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT  , FBILLDATE, FSCENENUMBER ";
    public Object[][] billTypeArray = new Object[][]{{"DAWSqQEREADgAAGVwKgSfCqo2zU=", "DAWSqQEREADgAAInwKgSfCqo2zU="}, {"DAWSqQEREADgAAILwKgSfCqo2zU=", "DAWSqQEREADgAAIswKgSfCqo2zU="}, {"DAWSqQEREADgAAIOwKgSfCqo2zU=", "DAWSqQEREADgAAIvwKgSfCqo2zU="}, {"NLGLdwEREADgAAHcwKgSRj6TKVs=", "NLGLdwEREADgAAHpwKgSRj6TKVs="}, {"NLGLdwEREADgAAHjwKgSRj6TKVs=", "NLGLdwEREADgAAHuwKgSRj6TKVs="}, {"NLGLdwEREADgAAHmwKgSRj6TKVs=", "NLGLdwEREADgAAHxwKgSRj6TKVs="}};
    public final String REC_PAY_GROUP_BY_COLUMNS_TMP_WITHOUT_FSCENENUMBER = " TMP.FBILLID, TMP.FBILLNUMBER, TMP.FRECPAYBILLTYPEID, \r\n TMP.FCOMPANYID, TMP.FASSTACTTYPEID, TMP.FASSTACTID, TMP.FCURRENCYID, \r\n TMP.FPERSONID, TMP.FADMINORGUNITID, TMP.FACCOUNT, TMP.FBILLDATE ";
    public final int FDataDirection_Negative = 1;
    public final int FDataDirection_Opposite_Positive = -1;
    private Map<String, String> recPayScenceNumberMap = new HashMap<String, String>();

    public boolean isAr() {
        return this.isAr;
    }

    public ArApBillAccountBalanceCalculator setAr(boolean isAr) {
        this.isAr = isAr;
        return this;
    }

    public ContrastGLQueryParam getParam() {
        return this.param;
    }

    public ArApBillAccountBalanceCalculator setParam(ContrastGLQueryParam param) {
        this.param = param;
        return this;
    }

    public ArApBillAccountBalanceCalculator(Context ctx, BalanceModelInfo balanceModelInfo, boolean isAr, ContrastGLQueryParam param) throws BOSException, EASBizException {
        super(ctx, balanceModelInfo);
        this.isAr = isAr;
        this.param = param;
    }

    private String tempBillAcctBalTbl() throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(300);
        buf.append("(FID VARCHAR(44), FBalType VARCHAR(6), FCompanyID VARCHAR(44), ").append("\r\n").append("FPeriodID VARCHAR(44), FCurrencyID VARCHAR(44), ").append("\r\n").append("FBeginBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FYearDebitFor NUMERIC(19,4) DEFAULT 0 NOT NULL,").append("\r\n").append("FYearCreditFor NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FEndBalanceFor NUMERIC(19,4) DEFAULT 0 NOT NULL , ").append("\r\n").append("FBeginBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL,").append("\r\n").append("FDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FYearDebitLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FYearCreditLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FEndBalanceLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FAsstActTypeID VARCHAR(44), ").append("\r\n").append("FAsstActID VARCHAR(44), FAccount VARCHAR(44), ").append("\r\n").append("FAdminOrgUnitID VARCHAR(44), FPersonID VARCHAR(44), ").append("\r\n").append("FisDeleted INT DEFAULT 0 NOT NULL ").append("\r\n").append(" );");
        return buf.toString();
    }

    private String tempRecPayBillTbl() throws BOSException, EASBizException {
        StringBuilder buf = new StringBuilder(200);
        buf.append("(FBillID VARCHAR(44), FBillNumber VARCHAR(80), ").append("\r\n").append(" FRecPayBillTypeID VARCHAR(44), FCompanyID VARCHAR(44), ").append("\r\n").append(" FAsstActTypeID VARCHAR(44), FAsstActID VARCHAR(44), ").append("\r\n").append(" FCurrencyID VARCHAR(44), FPersonID VARCHAR(44),").append("\r\n").append(" FAdminOrgUnitID VARCHAR(44), FAccount VARCHAR(44),").append("\r\n").append("FAmount NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FAmountLocal NUMERIC(19,4) DEFAULT 0 NOT NULL, ").append("\r\n").append("FVoucherID VARCHAR(44), ").append("\r\n").append("FSceneNumber VARCHAR(30), ").append("\r\n").append("FBillDate DateTime ").append("\r\n").append(" );");
        return buf.toString();
    }

    public void addRecPayDebitSceneNumber(Set<String> sceneNumberSet) {
    }

    public void addRecPayCreditSceneNumber(Set<String> sceneNumberSet) {
    }

    public void addBizBillSceneNumber(Set<String> sceneNumberSet) {
    }

    protected String getCommonDataFilter() {
        return new StringBuilder(100).append(" FCOMPANYID = '").append(this.orgUnitID).append("'").append("\r\n").append(" AND ").append(" FCREATORID = '").append(this.createId).append("'").toString();
    }

    private void clearContrastByBillAccount() throws BOSException, BalanceModelException {
        StringBuilder deleteSQL = new StringBuilder(200).append(" DELETE FROM ").append(this.createFinalTempTable()).append("\r\n").append(" ").append("WHERE ").append(this.getCommonDataFilter());
        KsqlUtil.execute((Context)this.ctx, (String)deleteSQL.toString());
    }

    protected String createFinalTempTable() throws BOSException, BalanceModelException {
        String tableName = "";
        tableName = this.isAr ? (!this.param.isCalculateOpposite() ? "T_AR_ArContrastByBillAccount" : "T_AP_ApContrastByBillAccount") : (!this.param.isCalculateOpposite() ? "T_AP_ApContrastByBillAccount" : "T_AR_ArContrastByBillAccount");
        return tableName;
    }

    protected void beforeInit() throws BOSException, EASBizException {
        if (!this.param.isContrastByBillAccount()) {
            throw new BalanceModelException(BalanceModelException.ARAPCONTRASTBYBILLACCOUNTISDISABLE);
        }
        if (CommonUtils.isEmpty(this.param.getAcctFormula())) {
            throw new ARAPContrastBizException(ARAPContrastBizException.NOT_SET_CONTRAST_ACCOUNT);
        }
    }

    protected void createTmpBalanceTable() throws BOSException, EASBizException {
        if (this.param.isCalculateOpposite()) {
            if (StringUtils.isEmpty((String)this.param.getTempAcctBalTable()) || StringUtils.isEmpty((String)this.param.getFinalAcctBalTable())) {
                if (this.isAr()) {
                    throw new ARAPContrastBizException(ARAPContrastBizException.NOT_AR_TEMP_TABLE_WHEN_OPPOSITE);
                }
                throw new ARAPContrastBizException(ARAPContrastBizException.NOT_AP_TEMP_TABLE_WHEN_OPPOSITE);
            }
            this.tempAcctBalTable = this.param.getTempAcctBalTable();
            this.finalAcctBalTable = this.param.getFinalAcctBalTable();
        } else {
            this.tempAcctBalTable = TempTableUtil.createTempTable(this.ctx, this.tempBillAcctBalTbl());
            KsqlUtil.createTempTableIndex((Context)this.ctx, (String)this.tempAcctBalTable, (String)" FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT , FBALTYPE", (boolean)false, (boolean)false);
            this.param.setTempAcctBalTable(this.tempAcctBalTable);
            this.finalAcctBalTable = TempTableUtil.createTempTable(this.ctx, this.tempBillAcctBalTbl());
            this.param.setFinalAcctBalTable(this.finalAcctBalTable);
            this.clearContrastByBillAccount();
        }
    }

    protected void init() throws BOSException, EASBizException {
        this.beforeInit();
        super.init();
        this.createId = ContextUtil.getCurrentUserInfo((Context)this.ctx).getId().toString();
        this.createTime = "{ts'" + this.sdf.format(new Date()) + "'}";
        KsqlUtil.createTempTableIndex((Context)this.ctx, (String)this.detailTempTable, (String)"FsceneNumber", (boolean)false, (boolean)false);
        if (this.param.isCloseAccount()) {
            ContrastGLQueryParam.initDBParam(this.ctx, this.param, this.isAr);
        }
        this.createTmpBalanceTable();
        this.recPayTempTable = TempTableUtil.createTempTable(this.ctx, this.tempRecPayBillTbl());
        KsqlUtil.createTempTableIndex((Context)this.ctx, (String)this.recPayTempTable, (String)"FsceneNumber", (boolean)false, (boolean)false);
        this.recPayDebitSceneNumberSet = new HashSet<String>();
        this.recPayCreditSceneNumberSet = new HashSet<String>();
        this.bizBillSceneNumberSet = new HashSet<String>();
        this.addRecPayDebitSceneNumber(this.recPayDebitSceneNumberSet);
        this.addRecPayCreditSceneNumber(this.recPayCreditSceneNumberSet);
        this.addBizBillSceneNumber(this.bizBillSceneNumberSet);
    }

    private String getBalanceBosType() {
        String bosType = this.balBosType;
        if (this.param.isCalculateOpposite()) {
            bosType = this.isAr ? "30821EEB" : "CF8988AB";
        }
        return bosType;
    }

    public static final void initArApBillAccountBeginBalance(Context ctx, CompanyOrgUnitInfo company, boolean isEnable, boolean isAr, SystemStatusCtrolInfo sysStsCtrl) throws BOSException, EASBizException {
        if (null == company || null == sysStsCtrl) {
            return;
        }
        if (!isEnable || !sysStsCtrl.isIsStart()) {
            return;
        }
        String companyId = company.getId().toString();
        String update = "UPDATE %s SET FISDELETED = 1 WHERE FCOMPANYID = '%s' ";
        KsqlUtil.execute((Context)ctx, (String)String.format(update, ArApBillAccountBalanceCalculator.getBalanceTable(isAr), companyId));
        PeriodInfo curPeriod = sysStsCtrl.getCurrentPeriod();
        String system = isAr ? "SYSTEM_AR" : "SYSTEM_AP";
        String operator = curPeriod.getPeriodNumber() == 1 ? "0" : "1";
        StringBuilder selectSQL = new StringBuilder(500);
        selectSQL.append((CharSequence)CommonServerUtils.getBillAccountBalanceInsertSQL(ArApBillAccountBalanceCalculator.getBalanceTable(isAr))).append("SELECT ").append("\r\n").append(CommonUtils.getARAPBalanceID(system, "BILL_ACCOUNT")).append(" AS FID, ").append("\r\n").append("CASE FBALTYPE WHEN ").append(2).append(" THEN '").append("20").append("' ").append("\r\n").append(" WHEN ").append(3).append(" THEN '").append("20").append("' ").append("\r\n").append(" WHEN ").append(4).append(" THEN '").append("10").append("' ").append("\r\n").append(" WHEN ").append(5).append(" THEN '").append("10").append("' ").append("\r\n").append(" END AS FBALTYPE,").append("\r\n").append("FCOMPANYID, '").append(curPeriod.getId().toString()).append("' AS FPERIODID, FCURRENCYID,").append("\r\n").append("FBEGINBALANCEFOR, 0.0 AS FDEBITFOR, 0.0 AS FCREDITFOR,").append("\r\n").append(operator).append("*FYEARDEBITFOR AS FYEARDEBITFOR, ").append(operator).append("*FYEARCREDITFOR AS FYEARCREDITFOR,").append("\r\n").append("0.0 AS FENDBALANCEFOR,").append("\r\n").append("FBEGINBALANCELOCAL, 0.0 AS FDEBITLOCAL, 0.0 AS FCREDITLOCAL,").append("\r\n").append(operator).append("*FYEARDEBITLOCAL AS FYEARDEBITLOCAL, ").append(operator).append("*FYEARCREDITLOCAL AS FYEARCREDITLOCAL,").append("\r\n").append("0.0 AS FENDBALANCELOCAL,").append("\r\n").append("FASSTACTTYPEID, FASSTACTID, FACCOUNT, FADMINORGUNITID, FPERSONID").append("\r\n").append("FROM ").append(CommonUtils.getARAPBalanceTable(system, "ACCOUNT_NORMAL")).append("\r\n").append("WHERE ").append(" FCOMPANYID = '").append(companyId).append("' ").append("\r\n").append(" AND FPERIODID = '").append(curPeriod.getId().toString()).append("' ");
        KsqlUtil.execute((Context)ctx, (String)selectSQL.toString());
    }

    protected void validateBeginData() throws BOSException, EASBizException {
        Object iCoreBase;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.orgUnitID));
        filter.getFilterItems().add(new FilterItemInfo("period", (Object)this.curPeriod.getId().toString()));
        Object object = iCoreBase = this.isAr ? ArBillAccountBalanceFactory.getLocalInstance(this.ctx) : ApBillAccountBalanceFactory.getLocalInstance(this.ctx);
        if (!iCoreBase.exists(filter)) {
            throw new ARAPContrastBizException(ARAPContrastBizException.NOT_INIT_PERIOD_BEGIN_BALANCE);
        }
    }

    private static String getBalanceTable(boolean isAr) {
        return isAr ? "T_AR_ArBillAccountBalance" : "T_AP_ApBillAccountBalance";
    }

    private String getSceneNumberFilter(Set<String> sceneNumberSet) {
        String sceneNumberCondition = "";
        if (null == sceneNumberSet || sceneNumberSet.size() == 0) {
            return sceneNumberCondition;
        }
        StringBuilder buf = new StringBuilder(100).append(" ( ");
        Iterator<String> it = sceneNumberSet.iterator();
        int count = 0;
        while (it.hasNext()) {
            if (count > 0) {
                buf.append(" ").append("OR").append(" ");
            }
            buf.append("FsceneNumber");
            if (sceneNumberSet.size() == 1) {
                buf.append(" = ").append("'").append(it.next()).append("'");
                break;
            }
            buf.append(" LIKE ").append("'").append(it.next()).append("%").append("'");
            ++count;
        }
        sceneNumberCondition = buf.append(" ) ").toString();
        return sceneNumberCondition;
    }

    private String getRecPaySceneNumberFilter() {
        if (null == this.recPaySceneNumberSet || this.recPaySceneNumberSet.size() == 0) {
            return "";
        }
        if (StringUtils.isEmpty((String)this.recPaySceneNumberCondition)) {
            this.recPaySceneNumberCondition = this.getSceneNumberFilter(this.recPaySceneNumberSet);
        }
        return this.recPaySceneNumberCondition;
    }

    private void updateRecPayBillType() throws BOSException {
        StringBuilder buf = new StringBuilder(200).append("UPDATE ").append(this.detailTempTable).append(" TMP SET FRECPAYBILLTYPEID = ? ").append("\r\n").append("WHERE ").append(this.getRecPaySceneNumberFilter()).append("\r\n").append(" AND ").append(" FRECPAYBILLTYPEID = ?");
        this.logger.info("updateRecPayBillType()=>\u66f4\u65b0\u5e94\u6536/\u4ed8\u6309\u5355\u636e\u79d1\u76ee\u53d6\u6570\u660e\u7ec6\u4e34\u65f6\u8868\uff08detailTempTable\uff09\u4e2d\u6536/\u4ed8\u6b3e\u5355\u4e0a\u6536/\u4ed8\u6b3e\u7c7b\u578b\uff1a\u6240\u6709\u9000\u6b3e\u4e1a\u52a1\u66f4\u65b0\u4e3a\u5bf9\u5e94\u7684\u6536/\u4ed8\u6b3e\u4e1a\u52a1");
        KsqlUtil.executeBatch((Context)this.ctx, (String)buf.toString(), (Object[][])this.billTypeArray);
    }

    private void sumRecPayEntries() throws BOSException {
        StringBuilder buf = new StringBuilder(200).append("INSERT INTO ").append(this.recPayTempTable).append(" ( ").append(" FBILLID, FBILLNUMBER, FRECPAYBILLTYPEID, \r\n FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT  , FBILLDATE, FSCENENUMBER ").append(",").append(" FAMOUNT, FAMOUNTLOCAL, FVOUCHERID ").append(" ) ").append("\r\n").append("SELECT ").append(" FBILLID, FBILLNUMBER, FRECPAYBILLTYPEID, \r\n FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT  , FBILLDATE, FSCENENUMBER ").append(",").append("\r\n").append("SUM(CASE WHEN FDRAMOUNT = 0 THEN FCRAMOUNT ELSE FDRAMOUNT END) FAMOUNT, ").append("\r\n").append("SUM(CASE WHEN FDRAMOUNTLOCAL = 0 THEN FCRAMOUNTLOCAL ELSE FDRAMOUNTLOCAL END) FAMOUNTLOCAL, ").append("\r\n").append("MAX(FVOUCHERID) FVOUCHERID ").append("\r\n").append("FROM ").append(this.detailTempTable).append(" ").append("\r\n").append("WHERE ").append(this.getRecPaySceneNumberFilter()).append("\r\n").append("GROUP BY ").append(" FBILLID, FBILLNUMBER, FRECPAYBILLTYPEID, \r\n FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT  , FBILLDATE, FSCENENUMBER ");
        this.logger.info("sumRecPayEntries()=>\u6536\u4ed8\u6b3e\u5355\u6839\u636e \u5355\u636eid\u3001\u4ed8\u6b3e\u7c7b\u578b\u3001\u79d1\u76eeid\u3001\u516c\u53f8\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u5e01\u522b\u3001\u5458\u5de5\u3001\u90e8\u95e8\uff08\u884c\u653f\u7ec4\u7ec7\uff09\u3001\u5355\u636e\u65e5\u671f\u5206\u7ec4\u6c42\u548c\u5230\u6536/\u4ed8\u6b3e\u5355\u6309\u5206\u5f55\u6c47\u603b\u4e34\u65f6\u4e34\u65f6\u8868\uff08recPayTempTable\uff09");
        KsqlUtil.execute((Context)this.ctx, (String)buf.toString());
    }

    private String getFinalTableInsertSQL() {
        if (StringUtils.isEmpty((String)this.arApContrastByBillAccountInsertSQL)) {
            StringBuilder buf = new StringBuilder(150).append("INSERT INTO ").append(this.finalTempTable).append(" ( ").append(" FBILLID, FBILLNUMBER, FRECPAYBILLTYPEID, \r\n FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT  , FBILLDATE, FSCENENUMBER ").append("\r\n").append(", FID, FVOUCHERID, FDRAMOUNT, FDRAMOUNTLOCAL, FCRAMOUNT, FCRAMOUNTLOCAL, FPERIODID, FISAR, FCREATORID, FCREATETIME ").append("\r\n").append(" ) ").append("\r\n");
            this.arApContrastByBillAccountInsertSQL = buf.toString();
        }
        return this.arApContrastByBillAccountInsertSQL;
    }

    private String getSelectSceneNumberSQL(boolean isOppPositive) {
        StringBuilder buf = new StringBuilder(150);
        if (isOppPositive) {
            buf.append(" CASE TMP.FSCENENUMBER ");
            Iterator<String> it = this.recPayScenceNumberMap.keySet().iterator();
            String negativeSceneNumber = null;
            while (it.hasNext()) {
                negativeSceneNumber = it.next();
                buf.append(" WHEN '").append(negativeSceneNumber).append("' THEN '").append(this.recPayScenceNumberMap.get(negativeSceneNumber)).append("'").append(" ").append("\r\n");
            }
            buf.append(" END AS FSCENENUMBER, ");
        } else {
            buf.append(" TMP.FSCENENUMBER, ");
        }
        return buf.toString();
    }

    private String getFinalTempTableBostype() {
        return this.isAr ? "E721DA78" : "87769C38";
    }

    private String getRecPaySelectSQL(boolean isDebit, int fdatadirection, boolean isNegative) {
        boolean isOppPositive = isNegative && fdatadirection == -1;
        StringBuilder buf = new StringBuilder(300);
        buf.append("SELECT ").append(" TMP.FBILLID, TMP.FBILLNUMBER, TMP.FRECPAYBILLTYPEID, \r\n TMP.FCOMPANYID, TMP.FASSTACTTYPEID, TMP.FASSTACTID, TMP.FCURRENCYID, \r\n TMP.FPERSONID, TMP.FADMINORGUNITID, TMP.FACCOUNT, TMP.FBILLDATE ").append(",").append("\r\n").append(this.getSelectSceneNumberSQL(isOppPositive)).append("\r\n").append("NEWBOSID('").append(this.getFinalTempTableBostype()).append("') AS FID, ").append("\r\n").append("TMP.FVOUCHERID, ").append("\r\n");
        if (isOppPositive) {
            if (isDebit) {
                buf.append(" 0, 0, -1*(TMP.FAMOUNT), -1*(TMP.FAMOUNTLOCAL) ").append("\r\n");
            } else {
                buf.append(" -1*(TMP.FAMOUNT), -1*(TMP.FAMOUNTLOCAL), 0, 0 ").append("\r\n");
            }
        } else if (isDebit) {
            buf.append("TMP.FAMOUNT, TMP.FAMOUNTLOCAL, 0, 0 ").append("\r\n");
        } else {
            buf.append("0, 0, TMP.FAMOUNT, TMP.FAMOUNTLOCAL ").append("\r\n");
        }
        buf.append(",").append("'").append(this.curPeriod.getId().toString()).append("'").append(" AS FPERIODID, ").append("\r\n").append(" ").append(this.isAr ? "1" : "0").append(" AS FISAR, ").append("\r\n").append("'").append(this.createId).append("'").append(" AS FCREATORID, ").append("\r\n").append(this.createTime).append(" AS FCREATETIME ").append("\r\n").append("FROM ").append(this.recPayTempTable).append(" TMP ").append("\r\n").append(" INNER JOIN ").append(" T_AR_CONTRASTACCOUNTVIEW TAC ").append("\r\n").append(" ON ").append(" TAC.FACCOUNTID = TMP.FACCOUNT ").append("\r\n").append(" AND ").append(" TAC.FCOMPANYID ='").append(this.orgUnitID).append("'").append("\r\n").append(" AND ").append(" TAC.FPERIODYEAR = ").append(this.curPeriod.getPeriodYear()).append("\r\n").append(" AND ").append(" TAC.FPERIODNUMBER = ").append(this.curPeriod.getPeriodNumber()).append("\r\n").append(" AND ").append(" TAC.FSYSTEM = ").append(this.isAr ? "1" : "2").append("\r\n");
        String sceneNumberFilter = this.getSceneNumberFilter(isDebit ? this.recPayDebitSceneNumberSet : this.recPayCreditSceneNumberSet);
        buf.append("WHERE ").append(sceneNumberFilter).append("\r\n");
        if (isNegative) {
            buf.append(" AND ").append(" TAC.FDATADIRECTION = ").append(fdatadirection).append("\r\n").append(" AND ").append("TMP.FAMOUNT < 0");
        } else {
            buf.append(" AND ").append("TMP.FAMOUNT >= 0");
        }
        return buf.append("\r\n").toString();
    }

    private void sumRecPayAmountIntoFinalTable() throws BOSException {
        StringBuilder buf = new StringBuilder(800).append(this.getFinalTableInsertSQL());
        boolean executable = false;
        if (CommonUtils.isNotEmpty(this.recPayDebitSceneNumberSet)) {
            buf.append(this.getRecPaySelectSQL(true, 1, true)).append(" UNION ALL ").append("\r\n").append(this.getRecPaySelectSQL(true, -1, true)).append(" UNION ALL ").append("\r\n").append(this.getRecPaySelectSQL(true, 1, false));
            executable = true;
        } else {
            this.logger.info("sumRecPayAmount()=>\u8bb0\u5165\u501f\u65b9\u91d1\u989d\u7684\u4e1a\u52a1\u573a\u666f\u7f16\u7801\u96c6\u5408\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5" + (this.isAr ? "\u5e94\u6536" : "\u5e94\u4ed8") + "\u6309\u5355\u636e\u79d1\u76ee\u5bf9\u8d26\u660e\u7ec6-\u53d6\u6570\u914d\u7f6e");
        }
        if (CommonUtils.isNotEmpty(this.recPayCreditSceneNumberSet)) {
            if (executable) {
                buf.append(" UNION ALL ").append("\r\n");
            }
            buf.append(this.getRecPaySelectSQL(false, 1, true)).append(" UNION ALL ").append("\r\n").append(this.getRecPaySelectSQL(false, -1, true)).append(" UNION ALL ").append("\r\n").append(this.getRecPaySelectSQL(false, 1, false));
            executable = true;
        } else {
            this.logger.info("sumRecPayAmount()=>\u8bb0\u5165\u8d37\u65b9\u91d1\u989d\u7684\u4e1a\u52a1\u573a\u666f\u7f16\u7801\u96c6\u5408\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5" + (this.isAr ? "\u5e94\u6536" : "\u5e94\u4ed8") + "\u6309\u5355\u636e\u79d1\u76ee\u5bf9\u8d26\u660e\u7ec6-\u53d6\u6570\u914d\u7f6e");
        }
        if (executable) {
            KsqlUtil.execute((Context)this.ctx, (String)buf.toString());
        }
    }

    private void markCountedRecords(String tableName, String filterSQL) throws BOSException {
        if (StringUtils.isEmpty((String)tableName)) {
            return;
        }
        StringBuilder buf = new StringBuilder(150).append("UPDATE ").append(tableName).append(" SET ").append(" FISCOUNTED = 1 \r\n").append("WHERE ").append(" FISCOUNTED = 0 \r\n");
        if (!StringUtils.isEmpty((String)filterSQL)) {
            buf.append(" AND ").append(filterSQL);
        }
        this.logger.info("markCountedRecords()=>\u66f4\u65b0\u5e94\u6536/\u4ed8\u6309\u5355\u636e\u79d1\u76ee\u53d6\u6570\u660e\u7ec6\u8868\u3010" + tableName + "\u3011\u4e2d\u6307\u5b9a\u8fc7\u6ee4\u6761\u4ef6\u7684\u6536/\u4ed8\u6b3e\u5355\u660e\u7ec6\u8bb0\u5f55.\u662f\u5426\u5df2\u7edf\u8ba1\u6c42\u548c\uff08FisCounted\uff09\u4e3atrue");
        KsqlUtil.execute((Context)this.ctx, (String)buf.toString());
    }

    private void sumRecPayBillAmount() throws BOSException, EASBizException {
        this.updateRecPayBillType();
        this.sumRecPayEntries();
        this.sumRecPayAmountIntoFinalTable();
        this.markCountedRecords(this.detailTempTable, this.getRecPaySceneNumberFilter());
        TempTableUtil.releasTempTable(this.ctx, this.recPayTempTable);
    }

    protected void groupDetailDataToFinalTable() throws BOSException {
        StringBuilder groupSQL = new StringBuilder(300);
        groupSQL.append(this.getFinalTableInsertSQL()).append("\r\n").append("SELECT ").append(" FBILLID, FBILLNUMBER, FRECPAYBILLTYPEID, \r\n FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT  , FBILLDATE, FSCENENUMBER ").append(",").append("\r\n").append("NEWBOSID('").append(this.getFinalTempTableBostype()).append("') AS FID, ").append("\r\n").append("MAX(FVOUCHERID) FVOUCHERID, ").append("\r\n").append("SUM(FDRAMOUNT) FDRAMOUNT, SUM(FDRAMOUNTLOCAL) FDRAMOUNTLOCAL, ").append("\r\n").append("SUM(FCRAMOUNT) FCRAMOUNT, SUM(FCRAMOUNTLOCAL) FCRAMOUNTLOCAL, ").append("\r\n").append("'").append(this.curPeriod.getId().toString()).append("'").append(" AS FPERIODID, ").append("\r\n").append(this.isAr ? "1" : "0").append(" AS FISAR, ").append("\r\n").append("'").append(this.createId).append("'").append(" AS FCREATORID, ").append("\r\n").append(this.createTime).append(" AS FCREATETIME ").append("\r\n").append("FROM ").append(this.detailTempTable).append(" ").append("\r\n").append("WHERE ").append(" FISCOUNTED = 0 \r\n").append("\r\n").append("GROUP BY ").append(" FBILLID, FBILLNUMBER, FRECPAYBILLTYPEID, \r\n FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT  , FBILLDATE, FSCENENUMBER ");
        this.logger.info("groupDetailDataToFinalTable()=>\u5c06\u660e\u7ec6\u4e34\u65f6\u8868\uff08detailTempTable\uff09\u6570\u636e\u6309\u7ef4\u5ea6\u3010\u5355\u636e\u3001\u516c\u53f8\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u5e01\u522b\u3001\u5458\u5de5\u3001\u90e8\u95e8\uff08\u884c\u653f\u7ec4\u7ec7\uff09\u3001\u79d1\u76ee\u3011\u6c47\u603b\u5230\u5206\u7ec4\u6c47\u603b\u4e34\u65f6\u8868\uff08finalTempTable\uff09");
        KsqlUtil.execute((Context)this.ctx, (String)groupSQL.toString());
    }

    protected void updateFinalDataBizBalType() throws BOSException {
        StringBuilder buf = new StringBuilder(150).append("UPDATE ").append(this.finalTempTable).append(" SET ").append(" FBalType = '").append("10").append("' ").append("WHERE ").append(this.getSceneNumberFilter(this.bizBillSceneNumberSet)).append("\r\n").append(" AND ").append(this.getCommonDataFilter());
        this.logger.info("udpateFinalDataBizBalType()=>\u66f4\u65b0\u5e94\u6536/\u4ed8\u6309\u5355\u636e\u79d1\u76ee\u5bf9\u8d26\u660e\u7ec6\u8868\u3010" + this.finalTempTable + "\u3011\u4e2d\uff08\u4e1a\u52a1\u5355\u636e\u4f59\u989d\uff1a10\uff09");
        KsqlUtil.execute((Context)this.ctx, (String)buf.toString());
    }

    protected void groupFinalDataToTempAcctBalTable() throws BOSException {
        StringBuilder groupSQL = CommonServerUtils.getBillAccountBalanceInsertSQL(this.tempAcctBalTable);
        groupSQL.append("SELECT ").append(" newbosid('").append(this.getBalanceBosType()).append("') AS FID, ").append("\r\n").append(" FBALTYPE, FCOMPANYID, '").append(this.curPeriod.getId().toString()).append("' AS FPERIODID , FCURRENCYID, ").append("\r\n").append("0, SUM(FDRAMOUNT) AS FDEBITFOR, SUM(FCRAMOUNT) AS FCREDITFOR, ").append("\r\n").append("SUM(FDRAMOUNT) FYEARDEBITFOR, SUM(FCRAMOUNT) AS FYEARCREDITFOR, 0, ").append("\r\n").append("0, SUM(FDRAMOUNTLOCAL) AS FDEBITLOCAL, SUM(FCRAMOUNTLOCAL) AS FCREDITLOCAL, ").append("\r\n").append("SUM(FDRAMOUNTLOCAL) AS FYEARDEBITLOCAL, SUM(FCRAMOUNTLOCAL) AS FYEARCREDITLOCAL, 0, ").append("\r\n").append("FASSTACTTYPEID, FASSTACTID, FACCOUNT, FADMINORGUNITID, FPERSONID ").append("FROM ").append(this.finalTempTable).append(" ").append("\r\n").append("WHERE ").append(this.getCommonDataFilter()).append(" ").append("\r\n").append("GROUP BY ").append(" FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT , FBALTYPE");
        this.logger.info("groupDetailDataToFinalTable()=>\u5c06\u5e94\u6536/\u4ed8\u6309\u5355\u636e\u79d1\u76ee\u5bf9\u8d26\u660e\u7ec6\u8868\uff08finalTempTable\uff09\u6570\u636e\u6309\u7ef4\u5ea6\u3010\u516c\u53f8\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u5e01\u522b\u3001\u5458\u5de5\u3001\u90e8\u95e8\uff08\u884c\u653f\u7ec4\u7ec7\uff09\u3001\u79d1\u76ee\u3001\u4f59\u989d\u7c7b\u578b\u3011\u6c47\u603b\u5230\u5206\u7ec4\u6c47\u603b\u4e34\u65f6\u8868\uff08tempAcctBalTable\uff09");
        KsqlUtil.execute((Context)this.ctx, (String)groupSQL.toString());
    }

    protected void groupTempToFinalAcctBalTable() throws BOSException {
        StringBuilder groupSQL = CommonServerUtils.getBillAccountBalanceInsertSQL(this.finalAcctBalTable);
        groupSQL.append("SELECT ").append(" NEWBOSID('").append(this.getBalanceBosType()).append("') AS FID, ").append("\r\n");
        groupSQL.append(" FBALTYPE, FCOMPANYID, MAX(FPERIODID) AS FPERIODID, FCURRENCYID, ").append("\r\n").append("SUM(FBEGINBALANCEFOR) AS FBEGINBALANCEFOR, SUM(FDEBITFOR) AS FDEBITFOR, SUM(FCREDITFOR) AS FCREDITFOR, ").append("\r\n").append("SUM(FYEARDEBITFOR) AS FYEARDEBITFOR, SUM(FYEARCREDITFOR) AS FYEARCREDITFOR, SUM(FENDBALANCEFOR) AS FENDBALANCEFOR, ").append("\r\n").append("SUM(FBEGINBALANCELOCAL) AS FBEGINBALANCELOCAL, SUM(FDEBITLOCAL) AS FDEBITLOCAL, SUM(FCREDITLOCAL) AS FCREDITLOCAL, ").append("\r\n").append("SUM(FYEARDEBITLOCAL) AS FYEARDEBITLOCAL, SUM(FYEARCREDITLOCAL) AS FYEARCREDITLOCAL, SUM(FENDBALANCELOCAL) AS FENDBALANCELOCAL, ").append("\r\n").append("FASSTACTTYPEID, FASSTACTID, FACCOUNT, FADMINORGUNITID, FPERSONID ").append("\r\n").append("FROM ").append(this.tempAcctBalTable).append("\r\n").append("GROUP BY ").append(" FCOMPANYID, FASSTACTTYPEID, FASSTACTID, FCURRENCYID, \r\n FPERSONID, FADMINORGUNITID, FACCOUNT , FBALTYPE");
        this.logger.info("groupTempToFinalAcctBalTable()=>\u5c06\u4f59\u989d\u4e34\u65f6\u8868\uff08tempAcctBalTable\uff09\u4e2d\u7684\u671f\u521d+\u672c\u671f\u53d1\u751f\u6570\u636e\u6309\u7ef4\u5ea6\u3010\u516c\u53f8\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u5e01\u522b\u3001\u5458\u5de5\u3001\u90e8\u95e8\uff08\u884c\u653f\u7ec4\u7ec7\uff09\u3001\u79d1\u76ee\u3001\u4f59\u989d\u7c7b\u578b\u3011\u6c47\u603b\u5230\u6700\u7ec8\u4f59\u989d\u4e34\u65f6\u8868\uff08finalAcctBalTable\uff09");
        KsqlUtil.execute((Context)this.ctx, (String)groupSQL.toString());
    }

    protected void calculateBalance() throws BOSException, EASBizException {
        boolean needSummary = !this.param.isQueryAll() || this.param.isQueryAll() && this.param.isCalculateOpposite();
        try {
            if (!this.param.isCalculateOpposite()) {
                this.timer.reset();
                CommonServerUtils.copyBillAccountBalanceDataForContrast(this.ctx, ArApBillAccountBalanceCalculator.getBalanceTable(this.isAr), this.tempAcctBalTable, this.orgUnitID, this.curPeriod.getId().toString());
                this.logger.info("\u63d2\u5165\u5f53\u524d\u671f\u95f4\u7684\u671f\u521d\u79d1\u76ee\u4f59\u989d\u5230\u4e34\u65f6\u5355\u636e\u79d1\u76ee\u4f59\u989d\u8868\u4e2d\u82b1\u8d39\uff1a" + this.timer.msValue());
            }
            this.timer.reset();
            this.takeBillData();
            this.logger.info("\u6839\u636e\u6a21\u578b\u53d6\u6570\u914d\u7f6e\u4fe1\u606f\u53d6\u6570\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e==================");
            this.invokePlugInHandler(InvokeTime.AfterDetailData);
            this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u660e\u7ec6\u6570\u636e\u7ed3\u675f\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
            if (CommonUtils.isNotEmpty(this.recPaySceneNumberSet)) {
                this.timer.reset();
                this.sumRecPayBillAmount();
                this.logger.info("\u6839\u636e\u5e94\u6536/\u4ed8\u5bf9\u8d26\u79d1\u76ee-\u8d1f\u6570\u5355\u636e\u53d6\u503c\u914d\u7f6e\uff0c\u5c06\u660e\u7ec6\u4e34\u65f6\u8868\uff08detailTempTable\uff09\u4e2d\u6536/\u4ed8\u6b3e\u5355\u6570\u636e\u6309\u7ef4\u5ea6\u3010\u516c\u53f8\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u5e01\u522b\u3001\u5458\u5de5\u3001\u90e8\u95e8\uff08\u884c\u653f\u7ec4\u7ec7\uff09\u3001\u79d1\u76ee\u3011\u6c47\u603b\u5230\u5206\u7ec4\u6c47\u603b\u4e34\u65f6\u8868\uff08finalTempTable\uff09\u82b1\u8d39\uff1a" + this.timer.msValue());
            }
            this.timer.reset();
            this.groupDetailDataToFinalTable();
            this.logger.info("\u5c06\u660e\u7ec6\u4e34\u65f6\u8868\uff08detailTempTable\uff09\u6570\u636e\u6309\u7ef4\u5ea6\u3010\u5355\u636e\u3001\u516c\u53f8\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u5e01\u522b\u3001\u5458\u5de5\u3001\u90e8\u95e8\uff08\u884c\u653f\u7ec4\u7ec7\uff09\u3001\u79d1\u76ee\u3011\u6c47\u603b\u5230\u5206\u7ec4\u6c47\u603b\u4e34\u65f6\u8868\uff08finalTempTable\uff09\u82b1\u8d39\uff1a" + this.timer.msValue());
            this.timer.reset();
            this.logger.info("==================\u5f00\u59cb\u8c03\u7528\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e==================");
            this.invokePlugInHandler(InvokeTime.AfterFinalData);
            this.logger.info("==================\u63d2\u4ef6\u5904\u7406\u6700\u7ec8\u6570\u636e\u7ed3\u675f\uff0c\u82b1\u8d39\uff1a" + this.timer.msValue() + "==================");
            if (needSummary) {
                if (CommonUtils.isNotEmpty(this.bizBillSceneNumberSet)) {
                    this.timer.reset();
                    this.updateFinalDataBizBalType();
                    this.logger.info("\u66f4\u65b0\u5e94\u6536/\u4ed8\u6309\u5355\u636e\u79d1\u76ee\u5bf9\u8d26\u660e\u7ec6\u8868\u3010" + this.finalTempTable + "\u3011\u4e2d\uff08\u4e1a\u52a1\u5355\u636e\u4f59\u989d\uff1a10\uff09\u82b1\u8d39\uff1a" + this.timer.msValue());
                }
                this.timer.reset();
                this.groupFinalDataToTempAcctBalTable();
                this.logger.info("\u5c06\u5e94\u6536/\u4ed8\u6309\u5355\u636e\u79d1\u76ee\u5bf9\u8d26\u660e\u7ec6\u8868\uff08finalTempTable\uff09\u6570\u636e\u6309\u7ef4\u5ea6\u3010\u516c\u53f8\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u5e01\u522b\u3001\u5458\u5de5\u3001\u90e8\u95e8\uff08\u884c\u653f\u7ec4\u7ec7\uff09\u3001\u79d1\u76ee\u3001\u4f59\u989d\u7c7b\u578b\u3011\u5206\u7ec4\u6c47\u603b\u5230\u4f59\u989d\u4e34\u65f6\u8868\uff08tempAcctBalTable\uff09\u82b1\u8d39\uff1a" + this.timer.msValue());
                this.timer.reset();
                this.groupTempToFinalAcctBalTable();
                this.logger.info("\u5c06\u4f59\u989d\u4e34\u65f6\u8868\uff08tempAcctBalTable\uff09\u4e2d\u7684\u671f\u521d+\u672c\u671f\u53d1\u751f\u6570\u636e\u6309\u7ef4\u5ea6\u3010\u516c\u53f8\u3001\u5f80\u6765\u7c7b\u578b\u3001\u5f80\u6765\u6237\u3001\u5e01\u522b\u3001\u5458\u5de5\u3001\u90e8\u95e8\uff08\u884c\u653f\u7ec4\u7ec7\uff09\u3001\u79d1\u76ee\u3001\u4f59\u989d\u7c7b\u578b\u3011\u6c47\u603b\u5230\u6700\u7ec8\u4f59\u989d\u4e34\u65f6\u8868\uff08finalAcctBalTable\uff09\u82b1\u8d39\uff1a" + this.timer.msValue());
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (needSummary) {
                TempTableUtil.releasTempTable(this.ctx, this.tempAcctBalTable);
                TempTableUtil.releasTempTable(this.ctx, this.detailTempTable);
            }
        }
    }

    protected void reversePreperiodBalance() throws BalanceModelException, BOSException {
    }

    private String getOppositePostiveScenenumber(String negativeSceneNumber) {
        return negativeSceneNumber + "-Positive";
    }

    private void initNegativeToPositveSceneNumberMap() {
        this.logger.debug("=>\u521d\u59cb\u5316\u6536/\u4ed8\u6b3e\u5355\u4e1a\u52a1\u573a\u666f\uff1a\u53d6\u8d1f\u6570\u548c\u5bf9\u5e94\u53d6\u6b63\u6570\u7684\u4e1a\u52a1\u573a\u666f\u7f16\u7801\u6620\u5c04\u5173\u7cfb\uff1a\u7528\u4e8e\u8f6c\u6362\u5bf9\u65b9\u6b63\u6570\u4e1a\u52a1\u573a\u666f\u7f16\u7801");
        this.recPayScenceNumberMap.put("60201", "60211");
        this.recPayScenceNumberMap.put("60202", "60212");
        this.recPayScenceNumberMap.put("60203", "60213");
        this.recPayScenceNumberMap.put("60301", "60311");
        this.recPayScenceNumberMap.put("60401", "60411");
        this.recPayScenceNumberMap.put("70201", "70211");
        this.recPayScenceNumberMap.put("70202", "70212");
        this.recPayScenceNumberMap.put("70203", "70213");
        this.recPayScenceNumberMap.put("70301", "70311");
        this.recPayScenceNumberMap.put("70401", "70411");
        if (this.recPayScenceNumberMap.size() != this.recPaySceneNumberSet.size()) {
            Iterator<String> it = this.recPaySceneNumberSet.iterator();
            String negativeSceneNumber = null;
            while (it.hasNext()) {
                negativeSceneNumber = it.next();
                if (this.recPayScenceNumberMap.containsKey(negativeSceneNumber)) continue;
                this.recPayScenceNumberMap.put(negativeSceneNumber, this.getOppositePostiveScenenumber(negativeSceneNumber));
            }
        }
    }

    protected List<ISQLBuilder> getSQLBuilder() {
        List sqlBuilderList = super.getSQLBuilder();
        this.recPaySceneNumberSet = new HashSet<String>();
        this.recPaySceneNumberCondition = null;
        this.recPaySceneNumberSet.addAll(this.recPayDebitSceneNumberSet);
        this.recPaySceneNumberSet.addAll(this.recPayCreditSceneNumberSet);
        this.initNegativeToPositveSceneNumberMap();
        return sqlBuilderList;
    }

    protected ArApBillAccountBalanceSQLBuilder createSQLBuilderExt(BalanceDataModelInfo dataModelInfo) {
        return null;
    }

    protected ISQLBuilder createSQLBuilder(BalanceDataModelInfo dataModelInfo) {
        ArApBillAccountBalanceSQLBuilder sqlBuilder = this.createSQLBuilderExt(dataModelInfo);
        if (null != sqlBuilder) {
            sqlBuilder.setAr(this.isAr).setParam(this.param);
            return sqlBuilder;
        }
        sqlBuilder = new ArApBillAccountBalanceSQLBuilder(this.balanceModelInfo, dataModelInfo, this.orgUnitID, this.curPeriod).setAr(this.isAr).setParam(this.param);
        if (dataModelInfo.getNumber().startsWith("60101") || dataModelInfo.getNumber().startsWith("60601") || dataModelInfo.getNumber().startsWith("70101") || dataModelInfo.getNumber().startsWith("70601")) {
            this.bizBillSceneNumberSet.add(dataModelInfo.getNumber());
            if (!this.param.isIncludeBizBill()) {
                return null;
            }
            return sqlBuilder;
        }
        if (this.param.isCash() ? dataModelInfo.getNumber().startsWith("60103") || dataModelInfo.getNumber().startsWith("60602") || dataModelInfo.getNumber().startsWith("70102") || dataModelInfo.getNumber().startsWith("70602") : dataModelInfo.getNumber().startsWith("60102") || dataModelInfo.getNumber().startsWith("60603") || dataModelInfo.getNumber().startsWith("70103") || dataModelInfo.getNumber().startsWith("70603")) {
            return sqlBuilder;
        }
        if (dataModelInfo.getNumber().startsWith("60104") || dataModelInfo.getNumber().startsWith("70104")) {
            return sqlBuilder;
        }
        if (this.param.isCash()) {
            if (dataModelInfo.getNumber().startsWith("60202") || dataModelInfo.getNumber().startsWith("70201")) {
                if (this.isAr) {
                    this.recPayCreditSceneNumberSet.add(dataModelInfo.getNumber());
                } else {
                    this.recPayDebitSceneNumberSet.add(dataModelInfo.getNumber());
                }
                return sqlBuilder;
            }
        } else if (dataModelInfo.getNumber().startsWith("60201") || dataModelInfo.getNumber().startsWith("70202")) {
            if (this.isAr) {
                this.recPayCreditSceneNumberSet.add(dataModelInfo.getNumber());
            } else {
                this.recPayDebitSceneNumberSet.add(dataModelInfo.getNumber());
            }
            return sqlBuilder;
        }
        if (dataModelInfo.getNumber().startsWith("60203") || dataModelInfo.getNumber().startsWith("60301") || dataModelInfo.getNumber().startsWith("60401") || dataModelInfo.getNumber().startsWith("70203") || dataModelInfo.getNumber().startsWith("70301") || dataModelInfo.getNumber().startsWith("70401")) {
            if (this.isAr) {
                this.recPayDebitSceneNumberSet.add(dataModelInfo.getNumber());
            } else {
                this.recPayCreditSceneNumberSet.add(dataModelInfo.getNumber());
            }
            return sqlBuilder;
        }
        if (this.param.isPreRecPayAcct() && (dataModelInfo.getNumber().startsWith("60302") || dataModelInfo.getNumber().startsWith("70302"))) {
            return sqlBuilder;
        }
        if (dataModelInfo.getNumber().startsWith("60303") || dataModelInfo.getNumber().startsWith("60402") || dataModelInfo.getNumber().startsWith("60501") || dataModelInfo.getNumber().startsWith("70303") || dataModelInfo.getNumber().startsWith("70402") || dataModelInfo.getNumber().startsWith("70501")) {
            return sqlBuilder;
        }
        if (dataModelInfo.getNumber().startsWith("60701") || dataModelInfo.getNumber().startsWith("60304")) {
            return sqlBuilder;
        }
        return null;
    }
}

