/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.combTrans.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillInvoiceCollection;
import com.kingdee.eas.fi.ap.OtherBillInvoiceInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.app.combTrans.AbstractCombTransferHandler;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ApOtherBillCombTransferImpl
extends AbstractCombTransferHandler {
    private int count = 0;
    private static final String RESOURCE2_NAME = "com.kingdee.eas.fi.ar.ArApBillResource";

    @Override
    public Map innerCombTransfer() throws BOSException {
        Map<String, String> result = new HashMap<String, String>();
        if (this.count > 500) {
            result.put("errorMsg", this.getResourceStr("EXCESSIVE_DIFF") + this.getResourceStr("COMBTRANS_ERROR"));
            return result;
        }
        ++this.count;
        this.adjustDiff(this.getEntryList());
        if (this.getDiff().compareTo(BigDecimal.ZERO) != 0) {
            result = this.innerCombTransfer();
        }
        return result;
    }

    @Override
    public void adjustDiff(List<CoreBillEntryBaseInfo> list) {
        if (list.size() == 0) {
            return;
        }
        Collections.sort(list, this.getComparator());
        BigDecimal allocationNum = this.getAllocationNum();
        for (int i = 0; i < list.size(); ++i) {
            BigDecimal allAmount;
            OtherBillentryInfo entryInfo = (OtherBillentryInfo)list.get(i);
            if (entryInfo.get("invoiceEntryId") != null || entryInfo.getTaxRate() == null || entryInfo.getTaxRate().compareTo(BigDecimal.ZERO) == 0) continue;
            if (this.diff.abs().compareTo(allocationNum.abs()) >= 0) {
                allAmount = allocationNum;
                this.diff = this.diff.subtract(allocationNum);
            } else {
                allAmount = this.diff;
                this.diff = BigDecimal.ZERO;
            }
            BigDecimal taxAmount = entryInfo.getTaxAmount();
            BigDecimal racPayAmount = entryInfo.getRecievePayAmount();
            taxAmount = taxAmount.add(allAmount);
            if (taxAmount.multiply(racPayAmount).compareTo(BigDecimal.ZERO) < 0 || taxAmount.abs().compareTo(racPayAmount.abs()) > 0) {
                this.diff = this.diff.add(allAmount);
                continue;
            }
            if (allAmount.compareTo(BigDecimal.ZERO) != 0) {
                this.computeAmount((CoreBillEntryBaseInfo)entryInfo, allAmount);
                this.getEntryIdSet().add(entryInfo.getId().toString());
            }
            if (this.diff.compareTo(BigDecimal.ZERO) == 0) break;
        }
    }

    @Override
    public void doSumEntry(CoreBillBaseCollection billColl) {
        for (int i = 0; i < billColl.size(); ++i) {
            OtherBillInfo bill = (OtherBillInfo)billColl.get(i);
            bill.sumEntry();
        }
    }

    @Override
    public String getLogItem() {
        return "";
    }

    @Override
    public String getPermissionItem() {
        return "";
    }

    @Override
    public void computeAmount(CoreBillEntryBaseInfo entry, BigDecimal allAmount) {
        OtherBillentryInfo entryInfo = (OtherBillentryInfo)entry;
        ArApBillBaseInfo info = (ArApBillBaseInfo)this.getBillMap().get(entryInfo.getId().toString());
        if (info.getCompany() == null || info.getCompany().getBaseCurrency() == null || info.getCurrency() == null) {
            return;
        }
        int basePrecision = info.getCompany().getBaseCurrency().getPrecision();
        int precision = info.getCurrency().getPrecision();
        BigDecimal taxAmount = entryInfo.getTaxAmount() == null ? BigDecimal.ZERO : entryInfo.getTaxAmount();
        BigDecimal recPayAmount = entryInfo.getRecievePayAmount() == null ? BigDecimal.ZERO : entryInfo.getRecievePayAmount();
        BigDecimal amount = entryInfo.getAmount() == null ? BigDecimal.ZERO : entryInfo.getAmount();
        taxAmount = taxAmount.add(allAmount).setScale(precision, 4);
        entryInfo.setTaxAmount(taxAmount);
        BigDecimal taxAmountLocal = this.calLocAmount(taxAmount, basePrecision, info.getCompany().getBaseCurrency(), info.getCurrency());
        entryInfo.setTaxAmountLocal(this.calLocAmount(taxAmount, basePrecision, info.getCompany().getBaseCurrency(), info.getCurrency()));
        entryInfo.setInvoiceReqAmount(BigDecimal.ZERO);
        entryInfo.setInvoiceReqAmountLocal(BigDecimal.ZERO);
        entryInfo.setUnInvoiceReqAmount(recPayAmount);
        entryInfo.setUnInvoiceReqAmountLocal(this.calLocAmount(recPayAmount, basePrecision, info.getCompany().getBaseCurrency(), info.getCurrency()));
        amount = recPayAmount.subtract(taxAmount).setScale(precision, 4);
        entryInfo.setAmount(amount);
        entryInfo.setAmountLocal(this.calLocAmount(amount, basePrecision, info.getCompany().getBaseCurrency(), info.getCurrency()));
        entryInfo.setLocalUnwriteOffAmount(entryInfo.getAmountLocal().subtract(entryInfo.getLocalWrittenOffAmount() == null ? BigDecimal.ZERO : entryInfo.getLocalWrittenOffAmount()));
    }

    private BigDecimal calLocAmount(BigDecimal amount, int basePrecision, CurrencyInfo baseCurrency, CurrencyInfo currency) {
        BigDecimal locaAmount = BigDecimal.ZERO;
        if (baseCurrency.getId().toString().equals(currency.getId().toString())) {
            locaAmount = new BigDecimal(amount.toString());
        }
        return locaAmount;
    }

    @Override
    public void init() {
        super.init();
    }

    @Override
    public Map initData() throws BOSException {
        super.initData();
        return this.getInitData();
    }

    public String getResourceStr(String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.CombTransResource", (String)key, (Locale)this.getCtx().getLocale());
    }

    public String getResourceStr(String key, Object[] param) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.CombTransResource", (String)key, (Locale)this.getCtx().getLocale(), (Object[])param);
    }

    @Override
    public Comparator<CoreBillEntryBaseInfo> getComparator() {
        return new Comparator<CoreBillEntryBaseInfo>(){

            @Override
            public int compare(CoreBillEntryBaseInfo arg0, CoreBillEntryBaseInfo arg1) {
                return ((OtherBillentryInfo)arg1).getTaxAmount().abs().compareTo(((OtherBillentryInfo)arg0).getTaxAmount().abs());
            }
        };
    }

    @Override
    public Map<String, String> checkData(List idList) throws BOSException {
        return new HashMap<String, String>();
    }

    @Override
    public void calDiff() {
        this.init();
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal invoiceTaxAmt = BigDecimal.ZERO;
        List<CoreBillEntryBaseInfo> billList = null;
        billList = this.getEntryList();
        if (billList.size() == 0) {
            return;
        }
        OtherBillInfo billInfo = (OtherBillInfo)this.getBillMap().get(billList.get(0).getId().toString());
        for (int i = 0; i < billList.size(); ++i) {
            OtherBillentryInfo entry = (OtherBillentryInfo)billList.get(i);
            taxAmt = taxAmt.add(entry.getTaxAmount());
        }
        OtherBillInvoiceCollection invoiceCollection = billInfo.getOtherBillInvoice();
        for (int i = 0; i < invoiceCollection.size(); ++i) {
            BigDecimal tax = invoiceCollection.get(i).getTax();
            if (null == tax) continue;
            invoiceTaxAmt = invoiceTaxAmt.add(tax);
        }
        this.setDiff(invoiceTaxAmt.subtract(taxAmt));
    }

    @Override
    public SelectorItemCollection getSelect() {
        SelectorItemCollection sic = super.getSelect();
        sic.add("currency.precision");
        sic.add("isInTax");
        sic.add("entry.taxRate");
        sic.add("otherBillInvoice.tax");
        sic.add("otherBillInvoice.taxAmount");
        sic.addObjectCollection((IObjectCollection)this.getUpdateSelect());
        return sic;
    }

    @Override
    public SelectorItemCollection getUpdateSelect() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("amount");
        sic.add("amountLocal");
        sic.add("totalAmount");
        sic.add("totalAmountLocal");
        sic.add("totalTax");
        sic.add("totalTaxLocal");
        sic.add("entry.recievePayAmount");
        sic.add("entry.recievePayAmountLocal");
        sic.add("entry.amount");
        sic.add("entry.amountLocal");
        sic.add("entry.taxAmount");
        sic.add("entry.taxAmountLocal");
        sic.add("entry.invoiceReqAmount");
        sic.add("entry.invoiceReqAmountLocal");
        sic.add("entry.unInvoiceReqAmount");
        sic.add("entry.unInvoiceReqAmountLocal");
        sic.add("entry.localUnwriteOffAmount");
        return sic;
    }

    @Override
    public boolean checkEntryForCombTransfer(CoreBillEntryBaseInfo entry) {
        OtherBillentryInfo entryInfo = (OtherBillentryInfo)entry;
        if (entryInfo.getMaterial() == null && entryInfo.getExpenseItem() == null && entryInfo.getMaterialName() == null) {
            return false;
        }
        if (entryInfo.getTaxAmount() == null || entryInfo.getTaxAmount().compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        if (entryInfo.getTaxAmountLocal() == null || entryInfo.getTaxAmountLocal().compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        if (entryInfo.getId() == null) {
            entryInfo.setId(BOSUuid.create((BOSObjectType)entryInfo.getBOSType()));
        }
        return true;
    }

    @Override
    public void checkBeforeCombTransfer(CoreBillBaseCollection billColl) throws EASBizException, BOSException {
        super.checkBeforeCombTransfer(billColl);
        this.checkIsInQueue(this.getCtx(), (OtherBillInfo)billColl.get(0));
        for (int i = billColl.size() - 1; i >= 0; --i) {
            int j;
            OtherBillInfo billInfo = (OtherBillInfo)billColl.get(i);
            BigDecimal recPayAmountLocal = BigDecimal.ZERO;
            BigDecimal invoiceTaxAmount = BigDecimal.ZERO;
            OtherBillentryCollection entryColl = billInfo.getEntry();
            OtherBillInvoiceCollection invoiceColl = billInfo.getOtherBillInvoice();
            for (j = 0; j < entryColl.size(); ++j) {
                if (entryColl.get(j).getRecievePayAmountLocal() == null) continue;
                recPayAmountLocal = recPayAmountLocal.add(entryColl.get(j).getRecievePayAmountLocal());
            }
            for (j = 0; j < invoiceColl.size(); ++j) {
                if (invoiceColl.get(j).getTaxAmount() == null) continue;
                invoiceTaxAmount = invoiceTaxAmount.add(invoiceColl.get(j).getTaxAmount());
            }
            CompanyOrgUnitInfo company = billInfo.getCompany();
            if (billInfo.getCurrency() == null || company.getBaseCurrency() == null || !billInfo.getCurrency().getId().equals((Object)company.getBaseCurrency().getId())) {
                String msg = ResourceBase.getString((String)RESOURCE2_NAME, (String)"NotBaseCurrencyNotAdjust", (Locale)this.getCtx().getLocale());
                throw new ARAPVerifynException(ARAPVerifynException.COMMON, new String[]{msg});
            }
            if (billInfo.getOtherBillInvoice() == null || billInfo.getOtherBillInvoice().size() == 0 || this.isNullInvoice(billInfo.getOtherBillInvoice())) {
                String msg = ResourceBase.getString((String)RESOURCE2_NAME, (String)"InvoiceIsNullNotAdjust", (Locale)this.getCtx().getLocale());
                throw new ARAPVerifynException(ARAPVerifynException.COMMON, new String[]{msg});
            }
            if (recPayAmountLocal.compareTo(invoiceTaxAmount) == 0) continue;
            String msg = this.getResourceStr("TAXAMOUNT_DIFF");
            throw new ARAPVerifynException(ARAPVerifynException.COMMON, new String[]{msg});
        }
    }

    private boolean isNullInvoice(OtherBillInvoiceCollection coll) {
        OtherBillInvoiceInfo otherBillInvoiceInfo = null;
        for (int i = 0; i < coll.size(); ++i) {
            otherBillInvoiceInfo = coll.get(i);
            if (otherBillInvoiceInfo.getInvoiceCode() == null && otherBillInvoiceInfo.getInvoiceNumber() == null) continue;
            return false;
        }
        return true;
    }

    private void checkIsInQueue(Context ctx, OtherBillInfo otherBillInfo) throws BOSException, EASBizException {
        ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        String companyNumber = otherBillInfo.getCompany().getNumber();
        if (companyNumber == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(otherBillInfo.getCompany().getId()), sic);
            companyNumber = currentCompany.getNumber();
        }
        if (createJobFacade.checkDuplicateTask("SCM_FI_AP_001" + companyNumber)) {
            throw new OtherBillBizException(OtherBillBizException.ARCLOSRACCOUNTISINQUEUE);
        }
    }
}

