/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.combTrans.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.ICreateJobFacade;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.app.combTrans.AbstractCombTransferHandler;
import com.kingdee.eas.fi.arap.check.CheckService;
import com.kingdee.eas.fi.arap.check.formula.CheckFormulaFactory;
import com.kingdee.eas.fi.arap.check.impl.ExistDownBillBatchCheckImpl;
import com.kingdee.eas.fi.arap.check.impl.FieldsCheckImpl;
import com.kingdee.eas.fi.arap.check.impl.IsSameCheckImpl;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ArOtherBillCombTransferImpl
extends AbstractCombTransferHandler {
    private List<CoreBillEntryBaseInfo> fullWriteOffList = new ArrayList<CoreBillEntryBaseInfo>();
    private List<CoreBillEntryBaseInfo> someWriteOffList = new ArrayList<CoreBillEntryBaseInfo>();
    public static final String COMPLETE_WRITEOF_JOIN_TRANSFER = "COMPLETE_WRITEOF_JOIN_TRANSFER";
    private int count = 0;
    private Map<String, Boolean> isDirectExchangeCache = new HashMap<String, Boolean>();

    @Override
    public Map innerCombTransfer() throws BOSException, EASBizException {
        Map<String, String> result = new HashMap<String, String>();
        if (this.count > 500) {
            result.put("errorMsg", this.getResourceStr("EXCESSIVE_DIFF") + this.getResourceStr("COMBTRANS_ERROR"));
            return result;
        }
        ++this.count;
        this.adjustDiff(this.someWriteOffList);
        Boolean fullWriteOffJoinTransfer = (Boolean)this.getInitData().get(COMPLETE_WRITEOF_JOIN_TRANSFER);
        if (this.getDiff().compareTo(BigDecimal.ZERO) != 0 && !fullWriteOffJoinTransfer.booleanValue() && this.fullWriteOffList.size() > 0) {
            String errorMsg = this.getResourceStr("EXIST_FULL_WRITEOFENTRY");
            result.put("errorMsg", errorMsg);
            return result;
        }
        this.adjustDiff(this.fullWriteOffList);
        if (this.getDiff().compareTo(BigDecimal.ZERO) != 0) {
            result = this.innerCombTransfer();
        }
        return result;
    }

    @Override
    public void doSumEntry(CoreBillBaseCollection billColl) {
        for (int i = 0; i < billColl.size(); ++i) {
            OtherBillInfo bill = (OtherBillInfo)billColl.get(i);
            bill.sumEntry();
        }
    }

    @Override
    public String getLogItem() {
        return "ar_otherbill_CombTransfer";
    }

    @Override
    public String getPermissionItem() {
        return "fi_ar_ArOtherbill_CombTransfer";
    }

    @Override
    public void computeAmount(CoreBillEntryBaseInfo entry, BigDecimal allAmount) throws EASBizException, BOSException {
        OtherBillentryInfo entryInfo = (OtherBillentryInfo)entry;
        ArApBillBaseInfo info = (ArApBillBaseInfo)this.getBillMap().get(entryInfo.getId().toString());
        if (info.getCompany() == null || info.getCompany().getBaseCurrency() == null || info.getCurrency() == null) {
            return;
        }
        int basePrecision = info.getCompany().getBaseCurrency().getPrecision();
        int precision = info.getCurrency().getPrecision();
        BigDecimal taxAmount = entryInfo.getTaxAmount() == null ? BigDecimal.ZERO : entryInfo.getTaxAmount();
        BigDecimal recPayAmount = entryInfo.getRecievePayAmount() == null ? BigDecimal.ZERO : entryInfo.getRecievePayAmount();
        BigDecimal recPayAmountLocal = entryInfo.getRecievePayAmountLocal() == null ? BigDecimal.ZERO : entryInfo.getRecievePayAmountLocal();
        taxAmount = taxAmount.add(allAmount).setScale(precision, 4);
        entryInfo.setTaxAmount(taxAmount);
        BigDecimal taxAmountLocal = this.calLocAmount(info, taxAmount, basePrecision, info.getCompany().getBaseCurrency(), info.getCurrency());
        entryInfo.setTaxAmountLocal(taxAmountLocal);
        entryInfo.setInvoiceReqAmount(BigDecimal.ZERO);
        entryInfo.setInvoiceReqAmountLocal(BigDecimal.ZERO);
        entryInfo.setUnInvoiceReqAmount(recPayAmount);
        entryInfo.setUnInvoiceReqAmountLocal(recPayAmountLocal);
        BigDecimal amount = recPayAmount.subtract(taxAmount).setScale(precision, 4);
        BigDecimal amountLocal = recPayAmountLocal.subtract(taxAmountLocal).setScale(basePrecision, 4);
        entryInfo.setAmount(amount);
        entryInfo.setAmountLocal(amountLocal);
        entryInfo.setLocalUnwriteOffAmount(entryInfo.getAmountLocal().subtract(entryInfo.getLocalWrittenOffAmount() == null ? BigDecimal.ZERO : entryInfo.getLocalWrittenOffAmount()));
    }

    private BigDecimal calLocAmount(ArApBillBaseInfo info, BigDecimal amount, int basePrecision, CurrencyInfo baseCurrency, CurrencyInfo currency) throws BOSException, EASBizException {
        BigDecimal locaAmount = BigDecimal.ZERO;
        if (baseCurrency.getId().toString().equals(currency.getId().toString())) {
            locaAmount = new BigDecimal(amount.toString());
        } else {
            if (info.getExchangeRate() == null) {
                return amount;
            }
            String key = info.getId().toString();
            boolean isDirectExchange = true;
            if (this.isDirectExchangeCache.get(key) == null) {
                ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(this.getCtx(), info.getCompany(), info.getCurrency(), info.getBillDate());
                isDirectExchange = BaseDataUtil.isDirectExchangeRate(rateInfo);
                this.isDirectExchangeCache.put(key, isDirectExchange);
            }
            isDirectExchange = this.isDirectExchangeCache.get(key);
            locaAmount = BaseDataUtil.caculateLocalAmount(amount, info.getExchangeRate(), isDirectExchange, basePrecision);
        }
        return locaAmount;
    }

    @Override
    public void init() {
        super.init();
        this.fullWriteOffList.clear();
        this.someWriteOffList.clear();
        for (int i = 0; i < this.getEntryList().size(); ++i) {
            BigDecimal baseQty;
            OtherBillentryInfo entry = (OtherBillentryInfo)this.getEntryList().get(i);
            BigDecimal writeOffBaseQty = entry.getWittenOffBaseQty() == null ? BigDecimal.ZERO : entry.getWittenOffBaseQty();
            BigDecimal bigDecimal = baseQty = entry.getBaseQty() == null ? BigDecimal.ZERO : entry.getBaseQty();
            if (writeOffBaseQty.compareTo(BigDecimal.ZERO) != 0 && writeOffBaseQty.compareTo(baseQty) == 0) {
                this.fullWriteOffList.add((CoreBillEntryBaseInfo)entry);
                continue;
            }
            this.someWriteOffList.add((CoreBillEntryBaseInfo)entry);
        }
    }

    @Override
    public Map initData() throws BOSException {
        super.initData();
        if (this.getInitData().get(COMPLETE_WRITEOF_JOIN_TRANSFER) == null) {
            StringBuffer sql = new StringBuffer("select FValue from T_ARAP_CommonParam ");
            sql.append(" where fnumber='").append(COMPLETE_WRITEOF_JOIN_TRANSFER).append("'");
            boolean val = false;
            IRowSet rowSet = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString());
            try {
                if (rowSet.next()) {
                    String value = rowSet.getString("fvalue");
                    val = Boolean.valueOf(value);
                    this.getInitData().put(COMPLETE_WRITEOF_JOIN_TRANSFER, val);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return this.getInitData();
    }

    public String getResourceStr(String key) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.CombTransResource", (String)key, (Locale)this.getCtx().getLocale());
    }

    public String getResourceStr(String key, Object[] param) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.arap.CombTransResource", (String)key, (Locale)this.getCtx().getLocale(), (Object[])param);
    }

    @Override
    public Comparator<CoreBillEntryBaseInfo> getComparator() {
        return new Comparator<CoreBillEntryBaseInfo>(){

            @Override
            public int compare(CoreBillEntryBaseInfo arg0, CoreBillEntryBaseInfo arg1) {
                return ((OtherBillentryInfo)arg1).getTaxAmount().abs().compareTo(((OtherBillentryInfo)arg0).getTaxAmount().abs());
            }
        };
    }

    @Override
    public Map<String, String> checkData(List idList) throws BOSException {
        CheckService checkService = new CheckService(this.getCtx(), idList);
        checkService.addCheck(new IsSameCheckImpl("company.id", this.getResourceStr("COMPANY_NOT_SAME"), true));
        checkService.addCheck(new IsSameCheckImpl("currency.id", this.getResourceStr("CURRENCY_NOT_SAME"), true));
        checkService.addCheck(new IsSameCheckImpl("isInTax", this.getResourceStr("INTAX_NOT_SAME"), true));
        checkService.addCheck(new IsSameCheckImpl("isPriceWithoutTax", this.getResourceStr("INPRICE_NOT_SAME"), true));
        checkService.addCheck(new ExistDownBillBatchCheckImpl(this.getResourceStr("BILL_HAS_NEXTBILL"), true));
        checkService.addCheck(new FieldsCheckImpl(CheckFormulaFactory.getCheckFormual("=", "billStatus", -1), this.getResourceStr("BILL_HAS_DELETED"), true));
        checkService.addCheck(new IsSameCheckImpl("asstActID", this.getResourceStr("ASSTACT_NOT_SAME"), false));
        checkService.addCheck(new FieldsCheckImpl(CheckFormulaFactory.getCheckFormual("=", "isBizBill", true), this.getResourceStr("BIZ_BILL_CANNOT_DIFF"), true));
        return checkService.check();
    }

    @Override
    public void calDiff() {
        this.init();
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal recPayAmt = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        List<CoreBillEntryBaseInfo> billList = null;
        billList = this.getEntryList();
        if (billList.size() == 0) {
            return;
        }
        OtherBillInfo billInfo = (OtherBillInfo)this.getBillMap().get(billList.get(0).getId().toString());
        int precision = billInfo.getCurrency().getPrecision();
        for (int i = 0; i < billList.size(); ++i) {
            OtherBillentryInfo entry = (OtherBillentryInfo)billList.get(i);
            amount = amount.add(entry.getAmount());
            recPayAmt = recPayAmt.add(entry.getRecievePayAmount());
            if (taxRate.compareTo(BigDecimal.ZERO) != 0) continue;
            taxRate = entry.getTaxRate();
        }
        taxRate = BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP));
        BigDecimal realAmount = recPayAmt.divide(taxRate, precision, RoundingMode.HALF_UP);
        this.setDiff(amount.subtract(realAmount));
    }

    @Override
    public SelectorItemCollection getSelect() {
        SelectorItemCollection sic = super.getSelect();
        sic.add("currency.precision");
        sic.add("isInTax");
        sic.add("exchangeRate");
        sic.add("entry.taxRate");
        sic.add("entry.unwriteOffBaseQty");
        sic.add("entry.wittenOffBaseQty");
        sic.add("entry.baseQty");
        sic.add("entry.isQtyZero");
        sic.addObjectCollection((IObjectCollection)this.getUpdateSelect());
        return sic;
    }

    @Override
    public SelectorItemCollection getUpdateSelect() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("amount");
        sic.add("amountLocal");
        sic.add("totalAmount");
        sic.add("totalAmountLocal");
        sic.add("totalTax");
        sic.add("totalTaxLocal");
        sic.add("entry.recievePayAmount");
        sic.add("entry.recievePayAmountLocal");
        sic.add("entry.amount");
        sic.add("entry.amountLocal");
        sic.add("entry.taxAmount");
        sic.add("entry.taxAmountLocal");
        sic.add("entry.invoiceReqAmount");
        sic.add("entry.invoiceReqAmountLocal");
        sic.add("entry.unInvoiceReqAmount");
        sic.add("entry.unInvoiceReqAmountLocal");
        sic.add("entry.localUnwriteOffAmount");
        return sic;
    }

    @Override
    public boolean checkEntryForCombTransfer(CoreBillEntryBaseInfo entry) {
        return ((OtherBillentryInfo)entry).getTaxAmount().compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public void checkBeforeCombTransfer(CoreBillBaseCollection billColl) throws EASBizException, BOSException {
        super.checkBeforeCombTransfer(billColl);
        this.checkIsInQueue(this.getCtx(), (OtherBillInfo)billColl.get(0));
    }

    private void checkIsInQueue(Context ctx, OtherBillInfo otherBillInfo) throws BOSException, EASBizException {
        ICreateJobFacade createJobFacade = CreateJobFacadeFactory.getLocalInstance((Context)ctx);
        String companyNumber = otherBillInfo.getCompany().getNumber();
        if (companyNumber == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(otherBillInfo.getCompany().getId()), sic);
            companyNumber = currentCompany.getNumber();
        }
        if (createJobFacade.checkDuplicateTask("SCM_FI_AR_001" + companyNumber)) {
            throw new OtherBillBizException(OtherBillBizException.ARCLOSRACCOUNTISINQUEUE);
        }
    }
}

