/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.reverse.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseCollection;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.IncomeConfimBillInfo;
import com.kingdee.eas.fi.ar.IncomeConfimBillTypeEnum;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.app.ArApBillBaseControllerBean;
import com.kingdee.eas.fi.arap.app.reverse.impl.IncomeConfirmBillRelationReverseImpl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IncomeConfirmCoreBillReverseImpl
extends IncomeConfirmBillRelationReverseImpl {
    protected Map<String, BigDecimal> coreEntryUnReversedBaseQtyMap = new HashMap<String, BigDecimal>();

    public IncomeConfirmCoreBillReverseImpl(Context ctx, ArApBillBaseInfo baseInfo, ArApBillBaseControllerBean arapBaseControllerBean) {
        super(ctx, baseInfo, arapBaseControllerBean);
    }

    @Override
    public Map<String, String> queryBizBill(ArApBillBaseInfo baseInfo) throws BOSException {
        HashMap<String, String> bizBillMap = new HashMap<String, String>();
        IncomeConfimBillInfo info = (IncomeConfimBillInfo)baseInfo;
        if (!info.getBillType().equals((Object)IncomeConfimBillTypeEnum.SALE_INCOME)) {
            return bizBillMap;
        }
        if (StringUtils.isEmpty((String)info.getEntry().get(0).getCoreBillEntryId())) {
            return super.queryBizBill(baseInfo);
        }
        StringBuffer sb = new StringBuffer(100);
        sb.append("SELECT ");
        sb.append(" bizentry.FParentID as billId,bizentry.FID as entryId");
        sb.append(" FROM T_AR_OtherBillEntry bizentry");
        sb.append(" INNER JOIN T_AR_OtherBill bizbill ON bizentry.FParentID = bizbill.FID WHERE ");
        sb.append(" FCOREBILLENTRYID in (SELECT FCOREBILLENTRYID  FROM T_AR_IncomeConfimEntry where FPARENTID = '" + info.getId().toString() + "') ");
        sb.append(" AND bizBill.FCompanyID = ? AND bizBill.FBillType = ").append(102);
        sb.append(" AND bizBill.FIsBizBill = 1 AND bizBill.FBillStatus = ").append(3);
        sb.append(" ORDER BY bizentry.FCoreBillNumber, bizentry.FCoreBillEntrySeq, bizBill.FBillDate");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString(), (Object[])new Object[]{info.getCompany().getId().toString()});
        try {
            while (rowSet.next()) {
                bizBillMap.put(rowSet.getString("entryId"), rowSet.getString("billId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return bizBillMap;
    }

    @Override
    protected void calReverseQty() throws OtherBillBizException {
        super.calReverseQty();
        Map<String, ArApBillEntryBaseCollection> reverseCoreMap = this.getCoreReverseMap();
        this.getCoreUnReversedBaseQtyMap();
        Iterator<Map.Entry<String, BigDecimal>> it = this.coreEntryUnReversedBaseQtyMap.entrySet().iterator();
        Map.Entry<String, BigDecimal> me = null;
        boolean isEntryFullWf = false;
        block0: while (it.hasNext()) {
            me = it.next();
            BigDecimal totalUnReversedBaseQty = me.getValue();
            if (!reverseCoreMap.containsKey(me.getKey())) continue;
            ArApBillEntryBaseCollection reverseCoreColl = reverseCoreMap.get(me.getKey());
            for (int i = 0; i < reverseCoreColl.size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = reverseCoreColl.get(i);
                isEntryFullWf = this.isEntryFullWriteoffMap.get(entryInfo.getId().toString()) == null ? false : (Boolean)this.isEntryFullWriteoffMap.get(entryInfo.getId().toString());
                BigDecimal entryUnReversedBaseQty = (BigDecimal)entryInfo.get("UN_REVERSED_BASEQTY");
                if (totalUnReversedBaseQty.signum() * entryUnReversedBaseQty.signum() <= 0) continue;
                if (totalUnReversedBaseQty.abs().compareTo(entryUnReversedBaseQty.abs()) >= 0 || isEntryFullWf) {
                    totalUnReversedBaseQty = totalUnReversedBaseQty.subtract(entryUnReversedBaseQty);
                    entryInfo.setBaseQty(entryInfo.getBaseQty().add(entryUnReversedBaseQty));
                    entryInfo.put("IS_LAST_REVERSE_ENTRY", true);
                } else {
                    entryInfo.setBaseQty(entryInfo.getBaseQty().add(totalUnReversedBaseQty));
                    entryInfo.setAmount(this.ZERO);
                    entryInfo.setAmountLocal(this.ZERO);
                    entryInfo.setRecievePayAmount(this.ZERO);
                    entryInfo.setRecievePayAmountLocal(this.ZERO);
                    totalUnReversedBaseQty = this.ZERO;
                }
                if (!this.reversedEntrys.contains(entryInfo.getId())) {
                    this.reversedEntrys.add(entryInfo);
                }
                if (totalUnReversedBaseQty.signum() == 0) continue block0;
            }
        }
    }

    private Map<String, ArApBillEntryBaseCollection> getCoreReverseMap() {
        HashMap<String, ArApBillEntryBaseCollection> reverseCoreMap = new HashMap<String, ArApBillEntryBaseCollection>();
        Collection coll = this.reversedEntryInfoMap.values();
        for (ArApBillEntryBaseInfo entry : coll) {
            ArApBillEntryBaseCollection coreReverseColl;
            String coreBillEntryId = entry.getCoreBillEntryId();
            BigDecimal unReversedBaseQty = (BigDecimal)entry.get("UN_REVERSED_BASEQTY");
            if (unReversedBaseQty.compareTo(this.ZERO) == 0) continue;
            if (reverseCoreMap.get(coreBillEntryId) != null) {
                coreReverseColl = (ArApBillEntryBaseCollection)((Object)reverseCoreMap.get(coreBillEntryId));
            } else {
                coreReverseColl = new ArApBillEntryBaseCollection();
                reverseCoreMap.put(coreBillEntryId, coreReverseColl);
            }
            coreReverseColl.add(entry);
        }
        return reverseCoreMap;
    }

    private Map<String, BigDecimal> getCoreUnReversedBaseQtyMap() {
        AbstractObjectCollection entryColl = this.baseInfo.getEntries();
        for (int i = 0; i < entryColl.size(); ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryColl.getObject(i);
            String coreBillEntryId = entryInfo.getCoreBillEntryId();
            if (StringUtils.isEmpty((String)coreBillEntryId)) continue;
            if (this.coreEntryUnReversedBaseQtyMap.get(coreBillEntryId) != null) {
                this.coreEntryUnReversedBaseQtyMap.put(coreBillEntryId, this.coreEntryUnReversedBaseQtyMap.get(coreBillEntryId).add(entryInfo.getBaseQty()));
                continue;
            }
            this.coreEntryUnReversedBaseQtyMap.put(coreBillEntryId, entryInfo.getBaseQty());
        }
        return this.coreEntryUnReversedBaseQtyMap;
    }
}

