/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.service.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.APDisposeUtil;
import com.kingdee.eas.fi.ar.IOtherBill;
import com.kingdee.eas.fi.ar.IOtherBillentry;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.arap.DisposerActionEnum;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApSelectorFactory;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillEntryCollection;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.app.ArApRecPayServerHelper;
import com.kingdee.eas.fi.cas.app.service.handler.ServiceHandler;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class ArApServiceHandler
extends ServiceHandler {
    private static final String ARAP_RESOUREC = "com.kingdee.eas.fi.arap.ArapResource";
    private static Logger logger = Logger.getLogger((String)ArApServiceHandler.class.getName());
    private final String autoAssoNumber = "AutoNumberFromBTP_";
    private ArApRecPayServerHelper arapHelper = new ArApRecPayServerHelper();

    public void checkNumber(Context ctx, RecPayBillInfo info) throws BOSException, EASBizException {
        if (info.isIsImport()) {
            return;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codeRuleInfo = iCodingRuleManager.getCodingRule((IObjectValue)info, info.getCompany().getId().toString());
        boolean isSameNumber = this.isSameNumber(ctx, null, (IObjectValue)info);
        if (codeRuleInfo == null) {
            if (StringUtils.isEmpty((String)info.getNumber())) {
                info.setNumber(null);
            } else if (isSameNumber) {
                throw new CasForArApException(CasForArApException.CHECKNUMBERDUP, (Object[])new String[]{info.getNumber()});
            }
        } else if (codeRuleInfo.isIsaddnewbreak() && !PaymentBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId())) || isSameNumber || StringUtils.isEmpty((String)info.getNumber())) {
            this.getNewNumber(ctx, (IObjectValue)info, info.getCompany().getId().toString(), null);
        }
    }

    public IObjectValue getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (strCompanyID == null || strCompanyID.trim().length() == 0) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
            strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        }
        String number = "";
        RecPayBillInfo info = (RecPayBillInfo)model;
        number = iCodingRuleManager.getNumber((IObjectValue)info, strCompanyID, customString);
        info.setNumber(number);
        ObjectUuidPK pk = new ObjectUuidPK(info.getId());
        if (this.isSameNumber(ctx, (IObjectPK)pk, (IObjectValue)info)) {
            return this.getNewNumber(ctx, (IObjectValue)info, strCompanyID, customString);
        }
        return info;
    }

    public boolean isSameNumber(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        RecPayBillInfo recPayInfo = (RecPayBillInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)recPayInfo.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (recPayInfo.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)recPayInfo.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (recPayInfo.getCompany() != null) {
            filterItem = new FilterItemInfo("company.id", (Object)recPayInfo.getCompany().getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        } else {
            filterItem = new FilterItemInfo("company.id", (Object)ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (model instanceof PaymentBillInfo && PaymentBillFactory.getLocalInstance((Context)ctx).exists(filter)) {
            return true;
        }
        return model instanceof ReceivingBillInfo && ReceivingBillFactory.getLocalInstance((Context)ctx).exists(filter);
    }

    public void reverseTransOtherBill(Context ctx, PaymentBillInfo destBillInfo, boolean operTrans) throws EASBizException, BOSException {
        int i;
        Set billIdSet = this.getTransIdSet(destBillInfo, "sourceBillId");
        Set entryIdSet = this.getTransIdSet(destBillInfo, "sourceBillEntryId");
        IOtherBill iOtherBill = OtherBillFactory.getLocalInstance(ctx);
        IOtherBillentry iOtherBillEntry = OtherBillentryFactory.getLocalInstance(ctx);
        EntityViewInfo view = this.getIdSetView(billIdSet);
        OtherBillCollection otherCol = iOtherBill.getOtherBillCollection(view);
        EntityViewInfo entryView = this.getIdSetView(entryIdSet);
        OtherBillentryCollection otherEntryCol = iOtherBillEntry.getOtherBillentryCollection(entryView);
        PaymentBillEntryCollection destEtryCol = destBillInfo.getEntries();
        PaymentBillEntryInfo destEntryInfo = null;
        OtherBillentryCollection srcEtryCol = otherEntryCol;
        OtherBillentryInfo srcEntryInfo = null;
        String destSrcEntryId = null;
        String srcEntryId = null;
        BigDecimal destEntryPayAmt = ZERO;
        BigDecimal destEntryPayAmtLoc = ZERO;
        for (i = 0; i < destEtryCol.size(); ++i) {
            destEntryInfo = destEtryCol.get(i);
            destSrcEntryId = destEntryInfo.getSourceBillEntryId();
            if (destSrcEntryId == null) {
                throw new CasForArApException(CasForArApException.TRANSFAILED_SRCBILLID_ISNULL);
            }
            for (int j = 0; j < srcEtryCol.size(); ++j) {
                srcEntryInfo = srcEtryCol.get(j);
                srcEntryId = srcEntryInfo.getId().toString();
                if (!destSrcEntryId.equals(srcEntryId)) continue;
                destEntryPayAmt = destEntryInfo.getAmount();
                destEntryPayAmtLoc = destEntryInfo.getLocalAmt();
                if (destEntryPayAmt.multiply(srcEntryInfo.getAmount()).signum() < 0) {
                    logger.error((Object)("redBlue error: destEntryPayAmt:" + destEntryPayAmt + ",srcEntryLockUnVerifyAmt:" + srcEntryInfo.getAmount()));
                    throw new ArApRecPayException(ArApRecPayException.TRANSFAILED_REDBLUE, new Object[]{String.valueOf(destEntryInfo.getSeq()), destEntryPayAmt, srcEntryInfo.getAmount()});
                }
                if (operTrans) {
                    if (destEntryPayAmt.abs().compareTo(srcEntryInfo.getLockUnVerifyAmt().abs()) > 0) {
                        logger.error((Object)("TransOther error: destEntryPayAmt:" + destEntryPayAmt + ",Greater than srcEntryLockUnVerifyAmt:" + srcEntryInfo.getAmount()));
                        throw new ArApRecPayException(ArApRecPayException.TRANSFAILED_APAMOUNTGREATERERROR);
                    }
                    srcEntryInfo.setVerifyAmount(srcEntryInfo.getVerifyAmount().add(destEntryPayAmt));
                    srcEntryInfo.setVerifyAmountLocal(srcEntryInfo.getVerifyAmountLocal().add(destEntryPayAmtLoc));
                    srcEntryInfo.setUnVerifyAmount(srcEntryInfo.getUnVerifyAmount().subtract(destEntryPayAmt));
                    srcEntryInfo.setUnVerifyAmountLocal(srcEntryInfo.getUnVerifyAmountLocal().subtract(destEntryPayAmtLoc));
                    srcEntryInfo.setLockVerifyAmt(srcEntryInfo.getLockVerifyAmt().add(destEntryPayAmt));
                    srcEntryInfo.setLockVerifyAmtLocal(srcEntryInfo.getLockVerifyAmtLocal().add(destEntryPayAmtLoc));
                    srcEntryInfo.setLockUnVerifyAmt(srcEntryInfo.getLockUnVerifyAmt().subtract(destEntryPayAmt));
                    srcEntryInfo.setLockUnVerifyAmtLocal(srcEntryInfo.getLockUnVerifyAmtLocal().subtract(destEntryPayAmtLoc));
                    continue;
                }
                srcEntryInfo.setVerifyAmount(srcEntryInfo.getVerifyAmount().subtract(destEntryPayAmt));
                srcEntryInfo.setVerifyAmountLocal(srcEntryInfo.getVerifyAmountLocal().subtract(destEntryPayAmtLoc));
                srcEntryInfo.setUnVerifyAmount(srcEntryInfo.getUnVerifyAmount().add(destEntryPayAmt));
                srcEntryInfo.setUnVerifyAmountLocal(srcEntryInfo.getUnVerifyAmountLocal().add(destEntryPayAmtLoc));
                srcEntryInfo.setLockVerifyAmt(srcEntryInfo.getLockVerifyAmt().subtract(destEntryPayAmt));
                srcEntryInfo.setLockVerifyAmtLocal(srcEntryInfo.getLockVerifyAmtLocal().subtract(destEntryPayAmtLoc));
                srcEntryInfo.setLockUnVerifyAmt(srcEntryInfo.getLockUnVerifyAmt().add(destEntryPayAmt));
                srcEntryInfo.setLockUnVerifyAmtLocal(srcEntryInfo.getLockUnVerifyAmtLocal().add(destEntryPayAmtLoc));
            }
        }
        int size = otherCol.size();
        for (i = 0; i < size; ++i) {
            int bound = otherEntryCol.size();
            for (int j = 0; j < bound; ++j) {
                if (!otherEntryCol.get(j).getParent().getId().toString().equals(otherCol.get(i).getId().toString())) continue;
                otherCol.get(i).getEntry().set(otherEntryCol.get(j).getSeq() - 1, otherEntryCol.get(j));
            }
        }
        SelectorItemCollection sic = ArApSelectorFactory.getArOtherbillSelector(true);
        for (int i2 = 0; i2 < otherCol.size(); ++i2) {
            otherCol.get(i2).verifyPlan();
            OtherBillInfo otherbillInfo = otherCol.get(i2);
            ArApBillHelper.updateArApVerifyStatus(otherbillInfo);
            iOtherBill.updatePartial((CoreBaseInfo)otherbillInfo, sic);
        }
    }

    public void reverseTransBill(Context ctx, IObjectPK sourceBillPK, ReceivingBillInfo destBillInfo, boolean operTrans) throws EASBizException, BOSException {
        ReceivingBillInfo srcBillInfo = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo(sourceBillPK);
        ReceivingBillEntryCollection destEtryCol = destBillInfo.getEntries();
        ReceivingBillEntryInfo destEntryInfo = null;
        ReceivingBillEntryCollection srcEtryCol = srcBillInfo.getEntries();
        ReceivingBillEntryInfo srcEntryInfo = null;
        String destSrcEntryId = null;
        String srcEntryId = null;
        BigDecimal destEntryPayAmt = ZERO;
        BigDecimal destEntryPayAmtLoc = ZERO;
        BigDecimal destEntryPayAmtSum = ZERO;
        BigDecimal destEntryPayAmtLocSum = ZERO;
        int count = destEtryCol.size();
        for (int i = 0; i < count; ++i) {
            destEntryInfo = destEtryCol.get(i);
            destSrcEntryId = destEntryInfo.getSourceBillEntryId();
            if (destSrcEntryId == null) {
                throw new CasForArApException(CasForArApException.TRANSFAILED_SRCBILLID_ISNULL);
            }
            int size = srcEtryCol.size();
            for (int j = 0; j < size; ++j) {
                srcEntryInfo = srcEtryCol.get(j);
                srcEntryId = srcEntryInfo.getId().toString();
                if (!destSrcEntryId.equals(srcEntryId)) continue;
                destEntryPayAmt = destEntryInfo.getAmount();
                destEntryPayAmtLoc = destEntryInfo.getLocalAmt();
                destEntryPayAmtSum = destEntryPayAmtSum.add(destEntryPayAmt);
                destEntryPayAmtLocSum = destEntryPayAmtLocSum.add(destEntryPayAmtLoc);
                if (destEntryPayAmt.multiply(srcEntryInfo.getAmount()).signum() < 0) {
                    logger.error((Object)("redBlue error: destEntryPayAmt:" + destEntryPayAmt + ",srcEntryLockUnVerifyAmt:" + srcEntryInfo.getAmount()));
                    throw new ArApRecPayException(ArApRecPayException.TRANSFAILED_REDBLUE, new Object[]{String.valueOf(destEntryInfo.getSeq()), destEntryPayAmt, srcEntryInfo.getAmount()});
                }
                if (srcEntryInfo.getAmount().abs().compareTo(destEntryPayAmt.abs()) < 0) {
                    logger.error((Object)("reverseLockAmtError:  destEntryPayAmt" + destEntryPayAmt + ",srcEntryLockUnVerifyAmt:" + srcEntryInfo.getAmount()));
                    String writeBackErrorMsg = null;
                    Object[] param = new String[]{destBillInfo.getNumber(), String.valueOf(destEntryInfo.getSeq()), destEntryInfo.getAmount().toString(), srcBillInfo.getNumber(), String.valueOf(srcEntryInfo.getSeq()), srcEntryInfo.getAmount().toString()};
                    writeBackErrorMsg = ArApBillHelper.getResourceStr(ctx, ARAP_RESOUREC, "REC_AMOUNT_LITTER_UNLOCK_AMOUNT", param);
                    throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{writeBackErrorMsg});
                }
                if (operTrans) {
                    srcEntryInfo.setAmountVc(srcEntryInfo.getAmountVc().add(destEntryPayAmt));
                    srcEntryInfo.setLocalAmtVc(srcEntryInfo.getLocalAmtVc().add(destEntryPayAmtLoc));
                    BigDecimal zero = SysConstant.BIGZERO;
                    if (srcEntryInfo.getMatchedAmount() == null) {
                        srcEntryInfo.setMatchedAmount(zero);
                    }
                    if (srcEntryInfo.getMatchedAmountLoc() == null) {
                        srcEntryInfo.setMatchedAmountLoc(zero);
                    }
                    srcEntryInfo.setMatchedAmount(srcEntryInfo.getMatchedAmount().add(destEntryPayAmt));
                    srcEntryInfo.setMatchedAmountLoc(srcEntryInfo.getMatchedAmountLoc().add(destEntryPayAmtLoc));
                    srcEntryInfo.setUnVcAmount(srcEntryInfo.getUnVcAmount().subtract(destEntryPayAmt));
                    srcEntryInfo.setUnVcLocAmount(srcEntryInfo.getUnVcLocAmount().subtract(destEntryPayAmtLoc));
                    srcEntryInfo.setUnLockAmt(srcEntryInfo.getUnVcAmount());
                    srcEntryInfo.setUnLockLocAmt(srcEntryInfo.getUnVcLocAmount());
                    srcEntryInfo.setLockAmt(srcEntryInfo.getAmount().subtract(srcEntryInfo.getUnLockAmt()));
                    srcEntryInfo.setLockLocAmt(srcEntryInfo.getLocalAmt().subtract(srcEntryInfo.getUnLockLocAmt()));
                    continue;
                }
                srcEntryInfo.setAmountVc(srcEntryInfo.getAmountVc().subtract(destEntryPayAmt));
                srcEntryInfo.setLocalAmtVc(srcEntryInfo.getLocalAmtVc().subtract(destEntryPayAmtLoc));
                srcEntryInfo.setMatchedAmount(srcEntryInfo.getMatchedAmount().subtract(destEntryPayAmt));
                srcEntryInfo.setMatchedAmountLoc(srcEntryInfo.getMatchedAmountLoc().subtract(destEntryPayAmtLoc));
                srcEntryInfo.setUnVcAmount(srcEntryInfo.getUnVcAmount().add(destEntryPayAmt));
                srcEntryInfo.setUnVcLocAmount(srcEntryInfo.getUnVcLocAmount().add(destEntryPayAmtLoc));
                srcEntryInfo.setUnLockAmt(srcEntryInfo.getUnVcAmount());
                srcEntryInfo.setUnLockLocAmt(srcEntryInfo.getUnVcLocAmount());
                srcEntryInfo.setLockAmt(srcEntryInfo.getLockAmt().subtract(destEntryPayAmt));
                srcEntryInfo.setLockLocAmt(srcEntryInfo.getLockLocAmt().subtract(destEntryPayAmtLoc));
            }
        }
        if (operTrans) {
            srcBillInfo.setVerifiedAmt(srcBillInfo.getVerifiedAmt().add(destEntryPayAmtSum));
            srcBillInfo.setVerifiedAmtLoc(srcBillInfo.getVerifiedAmtLoc().add(destEntryPayAmtLocSum));
            srcBillInfo.setUnVerifiedAmt(srcBillInfo.getUnVerifiedAmt().subtract(destEntryPayAmtSum));
            srcBillInfo.setUnVerifiedAmtLoc(srcBillInfo.getUnVerifiedAmtLoc().subtract(destEntryPayAmtLocSum));
        } else {
            srcBillInfo.setVerifiedAmt(srcBillInfo.getVerifiedAmt().subtract(destEntryPayAmtSum));
            srcBillInfo.setVerifiedAmtLoc(srcBillInfo.getVerifiedAmtLoc().subtract(destEntryPayAmtLocSum));
            srcBillInfo.setUnVerifiedAmt(srcBillInfo.getUnVerifiedAmt().add(destEntryPayAmtSum));
            srcBillInfo.setUnVerifiedAmtLoc(srcBillInfo.getUnVerifiedAmtLoc().add(destEntryPayAmtLocSum));
        }
        ctx.put((Object)"haveDesbill", (Object)"true");
        String updateUserID = srcBillInfo.getLastUpdateUser() != null ? srcBillInfo.getLastUpdateUser().getId().toString() : null;
        String updateTime = srcBillInfo.getLastUpdateTime() != null ? srcBillInfo.getLastUpdateTime().toString() : null;
        ArApBillHelper.updateRecPayVerifyStatus((RecPayBillInfo)srcBillInfo);
        ReceivingBillFactory.getLocalInstance((Context)ctx).update(sourceBillPK, (CoreBaseInfo)srcBillInfo);
        if (updateUserID != null && updateTime != null) {
            DbUtil.execute((Context)ctx, (String)("update T_CAS_ReceivingBill set FLastUpdateUserID='" + updateUserID + "',FLastUpdateTime=to_date('" + updateTime + "') where FID='" + sourceBillPK.toString() + "'"));
        } else if (updateUserID == null || updateTime == null) {
            DbUtil.execute((Context)ctx, (String)("update T_CAS_ReceivingBill set FLastUpdateUserID=null,FLastUpdateTime=null where FID='" + sourceBillPK.toString() + "'"));
        }
        ctx.put((Object)"haveDesbill", null);
    }

    public void reverseTransOtherBill(Context ctx, ReceivingBillInfo destBillInfo, boolean operTrans) throws EASBizException, BOSException {
        int j;
        int i;
        Set billIdSet = this.getTransIdSet(destBillInfo, "sourceBillId");
        Set entryIdSet = this.getTransIdSet(destBillInfo, "sourceBillEntryId");
        com.kingdee.eas.fi.ap.IOtherBill iOtherBill = com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
        com.kingdee.eas.fi.ap.IOtherBillentry iOtherBillEntry = com.kingdee.eas.fi.ap.OtherBillentryFactory.getLocalInstance(ctx);
        EntityViewInfo view = this.getIdSetView(billIdSet);
        com.kingdee.eas.fi.ap.OtherBillCollection otherCol = iOtherBill.getOtherBillCollection(view);
        EntityViewInfo entryView = this.getIdSetView(entryIdSet);
        com.kingdee.eas.fi.ap.OtherBillentryCollection otherEntryCol = iOtherBillEntry.getOtherBillentryCollection(entryView);
        ReceivingBillEntryCollection destEtryCol = destBillInfo.getEntries();
        ReceivingBillEntryInfo destEntryInfo = null;
        com.kingdee.eas.fi.ap.OtherBillentryCollection srcEtryCol = otherEntryCol;
        com.kingdee.eas.fi.ap.OtherBillentryInfo srcEntryInfo = null;
        String destSrcEntryId = null;
        String srcEntryId = null;
        BigDecimal destEntryPayAmt = ZERO;
        BigDecimal destEntryPayAmtLoc = ZERO;
        int colSzie = destEtryCol.size();
        for (i = 0; i < colSzie; ++i) {
            destEntryInfo = destEtryCol.get(i);
            destSrcEntryId = destEntryInfo.getSourceBillEntryId();
            if (destSrcEntryId == null) {
                throw new CasForArApException(CasForArApException.TRANSFAILED_SRCBILLID_ISNULL);
            }
            int size = srcEtryCol.size();
            for (j = 0; j < size; ++j) {
                srcEntryInfo = srcEtryCol.get(j);
                srcEntryId = srcEntryInfo.getId().toString();
                if (!destSrcEntryId.equals(srcEntryId)) continue;
                destEntryPayAmt = destEntryInfo.getAmount();
                destEntryPayAmtLoc = destEntryInfo.getLocalAmt();
                if (destEntryPayAmt.multiply(srcEntryInfo.getAmount()).signum() < 0) {
                    logger.error((Object)("redBlue error: destEntryPayAmt:" + destEntryPayAmt + ",srcEntryLockUnVerifyAmt:" + srcEntryInfo.getAmount()));
                    throw new ArApRecPayException(ArApRecPayException.TRANSFAILED_REDBLUE);
                }
                if (operTrans) {
                    if (destEntryPayAmt.abs().compareTo(srcEntryInfo.getLockUnVerifyAmt().abs()) > 0) {
                        logger.error((Object)("TransOther error: destEntryPayAmt:" + destEntryPayAmt + ",Greater than srcEntryLockUnVerifyAmt:" + srcEntryInfo.getAmount()));
                        throw new ArApRecPayException(ArApRecPayException.TRANSFAILED_ARAMOUNTGREATERERROR);
                    }
                    srcEntryInfo.setVerifyAmount(srcEntryInfo.getVerifyAmount().add(destEntryPayAmt));
                    srcEntryInfo.setVerifyAmountLocal(srcEntryInfo.getVerifyAmountLocal().add(destEntryPayAmtLoc));
                    srcEntryInfo.setUnVerifyAmount(srcEntryInfo.getUnVerifyAmount().subtract(destEntryPayAmt));
                    srcEntryInfo.setUnVerifyAmountLocal(srcEntryInfo.getUnVerifyAmountLocal().subtract(destEntryPayAmtLoc));
                    srcEntryInfo.setLockVerifyAmt(srcEntryInfo.getLockVerifyAmt().add(destEntryPayAmt));
                    srcEntryInfo.setLockVerifyAmtLocal(srcEntryInfo.getLockVerifyAmtLocal().add(destEntryPayAmtLoc));
                    srcEntryInfo.setLockUnVerifyAmt(srcEntryInfo.getLockUnVerifyAmt().subtract(destEntryPayAmt));
                    srcEntryInfo.setLockUnVerifyAmtLocal(srcEntryInfo.getLockUnVerifyAmtLocal().subtract(destEntryPayAmtLoc));
                    continue;
                }
                srcEntryInfo.setVerifyAmount(srcEntryInfo.getVerifyAmount().subtract(destEntryPayAmt));
                srcEntryInfo.setVerifyAmountLocal(srcEntryInfo.getVerifyAmountLocal().subtract(destEntryPayAmtLoc));
                srcEntryInfo.setUnVerifyAmount(srcEntryInfo.getUnVerifyAmount().add(destEntryPayAmt));
                srcEntryInfo.setUnVerifyAmountLocal(srcEntryInfo.getUnVerifyAmountLocal().add(destEntryPayAmtLoc));
                srcEntryInfo.setLockVerifyAmt(srcEntryInfo.getLockVerifyAmt().subtract(destEntryPayAmt));
                srcEntryInfo.setLockVerifyAmtLocal(srcEntryInfo.getLockVerifyAmtLocal().subtract(destEntryPayAmtLoc));
                srcEntryInfo.setLockUnVerifyAmt(srcEntryInfo.getLockUnVerifyAmt().add(destEntryPayAmt));
                srcEntryInfo.setLockUnVerifyAmtLocal(srcEntryInfo.getLockUnVerifyAmtLocal().add(destEntryPayAmtLoc));
            }
        }
        int size = otherCol.size();
        for (i = 0; i < size; ++i) {
            int bound = otherEntryCol.size();
            for (j = 0; j < bound; ++j) {
                if (!otherEntryCol.get(j).getParent().getId().toString().equals(otherCol.get(i).getId().toString())) continue;
                otherCol.get(i).getEntry().set(otherEntryCol.get(j).getSeq() - 1, otherEntryCol.get(j));
            }
        }
        SelectorItemCollection sic = ArApSelectorFactory.getApOtherbillSelector(true);
        int size2 = otherCol.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            otherCol.get(i2).verifyPlan();
            ArApBillHelper.updateArApVerifyStatus(otherCol.get(i2));
            iOtherBill.updatePartial((CoreBaseInfo)otherCol.get(i2), sic);
        }
        APDisposeUtil.dispose(ctx, otherCol, operTrans ? DisposerActionEnum.VERIFY : DisposerActionEnum.UNVERIFY);
    }

    private Set getTransIdSet(PaymentBillInfo info, String property) throws CasForArApException {
        HashSet<String> idSet = new HashSet<String>();
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            String id = info.getEntries().get(i).get(property).toString();
            if (ArApRecPayServerHelper.isEmpty((Object)id)) {
                throw new CasForArApException(CasForArApException.TRANSFAILED_SRCBILLID_ISNULL);
            }
            if (id == null || idSet.contains(id)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    private Set getTransIdSet(ReceivingBillInfo info, String property) throws CasForArApException {
        HashSet<String> idSet = new HashSet<String>();
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            String id = info.getEntries().get(i).get(property).toString();
            if (ArApRecPayServerHelper.isEmpty((Object)id)) {
                throw new CasForArApException(CasForArApException.TRANSFAILED_SRCBILLID_ISNULL);
            }
            if (id == null || idSet.contains(id)) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public void writeBackOrderBill(Context ctx, String billID, boolean oprator, boolean isAR) throws BOSException {
        if (billID == null || billID.equals("")) {
            return;
        }
        String veriAdd = "+";
        if (!oprator) {
            veriAdd = "-";
        }
        if (isAR) {
            this.writeBackSaleOrderBill(ctx, billID, veriAdd);
            this.writeBackSaleOrderByTrans(ctx, billID, veriAdd);
            this.writeBackSaleReturnBill(ctx, billID, veriAdd);
            this.writeBackSaleReturnByTrans(ctx, billID, veriAdd);
            this.writeBackStockTransferBill(ctx, billID, veriAdd, true);
        } else {
            this.writeBackPurOrderBill(ctx, billID, veriAdd);
            this.writeBackPurOrderByTrans(ctx, billID, veriAdd);
            this.writeBackPurReturnBill(ctx, billID, veriAdd);
            this.writeBackPurReturnByTrans(ctx, billID, veriAdd);
            this.writeBackSubOrderBill(ctx, billID, veriAdd);
            this.writeBackSubOrderByTrans(ctx, billID, veriAdd);
            this.writeBackStockTransferBill(ctx, billID, veriAdd, false);
        }
    }

    protected void writeBackSaleOrderBill(Context ctx, String billID, String veriAdd) throws BOSException {
        StringBuffer udpateSaleOrderESQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpateSaleOrderESQL.append("UPDATE T_SD_SALEORDERENTRY SALEORDERE SET FTOTALRECEIVEDAMOUNT = ");
        udpateSaleOrderESQL.append("( SELECT ISNULL(SALEORDERE.FTOTALRECEIVEDAMOUNT,0) ").append(veriAdd).append(" paymentBillView.FAMOUNT ");
        fromTableSQL.append(" from (select SRCENTRY.FCOREBILLENTRYID FCOREBILLENTRYID, sum(isnull(DESTENTRY.FAMOUNT,0)) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_PAYMENTBILLENTRY DESTENTRY LEFT OUTER JOIN T_AR_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" WHERE  DESTENTRY.FPAYMENTBILLID = '").append(billID).append("' group by SRCENTRY.FCOREBILLENTRYID) paymentBillView");
        udpateSaleOrderESQL.append(fromTableSQL);
        udpateSaleOrderESQL.append(" where SALEORDERE.FID = paymentBillView.FCOREBILLENTRYID )");
        udpateSaleOrderESQL.append(" where  SALEORDERE.FID in (select paymentBillView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)udpateSaleOrderESQL.toString());
    }

    protected void writeBackSaleOrderByTrans(Context ctx, String billID, String veriAdd) throws BOSException {
        StringBuffer udpateSaleOrderESQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpateSaleOrderESQL.append("UPDATE T_SD_SALEORDERENTRY SALEORDERE SET FTOTALRECEIVEDAMOUNT = ");
        udpateSaleOrderESQL.append("( SELECT ISNULL(SALEORDERE.FTOTALRECEIVEDAMOUNT,0) ").append(veriAdd).append(" paymentBillView.FAMOUNT ");
        fromTableSQL.append(" from (select COREENTRY.FCOREBILLENTRYID FCOREBILLENTRYID, sum(isnull(DESTENTRY.FAMOUNT,0)) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_PAYMENTBILLENTRY DESTENTRY");
        fromTableSQL.append(" LEFT OUTER JOIN T_AR_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" INNER JOIN T_AR_OTHERBILL SRCTBILL ON SRCTBILL.FID = SRCENTRY.FParentID ");
        fromTableSQL.append(" INNER JOIN T_AR_OTHERBILLENTRY COREENTRY ON COREENTRY.FID = SRCENTRY.FCoreBillEntryID");
        fromTableSQL.append(" inner join T_SD_SaleOrderEntry soe on soe.FID = COREENTRY.FCOREBILLENTRYID ");
        fromTableSQL.append(" inner join T_SD_SaleOrder so on so.FID = soe.FParentID and so.FOrderCustomerID = SRCTBILL.FAsstActID");
        fromTableSQL.append(" WHERE  DESTENTRY.FPAYMENTBILLID = '").append(billID).append("' group by COREENTRY.FCOREBILLENTRYID) paymentBillView");
        udpateSaleOrderESQL.append(fromTableSQL);
        udpateSaleOrderESQL.append(" where SALEORDERE.FID = paymentBillView.FCOREBILLENTRYID )");
        udpateSaleOrderESQL.append(" where  SALEORDERE.FID in (select paymentBillView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)udpateSaleOrderESQL.toString());
    }

    protected void writeBackPurOrderBill(Context ctx, String billID, String veriAdd) throws BOSException {
        StringBuffer udpatePurOrderESQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpatePurOrderESQL.append("UPDATE T_SM_PURORDERENTRY PURORDERE SET FTOTALPAIDAMOUNT = ");
        udpatePurOrderESQL.append(" (SELECT ISNULL(PURORDERE.FTOTALPAIDAMOUNT,0) ").append(veriAdd).append(" purOrderBillView.FAMOUNT ");
        fromTableSQL.append(" from (select SRCENTRY.FCOREBILLENTRYID FCOREBILLENTRYID,sum(isnull(DESTENTRY.FAMOUNT,0)) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_RECEIVINGBILLENTRY DESTENTRY LEFT OUTER JOIN T_AP_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" WHERE DESTENTRY.FRECEIVINGBILLID = '").append(billID).append("' group by SRCENTRY.FCOREBILLENTRYID) purOrderBillView");
        udpatePurOrderESQL.append(fromTableSQL);
        udpatePurOrderESQL.append(" where PURORDERE.FID = purOrderBillView.FCOREBILLENTRYID) where PURORDERE.FID in (select purOrderBillView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)udpatePurOrderESQL.toString());
    }

    protected void writeBackPurOrderByTrans(Context ctx, String billID, String veriAdd) throws BOSException {
        StringBuffer udpatePurOrderESQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpatePurOrderESQL.append("UPDATE T_SM_PURORDERENTRY PURORDERE SET FTOTALPAIDAMOUNT = ");
        udpatePurOrderESQL.append(" (SELECT ISNULL(PURORDERE.FTOTALPAIDAMOUNT,0) ").append(veriAdd).append(" purOrderBillView.FAMOUNT ");
        fromTableSQL.append(" from (select CoreEntry.FCOREBILLENTRYID FCOREBILLENTRYID,sum(isnull(DESTENTRY.FAMOUNT,0)) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_RECEIVINGBILLENTRY DESTENTRY");
        fromTableSQL.append(" LEFT OUTER JOIN T_AP_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" LEFT OUTER JOIN T_AP_OTHERBILLENTRY CoreEntry ON CoreEntry.FID = SRCENTRY.FCoreBillEntryID");
        fromTableSQL.append(" WHERE DESTENTRY.FRECEIVINGBILLID = '").append(billID).append("' group by CoreEntry.FCOREBILLENTRYID) purOrderBillView");
        udpatePurOrderESQL.append(fromTableSQL);
        udpatePurOrderESQL.append(" where PURORDERE.FID = purOrderBillView.FCOREBILLENTRYID) where PURORDERE.FID in (select purOrderBillView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)udpatePurOrderESQL.toString());
    }

    protected void writeBackSubOrderBill(Context ctx, String billID, String veriAdd) throws BOSException {
        ArrayList<String> batchSql = new ArrayList<String>();
        StringBuffer udpateSubContractOrderESQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpateSubContractOrderESQL.append(" update T_SM_SubContractOrderEntry subContractOrderE set FTotalPaidAmount = ");
        udpateSubContractOrderESQL.append(" (SELECT ISNULL(subContractOrderE.FTotalPaidAmount,0) ").append(veriAdd).append("isnull(subConView.FAMOUNT,0)");
        fromTableSQL.append(" from (select SRCENTRY.FCOREBILLENTRYID FCOREBILLENTRYID,sum(isnull(DESTENTRY.FAMOUNT,0)) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_RECEIVINGBILLENTRY DESTENTRY INNER JOIN T_AP_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" WHERE DESTENTRY.FRECEIVINGBILLID = '").append(billID).append("' group by SRCENTRY.FCOREBILLENTRYID) subConView");
        udpateSubContractOrderESQL.append(fromTableSQL);
        udpateSubContractOrderESQL.append(" where subContractOrderE.FID = subConView.FCOREBILLENTRYID) where subContractOrderE.FID in (select subConView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        batchSql.add(udpateSubContractOrderESQL.toString());
        udpateSubContractOrderESQL.setLength(0);
        fromTableSQL.setLength(0);
        udpateSubContractOrderESQL.append(" update T_SM_SubContractOrder subContractOrder set FTotalPaidAmount = ");
        udpateSubContractOrderESQL.append(" (SELECT ISNULL(subContractOrder.FTotalPaidAmount,0) ").append(veriAdd).append(" isnull(result.FTHISPAYAMOUNT,0)");
        fromTableSQL.append(" FROM(SELECT Sum(ISNULL(DESTENTRY.FAMOUNT,0)) AS FTHISPAYAMOUNT,SRCENTRY.FCOREBILLID AS FCOREBILLID");
        fromTableSQL.append(" FROM T_CAS_RECEIVINGBILLENTRY DESTENTRY INNER JOIN T_AP_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" WHERE DESTENTRY.FRECEIVINGBILLID = '").append(billID).append("'");
        fromTableSQL.append(" group by SRCENTRY.FCOREBILLID) as result");
        udpateSubContractOrderESQL.append(fromTableSQL);
        udpateSubContractOrderESQL.append(" where subContractOrder.FID = result.FCOREBILLID)");
        udpateSubContractOrderESQL.append(" where subContractOrder.FID in (select result.FCOREBILLID").append(fromTableSQL).append(")");
        batchSql.add(udpateSubContractOrderESQL.toString());
        ServiceHandler.execute((Context)ctx, (String[])batchSql.toArray(new String[batchSql.size()]));
    }

    protected void writeBackSubOrderByTrans(Context ctx, String billID, String veriAdd) throws BOSException {
        ArrayList<String> batchSql = new ArrayList<String>();
        StringBuffer udpateSubContractOrderESQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpateSubContractOrderESQL.append(" update T_SM_SubContractOrderEntry subContractOrderE set FTotalPaidAmount = ");
        udpateSubContractOrderESQL.append(" (SELECT ISNULL(subContractOrderE.FTotalPaidAmount,0) ").append(veriAdd).append("isnull(subConView.FAMOUNT,0)");
        fromTableSQL.append(" from (select coreEntry.FCOREBILLENTRYID FCOREBILLENTRYID,sum(isnull(DESTENTRY.FAMOUNT,0)) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_RECEIVINGBILLENTRY DESTENTRY");
        fromTableSQL.append(" INNER JOIN T_AP_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" INNER JOIN T_AP_OTHERBILLENTRY coreEntry ON coreEntry.FID = SRCENTRY.FCoreBillEntryID");
        fromTableSQL.append(" WHERE DESTENTRY.FRECEIVINGBILLID = '").append(billID).append("' group by coreEntry.FCOREBILLENTRYID) subConView");
        udpateSubContractOrderESQL.append(fromTableSQL);
        udpateSubContractOrderESQL.append(" where subContractOrderE.FID = subConView.FCOREBILLENTRYID) where subContractOrderE.FID in (select subConView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        batchSql.add(udpateSubContractOrderESQL.toString());
        udpateSubContractOrderESQL.setLength(0);
        fromTableSQL.setLength(0);
        udpateSubContractOrderESQL.append(" update T_SM_SubContractOrder subContractOrder set FTotalPaidAmount = ");
        udpateSubContractOrderESQL.append(" (SELECT ISNULL(subContractOrder.FTotalPaidAmount,0) ").append(veriAdd).append(" isnull(result.FTHISPAYAMOUNT,0)");
        fromTableSQL.append(" FROM(SELECT Sum(ISNULL(DESTENTRY.FAMOUNT,0)) AS FTHISPAYAMOUNT,coreEntry.FCOREBILLID AS FCOREBILLID");
        fromTableSQL.append(" FROM T_CAS_RECEIVINGBILLENTRY DESTENTRY");
        fromTableSQL.append(" INNER JOIN T_AP_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" INNER JOIN T_AP_OTHERBILLENTRY coreEntry ON coreEntry.FID = SRCENTRY.FCoreBillEntryID");
        fromTableSQL.append(" WHERE DESTENTRY.FRECEIVINGBILLID = '").append(billID).append("'");
        fromTableSQL.append(" group by coreEntry.FCOREBILLID) as result");
        udpateSubContractOrderESQL.append(fromTableSQL);
        udpateSubContractOrderESQL.append(" where subContractOrder.FID = result.FCOREBILLID)");
        udpateSubContractOrderESQL.append(" where subContractOrder.FID in (select result.FCOREBILLID").append(fromTableSQL).append(")");
        batchSql.add(udpateSubContractOrderESQL.toString());
        ServiceHandler.execute((Context)ctx, (String[])batchSql.toArray(new String[batchSql.size()]));
    }

    protected void writeBackSaleReturnBill(Context ctx, String billID, String veriAdd) throws BOSException {
        StringBuffer udpateSaleReturnsESQL = new StringBuffer(" update T_SD_SaleReturnsEntry SALERETURNSE set FTotalReturnAmt = ");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpateSaleReturnsESQL.append(" (SELECT ISNULL(SALERETURNSE.FTotalReturnAmt,0) ").append(veriAdd).append("saleReturnView.FAMOUNT");
        fromTableSQL.append(" from (select SRCENTRY.FCOREBILLENTRYID FCOREBILLENTRYID,sum(ABS(isnull(DESTENTRY.FAMOUNT,0))) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_PAYMENTBILLENTRY DESTENTRY INNER JOIN T_AR_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" WHERE  DESTENTRY.FPAYMENTBILLID = '").append(billID).append("' group by SRCENTRY.FCOREBILLENTRYID) saleReturnView");
        udpateSaleReturnsESQL.append(fromTableSQL);
        udpateSaleReturnsESQL.append(" where SALERETURNSE.FID = saleReturnView.FCOREBILLENTRYID) where SALERETURNSE.FID in (select saleReturnView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)udpateSaleReturnsESQL.toString());
    }

    protected void writeBackSaleReturnByTrans(Context ctx, String billID, String veriAdd) throws BOSException {
        StringBuffer udpateSaleReturnsESQL = new StringBuffer(" update T_SD_SaleReturnsEntry SALERETURNSE set FTotalReturnAmt = ");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpateSaleReturnsESQL.append(" (SELECT ISNULL(SALERETURNSE.FTotalReturnAmt,0) ").append(veriAdd).append("saleReturnView.FAMOUNT");
        fromTableSQL.append(" from (select coreEntry.FCOREBILLENTRYID FCOREBILLENTRYID,sum(ABS(isnull(DESTENTRY.FAMOUNT,0))) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_PAYMENTBILLENTRY DESTENTRY");
        fromTableSQL.append(" INNER JOIN T_AR_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" INNER JOIN T_AR_OTHERBILLENTRY coreEntry ON coreEntry.FID = SRCENTRY.FCoreBillEntryID");
        fromTableSQL.append(" WHERE  DESTENTRY.FPAYMENTBILLID = '").append(billID).append("' group by coreEntry.FCOREBILLENTRYID) saleReturnView");
        udpateSaleReturnsESQL.append(fromTableSQL);
        udpateSaleReturnsESQL.append(" where SALERETURNSE.FID = saleReturnView.FCOREBILLENTRYID) where SALERETURNSE.FID in (select saleReturnView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)udpateSaleReturnsESQL.toString());
    }

    protected void writeBackPurReturnBill(Context ctx, String billID, String veriAdd) throws BOSException {
        StringBuffer udpatePurReturnsESQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpatePurReturnsESQL.append("UPDATE T_SM_PurReturnsEntry purReturnsE SET FTotalReturnAmt = ");
        udpatePurReturnsESQL.append(" (SELECT ISNULL(purReturnsE.FTotalReturnAmt,0) ").append(veriAdd).append(" purReturnsView.FAMOUNT");
        fromTableSQL.append(" from (select SRCENTRY.FCOREBILLENTRYID FCOREBILLENTRYID,sum(ABS(isnull(DESTENTRY.FAMOUNT,0))) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_RECEIVINGBILLENTRY DESTENTRY LEFT OUTER JOIN T_AP_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" WHERE DESTENTRY.FRECEIVINGBILLID = '").append(billID).append("' group by SRCENTRY.FCOREBILLENTRYID) purReturnsView");
        udpatePurReturnsESQL.append(fromTableSQL);
        udpatePurReturnsESQL.append(" where purReturnsE.FID = purReturnsView.FCOREBILLENTRYID ) where purReturnsE.FID in (select purReturnsView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)udpatePurReturnsESQL.toString());
    }

    protected void writeBackPurReturnByTrans(Context ctx, String billID, String veriAdd) throws BOSException {
        StringBuffer udpatePurReturnsESQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        udpatePurReturnsESQL.append("UPDATE T_SM_PurReturnsEntry purReturnsE SET FTotalReturnAmt = ");
        udpatePurReturnsESQL.append(" (SELECT ISNULL(purReturnsE.FTotalReturnAmt,0) ").append(veriAdd).append(" purReturnsView.FAMOUNT");
        fromTableSQL.append(" from (select coreEntry.FCOREBILLENTRYID FCOREBILLENTRYID,sum(ABS(isnull(DESTENTRY.FAMOUNT,0))) FAMOUNT");
        fromTableSQL.append(" FROM T_CAS_RECEIVINGBILLENTRY DESTENTRY");
        fromTableSQL.append(" LEFT OUTER JOIN T_AP_OTHERBILLENTRY SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" LEFT OUTER JOIN T_AP_OTHERBILLENTRY coreEntry ON coreEntry.FID = SRCENTRY.FCoreBillEntryID");
        fromTableSQL.append(" WHERE DESTENTRY.FRECEIVINGBILLID = '").append(billID).append("' group by coreEntry.FCOREBILLENTRYID) purReturnsView");
        udpatePurReturnsESQL.append(fromTableSQL);
        udpatePurReturnsESQL.append(" where purReturnsE.FID = purReturnsView.FCOREBILLENTRYID ) where purReturnsE.FID in (select purReturnsView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)udpatePurReturnsESQL.toString());
    }

    protected void writeBackStockTransferBill(Context ctx, String billID, String veriAdd, boolean isAR) throws BOSException {
        String entryComCol = "FIssueCompanyOrgUnitID";
        String headComCol = "FIssueCompanyOrgUnitID";
        StringBuffer bizType1 = new StringBuffer("");
        StringBuffer bizType2 = new StringBuffer("");
        if (!isAR) {
            entryComCol = "FReceiveCompanyOrgUnitID";
            headComCol = "FReceiptCompanyOrgUnitID";
            bizType1.append("'").append("d8e80652-0117-1000-e000-04c5c0a812202407435C").append("',");
            bizType1.append("'").append("ltQJK8kihHPgQKjAYj1jAyQHQ1w=").append("',");
            bizType1.append("'").append("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=").append("',");
            bizType1.append("'").append("ltQJdddQMebgQKjAYj1j1yQHQ1w=").append("'");
            bizType2.append("'").append("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=").append("',");
            bizType2.append("'").append("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=").append("'");
        } else {
            bizType1.append("'").append("d8e80652-0117-1000-e000-04c5c0a812202407435C").append("',");
            bizType1.append("'").append("ltQJK8kihHPgQKjAYj1jAyQHQ1w=").append("'");
            bizType2.append("'").append("LyS5ouN3YEPgQAB/AQBJsCQHQ1w=").append("',");
            bizType2.append("'").append("ltQJdddQMebgQKjAYj1j1yQHQ1w=").append("',");
            bizType2.append("'").append("LyS5ouN4YEPgQAB/AQBJsCQHQ1w=").append("',");
            bizType2.append("'").append("ltQJ0s1RqWzgQKjAYj1j3CQHQ1w=").append("'");
        }
        StringBuffer updateStockTransferBillSQL = new StringBuffer("");
        StringBuffer fromTableSQL = new StringBuffer("");
        updateStockTransferBillSQL.append("update T_IM_TransferOrderBillEntry transferOrderE set ").append(isAR ? "FTotalAccountReceivable" : "FTotalAccountPayable").append(" = ");
        updateStockTransferBillSQL.append("(select ISNULL(transferOrderE.").append(isAR ? "FTotalAccountReceivable" : "FTotalAccountPayable").append(",0)");
        updateStockTransferBillSQL.append(veriAdd).append("transferOrderView.FAMOUNT");
        fromTableSQL.append(" from (select SRCENTRY.FCOREBILLENTRYID FCOREBILLENTRYID,sum(isnull(destEntry.FAMOUNT,0)) FAMOUNT");
        fromTableSQL.append(" from ").append(isAR ? "T_CAS_PAYMENTBILLENTRY" : "T_CAS_RECEIVINGBILLENTRY").append(" DESTENTRY INNER JOIN ");
        fromTableSQL.append(isAR ? "T_AR_OTHERBILLENTRY" : "T_AP_OTHERBILLENTRY").append(" SRCENTRY ON DESTENTRY.FSOURCEBILLENTRYID = SRCENTRY.FID");
        fromTableSQL.append(" INNER JOIN ").append(isAR ? "T_AR_OTHERBILL" : "T_AP_OTHERBILL").append(" SRCBILL ON SRCBILL.FID = SRCENTRY.FPARENTID");
        fromTableSQL.append(" inner join T_IM_TransferOrderBillEntry stEntry on srcEntry.FCoreBillEntryId = stEntry.FID ");
        fromTableSQL.append(" INNER JOIN T_IM_TRANSFERORDERBILL TRANSFERORDER ON TRANSFERORDER.FID = stEntry.fparentid");
        fromTableSQL.append(" WHERE ((SRCBILL.FCompanyID = TRANSFERORDER.").append(headComCol);
        fromTableSQL.append(" AND SRCBILL.FBizTypeID in(").append(bizType2).append("))");
        fromTableSQL.append(" OR (SRCBILL.FCompanyID = stEntry.").append(entryComCol).append(" AND SRCBILL.FBizTypeID in(").append(bizType1).append(")))");
        fromTableSQL.append(" AND ").append(isAR ? "DESTENTRY.FPAYMENTBILLID" : "DESTENTRY.FRECEIVINGBILLID").append(" = '").append(billID).append("' ");
        fromTableSQL.append(" group by SRCENTRY.FCOREBILLENTRYID) transferOrderView");
        updateStockTransferBillSQL.append(fromTableSQL);
        updateStockTransferBillSQL.append(" where transferOrderE.FID = transferOrderView.FcoreBillEntryId) ");
        updateStockTransferBillSQL.append(" where transferOrderE.FID in (select transferOrderView.FcoreBillEntryId ").append(fromTableSQL).append(")");
        DbUtil.execute((Context)ctx, (String)updateStockTransferBillSQL.toString());
    }

    public void recycleUseIntermitNumber(Context ctx, IObjectPK pk, PaymentBillInfo paymentBillInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (paymentBillInfo == null || paymentBillInfo.getNumber() == null || paymentBillInfo.getCompany() == null || paymentBillInfo.getCU() == null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("number");
            sic.add("company.id");
            sic.add("cu.id");
            paymentBillInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo(pk, sic);
        }
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = paymentBillInfo.getCompany();
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        CodingRuleInfo codingInfo = iCodingRuleManager.getCodingRule((IObjectValue)paymentBillInfo, strCompanyID);
        if (iCodingRuleManager.isExist((IObjectValue)paymentBillInfo, strCompanyID) && (iCodingRuleManager.isUseIntermitNumber((IObjectValue)paymentBillInfo, strCompanyID) || codingInfo.isIsaddnewbreak())) {
            iCodingRuleManager.recycleNumber((IObjectValue)paymentBillInfo, strCompanyID, StringUtils.isEmpty((String)paymentBillInfo.getOldNumber()) ? paymentBillInfo.getNumber() : paymentBillInfo.getOldNumber());
        }
    }

    public void throwSubmitExcetion(Context ctx, String messageItem) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.CHECKBLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)messageItem, (Locale)ctx.getLocale())});
    }

    public void throwSaveExcetion(Context ctx, String messageItem) throws EASBizException {
        throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)messageItem, (Locale)ctx.getLocale())});
    }

    public boolean isRuleAutoNumber(Context ctx, ReceivingBillInfo receivingBillInfo) throws EASBizException, BOSException {
        String strCompanyId = null;
        if (receivingBillInfo.getCompany() != null) {
            strCompanyId = receivingBillInfo.getCompany().getId().toString();
        }
        return this.isRuleAutoNumber(ctx, receivingBillInfo, strCompanyId);
    }

    public boolean isRuleAutoNumber(Context ctx, ReceivingBillInfo receivingBillInfo, String sCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager;
        if (StringUtils.isEmpty((String)sCompanyID)) {
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = null;
            aCompanyOrgUnitInfo = receivingBillInfo.getCompany() != null ? receivingBillInfo.getCompany() : ContextUtil.getCurrentFIUnit((Context)ctx);
            sCompanyID = aCompanyOrgUnitInfo.getId().toString();
        }
        return (iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx)).isExist((IObjectValue)receivingBillInfo, sCompanyID);
    }

    public boolean isAddView(Context ctx, ICodingRuleManager iCodingRuleManager, ReceivingBillInfo receivingBillInfo) throws CodingRuleException, EASBizException, BOSException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = receivingBillInfo.getCompany();
        String strCompanyID = aCompanyOrgUnitInfo.getId().toString();
        return iCodingRuleManager.isAddView((IObjectValue)receivingBillInfo, strCompanyID);
    }

    public void checkPayeeForPayment(Context ctx, PaymentBillInfo info) throws EASBizException, BOSException {
        boolean needHandle;
        boolean bl = needHandle = SourceTypeEnum.AP == info.getSourceType() && !StringUtils.isEmpty((String)info.getPayeeID()) && null != info.getPayeeType() && null != info.getPayeeType().getRealtionDataObject() && null != info.getCompany();
        if (needHandle) {
            IRowSet rowSet;
            Object[] params;
            String sql;
            String companyId = info.getCompany().getId().toString();
            String relDataObject = info.getPayeeType().getRealtionDataObject();
            String oql = "select id, name, number,usedStatus where id = '" + info.getPayeeID() + "'";
            if ("T_BD_Supplier".equalsIgnoreCase(relDataObject)) {
                SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo(oql);
                if (supplierInfo.getUsedStatus() != UsedStatusEnum.APPROVED) {
                    throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)"asstActNotApproved", (Locale)ctx.getLocale())});
                }
                sql = "SELECT FID,FIsFreezePayment,FUsingStatus FROM T_BD_SUPPLIERCOMPANYINFO WHERE FCOMORGID = ? AND FSUPPLIERID= ?";
                params = new String[]{companyId, info.getPayeeID()};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                boolean isFreezePayment = false;
                int usingStatus = 0;
                try {
                    if (rowSet.next()) {
                        isFreezePayment = rowSet.getBoolean("FIsFreezePayment");
                        usingStatus = rowSet.getInt("FUsingStatus");
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                if (usingStatus != 0) {
                    throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)"asstActCompanyNotApproved", (Locale)ctx.getLocale())});
                }
                if (isFreezePayment) {
                    throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)"supplierHasFreezePayment", (Locale)ctx.getLocale())});
                }
            }
            if ("T_BD_Customer".equalsIgnoreCase(relDataObject)) {
                CustomerInfo customerInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo(oql);
                if (customerInfo.getUsedStatus() != UsedStatusEnum.APPROVED) {
                    throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)"asstActNotApproved", (Locale)ctx.getLocale())});
                }
                sql = "SELECT FID,FUsingStatus FROM T_BD_CUSTOMERCOMPANYINFO WHERE FCOMORGID = ? AND FCUSTOMERID = ?";
                params = new String[]{companyId, info.getPayeeID()};
                rowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])params);
                int usingStatus = 0;
                try {
                    if (rowSet.next()) {
                        usingStatus = rowSet.getInt("FUsingStatus");
                    }
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    throw new BOSException((Throwable)e);
                }
                if (usingStatus != 0) {
                    throw new ArApRecPayException(ArApRecPayException.BLANK, (Object[])new String[]{ResourceBase.getString((String)this.resourcePath, (String)"asstActCompanyNotApproved", (Locale)ctx.getLocale())});
                }
            }
        }
    }
}

