/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParam;
import com.kingdee.eas.base.param.ParamCollection;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamFactory;
import com.kingdee.eas.base.param.ParamInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.APParamEnum;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ap.app.util.ApServerUtils;
import com.kingdee.eas.fi.ar.ARParamEnum;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IVerificationBillentry;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillCollection;
import com.kingdee.eas.fi.ar.VerificationBillFactory;
import com.kingdee.eas.fi.ar.VerificationBillInfo;
import com.kingdee.eas.fi.ar.VerificationBillentryCollection;
import com.kingdee.eas.fi.ar.VerificationBillentryFactory;
import com.kingdee.eas.fi.ar.VerificationBillentryInfo;
import com.kingdee.eas.fi.ar.app.util.ArServerUtils;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.ar.util.CommonUtils;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.ARAPContrastBizException;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.DbUtilFacadeFactory;
import com.kingdee.eas.fi.arap.IDbUtilFacade;
import com.kingdee.eas.fi.arap.app.util.LockResult;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.pcc.FIClosingCenterFacadeFactory;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.ma.control.BgControlException;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.ma.nbudget.face.IBudgetBalance;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.framework.app.InvBalanceReCal.KsqlUtil;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.framework.bizflow.app.BizFlowServerHelper;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogAdapter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.RowSet;
import org.apache.log4j.Logger;

public class ArApServerUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.util.ArApServerUtils");
    public static final String SUB_SYSTEM_AP = "com.kingdee.eas.fi.ar.ap.ap";
    public static final String SUB_SYSTEM_AR = "com.kingdee.eas.fi.ar.ar";
    public static final String CR = " \r\n ";
    public static final int SYSTEM_AR = 1;
    public static final int SYSTEM_AP = 2;
    public static final String RT = " \r\n ";

    public static void addSQLLock(Context ctx, Object pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        if (!BOSUuid.isValid((String)pk.toString(), (boolean)true)) {
            return;
        }
        HashSet<Object> pkSet = new HashSet<Object>();
        pkSet.add(pk);
        ArApServerUtils.addSQLLock(ctx, pkSet);
    }

    public static void addSQLLock(Context ctx, List pkList) throws BOSException, EASBizException {
        if (pkList.isEmpty()) {
            return;
        }
        HashSet pkSet = new HashSet(pkList);
        ArApServerUtils.addSQLLock(ctx, pkSet);
    }

    public static void addSQLLock(Context ctx, Set pkSet) throws BOSException, EASBizException {
        if (pkSet.isEmpty()) {
            return;
        }
        Object pk = pkSet.iterator().next();
        if (pk == null) {
            return;
        }
        BOSObjectType bosType = BOSUuid.read((String)pk.toString()).getType();
        String ids = ArApServerUtils.transList2String(pkSet);
        String table = FMIsqlFacadeFactory.getLocalInstance((Context)ctx).getTableNameByBosType(bosType);
        String lockSQL = " UPDATE " + table + " SET FID = FID  WHERE FID in " + ids;
        DBUtil.execute((Context)ctx, (String)lockSQL);
    }

    public static String transList2String(Set list) {
        String ids = "";
        for (Object idStr : list) {
            if (idStr == null || !BOSUuid.isValid((String)idStr.toString(), (boolean)true)) continue;
            ids = ids + "'" + idStr + "',";
        }
        if (ids.length() > 0) {
            ids = ids.substring(0, ids.length() - 1);
        }
        return "(" + ids + ")";
    }

    public static CurrencyInfo getCurrencyInfo(BOSUuid id, Context ctx) throws EASBizException, BOSException {
        SelectorItemCollection itemColl = new SelectorItemCollection();
        itemColl.add(new SelectorItemInfo("precision"));
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id));
    }

    public static boolean isAPRelationSCM(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        APParamEnum aPParamEnum = APParamEnum.AP_SCM_001;
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, aPParamEnum.getValue());
        if (value == null) {
            return ArApServerUtils.getDefaulParam(ctx, SUB_SYSTEM_AP, aPParamEnum.getValue());
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    public static boolean isARRelationSCM(Context ctx, String companyID) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        ARParamEnum aPParamEnum = ARParamEnum.AR_SCM_001;
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, aPParamEnum.getValue());
        if (value == null) {
            return ArApServerUtils.getDefaulParam(ctx, SUB_SYSTEM_AR, aPParamEnum.getValue());
        }
        return value.equalsIgnoreCase("true") || value.equals("1");
    }

    private static boolean getDefaulParam(Context ctx, String system, String number) throws BOSException, EASBizException {
        IParam iParam = ParamFactory.getLocalInstance((Context)ctx);
        StringBuffer oql = new StringBuffer("");
        oql.append(" select * where number ='").append(number).append("'");
        oql.append(" and subSysID ='").append(system).append("'");
        ParamCollection paramCollection = iParam.getParamCollection(oql.toString());
        ParamInfo paramInfo = null;
        if (paramCollection != null) {
            paramInfo = paramCollection.get(0);
            if (paramInfo != null) {
                return "true".equalsIgnoreCase(paramInfo.getDefaultValue()) || "1".equals(paramInfo.getDefaultValue());
            }
            return true;
        }
        return true;
    }

    public static boolean isSameBizCode(Context ctx, String topAssactID, String botAssactID) throws BOSException {
        boolean isSameCode = false;
        if (topAssactID != null && botAssactID != null) {
            if (!botAssactID.equals(topAssactID)) {
                IDynamicObject iDyn = DynamicObjectFactory.getLocalInstance((Context)ctx);
                String bizCode = "bizAnalysisCode";
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo(bizCode));
                ObjectUuidPK pk = new ObjectUuidPK(topAssactID);
                IObjectValue val1 = iDyn.getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
                pk = new ObjectUuidPK(botAssactID);
                IObjectValue val2 = iDyn.getValue(pk.getObjectType(), (IObjectPK)pk, selectors);
                if (val1 != null && val2 != null && val1.get(bizCode) != null && val1.get(bizCode).equals(val2.get(bizCode))) {
                    isSameCode = true;
                }
            } else {
                isSameCode = true;
            }
        }
        return isSameCode;
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (companyOrgUnitInfo == null) {
            return null;
        }
        if (sourceCur == null) {
            throw new BOSException(CommonUtils.getResources("com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", "49_BaseDataUtil", ctx.getLocale()));
        }
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            throw new BOSException(CommonUtils.getResources("com.kingdee.eas.fi.ar.ARResources", "BaseExchangeTable_not_exist", ctx.getLocale()));
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            throw new BOSException("BaseCurrency is null");
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static String getInStringFromSet(Set<String> idSet) {
        if (idSet == null || idSet.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator<String> iter = idSet.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static void injectBizFlow(Context ctx, IObjectValue model, BatchActionEnum action) throws EASBizException, BOSException {
        BizFlowServerHelper.doProcessing((Context)ctx, (IObjectValue)model, (BatchActionEnum)action);
    }

    public static void doWriteBack(Context ctx, IObjectValue model, BatchActionEnum action) throws EASBizException, BOSException {
        BizFlowServerHelper.doWriteBack((Context)ctx, (IObjectValue)model, (BatchActionEnum)action);
    }

    public static AccountViewInfo getKAClassAccount(Context ctx, String companyID, String asstActId, boolean isArBill, boolean isArSystem, int isPreRecPay) throws Exception {
        IArApBillBase iArAp = isArBill ? OtherBillFactory.getLocalInstance(ctx) : com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx);
        AccountViewInfo account = new AccountViewInfo();
        IRowSet accountResult = iArAp.getKAClassAccount(companyID, asstActId, isArBill, isArSystem, isPreRecPay);
        if (accountResult == null) {
            return null;
        }
        accountResult.beforeFirst();
        while (accountResult.next()) {
            account.setId(BOSUuid.read((String)accountResult.getString("account_id")));
            account.setNumber(accountResult.getString("account_number"));
            account.setName(accountResult.getString("account_name"));
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)accountResult.getInt("accounting_currency")));
            if (accountResult.getString("account_currency") == null) continue;
            AccountCurrencyInfo accCurInfo = new AccountCurrencyInfo();
            CurrencyInfo cur = new CurrencyInfo();
            cur.setId(BOSUuid.read((String)accountResult.getString("account_currency")));
            accCurInfo.setCurrency(cur);
            account.getAccountCurrency().add(accCurInfo);
        }
        if (account.getId() == null) {
            return null;
        }
        return account;
    }

    public static void createBotpRelation(Context ctx, Set<String> srcObjectIdSet, String destObjectId) throws BOSException, UuidException, SQLException {
        if (srcObjectIdSet == null || srcObjectIdSet.isEmpty() || StringUtils.isEmpty((String)destObjectId)) {
            return;
        }
        StringBuffer sqlString = new StringBuffer();
        sqlString = sqlString.append("SELECT FSRCOBJECTID FROM T_BOT_Relation ").append("WHERE FSRCOBJECTID in ").append(ArApServerUtils.transList2String(srcObjectIdSet)).append(" AND FDESTOBJECTID ='").append(destObjectId).append("' ");
        IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sqlString.toString());
        HashSet<String> hasRelationSrcIds = new HashSet<String>();
        while (rowSet.next()) {
            hasRelationSrcIds.add(rowSet.getString("FSRCOBJECTID"));
        }
        for (String srcObjectId : srcObjectIdSet) {
            if (hasRelationSrcIds.contains(srcObjectId)) continue;
            IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
            BOTRelationInfo info = new BOTRelationInfo();
            String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
            String destBosType = BOSUuid.read((String)destObjectId).getType().toString();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            info.setType(0);
            iBOTRelation.addnew(info);
        }
    }

    public static BTPTransformResult transformForBotpWithMutex(Context ctx, CoreBillBaseCollection srcBillCols, String destBillBosType, IObjectPK botMappingId, boolean isNeedMutex) throws BOSException, EASBizException {
        ArrayList<String> thisLockList = new ArrayList<String>();
        ArrayList<String> otherLockList = new ArrayList<String>();
        IMutexServiceControl mutexService = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        IBTPManager ibtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        try {
            if (isNeedMutex) {
                int size = srcBillCols.size();
                ArrayList<String> idList = new ArrayList<String>();
                for (int i = 0; i < size; ++i) {
                    CoreBillBaseInfo billInfo = (CoreBillBaseInfo)srcBillCols.getObject(i);
                    idList.add(billInfo.getId().toString());
                }
                Map requestLockMap = mutexService.batchRequestObjIDForUpdate(idList);
                for (int i = 0; i < size; ++i) {
                    String id = (String)idList.get(i);
                    if (((Boolean)requestLockMap.get(id)).booleanValue()) {
                        thisLockList.add(id);
                        continue;
                    }
                    otherLockList.add(id);
                }
                if (otherLockList.size() > 0) {
                    throw new com.kingdee.eas.fi.ap.OtherBillBizException(com.kingdee.eas.fi.ap.OtherBillBizException.BILL_LOCKED);
                }
            }
            BTPTransformResult size = ibtpManager.transformForBotp(srcBillCols, destBillBosType, botMappingId);
            return size;
        }
        catch (Exception e) {
            throw new ARAPVerifynException(ARAPVerifynException.COMMON, new String[]{e.getMessage()});
        }
        finally {
            if (thisLockList != null && thisLockList.size() != 0) {
                mutexService.batchReleaseObjIDForUpdate(thisLockList);
            }
        }
    }

    public static void commonBugdetCheck(Context ctx, String companyID, IObjectValue model) throws BOSException, EASBizException {
        BgControlCaller caller = new BgControlCaller();
        ObjectUuidPK pk = new ObjectUuidPK(companyID);
        String bgParamName = "AR_BUDGET_01";
        String value = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, bgParamName);
        if (value == null) {
            return;
        }
        if (value.equalsIgnoreCase("true") || value.equals("1")) {
            try {
                IBudgetBalance budgetBalance = caller.queryBalance(ctx, model);
                caller.checkBudget(ctx, budgetBalance);
            }
            catch (BgControlException e) {
                if (BgControlException.NOFOUNDCONTROLSCHEME.getCode().equalsIgnoreCase(e.getSubCode())) {
                    logger.error((Object)e.getMessage());
                }
                throw e;
            }
        }
    }

    public static Date getBizDateBySystem(Context ctx, boolean isAr, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        Date date = new Date();
        PeriodInfo periodInfo = isAr ? ArServerUtils.getArCurrentPeriod(ctx, company) : ApServerUtils.getApCurrentPeriod(ctx, company);
        if (periodInfo != null && date.before(periodInfo.getBeginDate())) {
            date = periodInfo.getBeginDate();
        }
        return date;
    }

    public static void appointmentAccount4Verify(Context ctx, String entryID, AccountViewInfo recPayAcct, AccountViewInfo oppAccount, PeriodInfo currentPeriod) throws BOSException, EASBizException {
        int i;
        VerificationBillentryCollection arVerificationCol = null;
        com.kingdee.eas.fi.ap.VerificationBillentryCollection apVerificationCol = null;
        IVerificationBillentry arIVerificationBillEntry = VerificationBillentryFactory.getLocalInstance(ctx);
        com.kingdee.eas.fi.ap.IVerificationBillentry apIVerificationBillEntry = com.kingdee.eas.fi.ap.VerificationBillentryFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setEntryPermCol(true);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("parent.bizDate");
        sic.add("parent.number");
        sic.add("account");
        sic.add("oppAccount");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("entryID", (Object)entryID, CompareType.EQUALS));
        ev.setSelector(sic);
        ev.setFilter(filter);
        arVerificationCol = arIVerificationBillEntry.getVerificationBillentryCollection(ev);
        apVerificationCol = apIVerificationBillEntry.getVerificationBillentryCollection(ev);
        if (arVerificationCol != null && arVerificationCol.size() > 0) {
            for (i = 0; i < arVerificationCol.size(); ++i) {
                VerificationBillentryInfo arInfo = arVerificationCol.get(i);
                if (arInfo.getParent().getBizDate().before(currentPeriod.getBeginDate())) {
                    throw new ArApCommonException(ArApCommonException.VERIFICATION_NOT_IN_CURRENT_PERIOD);
                }
                arInfo.setAccount(recPayAcct);
                arInfo.setOppAccount(oppAccount);
            }
        }
        if (apVerificationCol != null && apVerificationCol.size() > 0) {
            for (i = 0; i < apVerificationCol.size(); ++i) {
                com.kingdee.eas.fi.ap.VerificationBillentryInfo apInfo = apVerificationCol.get(i);
                if (apInfo.getParent().getBizDate().before(currentPeriod.getBeginDate())) {
                    throw new ArApCommonException(ArApCommonException.VERIFICATION_NOT_IN_CURRENT_PERIOD);
                }
                apInfo.setAccount(recPayAcct);
                apInfo.setOppAccount(oppAccount);
            }
        }
        sic.clear();
        sic.add("account");
        sic.add("oppAccount");
        arIVerificationBillEntry.updatePartialBatchData((IObjectCollection)arVerificationCol, sic);
        apIVerificationBillEntry.updatePartialBatchData((IObjectCollection)apVerificationCol, sic);
    }

    public static void checkForReverseClose(Context ctx, String companyID, boolean isAr, boolean isContrastByBillAccount, PeriodInfo startPeriod, PeriodInfo currentPeriod, PeriodInfo prePeriod) throws EASBizException, BOSException {
        if (isContrastByBillAccount) {
            String checkSql = "SELECT 1 FROM T_ARAP_CONTRASTPARAMRECORD WHERE FCOMPANYID = ? AND FISAR = ? AND FPERIODNUMBER >= ?";
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)checkSql, (Object[])new Object[]{companyID, isAr ? 1 : 0, currentPeriod.getNumber()});
            try {
                if (rowSet.next()) {
                    throw new ARAPContrastBizException(ARAPContrastBizException.AR_045_ENABLE_WITHOUT_CLOSE_ACCOUNT);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        NumericExceptionSubItem excpItem = null;
        if (null == startPeriod) {
            NumericExceptionSubItem numericExceptionSubItem = excpItem = isAr ? ARAPContrastBizException.AR_SYSTEM_NOT_ENABLED : ARAPContrastBizException.AP_SYSTEM_NOT_ENABLED;
        }
        if (null == currentPeriod) {
            NumericExceptionSubItem numericExceptionSubItem = excpItem = isAr ? ARAPContrastBizException.AR_SYSTEM_NO_CURRENT_PERIOD : ARAPContrastBizException.AP_SYSTEM_NO_CURRENT_PERIOD;
        }
        if (null != excpItem) {
            throw new ARAPContrastBizException(excpItem);
        }
        if (prePeriod == null) {
            throw new BalanceModelException(BalanceModelException.PREPERIODISNULL);
        }
    }

    public static void checkForReverseInit(Context ctx, String companyID, boolean isAr) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)companyID) || !BOSUuid.isValid((String)companyID, (boolean)false)) {
            return;
        }
        StringBuilder buf = new StringBuilder(200).append("SELECT FPERIODNUMBER FROM T_ARAP_CONTRASTPARAMRECORD WHERE FISINIT = 0 AND FCOMPANYID = '" + companyID + "' and FISAR = " + (isAr ? 1 : 0));
        IDbUtilFacade dbUtil = null == ctx ? DbUtilFacadeFactory.getRemoteInstance() : DbUtilFacadeFactory.getLocalInstance(ctx);
        IRowSet rs = dbUtil.executeQuery(buf.toString());
        try {
            if (rs.next()) {
                throw new ARAPContrastBizException(ARAPContrastBizException.CAN_NOT_REVERSE_INIT);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static void changeCurrentPeriodToPrevious(Context ctx, CompanyOrgUnitInfo currentCompany, boolean isAr) throws BOSException, EASBizException {
        String companyID = currentCompany.getId().toString();
        SystemEnum systemEnum = isAr ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        SystemStatusCtrolInfo sysStsCtrInfo = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyID, systemEnum);
        PeriodInfo currentPeriod = null;
        if (sysStsCtrInfo != null) {
            currentPeriod = sysStsCtrInfo.getCurrentPeriod();
        }
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        boolean isContrastByBillAccount = false;
        if (currentPeriod != null) {
            isContrastByBillAccount = ArApParamHelper.isContrastByBillAccount(ctx, companyID, currentPeriod.getNumber(), isAr);
        }
        ArrayList<String> tableNames = new ArrayList<String>(3);
        if (isAr) {
            tableNames.add("T_AR_ArBalance");
            if (isContrastByBillAccount) {
                tableNames.add("T_AR_ArBillAccountBalance");
            } else {
                tableNames.add("T_AR_ArBalanceCollate");
            }
        } else {
            tableNames.add("T_AP_ApBalance");
            if (isContrastByBillAccount) {
                tableNames.add("T_AP_ApBillAccountBalance");
            } else {
                tableNames.add("T_AP_ApBalanceCollate");
            }
        }
        ArApServerUtils.changePeriodToPrevious(ctx, companyID, isContrastByBillAccount, sysStsCtrInfo, currentPeriod, tableNames, isAr);
        if (prePeriod != null) {
            String taskID = isAr ? "rM52TBYcQFeaZMTzrzcMfM4XzhY=" : "ovBdLuutTl2CO/mJXrhncc4XzhY=";
            FIClosingCenterFacadeFactory.getLocalInstance((Context)ctx).taskExecutionRecord(companyID, taskID, prePeriod.getId().toString(), true);
        }
    }

    private static void changePeriodToPrevious(Context ctx, String companyID, boolean isContrastByBillAccount, SystemStatusCtrolInfo sysStsCtrInfo, PeriodInfo currentPeriod, List<String> tableNames, boolean isAr) throws BOSException, EASBizException {
        PeriodInfo startPeriod = null;
        if (sysStsCtrInfo != null) {
            startPeriod = sysStsCtrInfo.getStartPeriod();
        }
        PeriodInfo prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK pk = new ObjectUuidPK(sysStsCtrInfo.getId());
        while (prePeriod != null && prePeriod.isIsAdjustPeriod()) {
            ArApServerUtils.checkForReverseClose(ctx, companyID, isAr, isContrastByBillAccount, startPeriod, currentPeriod, prePeriod);
            ArApServerUtils.reverseCloseBalance(ctx, companyID, currentPeriod, prePeriod, tableNames);
            if (prePeriod.getId().equals((Object)startPeriod.getId())) {
                sysStsCtrInfo.setCurrentPeriod(prePeriod);
                systemStatusCtrol.update((IObjectPK)pk, (CoreBaseInfo)sysStsCtrInfo);
                return;
            }
            currentPeriod = prePeriod;
            prePeriod = PeriodUtils.getPrePeriodInfo((Context)ctx, (PeriodInfo)currentPeriod);
        }
        ArApServerUtils.checkForReverseClose(ctx, companyID, isAr, isContrastByBillAccount, startPeriod, currentPeriod, prePeriod);
        ArApServerUtils.reverseCloseBalance(ctx, companyID, currentPeriod, prePeriod, tableNames);
        sysStsCtrInfo.setCurrentPeriod(prePeriod);
        sysStsCtrInfo.setIsClosedAccount(false);
        systemStatusCtrol.update((IObjectPK)pk, (CoreBaseInfo)sysStsCtrInfo);
    }

    public static void reverseCloseBalance(Context ctx, String companyID, PeriodInfo curPeriod, PeriodInfo prePeriod, List<String> tableNames) throws BOSException {
        if (StringUtils.isEmpty((String)companyID) || null == curPeriod || null == prePeriod || CommonUtils.isEmpty(tableNames)) {
            return;
        }
        int size = tableNames.size();
        String[] sqlArray = new String[2 * size];
        StringBuilder buf = new StringBuilder(200);
        for (int i = 0; i < size; ++i) {
            buf.append("DELETE FROM ").append(tableNames.get(i)).append(" WHERE FCOMPANYID = '").append(companyID).append("' AND FPERIODID = '").append(curPeriod.getId().toString()).append("' ");
            sqlArray[2 * i] = buf.toString();
            buf.setLength(0);
            logger.info((Object)("=>\u5220\u9664\u4f59\u989d\u8868\u3010" + tableNames.get(i) + "\u3011\u672c\u671f\u3010" + curPeriod.getNumber() + "\u3011\u4f59\u989d\u6570\u636e"));
            buf.append("UPDATE ").append(tableNames.get(i)).append(" SET FYEARDEBITFOR = FYEARDEBITFOR - FDEBITFOR, ").append(" \r\n ").append(" FYEARDEBITLOCAL = FYEARDEBITLOCAL - FDEBITLOCAL, ").append(" \r\n ").append(" FYEARCREDITFOR = FYEARCREDITFOR - FCREDITFOR, ").append(" \r\n ").append(" FYEARCREDITLOCAL = FYEARCREDITLOCAL - FCREDITLOCAL, ").append(" \r\n ").append(" FCREDITFOR = 0.0, FDEBITFOR = 0.0, FENDBALANCEFOR = 0.0, ").append(" \r\n ").append(" FCREDITLOCAL = 0.0, FDEBITLOCAL = 0.0, FENDBALANCELOCAL = 0.0  ").append(" \r\n ").append(" WHERE FCOMPANYID ='").append(companyID).append("'").append(" \r\n ").append(" AND FPERIODID = '").append(prePeriod.getId().toString()).append("'");
            sqlArray[2 * i + 1] = buf.toString();
            buf.setLength(0);
            logger.info((Object)("=>\u66f4\u65b0\u4e0a\u4e00\u671f\u3010" + prePeriod.getNumber() + "\u3011\u4f59\u989d\u8868\u3010" + tableNames.get(i) + "\u3011\u4f59\u989d\u6570\u636e"));
        }
        KsqlUtil.execute((Context)ctx, (String[])sqlArray);
    }

    public static RowSet getArApBalance(Context ctx, HashMap filter, int checkType, Boolean isBalanceAmt, Boolean isAr) throws EASBizException, BOSException {
        ObjectUuidPK orgPk = new ObjectUuidPK(filter.get("company_id").toString());
        String tableName = (String)filter.get("tableName");
        String contrastTableName = (String)filter.get("contrastTableName");
        Boolean isNewContrast = false;
        if ("T_AR_ArBillAccountBalance".equalsIgnoreCase(contrastTableName) || "T_AP_ApBillAccountBalance".equalsIgnoreCase(contrastTableName)) {
            isNewContrast = true;
        }
        StringBuffer sb = new StringBuffer(" select ");
        sb.append("t1.FAsstActID as acctcuss_id,");
        if (isBalanceAmt.booleanValue()) {
            sb.append("t2.FNumber as acctcuss_number,");
            sb.append("t2.FName_").append(ctx.getLocale().getLanguage()).append(" as acctcuss_name,");
        } else {
            sb.append("max(t2.FNumber) as acctcuss_number,");
            sb.append("max(t2.FName_").append(ctx.getLocale().getLanguage()).append(") as acctcuss_name,");
        }
        sb.append(ArApServerUtils.getArApBalanceAmtSql(checkType, isAr));
        sb.append("from " + contrastTableName + " t1 ");
        sb.append("inner join ").append(tableName).append(" t2 on t1.FAsstActID = t2.FID ");
        sb.append("where t1.FCompanyID = '").append(filter.get("company_id")).append("' ");
        if (isNewContrast.booleanValue()) {
            sb.append(" and t1.FISDELETED = 0 ");
        }
        sb.append("and t1.FCurrencyID = '").append(filter.get("currency_id")).append("' ");
        sb.append("and t1.FPeriodID = '").append(filter.get("period_id")).append("' ");
        sb.append("and t1.FAsstActTypeID = '").append(filter.get("asstacttype_id")).append("' ");
        sb.append("and t1.FAccount = '").append(filter.get("account_id")).append("' ");
        if (filter.get("asstact_id") != null) {
            sb.append("and t1.FAsstActID = '").append(filter.get("asstact_id")).append("' ");
        }
        sb.append(" group by t1.FAsstActID ");
        if (isBalanceAmt.booleanValue()) {
            sb.append(",t2.FNumber,t2.FName_").append(ctx.getLocale().getLanguage());
        }
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }

    public static String getArApBalanceAmtSql(Integer checkType, boolean isAr) {
        StringBuffer sb = new StringBuffer(300);
        switch (checkType) {
            case 0: {
                sb.append("sum(t1.FYearDebitFor - t1.FDebitFor) as debitAmt,");
                sb.append("0.0 as debitAmtLoc,");
                sb.append("sum(t1.FYearCreditFor - t1.FCreditFor) as creditAmt,");
                sb.append("0.0 as creditAmtLoc,");
                if (!isAr) {
                    sb.append("-1*");
                }
                sb.append("sum(t1.FBeginBalanceFor) as periodAmt,0.0 as periodAmtLoc ");
                break;
            }
            case 1: {
                sb.append("0.0 as debitAmt,");
                sb.append("sum(t1.FYearDebitLocal - t1.FDebitLocal) as debitAmtLoc,");
                sb.append("0.0 as creditAmt,");
                sb.append("sum(t1.FYearCreditLocal - t1.FCreditLocal) as creditAmtLoc,");
                sb.append("0.0 as periodAmt,");
                if (!isAr) {
                    sb.append("-1*");
                }
                sb.append("sum(t1.FBeginBalanceLocal) as periodAmtLoc ");
                break;
            }
            case 2: {
                sb.append("sum(t1.FYearDebitFor - t1.FDebitFor) as debitAmt,");
                sb.append("sum(t1.FYearDebitLocal - t1.FDebitLocal) as debitAmtLoc,");
                sb.append("sum(t1.FYearCreditFor - t1.FCreditFor) as creditAmt,");
                sb.append("sum(t1.FYearCreditLocal - t1.FCreditLocal) as creditAmtLoc,");
                if (!isAr) {
                    sb.append("-1*");
                }
                sb.append("sum(t1.FBeginBalanceFor) as periodAmt,");
                if (!isAr) {
                    sb.append("-1*");
                }
                sb.append("sum(t1.FBeginBalanceLocal) as periodAmtLoc ");
            }
        }
        return sb.toString();
    }

    public static String getContrastTableName(Boolean isNewContrast, Boolean isAr) {
        String tableName = "";
        tableName = isAr.booleanValue() ? (isNewContrast.booleanValue() ? "T_AR_ArBillAccountBalance" : "T_AR_ARBALANCECOLLATE") : (isNewContrast != false ? "T_AP_ApBillAccountBalance" : "T_AP_APBalancecollate");
        return tableName;
    }

    public static RowSet getGlBalance(Context ctx, HashMap filter, int checkType, Boolean isBalanceAmt, Boolean isAr) throws EASBizException, BOSException {
        ObjectUuidPK orgPk = new ObjectUuidPK(filter.get("company_id").toString());
        String tableName = (String)filter.get("tableName");
        String fieldName = (String)filter.get("fieldName");
        StringBuffer sb = new StringBuffer(" select ");
        sb.append("t2.").append(fieldName).append(" as acctcuss_id,");
        if (isBalanceAmt.booleanValue()) {
            sb.append("t3.Fnumber as acctcuss_number,");
            sb.append("t3.FName_").append(ctx.getLocale().getLanguage()).append(" acctcuss_name,");
        } else {
            sb.append("max(t3.Fnumber) as acctcuss_number,");
            sb.append("max(t3.FName_").append(ctx.getLocale().getLanguage()).append(") acctcuss_name,");
        }
        sb.append(ArApServerUtils.getGLBalanceAmtSql(checkType, isAr));
        sb.append("from T_GL_AssistBalance_5f t1 ");
        sb.append("inner join T_BD_AssistantHG t2 on t1.FAssistGrpID = t2.FID ");
        sb.append("inner join ").append(tableName).append(" t3 on t2.").append(fieldName).append(" = t3.FID ");
        sb.append("where (t1.FOrgUnitID = '").append(filter.get("company_id").toString()).append("') ");
        sb.append("and (t1.FCurrencyID = '").append(filter.get("currency_id").toString()).append("') ");
        sb.append("and (t1.FAccountID = '").append(filter.get("account_id")).append("') ");
        sb.append("and (t1.FPeriod = ").append(filter.get("period_number")).append(") ");
        sb.append("group by t2.").append(fieldName);
        sb.append(",t3.Fnumber ");
        sb.append(",t3.FName_").append(ctx.getLocale().getLanguage());
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        return result;
    }

    public static String getGLBalanceAmtSql(Integer checkType, Boolean isAr) {
        StringBuilder sb = new StringBuilder(300);
        switch (checkType) {
            case 0: {
                sb.append("sum(t1.FYearDebitFor - t1.FDebitFor) as glDebitAmt,");
                sb.append("0.0 as glDebitAmtLoc,");
                sb.append("sum(t1.FYearCreditFor - t1.FCreditFor) as glCreditAmt,");
                sb.append("0.0 as glCreditAmtLoc,");
                if (!isAr.booleanValue()) {
                    sb.append("-1*");
                }
                sb.append("sum(t1.FBeginBalanceFor) as glPeriodAmt,");
                sb.append("0.0 as glPeriodAmtLoc ");
                break;
            }
            case 1: {
                sb.append("0.0 as glDebitAmt,");
                sb.append("sum(t1.FYearDebitLocal - t1.FDebitLocal) as glDebitAmtLoc,");
                sb.append("0.0 as glCreditAmt,");
                sb.append("sum(t1.FYearCreditLocal - t1.FCreditLocal) as glCreditAmtLoc,");
                sb.append("0.0 as glPeriodAmt,");
                if (!isAr.booleanValue()) {
                    sb.append("-1*");
                }
                sb.append("sum(t1.FBeginBalanceLocal) as glPeriodAmtLoc ");
                break;
            }
            case 2: {
                sb.append("sum(t1.FYearDebitFor - t1.FDebitFor) as glDebitAmt,");
                sb.append("sum(t1.FYearDebitLocal - t1.FDebitLocal) as glDebitAmtLoc,");
                sb.append("sum(t1.FYearCreditFor - t1.FCreditFor) as glCreditAmt,");
                sb.append("sum(t1.FYearCreditLocal - t1.FCreditLocal) as glCreditAmtLoc,");
                if (!isAr.booleanValue()) {
                    sb.append("-1*");
                }
                sb.append("sum(t1.FBeginBalanceFor) as glPeriodAmt,");
                if (!isAr.booleanValue()) {
                    sb.append("-1*");
                }
                sb.append("sum(t1.FBeginBalanceLocal) as glPeriodAmtLoc ");
            }
        }
        return sb.toString();
    }

    public static String getContrastBalanceSql(String contrastCondition, Boolean isAmountLocal) {
        StringBuilder sql = new StringBuilder(150);
        if ("0".equals(contrastCondition)) {
            sql.append(" FStartDiffAmt != 0 or FDebitDiffAmt != 0 or FCreditDiffAmt != 0 or FBalanceDiffAmt != 0 ");
            if (isAmountLocal.booleanValue()) {
                sql.append("or FStartDiffAmtLocal != 0 or FDebitDiffAmtLocal != 0 or FCreditDiffAmtLocal != 0 or FBalanceDiffAmtLocal != 0 ");
            }
        } else if ("1".equals(contrastCondition)) {
            sql.append(" FDebitDiffAmt != 0 or FCreditDiffAmt != 0 ");
            if (isAmountLocal.booleanValue()) {
                sql.append(" or FDebitDiffAmtLocal != 0 or FCreditDiffAmtLocal != 0 ");
            }
        } else if ("2".equals(contrastCondition)) {
            sql.append(" FBalanceDiffAmt != 0 ");
            if (isAmountLocal.booleanValue()) {
                sql.append(" or FBalanceDiffAmtLocal != 0 ");
            }
        }
        return sql.toString();
    }

    public static int isContrastEqual(Context ctx, String tempTableId) throws BOSException {
        int result = 1;
        if (null == tempTableId || tempTableId.length() == 0) {
            return result;
        }
        StringBuilder buf = new StringBuilder(60).append("SELECT 1 From ").append(tempTableId).append(" WHERE FISDIFF = 1 ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)buf.toString());
        try {
            if (rs.next()) {
                result = 0;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    public static void batchAfterLog(Context ctx, IObjectPK[] pkArr) throws BOSException {
        if (null != pkArr && pkArr.length > 0) {
            ArrayList<String[]> params = new ArrayList<String[]>(pkArr.length);
            for (int i = 0; i < pkArr.length; ++i) {
                if (null == pkArr[i]) continue;
                params.add(new String[]{pkArr[i].toString()});
            }
            String sql = "UPDATE T_LOG_APP SET FISSUCCESSED = 1 WHERE FID = ?";
            DbUtil.executeBatch((Context)ctx, (String)sql, params);
        }
    }

    public static void checkBillStatusForBotp(Context ctx, IObjectCollection collection, String[] checkBosType) throws BOSException, EASBizException {
        if (collection == null || collection.size() == 0) {
            return;
        }
        IObjectCollection entry = null;
        entry = (IObjectCollection)collection.getObject(0).get("entry");
        if (entry == null) {
            entry = (IObjectCollection)collection.getObject(0).get("entrys");
        }
        BOSUuid bosUuid = (BOSUuid)entry.getObject(0).get("sourceBillId");
        BOSObjectType bosType = null;
        if (bosUuid != null) {
            bosType = bosUuid.getType();
        }
        String bosTypeStr = String.valueOf(bosType);
        if (checkBosType == null) {
            return;
        }
        boolean isNeedCheck = false;
        for (int i = 0; i < checkBosType.length; ++i) {
            if (!bosTypeStr.equals(checkBosType[i])) continue;
            isNeedCheck = true;
            break;
        }
        if (!isNeedCheck) {
            return;
        }
        ICoreBillBase iBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosType);
        ArrayList<ObjectUuidPK> srcBillPks = new ArrayList<ObjectUuidPK>();
        IObjectValue info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = collection.getObject(i);
            entry = (IObjectCollection)info.get("entry");
            if (entry == null) {
                entry = (IObjectCollection)info.get("entrys");
            }
            for (int j = 0; j < entry.size(); ++j) {
                if (StringUtils.isEmpty((String)entry.getObject(j).getString("sourceBillId"))) continue;
                srcBillPks.add(new ObjectUuidPK(entry.getObject(j).getString("sourceBillId")));
            }
        }
        int auditValue = 3;
        int closedValue = -2;
        String billStatus = "FBILLSTATUS";
        if (iBillBase instanceof ISCMBillBase) {
            auditValue = 4;
            closedValue = 7;
            billStatus = "FBASESTATUS";
        }
        String tableName = DBUtil.getTableNameById(ctx, ((IObjectPK)srcBillPks.get(0)).toString());
        ArApServerUtils.checkSrcBillStatus(ctx, srcBillPks.toArray(new IObjectPK[1]), tableName, billStatus, new Integer[]{auditValue, closedValue});
    }

    public static void checkSrcBillStatus(Context ctx, IObjectPK[] srcBillPKs, String tableName, String statusField, Integer[] auditStatus) throws BOSException, EASBizException {
        if (srcBillPKs == null) {
            return;
        }
        HashSet<String> srcBillSet = new HashSet<String>();
        for (int i = 0; i < srcBillPKs.length; ++i) {
            srcBillSet.add(srcBillPKs[i].toString());
        }
        String pks = ListUtil.transList2String(srcBillSet);
        String status = ListUtil.transList2String4Number(Arrays.asList(auditStatus));
        if (StringUtils.isEmpty((String)pks) || StringUtils.isEmpty((String)tableName)) {
            return;
        }
        StringBuilder buf = new StringBuilder(100);
        String sourceBillCheckSql = buf.append("select count(1) from ").append(tableName).append(" where FID IN ").append(pks).toString();
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sourceBillCheckSql);
        try {
            boolean count = false;
            if (rs.next()) {
                int sourceBillCount = rs.getInt(1);
                if (srcBillSet.size() > sourceBillCount) {
                    throw new OtherBillBizException(OtherBillBizException.SOURCE_BILL_NOT_EXIST);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        buf.setLength(0);
        String chkSql = buf.append(" SELECT FNUMBER FROM ").append(tableName).append(" \r\n ").append(" WHERE ").append(statusField).append(" NOT IN (").append(status).append(")").append(" \r\n ").append(" AND FID IN ").append(pks).toString();
        rs = DBUtil.executeQuery((Context)ctx, (String)chkSql);
        buf.setLength(0);
        try {
            int count = 0;
            while (rs.next()) {
                if (count > 0) {
                    buf.append(",");
                }
                buf.append(rs.getString("FNUMBER"));
                ++count;
            }
            if (buf.length() > 0) {
                throw new OtherBillBizException(OtherBillBizException.NOTAUDITEDBILL, new Object[]{buf.toString()});
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static String getStrResource(Locale locale, String resKey, Object[] params) {
        if (params == null) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey, (Locale)locale);
        }
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)resKey, (Locale)locale, (Object[])params);
    }

    public static String getArResource(Locale locale, String resKey, Object[] params) {
        if (params == null) {
            return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArResource", (String)resKey, (Locale)locale);
        }
        return ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArResource", (String)resKey, (Locale)locale, (Object[])params);
    }

    public static void wrietOffBizLogForAutoVerification(Context ctx, List result, String companyId, String methodName) {
        if (result.size() == 0) {
            return;
        }
        HashMap<String, String> hashLog = new HashMap<String, String>(10);
        hashLog.put("FMethodName", methodName);
        hashLog.put("FMethodAlias", "\u81ea\u52a8\u7ed3\u7b97");
        SCMBizLogAdapter.writeBizLogForWriteOff((Context)ctx, hashLog, (IObjectPK)new ObjectUuidPK(companyId), new HashSet(result));
    }

    public static void batchRecycleNumber(Context ctx, List<IObjectValue> bills) throws BOSException {
        if (null == ctx || null == bills || bills.size() == 0) {
            return;
        }
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        HashMap recycleNumMap = new HashMap();
        HashMap<String, IObjectValue> recycleBillMap = new HashMap<String, IObjectValue>();
        try {
            for (int i = 0; i < bills.size(); ++i) {
                IObjectValue bill = bills.get(i);
                String id = bill.getString("id");
                String number = bill.getString("number");
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)bill.get("company");
                if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)number) || null == company) continue;
                String companyId = company.getId().toString();
                String bostype = BOSUuid.read((String)id).getType().toString();
                String key = bostype + "_" + companyId;
                if (null == recycleNumMap.get(key)) {
                    recycleNumMap.put(key, new ArrayList());
                }
                ((List)recycleNumMap.get(key)).add(number);
                if (null != recycleBillMap.get(key)) continue;
                recycleBillMap.put(key, bill);
            }
            if (recycleNumMap.size() == 0) {
                return;
            }
            for (String key : recycleNumMap.keySet()) {
                List numbers = (List)recycleNumMap.get(key);
                String companyId = key.split("_")[1];
                CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)recycleBillMap.get(key), companyId);
                if (codingRule == null) continue;
                iCodingRuleManager.recycleBatchNumber((IObjectValue)recycleBillMap.get(key), companyId, numbers.toArray(new String[numbers.size()]));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private static boolean canDAPVoucherAddEntry(Context ctx) throws BOSException {
        boolean canModifyEntry = false;
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"SELECT FVALUE FROM T_ARAP_COMMONPARAM WHERE FNUMBER = 'canDAPVoucherAddEntry'");
        try {
            if (rs.next() && "1".equals(rs.getString("FVALUE"))) {
                canModifyEntry = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return canModifyEntry;
    }

    public static void canDapVoucherModifyEntry(Context ctx, String srcBillId, String destBillId, String companyId) throws BOSException, EASBizException {
        if (ArApServerUtils.canDAPVoucherAddEntry(ctx)) {
            return;
        }
        ArrayList<SystemEnum> systemEnums = new ArrayList<SystemEnum>();
        systemEnums.add(SystemEnum.ACCOUNTSRECEIVABLE);
        systemEnums.add(SystemEnum.ACCOUNTSPAYABLE);
        Map<SystemEnum, SystemStatusCtrolInfo> map = CommonServerUtils.getSysStatusInfoMap(ctx, companyId, systemEnums);
        PeriodInfo arPeriod = map.get(SystemEnum.ACCOUNTSRECEIVABLE).getCurrentPeriod();
        PeriodInfo apPeriod = map.get(SystemEnum.ACCOUNTSPAYABLE).getCurrentPeriod();
        StringBuilder sb = new StringBuilder(500);
        sb.append("SELECT DISTINCT VOUENTRY.FID FID FROM T_GL_VOUCHERENTRY VOUENTRY ").append(" \r\n ");
        sb.append("  INNER JOIN T_AR_CONTRASTACCOUNTVIEW ACCOUNT ").append(" \r\n ");
        sb.append("\t   ON VOUENTRY.FACCOUNTID = ACCOUNT.FACCOUNTID ").append(" \r\n ");
        sb.append(" AND (( 1= 1").append(" \r\n ");
        if (arPeriod != null) {
            sb.append(" AND account.FSystem = ").append(1).append(" \r\n ");
            sb.append(" AND account.FPeriodYear = ").append(arPeriod.getPeriodYear()).append(" \r\n ");
            sb.append(" AND account.FPeriodNumber = ").append(arPeriod.getPeriodNumber()).append(" \r\n ");
        }
        sb.append(") OR ( 1= 1 ");
        if (apPeriod != null) {
            sb.append(" AND account.FSystem = ").append(2).append(" \r\n ");
            sb.append(" AND account.FPeriodYear = ").append(apPeriod.getPeriodYear()).append(" \r\n ");
            sb.append(" AND account.FPeriodNumber = ").append(apPeriod.getPeriodNumber()).append(" \r\n ");
        }
        sb.append(")) AND account.FCompanyID = '").append(companyId).append("' ").append(" \r\n ");
        sb.append("WHERE VOUENTRY.FBILLID = '").append(destBillId).append("' ").append(" \r\n ");
        sb.append(" AND NOT EXISTS (SELECT 1 FROM T_AR_ARAPRELATIONENTRY REL ").append(" \r\n ");
        sb.append("                 WHERE VOUENTRY.FID = REL.FDESTENTRYID ").append(" \r\n ");
        sb.append("                   AND REL.FDESTOBJECTID = '").append(destBillId).append("'").append(" \r\n ");
        sb.append("                   AND REL.FSRCOBJECTID IN ").append(srcBillId).append(" \r\n ");
        sb.append("                )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        if (null != rs && rs.size() > 0) {
            throw new OtherBillBizException(OtherBillBizException.VOUCHER_FROM_DAP);
        }
    }

    public static void writeRecBillVoucherInfo4BadAcctCollect(Context ctx, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectPK[] ids) throws BOSException {
        if (null == bOTBillOperStateEnum || null == ids || ids.length == 0) {
            return;
        }
        ArrayList<String> idList = new ArrayList<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idList.add(ids[i].toString());
        }
        ArApServerUtils.writeRecBillVoucherInfo4BadAcctCollect(ctx, bOTBillOperStateEnum, idList);
    }

    public static void writeRecBillVoucherInfo4BadAcctCollect(Context ctx, BOTBillOperStateEnum bOTBillOperStateEnum, List<String> ids) throws BOSException {
        if (null == bOTBillOperStateEnum || null == ids || ids.size() == 0) {
            return;
        }
        if (!BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum) && !BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            return;
        }
        if (!"3C41FD86".equals(BOSUuid.read((String)ids.get(0)).getType().toString())) {
            return;
        }
        String idSql = ArApServerUtils.transList2String(new HashSet<String>(ids));
        VerificationBillentryCollection verEntryCol = null;
        VerificationBillInfo info = null;
        VerificationBillentryInfo verEntryInfo = null;
        String receivingBillID = null;
        StringBuilder strBuf = new StringBuilder(100);
        StringBuilder sqlBuf = new StringBuilder(300);
        HashSet<String> idSet = new HashSet<String>(10);
        VerificationBillCollection verCol = VerificationBillFactory.getLocalInstance(ctx).getVerificationBillCollection(" where id in " + idSql);
        HashMap<String, String> idMap = new HashMap<String, String>();
        ArrayList<String> srcBillIds = new ArrayList<String>();
        int size = verCol.size();
        for (int i = 0; i < size; ++i) {
            info = verCol.get(i);
            if (info.getVerificationType().getValue() != 111 && info.getVerificationType().getValue() != 112) continue;
            verEntryCol = info.getEntrys();
            strBuf.setLength(0);
            idSet.clear();
            int entrySize = verEntryCol.size() - 1;
            for (int j = 0; j <= entrySize; ++j) {
                verEntryInfo = verEntryCol.get(j);
                if (!VerificateBillTypeEnum.ReceiveBill.equals((Object)verEntryInfo.getBillType()) || idSet.contains(receivingBillID = verEntryInfo.getBillID().toString())) continue;
                idSet.add(receivingBillID);
                strBuf.append("'").append(receivingBillID).append("'");
                if (j == entrySize) continue;
                strBuf.append(",");
            }
            sqlBuf.setLength(0);
            sqlBuf.append("update t_cas_receivingbill set ffiVouchered= ?, fvoucherid=?, fvoucherNumber = ?, fvoucherTypeid = ?");
            sqlBuf.append(" where fid in (").append(strBuf.toString()).append(")");
            Object[] params = null;
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                params = new Object[]{0, null, null, null};
                srcBillIds.addAll(idSet);
            } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
                String voucherId = info.getVoucher().getId().toString();
                params = new Object[]{1, voucherId, info.getVoucherNumber(), info.getVoucherType().getId().toString()};
                Iterator it = idSet.iterator();
                while (it.hasNext()) {
                    idMap.put((String)it.next(), voucherId);
                }
            }
            DbUtil.execute((Context)ctx, (String)sqlBuf.toString(), params);
        }
        if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            ArApServerUtils.deleteBotpRelation(ctx, srcBillIds, "2652E01E");
        } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            ArApServerUtils.addBotpRelation(ctx, idMap);
        }
    }

    public static void addBotpRelation(Context ctx, Map<String, String> idMap) throws BOSException {
        if (null == ctx || null == idMap || idMap.isEmpty()) {
            return;
        }
        StringBuilder buf = new StringBuilder(200);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            buf.append("INSERT INTO t_bot_relation(FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FOperatorID,FisEffected,FType,FDate)");
            buf.append(" values(?,?,?,?,?,?,?,?,?)");
            pstmt = conn.prepareStatement(buf.toString());
            Iterator<String> kit = idMap.keySet().iterator();
            java.sql.Date createTime = new java.sql.Date(System.currentTimeMillis());
            while (kit.hasNext()) {
                String srcObjectID = kit.next();
                String dstObjectID = idMap.get(srcObjectID);
                pstmt.setString(1, BOSUuid.create((String)"59302EC6").toString());
                pstmt.setString(2, BOSUuid.getBOSObjectType((String)srcObjectID, (boolean)true).toString());
                pstmt.setString(3, BOSUuid.getBOSObjectType((String)dstObjectID, (boolean)true).toString());
                pstmt.setString(4, srcObjectID);
                pstmt.setString(5, dstObjectID);
                pstmt.setString(6, "unknown");
                pstmt.setInt(7, 1);
                pstmt.setInt(8, 0);
                pstmt.setDate(9, createTime);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void deleteBotpRelation(Context ctx, List<String> srcBillIDs, String dstBosType) throws BOSException {
        if (null == ctx || null == srcBillIDs || srcBillIDs.size() == 0 || StringUtils.isEmpty((String)dstBosType)) {
            return;
        }
        StringBuilder buf = new StringBuilder(200);
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            buf.append("delete from T_BOT_RELATION where fsrcObjectID = ? and FDestEntityID = ?");
            pstmt = conn.prepareStatement(buf.toString());
            for (int i = 0; i < srcBillIDs.size(); ++i) {
                pstmt.setString(1, srcBillIDs.get(i));
                pstmt.setString(2, dstBosType);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static LockResult requestLocks(Context ctx, List<String> idList) throws BOSException {
        LockResult lockResult = new LockResult();
        Map lockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(idList);
        if (lockMap != null) {
            for (String id : idList) {
                if (lockMap.containsKey(id) && ((Boolean)lockMap.get(id)).booleanValue()) {
                    lockResult.getLockedIds().add(id);
                    continue;
                }
                lockResult.getErrorIds().add(id);
            }
        }
        return lockResult;
    }

    public static void releaseLocks(Context ctx, LockResult lockResult) throws BOSException {
        Set<String> lockList = lockResult.getLockedIds();
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(Arrays.asList(lockList.toArray()));
        }
    }
}

