/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.util;

import com.aliyun.odps.utils.StringUtils;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillBizException;
import com.kingdee.eas.fi.ap.app.util.DateUtils;
import com.kingdee.eas.fi.arap.DateRangeEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ArApVerifyUtil {
    public static String getDateFilter(DateRangeEnum dateRange) throws OtherBillBizException {
        int dateVal = dateRange.getValue();
        String beginDate = null;
        String endDate = null;
        String dateFormat = "yyyy-MM-dd HH:mm:ss";
        switch (dateVal) {
            case 1: {
                beginDate = DateUtils.date2String(DateUtils.getDayBegin(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getDayEnd(), dateFormat);
                break;
            }
            case 7: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfWeek(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfWeek(), dateFormat);
                break;
            }
            case 30: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfMonth(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 90: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastThreeMonth(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 180: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastHalfYear(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 365: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastOneYear(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 1095: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastThreeYear(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
                break;
            }
            case 1825: {
                beginDate = DateUtils.date2String(DateUtils.getBeginDayOfLastFiveYear(), dateFormat);
                endDate = DateUtils.date2String(DateUtils.getEndDayOfMonth(), dateFormat);
            }
        }
        StringBuffer sbFormula = new StringBuffer();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        int i = 0;
        FilterItemInfo fromBillDateFilter = new FilterItemInfo("bizDate", (Object)beginDate, CompareType.GREATER_EQUALS);
        items.add(fromBillDateFilter);
        sbFormula.append("#" + i++);
        FilterItemInfo toBillDateFilter = new FilterItemInfo("bizDate", (Object)endDate, CompareType.LESS_EQUALS);
        items.add(toBillDateFilter);
        sbFormula.append(" and #" + i++);
        filter.setMaskString(sbFormula.toString());
        return filter.toString();
    }

    public static Set<String> getCompanyIds(Context ctx, IObjectCollection companyRange) throws BOSException {
        HashSet<String> companySet = new HashSet<String>();
        for (IObjectValue companyInfo : companyRange) {
            if (null == companyInfo.get("id")) continue;
            companySet.add(companyInfo.get("id").toString());
        }
        return companySet;
    }

    public static Map getVerifyDateSortTypeParam(Context ctx, String companyId) throws BOSException {
        if (StringUtils.isEmpty((String)companyId)) {
            return null;
        }
        IParamControl iParamControl = null;
        iParamControl = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap paramValueMap = null;
        HashMap<String, ObjectUuidPK> keyMap = new HashMap<String, ObjectUuidPK>();
        ObjectUuidPK companyPK = new ObjectUuidPK(companyId);
        keyMap.put("AR_040", companyPK);
        keyMap.put("AP_034", companyPK);
        try {
            paramValueMap = iParamControl.getParamHashMap(keyMap);
        }
        catch (EASBizException e) {
            throw new BOSException(e.getMessage());
        }
        return paramValueMap;
    }

    public static SorterItemCollection getSortItemColl(Context ctx, String companyId, boolean isAr) throws BOSException {
        String sortField = "billDate";
        Map paramValueMap = ArApVerifyUtil.getVerifyDateSortTypeParam(ctx, companyId);
        if (paramValueMap != null) {
            if (isAr) {
                String AR_040 = paramValueMap.get("AR_040").toString();
                if ("1".equalsIgnoreCase(AR_040)) {
                    sortField = "bizDate";
                }
            } else {
                String AP_034 = paramValueMap.get("AP_034").toString();
                if ("1".equalsIgnoreCase(AP_034)) {
                    sortField = "bizDate";
                }
            }
        }
        SorterItemCollection sorterItemColl = new SorterItemCollection();
        sorterItemColl.add(new SorterItemInfo(sortField));
        return sorterItemColl;
    }
}

