/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.ar.app.ArApReportHelper;
import com.kingdee.eas.fi.arap.ArapRcProjectEnum;
import com.kingdee.eas.fi.arap.app.util.TempTableUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.arap.util.paramconvertor.ContrastGLRptParamConvertor;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArapContrastDiffRptUtils {
    public static final String RT = "\r\n";
    private static Logger logger = Logger.getLogger(ArapContrastDiffRptUtils.class);

    public static Map createTable(Context ctx, boolean fAR, String companyId, String periodId, String acctId, int project, String asstActId, String currencyId, String cussTypeID) throws BOSException, EASBizException {
        HashMap<String, Object> filterMap = new HashMap<String, Object>();
        long st = System.currentTimeMillis();
        PeriodInfo period = PeriodFactory.getLocalInstance((Context)ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        ContrastGLQueryParam param = ArapContrastDiffRptUtils.getRptParam(ctx, fAR, companyId, period);
        AsstActTypeInfo asstActType = null;
        if (cussTypeID != null && !"null".equalsIgnoreCase(cussTypeID)) {
            asstActType = (AsstActTypeInfo)AsstActTypeFactory.getLocalInstance((Context)ctx).getValue("select id,mappingFieldName  where id ='" + cussTypeID + "'");
        }
        CompanyOrgUnitInfo company = ArapContrastDiffRptUtils.getCompanyOrgUnitInfo(ctx, companyId);
        String currentAcctTableID = ArapContrastDiffRptUtils.getCurrentAcctTable(ctx, company, period);
        String beginDate = ArapContrastDiffRptUtils.convertDateToString(period.getBeginDate());
        String endDate = ArapContrastDiffRptUtils.convertDateToString(ArapContrastDiffRptUtils.upTimestamp(period.getEndDate()));
        String cu = company.getCU().getId().toString();
        int periodYear = period.getPeriodYear();
        int periodNum = period.getPeriodNumber();
        String periodInfo = periodYear + ArapContrastDiffRptUtils.getResource("year") + periodNum + ArapContrastDiffRptUtils.getResource("periodNum");
        String accountId = "'" + acctId + "'";
        if (param.isBySum()) {
            List idFormula = param.getAcctFormula();
            accountId = ArapContrastDiffRptUtils.convertToString(idFormula.toArray());
        }
        filterMap.put("companyId", companyId);
        filterMap.put("periodId", periodId);
        filterMap.put("currentAcctTableID", currentAcctTableID);
        filterMap.put("beginDate", beginDate);
        filterMap.put("endDate", endDate);
        filterMap.put("cu", cu);
        filterMap.put("periodYear", periodYear);
        filterMap.put("periodNum", periodNum);
        filterMap.put("periodInfo", periodInfo);
        filterMap.put("asstActId", asstActId);
        filterMap.put("accID", accountId);
        filterMap.put("project", project);
        filterMap.put("currencyId", currencyId);
        filterMap.put("isDAPCheckAccount", ArApParamHelper.isDAPCheckAccount(ctx));
        if (asstActType != null) {
            filterMap.put("assistanthg", asstActType.getMappingFieldName());
        }
        CurrencyInfo currency = ArapContrastDiffRptUtils.getCurrencyInfo(ctx, currencyId);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        long et = System.currentTimeMillis();
        logger.info((Object)("computeAcctBalance:::" + (et - st)));
        resultMap.put("queryId", ArapContrastDiffRptUtils.createTable(ctx, filterMap));
        long eet = System.currentTimeMillis();
        logger.info((Object)("createTable:::" + (eet - st)));
        resultMap.put("title", ArapContrastDiffRptUtils.getContrastDiffTitle(ctx, company, period, currency, acctId, param.isBySum(), project));
        resultMap.put("precision", currency.getPrecision());
        return resultMap;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String companyId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = null;
        if (!StringUtils.isEmpty((String)companyId)) {
            company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("select id,name,number,accountTable.id,CU.id  where id ='" + companyId + "'");
        }
        return company;
    }

    public static CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws BOSException, EASBizException {
        CurrencyInfo currency = null;
        if (!StringUtils.isEmpty((String)currencyId)) {
            currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        }
        return currency;
    }

    public static String getContrastDiffTitle(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period, CurrencyInfo currency, String acctId, boolean isBySum, int project) throws BOSException, EASBizException {
        StringBuilder title = new StringBuilder(200);
        title.append(company.getName()).append("\u3000|\u3000");
        if (!isBySum) {
            AccountViewInfo account = AccountViewFactory.getLocalInstance((Context)ctx).getAccountViewInfo("select id,name,number  where id ='" + acctId + "'");
            title.append(account.getNumber()).append(" ").append(account.getName()).append("\u3000|\u3000");
        }
        title.append(period.getPeriodYear() + ArapContrastDiffRptUtils.getResource("year") + period.getPeriodNumber() + ArapContrastDiffRptUtils.getResource("periodNum")).append("\u3000|\u3000");
        title.append(currency.getName()).append("\u3000|\u3000");
        title.append((Object)(project == 2 ? ArapRcProjectEnum.CreditBalance : ArapRcProjectEnum.DebitBalance));
        return title.toString();
    }

    private static String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    public static String createTable(Context ctx, Map filterMap) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        String tempTable = TempTableUtil.createTempTable(ctx, ArapContrastDiffRptUtils.tempContrastTable());
        ArapContrastDiffRptUtils.insertData(ctx, tempTable, filterMap);
        return tempTable;
    }

    public static String tempContrastTable() {
        StringBuffer tbl = new StringBuffer();
        tbl.append("(fid VARCHAR(44),FbillID VARCHAR(44),FBillType VARCHAR(44) ,");
        tbl.append("FBillNumber VARCHAR(44),FBillDate DateTime,");
        tbl.append("FBIllAmount decimal(28, 10) NOT NULL DEFAULT 0, ");
        tbl.append("FVoucherID VARCHAR(44),FVoucherEntryID VARCHAR(44),");
        tbl.append("FVoucherPeriod VARCHAR(44),");
        tbl.append("FVoucherNumber nVARCHAR(80),");
        tbl.append(" FVoucherAmount decimal(28, 10) NOT NULL DEFAULT 0, ");
        tbl.append(" FDiffAmount decimal(28, 10) NOT NULL DEFAULT 0 ,");
        tbl.append("FDiffType int,FIsSum int)");
        return tbl.toString();
    }

    private static String tempGLTable() {
        StringBuffer tbl = new StringBuffer();
        tbl.append("(FSRCENTRYID VARCHAR(44),FDC int,");
        tbl.append("FACCOUNTID VARCHAR(44),FVoucherAmount decimal(28, 10) NOT NULL DEFAULT 0,");
        tbl.append("FVOUCHERENTRYID VARCHAR(44),FVOUCHERID VARCHAR(44),");
        tbl.append("FVOUCHERDATE DateTime,FVOUCHERNUMBER NVARCHAR(80),");
        tbl.append("FVoucherTypeID VARCHAR(44),FCONTROL int,");
        tbl.append("FVoucherCompanyID VARCHAR(44),FvoucherBizStatus int,");
        tbl.append("FAccountCompanyID VARCHAR(44),FControlUnitID VARCHAR(44),");
        tbl.append("FAccountTableID VARCHAR(44),Fdatadirection VARCHAR(44),");
        tbl.append("fperiodyear int,fperiodnumber int,");
        tbl.append("FVoucherTypeNumber nVARCHAR(80))");
        return tbl.toString();
    }

    private static String tempUpdateTable() {
        StringBuffer tbl = new StringBuffer();
        tbl.append("(fid VARCHAR(44),");
        tbl.append(" FBIllAmount decimal(28, 10) NOT NULL DEFAULT 0, ");
        tbl.append("FVoucherID VARCHAR(44),FVoucherEntryID VARCHAR(44),");
        tbl.append(" FVoucherAmount decimal(28, 10) NOT NULL DEFAULT 0, ");
        tbl.append(" FDiffAmount decimal(28, 10) NOT NULL DEFAULT 0 ,");
        tbl.append("FDiffType int,FIsSum int)");
        return tbl.toString();
    }

    private static String getVoucherTable(Context ctx, Map filterMap) {
        StringBuffer voucherSql = new StringBuffer();
        voucherSql.append("select relationEntry.FSrcEntryID FSRCENTRYID,temp.* from T_AR_ArApRelationEntry relationEntry ").append(RT);
        voucherSql.append("inner join (").append(RT);
        voucherSql.append(" SELECT   voucherEntry.FEntryDC FDC,").append(RT);
        voucherSql.append("voucherEntry.FAccountID FACCOUNTID,sum(var.foriginalamount) as  FVoucherAmount,").append(RT);
        voucherSql.append("voucherEntry.FID FVOUCHERENTRYID,voucher.FID FVOUCHERID, voucher.FBookedDate FVOUCHERDATE,").append(RT);
        voucherSql.append("voucher.FNUMBER FVOUCHERNUMBER,voucher.FVoucherTypeID FVoucherTypeID,accountUnion.FSystem FCONTROL,").append(RT);
        voucherSql.append("voucher.FCompanyID AS FVoucherCompanyID,voucher.FBizStatus AS fvoucherBizStatus,").append(RT);
        voucherSql.append("accountUnion.FCompanyID AS FAccountCompanyID,accountUnion.FControlUnitID AS FControlUnitID,").append(RT);
        voucherSql.append("accountUnion.FAccountTableID AS FAccountTableID, accountUnion.Fdatadirection AS Fdatadirection,").append(RT);
        voucherSql.append("accountUnion.fperiodyear AS fperiodyear, accountUnion.fperiodnumber AS fperiodnumber,").append(RT);
        voucherSql.append("CONCAT( CONCAT(CONCAT('[',VTypes.fname_l2),']'),voucher.Fnumber) FVoucherTypeNumber").append(RT);
        voucherSql.append("FROM T_GL_VoucherEntry voucherEntry ").append(RT);
        voucherSql.append("INNER JOIN T_GL_Voucher voucher ON  voucherEntry.FBillID = voucher.FID").append(RT);
        voucherSql.append("INNER JOIN V_AR_AccountViewUnion accountUnion on  voucherEntry.FAccountID = accountUnion.FAccountID").append(RT);
        voucherSql.append("inner join t_gl_voucherassistrecord var on var.fentryid = voucherEntry.fid and var.fbillid = voucher.fid").append(RT);
        voucherSql.append("inner join t_bd_assistanthg hg on hg.fid = var.fassgrpid").append(RT);
        voucherSql.append("left join T_BD_VoucherTypes VTypes on voucher.FVoucherTypeID=VTypes.fid").append(RT);
        voucherSql.append("where ").append(RT);
        voucherSql.append("voucher.FPeriodId = '").append(filterMap.get("periodId")).append("' and  ").append(RT);
        voucherSql.append("voucher.FCompanyId = '").append(filterMap.get("companyId")).append("' and ").append(RT);
        voucherSql.append("voucherEntry.FCURRENCYID='").append(filterMap.get("currencyId")).append("' and ").append(RT);
        if (filterMap.get("assistanthg") != null) {
            voucherSql.append(" hg.").append(filterMap.get("assistanthg")).append("='").append(filterMap.get("asstActId")).append("' and").append(RT);
        }
        voucherSql.append("voucherEntry.FAccountId in(").append(filterMap.get("accID")).append(") ").append(RT);
        voucherSql.append("  group by voucherEntry.fid ,voucher.FID ,voucher.FNUMBER,voucherEntry.FEntryDC, ").append(RT);
        voucherSql.append("voucher.FBookedDate,voucherEntry.FAccountID,").append(RT);
        voucherSql.append("voucher.FVoucherTypeID,accountUnion.FSystem,voucher.FCompanyID,").append(RT);
        voucherSql.append("voucher.FBizStatus ,accountUnion.FCompanyID,accountUnion.FControlUnitID,").append(RT);
        voucherSql.append("accountUnion.FAccountTableID, accountUnion.Fdatadirection,accountUnion.fperiodyear, ").append(RT);
        voucherSql.append("accountUnion.fperiodnumber,CONCAT( CONCAT(CONCAT('[',VTypes.fname_l2),']'),voucher.Fnumber)) as temp  ");
        voucherSql.append("on temp.FVOUCHERENTRYID=relationEntry.FDestEntryID").append(RT);
        return voucherSql.toString();
    }

    private static String getVoucherTable2(Context ctx, Map filterMap) {
        StringBuffer voucherSql = new StringBuffer();
        voucherSql.append("(SELECT  relationEntry.FSrcEntryID FSRCENTRYID, voucherEntry.FEntryDC FDC,").append(RT);
        voucherSql.append("voucherEntry.FAccountID FACCOUNTID,var.foriginalamount FVoucherAmount,").append(RT);
        voucherSql.append("voucherEntry.FID FVOUCHERENTRYID,voucher.FID FVOUCHERID, voucher.FBookedDate FVOUCHERDATE,").append(RT);
        voucherSql.append("voucher.FNUMBER FVOUCHERNUMBER,voucher.FVoucherTypeID FVoucherTypeID,accountUnion.FSystem FCONTROL,").append(RT);
        voucherSql.append("voucher.FCompanyID AS FVoucherCompanyID,voucher.FBizStatus AS voucherBizStatus,").append(RT);
        voucherSql.append("accountUnion.FCompanyID AS FAccountCompanyID,accountUnion.FControlUnitID AS FControlUnitID,").append(RT);
        voucherSql.append("accountUnion.FAccountTableID AS FAccountTableID, accountUnion.Fdatadirection AS Fdatadirection,").append(RT);
        voucherSql.append("accountUnion.fperiodyear AS fperiodyear, accountUnion.fperiodnumber AS fperiodnumber,").append(RT);
        voucherSql.append(" CONCAT( CONCAT(CONCAT('[',VTypes.fname_l2),']'),voucher.Fnumber) FVoucherTypeNumber").append(RT);
        voucherSql.append("FROM T_GL_Voucher voucher").append(RT);
        voucherSql.append("inner JOIN T_GL_VoucherEntry voucherEntry ON  voucherEntry.FBillID = voucher.FID").append(RT);
        voucherSql.append("left JOIN T_AR_ArApRelationEntry relationEntry ON  relationEntry.FDestObjectID = voucher.FID").append(RT);
        voucherSql.append(" inner join T_bd_period period  on period.fid =voucher.FPeriodId ").append(RT);
        voucherSql.append(" inner join T_AR_ContrastAccountView as accountView on  voucherEntry.FAccountID = accountView.FAccountID ").append(RT);
        voucherSql.append(" and accountView.FPeriodYear = period.FPeriodYear and accountView.FPeriodNumber = period.FPeriodNumber ").append(RT);
        voucherSql.append(" INNER JOIN V_AR_AccountViewUnion accountUnion on  accountView.fid = accountUnion.Fid ").append(RT);
        voucherSql.append("inner join t_gl_voucherassistrecord var on var.fentryid = voucherEntry.fid and var.fbillid = voucher.fid").append(RT);
        voucherSql.append("inner join t_bd_assistanthg hg on hg.fid = var.fassgrpid").append(RT);
        voucherSql.append("left join T_BD_VoucherTypes VTypes on voucher.FVoucherTypeID=VTypes.fid").append(RT);
        voucherSql.append("where ").append(RT);
        voucherSql.append(" accountView.FCompanyID  = '").append(filterMap.get("companyId")).append("' and ").append(RT);
        voucherSql.append("voucher.FPeriodId = '").append(filterMap.get("periodId")).append("' and  ").append(RT);
        voucherSql.append("voucher.FCompanyId = '").append(filterMap.get("companyId")).append("' and ").append(RT);
        voucherSql.append("voucherEntry.FCURRENCYID='").append(filterMap.get("currencyId")).append("' and ").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            voucherSql.append("voucherEntry.FEntryDC=1").append(RT);
        } else {
            voucherSql.append("voucherEntry.FEntryDC=0").append(RT);
        }
        if (filterMap.get("assistanthg") != null) {
            voucherSql.append(" and hg.").append(filterMap.get("assistanthg")).append("='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        voucherSql.append(" and relationEntry.FSrcObjectID is null ").append(RT);
        voucherSql.append("and voucherEntry.FAccountId in(").append(filterMap.get("accID")).append("))").append(RT);
        return voucherSql.toString();
    }

    private static String querySql(Context ctx, Map filterMap) throws EASBizException, BOSException {
        String companyID = filterMap.get("companyId").toString();
        String periodID = filterMap.get("periodId").toString();
        String beginDate = filterMap.get("beginDate").toString();
        String endDate = filterMap.get("endDate").toString();
        String currentAcctTableID = filterMap.get("currentAcctTableID").toString();
        StringBuffer sqlBf = new StringBuffer();
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            sqlBf.append(" and voucher.fvoucherBizStatus != ").append(0).append(RT);
            sqlBf.append(" and voucher.fvoucherBizStatus != ").append(2).append(RT);
        }
        sqlBf.append(" and voucher.fperiodyear = ").append(filterMap.get("periodYear").toString()).append(RT);
        sqlBf.append(" and voucher.fperiodnumber = ").append(filterMap.get("periodNum").toString()).append(RT);
        sqlBf.append(" and ");
        sqlBf.append(" bill.FCompanyID='").append(companyID).append("'");
        sqlBf.append(" and voucher.FControlUnitID='").append(filterMap.get("cu")).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            sqlBf.append(" and voucher.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            sqlBf.append(" and voucher.FVoucherDate>={").append(beginDate).append("}");
            sqlBf.append(" and voucher.FVoucherDate<{").append(endDate).append("}");
        } else {
            sqlBf.append(" and bill.FBillDate>={").append(beginDate).append("}");
            sqlBf.append(" and bill.FBillDate<{").append(endDate).append("}");
        }
        sqlBf.append("  ");
        return sqlBf.toString();
    }

    private static String querySql2(Context ctx, Map filterMap) throws EASBizException, BOSException {
        String companyID = filterMap.get("companyId").toString();
        String periodID = filterMap.get("periodId").toString();
        String beginDate = filterMap.get("beginDate").toString();
        String endDate = filterMap.get("endDate").toString();
        String currentAcctTableID = filterMap.get("currentAcctTableID").toString();
        StringBuffer sqlBf = new StringBuffer();
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            sqlBf.append(" and voucher.fvoucherBizStatus != ").append(0).append(RT);
            sqlBf.append(" and voucher.fvoucherBizStatus != ").append(2).append(RT);
        }
        sqlBf.append(" and voucher.fperiodyear = ").append(filterMap.get("periodYear").toString()).append(RT);
        sqlBf.append(" and voucher.fperiodnumber = ").append(filterMap.get("periodNum").toString()).append(RT);
        sqlBf.append(" and ");
        sqlBf.append(" bill.FCompanyID='").append(companyID).append("'");
        sqlBf.append(" and voucher.FControlUnitID='").append(filterMap.get("cu")).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            sqlBf.append(" and voucher.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            sqlBf.append(" and voucher.FVoucherDate>={").append(beginDate).append("}");
            sqlBf.append(" and voucher.FVoucherDate<{").append(endDate).append("}");
        } else {
            sqlBf.append(" and bill.fbizdate>={").append(beginDate).append("}");
            sqlBf.append(" and bill.fbizdate<{").append(endDate).append("}");
        }
        sqlBf.append("  ");
        return sqlBf.toString();
    }

    private static String getOtherBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer otherBillSql = new StringBuffer();
        otherBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("arOtherBill")).append("','").append(periodInfo).append("',").append(RT);
        otherBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            otherBillSql.append("isnull(billentry.FRecievePayAmount,0) as FBillAmount,").append(RT);
        } else {
            otherBillSql.append("0 as FBillAmount,").append(RT);
        }
        otherBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        otherBillSql.append("from t_ar_otherbill bill").append(RT);
        otherBillSql.append("INNER JOIN t_ar_otherbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        otherBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        otherBillSql.append("WHERE  bill.ffivouchered = 1 AND bill.fistransbill = 0 AND bill.FIsBizBill = 0 and  voucher.fcontrol = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            otherBillSql.append("and bill.fasstactid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        otherBillSql.append(ArapContrastDiffRptUtils.querySql(ctx, filterMap));
        return otherBillSql.toString();
    }

    private static String getOtherBillTable2(Context ctx, Map filterMap) throws EASBizException, BOSException {
        String companyID = filterMap.get("companyId").toString();
        String periodID = filterMap.get("periodId").toString();
        String beginDate = filterMap.get("beginDate").toString();
        String endDate = filterMap.get("endDate").toString();
        String currentAcctTableID = filterMap.get("currentAcctTableID").toString();
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer otherBillSql = new StringBuffer();
        otherBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("arOtherBill")).append("','").append(periodInfo).append("',").append(RT);
        otherBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            otherBillSql.append("isnull(billentry.FRecievePayAmount,0) as FBillAmount,").append(RT);
        } else {
            otherBillSql.append("0 as FBillAmount,").append(RT);
        }
        otherBillSql.append("voucher.FID FVOUCHERID,voucherEntry.FID fvoucherentryid, CONCAT( CONCAT(CONCAT('[',VTypes.fname_l2),']'),voucher.Fnumber) as FVoucherNumber,isnull(voucherentry.foriginalamount,0) as FVoucherAmount ").append(RT);
        otherBillSql.append("from t_ar_otherbill bill").append(RT);
        otherBillSql.append("INNER JOIN t_ar_otherbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        otherBillSql.append("INNER JOIN t_gl_voucher voucher ON bill.FVoucherID = voucher.FID").append(RT);
        otherBillSql.append("inner JOIN T_GL_VoucherEntry voucherEntry ON  voucherEntry.FBillID = voucher.FID").append(RT);
        otherBillSql.append("INNER JOIN v_ar_accountviewunion voucheraccount on billentry.faccountid = voucheraccount.faccountid").append(RT);
        otherBillSql.append("left join T_BD_VoucherTypes VTypes on voucher.FVoucherTypeID=VTypes.fid").append(RT);
        otherBillSql.append("WHERE bill.ffivouchered = 1 AND voucheraccount.fsystem = 1 AND bill.FSourceBillType != 17").append(RT);
        otherBillSql.append("AND bill.FIsNeedVoucher = 1 AND bill.FIsAppointVoucher = 1 AND bill.FIsBizBill = 0 ").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            otherBillSql.append("and bill.fasstactid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            otherBillSql.append(" and voucher.FBizStatus != ").append(0).append(RT);
            otherBillSql.append(" and voucher.FBizStatus != ").append(2).append(RT);
        }
        otherBillSql.append(" and voucheraccount.fperiodyear = ").append(filterMap.get("periodYear").toString()).append(RT);
        otherBillSql.append(" and voucheraccount.fperiodnumber = ").append(filterMap.get("periodNum").toString()).append(RT);
        otherBillSql.append("and voucher.FPeriodId = '").append(periodID).append("' and  ").append(RT);
        otherBillSql.append("voucher.FCompanyId = '").append(companyID).append("' ").append(RT);
        otherBillSql.append("and voucherEntry.FAccountId in(").append(filterMap.get("accID")).append(")").append(RT);
        otherBillSql.append(" and ");
        otherBillSql.append(" bill.FCompanyID='").append(companyID).append("'");
        otherBillSql.append(" and voucheraccount.FControlUnitID='").append(filterMap.get("cu")).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            otherBillSql.append(" and voucheraccount.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            otherBillSql.append(" and voucher.FBookedDate>={").append(beginDate).append("}");
            otherBillSql.append(" and voucher.FBookedDate<{").append(endDate).append("}");
        } else {
            otherBillSql.append(" and bill.FBillDate>={").append(beginDate).append("}");
            otherBillSql.append(" and bill.FBillDate<{").append(endDate).append("}");
        }
        return otherBillSql.toString();
    }

    private static String getOtherBillTable3(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer otherBillSql = new StringBuffer();
        otherBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("arOtherBill")).append("','").append(periodInfo).append("',").append(RT);
        otherBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            otherBillSql.append("isnull(billentry.FRecievePayAmount,0) as FBillAmount,").append(RT);
        } else {
            otherBillSql.append("isnull(billentry.FRecievePayAmount,0) as FBillAmount,").append(RT);
        }
        otherBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        otherBillSql.append("from t_ar_otherbill bill").append(RT);
        otherBillSql.append("INNER JOIN t_ar_otherbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        otherBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        otherBillSql.append("WHERE  bill.ffivouchered = 1 AND bill.fistransbill = 0 AND bill.FIsBizBill = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            otherBillSql.append("and bill.fasstactid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        otherBillSql.append(ArapContrastDiffRptUtils.querySql(ctx, filterMap));
        return otherBillSql.toString();
    }

    private static String getOtherBillTable4(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer otherBillSql = new StringBuffer();
        otherBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("arOtherBill")).append("','").append(periodInfo).append("',").append(RT);
        otherBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            otherBillSql.append("(voucher.FDC * otherbillentry.FRecievePayAmount) as FBillAmount,").append(RT);
        } else {
            otherBillSql.append(" ((1 - voucher.FDC) * otherbillentry.FRecievePayAmount)  as FBillAmount,").append(RT);
        }
        otherBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        otherBillSql.append("from t_ar_otherbill bill").append(RT);
        otherBillSql.append("INNER JOIN t_ar_otherbillentry otherbillentry on bill.fid = otherbillentry.fparentid").append(RT);
        otherBillSql.append("INNER JOIN T_AR_OtherBill sourceBill ON otherbillentry.FSourceBillID = sourceBill.FID").append(RT);
        otherBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on otherbillentry.fid=voucher.fsrcentryid").append(RT);
        otherBillSql.append("WHERE  bill.ffivouchered = 1 AND bill.fistransbill = 1 AND voucher.fdc = 0 AND voucher.fcontrol = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            otherBillSql.append("and bill.fasstactid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        otherBillSql.append(ArapContrastDiffRptUtils.querySql(ctx, filterMap));
        return otherBillSql.toString();
    }

    private static String getOtherBillTable5(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer otherBillSql = new StringBuffer();
        otherBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("arOtherBill")).append("','").append(periodInfo).append("',").append(RT);
        otherBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            otherBillSql.append("(voucher.FDC * billentry.FRecievePayAmount) as FBillAmount,").append(RT);
        } else {
            otherBillSql.append(" ((1 - voucher.FDC) * billentry.FRecievePayAmount)  as FBillAmount,").append(RT);
        }
        otherBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        otherBillSql.append("from t_ar_otherbill bill").append(RT);
        otherBillSql.append("INNER JOIN t_ar_otherbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        otherBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        otherBillSql.append("WHERE  bill.ffivouchered = 1 and bill.FIsTransBill = 1 AND voucher.fdc = 1 AND voucher.fcontrol = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            otherBillSql.append("and bill.fasstactid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        otherBillSql.append(ArapContrastDiffRptUtils.querySql(ctx, filterMap));
        return otherBillSql.toString();
    }

    private static String getProxyBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String companyID = filterMap.get("companyId").toString();
        String periodID = filterMap.get("periodId").toString();
        String beginDate = filterMap.get("beginDate").toString();
        String endDate = filterMap.get("endDate").toString();
        String currentAcctTableID = filterMap.get("currentAcctTableID").toString();
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer proxyBillSql = new StringBuffer();
        proxyBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("ProxyBill")).append("','").append(periodInfo).append("',").append(RT);
        proxyBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            proxyBillSql.append("isnull(billentry.FPayableAmt,0) as FAmount,").append(RT);
        } else {
            proxyBillSql.append("isnull(billentry.FPayableAmt,0) as FAmount,").append(RT);
        }
        proxyBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        proxyBillSql.append("from T_ARP_ProxyBill bill").append(RT);
        proxyBillSql.append("INNER JOIN T_ARP_ProxyBillEntry billentry on bill.fid = billentry.fparentid").append(RT);
        proxyBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        proxyBillSql.append("WHERE  bill.ffivouchered = 1 and  voucher.fcontrol = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            proxyBillSql.append("and bill.FRecAsstActId='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            proxyBillSql.append(" and voucher.fvoucherBizStatus != ").append(0).append(RT);
            proxyBillSql.append(" and voucher.fvoucherBizStatus != ").append(2).append(RT);
        }
        proxyBillSql.append(" and voucher.fperiodyear = ").append(filterMap.get("periodYear").toString()).append(RT);
        proxyBillSql.append(" and voucher.fperiodnumber = ").append(filterMap.get("periodNum").toString()).append(RT);
        proxyBillSql.append(" and ");
        proxyBillSql.append(" bill.FCompanyOrgUnitID ='").append(companyID).append("'");
        proxyBillSql.append(" and voucher.FControlUnitID='").append(filterMap.get("cu")).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            proxyBillSql.append(" and voucher.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            proxyBillSql.append(" and voucher.FVoucherDate>={").append(beginDate).append("}");
            proxyBillSql.append(" and voucher.FVoucherDate<{").append(endDate).append("}");
        } else {
            proxyBillSql.append(" and bill.FBillDate>={").append(beginDate).append("}");
            proxyBillSql.append(" and bill.FBillDate<{").append(endDate).append("}");
        }
        proxyBillSql.append("  ");
        return proxyBillSql.toString();
    }

    private static String getReceivingBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer receivingBillSql = new StringBuffer();
        receivingBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("ReceivingBill")).append("','").append(periodInfo).append("',").append(RT);
        receivingBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            receivingBillSql.append("CASE WHEN billentry.famount < 0 AND voucher.fdatadirection = -1").append(RT);
            receivingBillSql.append("THEN -1 * billentry.famount  ELSE 0").append(RT);
            receivingBillSql.append("END AS  FAmount,").append(RT);
        } else {
            receivingBillSql.append("CASE WHEN billentry.famount < 0 AND voucher.fdatadirection = -1").append(RT);
            receivingBillSql.append("THEN 0  ELSE billentry.famount").append(RT);
            receivingBillSql.append("END AS  FAmount,").append(RT);
        }
        receivingBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        receivingBillSql.append("from t_cas_receivingbill bill").append(RT);
        receivingBillSql.append("INNER JOIN t_cas_receivingbillentry billentry on bill.fid = billentry.freceivingbillid").append(RT);
        receivingBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        receivingBillSql.append("WHERE  bill.ffivouchered = 1 and  bill.fsourcetype = 100  ").append(RT);
        receivingBillSql.append("and  (bill.FPayerTypeID IS NOT NULL or bill.FPayerID IS NOT NULL) ").append(RT);
        receivingBillSql.append("and  voucher.fcontrol = 1 ").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            receivingBillSql.append("and bill.fpayerid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        receivingBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return receivingBillSql.toString();
    }

    private static String getReceivingBillTable2(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer receivingBillSql = new StringBuffer();
        receivingBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("PaymentBill")).append("','").append(periodInfo).append("',").append(RT);
        receivingBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            receivingBillSql.append("voucher.FDC * billentry.famount as FbillAmount,").append(RT);
        } else {
            receivingBillSql.append("(1 - voucher.FDC) * billentry.famount AS  FbillAmount,").append(RT);
        }
        receivingBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        receivingBillSql.append("from t_cas_paymentbill bill").append(RT);
        receivingBillSql.append("INNER JOIN t_cas_paymentbillentry billentry on bill.fid = billentry.fpaymentbillid").append(RT);
        receivingBillSql.append("INNER JOIN t_ar_otherbill sourcebill on billentry.fsourcebillid = sourcebill.fid").append(RT);
        receivingBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        receivingBillSql.append("WHERE (bill.fsourcetype = 101 AND bill.ffivouchered = 1 AND bill.FIsTransBill = 1)  ").append(RT);
        receivingBillSql.append("and  ( bill.FIsTransOtherBill = 1 AND voucher.fdc = 0) ").append(RT);
        receivingBillSql.append("and  voucher.fcontrol = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            receivingBillSql.append("and bill.fpayeeid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        receivingBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return receivingBillSql.toString();
    }

    private static String getVerificationBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer verificationBillSql = new StringBuffer();
        verificationBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("VerificationBill")).append("','").append(periodInfo).append("',").append(RT);
        verificationBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            verificationBillSql.append(" CASE ").append(RT);
            verificationBillSql.append(" WHEN billentry.fthisverificateamt < 0").append(RT);
            verificationBillSql.append(" THEN voucher.fdatadirection * voucher.fdc * billentry.fthisverificateamt").append(RT);
            verificationBillSql.append(" ELSE voucher.fdc * billentry.fthisverificateamt").append(RT);
            verificationBillSql.append("END AS  FAmount,").append(RT);
        } else {
            verificationBillSql.append("CASE").append(RT);
            verificationBillSql.append("WHEN billentry.fthisverificateamt < 0").append(RT);
            verificationBillSql.append("THEN voucher.fdatadirection * ((1 - voucher.fdc) * billentry.fthisverificateamt)").append(RT);
            verificationBillSql.append("ELSE (1 - voucher.fdc) * billentry.fthisverificateamt ").append(RT);
            verificationBillSql.append("END AS  FAmount,").append(RT);
        }
        verificationBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        verificationBillSql.append("from t_ar_verificationbill bill").append(RT);
        verificationBillSql.append("INNER JOIN t_ar_verificationbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        verificationBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        verificationBillSql.append("WHERE  bill.ffivouchered = 1  ").append(RT);
        verificationBillSql.append("and ((((bill.fverificationtype = 203 OR bill.fverificationtype = 209 or bill.fverificationtype = 103 OR bill.fverificationtype = 109) AND billentry.fbilltype = 8 ) ").append(RT);
        verificationBillSql.append("OR (( bill.fverificationtype = 204 OR bill.fverificationtype = 210 or bill.fverificationtype = 104 OR bill.fverificationtype = 110)  AND billentry.fbilltype = 6 )) ").append(RT);
        verificationBillSql.append("OR (( bill.fverificationtype = 211 OR bill.fverificationtype = 212 or bill.fverificationtype = 113 OR bill.fverificationtype = 114) AND billentry.fbilltype = 6 ) ").append(RT);
        verificationBillSql.append("OR (  bill.fverificationtype = 101 or bill.fverificationtype = 107 )) ").append(RT);
        verificationBillSql.append("and  voucher.fcontrol = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            verificationBillSql.append("and billentry.facctcussid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        verificationBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return verificationBillSql.toString();
    }

    private static String getBadAcctTakeBackBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer verificationBillSql = new StringBuffer();
        verificationBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("BadAcctBack")).append("','").append(periodInfo).append("',").append(RT);
        verificationBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            verificationBillSql.append(" CASE ").append(RT);
            verificationBillSql.append(" WHEN billentry.fthisverificateamt < 0").append(RT);
            verificationBillSql.append(" THEN voucher.fdatadirection * voucher.fdc * billentry.fthisverificateamt").append(RT);
            verificationBillSql.append(" ELSE voucher.fdc * billentry.fthisverificateamt").append(RT);
            verificationBillSql.append("END AS  FAmount,").append(RT);
        } else {
            verificationBillSql.append("CASE").append(RT);
            verificationBillSql.append("WHEN billentry.fthisverificateamt < 0").append(RT);
            verificationBillSql.append("THEN voucher.fdatadirection * ((1 - voucher.fdc) * billentry.fthisverificateamt)").append(RT);
            verificationBillSql.append("ELSE (1 - voucher.fdc) * billentry.fthisverificateamt ").append(RT);
            verificationBillSql.append("END AS  FAmount,").append(RT);
        }
        verificationBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        verificationBillSql.append("from t_ar_verificationbill bill").append(RT);
        verificationBillSql.append("INNER JOIN t_ar_verificationbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        verificationBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        verificationBillSql.append("WHERE  bill.ffivouchered = 1  ").append(RT);
        verificationBillSql.append("and ( bill.fverificationtype = 111 OR bill.fverificationtype = 112 ) ").append(RT);
        verificationBillSql.append("and  voucher.fcontrol = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            verificationBillSql.append("and billentry.facctcussid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        verificationBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return verificationBillSql.toString();
    }

    private static String getBadAcctBillTable(Context ctx, Map filterMap) throws EASBizException, BOSException {
        String companyID = filterMap.get("companyId").toString();
        String periodID = filterMap.get("periodId").toString();
        String beginDate = filterMap.get("beginDate").toString();
        String endDate = filterMap.get("endDate").toString();
        String currentAcctTableID = filterMap.get("currentAcctTableID").toString();
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer badAcctBillSql = new StringBuffer();
        badAcctBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("BadAcctRefer")).append("','").append(periodInfo).append("',").append(RT);
        badAcctBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            badAcctBillSql.append("voucherEntry.FEntryDC * bill.FBadAmounts AS FAmount,").append(RT);
        } else {
            badAcctBillSql.append("(1 - voucherEntry.FEntryDC) * bill.FBadAmounts AS FAmount,").append(RT);
        }
        badAcctBillSql.append("voucher.FID FVOUCHERID,voucherEntry.FID fvoucherentryid, CONCAT( CONCAT(CONCAT('[',VTypes.fname_l2),']'),voucher.Fnumber) as FVoucherNumber,isnull(voucherEntry.foriginalamount,0) as FVoucherAmount ").append(RT);
        badAcctBillSql.append(" from T_BOT_RELATION relation").append(RT);
        badAcctBillSql.append(" INNER JOIN T_AR_BADACCT bill ON relation.FSrcObjectID = bill.FID").append(RT);
        badAcctBillSql.append(" INNER JOIN T_GL_VOUCHER voucher ON relation.FDestObjectID = voucher.FID").append(RT);
        badAcctBillSql.append(" INNER JOIN T_GL_VOUCHERENTRY voucherEntry ON voucher.FID = voucherEntry.FBillID").append(RT);
        badAcctBillSql.append(" left join T_BD_VoucherTypes VTypes on voucher.FVoucherTypeID=VTypes.fid").append(RT);
        badAcctBillSql.append(" INNER JOIN V_AR_ACCOUNTVIEWUNION accountUnion ON voucherEntry.FAccountID = accountUnion.FAccountID WHERE 1=1").append(RT);
        badAcctBillSql.append(" AND relation.FDestEntityID = '2652E01E' AND relation.FSrcEntityID = '9E1B9DB7'").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            badAcctBillSql.append("and bill.FAcctCussentID='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            badAcctBillSql.append(" and voucher.FBizStatus != ").append(0).append(RT);
            badAcctBillSql.append(" and voucher.FBizStatus != ").append(2).append(RT);
        }
        badAcctBillSql.append(" and accountUnion.fperiodyear = ").append(filterMap.get("periodYear").toString()).append(RT);
        badAcctBillSql.append(" and accountUnion.fperiodnumber = ").append(filterMap.get("periodNum").toString()).append(RT);
        badAcctBillSql.append(" and bill.FCompanyID='").append(companyID).append("'");
        badAcctBillSql.append(" AND voucher.FCompanyID='").append(companyID).append("'");
        badAcctBillSql.append(" and (accountUnion.FCompanyID='").append(companyID).append("'");
        badAcctBillSql.append(" or accountUnion.FCompanyID='111')");
        badAcctBillSql.append(" and accountUnion.FControlUnitID='").append(filterMap.get("cu")).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            badAcctBillSql.append(" and accountUnion.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            badAcctBillSql.append(" and voucher.FBookedDate>={").append(beginDate).append("}");
            badAcctBillSql.append(" and voucher.FBookedDate<{").append(endDate).append("}");
        } else {
            badAcctBillSql.append(" and bill.FBadAcctDate>={").append(beginDate).append("}");
            badAcctBillSql.append(" and bill.FBadAcctDate<{").append(endDate).append("}");
        }
        badAcctBillSql.append(" AND accountUnion.FSystem = 1");
        return badAcctBillSql.toString();
    }

    private static String getApOtherBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer otherBillSql = new StringBuffer();
        otherBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("APOtherBill")).append("','").append(periodInfo).append("',").append(RT);
        otherBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            otherBillSql.append("0 as FBillAmount,").append(RT);
        } else {
            otherBillSql.append("isnull(billentry.FRecievePayAmount,0) as FBillAmount,").append(RT);
        }
        otherBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        otherBillSql.append("from t_ap_otherbill bill").append(RT);
        otherBillSql.append("INNER JOIN t_ap_otherbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        otherBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        otherBillSql.append("WHERE  bill.ffivouchered = 1 AND bill.fistransbill = 0  and  voucher.fcontrol = 2 ").append(RT);
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            otherBillSql.append("AND (bill.FIsBizBill = 0 or bill.FIsBizBill= 1 ) ").append(RT);
        } else {
            otherBillSql.append("AND bill.FIsBizBill = 0  ").append(RT);
        }
        if (!filterMap.get("asstActId").equals("null")) {
            otherBillSql.append("and bill.fasstactid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        otherBillSql.append(ArapContrastDiffRptUtils.querySql(ctx, filterMap));
        return otherBillSql.toString();
    }

    private static String getApOtherBillTable2(Context ctx, Map filterMap) throws EASBizException, BOSException {
        String companyID = filterMap.get("companyId").toString();
        String periodID = filterMap.get("periodId").toString();
        String beginDate = filterMap.get("beginDate").toString();
        String endDate = filterMap.get("endDate").toString();
        String currentAcctTableID = filterMap.get("currentAcctTableID").toString();
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer otherBillSql = new StringBuffer();
        otherBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("APOtherBill")).append("','").append(periodInfo).append("',").append(RT);
        otherBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            otherBillSql.append("0 as FBillAmount,").append(RT);
        } else {
            otherBillSql.append("isnull(billentry.FRecievePayAmount,0) as FBillAmount,").append(RT);
        }
        otherBillSql.append("voucher.FID FVOUCHERID,voucherEntry.FID fvoucherentryid, CONCAT( CONCAT(CONCAT('[',VTypes.fname_l2),']'),voucher.Fnumber) as FVoucherNumber,isnull(voucherentry.foriginalamount,0) as FVoucherAmount ").append(RT);
        otherBillSql.append("from t_ap_otherbill bill").append(RT);
        otherBillSql.append("INNER JOIN t_ap_otherbillentry billentry on bill.fid = billentry.fparentid ").append(RT);
        otherBillSql.append("INNER JOIN t_gl_voucher voucher on bill.FVoucherID = voucher.FID ").append(RT);
        otherBillSql.append("inner JOIN T_GL_VoucherEntry voucherEntry ON  voucherEntry.FBillID = voucher.FID").append(RT);
        otherBillSql.append("INNER JOIN v_ar_accountviewunion voucheraccount on billentry.faccountid = voucheraccount.faccountid").append(RT);
        otherBillSql.append("left join T_BD_VoucherTypes VTypes on voucher.FVoucherTypeID=VTypes.fid").append(RT);
        otherBillSql.append("WHERE  bill.ffivouchered = 1 AND voucheraccount.fsystem = 2 AND bill.FSourceBillType != 14 AND bill.FIsNeedVoucher = 1 AND bill.FIsAppointVoucher = 1").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            otherBillSql.append("and bill.fasstactid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            otherBillSql.append(" and voucher.FBizStatus != ").append(0).append(RT);
            otherBillSql.append(" and voucher.FBizStatus != ").append(2).append(RT);
        }
        otherBillSql.append(" and voucheraccount.fperiodyear = ").append(filterMap.get("periodYear").toString()).append(RT);
        otherBillSql.append(" and voucheraccount.fperiodnumber = ").append(filterMap.get("periodNum").toString()).append(RT);
        otherBillSql.append("and voucher.FPeriodId = '").append(periodID).append("' and  ").append(RT);
        otherBillSql.append("voucher.FCompanyId = '").append(companyID).append("' ").append(RT);
        otherBillSql.append("and voucherEntry.FAccountId in(").append(filterMap.get("accID")).append(")").append(RT);
        otherBillSql.append(" and ");
        otherBillSql.append(" bill.FCompanyID='").append(companyID).append("'");
        otherBillSql.append(" and voucheraccount.FControlUnitID='").append(filterMap.get("cu")).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            otherBillSql.append(" and voucheraccount.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            otherBillSql.append(" and voucher.FBookedDate>={").append(beginDate).append("}");
            otherBillSql.append(" and voucher.FBookedDate<{").append(endDate).append("}");
        } else {
            otherBillSql.append(" and bill.FBillDate>={").append(beginDate).append("}");
            otherBillSql.append(" and bill.FBillDate<{").append(endDate).append("}");
        }
        return otherBillSql.toString();
    }

    private static String getApOtherBillTable3(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer otherBillSql = new StringBuffer();
        otherBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("APOtherBill")).append("','").append(periodInfo).append("',").append(RT);
        otherBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            otherBillSql.append(" (voucher.fdc * billentry.frecievepayamount) as FBillAmount,").append(RT);
        } else {
            otherBillSql.append("((1 - voucher.fdc) * billentry.frecievepayamount)  as FBillAmount,").append(RT);
        }
        otherBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        otherBillSql.append("from t_ap_otherbill bill").append(RT);
        otherBillSql.append("INNER JOIN t_ap_otherbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        otherBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        otherBillSql.append("WHERE  bill.ffivouchered = 1 and bill.fistransbill = 1  and voucher.fdc = 0 and voucher.fcontrol = 2").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            otherBillSql.append("and bill.fasstactid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        otherBillSql.append(ArapContrastDiffRptUtils.querySql(ctx, filterMap));
        return otherBillSql.toString();
    }

    private static String getApProxyBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String companyID = filterMap.get("companyId").toString();
        String periodID = filterMap.get("periodId").toString();
        String beginDate = filterMap.get("beginDate").toString();
        String endDate = filterMap.get("endDate").toString();
        String currentAcctTableID = filterMap.get("currentAcctTableID").toString();
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer proxyBillSql = new StringBuffer();
        proxyBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("ProxyBill")).append("','").append(periodInfo).append("',").append(RT);
        proxyBillSql.append("bill.fID fbillid,bill.fbilldate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            proxyBillSql.append("isnull(billentry.FPayableAmt,0) as FAmount,").append(RT);
        } else {
            proxyBillSql.append("isnull(billentry.FPayableAmt,0) as FAmount,").append(RT);
        }
        proxyBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        proxyBillSql.append("from T_ARP_ProxyBill bill").append(RT);
        proxyBillSql.append("INNER JOIN T_ARP_ProxyBillEntry billentry on bill.fid = billentry.fparentid").append(RT);
        proxyBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        proxyBillSql.append("WHERE  bill.ffivouchered = 1 and  voucher.fcontrol = 2").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            proxyBillSql.append("and bill.FRecAsstActId='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            proxyBillSql.append(" and voucher.fvoucherBizStatus != ").append(0).append(RT);
            proxyBillSql.append(" and voucher.fvoucherBizStatus != ").append(2).append(RT);
        }
        proxyBillSql.append(" and voucher.fperiodyear = ").append(filterMap.get("periodYear").toString()).append(RT);
        proxyBillSql.append(" and voucher.fperiodnumber = ").append(filterMap.get("periodNum").toString()).append(RT);
        proxyBillSql.append(" and ");
        proxyBillSql.append(" bill.FCompanyOrgUnitID ='").append(companyID).append("'");
        proxyBillSql.append(" and voucher.FControlUnitID='").append(filterMap.get("cu")).append("'");
        if (currentAcctTableID != null && !"".equals(currentAcctTableID)) {
            proxyBillSql.append(" and voucher.FAccountTableID='").append(currentAcctTableID).append("'");
        }
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            proxyBillSql.append(" and voucher.FVoucherDate>={").append(beginDate).append("}");
            proxyBillSql.append(" and voucher.FVoucherDate<{").append(endDate).append("}");
        } else {
            proxyBillSql.append(" and bill.FBillDate>={").append(beginDate).append("}");
            proxyBillSql.append(" and bill.FBillDate<{").append(endDate).append("}");
        }
        proxyBillSql.append("  ");
        return proxyBillSql.toString();
    }

    private static String getPaymentBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer paymentBillSql = new StringBuffer();
        paymentBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("PaymentBill")).append("','").append(periodInfo).append("',").append(RT);
        paymentBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            paymentBillSql.append("CASE WHEN billentry.famount < 0 AND voucher.fdatadirection = -1").append(RT);
            paymentBillSql.append("THEN 0  ELSE billentry.famount").append(RT);
            paymentBillSql.append("END AS  FAmount,").append(RT);
        } else {
            paymentBillSql.append("CASE WHEN billentry.famount < 0 AND voucher.fdatadirection = -1").append(RT);
            paymentBillSql.append("THEN -1 * billentry.famount  ELSE 0").append(RT);
            paymentBillSql.append("END AS  FAmount,").append(RT);
        }
        paymentBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        paymentBillSql.append("from t_cas_paymentbill bill").append(RT);
        paymentBillSql.append("INNER JOIN t_cas_paymentbillentry billentry on bill.fid = billentry.fpaymentbillid").append(RT);
        paymentBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        paymentBillSql.append("WHERE  bill.ffivouchered = 1 ").append(RT);
        paymentBillSql.append("and   bill.fsourcetype = 101  AND FIsTransBill = 0 ").append(RT);
        paymentBillSql.append("and  voucher.fcontrol = 2 ").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            paymentBillSql.append("and bill.fpayeeid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        paymentBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return paymentBillSql.toString();
    }

    private static String getPaymentBillTable2(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer paymentBillSql = new StringBuffer();
        paymentBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("PaymentBill")).append("','").append(periodInfo).append("',").append(RT);
        paymentBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            paymentBillSql.append(" (voucher.FDC * billentry.famount)  AS  FAmount,").append(RT);
        } else {
            paymentBillSql.append("((1 - voucher.FDC) * billentry.famount)  AS  FAmount,").append(RT);
        }
        paymentBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        paymentBillSql.append("from t_cas_paymentbill bill").append(RT);
        paymentBillSql.append("INNER JOIN t_cas_paymentbillentry billentry on bill.fid = billentry.fpaymentbillid").append(RT);
        paymentBillSql.append("INNER JOIN t_cas_paymentbill sourcebill on billentry.fsourcebillid = sourcebill.fid").append(RT);
        paymentBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        paymentBillSql.append("WHERE bill.fsourcetype = 101 AND bill.ffivouchered = 1 AND bill.FIsTransBill = 1 ").append(RT);
        paymentBillSql.append("and bill.FIsTransOtherBill = 0 AND voucher.fdc = 0 AND voucher.fcontrol = 2 ").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            paymentBillSql.append("and bill.fpayeeid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        paymentBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return paymentBillSql.toString();
    }

    private static String getPaymentBillTable3(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer receivingBillSql = new StringBuffer();
        receivingBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("ReceivingBill")).append("','").append(periodInfo).append("',").append(RT);
        receivingBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            receivingBillSql.append(" (voucher.FDC * billentry.famount)  AS  FAmount,").append(RT);
        } else {
            receivingBillSql.append("((1 - voucher.FDC) * billentry.famount)  AS  FAmount,").append(RT);
        }
        receivingBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        receivingBillSql.append("from t_cas_receivingbill bill").append(RT);
        receivingBillSql.append("INNER JOIN t_cas_receivingbillentry billentry on bill.fid = billentry.freceivingbillid").append(RT);
        receivingBillSql.append("INNER JOIN t_ap_otherbill sourcebill on billentry.fsourcebillid = sourcebill.fid").append(RT);
        receivingBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        receivingBillSql.append("WHERE  bill.fsourcetype = 100 AND bill.ffivouchered = 1 AND bill.FIsTransBill = 1").append(RT);
        receivingBillSql.append("and bill.FIsTransOtherBill = 1 AND voucher.fdc = 1 AND voucher.fcontrol = 2").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            receivingBillSql.append("and bill.fpayerid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        receivingBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return receivingBillSql.toString();
    }

    private static String getPaymentBillTable4(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer paymentBillSql = new StringBuffer();
        paymentBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("PaymentBill")).append("','").append(periodInfo).append("',").append(RT);
        paymentBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            paymentBillSql.append(" (voucher.FDC * billentry.famount)  AS  FAmount,").append(RT);
        } else {
            paymentBillSql.append("((1 - voucher.FDC) * billentry.famount)  AS  FAmount,").append(RT);
        }
        paymentBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        paymentBillSql.append("from t_cas_paymentbill bill").append(RT);
        paymentBillSql.append("INNER JOIN t_cas_paymentbillentry billentry on bill.fid = billentry.fpaymentbillid").append(RT);
        paymentBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        paymentBillSql.append("WHERE  bill.fsourcetype = 101 AND bill.ffivouchered = 1 AND bill.FIsTransBill = 1 ").append(RT);
        paymentBillSql.append("and voucher.fdc = 1 AND voucher.fcontrol = 2").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            paymentBillSql.append("and bill.fpayeeid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        paymentBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return paymentBillSql.toString();
    }

    private static String getApVerificationBillTable(Context ctx, Map filterMap, String tempGLTable) throws EASBizException, BOSException {
        String periodInfo = filterMap.get("periodInfo").toString();
        StringBuffer verificationBillSql = new StringBuffer();
        verificationBillSql.append("SELECT '").append(ArapContrastDiffRptUtils.getResource("APVerificationBill")).append("','").append(periodInfo).append("',").append(RT);
        verificationBillSql.append("bill.fID fbillid,bill.fbizdate fbilldate,bill.FNumber as FBillNumber,").append(RT);
        if (Integer.parseInt(filterMap.get("project").toString()) == 2) {
            verificationBillSql.append(" CASE ").append(RT);
            verificationBillSql.append(" WHEN billentry.fthisverificateamt < 0").append(RT);
            verificationBillSql.append(" THEN voucher.fdatadirection * voucher.fdc * billentry.fthisverificateamt").append(RT);
            verificationBillSql.append(" ELSE voucher.fdc * billentry.fthisverificateamt").append(RT);
            verificationBillSql.append("END AS  FAmount,").append(RT);
        } else {
            verificationBillSql.append("CASE").append(RT);
            verificationBillSql.append("WHEN billentry.fthisverificateamt < 0").append(RT);
            verificationBillSql.append("THEN voucher.fdatadirection * ((1 - voucher.fdc) * billentry.fthisverificateamt)").append(RT);
            verificationBillSql.append("ELSE (1 - voucher.fdc) * billentry.fthisverificateamt ").append(RT);
            verificationBillSql.append("END AS  FAmount,").append(RT);
        }
        verificationBillSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount ").append(RT);
        verificationBillSql.append("from t_ap_verificationbill bill").append(RT);
        verificationBillSql.append("INNER JOIN t_ap_verificationbillentry billentry on bill.fid = billentry.fparentid").append(RT);
        verificationBillSql.append("INNER JOIN ").append(tempGLTable).append(" voucher on billentry.fid=voucher.fsrcentryid").append(RT);
        verificationBillSql.append("WHERE  bill.ffivouchered = 1  ").append(RT);
        verificationBillSql.append("and (( bill.fverificationtype = 201 OR bill.fverificationtype = 207 ) ").append(RT);
        verificationBillSql.append("or ((bill.fverificationtype = 203 OR bill.fverificationtype = 209 ").append(RT);
        verificationBillSql.append("or bill.fverificationtype = 103 OR bill.fverificationtype = 109) and billentry.fbilltype = 9) ").append(RT);
        verificationBillSql.append("or ((bill.fverificationtype = 204 OR bill.fverificationtype = 210 ").append(RT);
        verificationBillSql.append("or   bill.fverificationtype = 104 OR bill.fverificationtype = 110  ").append(RT);
        verificationBillSql.append("or  bill.fverificationtype = 113 OR bill.fverificationtype = 114  ) and billentry.fbilltype = 4))").append(RT);
        verificationBillSql.append("and voucher.fcontrol = 2 ").append(RT);
        if (!filterMap.get("asstActId").equals("null")) {
            verificationBillSql.append("and billentry.facctcussid='").append(filterMap.get("asstActId")).append("'").append(RT);
        }
        verificationBillSql.append(ArapContrastDiffRptUtils.querySql2(ctx, filterMap));
        return verificationBillSql.toString();
    }

    private static String getOnlyVoucherInsertSql(Context ctx, String tempTable, Map filterMap) {
        StringBuffer voucherSql = new StringBuffer();
        String periodInfo = filterMap.get("periodInfo").toString();
        voucherSql.append("insert into ").append(tempTable).append(RT);
        voucherSql.append(" (fid,FBillType,FVoucherPeriod,FbillID,FBillDate,FBillNumber,FBIllAmount,").append(RT);
        voucherSql.append(" FVoucherID,FVoucherentryID,FVoucherNumber,FVoucherAmount,FDiffAmount,FisSum,FDiffType) ").append(RT);
        voucherSql.append("select newbosid('12345678'),'").append(ArapContrastDiffRptUtils.getResource("Voucher")).append("','").append(periodInfo).append("',").append(RT);
        voucherSql.append("'','','',0,").append(RT);
        voucherSql.append("voucher.FVOUCHERID FVOUCHERID,voucher.FVoucherEntryID fvoucherentryid,voucher.FVoucherTypeNumber as FVoucherNumber,isnull(voucher.FVoucherAmount,0) as FVoucherAmount, ").append(RT);
        voucherSql.append("isnull(voucher.FVoucherAmount,0) as FVoucherAmount,0,").append(4).append(RT);
        voucherSql.append("from (").append(ArapContrastDiffRptUtils.getVoucherTable2(ctx, filterMap)).append(") voucher ").append(RT);
        voucherSql.append("where  voucher.voucherBizStatus != ").append(0).append(RT);
        voucherSql.append(" and voucher.voucherBizStatus != ").append(2).append(RT);
        voucherSql.append(" and voucher.FVOUCHERID not in (select tempTable.FVoucherID from ").append(tempTable).append(" tempTable) ").append(RT);
        return voucherSql.toString();
    }

    private static void insertData(Context ctx, String tempTable, Map filterMap) throws BOSException, EASBizException {
        StringBuffer insertBf = new StringBuffer("");
        StringBuffer insertGlSql = new StringBuffer();
        Connection conn = null;
        String tempGLTable = TempTableUtil.createTempTable(ctx, ArapContrastDiffRptUtils.tempGLTable());
        String tempUpdateTable = TempTableUtil.createTempTable(ctx, ArapContrastDiffRptUtils.tempUpdateTable());
        insertGlSql.append("insert into ").append(tempGLTable).append(RT);
        insertGlSql.append("(FSRCENTRYID,FDC,FACCOUNTID,FVoucherAmount,FVOUCHERENTRYID,FVOUCHERID,FVOUCHERDATE,FVOUCHERNUMBER,");
        insertGlSql.append("FVoucherTypeID,FCONTROL,FVoucherCompanyID,FvoucherBizStatus,FAccountCompanyID,FControlUnitID,");
        insertGlSql.append("FAccountTableID,Fdatadirection,fperiodyear,fperiodnumber,FVoucherTypeNumber)");
        insertGlSql.append(ArapContrastDiffRptUtils.getVoucherTable(ctx, filterMap));
        DbUtil.execute((Context)ctx, (String)insertGlSql.toString());
        TempTablePool tempPool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = ArapContrastDiffRptUtils.getConnection(ctx);
            tempPool.createIndex(tempGLTable, "fsrcentryid,fperiodyear,fperiodnumber,FControlUnitID,FAccountTableID", false, false);
            tempPool.createIndex(tempUpdateTable, "fvoucherentryid,fissum", false, false);
            tempPool.analyzeTable(conn, tempGLTable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        insertBf.append("insert into ").append(tempTable).append(RT);
        insertBf.append(" (FBillType,FVoucherPeriod,FbillID,FBillDate,FBillNumber,FBIllAmount,FVoucherID,FVoucherEntryID,FVoucherNumber,FVoucherAmount) ").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getOtherBillTable(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getOtherBillTable2(ctx, filterMap)).append(RT);
        insertBf.append("union all").append(RT);
        if (filterMap.get("isDAPCheckAccount").toString().equals("true")) {
            insertBf.append(ArapContrastDiffRptUtils.getOtherBillTable3(ctx, filterMap, tempGLTable)).append(RT);
            insertBf.append("union all").append(RT);
        }
        insertBf.append(ArapContrastDiffRptUtils.getOtherBillTable4(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getOtherBillTable5(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getProxyBillTable(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getReceivingBillTable(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getReceivingBillTable2(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getVerificationBillTable(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getBadAcctTakeBackBillTable(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getBadAcctBillTable(ctx, filterMap));
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getApOtherBillTable(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getApOtherBillTable2(ctx, filterMap)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getApOtherBillTable3(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getApProxyBillTable(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getPaymentBillTable(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getPaymentBillTable2(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getPaymentBillTable3(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getPaymentBillTable4(ctx, filterMap, tempGLTable)).append(RT);
        insertBf.append("union all").append(RT);
        insertBf.append(ArapContrastDiffRptUtils.getApVerificationBillTable(ctx, filterMap, tempGLTable)).append(RT);
        DbUtil.execute((Context)ctx, (String)insertBf.toString());
        StringBuffer insertUpdateTable = new StringBuffer();
        insertUpdateTable.append("insert into ").append(tempUpdateTable).append("(FBIllAmount,FVoucherAmount, FVoucherID,FVoucherEntryID,fissum)").append(RT);
        insertUpdateTable.append("select sum(Fbillamount),FVoucherAmount,fvoucherid,FVoucherEntryID,0 from ").append(RT);
        insertUpdateTable.append(tempTable).append(" group by FVoucherEntryID,fvoucherid,FVoucherAmount").append(RT);
        DbUtil.execute((Context)ctx, (String)insertUpdateTable.toString());
        StringBuffer deleteSql = new StringBuffer();
        deleteSql.append("delete from ").append(tempUpdateTable).append(RT);
        deleteSql.append("where FBIllAmount=0 ");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update ").append(tempUpdateTable).append(" t1 set (fid,FDiffAmount,FDiffType,fissum)=(select newbosid('12345678'),(t2.FBIllAmount-t2.FVoucherAmount),").append(RT);
        updateSql.append("case when (t2.FBIllAmount-t2.FVoucherAmount)=0 then  ").append(1).append(RT);
        updateSql.append("else ").append(2);
        updateSql.append(" end as fdiff,0 from ").append(tempUpdateTable).append(" t2 where t1.FVoucherEntryID=t2.FVoucherEntryID ) ");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        StringBuffer insertSumSql = new StringBuffer();
        insertSumSql.append("insert into ").append(tempUpdateTable).append(RT);
        insertSumSql.append("(fid, FBIllAmount  ,FVoucherAmount, FDiffAmount, FDiffType,fissum)").append(RT);
        insertSumSql.append("select newbosid('12345678'), sum(FBIllAmount),sum(FVoucherAmount),sum(FDiffAmount),FDIFFTYPE,1").append(RT);
        insertSumSql.append("from ").append(tempUpdateTable).append(RT);
        insertSumSql.append("group by FDiffType").append(RT);
        DbUtil.execute((Context)ctx, (String)insertSumSql.toString());
        updateSql.setLength(0);
        updateSql.append("update ").append(tempTable).append(" temptable set (fid,FDiffAmount,FDiffType,FIsSum)").append(RT);
        updateSql.append("=(select updateTable.fid,updateTable.FDiffAmount,updateTable.FDiffType,0 from ").append(tempUpdateTable).append(" updateTable").append(RT);
        updateSql.append("where updateTable.fvoucherentryid=temptable.fvoucherentryid");
        updateSql.append(")");
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
        try {
            conn = ArapContrastDiffRptUtils.getConnection(ctx);
            tempPool.createIndex(tempTable, "FBIllAmount,FBillNumber,fid", false, false);
            tempPool.analyzeTable(conn, tempTable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        deleteSql.setLength(0);
        deleteSql.append("delete from ").append(tempTable).append(RT);
        deleteSql.append("where FBIllAmount=0 and FBillNumber is not null");
        DbUtil.execute((Context)ctx, (String)deleteSql.toString());
        DbUtil.execute((Context)ctx, (String)ArapContrastDiffRptUtils.getOnlyVoucherInsertSql(ctx, tempTable, filterMap));
        insertSumSql.setLength(0);
        insertSumSql.append("insert into ").append(tempTable).append(RT);
        insertSumSql.append("(fid,FBIllAmount,FVoucherAmount,FDiffAmount,FDiffType,FisSum)").append(RT);
        insertSumSql.append("select updateTable.fid,updateTable.FBIllAmount, updateTable.FVoucherAmount,").append(RT);
        insertSumSql.append("updateTable.FDiffAmount,updateTable.FDiffType,updateTable.FisSum  from ").append(tempUpdateTable).append(" updateTable ").append(RT);
        insertSumSql.append("where updateTable.fissum =1");
        DbUtil.execute((Context)ctx, (String)insertSumSql.toString());
        insertSumSql.setLength(0);
        insertSumSql.append("insert into ").append(tempTable).append(RT);
        insertSumSql.append("(fid,FBIllAmount,FVoucherAmount,FDiffAmount,FDiffType,FisSum)").append(RT);
        insertSumSql.append("select newbosid('12345678'),isnull(sum(isnull(FBIllAmount,0)),0),").append(RT);
        insertSumSql.append("isnull(sum(isnull(FVoucherAmount,0)),0),isnull(sum(isnull(FDiffAmount,0)),0),FDiffType,1 from ").append(tempTable).append(RT);
        insertSumSql.append("where FDiffType =").append(4).append(RT);
        insertSumSql.append("group by fdifftype");
        DbUtil.execute((Context)ctx, (String)insertSumSql.toString());
        insertSumSql.setLength(0);
        insertSumSql.append("insert into ").append(tempTable).append(RT);
        insertSumSql.append("(fid,FBIllAmount,FVoucherAmount,FDiffAmount,FDiffType, FisSum)").append(RT);
        insertSumSql.append("select newbosid('12345678'),isnull(sum(isnull(FBIllAmount,0)),0),").append(RT);
        insertSumSql.append("isnull(sum(isnull(FVoucherAmount,0)),0),isnull(sum(isnull(FDiffAmount,0)),0),0,1 from ").append(tempTable).append(RT);
        insertSumSql.append("where FisSum=1");
        DbUtil.execute((Context)ctx, (String)insertSumSql.toString());
        TempTableUtil.releasTempTable(ctx, tempUpdateTable);
        TempTableUtil.releasTempTable(ctx, tempGLTable);
    }

    protected static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    private static String getResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapRCResource", (String)key);
    }

    public static ContrastGLQueryParam getRptParam(Context ctx, boolean fAR, String companyId, PeriodInfo periodInfo) throws BOSException, EASBizException {
        EntityViewInfo viewInfo;
        ContrastGLQueryParam param = new ContrastGLQueryParam();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        String className = "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.ap.solution_ar_page";
        if (!fAR) {
            className = "bizCommonQuery.advancedQuery.com.kingdee.eas.fi.ap.solution_ap_page";
        }
        try {
            viewInfo = ArapContrastDiffRptUtils.getQuerySolutionViewInfo(null, className, companyId, userID);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
        QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
        if (solutionCol.size() > 0) {
            QuerySolutionInfo solutionInfo = solutionCol.get(0);
            if (solutionInfo != null && solutionInfo.getSolutionType() == SolutionTypeEnum.CUSTOMER_SOLUTION) {
                QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
                int size = queryPanels.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        CustomerParams cp = XMLBean.transStrToCommonCustParams((String)queryPanels.get(i).getCustomerParams());
                        ContrastGLRptParamConvertor convertor = new ContrastGLRptParamConvertor();
                        convertor.setRptParam((IReportQueryParam)param);
                        convertor.read(ctx, cp);
                        continue;
                    }
                    catch (Exception e) {
                        logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
                    }
                }
            }
        } else {
            return null;
        }
        int spPeriodYear = periodInfo.getPeriodYear();
        int spPeriodNum = periodInfo.getPeriodNumber();
        param.setPeriodYear(spPeriodYear);
        param.setPeriodNum(spPeriodNum);
        boolean fAllVoucheredCt = ArApParamHelper.isDAPCheckAccount(ctx);
        param.setIsIncludeUnvoucheredBills(!fAllVoucheredCt);
        param.setBoolean("isDAPCheckAccount", fAllVoucheredCt);
        if (!fAR) {
            param.setIncludeBizBill(ArApParamHelper.isAPContrastEstimateAndGL(ctx, param.getCompanyId()));
        }
        if (param.getCussTypeId() != null && !param.getCussTypeId().equals("all")) {
            param.setCussAcctId(ArapContrastDiffRptUtils.getCussAcctRangeIds(ctx, param));
        }
        return param;
    }

    public static EntityViewInfo getQuerySolutionViewInfo(String queryName, String parentPageName, String orgID, String userID) throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)queryName));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentPageName));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)String.valueOf(2)));
        filter.getFilterItems().add(new FilterItemInfo("isUserDefaultSolu", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        filter.setMaskString(" #0 AND #1 AND #2 AND #3 and #4 ");
        viewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.getSorter().decode("order by name");
        viewInfo.setSorter(sorterItemCollection);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)ArapContrastDiffRptUtils.getSelectorItemCollection());
        return viewInfo;
    }

    private static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    protected static String getCussAcctRangeIds(Context ctx, ContrastGLQueryParam param) throws BOSException, EASBizException {
        String sql = ArApReportHelper.getCussObjsSql(ctx, param);
        String nameFld = "FName_" + ctx.getLocale().getLanguage() + " ";
        String tblDefine = "(FId varchar(44), " + nameFld + " nvarchar(400), FNumber nvarchar(80) )";
        String tmpIdsTbl = TempTableUtil.createTempTable(ctx, tblDefine);
        String insSql = "insert into " + tmpIdsTbl + " (FId, " + nameFld + ", FNumber)\r\n " + sql.toString();
        logger.debug((Object)(" the tmpCussAcctIds: \r\n" + insSql));
        DbUtil.execute((Context)ctx, (String)insSql);
        return "select FId from " + tmpIdsTbl;
    }

    public static String getCurrentAcctTable(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        if (company.getAccountTable() == null) {
            return null;
        }
        String companyID = company.getId().toString();
        String accountTableID = company.getAccountTable().getId().toString();
        int periodYear = period.getPeriodYear();
        int periodNumber = period.getPeriodNumber();
        return AccountTools.getCurrentAcctTable((Context)ctx, (String)companyID, (String)accountTableID, (int)periodYear, (int)periodNumber);
    }

    public static String convertDateToString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        return df.format(date);
    }

    public static Date downTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarDown = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5));
        Date dateDown = new Date(calendarDown.getTime().getTime());
        return dateDown;
    }

    public static Date upTimestamp(Timestamp oldTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(oldTime);
        GregorianCalendar calendarUp = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5) + 1);
        Date dateUp = new Date(calendarUp.getTime().getTime());
        return dateUp;
    }
}

