/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillPlanCollection;
import com.kingdee.eas.fi.ap.OtherBillPlanInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.ap.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillPlanBaseInfo;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.PaymentBillTypeInfo;
import com.kingdee.eas.fi.cas.RecPayBillCollection;
import com.kingdee.eas.fi.cas.RecPayBillEntryInfo;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogAdapter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class RecPayServiceUtil {
    public static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String DELIMIT = ";";

    public static void reversePayAmountFields(Context ctx, PaymentBillInfo info, BatchActionEnum actionEnum) throws BOSException, EASBizException {
        boolean isHasValue = false;
        String tableName = "T_CAS_PaymentBillEntry";
        HashSet<String> idSet = new HashSet<String>();
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (info.getEntries().get(i) == null || info.getEntries().get(i).getId() == null) continue;
            idSet.add(info.getEntries().get(i).getId().toString());
        }
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, idSet)) {
            isHasValue = true;
        }
        boolean isPayRequestBill = false;
        if (info.getEntries() != null && info.getEntries().size() > 0 && info.getEntries().get(0).getSourceBillId() != null && "D001019A".equals(BOSUuid.read((String)info.getEntries().get(0).getSourceBillId()).getType().toString())) {
            isPayRequestBill = true;
        }
        if (!((info.isIsInitializeBill() || !info.isAssoGenByApBill() || info.isIsTransBill()) && !isPayRequestBill || isHasValue && BatchActionEnum.SAVE != actionEnum)) {
            if (info.getId() != null && PaymentBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                SelectorItemCollection selectorColl = new SelectorItemCollection();
                selectorColl.add(new SelectorItemInfo("*"));
                selectorColl.add(new SelectorItemInfo("entries.*"));
                selectorColl.add(new SelectorItemInfo("company.baseCurrency.id"));
                PaymentBillInfo payInfo = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), selectorColl);
                ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)payInfo, BOTBillOperStateEnum.DELETE);
                if (null == info.getCompany().getBaseCurrency() || null == info.getCompany().getBaseCurrency().getId()) {
                    info.getCompany().setBaseCurrency(payInfo.getCompany().getBaseCurrency());
                }
            }
            ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)info, BOTBillOperStateEnum.ADDNEW);
        } else if (isHasValue) {
            int i;
            PaymentBillEntryInfo entryInfo = null;
            boolean isFromArAp = false;
            int size2 = info.getEntries().size();
            for (i = 0; i < size2; ++i) {
                entryInfo = info.getEntries().get(i);
                if (StringUtils.isEmpty((String)entryInfo.getSourceBillEntryId()) || !"ED4DBC81".equals(BOSUuid.read((String)entryInfo.getSourceBillEntryId()).getType().toString()) && !"BC91693F".equals(BOSUuid.read((String)entryInfo.getSourceBillEntryId()).getType().toString())) continue;
                isFromArAp = true;
                break;
            }
            if (isFromArAp) {
                size2 = info.getEntries().size();
                for (i = 0; i < size2; ++i) {
                    entryInfo = info.getEntries().get(i);
                    entryInfo.setLockAmt(entryInfo.getAmount());
                    entryInfo.setLockLocAmt(entryInfo.getLocalAmt());
                    entryInfo.setUnLockAmt(ZERO);
                    entryInfo.setUnLockLocAmt(ZERO);
                }
            }
            if (info.getId() != null && PaymentBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                SelectorItemCollection selectorColl = new SelectorItemCollection();
                selectorColl.add(new SelectorItemInfo("*"));
                selectorColl.add(new SelectorItemInfo("entries.*"));
                selectorColl.add(new SelectorItemInfo("company.baseCurrency.id"));
                PaymentBillInfo oldModel = PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), selectorColl);
                if (BillStatusEnum.SAVE == oldModel.getBillStatus()) {
                    ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)oldModel, BOTBillOperStateEnum.DELETE);
                }
            }
        }
    }

    public static void reverseRecAmountFields(Context ctx, ReceivingBillInfo info, BatchActionEnum actionEnum, boolean isHasBizFlow) throws BOSException, EASBizException {
        if (!(info.isIsInitializeBill() || !info.isAssoGenByArBill() || info.isIsTransBill() || isHasBizFlow && actionEnum != BatchActionEnum.SAVE)) {
            if (info.getId() != null && ReceivingBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                SelectorItemCollection selectorColl = new SelectorItemCollection();
                selectorColl.add(new SelectorItemInfo("*"));
                selectorColl.add(new SelectorItemInfo("entries.*"));
                selectorColl.add(new SelectorItemInfo("company.baseCurrency.id"));
                ReceivingBillInfo recInfo = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), selectorColl);
                ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)recInfo, BOTBillOperStateEnum.DELETE);
            }
            ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)info, BOTBillOperStateEnum.ADDNEW);
        } else if (isHasBizFlow) {
            int i;
            ReceivingBillEntryInfo entryInfo = null;
            boolean isFromArAp = false;
            int size = info.getEntries().size();
            for (i = 0; i < size; ++i) {
                entryInfo = info.getEntries().get(i);
                if (StringUtils.isEmpty((String)entryInfo.getSourceBillEntryId()) || !"ED4DBC81".equals(BOSUuid.read((String)entryInfo.getSourceBillEntryId()).getType().toString()) && !"BC91693F".equals(BOSUuid.read((String)entryInfo.getSourceBillEntryId()).getType().toString())) continue;
                isFromArAp = true;
                break;
            }
            if (isFromArAp) {
                size = info.getEntries().size();
                for (i = 0; i < size; ++i) {
                    entryInfo = info.getEntries().get(i);
                    entryInfo.setLockAmt(entryInfo.getAmount());
                    entryInfo.setLockLocAmt(entryInfo.getAmountVc());
                    entryInfo.setUnLockAmt(ZERO);
                    entryInfo.setUnLockLocAmt(ZERO);
                }
            }
            if (info.getId() != null && ReceivingBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()))) {
                SelectorItemCollection selectorColl = new SelectorItemCollection();
                selectorColl.add(new SelectorItemInfo("*"));
                selectorColl.add(new SelectorItemInfo("entries.*"));
                selectorColl.add(new SelectorItemInfo("company.baseCurrency.id"));
                ReceivingBillInfo recInfo = ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), selectorColl);
                if (recInfo.getBillStatus() == BillStatusEnum.SAVE) {
                    ArApBillReverseHelper.reverseLockAmt(ctx, (RecPayBillInfo)recInfo, BOTBillOperStateEnum.DELETE);
                }
            }
        }
    }

    public static void reverseOtherBillAndPreBill(Context ctx, ArApBillBaseInfo info, OperationTypeEnum operType) throws BOSException, EASBizException {
        boolean isAR = info.getBOSType().toString().equals(OtherBillInfo.getBosType().toString());
        Object entryID = null;
        String prePayAmount = null;
        BigDecimal prePayAmountDec = null;
        PreparedStatement pstmt = null;
        Statement stmt = null;
        Connection conn = null;
        IRowSet rs = null;
        String recPayTable = isAR ? "T_CAS_ReceivingBill" : "T_CAS_PAYMENTBILL";
        String recPayEntryTable = isAR ? "T_CAS_ReceivingBillENTRY" : "T_CAS_PAYMENTBILLENTRY";
        String recPayHeadField = isAR ? "FReceivingBillID" : "FPaymentBillID";
        String unLockOperType = operType.equals((Object)OperationTypeEnum.Positive) ? "-" : "+";
        String lockOperType = operType.equals((Object)OperationTypeEnum.Positive) ? "+" : "-";
        String sql = "update " + recPayEntryTable + " set FUnLockAmt = FUnLockAmt " + unLockOperType + " ? ,FUnLockLocAmt = FUnLockLocAmt " + unLockOperType + " ? ,FLockAmt = FLockAmt " + lockOperType + " ? ,FLockLocAmt = FLockLocAmt " + lockOperType + " ?  where FID = ?";
        String headSql = null;
        String veriSql = null;
        String preBillNumber = info.getString(isAR ? "preRecBillNumber" : "prePayBillNumber");
        Object[] prePayBillNumberArr = preBillNumber.split(DELIMIT);
        String preBillEntryIDs = info.getString(isAR ? "preRecBillEntryIDs" : "prePayBillEntryIDs");
        String preAmountStr = info.getString(isAR ? "preRecAmountString" : "prePayAmountString");
        Object[] preBillEntryIDsArr = preBillEntryIDs == null ? new String[]{} : preBillEntryIDs.split(DELIMIT);
        String[] preAmountArr = preAmountStr == null ? new String[]{} : preAmountStr.split(DELIMIT);
        try {
            int precision = 0;
            if (info.getCompany().getBaseCurrency() == null) {
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add(new SelectorItemInfo("baseCurrency.precision"));
                CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), selector);
                precision = company.getBaseCurrency().getPrecision();
            } else {
                precision = info.getCompany().getBaseCurrency().getPrecision();
            }
            if (precision == 0) {
                precision = 2;
            }
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), new java.util.Date());
            BigDecimal converRate = new BigDecimal("1.0");
            boolean isDirectExchangeRate = true;
            if (rateInfo != null) {
                isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate(rateInfo);
            }
            String entryIds = StringUtil.getKeyIdList((Object[])preBillEntryIDsArr);
            String selectExRateSql = " select entry.fid as entryId,head.fexchangeRate as exchangeRate from " + recPayTable + " as head inner join " + recPayEntryTable + " as entry on head.fid = entry." + recPayHeadField + " where entry.fid in(" + entryIds + ")";
            rs = DbUtil.executeQuery((Context)ctx, (String)selectExRateSql);
            String entryId = null;
            BigDecimal exRate = BigDecimal.ONE;
            HashMap<String, BigDecimal> entryIdExRateMap = new HashMap<String, BigDecimal>();
            while (rs.next()) {
                entryId = rs.getString("entryId");
                exRate = rs.getBigDecimal("exchangeRate");
                if (exRate == null) {
                    exRate = BigDecimal.ONE;
                }
                entryIdExRateMap.put(entryId, exRate);
            }
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            stmt = conn.createStatement();
            for (int i = 0; i < preBillEntryIDsArr.length; ++i) {
                entryID = preBillEntryIDsArr[i];
                prePayAmount = preAmountArr[i];
                prePayAmountDec = new BigDecimal(prePayAmount);
                pstmt.setBigDecimal(1, prePayAmountDec);
                pstmt.setBigDecimal(2, BaseDataUtil.caculateLocalAmount(prePayAmountDec, (BigDecimal)entryIdExRateMap.get(entryID), isDirectExchangeRate, precision));
                pstmt.setBigDecimal(3, prePayAmountDec);
                pstmt.setBigDecimal(4, BaseDataUtil.caculateLocalAmount(prePayAmountDec, (BigDecimal)entryIdExRateMap.get(entryID), isDirectExchangeRate, precision));
                pstmt.setString(5, (String)entryID);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            HashMap<String, String> idNumberMap = new HashMap<String, String>();
            HashSet<Object> numberSet = new HashSet<Object>();
            if (operType.equals((Object)OperationTypeEnum.Positive)) {
                headSql = "update " + recPayTable + " set FIsPreVerify = 1 where FNumber in (?)";
            } else {
                IReceivingBill iRecPayBill = isAR ? ReceivingBillFactory.getLocalInstance((Context)ctx) : PaymentBillFactory.getLocalInstance((Context)ctx);
                String numbers = StringUtil.getKeyIdList((Object[])prePayBillNumberArr);
                RecPayBillCollection preCol = iRecPayBill.getRecPayBillCollection("select id,number where number in (" + numbers + ") and company = '" + info.getCompany().getId().toString() + "'");
                int size = preCol.size();
                for (int i = 0; i < size; ++i) {
                    RecPayBillInfo preInfo = preCol.get(i);
                    idNumberMap.put(preInfo.getId().toString(), preInfo.getNumber());
                }
                String sqlIds = ArApBillUtil.convertSetToString(idNumberMap.keySet());
                veriSql = " select FDestObjectID from T_BOT_RELATION where FDestObjectID in " + sqlIds + " and FType = 100 and FSrcObjectID <> '" + info.getId().toString() + "'";
                headSql = "update " + recPayTable + " set  FIsPreVerify = 0 where FNumber in (?)";
            }
            String sqlNumbers = null;
            if (operType.equals((Object)OperationTypeEnum.Positive)) {
                sqlNumbers = StringUtil.getKeyIdList((Object[])prePayBillNumberArr);
            } else {
                List<Object> list = Arrays.asList(prePayBillNumberArr);
                numberSet.addAll(list);
                rs = DbUtil.executeQuery((Context)ctx, veriSql);
                String destObjectId = "";
                while (rs.next()) {
                    destObjectId = rs.getString("FDestObjectID");
                    numberSet.remove(idNumberMap.get(destObjectId));
                }
                sqlNumbers = StringUtil.getKeyIdList((Object[])numberSet.toArray());
            }
            if (sqlNumbers != null && sqlNumbers.length() > 0) {
                stmt = conn.createStatement();
                headSql = headSql.replace("?", sqlNumbers);
                stmt.execute(headSql);
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, conn);
                SQLUtils.cleanup(stmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        RecPayServiceUtil.dealPreBotpRelation(ctx, info, operType.equals((Object)OperationTypeEnum.Positive) ? BOTBillOperStateEnum.ADDNEW : BOTBillOperStateEnum.DELETE);
    }

    public static void writePreBillLog(Context ctx, ArApBillBaseInfo oldValue, ArApBillBaseInfo newValue, String method) throws BOSException {
        IReceivingBill iRecPayBill;
        RecPayBillCollection preCol;
        String preBillNumberNew;
        String preBillNumberOld;
        boolean isAR = newValue.getBOSType().toString().equals(OtherBillInfo.getBosType().toString());
        HashSet preBillSet = new HashSet();
        if (oldValue != null && !StringUtils.isEmpty((String)(preBillNumberOld = oldValue.getString(isAR ? "preRecBillNumber" : "prePayBillNumber")))) {
            Collections.addAll(preBillSet, preBillNumberOld.split(DELIMIT));
        }
        if (!StringUtils.isEmpty((String)(preBillNumberNew = newValue.getString(isAR ? "preRecBillNumber" : "prePayBillNumber")))) {
            Collections.addAll(preBillSet, preBillNumberNew.split(DELIMIT));
        }
        if (preBillSet.isEmpty()) {
            return;
        }
        String sqlNumbers = StringUtil.getKeyIdList((Object[])preBillSet.toArray());
        if (!StringUtils.isEmpty((String)sqlNumbers) && (preCol = (iRecPayBill = isAR ? ReceivingBillFactory.getLocalInstance((Context)ctx) : PaymentBillFactory.getLocalInstance((Context)ctx)).getRecPayBillCollection("select id,number where number in (" + sqlNumbers + ") and company = '" + newValue.getCompany().getId().toString() + "'")).size() > 0) {
            HashMap idMap = new HashMap(1);
            HashSet<String> idSet = new HashSet<String>(preCol.size());
            for (int i = 0; i < preCol.size(); ++i) {
                idSet.add(preCol.get(i).getId().toString());
            }
            HashMap<String, HashSet<String>> rootIdMap = new HashMap<String, HashSet<String>>();
            String number = "";
            if (newValue != null) {
                number = newValue.getNumber();
            }
            if (StringUtils.isEmpty((String)number) && oldValue != null) {
                number = oldValue.getNumber();
            }
            if (!StringUtils.isEmpty((String)number)) {
                rootIdMap.put(number, idSet);
            }
            idMap.put(preCol.get(0).getBOSType().toString(), idSet);
            BOSObjectType bosType = newValue.getBOSType();
            HashMap<String, String> hashLog = new HashMap<String, String>(10);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
            String methodAlias = "submit".equals(method) ? "\u63d0\u4ea4" : "\u4fdd\u5b58";
            hashLog.put("FEntityID", bosType.toString());
            hashLog.put("FEntityName", entityInfo.getName());
            hashLog.put("FEntityAlias", entityInfo.getAlias());
            hashLog.put("FMethodName", method);
            hashLog.put("FMethodAlias", methodAlias);
            hashLog.put("FOperateOrg", newValue.getCompany().getNumber());
            hashLog.put("FOperateOrgName", newValue.getCompany().getName());
            SCMBizLogAdapter.writeBizLog((Context)ctx, hashLog, (IObjectPK)new ObjectUuidPK(newValue.getCompany().getId()), idMap, rootIdMap);
        }
    }

    public static void dealPreBotpRelation(Context ctx, ArApBillBaseInfo info, BOTBillOperStateEnum operStateEnum) throws BOSException, EASBizException {
        boolean isAR = info.getBOSType().toString().equals(OtherBillInfo.getBosType().toString());
        StringBuilder sql = new StringBuilder();
        PreparedStatement pstmt = null;
        Connection conn = null;
        UserInfo currentUser = CommonServerUtils.getCurrentUser(ctx);
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            if (BOTBillOperStateEnum.DELETE.equals((Object)operStateEnum)) {
                sql.append("delete from T_BOT_RELATION where fsrcObjectID = ? ");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, info.getId().toString());
                pstmt.execute();
            } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)operStateEnum)) {
                IReceivingBill iRecPayBill = isAR ? ReceivingBillFactory.getLocalInstance((Context)ctx) : PaymentBillFactory.getLocalInstance((Context)ctx);
                String payNumber = info.getString(isAR ? "preRecBillNumber" : "prePayBillNumber");
                if ((payNumber = payNumber.replace(" ", "")).endsWith(DELIMIT)) {
                    payNumber = payNumber.substring(0, payNumber.length() - DELIMIT.length());
                }
                payNumber = payNumber.replace(DELIMIT, "','");
                RecPayBillCollection preCol = iRecPayBill.getRecPayBillCollection("select fid where number in ('" + payNumber + "') and company = '" + info.getCompany().getId().toString() + "'");
                HashSet<String> idSet = new HashSet<String>();
                int size = preCol.size();
                for (int i = 0; i < size; ++i) {
                    String id = preCol.get(i).getId().toString();
                    idSet.add(id);
                }
                sql.append("INSERT INTO t_bot_relation(FID,FSrcEntityID,FDestEntityID,FSrcObjectID,FDestObjectID,FOperatorID,FisEffected,FType,FDate)");
                sql.append(" values(?,?,?,?,?,?,?,?,?)");
                pstmt = conn.prepareStatement(sql.toString());
                Iterator iter = idSet.iterator();
                String destObjectID = null;
                while (iter.hasNext()) {
                    destObjectID = (String)iter.next();
                    pstmt.setString(1, BOSUuid.create((BOSObjectType)new BOTRelationInfo().getBOSType()).toString());
                    pstmt.setString(2, info.getBOSType().toString());
                    pstmt.setString(3, isAR ? new ReceivingBillInfo().getBOSType().toString() : new PaymentBillInfo().getBOSType().toString());
                    pstmt.setString(4, info.getId().toString());
                    pstmt.setString(5, destObjectID);
                    pstmt.setString(6, currentUser.getId().toString());
                    pstmt.setInt(7, 1);
                    pstmt.setInt(8, 100);
                    pstmt.setDate(9, new Date(System.currentTimeMillis()));
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    public static void reversePreOtherBill(Context ctx, ArApBillBaseInfo info) throws BOSException, EASBizException {
        int i;
        boolean isAR = info.getBOSType().toString().equals(OtherBillInfo.getBosType().toString());
        if (org.stefan.snrpc.util.StringUtil.isEmpty((String)info.getString(isAR ? "preRecBillNumber" : "prePayBillNumber"))) {
            return;
        }
        ArApBillEntryBaseInfo entryInfo = null;
        int precision = 0;
        if (info.getCompany().getBaseCurrency() == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("baseCurrency.precision"));
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()), selector);
            precision = company.getBaseCurrency().getPrecision();
        } else {
            precision = info.getCompany().getBaseCurrency().getPrecision();
        }
        if (precision == 0) {
            precision = 2;
        }
        ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, info.getCompany(), info.getCurrency(), new java.util.Date());
        BigDecimal converRate = new BigDecimal("1.0");
        boolean isDirectExchangeRate = true;
        if (rateInfo != null) {
            if (info.getExchangeRate() != null) {
                converRate = info.getExchangeRate();
            }
            isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate(rateInfo);
        }
        BigDecimal prePayAmount = info.getBigDecimal(isAR ? "preRecAmount" : "prePayAmount");
        AbstractBaseObjectCollection col = (AbstractBaseObjectCollection)info.get("entry");
        HashSet<Integer> negativeSet = new HashSet<Integer>();
        BigDecimal posDecimal = ZERO;
        BigDecimal posDecimalLocal = ZERO;
        int size = col.size();
        for (i = 0; i < size; ++i) {
            entryInfo = (ArApBillEntryBaseInfo)col.getObject(i);
            if (prePayAmount.signum() * entryInfo.getRecievePayAmount().signum() >= 0) continue;
            negativeSet.add(i);
            posDecimal = posDecimal.add(entryInfo.getRecievePayAmount());
            posDecimalLocal = posDecimalLocal.add(entryInfo.getRecievePayAmountLocal());
            entryInfo.setLockVerifyAmt(entryInfo.getRecievePayAmount());
            entryInfo.setLockVerifyAmtLocal(entryInfo.getRecievePayAmountLocal());
            entryInfo.setLockUnVerifyAmt(ZERO);
            entryInfo.setLockUnVerifyAmtLocal(ZERO);
        }
        size = col.size();
        for (i = 0; i < size; ++i) {
            if (negativeSet.contains(i)) continue;
            entryInfo = (ArApBillEntryBaseInfo)col.getObject(i);
            if (posDecimal.abs().compareTo(ZERO) == 0) break;
            if (posDecimal.abs().compareTo(entryInfo.getRecievePayAmount().abs()) >= 0) {
                entryInfo.setLockVerifyAmt(entryInfo.getRecievePayAmount());
                entryInfo.setLockVerifyAmtLocal(entryInfo.getRecievePayAmountLocal());
                entryInfo.setLockUnVerifyAmt(ZERO);
                entryInfo.setLockUnVerifyAmtLocal(ZERO);
                posDecimal = posDecimal.subtract(entryInfo.getRecievePayAmount().negate());
                posDecimalLocal = posDecimalLocal.subtract(entryInfo.getRecievePayAmountLocal().negate());
                continue;
            }
            entryInfo.setLockVerifyAmt(posDecimal.negate());
            entryInfo.setLockVerifyAmtLocal(posDecimalLocal.negate());
            entryInfo.setLockUnVerifyAmt(entryInfo.getRecievePayAmount().subtract(posDecimal.negate()));
            entryInfo.setLockUnVerifyAmtLocal(entryInfo.getRecievePayAmountLocal().subtract(posDecimalLocal.negate()));
            posDecimal = ZERO;
            posDecimalLocal = ZERO;
        }
        size = col.size();
        for (i = 0; i < size && prePayAmount.compareTo(ZERO) != 0; ++i) {
            if (negativeSet.contains(i)) continue;
            entryInfo = (ArApBillEntryBaseInfo)col.getObject(i);
            if (prePayAmount.abs().compareTo(entryInfo.getLockUnVerifyAmt().abs()) > 0) {
                prePayAmount = prePayAmount.subtract(entryInfo.getLockUnVerifyAmt());
                entryInfo.setLockVerifyAmt(entryInfo.getRecievePayAmount());
                entryInfo.setLockVerifyAmtLocal(entryInfo.getRecievePayAmountLocal());
                entryInfo.setLockUnVerifyAmt(ZERO);
                entryInfo.setLockUnVerifyAmtLocal(ZERO);
                continue;
            }
            if (prePayAmount.abs().compareTo(entryInfo.getLockUnVerifyAmt().abs()) < 0) {
                BigDecimal lockAmt = prePayAmount;
                prePayAmount = ZERO;
                lockAmt = lockAmt.add(entryInfo.getLockVerifyAmt());
                entryInfo.setLockVerifyAmt(lockAmt);
                entryInfo.setLockVerifyAmtLocal(BaseDataUtil.caculateLocalAmount(lockAmt, converRate, isDirectExchangeRate, precision));
                entryInfo.setLockUnVerifyAmt(entryInfo.getRecievePayAmount().subtract(entryInfo.getLockVerifyAmt()));
                entryInfo.setLockUnVerifyAmtLocal(entryInfo.getRecievePayAmountLocal().subtract(entryInfo.getLockVerifyAmtLocal()));
                continue;
            }
            prePayAmount = ZERO;
            entryInfo.setLockVerifyAmt(entryInfo.getRecievePayAmount());
            entryInfo.setLockVerifyAmtLocal(entryInfo.getRecievePayAmountLocal());
            entryInfo.setLockUnVerifyAmt(ZERO);
            entryInfo.setLockUnVerifyAmtLocal(ZERO);
        }
        for (i = 0; i < col.size(); ++i) {
            ArApBillEntryBaseInfo entry = (ArApBillEntryBaseInfo)col.getObject(i);
            entry.setPreRecPayAmount(entry.getLockVerifyAmt());
        }
    }

    public static void reversePrePayOtherBillUnAudit(Context ctx, com.kingdee.eas.fi.ap.OtherBillInfo info) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        Connection conn = null;
        String sql = "update T_AP_OTHERBILLENTRY set FLockUnVerifyAmt = ? ,FLockUnVerifyAmtLocal =  ? ,FLockVerifyAmt = ? ,FLockVerifyAmtLocal = ?  where FID = ?";
        String planSql = "update T_AP_OTHERBILLPLAN set FUnLockAmount = ? ,FUnLockAmountLoc =  ? ,FLockAmount = ? ,FLockAmountLoc = ?  where FID = ?";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            OtherBillentryCollection entryCol = info.getEntry();
            for (int i = 0; i < entryCol.size(); ++i) {
                OtherBillentryInfo entryInfo = entryCol.get(i);
                if (entryInfo.getLockVerifyAmt().compareTo(ZERO) == 0) continue;
                pstmt.setBigDecimal(1, entryInfo.getRecievePayAmount());
                pstmt.setBigDecimal(2, entryInfo.getRecievePayAmountLocal());
                pstmt.setBigDecimal(3, ZERO);
                pstmt.setBigDecimal(4, ZERO);
                pstmt.setString(5, entryInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt = conn.prepareStatement(planSql);
            OtherBillPlanCollection planCol = info.getPayPlan();
            for (int i = 0; i < planCol.size(); ++i) {
                OtherBillPlanInfo planInfo = planCol.get(i);
                if (planInfo.getLockAmount().compareTo(ZERO) == 0) continue;
                pstmt.setBigDecimal(1, planInfo.getRecievePayAmount());
                pstmt.setBigDecimal(2, planInfo.getRecievePayAmountLocal());
                pstmt.setBigDecimal(3, ZERO);
                pstmt.setBigDecimal(4, ZERO);
                pstmt.setString(5, planInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void reversePreOtherBillUnAudit(Context ctx, ArApBillBaseInfo info) throws BOSException, EASBizException {
        Boolean isAR = info.getBOSType().toString().equals(OtherBillInfo.getBosType());
        String entryTable = isAR != false ? "T_AR_OTHERBILLENTRY" : "T_AP_OTHERBILLENTRY";
        String planTable = isAR != false ? "T_AR_OTHERBILLPLAN" : "T_AP_OTHERBILLPLAN";
        PreparedStatement pstmt = null;
        Connection conn = null;
        String sql = "update " + entryTable + " set FLockUnVerifyAmt = ? ,FLockUnVerifyAmtLocal =  ? ,FLockVerifyAmt = ? ,FLockVerifyAmtLocal = ?  where FID = ?";
        String planSql = "update " + planTable + " set FUnLockAmount = ? ,FUnLockAmountLoc =  ? ,FLockAmount = ? ,FLockAmountLoc = ?  where FID = ?";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            AbstractBaseObjectCollection entryCol = (AbstractBaseObjectCollection)info.get("entry");
            for (int i = 0; i < entryCol.size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryCol.getObject(i);
                if (entryInfo.getLockVerifyAmt().compareTo(ZERO) == 0) continue;
                pstmt.setBigDecimal(1, entryInfo.getRecievePayAmount());
                pstmt.setBigDecimal(2, entryInfo.getRecievePayAmountLocal());
                pstmt.setBigDecimal(3, ZERO);
                pstmt.setBigDecimal(4, ZERO);
                pstmt.setString(5, entryInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            pstmt = conn.prepareStatement(planSql);
            AbstractBaseObjectCollection planCol = (AbstractBaseObjectCollection)info.get(isAR != false ? "recievePlan" : "payPlan");
            for (int i = 0; i < planCol.size(); ++i) {
                ArApBillPlanBaseInfo planInfo = (ArApBillPlanBaseInfo)planCol.getObject(i);
                if (planInfo.getLockAmount().compareTo(ZERO) == 0) continue;
                pstmt.setBigDecimal(1, planInfo.getRecievePayAmount());
                pstmt.setBigDecimal(2, planInfo.getRecievePayAmountLocal());
                pstmt.setBigDecimal(3, ZERO);
                pstmt.setBigDecimal(4, ZERO);
                pstmt.setString(5, planInfo.getId().toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    public static void reverseOtherBillLock(Context ctx, RecPayBillInfo info, boolean isAR, BOTBillOperStateEnum operStateEnum) throws BOSException, EASBizException {
        String tableName = null;
        String tableHeadName = null;
        String planTableName = null;
        StringBuilder sql = new StringBuilder();
        String planSql = null;
        AbstractObjectCollection entryColl = (AbstractObjectCollection)info.get("entries");
        HashSet<String> sourceBillIdSet = new HashSet<String>();
        RecPayBillEntryInfo entryInfo = null;
        int size = entryColl.size();
        for (int j = 0; j < size; ++j) {
            entryInfo = (RecPayBillEntryInfo)entryColl.getObject(0);
            if (StringUtils.isEmpty((String)entryInfo.getSourceBillId())) continue;
            sourceBillIdSet.add(entryInfo.getSourceBillId());
        }
        if (sourceBillIdSet.size() > 1) {
            throw new ArApCommonException(ArApCommonException.DIFF_CURRENCY_NOT_SUPPORT_IDS);
        }
        String sourceBillId = ((AbstractObjectCollection)info.get("entries")).getObject(0).getString("sourceBillId");
        if (isAR) {
            tableName = "T_AR_OTHERBILLENTRY";
            tableHeadName = "T_AR_OTHERBILL";
            planTableName = "T_AR_OTHERBILLPLAN";
        } else {
            tableName = "T_AP_OTHERBILLENTRY";
            tableHeadName = "T_AP_OTHERBILL";
            planTableName = "T_AP_OTHERBILLPLAN";
        }
        if (BOTBillOperStateEnum.DELETE.equals((Object)operStateEnum)) {
            sql.append("update ").append(tableName).append(" set FLockUnVerifyAmt = FunVerifyAmount ,FLockUnVerifyAmtLocal =  FUnVerifyAmountLocal ,FLockVerifyAmt = FverifyAmount ,FLockVerifyAmtLocal = FverifyAmountLocal ").append(" where FParentID = ?");
            planSql = "update " + planTableName + " set FUnLockAmount = FUNVERIFYAMOUNT ,FUnLockAmountLoc =  FUNVERIFYAMOUNTLOCAL ,FLockAmount = FVERIFYAMOUNT ,FLockAmountLoc = FVERIFYAMOUNTLOCAL  where fparentID = ?";
        } else if (BOTBillOperStateEnum.ADDNEW.equals((Object)operStateEnum) || BOTBillOperStateEnum.EDIT.equals((Object)operStateEnum)) {
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)operStateEnum)) {
                StringBuilder checkSql = new StringBuilder(100);
                checkSql.append("SELECT bill.FNUMBER FNUMBER FROM ").append(tableHeadName).append(" bill ");
                checkSql.append(" INNER JOIN ").append(tableName).append(" entry ");
                checkSql.append(" on bill.FID  = entry.FPARENTID ");
                checkSql.append(" where bill.FID = '").append(sourceBillId).append("' and entry.FLOCKUNVERIFYAMT = 0");
                IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)checkSql.toString());
                try {
                    if (rowSet.next()) {
                        String number = rowSet.getString("FNUMBER");
                        throw new ArApCommonException(ArApCommonException.DIFF_CURRENCY_BILL_LOCKED, new Object[]{number});
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
            sql.append("update ").append(tableName).append(" set FLockUnVerifyAmt = 0 ,FLockUnVerifyAmtLocal =  0 ,FLockVerifyAmt = FRecievePayAmount ,FLockVerifyAmtLocal = FRecievePayAmountLocal ").append(" where FParentID = ?");
            planSql = "update " + planTableName + " set FUnLockAmount = 0 ,FUnLockAmountLoc =  0 ,FLockAmount = FRecievePayAmount ,FLockAmountLoc = FRecievePayAmountLocal  where fparentID = ?";
        }
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{sourceBillId});
        DbUtil.execute((Context)ctx, (String)planSql, (Object[])new Object[]{sourceBillId});
        entryInfo = (RecPayBillEntryInfo)entryColl.getObject(0);
        entryInfo.setLockAmt(entryInfo.getAmount());
        entryInfo.setLockLocAmt(entryInfo.getLocalAmt());
        entryInfo.setUnLockAmt(ZERO);
        entryInfo.setUnLockLocAmt(ZERO);
    }

    public static void reverseRecPayLockAmt(Context ctx, RecPayBillInfo info, boolean isAR) throws BOSException, EASBizException {
        boolean isExist = false;
        AbstractObjectCollection entries = (AbstractObjectCollection)info.get("entries");
        String sourceBillId = ((RecPayBillEntryInfo)entries.getObject(0)).getSourceBillId();
        if (StringUtils.isEmpty((String)sourceBillId)) {
            return;
        }
        if (!SourceTypeEnum.AR.equals((Object)info.getSourceType()) && !SourceTypeEnum.AP.equals((Object)info.getSourceType())) {
            return;
        }
        String bosType = BOSUuid.read((String)sourceBillId).getType().toString();
        if (isAR ? !"FA44FD5B".equals(bosType) || info.isIsTransBill() : !"40284E81".equals(bosType)) {
            return;
        }
        isExist = isAR ? ReceivingBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId())) : PaymentBillFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(info.getId()));
        if (isExist) {
            SelectorItemCollection selectorColl = new SelectorItemCollection();
            selectorColl.add(new SelectorItemInfo("*"));
            selectorColl.add(new SelectorItemInfo("entries.*"));
            Object recPayInfo = null;
            recPayInfo = isAR ? ReceivingBillFactory.getLocalInstance((Context)ctx).getReceivingBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), selectorColl) : PaymentBillFactory.getLocalInstance((Context)ctx).getPaymentBillInfo((IObjectPK)new ObjectUuidPK(info.getId()), selectorColl);
            RecPayServiceUtil.reverseRecPayLockAmt(ctx, (RecPayBillInfo)recPayInfo, isAR, BOTBillOperStateEnum.DELETE);
        }
        RecPayServiceUtil.checkRecPayAmt(ctx, isAR, entries);
        RecPayServiceUtil.reverseRecPayLockAmt(ctx, info, isAR, BOTBillOperStateEnum.ADDNEW);
    }

    public static void reverseRecPayLockAmt(Context ctx, RecPayBillInfo info, boolean isAR, BOTBillOperStateEnum operStateEnum) throws BOSException, EASBizException {
        String tableName = null;
        PreparedStatement pstmt = null;
        Connection conn = null;
        RecPayBillEntryInfo entryInfo = null;
        RecPayBillEntryInfo srcEntryInfo = null;
        AbstractObjectCollection entries = (AbstractObjectCollection)info.get("entries");
        String sourceBillId = ((RecPayBillEntryInfo)entries.getObject(0)).getSourceBillId();
        if (StringUtils.isEmpty((String)sourceBillId)) {
            return;
        }
        BOSObjectType srcBosType = BOSUuid.read((String)sourceBillId).getType();
        String bosType = srcBosType.toString();
        if (!SourceTypeEnum.AR.equals((Object)info.getSourceType()) && !SourceTypeEnum.AP.equals((Object)info.getSourceType())) {
            return;
        }
        if (isAR) {
            tableName = "T_CAS_ReceivingBillEntry";
            if (!"FA44FD5B".equals(bosType)) {
                return;
            }
        } else {
            if (!"40284E81".equals(bosType)) {
                return;
            }
            tableName = "T_CAS_PaymentBillEntry";
        }
        HashSet<String> sourceIdSet = new HashSet<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = (RecPayBillEntryInfo)entries.getObject(i);
            if (StringUtils.isEmpty((String)entryInfo.getSourceBillId())) continue;
            sourceIdSet.add(entryInfo.getSourceBillId());
        }
        HashMap<String, Boolean> isDirectExCache = new HashMap<String, Boolean>();
        HashMap<String, BigDecimal> exchangeRateCache = new HashMap<String, BigDecimal>();
        HashMap<String, Integer> precisionCache = new HashMap<String, Integer>();
        HashMap<String, RecPayBillEntryInfo> entryUnLockAmtMap = new HashMap<String, RecPayBillEntryInfo>();
        RecPayServiceUtil.preGetRecPayBillInfo(ctx, srcBosType, sourceIdSet, isDirectExCache, exchangeRateCache, precisionCache, entryUnLockAmtMap);
        String unLockOperType = operStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW) ? "-" : "+";
        String lockOperType = operStateEnum.equals((Object)BOTBillOperStateEnum.ADDNEW) ? "+" : "-";
        String sql = "update " + tableName + " set  FLockAmt = FlockAmt " + lockOperType + "? ,FLockLocAmt =  FLockLocAmt " + lockOperType + "? ,FUnLockAmt = FUnLockAmt " + unLockOperType + "? ,FUnLockLocAmt = FUnLockLocAmt " + unLockOperType + "?  where FID = ?";
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            BigDecimal payAmt = BigDecimal.ZERO;
            BigDecimal srcUnLockAmt = BigDecimal.ZERO;
            BigDecimal srcUnLockAmtLoc = BigDecimal.ZERO;
            BigDecimal payAmtLoc = BigDecimal.ZERO;
            BigDecimal exchangeRate = BigDecimal.ONE;
            boolean isDirectExchangeRate = true;
            int precision = 2;
            String srcId = "";
            String srcEntryId = "";
            int size2 = entries.size();
            for (int i = 0; i < size2; ++i) {
                entryInfo = (RecPayBillEntryInfo)entries.getObject(i);
                payAmt = entryInfo.getAmount().negate();
                srcId = entryInfo.getSourceBillId();
                srcEntryId = entryInfo.getSourceBillEntryId();
                if (null != entryUnLockAmtMap.get(srcEntryId) && null != (srcEntryInfo = (RecPayBillEntryInfo)entryUnLockAmtMap.get(srcEntryId)).getUnLockAmt() && null != srcEntryInfo.getUnLockLocAmt()) {
                    srcUnLockAmt = srcEntryInfo.getUnLockAmt();
                    srcUnLockAmtLoc = srcEntryInfo.getUnLockLocAmt();
                }
                if (null != isDirectExCache.get(srcId)) {
                    isDirectExchangeRate = (Boolean)isDirectExCache.get(srcId);
                }
                if (null != exchangeRateCache.get(srcId)) {
                    exchangeRate = (BigDecimal)exchangeRateCache.get(srcId);
                }
                if (null != precisionCache.get(srcId)) {
                    precision = (Integer)precisionCache.get(srcId);
                }
                payAmtLoc = BaseDataUtil.caculateLocalAmount(payAmt, exchangeRate, isDirectExchangeRate, precision);
                if (BOTBillOperStateEnum.ADDNEW.equals((Object)operStateEnum) && srcUnLockAmt.compareTo(payAmt) == 0) {
                    payAmtLoc = srcUnLockAmtLoc;
                }
                pstmt.setBigDecimal(1, payAmt);
                pstmt.setBigDecimal(2, payAmtLoc);
                pstmt.setBigDecimal(3, payAmt);
                pstmt.setBigDecimal(4, payAmtLoc);
                pstmt.setString(5, srcEntryId);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
            if (BOTBillOperStateEnum.ADDNEW.equals((Object)operStateEnum)) {
                AbstractObjectCollection entryCol = (AbstractObjectCollection)info.get("entries");
                int size3 = entryCol.size();
                for (int i = 0; i < size3; ++i) {
                    entryInfo = (RecPayBillEntryInfo)entryCol.getObject(i);
                    entryInfo.setLockAmt(entryInfo.getAmount());
                    entryInfo.setLockLocAmt(entryInfo.getLocalAmt());
                    entryInfo.setUnLockAmt(ZERO);
                    entryInfo.setUnLockLocAmt(ZERO);
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected static void preGetRecPayBillInfo(Context ctx, BOSObjectType srcBosType, Set<String> sourceIdSet, Map<String, Boolean> isDirectExCache, Map<String, BigDecimal> exchangeRateCache, Map<String, Integer> precisionCache, Map<String, RecPayBillEntryInfo> entryInfoMap) throws BOSException, EASBizException {
        RecPayBillInfo recPayBillInfo = null;
        RecPayBillEntryInfo entryInfo = null;
        IDynamicObject iObjectInstance = DynamicObjectFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", sourceIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("bizDate");
        sic.add("currency");
        sic.add("company.id");
        sic.add("company.baseCurrency.id");
        sic.add("company.baseCurrency.precision");
        sic.add("exchangeRate");
        sic.add("entries.id");
        sic.add("entries.unLockAmt");
        sic.add("entries.unLockLocAmt");
        view.setSelector(sic);
        IObjectCollection sourceColl = iObjectInstance.getCollection(srcBosType, view);
        if (null == sourceColl || sourceColl.size() == 0) {
            return;
        }
        Boolean isDirectExchangeRate = true;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        Integer precision = 2;
        String recPayId = "";
        String recPayEntryId = "";
        AbstractObjectCollection recPayEntryCol = null;
        int kSize = sourceColl.size();
        for (int k = 0; k < kSize; ++k) {
            recPayBillInfo = (RecPayBillInfo)sourceColl.getObject(k);
            recPayId = recPayBillInfo.getId().toString();
            isDirectExchangeRate = BaseDataUtil.isDirectExchangeRate(BaseDataUtil.getExchangeRate(ctx, recPayBillInfo.getCompany(), recPayBillInfo.getCurrency(), recPayBillInfo.getBizDate()));
            exchangeRate = recPayBillInfo.getExchangeRate();
            precision = recPayBillInfo.getCompany().getBaseCurrency().getPrecision();
            isDirectExCache.put(recPayId, isDirectExchangeRate);
            exchangeRateCache.put(recPayId, exchangeRate);
            precisionCache.put(recPayId, precision);
            recPayEntryCol = (AbstractObjectCollection)recPayBillInfo.get("entries");
            int jSize = recPayEntryCol.size();
            for (int j = 0; j < jSize; ++j) {
                entryInfo = (RecPayBillEntryInfo)recPayEntryCol.getObject(j);
                recPayEntryId = entryInfo.getId().toString();
                entryInfoMap.put(recPayEntryId, entryInfo);
            }
        }
    }

    private static void checkRecPayAmt(Context ctx, boolean isAR, AbstractObjectCollection entries) throws BOSException, EASBizException {
        RecPayBillEntryInfo entryInfo = null;
        String entryTable = isAR ? "t_cas_ReceivingBillentry" : "t_cas_paymentBillentry";
        String sql = "SELECT sourceEntry.FunLockAmt AS sourceUnLockAmt FROM " + entryTable + " sourceEntry WHERE abs(sourceEntry.FUnLockAmt) < ? AND sourceEntry.FID = ?";
        PreparedStatement pstmt = null;
        Connection conn = null;
        ResultSet rs = null;
        StringBuilder msgBuilder = new StringBuilder();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pstmt = conn.prepareStatement(sql);
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entryInfo = (RecPayBillEntryInfo)entries.getObject(i);
                pstmt.setBigDecimal(1, entryInfo.getAmount().abs());
                pstmt.setString(2, entryInfo.getSourceBillEntryId().toString());
                rs = pstmt.executeQuery();
                if (!rs.next()) continue;
                BigDecimal sourceUnLockAmt = rs.getBigDecimal("sourceUnLockAmt");
                msgBuilder.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"AMT_GREATER_SOURCEAMT", (Locale)ctx.getLocale(), (Object[])new Object[]{entryInfo.getSeq(), sourceUnLockAmt})).append("\n");
            }
            if (msgBuilder.length() > 0) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{msgBuilder.toString()});
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rs, (Statement)pstmt, (Connection)conn);
    }

    public static void verifyPayerAccount(AccountBankInfo acctBankInfo, CurrencyInfo Crinfo, AccountViewInfo account, PaymentBillTypeInfo billType) throws ARAPVerifynException {
        if (acctBankInfo != null) {
            CurrencyInfo acctBankCrinfo = acctBankInfo.getCurrency();
            if (acctBankInfo.isIsByCurrency() && acctBankCrinfo != null && !acctBankCrinfo.getId().equals((Object)Crinfo.getId())) {
                throw new ARAPVerifynException(ARAPVerifynException.COMMON, new String[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayerCurrencyNotEqual")});
            }
            if (acctBankInfo != null && acctBankInfo.getAccount() != null && account != null && !acctBankInfo.getAccount().getId().equals((Object)account.getId())) {
                throw new ARAPVerifynException(ARAPVerifynException.COMMON, new String[]{EASResource.getString((String)"com.kingdee.eas.fi.cas.RecPayResource", (String)"PayerAccountViewNotEqual")});
            }
        }
    }
}

