/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.app.web.IAppointmentVoucher;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public abstract class AbstractAppointmentVoucher
implements IAppointmentVoucher {
    protected Context ctx;
    public static final String BR = "<br>";

    protected Context getContext() {
        return this.ctx;
    }

    @Override
    public Map<String, Object> getInitData(String companyid, int system, String orderid, String bostype) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = null;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (!StringUtil.isEmpty((String)companyid)) {
            ObjectUuidPK pk = new ObjectUuidPK(companyid);
            company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)pk);
            resultMap.put("voucherType", this.getVouTypeFilter(company.getCU().getId().toString()));
            PeriodInfo currentPeriod = this.getCurrentPeriod(system, companyid, bostype);
            resultMap.put("currentPeriod", currentPeriod);
        }
        return resultMap;
    }

    protected abstract PeriodInfo getCurrentPeriod(int var1, String var2, String var3) throws BOSException, EASBizException;

    private VoucherTypeCollection getVouTypeFilter(String cuid) throws BOSException, EASBizException {
        ObjectUuidPK[] cuArr = new ObjectUuidPK[]{new ObjectUuidPK(cuid)};
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("pretermit"));
        SorterItemCollection sorters = view.getSorter();
        sorters.add(new SorterItemInfo("number"));
        FilterInfo filterVT = VoucherTypeFactory.getLocalInstance((Context)this.ctx).getDatabaseDFilter((IObjectPK[])cuArr, "id", "adminCU");
        view.setFilter(filterVT);
        view.setSorter(sorters);
        VoucherTypeCollection coll = VoucherTypeFactory.getLocalInstance((Context)this.ctx).getVoucherTypeCollection(view);
        return coll;
    }

    protected VoucherInfo checkVoucher(String companyid, int periodYear, int periodNumber, String voucherTypeid, String vouchernumber) throws EASBizException, BOSException {
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo viewVoucher = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)vouchernumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodYear", (Object)periodYear, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("period.periodNumber", (Object)periodNumber, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("voucherType.id", (Object)voucherTypeid, CompareType.EQUALS));
        viewVoucher.setFilter(filter);
        VoucherCollection voucherCol = iVoucher.getVoucherCollection(viewVoucher);
        if (voucherCol != null && voucherCol.size() > 0) {
            return voucherCol.get(0);
        }
        return null;
    }

    protected void createBotpRelation(String srcObjectId, String destObjectId, String bostype) throws BOSException, UuidException, EASBizException {
        if (StringUtils.isEmpty((String)srcObjectId) || StringUtils.isEmpty((String)destObjectId)) {
            return;
        }
        BOTRelationCollection botRelationCollection = null;
        IBOTRelation iBOTRelation = BOTRelationFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
        String destBosType = BOSUuid.read((String)destObjectId).getType().toString();
        filterInfo.getFilterItems().add(new FilterItemInfo("destObjectID", (Object)destObjectId, CompareType.EQUALS));
        view.setFilter(filterInfo);
        botRelationCollection = iBOTRelation.getCollection(view);
        if (botRelationCollection != null && botRelationCollection.size() > 0) {
            BOTRelationInfo rotpmap = botRelationCollection.get(0);
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            info.setBOTMappingID(rotpmap.getBOTMappingID());
            info.setType(0);
            iBOTRelation.addnew(info);
        } else {
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcEntityID(srcBosType);
            info.setDestEntityID(destBosType);
            info.setSrcObjectID(srcObjectId);
            info.setDestObjectID(destObjectId);
            info.setDate(new Date());
            info.setOperatorID("system");
            info.setIsEffected(true);
            BOTMappingCollection botMappingColl = BOTMappingFactory.getLocalInstance((Context)this.getContext()).getBOTMappingCollection(" select id where SrcEntityName='" + bostype + "' and DestEntityName='2652E01E'");
            if (botMappingColl != null && botMappingColl.size() > 0) {
                info.setBOTMappingID(botMappingColl.get(0).getId().toString());
            }
            info.setType(0);
            iBOTRelation.addnew(info);
        }
    }

    protected void delBotpRelation(String srcObjectId) throws BOSException, UuidException, EASBizException {
        IBOTRelation iBOTRelation2 = BOTRelationFactory.getLocalInstance((Context)this.getContext());
        BOTRelationCollection botRelationCollection2 = null;
        EntityViewInfo view2 = new EntityViewInfo();
        FilterInfo filterInfo2 = new FilterInfo();
        String srcBosType = BOSUuid.read((String)srcObjectId).getType().toString();
        filterInfo2.getFilterItems().add(new FilterItemInfo("srcEntityID", (Object)srcBosType, CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)new VoucherInfo().getBOSType().toString(), CompareType.EQUALS));
        filterInfo2.getFilterItems().add(new FilterItemInfo("srcObjectId", (Object)srcObjectId, CompareType.EQUALS));
        view2.setFilter(filterInfo2);
        botRelationCollection2 = iBOTRelation2.getCollection(view2);
        if (botRelationCollection2.size() > 0) {
            BOTRelationInfo rotpmap = botRelationCollection2.get(0);
            ObjectStringPK pkbot = new ObjectStringPK(rotpmap.getId().toString());
            iBOTRelation2.delete((IObjectPK)pkbot);
        }
    }

    protected void updateVoucherSrcBillId(String srcBillId, VoucherInfo voucher) throws BOSException, EASBizException {
        if (voucher.getSourceBillId() == null && SourceType.HANDCRAFT.equals((Object)voucher.getSourceType())) {
            ObjectUuidPK vorcherID = new ObjectUuidPK(voucher.getId());
            voucher.setSourceBillId(srcBillId);
            IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)this.getContext());
            iVoucher.update((IObjectPK)vorcherID, (CoreBaseInfo)voucher);
        }
    }

    protected Map requestLocks(String ids) throws BOSException {
        ArrayList<String> idList = new ArrayList<String>();
        String[] idArr = ids.split(",");
        int size = idArr.length;
        for (int i = 0; i < size; ++i) {
            idList.add(idArr[i]);
        }
        Map lockMap = MutexServiceControlFactory.getLocalInstance((Context)this.ctx).batchRequestObjIDForUpdate(idList);
        HashSet<String> lockedList = new HashSet<String>();
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("hasLockedBefore", Boolean.valueOf(false));
        result.put("isSuccess", Boolean.valueOf(false));
        if (lockMap != null) {
            for (int i = 0; i < idArr.length; ++i) {
                String id = idArr[i];
                if (!lockMap.containsKey(id) || !((Boolean)lockMap.get(id)).booleanValue()) {
                    result.put("hasLockedBefore", Boolean.valueOf(true));
                    continue;
                }
                lockedList.add(id);
            }
            result.put("isSuccess", Boolean.valueOf(true));
        }
        result.put("lockedIds", lockedList);
        return result;
    }

    protected void releaseLocks(Set idSet) throws BOSException {
        ArrayList lockList = new ArrayList();
        Iterator iter = idSet.iterator();
        while (iter.hasNext()) {
            lockList.add(iter.next());
        }
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getLocalInstance((Context)this.ctx).batchReleaseObjIDForUpdate(lockList);
        }
    }

    protected SystemEnum getSysEnum(String bostype) {
        if ("48DA3A71".equals(bostype) || "40284E81".equals(bostype) || "A8378ABC".equalsIgnoreCase(bostype)) {
            return SystemEnum.ACCOUNTSPAYABLE;
        }
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected String getBillAlias(String bostype) throws BOSException {
        return MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx).getEntity(BOSUuid.create((String)bostype).getType()).getAlias();
    }

    protected String verifyMsg(String billAlias, String number, String mainMsg) {
        Locale locale = this.ctx.getLocale();
        String msg = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"198_ArApBillUIUtil", (Locale)locale) + billAlias + EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"Res_OperError", (Locale)locale) + "\uff1a", number);
        msg = msg + mainMsg;
        return msg;
    }
}

