/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApReportData;
import com.kingdee.eas.fi.ar.ContrastGLFacadeFactory;
import com.kingdee.eas.fi.ar.IReportData;
import com.kingdee.eas.fi.ar.ReportInfo;
import com.kingdee.eas.fi.arap.AmountDirectionEnum;
import com.kingdee.eas.fi.arap.ContrastGLDiffTypeEnum;
import com.kingdee.eas.fi.arap.ContrastGLRptDetailQueryParam;
import com.kingdee.eas.fi.arap.app.util.ArapContrastDiffRptUtils;
import com.kingdee.eas.fi.arap.app.web.ArapRptServiceImpl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArapContrastDiffRptServiceImpl
extends ArapRptServiceImpl {
    private DateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    public ArapContrastDiffRptServiceImpl(Context context) {
        super(context);
    }

    @Override
    public Map<String, Object> query(Map<String, Object> condition) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        boolean fAR = true;
        String system = (String)condition.get("system");
        if (String.valueOf(12).equals(system)) {
            fAR = true;
        } else if (String.valueOf(13).equals(system)) {
            fAR = false;
        } else {
            return result;
        }
        String companyId = (String)condition.get("companyId");
        if (companyId == null) {
            return result;
        }
        String period = (String)condition.get("period");
        String periodId = (String)condition.get("periodId");
        PeriodInfo periodInfo = this.getPeriodInfo(companyId, Integer.parseInt(period));
        if ((periodId == null || periodId.length() == 0) && period != null) {
            periodId = periodInfo.getId().toString();
        }
        if (periodId == null) {
            return result;
        }
        String currencyId = (String)condition.get("currencyId");
        int project = Integer.parseInt((String)condition.get("project"));
        String acctId = (String)condition.get("acctId");
        String asstActId = (String)condition.get("asstActId");
        String cussTypeId = (String)condition.get("cussTypeId");
        Context ctx = this.getContext();
        boolean isContrastByBillAccount = (Boolean)condition.get("isContrastByBillAccount");
        if (isContrastByBillAccount) {
            ContrastGLRptDetailQueryParam param = new ContrastGLRptDetailQueryParam();
            param.setCurrencyId(currencyId);
            param.setCussTypeId(cussTypeId);
            param.setCussAcctId(asstActId);
            param.setAccountId(acctId);
            boolean hasUnRegVoucher = (Boolean)condition.get("hasUnRegVoucher");
            param.setHasUnRegVoucher(hasUnRegVoucher);
            param.setCompanyId(companyId);
            param.setPeriodId(periodId);
            param.setDiffType(ContrastGLDiffTypeEnum.ALL);
            param.setIsArRpt(fAR);
            param.setStartIndex(1);
            param.setEndIndex(20);
            param.setAmtDirection(2 == project ? AmountDirectionEnum.DR : AmountDirectionEnum.CR);
            CompanyOrgUnitInfo company = ArapContrastDiffRptUtils.getCompanyOrgUnitInfo(ctx, companyId);
            CurrencyInfo currency = ArapContrastDiffRptUtils.getCurrencyInfo(ctx, currencyId);
            IReportData data = ContrastGLFacadeFactory.getLocalInstance(ctx).contrastGLRptDetailQuery(param);
            result.put("otherTempTables", data.getOtherTempTables());
            result.put("totalRowCount", data.getTotalRowCount());
            result.put("queryId", data.getTempTable());
            result.put("isContrastByBillAccount", true);
            result.put("title", ArapContrastDiffRptUtils.getContrastDiffTitle(ctx, company, periodInfo, currency, acctId, false, project));
            result.put("precision", currency.getPrecision());
        } else {
            Map temp = ArapContrastDiffRptUtils.createTable(this.getContext(), fAR, companyId, periodId, acctId, project, asstActId, currencyId, cussTypeId);
            result.putAll(temp);
        }
        return result;
    }

    @Override
    public Map<String, Object> getData(Map<String, Object> condition) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap();
        boolean isContrastByBillAccount = false;
        Object obj = condition.get("isContrastByBillAccount");
        if (obj != null) {
            isContrastByBillAccount = obj instanceof Boolean ? (Boolean)obj : Boolean.parseBoolean((String)obj);
        }
        if (isContrastByBillAccount) {
            String queryId = (String)condition.get("queryId");
            String diffType = (String)condition.get("diffType");
            String sortItems = (String)condition.get("sorterItems");
            String strPage = (String)condition.get("page");
            String strRows = (String)condition.get("rows");
            int page = Integer.parseInt(strPage);
            int rows = Integer.parseInt(strRows);
            ContrastGLRptDetailQueryParam param = new ContrastGLRptDetailQueryParam();
            param.setTempTable(queryId);
            param.setDiffType(ContrastGLDiffTypeEnum.getEnum(diffType));
            param.setSortItems(sortItems);
            param.setGUI(false);
            param.setStartIndex((page - 1) * rows + 1);
            param.setEndIndex(page * rows);
            ArApReportData reportData = (ArApReportData)ContrastGLFacadeFactory.getLocalInstance(this.getContext()).contrastGLRptDetailQuery(param);
            if (null != reportData) {
                int total = reportData.getTotalRowCount() % rows == 0 ? reportData.getTotalRowCount() / rows : reportData.getTotalRowCount() / rows + 1;
                map.put("page", page);
                map.put("total", total);
                map.put("records", reportData.getTotalRowCount());
                int pageSize = reportData.size();
                if (pageSize > 0) {
                    List datas = reportData.getRows();
                    ArrayList records = new ArrayList(pageSize);
                    ReportInfo info = null;
                    HashMap<String, Object> row = null;
                    for (int i = 0; i < pageSize; ++i) {
                        info = (ReportInfo)datas.get(i);
                        row = new HashMap<String, Object>(20);
                        row.put("FID", info.getString("FID"));
                        row.put("FBillID", info.getString("FBillID"));
                        row.put("FBillType", info.getString("FBillType"));
                        row.put("FsceneNumber", info.getString("FsceneNumber"));
                        row.put("FVoucher", info.getString("FVoucher"));
                        row.put("FBillNumber", info.getString("FBillNumber"));
                        row.put("FBillDate", info.getString("FBillDate"));
                        row.put("FBillAmount", info.getBigDecimal("FBillAmount"));
                        row.put("FVoucherID", info.getString("FVoucherID"));
                        row.put("FVoucherPeriod", info.getString("FVoucherPeriod"));
                        row.put("FVoucherNumber", info.getString("FVoucherNumber"));
                        row.put("FVoucherAmount", info.getBigDecimal("FVoucherAmount"));
                        row.put("FDiffAmount", info.getBigDecimal("FDiffAmount"));
                        row.put("FDiffType", info.getString("FDiffType"));
                        row.put("FIsSum", info.getInt("FIsSum"));
                        records.add(row);
                    }
                    map.put("rows", records);
                }
            } else {
                map.put("page", 0);
                map.put("total", 0);
                map.put("records", 0);
                map.put("rows", new ArrayList());
            }
        } else {
            map = super.getData(condition);
        }
        return map;
    }

    @Override
    protected IRowSet executeQuery(Map<String, Object> condition, int from, int rows) throws EASBizException, BOSException {
        String queryId = (String)condition.get("queryId");
        String diffType = (String)condition.get("diffType");
        StringBuilder sql = new StringBuilder(200);
        sql.append("select * from " + queryId + " \n");
        sql.append("where fDiffType = " + diffType + " \n");
        if ("0".equals(diffType)) {
            sql.append("or FIsSum = 0 \n");
        }
        sql.append("order by FIsSum, FVoucherNumber");
        return DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (int)from, (int)rows);
    }

    @Override
    protected int getRecords(Map<String, Object> condition) throws EASBizException, BOSException, SQLException {
        IRowSet rs;
        String strRecords = (String)condition.get("records");
        if (strRecords != null && strRecords.length() > 0) {
            return Integer.parseInt(strRecords);
        }
        String queryId = (String)condition.get("queryId");
        if (queryId == null || queryId.length() == 0) {
            return 0;
        }
        String diffType = (String)condition.get("diffType");
        StringBuilder sql = new StringBuilder(150);
        sql.append("select count(*) from " + queryId + " \n");
        sql.append("where fDiffType = " + diffType + " \n");
        if ("0".equals(diffType)) {
            sql.append("or FIsSum = 0 \n");
        }
        if ((rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString())).next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    @Override
    protected Map<String, Object> wrapRow(Map<String, Object> condition, IRowSet rowSet) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("FID", rowSet.getString("FID"));
        row.put("FBillID", rowSet.getString("FBillID"));
        row.put("FBillType", rowSet.getString("FBillType"));
        row.put("FBillNumber", rowSet.getString("FBillNumber"));
        Date date = rowSet.getDate("FBillDate");
        row.put("FBillDate", date != null ? this.format.format(date) : "");
        row.put("FBillAmount", rowSet.getBigDecimal("FBillAmount"));
        String FVoucherID = rowSet.getString("FVoucherID");
        if (FVoucherID == null || FVoucherID.length() == 0) {
            FVoucherID = BOSUuid.create((String)"12345678").toString();
        }
        row.put("FVoucherID", FVoucherID);
        row.put("FVoucherPeriod", rowSet.getString("FVoucherPeriod"));
        row.put("FVoucherNumber", rowSet.getString("FVoucherNumber"));
        row.put("FVoucherAmount", rowSet.getBigDecimal("FVoucherAmount"));
        row.put("FDiffAmount", rowSet.getBigDecimal("FDiffAmount"));
        row.put("FDiffType", rowSet.getString("FDiffType"));
        row.put("FIsSum", rowSet.getInt("FIsSum"));
        return row;
    }
}

