/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArapRptServiceImpl {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.web.ArapRptServiceImpl");
    private Context ctx;

    public ArapRptServiceImpl(Context context) {
        this.ctx = context;
    }

    public Context getContext() {
        return this.ctx;
    }

    public Map<String, Object> query(Map<String, Object> condition) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("queryId", "T_GL_Voucher");
        return result;
    }

    public Map<String, Object> getData(Map<String, Object> condition) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("page", 0);
        map.put("total", 0);
        map.put("records", 0);
        map.put("rows", new ArrayList());
        try {
            int records = this.getRecords(condition);
            if (records <= 0) {
                return map;
            }
            String strPage = (String)condition.get("page");
            String strRows = (String)condition.get("rows");
            int page = Integer.parseInt(strPage);
            int rows = Integer.parseInt(strRows);
            int total = records / rows;
            if (total * rows < records) {
                ++total;
            }
            int from = (page - 1) * rows;
            IRowSet rowSet = this.executeQuery(condition, from, rows);
            ArrayList<Map<String, Object>> datas = new ArrayList<Map<String, Object>>(rowSet.size());
            while (rowSet.next()) {
                Map<String, Object> row = this.wrapRow(condition, rowSet);
                if (row == null) continue;
                datas.add(row);
            }
            map.put("page", page);
            map.put("total", total);
            map.put("records", records);
            map.put("rows", datas);
            return map;
        }
        catch (SQLException e) {
            throw new BOSException();
        }
    }

    protected int getRecords(Map<String, Object> condition) throws EASBizException, BOSException, SQLException {
        String strRecords = (String)condition.get("records");
        if (strRecords != null && strRecords.length() > 0) {
            return Integer.parseInt(strRecords);
        }
        String queryId = (String)condition.get("queryId");
        if (queryId == null || queryId.length() == 0) {
            return 0;
        }
        String sql = "select count(*) from " + queryId;
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql);
        if (rs.next()) {
            return rs.getInt(1);
        }
        return 0;
    }

    protected IRowSet executeQuery(Map<String, Object> condition, int from, int rows) throws EASBizException, BOSException {
        String queryId = (String)condition.get("queryId");
        String sql = "select * from " + queryId + " order by FNumber";
        return DbUtil.executeQuery((Context)this.getContext(), (String)sql, (int)from, (int)rows);
    }

    protected Map<String, Object> wrapRow(Map<String, Object> condition, IRowSet rowSet) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>();
        row.put("FID", rowSet.getString("FID"));
        row.put("FBillType", "voucher");
        row.put("FNumber", rowSet.getString("FNumber"));
        row.put("FBillDate", rowSet.getDate("FBizDate"));
        row.put("FAmount", 0);
        row.put("FVoucherPeriod", "201312");
        row.put("FVoucherNumber", "[haha]" + rowSet.getString("FNumber"));
        row.put("FVoucherAmount", 0);
        row.put("FDiffAmount", 0);
        row.put("FDiffType", "kan kan ba");
        return row;
    }

    public void release(Map<String, Object> condition) throws BOSException, EASBizException {
        if (condition == null) {
            return;
        }
        String queryId = (String)condition.get("queryId");
        if (queryId == null || queryId.length() == 0) {
            return;
        }
        ArrayList<String> otherTempTables = (ArrayList<String>)condition.get("otherTempTables");
        if (null == otherTempTables) {
            otherTempTables = new ArrayList<String>();
        }
        otherTempTables.add(queryId);
        TempTablePool pool = TempTablePool.getInstance((Context)this.getContext());
        for (int i = 0; i < otherTempTables.size(); ++i) {
            pool.releaseTable((String)otherTempTables.get(i));
        }
    }

    public PeriodInfo getPeriodInfo(String companyId, int period) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
        companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        int PeriodYear = period / 100;
        int PeriodNumber = period % 100;
        PeriodTypeInfo periodType = companyInfo.getAccountPeriodType();
        return PeriodFactory.getLocalInstance((Context)this.getContext()).getPeriodInfo(PeriodYear, PeriodNumber, periodType);
    }
}

