/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.bos.workflow.exception.AlreadyInProcessQueueException;
import com.kingdee.bos.workflow.exception.MatchAssignmentException;
import com.kingdee.bos.workflow.exception.MissMatchParticipantException;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.framework.DataBaseDInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.BaseException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class BatchService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.impl.BillBaseService");
    private Context ctx;

    public BatchService(Context context) {
        this.ctx = context;
    }

    private Context getContext() {
        return this.ctx;
    }

    public Class[] getParameterTypes() {
        return new Class[]{IObjectPK.class};
    }

    public BatchExecuteParamsEntry[] getParameters(List<String> idList) {
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        Class[] paramTypes = this.getParameterTypes();
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            entry.add((Object)new ObjectUuidPK(idList.get(i)));
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    public Object getId(BatchExecuteParamsEntry paramEntry) {
        return paramEntry.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> batchOperation(String bosType, String methodName, String[] billIDs) throws EASBizException, BOSException {
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)BOSObjectType.create((String)bosType));
        ArrayList<String> idList = new ArrayList<String>(billIDs.length);
        for (int i = 0; i < billIDs.length; ++i) {
            idList.add(billIDs[i]);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> lockedList = null;
        try {
            lockedList = this.requestLocks(this.getContext(), idList, result);
            BatchExecuteParamsEntry[] params = this.getParameters(lockedList);
            BatchExecuteResult exeResult = null;
            if (lockedList.size() > 0) {
                try {
                    ServiceStateManager.getInstance().enableNextCallServices();
                    exeResult = bizCtrl.batchExecute(methodName, this.getParameterTypes(), params);
                }
                catch (BaseException e) {
                    logger.error((Object)e);
                    if (e instanceof BOSException) {
                        throw (BOSException)((Object)e);
                    }
                    if (e instanceof EASBizException) {
                        throw (EASBizException)((Object)e);
                    }
                    throw new BOSException(e.getMessage());
                }
            }
            if (exeResult != null && exeResult.getBatchResult() == null) {
                Throwable[] exps = exeResult.getExceptions();
                int errorCount = result.size();
                for (int i = 0; i < exps.length; ++i) {
                    if (exps[i] == null) continue;
                    ++errorCount;
                    if (exps[i] instanceof MissMatchParticipantException) {
                        result.put(this.getId(params[i]).toString(), ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_MissMatchParticipant", (Locale)this.getContext().getLocale()));
                        continue;
                    }
                    if (exps[i] instanceof MatchAssignmentException) {
                        result.put(this.getId(params[i]).toString(), ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_WFMatch", (Locale)this.getContext().getLocale()));
                        continue;
                    }
                    if (exps[i] instanceof AlreadyInProcessQueueException) {
                        result.put(this.getId(params[i]).toString(), ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource", (String)"Msg_AlreadyInProcessQueue", (Locale)this.getContext().getLocale()));
                        continue;
                    }
                    result.put(this.getId(params[i]).toString(), exps[i].getMessage());
                }
                result.put("ERROR_COUNT", String.valueOf(errorCount));
            } else if (exeResult != null) {
                int errorCount = result.size();
                BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
                for (int i = 0; i < params.length; ++i) {
                    Object id = this.getId(params[i]);
                    ActionResult actionResult = actionResults.getActionResult(id);
                    if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                    result.put(id.toString(), actionResult.getMessage());
                    ++errorCount;
                }
                result.put("ERROR_COUNT", String.valueOf(errorCount));
            } else if (result.size() > 0) {
                result.put("ERROR_COUNT", result.size());
            }
        }
        finally {
            this.releaseLocks(this.getContext(), lockedList);
        }
        return result;
    }

    protected List<String> requestLocks(Context ctx, List<String> toLockList, Map<String, Object> result) throws BOSException {
        Map lockMap = MutexServiceControlFactory.getLocalInstance((Context)ctx).batchRequestObjIDForUpdate(toLockList);
        ArrayList<String> lockedList = new ArrayList<String>(toLockList.size());
        if (lockMap != null) {
            for (int i = 0; i < toLockList.size(); ++i) {
                String id = toLockList.get(i);
                if (lockMap.containsKey(id) && ((Boolean)lockMap.get(id)).booleanValue()) {
                    lockedList.add(id);
                    continue;
                }
                result.put(id, ResourceBase.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"DataMutex", (Locale)this.getContext().getLocale()));
            }
        }
        return lockedList;
    }

    protected void releaseLocks(Context ctx, List<String> lockList) throws BOSException {
        if (lockList != null && lockList.size() > 0) {
            MutexServiceControlFactory.getLocalInstance((Context)ctx).batchReleaseObjIDForUpdate(lockList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> batchTransfer(Map params, String billIDs) throws EASBizException, BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String bosType = params.get("bosType").toString();
        map.put("createToFlag", "1");
        map.put("createToFlag", new Integer(1));
        map.put("bizType", BOSObjectType.create((String)bosType));
        map.put("transSelectors", BaseService.getBillSelectors());
        map.put("currentUser", ContextUtil.getCurrentUserInfo((Context)this.getContext()));
        AsstActTypeInfo asstActTypeInfo = new AsstActTypeInfo();
        asstActTypeInfo.setId(BOSUuid.read((String)((Map)params.get("asstActType")).get("id").toString()));
        map.put("selectComAsstActType", asstActTypeInfo);
        Map asstActMap = (Map)params.get("asstAct");
        Object asstActInfo = null;
        asstActInfo = "YW3xsAEJEADgAAUWwKgTB0c4VZA=".equals(asstActTypeInfo.getId().toString()) ? new CustomerInfo() : new DataBaseDInfo();
        asstActInfo.setId(BOSUuid.read((String)asstActMap.get("id").toString()));
        String asstActNameStr = asstActMap.get("name").toString();
        String localeStr = this.ctx.getLocale().toString();
        int fromIndex = asstActNameStr.indexOf("=", asstActNameStr.indexOf(localeStr)) + 1;
        String actualName = asstActNameStr.substring(fromIndex, asstActNameStr.indexOf(",", fromIndex));
        asstActInfo.setName(actualName);
        asstActInfo.setNumber(asstActMap.get("number").toString());
        map.put("selectAccountCussent", asstActInfo);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            map.put("selectBillDate", df.parse(params.get("billDate").toString()));
            map.put("selectBizDate", params.get("bizDate") != null && !"".equals(params.get("bizDate")) ? df.parse(params.get("bizDate").toString()) : null);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        String[] ids = billIDs.split(",");
        ArrayList<String> idList = new ArrayList<String>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idList.add(ids[i]);
        }
        IArApBillBase iBillBase = null;
        iBillBase = "48DA3A71".equals(bosType) ? com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(this.getContext()) : OtherBillFactory.getLocalInstance(this.getContext());
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<String> lockedList = null;
        try {
            lockedList = this.requestLocks(this.getContext(), idList, result);
            int errorCount = result.size();
            ServiceStateManager.getInstance().enableNextCallServices();
            int size = lockedList.size();
            for (int i = 0; i < size; ++i) {
                try {
                    CoreBaseInfo info = iBillBase.getValue("select company.id,company.CU.id where id = '" + lockedList.get(i) + "'");
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)info.get("company");
                    map.put("company", company);
                    map.put("cuId", company.getCU().getId().toString());
                    iBillBase.batchDebitCreditTransfer(new IObjectPK[]{new ObjectUuidPK(BOSUuid.read((String)lockedList.get(i)))}, map);
                    continue;
                }
                catch (BaseException e) {
                    logger.error((Object)e);
                    if (e instanceof BOSException) {
                        throw (BOSException)((Object)e);
                    }
                    if (e instanceof EASBizException) {
                        result.put(lockedList.get(i), e.getMessage());
                        ++errorCount;
                        continue;
                    }
                    throw new BOSException(e.getMessage());
                }
            }
            int billCount = idList.size();
            if (errorCount > 0) {
                String summaryMsg = this.getResourceStr(this.ctx, "summaryMsg", new Object[]{String.valueOf(billCount), "", String.valueOf(billCount - errorCount), String.valueOf(errorCount)});
                result.put("summaryMsg", summaryMsg);
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        }
        finally {
            this.releaseLocks(this.getContext(), lockedList);
        }
        return result;
    }

    private String getResourceStr(Context ctx, String key) {
        return EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapAllResource", (String)key, (Locale)ctx.getOriginLocale());
    }

    private String getResourceStr(Context ctx, String key, Object[] params) {
        String s = this.getResourceStr(ctx, key);
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(params);
        return result;
    }
}

