/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.app.web.CodeRuleHelper;
import com.kingdee.eas.fi.arap.app.web.IBillCreateService;
import com.kingdee.eas.fi.cas.CasWebException;
import com.kingdee.eas.fi.cas.basedata.CasUtilFacadeFactory;
import com.kingdee.eas.fi.cas.basedata.ICasUtilFacade;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.Map;

public abstract class BillCreateService
implements IBillCreateService {
    private Context ctx;

    public BillCreateService(Context context) {
        this.ctx = context;
    }

    public Context getContext() {
        return this.ctx;
    }

    @Override
    public CoreBillBaseInfo createBill(String mainOrgId, Map otherInformation) throws EASBizException, BOSException {
        CompanyOrgUnitInfo mainOrg = null;
        ICasUtilFacade casUtil = CasUtilFacadeFactory.getLocalInstance((Context)this.ctx);
        ObjectUuidPK companypk = null;
        if (mainOrgId != null) {
            companypk = new ObjectUuidPK(mainOrgId);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            mainOrg = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)companypk, sic);
        }
        CompanyOrgUnitCollection orgUnitCollection = casUtil.getAuthrizedCompanyOrg(this.ctx.getCaller().toString(), this.getPermissionItem(), false);
        CompanyOrgUnitInfo company = null;
        if (mainOrgId == null) {
            CompanyOrgUnitInfo defaultOrgUnit = ContextUtil.getCurrentFIUnit((Context)this.ctx);
            if (defaultOrgUnit.isIsBizUnit()) {
                boolean havePower = false;
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).getId().toString().equals(defaultOrgUnit.getId().toString())) continue;
                    havePower = true;
                    break;
                }
                if (havePower) {
                    company = defaultOrgUnit;
                } else if (orgUnitCollection.size() > 0) {
                    company = orgUnitCollection.get(0);
                }
            } else {
                for (int i = 0; i < orgUnitCollection.size(); ++i) {
                    if (!orgUnitCollection.get(i).isIsBizUnit()) continue;
                    company = orgUnitCollection.get(i);
                    break;
                }
            }
        } else {
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                if (!orgUnitCollection.get(i).getId().toString().equals(mainOrgId) || !orgUnitCollection.get(i).isIsBizUnit()) continue;
                company = orgUnitCollection.get(i);
                break;
            }
        }
        if (company == null) {
            throw new CasWebException(CasWebException.NO_ORG_AUTHRIZED);
        }
        CoreBillBaseInfo info = this.createDefaultBill((OrgUnitInfo)company, otherInformation);
        CodeRuleHelper codeHelper = new CodeRuleHelper();
        codeHelper.genNewBillNumber(this.getContext(), (IObjectValue)info, (OrgUnitInfo)company);
        return info;
    }

    public abstract int getOrgType();

    public abstract String getPermissionItem();

    public abstract CoreBillBaseInfo createDefaultBill(OrgUnitInfo var1, Map var2) throws EASBizException, BOSException;

    @Override
    public CoreBillEntryBaseInfo createBillEntry(String companyid, Map otherInformation) throws EASBizException, BOSException {
        return null;
    }

    public AsstActTypeInfo getAsstActType(CompanyOrgUnitInfo cachedCompany, SystemEnum defaultSysEnum) throws BOSException {
        if (cachedCompany == null) {
            throw new IllegalAccessError();
        }
        AsstActTypeInfo defaulteAsstActType = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)cachedCompany.getId());
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("*");
        ev.getSelector().add("asstActType.*");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = AsstActTypeDefaultFactory.getLocalInstance((Context)this.getContext()).getAsstActTypeDefaultCollection(ev);
        AsstActTypeDefaultInfo value = null;
        int size = asstActTypeColl.size();
        for (int i = 0; i < size; ++i) {
            value = asstActTypeColl.get(i);
            if (SystemEnum.ACCOUNTSPAYABLE.equals((Object)defaultSysEnum) && value.isIsDefaultAccountPayable()) {
                defaulteAsstActType = value.getAsstActType();
                continue;
            }
            if (!SystemEnum.ACCOUNTSRECEIVABLE.equals((Object)defaultSysEnum) || !value.isIsDefaultAccountReceivable()) continue;
            defaulteAsstActType = value.getAsstActType();
        }
        if (defaulteAsstActType == null && asstActTypeColl.size() > 0) {
            defaulteAsstActType = asstActTypeColl.get(0).getAsstActType();
        }
        return defaulteAsstActType;
    }
}

