/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;

public class CodeRuleHelper {
    private ICoreBase bizCtrl;
    private IObjectValue model;
    private OrgUnitInfo mainOrgInfo;
    private RuleStatus ruleStatus;
    private ICodingRuleManager codingRuleManager;
    private String bizOrgPropertyName;
    private EASBizException numberException = null;

    public void genNewBillNumber(Context ctx, IObjectValue model, OrgUnitInfo mainOrgInfo) throws EASBizException, BOSException {
        this.model = model;
        this.mainOrgInfo = mainOrgInfo;
        this.getRule(ctx);
        if (this.isAutoNum() && this.ruleStatus.isAddView() && (model.getString("number") == null || model.getString("number").equals(""))) {
            this.setBillNewNumber(ctx, true);
        }
    }

    public void checkNumber(Context ctx, ICoreBase bizCtrl, IObjectValue model, OrgUnitInfo mainOrgInfo) throws EASBizException, BOSException {
        this.bizCtrl = bizCtrl;
        this.model = model;
        this.mainOrgInfo = mainOrgInfo;
        this.getRule(ctx);
        if (this.isAutoNum() && (model.getString("number") == null || model.getString("number").equals(""))) {
            boolean isAddNew = model.get("id") == null || model.getString("id").trim().length() == 0 || !bizCtrl.exists((IObjectPK)new ObjectUuidPK(model.getString("id")));
            this.setBillNewNumber(ctx, isAddNew);
        }
        this.checkNumberBlank();
        this.checkNumberDup();
    }

    public boolean rollBackNumber(Context ctx, IObjectValue model, OrgUnitInfo mainOrgInfo) throws EASBizException, BOSException {
        this.model = model;
        this.mainOrgInfo = mainOrgInfo;
        this.getRule(ctx);
        if (this.isAutoNum()) {
            ICodingRuleManager codingRuleManager = this.getCodingRuleManager(ctx);
            String mainOrgId = mainOrgInfo.getId().toString();
            String strBindProp = this.getBindingProperty();
            if (strBindProp != null && strBindProp.trim().length() > 0) {
                if (codingRuleManager.isExist(model, mainOrgId, strBindProp) && codingRuleManager.isUseIntermitNumber(model, mainOrgId, strBindProp)) {
                    return codingRuleManager.recycleNumber(model, mainOrgId, strBindProp, "", model.getString("number"));
                }
            } else if (codingRuleManager.isExist(model, mainOrgId) && codingRuleManager.isUseIntermitNumber(model, mainOrgId)) {
                return codingRuleManager.recycleNumber(model, mainOrgId, model.getString("number"));
            }
        }
        return false;
    }

    private void setBillNewNumber(Context ctx, boolean isAddNew) throws EASBizException, BOSException {
        if (isAddNew) {
            if (this.ruleStatus.isExist()) {
                this.model.setString("number", this.getNewNumber(ctx));
            } else if (this.model.get("id") != null) {
                this.model.setString("number", this.getNewNumber(ctx));
            }
        }
    }

    private String getNewNumber(Context ctx) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = this.getCodingRuleManager(ctx);
        String number = "";
        String strBindProp = this.getBindingProperty();
        number = strBindProp != null && strBindProp.trim().length() > 0 ? codingRuleManager.getNumber(this.model, this.mainOrgInfo.getId().toString(), strBindProp) : codingRuleManager.getNumber(this.model, this.mainOrgInfo.getId().toString());
        return number;
    }

    private void getRule(Context ctx) throws EASBizException, BOSException {
        ICodingRuleManager codingRuleManager = this.getCodingRuleManager(ctx);
        this.ruleStatus = this.getBindingProperty() != null && this.getBindingProperty().length() > 0 ? codingRuleManager.getRuleStatus(this.model, this.mainOrgInfo.getId().toString(), this.getBindingProperty()) : codingRuleManager.getRuleStatus(this.model, this.mainOrgInfo.getId().toString());
    }

    private ICodingRuleManager getCodingRuleManager(Context ctx) throws BOSException {
        if (this.codingRuleManager == null) {
            this.codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        }
        return this.codingRuleManager;
    }

    private void checkNumberBlank() throws EASBizException, BOSException {
        String number;
        if (this.numberException == null) {
            this.numberException = new EASBizException(EASBizException.CHECKNUMBLANK, new Object[]{"number"});
        }
        if (this.isAutoNum() ? (number = this.model.getString("number")) == null || number.trim().equals("") : (number = this.model.getString("number")) == null || number.trim().equals("")) {
            throw this.numberException;
        }
    }

    private boolean isAutoNum() {
        return this.ruleStatus.isExist();
    }

    private boolean checkNumberDup() throws EASBizException, BOSException {
        if (this.isSameNumber()) {
            throw new EASBizException(EASBizException.CHECKNUMDUP, new Object[]{this.model.getString("number"), ""});
        }
        return true;
    }

    private boolean isSameNumber() throws EASBizException, BOSException {
        String bizProName;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)this.model.getString("number"), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (this.model.get("id") != null) {
            filterItem = new FilterItemInfo("id", (Object)this.model.getString("id"), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.model.get("CU") != null) {
            filterItem = new FilterItemInfo("CU", (Object)((CtrlUnitInfo)this.model.get("CU")).getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if ((bizProName = this.bizOrgPropertyName) == null) {
            bizProName = "storageOrgUnit";
        }
        if (this.mainOrgInfo != null && this.model.get(bizProName) != null) {
            filterItem = new FilterItemInfo(bizProName, (Object)this.mainOrgInfo.getId().toString(), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        if (this.getBindingProperty() != null && this.getBindingProperty().trim().length() > 0 && this.model.get(this.getBindingProperty()) != null) {
            filterItem = new FilterItemInfo(this.getBindingProperty(), this.getBindingPropertyValue(this.model), CompareType.EQUALS);
            filter.getFilterItems().add(filterItem);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filter.getFilterItems().size(); ++i) {
            if (i != 0) {
                sb.append(" and #" + i);
                continue;
            }
            sb.append("#" + i);
        }
        filter.setMaskString(sb.toString());
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        return this.bizCtrl.exists(filter);
    }

    private String getBindingProperty() {
        return null;
    }

    protected Object getBindingPropertyValue(IObjectValue model) {
        return null;
    }

    public EASBizException getNumberException() {
        return this.numberException;
    }

    public void setNumberException(EASBizException numberException) {
        this.numberException = numberException;
    }

    public String getBizOrgPropertyName() {
        return this.bizOrgPropertyName;
    }

    public void setBizOrgPropertyName(String bizOrgPropertyName) {
        this.bizOrgPropertyName = bizOrgPropertyName;
    }
}

