/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.web;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.KSqlUtil;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ContrastGLQueryParam;
import com.kingdee.eas.fi.ar.app.util.CommonServerUtils;
import com.kingdee.eas.fi.ar.app.web.ArWriteOffCommonService;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.ArApVerifyCommonFacadeFactory;
import com.kingdee.eas.fi.arap.ArapWebQueryPanelCollection;
import com.kingdee.eas.fi.arap.ArapWebQueryPanelInfo;
import com.kingdee.eas.fi.arap.ArapWebQuerySolutionCollection;
import com.kingdee.eas.fi.arap.ArapWebQuerySolutionFactory;
import com.kingdee.eas.fi.arap.ArapWebQuerySolutionInfo;
import com.kingdee.eas.fi.arap.IArapWebQuerySolution;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionEntryCollection;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionEntryInfo;
import com.kingdee.eas.fi.arap.VerificationMappingSolutionFactory;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.util.LockResult;
import com.kingdee.eas.fi.arap.app.web.BaseService;
import com.kingdee.eas.fi.arap.util.ArApStringUtil;
import com.kingdee.eas.fi.arap.util.ArApVerificationConstant;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.framework.writeoff.IMappingConditionEntry;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryCollection;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryFactory;
import com.kingdee.eas.scm.framework.writeoff.MappingConditionEntryInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonInfo;
import com.kingdee.eas.scm.framework.writeoff.WriteOffCommonParams;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class WriteOffCommonService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.web.WriteOffCommonService");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map autoWriteOff(Context ctx, Set companySet, List rows, String bizDate, String unVerificatTable, List allDatas) throws BOSException, EASBizException {
        this.deleteData(ctx, unVerificatTable);
        String verificationType = null;
        String rowid = null;
        Map rowMap = null;
        ArrayList<String> verificationTypeList = new ArrayList<String>();
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            rowMap = (Map)rows.get(i);
            verificationType = rowMap.get("verificationtype").toString();
            verificationTypeList.add(verificationType);
        }
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        EntityViewInfo viewInfo = WriteOffCommonService.getQuerySolutionViewInfo(null, this.getClassName(verificationTypeList), companySet, userID);
        IArapWebQuerySolution iSolution = ArapWebQuerySolutionFactory.getLocalInstance(ctx);
        ArapWebQuerySolutionCollection defaultSolutionMap = iSolution.getArapWebQuerySolutionCollection(viewInfo);
        VerificationMappingSolutionEntryCollection mappingConfig = VerificationMappingSolutionFactory.getLocalInstance(ctx).querySolution4Schedule(this instanceof ArWriteOffCommonService, companySet);
        HashMap<String, VerificationMappingSolutionEntryInfo> mappingConditionMap = new HashMap<String, VerificationMappingSolutionEntryInfo>();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < mappingConfig.size(); ++i) {
            VerificationMappingSolutionEntryInfo entryInfo = mappingConfig.get(i);
            ids.add(entryInfo.getParent().getId().toString());
            if (entryInfo.getParent().getCompany() == null || entryInfo.getVerificationMethod() == null) continue;
            mappingConditionMap.put(entryInfo.getParent().getCompany().getId().toString() + entryInfo.getVerificationMethod().getValue(), entryInfo);
        }
        LockResult lockResult = ArApServerUtils.requestLocks(ctx, ids);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            Map map = this.getVerificationClassNameMAP();
            HashMap<String, Integer> billcountMap = new HashMap<String, Integer>();
            String verificationID = BOSUuid.create((String)"12345678").toString();
            int billCount = 0;
            int totalbillCount = 0;
            int size2 = rows.size();
            for (int i = 0; i < size2; ++i) {
                totalbillCount = 0;
                rowMap = (Map)rows.get(i);
                verificationType = rowMap.get("verificationtype").toString();
                rowid = rowMap.get("rowid").toString();
                String classname = map.get(verificationType).toString();
                int comsize = companySet.size();
                for (int j = 0; j < comsize; ++j) {
                    List result;
                    billCount = 0;
                    WriteOffCommonParams wfParams = this.getParams(verificationType);
                    String companyid = companySet.toArray()[j].toString();
                    wfParams = this.getWriteOffCommonParams(ctx, companyid, verificationType, wfParams, unVerificatTable, defaultSolutionMap);
                    String mappingConditionEntryId = null;
                    if (rowMap.containsKey("mappingCondition") && rowMap.get("mappingCondition") != null) {
                        mappingConditionEntryId = (String)rowMap.get("mappingCondition");
                    } else {
                        String key = companyid + verificationType;
                        if (!mappingConditionMap.containsKey(key)) continue;
                        VerificationMappingSolutionEntryInfo entryInfo = (VerificationMappingSolutionEntryInfo)mappingConditionMap.get(companyid + verificationType);
                        if (entryInfo.getMappingCondition().getMappingCondition() == null) {
                            throw new ARAPVerifynException(ARAPVerifynException.MAPPING_SOLUTION_NOT_EXISTS, new Object[]{entryInfo.getParent().getCompany().getName(), entryInfo.getVerificationMethod().getAlias()});
                        }
                        mappingConditionEntryId = entryInfo.getMappingCondition().getId().toString();
                    }
                    if (!org.apache.commons.lang.StringUtils.isEmpty((String)mappingConditionEntryId)) {
                        wfParams.setMappingEntryId(mappingConditionEntryId);
                    }
                    if ((result = ArApVerifyCommonFacadeFactory.getLocalInstance(ctx).writeOff(wfParams)) != null) {
                        this.insertResultData(ctx, result, companyid, verificationType, verificationID);
                        billCount = result.size();
                    }
                    totalbillCount += billCount;
                    this.updateUnWriteOff(ctx, rowid, verificationType, billCount, verificationID, unVerificatTable, companyid);
                }
                billcountMap.put(rowid, totalbillCount);
            }
            resultMap.put("verificationID", verificationID);
            resultMap.put("billCount", billcountMap);
            List billcounList = this.queryafterWriteOff(ctx, companySet, bizDate, unVerificatTable, rows, billcountMap);
            resultMap.put("unbillCount", billcounList);
        }
        finally {
            ArApServerUtils.releaseLocks(ctx, lockResult);
        }
        return resultMap;
    }

    private void updateUnWriteOff(Context ctx, String rowid, String verificationType, int billCount, String verificationID, String unVerificatTable, String companyid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_arap_unVerification set  frowid = '").append(rowid).append("',");
        sql.append(" fbillCount = ").append(billCount).append(",");
        sql.append(" fverificationID = '").append(verificationID).append("',");
        sql.append(" Fisfinish = 1 ");
        sql.append(" where funVerificatTable='").append(unVerificatTable).append("'");
        sql.append("and FverificationType ='").append(verificationType).append("'");
        sql.append("and forgid ='").append(companyid).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void deleteData(Context ctx, String unVerificatTable) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -3);
        Date date = calendar.getTime();
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from T_arap_autoVerification");
        sql.append(" where fbilldate < to_date('").append(sdf.format(date)).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from T_arap_unVerificationbill ");
        sql.append(" where fbilldate < to_date('").append(sdf.format(date)).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from T_arap_unVerification ");
        sql.append(" where fbilldate < to_date('").append(sdf.format(date)).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update  T_arap_unVerification set Fbillcount =0 ,Fisfinish = 0  ");
        sql.append(" where funVerificatTable=' ").append(unVerificatTable).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public Map queryAutoWriteOff(Context ctx, Set companySet, List rows, String unVerificatTable) throws BOSException {
        HashMap resultMap = new HashMap();
        StringBuffer rowidsql = new StringBuffer();
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            Map rowMap = (Map)rows.get(i);
            if (i == size - 1) {
                rowidsql.append(" '").append(rowMap.get("rowid")).append("'");
                continue;
            }
            rowidsql.append(" '").append(rowMap.get("rowid")).append("',");
        }
        if (rowidsql.length() < 1) {
            return resultMap;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(fbillcount) as fbillcount ,count(forgid) as forgcount,frowid,fverificationID ");
        sql.append(" from T_arap_unVerification ");
        sql.append(" where FunVerificatTable = '").append(unVerificatTable).append("'");
        sql.append(" and Fisfinish = 1 and frowid in (").append(rowidsql.toString()).append(")");
        sql.append(" group by frowid,fverificationID");
        sql.append(" order by frowid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        int totalcompanysize = companySet.size();
        int companysize = 0;
        boolean pdValue = false;
        ArrayList gridData = new ArrayList();
        try {
            while (rs.next()) {
                companysize = rs.getInt("forgcount");
                if (companysize == 0) continue;
                HashMap<String, Object> row = new HashMap<String, Object>();
                if (companysize == totalcompanysize) {
                    row.put("billcount", rs.getInt("fbillcount"));
                    row.put("verificationID", rs.getString("fverificationID"));
                } else {
                    row.put("pdValue", new BigDecimal(companysize).divide(new BigDecimal(totalcompanysize), 2, RoundingMode.HALF_UP).multiply(new BigDecimal("100")));
                    row.put("billcount", rs.getInt("fbillcount"));
                }
                row.put("rowid", rs.getString("frowid"));
                gridData.add(row);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        resultMap.put("gridData", gridData);
        return resultMap;
    }

    private String getOrgUnitInfo(Context ctx) throws EASBizException, BOSException {
        BaseService bs = new BaseService(ctx);
        OrgUnitInfo mainOrg = null;
        OrgUnitInfo[] orgs = bs.getAuthorizedBizOrgUnits(1, this.getPermissionItem());
        if (orgs == null || orgs.length == 0) {
            PermItemInfo permItemInfo = PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfoByNumber(this.getPermissionItem());
            throw new PermissionException(PermissionException.HAS_NOT_FUNCTION_PERMISSION, new Object[]{permItemInfo.getAlias()});
        }
        if (mainOrg == null) {
            mainOrg = orgs[0];
            OrgUnitInfo orgInfo = (OrgUnitInfo)ctx.get((Object)OrgType.getEnum((int)1));
            for (int i = 0; i < orgs.length; ++i) {
                if (!orgs[i].getId().equals((Object)orgInfo.getId())) continue;
                mainOrg = orgs[i];
                break;
            }
        }
        return mainOrg.getId().toString();
    }

    private void insertResultData(Context ctx, List result, String orgid, String verificationType, String verificationID) throws BOSException {
        if (result == null || result.size() <= 0) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_arap_autoVerification ");
        sql.append(" (fid,FbillID,forgid,fverificationType,FverificationID,fbilldate )");
        sql.append(" values ( ?,?,?,?,? ,now())");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            int size = result.size();
            for (int i = 0; i < size; ++i) {
                ps.setString(1, BOSUuid.create((String)"12345678").toString());
                ps.setString(2, result.get(i).toString());
                ps.setString(3, orgid);
                ps.setString(4, verificationType);
                ps.setString(5, verificationID);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : ", (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    public Map query(Context ctx, Set companySet, String dateFilterItems, String unVerificatTable) throws BOSException, EASBizException {
        if (companySet == null || companySet.size() == 0) {
            companySet = new HashSet<String>();
            companySet.add(this.getOrgUnitInfo(ctx));
        }
        List verificationTypeList = this.getVerificationTypeList();
        Map defaultSolutionMap = this.getDefaultSolution(ctx, companySet, this.getClassName(verificationTypeList), dateFilterItems);
        Map map = this.getVerificationClassNameMAP();
        Map nameMap = this.getVerificationNameMAP();
        Map mainuipkMap = this.getMainBillUIPKMAP();
        Map secuipkMap = this.getSecBillUIPKMAP();
        boolean mainBillCount = false;
        boolean secBillCount = false;
        ArrayList<Map<String, BOSUuid>> gridList = new ArrayList<Map<String, BOSUuid>>();
        if (unVerificatTable == null || unVerificatTable.length() < 5 || !BOSUuid.isValid((String)unVerificatTable, (boolean)true)) {
            unVerificatTable = BOSUuid.create((String)"12345678").toString();
        } else {
            String deletesql = "delete from T_arap_unVerification where FunVerificatTable= '" + unVerificatTable + "'";
            String deletesql2 = "delete from T_arap_unVerificationbill where FunVerificatTable= '" + unVerificatTable + "'";
            DbUtil.execute((Context)ctx, (String)deletesql);
            DbUtil.execute((Context)ctx, (String)deletesql2);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_arap_unVerification ");
        sql.append(" (fid,FunVerificatTable,forgid,fverificationType,Fbilldate )");
        sql.append(" values ( ?,?,?,?,now())");
        StringBuffer insertSql = new StringBuffer();
        StringBuffer sql2 = new StringBuffer();
        insertSql.append(" insert into T_arap_unVerificationbill ");
        insertSql.append(" (fid,fbilldate ,FunVerificatTable,forgid,fverificationType,ftype,Fbillid,Fentryid)");
        sql2.append(" (select  newbosid('12345678') as fid,  now() as fbilldate ,'");
        sql2.append(unVerificatTable).append("' as FunVerificatTable , ");
        String manualIdCondition = ArApStringUtil.convertIdsStr2SqlCondition(org.apache.commons.lang.StringUtils.join((Object[])ArApConstants.MANUAL_ID_LIST.toArray(), (String)","));
        IMappingConditionEntry iMappingConditionEntry = MappingConditionEntryFactory.getLocalInstance((Context)ctx);
        HashMap<String, MappingConditionEntryCollection> mappingConditionEntryMap = new HashMap<String, MappingConditionEntryCollection>();
        for (Object type : verificationTypeList) {
            String mappingConditionId = (String)ArApVerificationConstant.MappingCondition_MAP.get(type);
            MappingConditionEntryCollection coll = iMappingConditionEntry.getMappingConditionEntryCollection("select * where mappingCondition = '" + mappingConditionId + "'and id not in (" + manualIdCondition + ")  order by seq");
            mappingConditionEntryMap.put(mappingConditionId, coll);
        }
        HashMap<String, String> mappingConditionMap = new HashMap<String, String>();
        if (companySet.size() == 1) {
            VerificationMappingSolutionEntryCollection collection = VerificationMappingSolutionFactory.getLocalInstance(ctx).queryVerificationMappingSolution(this instanceof ArWriteOffCommonService, companySet, null);
            for (int i = 0; i < collection.size(); ++i) {
                VerificationMappingSolutionEntryInfo entryInfo = collection.get(i);
                mappingConditionMap.put(entryInfo.getVerificationMethod().getValue(), entryInfo.getMappingCondition().getId().toString());
            }
        }
        StringBuffer select = new StringBuffer();
        Connection conn = null;
        PreparedStatement ps = null;
        logger.error((Object)("deng_xu---------start: " + new Date(System.currentTimeMillis())));
        try {
            Map<String, BOSUuid> row;
            String verificationType;
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            int size = verificationTypeList.size();
            for (int i = 0; i < size; ++i) {
                String configMappingCondition;
                verificationType = verificationTypeList.get(i).toString();
                mainBillCount = false;
                secBillCount = false;
                row = new HashMap<String, String>();
                row.put("verificationtype", (BOSUuid)verificationType);
                row.put("name", (BOSUuid)ArApVerificationConstant.getResourceStr(ctx, nameMap.get(verificationType).toString()));
                String classname = map.get(verificationType).toString();
                Arrays.asList((Object[])companySet.toArray());
                Object[] arr = companySet.toArray();
                Arrays.sort((Object[])arr);
                String key = org.apache.commons.lang.StringUtils.join((Object[])arr, (String)",");
                Map defaultSolution = (Map)defaultSolutionMap.get(key + classname);
                Map params = this.getQueryParams(ctx, defaultSolution, companySet, verificationType, dateFilterItems);
                IQueryExecutor mainExecutor = this.getQueryExecutor(ctx, params.get("mainQuery").toString(), (FilterInfo)params.get("mainFilter"), unVerificatTable, "main");
                IQueryExecutor secExecutor = this.getQueryExecutor(ctx, params.get("secQuery").toString(), (FilterInfo)params.get("secFilter"), unVerificatTable, "sec");
                String mainsql = mainExecutor.getSQL();
                select.setLength(0);
                select.append(" COMPANY.FID as forgid,");
                select.append(" '").append(verificationType).append("' as fverificationType,'");
                mainsql = insertSql.toString() + KSqlUtil.optimize((String)(sql2.toString() + select.toString() + "main' as ftype," + mainsql.substring(7) + ")"));
                String secsql = secExecutor.getSQL();
                secsql = insertSql.toString() + KSqlUtil.optimize((String)(sql2.toString() + select.toString() + "sec' as ftype," + secsql.substring(7) + ")"));
                int[] counts = DBUtil.execute(ctx, new String[]{mainsql, secsql});
                for (String companyID : companySet) {
                    ps.setString(1, BOSUuid.create((String)"12345678").toString());
                    ps.setString(2, unVerificatTable);
                    ps.setString(3, companyID);
                    ps.setString(4, verificationType);
                    ps.addBatch();
                }
                row.put("mainuipk", (BOSUuid)mainuipkMap.get(verificationType));
                row.put("secuipk", (BOSUuid)secuipkMap.get(verificationType));
                MappingConditionEntryCollection mappingConditionEntryCollection = (MappingConditionEntryCollection)mappingConditionEntryMap.get((String)ArApVerificationConstant.MappingCondition_MAP.get(verificationType));
                MappingConditionEntryInfo mappingConditionEntryInfo = null;
                if (null != mappingConditionEntryCollection && !mappingConditionEntryCollection.isEmpty()) {
                    for (int j = 0; j < mappingConditionEntryCollection.size(); ++j) {
                        MappingConditionEntryInfo entry = mappingConditionEntryCollection.get(j);
                        entry.put("alias", (Object)entry.getName());
                        entry.put("value", (Object)entry.getId());
                    }
                    mappingConditionEntryInfo = mappingConditionEntryCollection.get(0);
                }
                if (null != mappingConditionEntryInfo) {
                    row.put("mappingCondition", mappingConditionEntryInfo.getId());
                }
                if (!org.apache.commons.lang.StringUtils.isEmpty((String)(configMappingCondition = (String)mappingConditionMap.get(verificationType)))) {
                    row.put("mappingCondition", (BOSUuid)configMappingCondition);
                }
                row.put("mappingConditionEnumSource", (BOSUuid)mappingConditionEntryCollection);
                gridList.add(row);
            }
            ps.executeBatch();
            HashMap<String, Integer> billcountMap = new HashMap<String, Integer>();
            StringBuffer selectsql = new StringBuffer();
            selectsql.append(" select count(fbillid) as count ,fverificationType ,ftype from (");
            selectsql.append(" select fbillid ,fverificationType ,ftype");
            selectsql.append(" from T_arap_unVerificationbill where FunVerificatTable ='").append(unVerificatTable).append("'");
            selectsql.append(" group by fbillid,ftype,fverificationType");
            selectsql.append(") as t group by fverificationType ,ftype");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectsql.toString());
            while (rs.next()) {
                billcountMap.put(rs.getString("fverificationType") + rs.getString("ftype"), rs.getInt("count"));
            }
            int size2 = gridList.size();
            for (int i = 0; i < size2; ++i) {
                verificationType = (row = (Map)gridList.get(i)).get("verificationtype").toString();
                row.put("mainBillCount", (BOSUuid)(billcountMap.get(verificationType + "main") != null ? billcountMap.get(verificationType + "main") : Integer.valueOf(0)));
                row.put("secBillCount", (BOSUuid)(billcountMap.get(verificationType + "sec") != null ? billcountMap.get(verificationType + "sec") : Integer.valueOf(0)));
            }
            logger.error((Object)("deng_xu---------end: " + new Date(System.currentTimeMillis())));
        }
        catch (Exception e) {
            try {
                logger.error((Object)"get total record count error!", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("unVerificatTable", unVerificatTable);
        returnMap.put("griddata", gridList);
        return returnMap;
    }

    private IQueryExecutor getQueryExecutor(Context ctx, String queryPK, FilterInfo filterinfo, String unVerificatTable, String type) throws BOSException, ParserException {
        Map entryfieldMap = ArApVerificationConstant.QUERY_EntryFields_Map;
        String entryfield = (String)entryfieldMap.get(queryPK);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterinfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id", "fbillid"));
        sic.add(new SelectorItemInfo(entryfield, "Fentryid"));
        entityViewInfo.setSelector(sic);
        exec.setObjectView(entityViewInfo);
        exec.option().isIgnoreOrder = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        exec.option().isAutoIgnoreDuplicatedRow = false;
        return exec;
    }

    public FilterInfo getDefalutFilter(String companyid, String dateFilterItems, String dateStr) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (dateFilterItems == null || dateFilterItems.length() == 0) {
            Date today = new Date();
            int day = today.getDay();
            int month = today.getMonth();
            int year = today.getYear();
            Date beginTime = new Date(year, month, 1);
            Date endTime = new Date(year, month + 1, 1);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            filterInfo.getFilterItems().add(new FilterItemInfo(dateStr, (Object)beginTime, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo(dateStr, (Object)endTime, CompareType.LESS));
        } else {
            try {
                if (dateStr != null && dateStr.equals("billDate")) {
                    dateFilterItems = dateFilterItems.replace("bizDate", dateStr);
                }
                filterInfo = new FilterInfo(dateFilterItems);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid, CompareType.EQUALS));
        filterInfo.mergeFilter(filterInfo2, "and");
        return filterInfo;
    }

    public FilterInfo getDefalutFilter(Set<String> companyIDSet, String dateFilterItems, String dateStr) throws BOSException {
        FilterInfo filterInfo = new FilterInfo();
        if (dateFilterItems == null || dateFilterItems.length() == 0) {
            Date today = new Date();
            int day = today.getDay();
            int month = today.getMonth();
            int year = today.getYear();
            Date beginTime = new Date(year, month, 1);
            Date endTime = new Date(year, month + 1, 1);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            filterInfo.getFilterItems().add(new FilterItemInfo(dateStr, (Object)beginTime, CompareType.GREATER_EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo(dateStr, (Object)endTime, CompareType.LESS));
        } else {
            try {
                if (dateStr != null && dateStr.equals("billDate")) {
                    dateFilterItems = dateFilterItems.replace("bizDate", dateStr);
                }
                filterInfo = new FilterInfo(dateFilterItems);
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("company.id", companyIDSet, CompareType.INCLUDE));
        filterInfo.mergeFilter(filterInfo2, "and");
        return filterInfo;
    }

    private Set getClassName(List verificationTypeList) {
        HashSet classname = new HashSet();
        Map map = this.getVerificationClassNameMAP();
        int size = verificationTypeList.size();
        for (int i = 0; i < size; ++i) {
            classname.add(map.get(verificationTypeList.get(i).toString()));
        }
        return classname;
    }

    public WriteOffCommonParams getWriteOffCommonParams(Context ctx, String companyId, String verificationType, WriteOffCommonParams wfParams, String unVerificatTable, ArapWebQuerySolutionCollection defaultSolutionMap) throws BOSException {
        FilterInfo mainFilter = new FilterInfo();
        FilterInfo secFilter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select Fentryid from T_arap_unVerificationbill where FunVerificatTable ='");
        sql.append(unVerificatTable).append("' and fverificationtype='").append(verificationType).append("' ");
        sql.append(" and forgid = '").append(companyId).append("'");
        sql.append(" and  ftype =");
        String mainbosType = wfParams.getMainEntityId();
        SorterItemCollection mainsorter = new SorterItemCollection();
        Boolean mainisArAp = "FC910EF3;48DA3A71".indexOf(mainbosType) != -1;
        wfParams.put((Object)"upOrder", (Object)this.getSortItemColl(ctx, companyId, mainbosType, verificationType));
        String secbosType = wfParams.getSecEntityId();
        boolean secisArAp = "FC910EF3;48DA3A71".indexOf(secbosType) != -1;
        wfParams.put((Object)"downOrder", (Object)this.getSortItemColl(ctx, companyId, secbosType, verificationType));
        mainFilter.getFilterItems().add(new FilterItemInfo(wfParams.getMainEntryIdField(), (Object)(sql.toString() + "'main'"), CompareType.INNER));
        secFilter.getFilterItems().add(new FilterItemInfo(wfParams.getSecEntryIdField(), (Object)(sql.toString() + "'sec'"), CompareType.INNER));
        String mainEntryAmountField = mainisArAp != false ? "entry.lockUnVerifyAmt" : "entries.unLockAmt";
        String secEntryAmountField = secisArAp ? "entry.lockUnVerifyAmt" : "entries.unLockAmt";
        mainFilter.getFilterItems().add(new FilterItemInfo(mainEntryAmountField, (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
        secFilter.getFilterItems().add(new FilterItemInfo(secEntryAmountField, (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
        wfParams.put((Object)"upQueryFilter", (Object)mainFilter);
        wfParams.put((Object)"downQueryFilter", (Object)secFilter);
        wfParams.setBizDate(new Date());
        wfParams.setCompanyId(companyId);
        wfParams.put((Object)"isAutoWriteOff", (Object)Boolean.TRUE);
        boolean isSameSideFirst = this.getIsSameSideFirse(companyId, verificationType, defaultSolutionMap);
        wfParams.setSameSideFirst(isSameSideFirst);
        wfParams.put((Object)"isHeadView", (Object)false);
        wfParams.setStrategy("verification");
        return wfParams;
    }

    private boolean getIsSameSideFirse(String companyId, String verificationType, ArapWebQuerySolutionCollection defaultSolutionMap) {
        int size = defaultSolutionMap.size();
        for (int i = 0; i < size; ++i) {
            ArapWebQuerySolutionInfo solutionInfo = defaultSolutionMap.get(i);
            if (!solutionInfo.getOrgID().toString().equals(companyId) || !solutionInfo.getParentUIName().equals(verificationType)) continue;
            return solutionInfo.isIsSameSideFirst();
        }
        Boolean defaultValue = ArApVerificationConstant.VerificationType_IsSameSideFirst_Map.get(verificationType);
        if (null != defaultValue) {
            return defaultValue;
        }
        return true;
    }

    public Map getDefaultSolution(Context ctx, Set companySet, Set classNameSet, String dateFilterItems) throws BOSException {
        ContrastGLQueryParam param = new ContrastGLQueryParam();
        String userID = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        EntityViewInfo viewInfo = WriteOffCommonService.getQuerySolutionViewInfo(null, classNameSet, companySet, userID);
        IArapWebQuerySolution iSolution = ArapWebQuerySolutionFactory.getLocalInstance(ctx);
        ArapWebQuerySolutionCollection solutionCol = iSolution.getArapWebQuerySolutionCollection(viewInfo);
        HashMap customerParamMap = new HashMap();
        HashMap<String, Object> panelMap = new HashMap<String, Object>();
        Date today = new Date();
        int day = today.getDay();
        int month = today.getMonth();
        int year = today.getYear();
        Date beginTime = new Date(year, month, 1);
        Date endTime = new Date(year, month + 1, 1);
        if (solutionCol.size() > 0) {
            try {
                int size = solutionCol.size();
                for (int i = 0; i < size; ++i) {
                    ArapWebQuerySolutionInfo solutionInfo = solutionCol.get(i);
                    panelMap = new HashMap();
                    panelMap.put("companyId", solutionInfo.getOrgID());
                    String query = solutionInfo.getQueryObjectName();
                    ArapWebQueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
                    for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
                        ArapWebQueryPanelInfo info = queryPanels.get(i0);
                        FilterInfo filterInfo = new FilterInfo(info.getFilterInfo());
                        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)solutionInfo.getOrgID(), CompareType.EQUALS));
                        panelMap.put(info.getPanelClassName(), filterInfo);
                    }
                    customerParamMap.put(solutionInfo.getOrgID() + solutionInfo.getParentUIName(), panelMap);
                }
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return customerParamMap;
    }

    public static EntityViewInfo getQuerySolutionViewInfo(String queryName, Set parentPageName, Set orgSet, String userID) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentPageName, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isUserDefaultSolu", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        SorterItemCollection sorterItemCollection = new SorterItemCollection();
        sorterItemCollection.getSorter().add(new SorterItemInfo("name"));
        viewInfo.setSorter(sorterItemCollection);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)WriteOffCommonService.getSelectorItemCollection());
        return viewInfo;
    }

    private static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    public List queryafterWriteOff(Context ctx, Set companySet, String dateFilterItems, String unVerificatTable, List rows, Map billCountMap) throws BOSException, EASBizException {
        String verificationType = null;
        String rowid = null;
        Map rowMap = null;
        ArrayList<String> verificationTypeList = new ArrayList<String>();
        int size = rows.size();
        for (int i = 0; i < size; ++i) {
            rowMap = (Map)rows.get(i);
            verificationType = rowMap.get("verificationtype").toString();
            verificationTypeList.add(verificationType);
        }
        Map defaultSolutionMap = this.getDefaultSolution(ctx, companySet, this.getClassName(verificationTypeList), dateFilterItems);
        Map map = this.getVerificationClassNameMAP();
        int mainBillCount = 0;
        int secBillCount = 0;
        ArrayList<Map<String, String>> gridList = new ArrayList<Map<String, String>>();
        String deletesql = "delete from T_arap_unVerification where FunVerificatTable= '" + unVerificatTable + "'";
        String deletesql2 = "delete from T_arap_unVerificationbill where FunVerificatTable= '" + unVerificatTable + "'";
        DbUtil.execute((Context)ctx, (String)deletesql.toString());
        DbUtil.execute((Context)ctx, (String)deletesql2.toString());
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into T_arap_unVerification ");
        sql.append(" (fid,FunVerificatTable,forgid,fverificationType,Fbilldate )");
        sql.append(" values ( ?,?,?,?,now())");
        StringBuffer sql2 = new StringBuffer();
        sql2.append(" insert into T_arap_unVerificationbill ");
        sql2.append(" (fid,fbilldate,FunVerificatTable,forgid,fverificationType,ftype,Fbillid,Fentryid)");
        sql2.append(" (select  newbosid('12345678') as fid, now() as fbilldate, '");
        sql2.append(unVerificatTable).append("' as FunVerificatTable , ");
        StringBuffer select = new StringBuffer();
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            Map<String, String> row;
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            int size2 = rows.size();
            for (int i = 0; i < size2; ++i) {
                Integer verfiedBillCount;
                rowMap = (Map)rows.get(i);
                verificationType = rowMap.get("verificationtype").toString();
                rowid = rowMap.get("rowid").toString();
                String classname = map.get(verificationType).toString();
                mainBillCount = 0;
                secBillCount = 0;
                row = new HashMap();
                Integer n = verfiedBillCount = null == billCountMap.get(rowid) ? null : new Integer(billCountMap.get(rowid).toString());
                if (0 == verfiedBillCount) continue;
                classname = map.get(verificationType).toString();
                Arrays.asList((Object[])companySet.toArray());
                Object[] arr = companySet.toArray();
                Arrays.sort((Object[])arr);
                String key = org.apache.commons.lang.StringUtils.join((Object[])arr, (String)",");
                Map defaultSolution = (Map)defaultSolutionMap.get(key + classname);
                Map params = this.getQueryParams(ctx, defaultSolution, companySet, verificationType, dateFilterItems);
                IQueryExecutor mainExecutor = this.getQueryExecutor(ctx, params.get("mainQuery").toString(), (FilterInfo)params.get("mainFilter"), unVerificatTable, "main");
                IQueryExecutor secExecutor = this.getQueryExecutor(ctx, params.get("secQuery").toString(), (FilterInfo)params.get("secFilter"), unVerificatTable, "sec");
                String mainsql = mainExecutor.getSQL();
                select.setLength(0);
                select.append(" COMPANY.FID as forgid,");
                select.append(" '").append(verificationType).append("' as fverificationType,'");
                mainsql = sql2.toString() + select.toString() + "main' as ftype," + mainsql.substring(7) + ")";
                String secsql = secExecutor.getSQL();
                secsql = sql2.toString() + select.toString() + "sec' as ftype," + secsql.substring(7) + ")";
                int[] counts = DBUtil.execute(ctx, new String[]{mainsql, secsql});
                mainBillCount += counts[0];
                secBillCount += counts[1];
                for (String companyID : companySet) {
                    ps.setString(1, BOSUuid.create((String)"12345678").toString());
                    ps.setString(2, unVerificatTable);
                    ps.setString(3, companyID);
                    ps.setString(4, verificationType);
                    ps.addBatch();
                }
                row.put("verificationtype", verificationType);
                row.put("rowid", rowid);
                row.put("mainBillCount", (String)((Object)Integer.valueOf(mainBillCount)));
                row.put("secBillCount", (String)((Object)Integer.valueOf(secBillCount)));
                gridList.add(row);
            }
            ps.executeBatch();
            HashMap<String, Integer> billcountMap = new HashMap<String, Integer>();
            StringBuffer selectsql = new StringBuffer();
            selectsql.append(" select count(fbillid) as count,fverificationType ,ftype from (");
            selectsql.append(" select fbillid ,fverificationType ,ftype");
            selectsql.append(" from T_arap_unVerificationbill where FunVerificatTable ='").append(unVerificatTable).append("'");
            selectsql.append(" group by fbillid,ftype,fverificationType");
            selectsql.append(") as t group by fverificationType ,ftype");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectsql.toString());
            while (rs.next()) {
                billcountMap.put(rs.getString("fverificationType") + rs.getString("ftype"), rs.getInt("count"));
            }
            int size3 = gridList.size();
            for (int i = 0; i < size3; ++i) {
                verificationType = (row = (Map)gridList.get(i)).get("verificationtype").toString();
                row.put("mainBillCount", (String)(billcountMap.get(verificationType + "main") != null ? billcountMap.get(verificationType + "main") : Integer.valueOf(0)));
                row.put("secBillCount", (String)(billcountMap.get(verificationType + "sec") != null ? billcountMap.get(verificationType + "sec") : Integer.valueOf(0)));
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return gridList;
    }

    private Map getGridData(List gridData) throws BOSException {
        ArrayList<WriteOffCommonInfo> list = new ArrayList<WriteOffCommonInfo>();
        WriteOffCommonInfo info = null;
        Map row = null;
        StringBuffer entryids = new StringBuffer();
        StringBuffer billids = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        int size = gridData.size();
        for (int i = 0; i < size; ++i) {
            info = new WriteOffCommonInfo();
            row = (Map)gridData.get(i);
            if (row.get("lastUpdateTime") != null && row.get("lastUpdateTime").toString().length() > 1) {
                String billId = row.get("billId").toString();
                String oql = "select lastUpdateTime where id = '" + billId + "'";
                IObjectValue value = DynamicObjectFactory.getRemoteInstance().getValue(BOSUuid.read((String)billId).getType(), oql);
                info.setLastUpdateTime((Date)value.getDate("lastUpdateTime"));
            }
            if (row.get("amount") != null) {
                info.setAmount(new BigDecimal(row.get("amount").toString()));
            }
            if (row.get("localAmount") != null) {
                info.setLocalAmount(new BigDecimal(row.get("localAmount").toString()));
            }
            info.setBillId((String)row.get("billId"));
            info.setEntryId((String)row.get("entryId"));
            info.setBillNumber((String)row.get("billNumber"));
            list.add(info);
            if (i == 0) {
                entryids.append("'").append((String)row.get("entryId")).append("'");
                billids.append("'").append((String)row.get("billId")).append("'");
                continue;
            }
            entryids.append(",'").append((String)row.get("entryId")).append("'");
            billids.append(",'").append((String)row.get("billId")).append("'");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("list", list);
        map.put("entryids", entryids.toString());
        map.put("billids", billids.toString());
        return map;
    }

    public Map manualWriteOff(Context ctx, Map params) throws EASBizException, BOSException {
        List mainGridData = (List)params.get("mainGridData");
        List secGridData = (List)params.get("secGridData");
        String verificationType = (String)params.get("verificationType");
        String mappingEntryId = (String)params.get("mappingEntryId");
        String companyId = (String)params.get("companyId");
        boolean isBillDate = Boolean.parseBoolean(params.get("isBillDate").toString());
        boolean sameSideFirst = Boolean.parseBoolean(params.get("sameSideFirst").toString());
        boolean isHeadView = Boolean.parseBoolean(params.get("isHeadView").toString());
        WriteOffCommonParams wfParams = this.getmanualParams(verificationType);
        wfParams.put((Object)"isAutoWriteOff", (Object)Boolean.FALSE);
        wfParams.setMappingEntryId(mappingEntryId);
        wfParams.setSameSideFirst(sameSideFirst);
        this.sortGridData(mainGridData);
        this.sortGridData(secGridData);
        Map mainMap = this.getGridData(mainGridData);
        Map secMap = this.getGridData(secGridData);
        wfParams.setMainList((List)mainMap.get("list"));
        wfParams.setSecList((List)secMap.get("list"));
        FilterInfo mainFilter = new FilterInfo();
        FilterInfo secFilter = new FilterInfo();
        if (isHeadView) {
            mainFilter.getFilterItems().add(new FilterItemInfo("id", (Object)(StringUtils.isEmpty((String)mainMap.get("billids").toString()) ? "'NULL'" : mainMap.get("billids").toString()), CompareType.INNER));
            secFilter.getFilterItems().add(new FilterItemInfo("id", (Object)(StringUtils.isEmpty((String)secMap.get("billids").toString()) ? "'NULL'" : secMap.get("billids").toString()), CompareType.INNER));
        } else {
            mainFilter.getFilterItems().add(new FilterItemInfo(wfParams.getMainEntryIdField(), (Object)(StringUtils.isEmpty((String)mainMap.get("entryids").toString()) ? "'NULL'" : mainMap.get("entryids").toString()), CompareType.INNER));
            secFilter.getFilterItems().add(new FilterItemInfo(wfParams.getSecEntryIdField(), (Object)(StringUtils.isEmpty((String)secMap.get("entryids").toString()) ? "'NULL'" : secMap.get("entryids").toString()), CompareType.INNER));
        }
        String mainbosType = wfParams.getMainEntityId();
        boolean mainisArAp = "FC910EF3;48DA3A71".indexOf(mainbosType) != -1;
        SorterItemCollection mainsorter = new SorterItemCollection();
        mainsorter.add(new SorterItemInfo(mainisArAp ? "billDate" : "bizDate"));
        wfParams.put((Object)"upOrder", (Object)mainsorter);
        String secbosType = wfParams.getSecEntityId();
        boolean secisArAp = "FC910EF3;48DA3A71".indexOf(secbosType) != -1;
        SorterItemCollection secsorter = new SorterItemCollection();
        secsorter.add(new SorterItemInfo(secisArAp ? "billDate" : "bizDate"));
        wfParams.put((Object)"downOrder", (Object)secsorter);
        String mainEntryAmountField = mainisArAp ? "entry.lockUnVerifyAmt" : "entries.unLockAmt";
        String secEntryAmountField = secisArAp ? "entry.lockUnVerifyAmt" : "entries.unLockAmt";
        mainFilter.getFilterItems().add(new FilterItemInfo(mainEntryAmountField, (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
        secFilter.getFilterItems().add(new FilterItemInfo(secEntryAmountField, (Object)new BigDecimal("0"), CompareType.NOTEQUALS));
        wfParams.put((Object)"upQueryFilter", (Object)mainFilter);
        wfParams.put((Object)"downQueryFilter", (Object)secFilter);
        String verificationDate = params.get("verificationDate") == null ? "" : (String)params.get("verificationDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date bizDate = new Date();
        try {
            if (verificationDate != null && verificationDate != "") {
                bizDate = sdf.parse(verificationDate);
            }
        }
        catch (ParseException e) {
            throw new BOSException(e.getCause());
        }
        wfParams.setBizDate(bizDate);
        wfParams.setCompanyId(companyId);
        wfParams.put((Object)"isHeadView", (Object)isHeadView);
        wfParams.put((Object)"isBillDate", (Object)isBillDate);
        List result = ArApVerifyCommonFacadeFactory.getLocalInstance(ctx).manualWriteOff(wfParams);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        StringBuffer idstring = new StringBuffer();
        for (int i = 0; i < result.size(); ++i) {
            if (result.get(i) == null) continue;
            if (i == 0) {
                idstring.append(result.get(i).toString());
                continue;
            }
            idstring.append(",").append(result.get(i).toString());
        }
        if (result.size() > 0) {
            resultMap.put("result", idstring.toString());
        }
        resultMap.put("resultcount", result.size());
        return resultMap;
    }

    private void sortGridData(List gridData) {
        if (gridData.size() == 0) {
            return;
        }
        Collections.sort(gridData, new Comparator<Map>(){

            @Override
            public int compare(Map o1, Map o2) {
                String date2;
                String date1 = o1.get("bizDate").toString();
                int i = date1.compareTo(date2 = o2.get("bizDate").toString());
                if (i == 0 && (i = o1.get("number").toString().compareTo(o2.get("number").toString())) == 0) {
                    i = new Double(o1.get("entrySeq").toString()).compareTo(new Double(o2.get("entrySeq").toString()));
                }
                return i;
            }
        });
    }

    protected FilterInfo getArApStartDateFilter(Context ctx, Set<String> companyIDSet, String queryPK) throws BOSException {
        SystemEnum system;
        FilterInfo filter = new FilterInfo();
        if (companyIDSet.size() == 0 || org.apache.commons.lang.StringUtils.isEmpty((String)queryPK)) {
            return filter;
        }
        HashSet<Integer> systemsSet = new HashSet<Integer>();
        systemsSet.add(12);
        systemsSet.add(13);
        Map<String, SystemStatusCtrolInfo> sysStatusMap = CommonServerUtils.getSysStatusCtrolInfo(ctx, companyIDSet, systemsSet);
        if ("com.kingdee.eas.fi.ar.app.OtherBill".equals(queryPK)) {
            system = SystemEnum.ACCOUNTSRECEIVABLE;
        } else if ("com.kingdee.eas.fi.ap.app.OtherBillQuery".equals(queryPK)) {
            system = SystemEnum.ACCOUNTSPAYABLE;
        } else {
            return filter;
        }
        for (String companyId : companyIDSet) {
            SystemStatusCtrolInfo sysInfo;
            if (sysStatusMap == null || (sysInfo = sysStatusMap.get(CommonServerUtils.generateMapKey(companyId, system))) == null || sysInfo.getStartPeriod() == null) continue;
            FilterInfo filterTemp = new FilterInfo();
            filterTemp.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
            filterTemp.getFilterItems().add(new FilterItemInfo("isInitializeBill", (Object)Boolean.TRUE));
            filterTemp.getFilterItems().add(new FilterItemInfo("billDate", (Object)sysInfo.getStartPeriod().getBeginDate(), CompareType.GREATER_EQUALS));
            filterTemp.setMaskString("#0 and (#1 or #2)");
            filter.mergeFilter(filterTemp, "or");
        }
        return filter;
    }

    public abstract WriteOffCommonParams getmanualParams(String var1);

    public abstract Map getVerificationNameMAP();

    public abstract Map getMainBillUIPKMAP();

    public abstract Map getSecBillUIPKMAP();

    public abstract Map getVerificationClassNameMAP();

    public abstract List getVerificationTypeList();

    public abstract Map getQueryParams(Context var1, Map var2, Set<String> var3, String var4, String var5) throws BOSException;

    public abstract WriteOffCommonParams getParams(String var1);

    public abstract String getPermissionItem();

    public abstract SorterItemCollection getSortItemColl(Context var1, String var2, String var3, String var4) throws BOSException;
}

