/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.IncomeConfimEntryCollection;
import com.kingdee.eas.fi.ar.IncomeConfimEntryFactory;
import com.kingdee.eas.fi.ar.IncomeConfimEntryInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.app.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.BaseServiceFacadeFactory;
import com.kingdee.eas.fi.arap.app.util.ArApServerUtils;
import com.kingdee.eas.fi.arap.app.writeback.handler.AbstractWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.scm.framework.balance.OperationTypeEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AR2ICWriteBackHandler
extends AbstractWriteBackHandler {
    private int locPrecision = 2;
    private boolean isDirectExchange = true;
    private static final String RES_STR = "com.kingdee.eas.fi.ar.IncomeConfimResource";
    private Map<String, BigDecimal> mmuConvsRate = new HashMap<String, BigDecimal>();
    private Map<String, Integer> mmuPrecisions = new HashMap<String, Integer>();
    private String arBillNumber;

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (null == destBillInfo) {
            return;
        }
        this.doWriteBack(ctx, bizAction, destBillInfo);
    }

    private void doWriteBack(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws BOSException, EASBizException {
        if (!(destBillInfo instanceof OtherBillInfo)) {
            return;
        }
        OtherBillInfo arInfo = (OtherBillInfo)destBillInfo;
        OtherBillentryCollection entries = arInfo.getEntry();
        if (entries == null || entries.size() == 0) {
            return;
        }
        String sourceBillEntryId = entries.getObject(0).getString("sourceBillEntryId");
        if (StringUtils.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        BOSObjectType srcEntryBosType = BOSUuid.read((String)sourceBillEntryId).getType();
        if (!"5EE6785D".equals(srcEntryBosType.toString())) {
            return;
        }
        this.arBillNumber = arInfo.getNumber();
        HashSet<String> icEntryIdSet = new HashSet<String>();
        HashSet<String> arEntryIdSet = new HashSet<String>();
        for (int i = 0; i < entries.size(); ++i) {
            arEntryIdSet.add(entries.get(i).getId().toString());
            String icEntryId = entries.get(i).getSourceBillEntryId();
            if (StringUtils.isEmpty((String)icEntryId)) continue;
            icEntryIdSet.add(icEntryId);
        }
        ArApServerUtils.addSQLLock(ctx, arEntryIdSet);
        ArApServerUtils.addSQLLock(ctx, icEntryIdSet);
        IncomeConfimEntryCollection icEntryColl = this.getIncomConfimEntryCollection(ctx, icEntryIdSet);
        if (icEntryColl != null && icEntryColl.size() > 0) {
            ArApBillEntryBaseInfo tempSrcEntryInfo = (ArApBillEntryBaseInfo)icEntryColl.getObject(0);
            if (tempSrcEntryInfo.getParent().getCompany() != null && tempSrcEntryInfo.getParent().getCompany().getBaseCurrency() != null) {
                this.locPrecision = tempSrcEntryInfo.getParent().getCompany().getBaseCurrency().getPrecision();
            }
            CurrencyInfo currcenyInfo = tempSrcEntryInfo.getParent().getCurrency();
            ExchangeRateInfo rateInfo = BaseDataUtil.getExchangeRate(ctx, tempSrcEntryInfo.getParent().getCompany(), currcenyInfo, new Date());
            if (rateInfo != null) {
                this.isDirectExchange = ConvertModeEnum.DIRECTEXCHANGERATE.equals((Object)rateInfo.getExchangeAux().getConvertMode());
            }
        }
        this.cacheMultiUnit(ctx, icEntryColl, entries);
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            IORMappingDAO srcDAO = ORMappingDAO.getInstance((BOSObjectType)srcEntryBosType, (Context)ctx, (Connection)conn);
            for (int i = 0; i < icEntryColl.size(); ++i) {
                OtherBillentryInfo arEntryInfo = (OtherBillentryInfo)entries.getObject(i);
                ObjectStringPK srcEntryPK = new ObjectStringPK(arEntryInfo.getSourceBillEntryId());
                if (!icEntryColl.containsKey(BOSUuid.read((String)arEntryInfo.getSourceBillEntryId()))) continue;
                IncomeConfimEntryInfo icEntryInfo = (IncomeConfimEntryInfo)icEntryColl.getObject(BOSUuid.read((String)arEntryInfo.getSourceBillEntryId()));
                if (BizActionEnum.SAVE.equals((Object)bizAction)) {
                    this.doWriteBackForLock(ctx, arEntryInfo, icEntryInfo, OperationTypeEnum.Positive);
                } else if (BizActionEnum.DELETE.equals((Object)bizAction)) {
                    this.doWriteBackForLock(ctx, arEntryInfo, icEntryInfo, OperationTypeEnum.Reverse);
                } else if (BizActionEnum.AUDIT.equals((Object)bizAction)) {
                    this.doWriteBackForTotal(ctx, arEntryInfo, icEntryInfo, OperationTypeEnum.Positive);
                } else if (BizActionEnum.UNAUDIT.equals((Object)bizAction)) {
                    this.doWriteBackForTotal(ctx, arEntryInfo, icEntryInfo, OperationTypeEnum.Reverse);
                }
                srcDAO.updateBatch((IObjectPK)srcEntryPK, (IObjectValue)icEntryInfo);
            }
            srcDAO.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void cacheMultiUnit(Context ctx, IncomeConfimEntryCollection icEntryColl, OtherBillentryCollection entries) throws EASBizException, BOSException {
        ArrayList mmuMaterials = new ArrayList();
        for (int i = 0; i < icEntryColl.size(); ++i) {
            IncomeConfimEntryInfo icEntryInfo;
            OtherBillentryInfo arEntryInfo = (OtherBillentryInfo)entries.getObject(i);
            if (!icEntryColl.containsKey(BOSUuid.read((String)arEntryInfo.getSourceBillEntryId())) || (icEntryInfo = (IncomeConfimEntryInfo)icEntryColl.getObject(BOSUuid.read((String)arEntryInfo.getSourceBillEntryId()))).getMeasureUnit() == null || arEntryInfo.getMeasureUnit() == null || icEntryInfo.getMeasureUnit().getId().toString().equals(arEntryInfo.getMeasureUnit().getId().toString())) continue;
            ArrayList<String> mmuMaterial = new ArrayList<String>();
            mmuMaterial.add(icEntryInfo.getMaterial().getId().toString());
            mmuMaterial.add(icEntryInfo.getMeasureUnit().getId().toString());
            mmuMaterial.add(icEntryInfo.getBaseUnit().getId().toString());
            mmuMaterial.add(null);
            mmuMaterials.add(mmuMaterial);
        }
        if (!mmuMaterials.isEmpty()) {
            Map result = BaseServiceFacadeFactory.getLocalInstance(ctx).getMultiUnitData(mmuMaterials);
            this.mmuConvsRate = (Map)result.get("MmuConvsRate");
            this.mmuPrecisions = (Map)result.get("MmuPrecisions");
        }
    }

    private IncomeConfimEntryCollection getIncomConfimEntryCollection(Context ctx, Set<String> icEntryIdSet) throws BOSException {
        EntityViewInfo entryView = new EntityViewInfo();
        entryView.getSelector().add(new SelectorItemInfo("*"));
        entryView.getSelector().add(new SelectorItemInfo("head.exchangeRate"));
        entryView.getSelector().add(new SelectorItemInfo("head.currency.*"));
        entryView.getSelector().add(new SelectorItemInfo("head.company.id"));
        entryView.getSelector().add(new SelectorItemInfo("head.company.baseCurrency.precision"));
        entryView.getSelector().add(new SelectorItemInfo("head.number"));
        FilterInfo entryFilter = new FilterInfo();
        entryFilter.getFilterItems().add(new FilterItemInfo("id", icEntryIdSet, CompareType.INCLUDE));
        entryView.setFilter(entryFilter);
        return IncomeConfimEntryFactory.getLocalInstance(ctx).getIncomeConfimEntryCollection(entryView);
    }

    private void doWriteBackForLock(Context ctx, OtherBillentryInfo arEntryInfo, IncomeConfimEntryInfo icEntryInfo, OperationTypeEnum operType) throws EASBizException, BOSException {
        boolean isPositive = operType.equals((Object)OperationTypeEnum.Positive);
        BigDecimal exchangeRate = icEntryInfo.getParent().getExchangeRate();
        BigDecimal thisAmt = arEntryInfo.getRecievePayAmount();
        BigDecimal thisQty = arEntryInfo.getQuantity();
        BigDecimal thisBaseQty = arEntryInfo.getBaseQty();
        BigDecimal lockAmt = this.getBigDecimal(icEntryInfo.getLockVerifyAmt());
        BigDecimal lockQty = this.getBigDecimal(icEntryInfo.getLockQty());
        BigDecimal lockBaseQty = this.getBigDecimal(icEntryInfo.getLockBaseQty());
        BigDecimal incomeConfirmAmt = this.getBigDecimal(icEntryInfo.getIncomeConfimAmount());
        BigDecimal incomeConfirmAmtLoc = this.getBigDecimal(icEntryInfo.getIncomeConfimAmountLoc());
        BigDecimal qty = this.getBigDecimal(icEntryInfo.getQuantity());
        BigDecimal baseQty = this.getBigDecimal(icEntryInfo.getBaseQty());
        BigDecimal unLockAmt = this.getBigDecimal(icEntryInfo.getLockUnVerifyAmt());
        BigDecimal unLockQty = this.getBigDecimal(icEntryInfo.getUnLockQty());
        BigDecimal unLockBaseQty = this.getBigDecimal(icEntryInfo.getUnLockBaseQty());
        if (unLockAmt.multiply(thisAmt).signum() < 0) {
            String errorMsg = this.getResString(ctx, "AR_AMOUNT_SIGNUM_NOT_SAME", new Object[]{this.arBillNumber, arEntryInfo.getSeq(), arEntryInfo.getRecievePayAmount(), icEntryInfo.getParent().getNumber(), icEntryInfo.getSeq(), icEntryInfo.getLockUnVerifyAmt()});
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        if (unLockQty.multiply(thisQty).signum() < 0) {
            String errorMsg = this.getResString(ctx, "AR_QTY_SIGNUM_NOT_SAME", new Object[]{this.arBillNumber, arEntryInfo.getSeq(), arEntryInfo.getQuantity(), icEntryInfo.getParent().getNumber(), icEntryInfo.getSeq(), icEntryInfo.getUnLockQty()});
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        lockAmt = isPositive ? lockAmt.add(thisAmt) : lockAmt.subtract(thisAmt);
        unLockAmt = incomeConfirmAmt.subtract(lockAmt);
        BigDecimal bigDecimal = lockBaseQty = isPositive ? lockBaseQty.add(thisBaseQty) : lockBaseQty.subtract(thisBaseQty);
        if (lockBaseQty.compareTo(baseQty) == 0) {
            lockQty = qty;
        } else if (lockBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            lockQty = BigDecimal.ZERO;
        } else if (icEntryInfo.getMeasureUnit().getId().toString().compareTo(arEntryInfo.getMeasureUnit().getId().toString()) == 0) {
            lockQty = isPositive ? lockQty.add(thisQty) : lockQty.subtract(thisQty);
        } else {
            BigDecimal tempQty = this.getQty(icEntryInfo.getMaterial().getId().toString(), icEntryInfo.getMeasureUnit().getId().toString(), icEntryInfo.getBaseUnit().getId().toString(), thisBaseQty);
            lockQty = isPositive ? lockQty.add(tempQty) : lockQty.subtract(tempQty);
        }
        unLockQty = qty.subtract(lockQty);
        unLockBaseQty = baseQty.subtract(lockBaseQty);
        if (lockAmt.abs().compareTo(incomeConfirmAmt.abs()) > 0) {
            String errorMsg = this.getResString(ctx, "AR_AMOUNT_LITTER_UNLOCK_AMOUNT", new Object[]{this.arBillNumber, arEntryInfo.getSeq(), arEntryInfo.getRecievePayAmount(), icEntryInfo.getParent().getNumber(), icEntryInfo.getSeq(), icEntryInfo.getLockUnVerifyAmt()});
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        if (lockQty.abs().compareTo(qty.abs()) > 0) {
            String errorMsg = this.getResString(ctx, "AR_QTY_LITTER_UNLOCK_QTY", new Object[]{this.arBillNumber, arEntryInfo.getSeq(), arEntryInfo.getQuantity(), icEntryInfo.getParent().getNumber(), icEntryInfo.getSeq(), icEntryInfo.getUnLockQty()});
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        icEntryInfo.setLockVerifyAmt(lockAmt);
        icEntryInfo.setLockUnVerifyAmt(unLockAmt);
        icEntryInfo.setLockQty(lockQty);
        icEntryInfo.setLockBaseQty(lockBaseQty);
        icEntryInfo.setUnLockQty(unLockQty);
        icEntryInfo.setUnLockBaseQty(unLockBaseQty);
        if (exchangeRate.compareTo(BigDecimal.ONE) == 0) {
            icEntryInfo.setLockVerifyAmtLocal(icEntryInfo.getLockVerifyAmt());
            icEntryInfo.setLockUnVerifyAmtLocal(icEntryInfo.getLockUnVerifyAmt());
        } else if (lockAmt.compareTo(incomeConfirmAmt) == 0) {
            icEntryInfo.setLockVerifyAmtLocal(incomeConfirmAmtLoc);
            icEntryInfo.setLockUnVerifyAmtLocal(BigDecimal.ZERO);
        } else if (lockAmt.compareTo(BigDecimal.ZERO) == 0) {
            icEntryInfo.setLockVerifyAmtLocal(BigDecimal.ZERO);
            icEntryInfo.setLockUnVerifyAmtLocal(incomeConfirmAmtLoc);
        } else {
            BigDecimal thisAmtLoc = this.isDirectExchange ? thisAmt.multiply(exchangeRate).setScale(this.locPrecision, 4) : thisAmt.divide(exchangeRate, this.locPrecision, 4);
            BigDecimal lockAmtLoc = this.getBigDecimal(icEntryInfo.getLockVerifyAmtLocal());
            lockAmtLoc = isPositive ? lockAmtLoc.add(thisAmtLoc) : lockAmtLoc.subtract(thisAmtLoc);
            icEntryInfo.setLockVerifyAmtLocal(lockAmtLoc);
            icEntryInfo.setLockUnVerifyAmtLocal(incomeConfirmAmtLoc.subtract(icEntryInfo.getLockVerifyAmtLocal()));
        }
    }

    private BigDecimal getQty(String materialID, String unitId, String baseUnitId, BigDecimal baseQty) {
        BigDecimal baseExchangeRate;
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        if (StringUtils.isEmpty((String)unitId)) {
            return SysConstant.BIGZERO;
        }
        baseQty = baseQty == null ? SysConstant.BIGZERO : baseQty;
        BigDecimal targetQty = null;
        if (unitId.equals(baseUnitId)) {
            return baseQty;
        }
        BigDecimal bigDecimal = baseExchangeRate = this.mmuConvsRate.get(materialID + unitId) == null ? BigDecimal.ONE : this.mmuConvsRate.get(materialID + unitId);
        if (baseQty != null) {
            int scale = this.mmuPrecisions.get(materialID + unitId) == null ? 8 : this.mmuPrecisions.get(materialID + unitId);
            targetQty = baseQty.divide(baseExchangeRate, scale, 4);
        }
        return targetQty;
    }

    public BigDecimal getBigDecimal(BigDecimal num) {
        return num == null ? BigDecimal.ZERO : num;
    }

    private void doWriteBackForTotal(Context ctx, OtherBillentryInfo arEntryInfo, IncomeConfimEntryInfo icEntryInfo, OperationTypeEnum operType) throws OtherBillBizException {
        boolean isPositive = operType.equals((Object)OperationTypeEnum.Positive);
        BigDecimal baseQty = this.getBigDecimal(icEntryInfo.getBaseQty());
        BigDecimal qty = this.getBigDecimal(icEntryInfo.getQuantity());
        BigDecimal totalArAmount = this.getBigDecimal(icEntryInfo.getTotalArAmount());
        BigDecimal incomeConfimAmount = this.getBigDecimal(icEntryInfo.getIncomeConfimAmount());
        BigDecimal totalArQty = this.getBigDecimal(icEntryInfo.getTotalArQty());
        BigDecimal totalArBaseQty = this.getBigDecimal(icEntryInfo.getTotalArBaseQty());
        BigDecimal thisQty = this.getBigDecimal(arEntryInfo.getQuantity());
        BigDecimal thisBaseQty = this.getBigDecimal(arEntryInfo.getBaseQty());
        BigDecimal thisRecPayAmount = this.getBigDecimal(arEntryInfo.getRecievePayAmount());
        totalArAmount = isPositive ? totalArAmount.add(thisRecPayAmount) : totalArAmount.subtract(thisRecPayAmount);
        icEntryInfo.setTotalArAmount(totalArAmount);
        BigDecimal bigDecimal = totalArBaseQty = isPositive ? totalArBaseQty.add(thisBaseQty) : totalArBaseQty.subtract(thisBaseQty);
        if (totalArBaseQty.compareTo(baseQty) == 0) {
            totalArQty = qty;
        } else if (totalArBaseQty.compareTo(BigDecimal.ZERO) == 0) {
            totalArQty = BigDecimal.ZERO;
        } else if (icEntryInfo.getMeasureUnit().getId().toString().equals(arEntryInfo.getMeasureUnit().getId().toString())) {
            totalArQty = isPositive ? totalArQty.add(thisQty) : totalArQty.subtract(thisQty);
        } else {
            BigDecimal tempQty = this.getQty(icEntryInfo.getMaterial().getId().toString(), icEntryInfo.getMeasureUnit().getId().toString(), icEntryInfo.getBaseUnit().getId().toString(), thisBaseQty);
            totalArQty = isPositive ? totalArQty.add(tempQty) : totalArQty.subtract(tempQty);
        }
        icEntryInfo.setTotalArQty(totalArQty);
        icEntryInfo.setTotalArBaseQty(totalArBaseQty);
        if (totalArAmount.abs().compareTo(incomeConfimAmount.abs()) > 0) {
            String errorMsg = this.getResString(ctx, "AR_TOTALAMOUNT_LITTER_UNLOCK_AMOUNT", new Object[]{this.arBillNumber, arEntryInfo.getSeq(), thisRecPayAmount, icEntryInfo.getParent().getNumber(), icEntryInfo.getSeq()});
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
        if (totalArQty.abs().compareTo(qty.abs()) > 0) {
            String errorMsg = this.getResString(ctx, "AR_TOTALQTY_LITTER_UNLOCK_AMOUNT", new Object[]{this.arBillNumber, arEntryInfo.getSeq(), thisQty, icEntryInfo.getParent().getNumber(), icEntryInfo.getSeq()});
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg});
        }
    }

    public String getResString(Context ctx, String key) {
        return ResourceBase.getString((String)RES_STR, (String)key, (Locale)ctx.getLocale());
    }

    public String getResString(Context ctx, String key, Object[] params) {
        return ResourceBase.getString((String)RES_STR, (String)key, (Locale)ctx.getLocale(), (Object[])params);
    }
}

