/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.arap.app.writeback.handler.AbstractWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.util.ArApCommonUtil;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PAY2PCWriteBackHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.writeback.handler.impl.PR2PCWriteBackHandler");

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        boolean allowed;
        if (destBillInfo == null || !(destBillInfo instanceof PaymentBillInfo)) {
            return;
        }
        PaymentBillInfo info = (PaymentBillInfo)destBillInfo;
        String sourceBillId = info.getEntries().get(0).getSourceBillId();
        if (sourceBillId == null || "D001019A".equals(BOSUuid.read((String)sourceBillId).getType().toString())) {
            return;
        }
        Set<String> notNeedDealIds = this.getNotNeedDealIds(ctx, bizAction, destBillInfo);
        this.addSqlLockForSourceBillEntry(ctx, destBillInfo, "E8D24BDF");
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        StringBuilder contractEntryIds = this.getWriteBackParam(ctx, destBillInfo, paramList, notNeedDealIds);
        if (paramList.size() == 0) {
            return;
        }
        this.doWriteBack(ctx, bizAction, paramList, bizScene);
        if (bizAction.equals((Object)BizActionEnum.PAY) && !(allowed = this.getCheckParamValue(ctx, destBillInfo))) {
            this.doCheck(ctx, contractEntryIds, bizScene);
        }
    }

    private Set<String> getNotNeedDealIds(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        HashSet<String> notNeedDealIds = new HashSet<String>();
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT payEntry.FID as payEntryId").append("\r\n");
        selectBuilder.append(" FROM T_CAS_PAYMENTBILLENTRY payEntry").append("\r\n");
        selectBuilder.append(" INNER JOIN T_AP_OTHERBILLENTRY apEntry ON payEntry.FSOURCEBILLENTRYID = apEntry.FID").append("\r\n");
        selectBuilder.append(" WHERE payEntry.FPAYMENTBILLID = ?").append("\r\n");
        String keySuffix = ".isContainsAp.selectSql";
        String recordKey = this.getClass() + keySuffix;
        Object[] params = new Object[]{destBillInfo.getString("id")};
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), params, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString(), (Object[])params);
        while (rowSet.next()) {
            notNeedDealIds.add(rowSet.getString("payEntryId"));
        }
        return notNeedDealIds;
    }

    protected StringBuilder getWriteBackParam(Context ctx, IObjectValue destBillInfo, List<Object[]> paramList, Set<String> notNeedDealIds) throws BOSException, SQLException, EASBizException {
        String notNeedDealIdStr = "";
        if (null != notNeedDealIds && notNeedDealIds.size() > 0) {
            notNeedDealIdStr = ArApCommonUtil.transArr2SqlIdStr(notNeedDealIds);
        }
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT purConEntry.FID AS CONTRACTENTRYID").append("\r\n");
        selectBuilder.append(" \t,sum(payEntry.FAmount) as AMOUNT").append("\r\n");
        selectBuilder.append(" FROM T_CAS_PaymentBillEntry payEntry").append("\r\n");
        selectBuilder.append(" INNER JOIN T_SM_PurContractEntry purConEntry").append("\r\n");
        selectBuilder.append(" ON payEntry.FSOURCEBILLENTRYID = purConEntry.FID").append("\r\n");
        selectBuilder.append(" WHERE payEntry.FParentID = ?").append("\r\n");
        if (StringUtils.isEmpty((String)notNeedDealIdStr)) {
            selectBuilder.append(" and payEntry.FID not in(").append(notNeedDealIdStr).append(")").append("\r\n");
        }
        selectBuilder.append(" GROUP BY purConEntry.FID").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurContractEntryFPreReceived1.selectSql";
        Object[] params = new Object[]{destBillInfo.getString("id")};
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), params, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString(), (Object[])params);
        selectBuilder.setLength(0);
        BigDecimal thisAmt = BigDecimal.ZERO;
        String contractEntryId = "";
        StringBuilder contractEntryIds = new StringBuilder(200);
        HashMap<String, BigDecimal> srcAmtMap = new HashMap<String, BigDecimal>();
        while (rowSet.next()) {
            thisAmt = rowSet.getBigDecimal("AMOUNT");
            contractEntryId = rowSet.getString("CONTRACTENTRYID");
            paramList.add(new Object[]{thisAmt, thisAmt, contractEntryId});
            contractEntryIds.append("'").append(contractEntryId).append("'").append(",");
            srcAmtMap.put(contractEntryId, thisAmt);
        }
        return contractEntryIds;
    }

    protected void doWriteBack(Context ctx, BizActionEnum bizAction, List<Object[]> paramList, BizSceneEnum bizScene) throws BOSException {
        String plus = BizActionEnum.PAY.equals((Object)bizAction) ? "+" : "-";
        String minus = BizActionEnum.PAY.equals((Object)bizAction) ? "-" : "+";
        StringBuffer updatePurContSql = new StringBuffer(200);
        updatePurContSql.append(" UPDATE T_SM_PurContractEntry SET ");
        updatePurContSql.append(" FPreReceived = isnull(FPreReceived,0) ").append(plus).append(" ? ");
        updatePurContSql.append(" ,FUnPrereceivedAm = isnull(FPrepayment,0) ").append(minus).append(" (isnull(FPreReceived,0) ").append(plus).append(" ? )");
        updatePurContSql.append("WHERE FID = ?");
        String recordKey = this.getClass() + ".writeBackPurContractEntryFPreReceived.updateSql";
        this.recordLog(logger, Level.DEBUG, updatePurContSql.toString(), paramList, recordKey);
        DbUtil.executeBatch((Context)ctx, (String)updatePurContSql.toString(), paramList);
    }

    protected void doCheck(Context ctx, StringBuilder contractEntryIds, BizSceneEnum bizScene) throws BOSException, SQLException, ArApCommonException {
        String contractEntryIdStr = contractEntryIds.substring(0, contractEntryIds.length() - 1);
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append("SELECT DISTINCT BILL.FNUMBER as number").append("\r\n");
        checkBuilder.append(" FROM T_SM_PurContractEntry ENTRY").append("\r\n");
        checkBuilder.append(" INNER JOIN T_SM_PurContract BILL").append("\r\n");
        checkBuilder.append(" ON ENTRY.FParentID = BILL.fid").append("\r\n");
        checkBuilder.append(" WHERE ENTRY.FID IN (").append(contractEntryIdStr).append(")").append("\r\n");
        checkBuilder.append(" AND FPreReceived > FPrepayment").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurContractEntryFPreReceived.checkSql";
        this.recordLog(logger, Level.DEBUG, checkBuilder.toString(), contractEntryIdStr, recordKey);
        IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptionNum = new StringBuilder(200);
        while (checkRs.next()) {
            exceptionNum.append(checkRs.getString("number")).append(",");
        }
        String billType = this.getResource("PUR_CONTRACT_BILL");
        String fieldName = this.getResource("PRE_PAID_AMT");
        if (exceptionNum.length() > 0) {
            throw new ArApCommonException(ArApCommonException.WRITE_BACK_ERROR, new Object[]{exceptionNum.toString(), billType, fieldName});
        }
    }
}

