/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.PayRequestBillEntryCollection;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.app.writeback.handler.AbstractWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.ArApBillReverseHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class PR2APWriteBackHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.writeback.handler.impl.PR2APWriteBackHandler");

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (destBillInfo == null || !(destBillInfo instanceof PayRequestBillInfo)) {
            return;
        }
        PayRequestBillInfo info = (PayRequestBillInfo)destBillInfo;
        this.addSqlLockForSourceBillEntry(ctx, (IObjectValue)info, "ED4DBC81");
        this.writeBackLockAmt(ctx, info, bizAction);
        this.writeBackRequestedPayAmt(ctx, info, bizAction);
    }

    protected void writeBackLockAmt(Context ctx, PayRequestBillInfo info, BizActionEnum bizAction) throws EASBizException, BOSException {
        HashSet<BizActionEnum> lockAmtBizActionMap = new HashSet<BizActionEnum>();
        lockAmtBizActionMap.add(BizActionEnum.SAVE);
        lockAmtBizActionMap.add(BizActionEnum.SUBMIT);
        lockAmtBizActionMap.add(BizActionEnum.DELETE);
        lockAmtBizActionMap.add(BizActionEnum.CLOSE);
        lockAmtBizActionMap.add(BizActionEnum.UNCLOSE);
        if (lockAmtBizActionMap.contains((Object)bizAction)) {
            ArApBillReverseHelper.reverseArApLockAmt4PayReq(ctx, info, bizAction);
        }
    }

    protected void writeBackRequestedPayAmt(Context ctx, PayRequestBillInfo info, BizActionEnum bizAction) throws BOSException, SQLException, EASBizException {
        HashSet<BizActionEnum> requestedPayAmtBizActionMap = new HashSet<BizActionEnum>();
        requestedPayAmtBizActionMap.add(BizActionEnum.AUDIT);
        requestedPayAmtBizActionMap.add(BizActionEnum.UNAUDIT);
        requestedPayAmtBizActionMap.add(BizActionEnum.CLOSE);
        requestedPayAmtBizActionMap.add(BizActionEnum.UNCLOSE);
        if (requestedPayAmtBizActionMap.contains((Object)bizAction)) {
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            HashSet<String> otherEntryIdSet = new HashSet<String>();
            this.getWriteBackParam(ctx, info, paramList, otherEntryIdSet, bizAction);
            if (paramList.size() > 0) {
                this.doWriteBack(ctx, bizAction, paramList);
                this.doCheck(ctx, otherEntryIdSet, null);
            }
        }
    }

    protected void doCheck(Context ctx, Set<String> otherEntryIdSet, BizSceneEnum bizScene) throws BOSException, SQLException, EASBizException {
        String otherEntryIdStr = ListUtil.transList2String(otherEntryIdSet);
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append("SELECT DISTINCT BILL.FNUMBER as number").append("\r\n");
        checkBuilder.append(" FROM T_AP_OtherBillentry ENTRY").append("\r\n");
        checkBuilder.append(" INNER JOIN T_AP_OtherBill BILL").append("\r\n");
        checkBuilder.append(" ON ENTRY.FParentID = BILL.fid").append("\r\n");
        checkBuilder.append(" WHERE ENTRY.FID IN ").append(otherEntryIdStr).append("\r\n");
        checkBuilder.append(" AND abs(isnull(ENTRY.FRequestedPayAmt,0)) > abs(isnull(Entry.FRecievePayAmount,0))").append("\r\n");
        String recordKey = this.getClass() + ".writeBackOtherEntryEntryRequestedPayAmt.checkSql";
        this.recordLog(logger, Level.DEBUG, checkBuilder.toString(), otherEntryIdStr, recordKey);
        IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptionNum = new StringBuilder(200);
        while (checkRs.next()) {
            exceptionNum.append(checkRs.getString("number")).append(",");
        }
        String billType = this.getResource("AP_OTHER_BILL");
        String fieldName = this.getResource("REQUESTED_PAY_AMT");
        if (exceptionNum.length() > 0) {
            throw new ArApCommonException(ArApCommonException.WRITE_BACK_ERROR, new Object[]{exceptionNum.toString(), billType, fieldName});
        }
    }

    protected void doWriteBack(Context ctx, BizActionEnum bizAction, List<Object[]> paramList) throws BOSException {
        String payAmtSymbol = BizActionEnum.AUDIT.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction) ? "+" : "-";
        StringBuilder updateBuilder = new StringBuilder(200);
        updateBuilder.append(" UPDATE T_AP_OTHERBILLEntry SET ").append("\r\n");
        updateBuilder.append("FRequestedPayAmt = isnull(FRequestedPayAmt,0) ").append(payAmtSymbol).append(" ? ").append("\r\n");
        updateBuilder.append(" WHERE FID = ?");
        String recordKey = this.getClass() + ".writeBackOtherBillEntryFRequestedPayAmt.updateSql";
        this.recordLog(logger, Level.DEBUG, updateBuilder.toString(), paramList, recordKey);
        DbUtil.executeBatch((Context)ctx, (String)updateBuilder.toString(), paramList);
    }

    protected void getWriteBackParam(Context ctx, PayRequestBillInfo info, List<Object[]> paramList, Set otherEntryIds, BizActionEnum bizAction) throws BOSException, SQLException {
        boolean isCloseOrUnClose;
        HashSet<String> entryIdSet = new HashSet<String>();
        boolean bl = isCloseOrUnClose = BizActionEnum.CLOSE.equals((Object)bizAction) || BizActionEnum.UNCLOSE.equals((Object)bizAction);
        if (isCloseOrUnClose) {
            PayRequestBillEntryCollection coll = info.getEntrys();
            for (int i = 0; i < coll.size(); ++i) {
                entryIdSet.add(coll.get(i).getId().toString());
            }
        }
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT otherEntry.fid as otherEntryId ,").append("\r\n");
        if (isCloseOrUnClose) {
            selectBuilder.append("sum(payReqEntry.FAuditAmount - payReqEntry.FTotalPayAmt) as AMOUNT ").append("\r\n");
        } else {
            selectBuilder.append("sum(payReqEntry.FAuditAmount) as AMOUNT ").append("\r\n");
        }
        selectBuilder.append(" FROM T_AP_PayRequestBillEntry payReqEntry").append("\r\n");
        selectBuilder.append(" INNER JOIN T_AP_OtherbillEntry otherEntry").append("\r\n");
        selectBuilder.append(" ON payReqEntry.FSOURCEBILLENTRYID = otherEntry.fid").append("\r\n");
        if (isCloseOrUnClose) {
            selectBuilder.append(" WHERE payReqEntry.fid in (").append(ArApBillHelper.ids2SqlString(entryIdSet)).append(")").append("\r\n");
        } else {
            selectBuilder.append(" WHERE payReqEntry.FParentID = '").append(info.getId().toString()).append("'").append("\r\n");
        }
        selectBuilder.append(" GROUP BY otherEntry.FID").append("\r\n");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString());
        BigDecimal thisAmt = BigDecimal.ZERO;
        String otherEntryId = "";
        HashMap<String, BigDecimal> srcAmtMap = new HashMap<String, BigDecimal>();
        while (rowSet.next()) {
            thisAmt = rowSet.getBigDecimal("AMOUNT");
            otherEntryId = rowSet.getString("otherEntryId");
            paramList.add(new Object[]{thisAmt, otherEntryId});
            otherEntryIds.add(otherEntryId);
            srcAmtMap.put(otherEntryId, thisAmt);
        }
    }
}

