/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.app.writeback.handler.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.app.writeback.handler.AbstractWriteBackHandler;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizActionEnum;
import com.kingdee.eas.fi.arap.app.writeback.handler.BizSceneEnum;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Refund4PurContractHandler
extends AbstractWriteBackHandler {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.app.writeback.handler.impl.Refund4SaleContractHandler");

    @Override
    protected void doHandle(Context ctx, BizActionEnum bizAction, BizSceneEnum bizScene, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        if (null == destBillInfo) {
            return;
        }
        if (BizSceneEnum.PRE_RECPAY_SCENE.equals((Object)bizScene)) {
            this.writeBackBillPrePayAmt(ctx, bizAction, destBillInfo);
        }
    }

    private void writeBackBillPrePayAmt(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo) throws EASBizException, BOSException, SQLException {
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        HashSet<String> srcIds = new HashSet<String>();
        this.getWriteBackParam(ctx, bizAction, destBillInfo, paramList, srcIds, false);
        this.getWriteBackParam(ctx, bizAction, destBillInfo, paramList, srcIds, true);
        if (0 == paramList.size()) {
            return;
        }
        this.doWriteBack(ctx, bizAction, paramList);
        boolean allowed = this.getCheckParamValue(ctx, destBillInfo);
        if (!allowed) {
            this.doCheck(ctx, srcIds);
        }
    }

    protected void getWriteBackParam(Context ctx, BizActionEnum bizAction, IObjectValue destBillInfo, List<Object[]> paramList, Set<String> srcIds, boolean isIncludeReq) throws BOSException, SQLException, EASBizException {
        StringBuilder selectBuilder = new StringBuilder(300);
        selectBuilder.append("SELECT purConEntry.FID as SRCID").append("\r\n");
        selectBuilder.append(" \t,sum(redEntry.FAMOUNT) as AMOUNT").append("\r\n");
        selectBuilder.append(" \t,sum(redEntry.FLOCALAMOUNT) as AMOUNTLOC").append("\r\n");
        selectBuilder.append(" FROM T_CAS_PAYMENTBILLENTRY redEntry").append("\r\n");
        selectBuilder.append(" INNER JOIN T_CAS_PAYMENTBILLENTRY blueEntry").append("\r\n");
        selectBuilder.append(" ON redEntry.FSOURCEBILLENTRYID = blueEntry.FID").append("\r\n");
        if (isIncludeReq) {
            selectBuilder.append(" INNER JOIN T_AP_PayRequestBillEntry payReqEntry").append("\r\n");
            selectBuilder.append(" ON blueEntry.FSOURCEBILLENTRYID = payReqEntry.FID").append("\r\n");
        }
        selectBuilder.append(" INNER JOIN T_SM_PurContractEntry purConEntry").append("\r\n");
        if (isIncludeReq) {
            selectBuilder.append(" ON payReqEntry.FSOURCEBILLENTRYID = purConEntry.FID").append("\r\n");
        } else {
            selectBuilder.append(" ON blueEntry.FSOURCEBILLENTRYID = purConEntry.FID").append("\r\n");
        }
        selectBuilder.append(" WHERE redEntry.FPAYMENTBILLID = ?").append("\r\n");
        selectBuilder.append(" GROUP BY purConEntry.FID").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurContractEntryPrePayAmt.selectSql";
        Object[] params = new Object[]{destBillInfo.getString("id")};
        this.recordLog(logger, Level.DEBUG, selectBuilder.toString(), params, recordKey);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)selectBuilder.toString(), (Object[])params);
        BigDecimal thisAmt = BigDecimal.ZERO;
        String srcId = "";
        HashMap<String, BigDecimal> srcAmtMap = new HashMap<String, BigDecimal>();
        while (rowSet.next()) {
            thisAmt = rowSet.getBigDecimal("AMOUNT");
            srcId = rowSet.getString("SRCID");
            paramList.add(new Object[]{thisAmt, thisAmt, srcId});
            srcIds.add(srcId);
            srcAmtMap.put(srcId, thisAmt);
        }
    }

    protected void doWriteBack(Context ctx, BizActionEnum bizAction, List<Object[]> paramList) throws BOSException {
        String plus = BizActionEnum.PAY.equals((Object)bizAction) ? "+" : "-";
        StringBuilder updateBuilder = new StringBuilder(200);
        updateBuilder.append(" UPDATE T_SM_PurContractEntry SET ");
        updateBuilder.append(" FPreReceived = isnull(FPreReceived,0) ").append(plus).append(" ? ");
        updateBuilder.append(" ,FUnPrereceivedAm = isnull(FPrepayment,0) - (isnull(FPreReceived,0) ").append(plus).append(" ? )");
        updateBuilder.append("WHERE FID = ?");
        String recordKey = this.getClass() + ".writeBackPurContractEntryPrePayAmt.updateSql";
        this.recordLog(logger, Level.DEBUG, updateBuilder.toString(), paramList, recordKey);
        DbUtil.executeBatch((Context)ctx, (String)updateBuilder.toString(), paramList);
    }

    protected void doCheck(Context ctx, Set<String> srcIds) throws BOSException, SQLException, ArApCommonException {
        if (srcIds.size() == 0) {
            return;
        }
        String srcIdStr = ListUtil.transList2String(srcIds);
        StringBuilder checkBuilder = new StringBuilder(300);
        checkBuilder.append("SELECT distinct BILL.FNUMBER as number,bill.fid as fid").append("\r\n");
        checkBuilder.append(" FROM T_SM_PurContract bill").append("\r\n");
        checkBuilder.append(" INNER JOIN T_SM_PurContractEntry entry").append("\r\n");
        checkBuilder.append(" on  entry.FParentID = bill.fid").append("\r\n");
        checkBuilder.append(" WHERE entry.FID IN ").append(srcIdStr).append("").append("\r\n");
        checkBuilder.append(" AND entry.FPreReceived > entry.FPrepayment").append("\r\n");
        String recordKey = this.getClass() + ".writeBackPurContractEntryPrePayAmt.checkSql";
        this.recordLog(logger, Level.DEBUG, checkBuilder.toString(), srcIdStr, recordKey);
        IRowSet checkRs = DbUtil.executeQuery((Context)ctx, (String)checkBuilder.toString());
        StringBuilder exceptionNum = new StringBuilder(200);
        while (checkRs.next()) {
            exceptionNum.append(checkRs.getString("number")).append(",");
        }
        if (exceptionNum.length() > 0) {
            String billType = this.getResource("PUR_CONTRACT_BILL");
            String fieldName = this.getResource("PRE_PAID_AMT");
            throw new ArApCommonException(ArApCommonException.WRITE_BACK_ERROR, new Object[]{exceptionNum.toString(), billType, fieldName});
        }
    }

    @Override
    protected boolean getCheckParamValue(Context ctx, IObjectValue billInfo) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)billInfo.getObjectValue("company");
        boolean allowed = ArApParamHelper.isPrePayAmtCanOverPurContractAmt(ctx, companyInfo.getId().toString());
        return allowed;
    }
}

