/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCommonException;
import com.kingdee.eas.fi.arap.ARAPVerifynException;
import com.kingdee.eas.fi.arap.billValidator.BillValidateConfigInfo;
import com.kingdee.eas.fi.arap.billValidator.CompareBillFilterEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.CompareBillFilterEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.MatchFieldEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.MatchFieldEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateBillFilterEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.ValidateBillFilterEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigCache;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigCacheSynFactory;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigStatus;
import com.kingdee.eas.fi.arap.billValidator.app.AbstractBillValidateConfigControllerBean;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class BillValidateConfigControllerBean
extends AbstractBillValidateConfigControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.billValidator.app.BillValidateConfigControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BillValidateConfigInfo configInfo = (BillValidateConfigInfo)model;
        this.removeEmptyEntry(configInfo);
        this.validateConfigInfo(ctx, configInfo);
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BillValidateConfigInfo configInfo = (BillValidateConfigInfo)model;
        this.removeEmptyEntry(configInfo);
        this.validateConfigInfo(ctx, configInfo);
        return super._submit(ctx, model);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BillValidateConfigInfo configInfo = (BillValidateConfigInfo)model;
        configInfo.setStatus(ValidateConfigStatus.ENABLE);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("status");
        this.updatePartial(ctx, configInfo, selector);
        ValidateConfigCacheSynFactory.getInstance().addCache(configInfo);
        ValidateConfigCache.localAddCache(configInfo);
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BillValidateConfigInfo configInfo = (BillValidateConfigInfo)model;
        configInfo.setStatus(ValidateConfigStatus.DISABLE);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("status");
        this.updatePartial(ctx, configInfo, selector);
        ValidateConfigCacheSynFactory.getInstance().removeCache(configInfo);
        ValidateConfigCache.localRemoveCache(configInfo);
    }

    protected void validateConfigInfo(Context ctx, BillValidateConfigInfo configInfo) throws BOSException, EASBizException {
        int i;
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)configInfo.getBOSType());
        if (ValidateConfigStatus.ENABLE.equals((Object)configInfo.getStatus())) {
            throw new ArApCommonException(ArApCommonException.CONFIG_USED_CANNOT_EDIT);
        }
        String[] verifyObjFieldArr = new String[]{"orgUnit", "validateBill", "validatePoint", "validateLevel", "compareBill"};
        for (int i2 = 0; i2 < verifyObjFieldArr.length; ++i2) {
            if (configInfo.get(verifyObjFieldArr[i2]) != null) continue;
            throw new ArApCommonException(ArApCommonException.CAN_NOT_NULL, new Object[]{entity.getPropertyByName(verifyObjFieldArr[i2]).getAlias()});
        }
        String[] verifyStrFieldArr = new String[]{"name", "number"};
        for (int i3 = 0; i3 < verifyStrFieldArr.length; ++i3) {
            if (!StringUtils.isEmpty((String)configInfo.getString(verifyStrFieldArr[i3]))) continue;
            throw new ArApCommonException(ArApCommonException.CAN_NOT_NULL, new Object[]{entity.getPropertyByName(verifyStrFieldArr[i3]).getAlias()});
        }
        EntityObjectInfo configEntity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)new ValidateConfigEntryInfo().getBOSType());
        for (int i4 = 0; i4 < configInfo.getValidateConfigEntry().size(); ++i4) {
            ValidateConfigEntryInfo configEntryInfo = configInfo.getValidateConfigEntry().get(i4);
            if (StringUtils.isEmpty((String)((String)configEntryInfo.get("validateField")))) {
                throw new ArApCommonException(ArApCommonException.CAN_NOT_NULL, new Object[]{configEntity.getPropertyByName("validateField").getAlias()});
            }
            if (!StringUtils.isEmpty((String)((String)configEntryInfo.get("compareField")))) continue;
            throw new ArApCommonException(ArApCommonException.CAN_NOT_NULL, new Object[]{configEntity.getPropertyByName("compareField").getAlias()});
        }
        EntityObjectInfo matchEntity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)new MatchFieldEntryInfo().getBOSType());
        for (int i5 = 0; i5 < configInfo.getMatchFieldEntry().size(); ++i5) {
            MatchFieldEntryInfo matchEntryInfo = configInfo.getMatchFieldEntry().get(i5);
            if (StringUtils.isEmpty((String)((String)matchEntryInfo.get("validateField")))) {
                throw new ArApCommonException(ArApCommonException.CAN_NOT_NULL, new Object[]{matchEntity.getPropertyByName("validateField").getAlias()});
            }
            if (!StringUtils.isEmpty((String)((String)matchEntryInfo.get("compareField")))) continue;
            throw new ArApCommonException(ArApCommonException.CAN_NOT_NULL, new Object[]{matchEntity.getPropertyByName("compareField").getAlias()});
        }
        EntityObjectInfo comFilterEntity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)new CompareBillFilterEntryInfo().getBOSType());
        for (int i6 = 0; i6 < configInfo.getCompareBillFilterEntry().size(); ++i6) {
            CompareBillFilterEntryInfo comFilterEntryInfo = configInfo.getCompareBillFilterEntry().get(i6);
            if (!StringUtils.isEmpty((String)comFilterEntryInfo.getField())) continue;
            throw new ArApCommonException(ArApCommonException.CAN_NOT_NULL, new Object[]{comFilterEntity.getPropertyByName("fieldName").getAlias()});
        }
        EntityObjectInfo valFilterEntity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)new ValidateBillFilterEntryInfo().getBOSType());
        for (int i7 = 0; i7 < configInfo.getValidateBillFilterEntry().size(); ++i7) {
            ValidateBillFilterEntryInfo valFilterEntryInfo = configInfo.getValidateBillFilterEntry().get(i7);
            if (!StringUtils.isEmpty((String)valFilterEntryInfo.getField())) continue;
            throw new ArApCommonException(ArApCommonException.CAN_NOT_NULL, new Object[]{valFilterEntity.getPropertyByName("fieldName").getAlias()});
        }
        this.verifyFilterEntry(ctx, (IObjectCollection)configInfo.getValidateBillFilterEntry());
        this.verifyFilterEntry(ctx, (IObjectCollection)configInfo.getCompareBillFilterEntry());
        Map entryFieldMap = configInfo.getValEntryPrefix(ctx);
        String valEntryField = (String)entryFieldMap.get(BillValidateConfigInfo.VAL);
        String comEntryField = (String)entryFieldMap.get(BillValidateConfigInfo.COMP);
        HashSet<String> valHeadFields = new HashSet<String>();
        HashSet<String> valEntryFields = new HashSet<String>();
        HashSet<String> comHeadFields = new HashSet<String>();
        HashSet<String> comEntryFields = new HashSet<String>();
        for (i = 0; i < configInfo.getValidateConfigEntry().size(); ++i) {
            ValidateConfigEntryInfo configEntry = configInfo.getValidateConfigEntry().get(i);
            if (configEntry.getValidateField().startsWith(valEntryField + ".")) {
                valEntryFields.add(configEntry.getValidateField());
            } else {
                valHeadFields.add(configEntry.getValidateField());
            }
            if (configEntry.getCompareField().startsWith(comEntryField + ".")) {
                comEntryFields.add(configEntry.getCompareField());
                continue;
            }
            comHeadFields.add(configEntry.getCompareField());
        }
        for (i = 0; i < configInfo.getMatchFieldEntry().size(); ++i) {
            MatchFieldEntryInfo matchEntry = configInfo.getMatchFieldEntry().get(i);
            if (matchEntry.getValidateField().startsWith(valEntryField + ".") && valHeadFields.size() > 0) {
                throw new ArApCommonException(ARAPVerifynException.COMMON, new Object[]{"\u6821\u9a8c\u5355\u636e\u6821\u9a8c\u4e86\u5355\u5934\u5b57\u6bb5\uff0c\u4e0d\u80fd\u518d\u5df2\u5206\u5f55\u5b57\u6bb5\u4f5c\u4e3a\u5339\u914d\u6761\u4ef6\uff0c\u591a\u5206\u5f55\u573a\u666f\u4e0b\u4f1a\u5bfc\u81f4\u6821\u9a8c\u4e0d\u51c6\u786e"});
            }
            if (!matchEntry.getCompareField().startsWith(valEntryField + ".") || comHeadFields.size() <= 0) continue;
            throw new ArApCommonException(ARAPVerifynException.COMMON, new Object[]{"\u6bd4\u8f83\u5355\u636e\u6821\u9a8c\u4e86\u5355\u5934\u5b57\u6bb5\uff0c\u4e0d\u80fd\u518d\u5df2\u5206\u5f55\u5b57\u6bb5\u4f5c\u4e3a\u5339\u914d\u6761\u4ef6\uff0c\u591a\u5206\u5f55\u573a\u666f\u4e0b\u4f1a\u5bfc\u81f4\u6821\u9a8c\u4e0d\u51c6\u786e"});
        }
    }

    protected void verifyFilterEntry(Context ctx, IObjectCollection filterEntryColl) throws BOSException, EASBizException {
        StringBuilder filterStr = new StringBuilder(100);
        for (int i = 0; i < filterEntryColl.size(); ++i) {
            IObjectValue filterEntryInfo = filterEntryColl.getObject(i);
            filterStr.append(filterEntryInfo.getString("leftBrackets")).append(filterEntryInfo.getString("field")).append(filterEntryInfo.getString("compareType")).append(filterEntryInfo.getString("compareValue")).append(filterEntryInfo.getString("rightBrackets")).append(filterEntryInfo.getString("logicSign"));
        }
        int bracketCount = 0;
        for (int i = 0; i < filterStr.length(); ++i) {
            if ("(".equals(Character.valueOf(filterStr.charAt(i)))) {
                ++bracketCount;
            } else if (")".equals(Character.valueOf(filterStr.charAt(i)))) {
                --bracketCount;
            }
            if (bracketCount >= 0) continue;
            throw new ArApCommonException(ArApCommonException.BRACKET_ERROR, new Object[]{filterStr});
        }
        if (bracketCount > 0) {
            throw new ArApCommonException(ArApCommonException.BRACKET_ERROR, new Object[]{filterStr});
        }
    }

    protected void removeEmptyEntry(BillValidateConfigInfo configInfo) {
        ValidateConfigEntryCollection configColl = configInfo.getValidateConfigEntry();
        for (int i = configColl.size() - 1; i >= 0; --i) {
            ValidateConfigEntryInfo configEntryInfo = configColl.get(i);
            if (!StringUtils.isEmpty((String)configEntryInfo.getCompareField()) || !StringUtils.isEmpty((String)configEntryInfo.getValidateField())) continue;
            configColl.remove(configEntryInfo);
        }
        MatchFieldEntryCollection matchColl = configInfo.getMatchFieldEntry();
        for (int i = matchColl.size() - 1; i >= 0; --i) {
            MatchFieldEntryInfo matchEntryInfo = matchColl.get(i);
            if (!StringUtils.isEmpty((String)matchEntryInfo.getCompareField()) || !StringUtils.isEmpty((String)matchEntryInfo.getValidateField())) continue;
            matchColl.remove(matchEntryInfo);
        }
        ValidateBillFilterEntryCollection valFilterColl = configInfo.getValidateBillFilterEntry();
        for (int i = valFilterColl.size() - 1; i >= 0; --i) {
            ValidateBillFilterEntryInfo valFilterEntryInfo = valFilterColl.get(i);
            if (!StringUtils.isEmpty((String)valFilterEntryInfo.getField()) || !StringUtils.isEmpty((String)valFilterEntryInfo.getCompareValue())) continue;
            valFilterColl.remove(valFilterEntryInfo);
        }
        CompareBillFilterEntryCollection comFilterColl = configInfo.getCompareBillFilterEntry();
        for (int i = comFilterColl.size() - 1; i >= 0; --i) {
            CompareBillFilterEntryInfo comFilterEntryInfo = comFilterColl.get(i);
            if (!StringUtils.isEmpty((String)comFilterEntryInfo.getField()) || !StringUtils.isEmpty((String)comFilterEntryInfo.getCompareValue())) continue;
            comFilterColl.remove(comFilterEntryInfo);
        }
    }
}

