/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.billValidator.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.server.RTQuerySqlAccess;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.QueryFilterInfo;
import com.kingdee.bos.metadata.query.QueryFilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.LogicSignEnum;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.billValidator.BillActionEnum;
import com.kingdee.eas.fi.arap.billValidator.BillValidateConfigInfo;
import com.kingdee.eas.fi.arap.billValidator.BillValidateResult;
import com.kingdee.eas.fi.arap.billValidator.CompareTypeEnum;
import com.kingdee.eas.fi.arap.billValidator.MatchFieldEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.MatchFieldEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.PaySecurityLogCollection;
import com.kingdee.eas.fi.arap.billValidator.PaySecurityLogFactory;
import com.kingdee.eas.fi.arap.billValidator.PaySecurityLogInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateBillFilterEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigCache;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigEntryCollection;
import com.kingdee.eas.fi.arap.billValidator.ValidateConfigEntryInfo;
import com.kingdee.eas.fi.arap.billValidator.ValidateResultEnum;
import com.kingdee.eas.fi.arap.billValidator.app.AbstractBillValidator;
import com.kingdee.eas.fi.arap.billValidator.app.IBillValidator;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class BillValidator
extends AbstractBillValidator
implements IBillValidator {
    private String billId = null;
    private IObjectValue billInfo = null;
    private String orgField = null;
    private String action = null;
    private Context ctx = null;
    Boolean isNeedReloadBill = true;
    private Map valQueryMap = new HashMap();
    private Map comQueryMap = new HashMap();
    private Map valBillMap = new HashMap();
    private Map compBillMap = new HashMap();
    private List<BillValidateResult> validateResults = new ArrayList<BillValidateResult>();
    private Map entryFieldMap = new HashMap();
    private ScriptEngineManager engineManager = new ScriptEngineManager();
    private ScriptEngine engine;
    private static String PK_FIELD = "id";
    private static String NUMBER_FIELD = "number";

    public BillValidator(Context ctx, IObjectValue billInfo, String billId, String orgField, String action) {
        this.ctx = ctx;
        this.billId = billId;
        this.billInfo = billInfo;
        this.orgField = orgField;
        this.action = action;
        if (billInfo != null && StringUtils.isEmpty((String)billId)) {
            this.isNeedReloadBill = false;
            this.billId = billInfo.get("id").toString();
        }
    }

    @Override
    public Object getValidateRes() {
        return this.validateResults;
    }

    @Override
    protected void init() throws BOSException {
        this.engine = this.engineManager.getEngineByName("JavaScript");
    }

    @Override
    protected void initValidateBillInfo() throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)this.billId) && this.billInfo == null) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(this.orgField + ".*");
            ICoreBase iCoreBase = ArApBillUtil.getBizInterfaceByBOSUuid(this.ctx, BOSUuid.read((String)this.billId));
            this.billInfo = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(this.billId), selector);
        }
    }

    @Override
    protected void initValidateConfig() throws BOSException, EASBizException {
        Object configList = ValidateConfigCache.localGetCache(this.ctx, (OrgUnitInfo)this.billInfo.get(this.orgField), this.billInfo.getBOSType().toString());
        if (configList instanceof List) {
            BillValidateConfigInfo config;
            int i;
            this.validateConfigList = new ArrayList();
            this.validateConfigList.addAll((List)configList);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(NUMBER_FIELD);
            selector.add(this.orgField + ".*");
            ICoreBase iCoreBase = ArApBillUtil.getBizInterfaceByBOSUuid(this.ctx, BOSUuid.read((String)this.billId));
            for (i = this.validateConfigList.size() - 1; i >= 0; --i) {
                int j;
                config = (BillValidateConfigInfo)this.validateConfigList.get(i);
                if (config.getValidatePointStr().indexOf(this.action) == -1) {
                    this.validateConfigList.remove(config);
                    continue;
                }
                for (j = 0; j < config.getMatchFieldEntry().size(); ++j) {
                    selector.add(config.getMatchFieldEntry().get(j).getValidateField());
                }
                for (j = 0; j < config.getValidateConfigEntry().size(); ++j) {
                    selector.add(config.getValidateConfigEntry().get(j).getValidateField());
                }
                for (j = 0; j < config.getValidateBillFilterEntry().size(); ++j) {
                    selector.add(config.getValidateBillFilterEntry().get(j).getField());
                }
                this.entryFieldMap.put(config.getId(), config.getValEntryPrefix(this.ctx));
            }
            if (selector.size() > 0 && this.isNeedReloadBill.booleanValue()) {
                this.billInfo = iCoreBase.getValue((IObjectPK)new ObjectUuidPK(this.billId), selector);
            }
            block8: for (i = this.validateConfigList.size() - 1; i >= 0; --i) {
                config = (BillValidateConfigInfo)this.validateConfigList.get(i);
                Map fieldMap = (Map)this.entryFieldMap.get(config.getId());
                String valField = (String)fieldMap.get(BillValidateConfigInfo.VAL);
                StringBuilder expr = new StringBuilder();
                if (StringUtils.isEmpty((String)valField)) {
                    for (int k = 0; k < config.getValidateBillFilterEntry().size(); ++k) {
                        ValidateBillFilterEntryInfo filterEntry = config.getValidateBillFilterEntry().get(k);
                        expr.append(filterEntry.getLeftBrackets());
                        expr.append(this.transFilterInfo2Expr(filterEntry, ArApBillUtil.getFieldFromBill(this.billInfo, filterEntry.getField(), null)));
                        expr.append(filterEntry.getRightBrackets());
                        if (filterEntry.getLogicSign() == null) continue;
                        if (filterEntry.getLogicSign().equals((Object)LogicSignEnum.AND)) {
                            expr.append(" && ");
                            continue;
                        }
                        if (!filterEntry.getLogicSign().equals((Object)LogicSignEnum.OR)) continue;
                        expr.append(" || ");
                    }
                    try {
                        if (StringUtils.isEmpty((String)expr.toString()) || ((Boolean)this.engine.eval(expr.toString())).booleanValue()) continue;
                        this.validateConfigList.remove(config);
                        continue;
                    }
                    catch (Exception e) {
                        throw new BOSException("\u65b9\u6848" + config.getName() + "\u6821\u9a8c\u5355\u636e\u8fc7\u6ee4\u6761\u4ef6\u89e3\u6790\u9519\u8bef");
                    }
                }
                for (int j = 0; j < ((IObjectCollection)this.billInfo.get(valField)).size(); ++j) {
                    expr.setLength(0);
                    for (int k = 0; k < config.getValidateBillFilterEntry().size(); ++k) {
                        ValidateBillFilterEntryInfo filterEntry = config.getValidateBillFilterEntry().get(k);
                        expr.append(filterEntry.getLeftBrackets());
                        expr.append(this.transFilterInfo2Expr(filterEntry, ArApBillUtil.getFieldFromBill(this.billInfo, filterEntry.getField(), j)));
                        expr.append(filterEntry.getRightBrackets());
                        if (filterEntry.getLogicSign() == null) continue;
                        if (filterEntry.getLogicSign().equals((Object)LogicSignEnum.AND)) {
                            expr.append(" && ");
                            continue;
                        }
                        if (!filterEntry.getLogicSign().equals((Object)LogicSignEnum.OR)) continue;
                        expr.append(" || ");
                    }
                    try {
                        if (StringUtils.isEmpty((String)expr.toString()) || ((Boolean)this.engine.eval(expr.toString())).booleanValue()) continue;
                        this.validateConfigList.remove(config);
                        continue block8;
                    }
                    catch (Exception e) {
                        throw new BOSException("\u65b9\u6848" + config.getName() + "\u6821\u9a8c\u5355\u636e\u8fc7\u6ee4\u6761\u4ef6\u89e3\u6790\u9519\u8bef");
                    }
                }
            }
        } else {
            this.validateConfigList = null;
        }
    }

    private String transFilterInfo2Expr(ValidateBillFilterEntryInfo filterInfo, Object compareValue) {
        StringBuilder res = new StringBuilder();
        String compareSign = "";
        compareSign = filterInfo.getCompareType().equals((Object)CompareTypeEnum.NOTEQUALS) ? "!=" : (filterInfo.getCompareType().equals((Object)CompareTypeEnum.IS) ? "== null" : (filterInfo.getCompareType().equals((Object)CompareTypeEnum.ISNOT) ? "!= null" : (filterInfo.getCompareType().equals((Object)CompareTypeEnum.EQUALS) ? "==" : filterInfo.getCompareType().getValue())));
        if (compareValue instanceof String) {
            res.append("'").append(filterInfo.getCompareValue()).append("'");
            res.append(compareSign);
            res.append("'").append(compareValue).append("'");
        } else {
            res.append(filterInfo.getCompareValue()).append(compareSign).append(compareValue);
        }
        return res.toString();
    }

    @Override
    protected void initQueryInfo() throws BOSException, EASBizException {
        EntityObjectInfo valEntity = null;
        EntityObjectInfo comEntity = null;
        for (int i = 0; i < this.validateConfigList.size(); ++i) {
            int j;
            BillValidateConfigInfo config = (BillValidateConfigInfo)this.validateConfigList.get(i);
            if (valEntity == null) {
                valEntity = MetaDataLoader.getEntity((Context)this.ctx, (BOSObjectType)new BOSObjectType(config.getValidateBill().getValue()));
            }
            if (comEntity == null || comEntity != null && !comEntity.getBOSType().equals((Object)config.getCompareBill().getValue())) {
                comEntity = MetaDataLoader.getEntity((Context)this.ctx, (BOSObjectType)new BOSObjectType(config.getCompareBill().getValue()));
            }
            JoinQueryInfo valQuery = new JoinQueryInfo();
            JoinQueryInfo comQuery = new JoinQueryInfo();
            valQuery.setBizUnitPK(valEntity.getBizUnitPK());
            comQuery.setBizUnitPK(comEntity.getBizUnitPK());
            SubEntityInfo valSubEntity = new SubEntityInfo((QueryInfo)valQuery, valEntity);
            SubEntityInfo comSubEntity = new SubEntityInfo((QueryInfo)comQuery, comEntity);
            Map fieldMap = (Map)this.entryFieldMap.get(config.getId());
            String valField = (String)fieldMap.get(BillValidateConfigInfo.VAL);
            String comField = (String)fieldMap.get(BillValidateConfigInfo.COMP);
            ArApBillUtil.addSubEntityByField(valQuery, valSubEntity, PK_FIELD, true);
            ArApBillUtil.addSubEntityByField(comQuery, comSubEntity, PK_FIELD, true);
            if (!StringUtils.isEmpty((String)valField)) {
                ArApBillUtil.addSubEntityByField(valQuery, valSubEntity, valField + "." + PK_FIELD, true);
            }
            if (!StringUtils.isEmpty((String)comField)) {
                ArApBillUtil.addSubEntityByField(comQuery, comSubEntity, comField + "." + PK_FIELD, true);
            }
            valQuery.getSubObjects().add((SubObjectInfo)valSubEntity);
            comQuery.getSubObjects().add((SubObjectInfo)comSubEntity);
            for (j = 0; j < config.getValidateConfigEntry().size(); ++j) {
                ValidateConfigEntryInfo configEntry = config.getValidateConfigEntry().get(j);
                ArApBillUtil.addSubEntityByField(valQuery, valSubEntity, configEntry.getValidateField(), true);
                ArApBillUtil.addSubEntityByField(comQuery, comSubEntity, configEntry.getCompareField(), true);
            }
            for (j = 0; j < config.getMatchFieldEntry().size(); ++j) {
                MatchFieldEntryInfo matchEntry = config.getMatchFieldEntry().get(j);
                ArApBillUtil.addSubEntityByField(valQuery, valSubEntity, matchEntry.getValidateField(), true);
                ArApBillUtil.addSubEntityByField(comQuery, comSubEntity, matchEntry.getCompareField(), true);
            }
            FilterInfo valFilter = config.getValFilter(this.billInfo);
            QueryFilterInfo valQueryFilter = new QueryFilterInfo();
            for (int j2 = 0; j2 < valFilter.getFilterItems().size(); ++j2) {
                FilterItemInfo filterItem = valFilter.getFilterItems().get(j2);
                QueryFilterItemInfo queryFilterItem = new QueryFilterItemInfo(valQueryFilter, filterItem.getPropertyName(), filterItem.getCompareValue());
                queryFilterItem.setCompareType(filterItem.getCompareType());
                valQueryFilter.getFilterItems().add(queryFilterItem);
                ArApBillUtil.addSubEntityByField(valQuery, valSubEntity, filterItem.getPropertyName(), false);
            }
            valQueryFilter.setFormulaString(valFilter.getMaskString());
            valQuery.setDefaultFilter(valQueryFilter);
            FilterInfo comFilter = config.getCompFilter(this.billInfo);
            QueryFilterInfo comQueryFilter = new QueryFilterInfo();
            for (int j3 = 0; j3 < comFilter.getFilterItems().size(); ++j3) {
                FilterItemInfo filterItem = comFilter.getFilterItems().get(j3);
                QueryFilterItemInfo queryFilterItem = new QueryFilterItemInfo(comQueryFilter, filterItem.getPropertyName(), filterItem.getCompareValue());
                queryFilterItem.setCompareType(filterItem.getCompareType());
                comQueryFilter.getFilterItems().add(queryFilterItem);
                ArApBillUtil.addSubEntityByField(comQuery, comSubEntity, filterItem.getPropertyName(), false);
            }
            comQueryFilter.setFormulaString(comFilter.getMaskString());
            comQuery.setDefaultFilter(comQueryFilter);
            this.valQueryMap.put(config.getId(), valQuery);
            this.comQueryMap.put(config.getId(), comQuery);
        }
    }

    @Override
    protected void getValBillColl() throws BOSException {
        for (Object id : this.valQueryMap.keySet()) {
            JoinQueryInfo query = (JoinQueryInfo)this.valQueryMap.get(id);
            RTQuerySqlAccess qsa = new RTQuerySqlAccess(this.ctx, (QueryInfo)query);
            try {
                String sql = qsa.getSql();
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                this.valBillMap.put(id, rs);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    @Override
    protected void getCompBillColl() throws BOSException {
        for (Object id : this.comQueryMap.keySet()) {
            JoinQueryInfo query = (JoinQueryInfo)this.comQueryMap.get(id);
            RTQuerySqlAccess qsa = new RTQuerySqlAccess(this.ctx, (QueryInfo)query);
            try {
                String sql = qsa.getSql();
                IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
                this.compBillMap.put(id, rs);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private void buildRowSetMap(IRowSet rs, BillValidateConfigInfo config, String entryField, Map billIDMap, Map billEntryIDMap, Map bigDecimalGroupMap, Boolean isMainBill) throws BOSException {
        ValidateConfigEntryCollection configColl = config.getValidateConfigEntry();
        MatchFieldEntryCollection matchColl = config.getMatchFieldEntry();
        String entryPk = null;
        try {
            while (rs.next()) {
                String key = "";
                for (int j = 0; j < matchColl.size(); ++j) {
                    MatchFieldEntryInfo matchInfo = matchColl.get(j);
                    key = isMainBill != false ? key + rs.getString(matchInfo.getValidateField()) + "_" : key + rs.getString(matchInfo.getCompareField()) + "_";
                }
                Boolean isValEntryField = false;
                for (int j = 0; j < configColl.size(); ++j) {
                    Map<String, BigDecimal> bigDecimalMap;
                    ValidateConfigEntryInfo configEntry = configColl.get(j);
                    String field = configEntry.getValidateField();
                    if (!isMainBill.booleanValue()) {
                        field = configEntry.getCompareField();
                    }
                    if (!field.startsWith(entryField + ".")) {
                        if (billIDMap.get(key) != null && ((Set)billIDMap.get(key)).contains(rs.getString(PK_FIELD))) {
                            continue;
                        }
                    } else {
                        isValEntryField = true;
                    }
                    if (bigDecimalGroupMap.get(configEntry.getId()) != null) {
                        bigDecimalMap = (Map)bigDecimalGroupMap.get(configEntry.getId());
                        BigDecimal num = BigDecimal.ZERO;
                        if (bigDecimalMap.get(key) != null) {
                            num = (BigDecimal)bigDecimalMap.get(key);
                        }
                        num = num.add(rs.getBigDecimal(field));
                        bigDecimalMap.put(key, num);
                        bigDecimalGroupMap.put(configEntry.getId(), bigDecimalMap);
                        continue;
                    }
                    bigDecimalMap = new HashMap<String, BigDecimal>();
                    bigDecimalMap.put(key, rs.getBigDecimal(field));
                    bigDecimalGroupMap.put(configEntry.getId(), bigDecimalMap);
                }
                if (billIDMap.get(key) != null) {
                    ((Set)billIDMap.get(key)).add(rs.getString(PK_FIELD));
                } else {
                    HashSet<String> idSet = new HashSet<String>();
                    idSet.add(rs.getString(PK_FIELD));
                    billIDMap.put(key, idSet);
                }
                if (StringUtils.isEmpty((String)entryField) || !isValEntryField.booleanValue()) continue;
                entryPk = entryField + "." + PK_FIELD;
                if (billEntryIDMap.get(key) != null) {
                    ((Set)billEntryIDMap.get(key)).add(rs.getString(entryPk));
                    continue;
                }
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(rs.getString(entryPk));
                billEntryIDMap.put(key, idSet);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void buildValBillMap(Map mainBigDecimalMap, BillValidateConfigInfo config, String entryField, Map billIDMap, Map billEntryIDMap) {
        HashMap billMap = new HashMap();
        IObjectCollection entryColl = (IObjectCollection)this.billInfo.get(entryField);
        for (int i = 0; i < entryColl.size(); ++i) {
            String key = "";
            for (int j = 0; j < config.getMatchFieldEntry().size(); ++j) {
                key = key + ArApBillUtil.getFieldFromBill(this.billInfo, config.getMatchFieldEntry().get(j).getValidateField(), i) + "_";
            }
            Boolean isValEntryField = false;
            for (int j = 0; j < config.getValidateConfigEntry().size(); ++j) {
                Map<String, BigDecimal> groupMap;
                ValidateConfigEntryInfo configEntry = config.getValidateConfigEntry().get(j);
                String field = configEntry.getValidateField();
                if (field.startsWith(entryField + ".")) {
                    isValEntryField = true;
                }
                BigDecimal value = (BigDecimal)ArApBillUtil.getFieldFromBill(this.billInfo, field, i);
                if (mainBigDecimalMap.get(configEntry.getId()) == null) {
                    groupMap = new HashMap<String, BigDecimal>();
                    groupMap.put(key, value);
                    mainBigDecimalMap.put(configEntry.getId(), groupMap);
                    continue;
                }
                if (!field.startsWith(entryField + ".") && i != 0) continue;
                groupMap = (Map)mainBigDecimalMap.get(configEntry.getId());
                BigDecimal res = groupMap.get(key) == null ? BigDecimal.ZERO : (BigDecimal)groupMap.get(key);
                res = res.add(value);
                groupMap.put(key, res);
                mainBigDecimalMap.put(configEntry.getId(), groupMap);
            }
            if (billIDMap.get(key) != null) {
                ((Set)billIDMap.get(key)).add(this.billInfo.get(PK_FIELD).toString());
            } else {
                HashSet<String> idSet = new HashSet<String>();
                idSet.add(this.billInfo.get(PK_FIELD).toString());
                billIDMap.put(key, idSet);
            }
            if (!isValEntryField.booleanValue() || StringUtils.isEmpty((String)entryField)) continue;
            if (billEntryIDMap.get(key) != null) {
                ((Set)billEntryIDMap.get(key)).add(entryColl.getObject(i).get(PK_FIELD).toString());
                continue;
            }
            HashSet<String> idSet = new HashSet<String>();
            idSet.add(entryColl.getObject(i).get(PK_FIELD).toString());
            billEntryIDMap.put(key, idSet);
        }
    }

    @Override
    protected void doValidate() throws BOSException, EASBizException {
        for (int i = 0; i < this.validateConfigList.size(); ++i) {
            BillValidateConfigInfo config = (BillValidateConfigInfo)this.validateConfigList.get(i);
            if (this.compBillMap.get(config.getId()) == null) continue;
            IRowSet valRs = (IRowSet)this.valBillMap.get(config.getId());
            IRowSet comRs = (IRowSet)this.compBillMap.get(config.getId());
            if (comRs.size() == 0) continue;
            BillValidateResult res = new BillValidateResult();
            this.validateResults.add(res);
            HashMap<String, String> errorMsgMap = new HashMap<String, String>();
            HashMap<String, Set<String>> mainBillIdMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> secBillIdMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> mainBillEntryIdMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> secBillEntryIdMap = new HashMap<String, Set<String>>();
            Map entryFields = (Map)this.entryFieldMap.get(config.getId());
            String mainEntryField = (String)entryFields.get(BillValidateConfigInfo.VAL);
            String setEntryField = (String)entryFields.get(BillValidateConfigInfo.COMP);
            HashMap mainBigDecimalMap = new HashMap();
            HashMap secBigDecimalMap = new HashMap();
            this.buildRowSetMap(valRs, config, mainEntryField, mainBillIdMap, mainBillEntryIdMap, mainBigDecimalMap, true);
            this.buildRowSetMap(comRs, config, setEntryField, secBillIdMap, secBillEntryIdMap, secBigDecimalMap, false);
            this.buildValBillMap(mainBigDecimalMap, config, mainEntryField, mainBillIdMap, mainBillEntryIdMap);
            BigDecimal diff = null;
            ValidateConfigEntryInfo configEntry = null;
            StringBuilder errMsg = new StringBuilder();
            PaySecurityLogCollection secLog = new PaySecurityLogCollection();
            for (int j = 0; j < config.getValidateConfigEntry().size(); ++j) {
                configEntry = config.getValidateConfigEntry().get(j);
                diff = configEntry.getDiffRange() == null ? BigDecimal.ZERO : configEntry.getDiffRange();
                Map mainDecimalMap = (Map)mainBigDecimalMap.get(configEntry.getId());
                Map secDecimalMap = (Map)secBigDecimalMap.get(configEntry.getId());
                for (Object key : mainDecimalMap.keySet()) {
                    BigDecimal valValue = (BigDecimal)mainDecimalMap.get(key);
                    BigDecimal comValue = (BigDecimal)secDecimalMap.get(key);
                    StringBuilder errMsgEntry = new StringBuilder();
                    if (valValue.multiply(comValue).compareTo(BigDecimal.ZERO) <= 0 || valValue.abs().compareTo(comValue.add(diff).abs()) <= 0) continue;
                    errMsgEntry.append(config.getValidateBill().getAlias()).append(configEntry.getValidateFieldName());
                    errMsgEntry.append(valValue).append("\u8d85\u51fa");
                    errMsgEntry.append(config.getCompareBill().getAlias()).append(configEntry.getCompareFieldName());
                    errMsgEntry.append(comValue).append("+").append(diff);
                    errorMsgMap.put((String)key, errMsgEntry.toString());
                    errMsg.append((CharSequence)errMsgEntry);
                    errMsg.append(LoginType.GUI.equals(this.ctx.get((Object)"LOGIN_TYPE")) ? "\n" : "<br>");
                }
                PaySecurityLogInfo logInfo = new PaySecurityLogInfo();
                logInfo.setClientIP(this.ctx.getClientHostIP());
                logInfo.setCtrlBillType(config.getValidateBill());
                logInfo.setCtrlBillNum(this.billInfo.get("number").toString());
                OrgUnitInfo mainOrg = (OrgUnitInfo)this.billInfo.get(this.orgField);
                logInfo.setMainOrgId(mainOrg.getId().toString());
                logInfo.setMainOrgName(mainOrg.getName());
                logInfo.setMainOrgNum(mainOrg.getNumber());
                logInfo.setSolutionNum(config.getNumber());
                logInfo.setSolutionName(config.getName());
                logInfo.setExecuteTime(new Timestamp(System.currentTimeMillis()));
                if (errMsg.length() == 0) {
                    logInfo.setExecuteResult(ValidateResultEnum.SUCCESS);
                } else {
                    logInfo.setExecuteResult(ValidateResultEnum.FAILURE);
                    logInfo.setResultDetail(errMsg.toString());
                }
                logInfo.setBillAction(BillActionEnum.getEnum(this.action));
                secLog.add(logInfo);
            }
            PaySecurityLogFactory.getLocalInstance(this.ctx).saveSolr(secLog);
            res.setErrMsg(errMsg.toString());
            res.setErrorMsgMap(errorMsgMap);
            res.setBillValidateConfig(config);
            res.setMainBillIdMap(mainBillIdMap);
            res.setMainBillEntryIdMap(mainBillEntryIdMap);
            res.setSecBillIdMap(secBillIdMap);
            res.setSecBillEntryIdMap(secBillEntryIdMap);
        }
    }
}

