/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.check;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.check.IBatchCheck;
import com.kingdee.eas.fi.arap.check.ICheck;
import com.kingdee.eas.fi.arap.check.IFieldsCheck;
import com.kingdee.eas.fi.arap.check.IIsSameCheck;
import com.kingdee.util.StringUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class CheckService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.check.CheckService");
    public static final String ERROR_MSG = "errorMsg";
    public static final String WARN_MSG = "warnMsg";
    private List<ICheck> checker = new ArrayList<ICheck>(10);
    Context ctx = null;
    String bosType = null;
    Boolean isErrorInterrupt = false;
    List<String> idList = new ArrayList<String>();

    public CheckService(Context ctx, List<String> idList) {
        this.ctx = ctx;
        this.idList = new ArrayList<String>(new LinkedHashSet<String>(idList));
        if (idList.size() > 0) {
            this.bosType = BOSUuid.read((String)idList.get(0)).getType().toString();
        }
    }

    public void addCheck(ICheck check) {
        this.checker.add(check);
    }

    public SelectorItemCollection getSelect() {
        ICheck iCheck2 = null;
        SelectorItemCollection select = new SelectorItemCollection();
        for (ICheck iCheck2 : this.checker) {
            String[] strArr = null;
            if (iCheck2 instanceof IFieldsCheck) {
                strArr = ((IFieldsCheck)iCheck2).getField();
            } else if (iCheck2 instanceof IIsSameCheck) {
                strArr = new String[]{((IIsSameCheck)iCheck2).getField()};
            }
            if (strArr == null || strArr.length <= 0) continue;
            for (int i = 0; i < strArr.length; ++i) {
                select.add(strArr[i]);
            }
        }
        return select;
    }

    public Map<String, String> check() throws BOSException {
        HashMap<String, String> returnData = new HashMap<String, String>();
        String enter = "\n";
        IObjectCollection coll = this.getInfoCollection();
        IObjectValue info = null;
        ICheck iCheck = null;
        Boolean hasError = false;
        IBatchCheck iBatchCheck = null;
        IFieldsCheck iFieldsCheck = null;
        IIsSameCheck iIsSameCheck = null;
        StringBuilder errorMsg = new StringBuilder(100);
        StringBuilder warnMsg = new StringBuilder(100);
        StringBuilder objectNames = new StringBuilder(100);
        StringBuilder tempMsg = new StringBuilder(100);
        Iterator<ICheck> it = this.checker.iterator();
        while (it.hasNext()) {
            String number;
            tempMsg.setLength(0);
            iCheck = it.next();
            if (Boolean.TRUE.equals(this.isErrorInterrupt != false && iCheck.isErrorType() && hasError != false)) continue;
            long startTime = System.currentTimeMillis();
            if (iCheck instanceof IFieldsCheck) {
                iFieldsCheck = (IFieldsCheck)iCheck;
                objectNames.setLength(0);
                for (int i = 0; i < coll.size(); ++i) {
                    info = coll.getObject(i);
                    number = iFieldsCheck.check(this.ctx, info);
                    if (StringUtils.isEmpty((String)number)) continue;
                    objectNames.append(number).append(",");
                }
                if (objectNames.length() > 0) {
                    tempMsg.append(MessageFormat.format(iFieldsCheck.getMsg(), objectNames.substring(0, objectNames.length() - 1)));
                }
            } else if (iCheck instanceof IIsSameCheck) {
                iIsSameCheck = (IIsSameCheck)iCheck;
                if (!iIsSameCheck.check(this.ctx, coll)) {
                    tempMsg.append(iIsSameCheck.getMsg());
                }
            } else if (iCheck instanceof IBatchCheck && !StringUtils.isEmpty((String)(number = (iBatchCheck = (IBatchCheck)iCheck).check(this.ctx, this.idList)))) {
                tempMsg.append(MessageFormat.format(iBatchCheck.getMsg(), number));
            }
            if (tempMsg.length() > 0) {
                if (iCheck.isErrorType()) {
                    errorMsg.append((CharSequence)tempMsg).append(enter);
                    hasError = true;
                } else {
                    warnMsg.append((CharSequence)tempMsg).append(enter);
                }
            }
            logger.info((Object)("\u6267\u884c\u68c0\u67e5\u7c7b\uff1a" + iCheck.getClass().getName() + ",\u8017\u65f6:" + (System.currentTimeMillis() - startTime) + "ms"));
        }
        if (errorMsg.length() > 0) {
            returnData.put(ERROR_MSG, errorMsg.substring(0, errorMsg.length() - enter.length()));
        }
        if (warnMsg.length() > 0) {
            returnData.put(WARN_MSG, warnMsg.substring(0, warnMsg.length() - enter.length()));
        }
        return returnData;
    }

    private IObjectCollection getInfoCollection() throws BOSException {
        IDynamicObject IdynObj = null;
        StringBuffer oql = new StringBuffer(100);
        oql.append(" SELECT ").append(this.getSelect().toString());
        oql.append(" WHERE ID IN ").append(ListUtil.transList2String(this.idList));
        oql.append("ORDER BY NUMBER DESC");
        IdynObj = this.ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)this.ctx);
        BOSObjectType bosObjectType = BOSObjectType.create((String)this.bosType);
        IObjectCollection objectColl = IdynObj.getCollection(bosObjectType, oql.toString());
        return objectColl;
    }

    public Boolean getIsErrorInterrupt() {
        return this.isErrorInterrupt;
    }

    public void setIsErrorInterrupt(Boolean isErrorInterrupt) {
        this.isErrorInterrupt = isErrorInterrupt;
    }
}

