/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.check.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.arap.check.ICalculateCheck;
import com.kingdee.eas.fi.arap.check.ICheck;
import com.kingdee.eas.fi.arap.util.VelocityHelper;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArApCalculateSimpleCheck
implements ICalculateCheck<ArApBillBaseInfo> {
    protected final List<Integer> unPassSeqs = new ArrayList<Integer>();

    @Override
    public boolean check(ArApBillBaseInfo billInfo) throws BOSException, EASBizException {
        this.unPassSeqs.clear();
        AbstractObjectCollection entries = billInfo.getEntries();
        for (int i = 0; i < entries.size(); ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entries.getObject(i);
            this.checkEntry(entryInfo);
        }
        return this.unPassSeqs.isEmpty();
    }

    private void checkEntry(ArApBillEntryBaseInfo entry) {
        if (entry.getAmount().add(entry.getTaxAmount()).compareTo(entry.getRecievePayAmount()) != 0 || entry.getAmountLocal().add(entry.getTaxAmountLocal()).compareTo(entry.getRecievePayAmountLocal()) != 0) {
            this.unPassSeqs.add(entry.getSeq());
        }
    }

    @Override
    public ICheck prepareMessage(final String template, final Map context) {
        return new ICheck(){

            @Override
            public boolean isErrorType() {
                return false;
            }

            @Override
            public String getMsg() {
                HashMap<String, String> ctxMap = new HashMap<String, String>(context);
                ctxMap.put("unPassSeqs", StringUtils.arrayToString((Object[])ArApCalculateSimpleCheck.this.unPassSeqs.toArray(), (String)","));
                return VelocityHelper.format(template, ctxMap);
            }
        };
    }
}

