/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.electronicInvoice.eiv.method;

import com.kingdee.bos.json.Kson;
import com.kingdee.eas.fi.arap.electronicInvoice.eiv.EIVCError;
import com.kingdee.eas.fi.arap.electronicInvoice.eiv.EIVCService;
import com.kingdee.eas.fi.arap.util.H;
import com.kingdee.eas.fi.arap.util.remote.AbstractRemoteMethod;
import com.kingdee.eas.fi.arap.util.remote.exception.AfterInvokingRemoteMethodException;
import com.kingdee.eas.fi.arap.util.remote.exception.InvokingRemoteMethodException;
import com.kingdee.eas.fi.arap.util.remote.exception.ThrowReturn;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;

public abstract class AbstractEIVMethod
extends AbstractRemoteMethod {
    protected EIVCService eivs;

    public AbstractEIVMethod(EIVCService eivs) {
        this.eivs = eivs;
    }

    protected String getBaseUrl() {
        return this.eivs.baseurl;
    }

    protected int execute(HttpClient client, HttpMethod httpMethod) throws InvokingRemoteMethodException {
        int statusCode = 0;
        try {
            statusCode = client.executeMethod(httpMethod);
        }
        catch (HttpException e) {
            ThrowReturn.throwInvokingException(e, EIVCError.EIV5001);
        }
        catch (IOException e) {
            ThrowReturn.throwInvokingException(e, EIVCError.EIV5001);
        }
        if (!H.sameIn(statusCode, 200, 201, 202, 203, 204, 205, 206)) {
            if (H.sameIn(statusCode, 300, 301, 302, 303, 304, 305, 306, 307)) {
                ThrowReturn.throwInvokingException(EIVCError.EIV5003, String.format("statusCode=%d,queryString=%s", statusCode, httpMethod.getQueryString()));
            } else if (statusCode >= 400) {
                ThrowReturn.throwInvokingException(EIVCError.EIV5002, String.format("statusCode=%d,queryString=%s", statusCode, httpMethod.getQueryString()));
            } else {
                ThrowReturn.throwInvokingException(EIVCError.EIV5003, String.format("statusCode=%d,queryString=%s", statusCode, httpMethod.getQueryString()));
            }
        }
        return statusCode;
    }

    protected Map getHttpResultAsMap(HttpMethod httpMethod) throws AfterInvokingRemoteMethodException {
        try {
            String json = httpMethod.getResponseBodyAsString();
            return (Map)Kson.getGson().fromJson(json, HashMap.class);
        }
        catch (IOException e) {
            ThrowReturn.throwAfterInvokingException(e, EIVCError.EIV_TOKEN_7001);
            return null;
        }
    }
}

