/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.gpt;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.arap.gpt.model.ExceptionCheckItemInfo;
import com.kingdee.eas.fi.arap.gpt.util.DataToTableUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.IRowSetMetaData;
import com.kingdee.util.LowTimer;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class ARAPGPTCheckExceptionPrecessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.gpt.ARAPGPTCheckExceptionPrecessor");
    public static int cpus = Runtime.getRuntime().availableProcessors();
    private static Map<String, Object> cache = new HashMap<String, Object>(5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getExceptionInfo(Map params) throws BOSException {
        LowTimer timer = new LowTimer();
        logger.error((Object)("ARAPGPTCheckExceptionPrecessor.getExceptionInfo:Start : " + new Date()));
        Context ctx = (Context)params.get("bosCtx");
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, List<List<String>>> allDatas = new HashMap<String, List<List<String>>>();
        int allDatesSize = 0;
        try {
            logger.error((Object)("ARAPGPTCheckExceptionPrecessor.getExceptionInfo\u5165\u53e3\u53c2\u6570\uff1a" + params.toString()));
            String companyOrg = ARAPGPTCheckExceptionPrecessor.getStringField(params, "companyOrg");
            String billType = ARAPGPTCheckExceptionPrecessor.getStringField(params, "billType");
            String beginDate = ARAPGPTCheckExceptionPrecessor.getStringField(params, "beginDate");
            String endDate = ARAPGPTCheckExceptionPrecessor.getStringField(params, "endDate");
            String field = ARAPGPTCheckExceptionPrecessor.getStringField(params, "fieldValue");
            String billTable = ARAPGPTCheckExceptionPrecessor.checkBillType(ctx, billType);
            CompanyOrgUnitInfo companyInfo = ARAPGPTCheckExceptionPrecessor.getCompanyOrgInfo(ctx, companyOrg);
            if (companyInfo == null) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{"\u516c\u53f8\u4e0d\u80fd\u4e3a\u7a7a!"});
            }
            if (StringUtil.isEmpty((String)beginDate)) {
                throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{"\u8d77\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a!"});
            }
            List<ExceptionCheckItemInfo> checkItemList = ARAPGPTCheckExceptionPrecessor.getCheckItem(ctx, billTable, field);
            ExecutorService es = Executors.newFixedThreadPool(2 * cpus);
            try {
                int i;
                ArrayList<Future<Map>> jobResults = new ArrayList<Future<Map>>(checkItemList.size());
                for (i = 0; i < checkItemList.size(); ++i) {
                    ExceptionCheckItemInfo info = checkItemList.get(i);
                    String sql = info.getExecuteSql(ctx, companyInfo.getId().toString(), beginDate, endDate);
                    Future<Map> feture = es.submit(new checkJob(ctx, info, sql));
                    jobResults.add(feture);
                }
                for (i = 0; i < jobResults.size(); ++i) {
                    Map rptData = (Map)((Future)jobResults.get(i)).get();
                    if (rptData.isEmpty()) continue;
                    allDatas.putAll(rptData);
                    allDatesSize = allDatesSize + ((List)rptData.values().iterator().next()).size() - 1;
                }
            }
            finally {
                es.shutdown();
            }
            String exceptionDataHtml = DataToTableUtil.generateMarkdownTables(allDatas);
            result.put("exceptionDataHtml", exceptionDataHtml);
            result.put("exceptionData", JSONUtils.convertObjectToJson((Context)ctx, allDatas));
            result.put("status", "success");
            StringBuffer msg = new StringBuffer();
            msg.append("\u516c\u53f8\uff1a\u3010").append(companyInfo.getName()).append("  ").append(companyInfo.getNumber()).append("\u3011\uff0c\u4ece\uff1a").append(beginDate).append(" ~ ").append(endDate).append("\u7684\u67e5\u8be2\u7ed3\u679c:");
            if (allDatesSize > 0) {
                msg.append("\u67e5\u8be2\u5230" + allDatesSize + "\u6761\u5f02\u5e38\u6570\u636e\u3002");
            } else {
                msg.append("\u672a\u67e5\u8be2\u5230\u5f02\u5e38\u6570\u636e\u3002");
            }
            result.put("reason", msg.toString());
            logger.error((Object)("ARAPGPTCheckExceptionPrecessor.getExceptionInfo:End : " + timer.msValue() + " ms"));
        }
        catch (Exception e) {
            result.put("exceptionData", JSONUtils.convertObjectToJson((Context)ctx, allDatas));
            result.put("status", "error");
            result.put("reason", e.getMessage());
            logger.error((Object)e);
            return result;
        }
        return result;
    }

    public static String getStringField(Map params, String fieldName) {
        if (params == null) {
            return null;
        }
        String value = (String)params.get(fieldName);
        if (value == null || value.equalsIgnoreCase("null")) {
            return null;
        }
        return value;
    }

    public static CompanyOrgUnitInfo getCompanyOrgInfo(Context ctx, String companyOrg) throws BOSException {
        CompanyOrgUnitInfo companyInfo = ARAPGPTCheckExceptionPrecessor.innerGetCompanyOrgInfo(ctx, companyOrg);
        if (companyInfo == null && !StringUtil.isEmpty((String)companyOrg)) {
            companyOrg = "%" + companyOrg + "%";
            companyInfo = ARAPGPTCheckExceptionPrecessor.innerGetCompanyOrgInfo(ctx, companyOrg);
        }
        if (companyInfo == null) {
            companyInfo = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
        }
        return companyInfo;
    }

    public static CompanyOrgUnitInfo innerGetCompanyOrgInfo(Context ctx, String companyOrg) throws BOSException {
        if (StringUtil.isEmpty((String)companyOrg)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)companyOrg, CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)companyOrg, CompareType.LIKE));
        filter.setMaskString("#0 or #1");
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        CompanyOrgUnitCollection comapnyColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(ev);
        if (comapnyColl.size() > 0) {
            return comapnyColl.get(0);
        }
        return null;
    }

    public static String checkBillType(Context ctx, String billType) {
        Map billTypeMap;
        if (billType != null) {
            billType = billType.trim();
        }
        if ((billTypeMap = ARAPGPTCheckExceptionPrecessor.getBillType()).containsValue(billType)) {
            return billType;
        }
        return null;
    }

    static List<ExceptionCheckItemInfo> getCheckItem(Context ctx, String billTable, String field) throws SQLException, BOSException {
        ArrayList<ExceptionCheckItemInfo> checkItemList = new ArrayList<ExceptionCheckItemInfo>();
        StringBuffer querySql = new StringBuffer("select * from T_ARAP_GPTCHECKITEM where 1 = 1 ");
        if (!StringUtil.isEmpty((String)billTable)) {
            querySql.append(" AND upper(FTABLENAME) =  '").append(billTable.toUpperCase(Locale.ENGLISH)).append("'");
        }
        if (!StringUtil.isEmpty((String)field)) {
            querySql.append(" AND FNAME like '%" + field + "%'");
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        while (rs.next()) {
            ExceptionCheckItemInfo info = new ExceptionCheckItemInfo();
            info.setNumber(rs.getString("FNUMBER"));
            info.setName(rs.getString("FNAME"));
            info.setTableName(rs.getString("FTABLENAME"));
            info.setTableAlias(rs.getString("FTABLEAALIAS"));
            info.setSql(rs.getString("FSQL"));
            checkItemList.add(info);
        }
        return checkItemList;
    }

    public static Map getInitData(Map params) {
        HashMap<String, Object> initDataMap = new HashMap<String, Object>();
        try {
            Context ctx = (Context)params.get("bosCtx");
            Date currentDate = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String currentDateStr = simpleDateFormat.format(currentDate);
            initDataMap.put("currentDate", currentDateStr);
            initDataMap.put("billType", ARAPGPTCheckExceptionPrecessor.getBillType());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return initDataMap;
    }

    public static Map getBillType() {
        HashMap<String, String> billTypeMap = new HashMap<String, String>();
        billTypeMap.put("\u5e94\u4ed8\u5355", "T_AP_OTHERBILL");
        billTypeMap.put("\u4ed8\u6b3e\u7533\u8bf7\u5355", "T_AP_PAYREQUESTBILL");
        billTypeMap.put("\u4ed8\u6b3e\u5355", "T_CAS_PAYMENTBILL");
        return billTypeMap;
    }

    public static Map getCurrentCompanyInfo(Context ctx) throws BOSException {
        HashMap<String, String> companyMap = new HashMap<String, String>();
        CompanyOrgUnitCollection companyOrgUnitColl = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection();
        for (int i = 0; i < companyOrgUnitColl.size(); ++i) {
            CompanyOrgUnitInfo companyInfo = companyOrgUnitColl.get(i);
            if (!companyInfo.isIsBizUnit()) continue;
            companyMap.put(companyInfo.getName() + ":" + companyInfo.getNumber(), companyInfo.getId().toString());
        }
        return companyMap;
    }

    public static class checkJob
    implements Callable<Map> {
        private Context ctx;
        private String sql;
        private ExceptionCheckItemInfo checkItemInfo;

        public checkJob(Context ctx, ExceptionCheckItemInfo checkItemInfo, String sql) {
            this.ctx = ctx;
            this.sql = sql;
            this.checkItemInfo = checkItemInfo;
        }

        @Override
        public Map call() throws Exception {
            HashMap returnMap = new HashMap();
            IRowSet rs = null;
            try {
                rs = DbUtil.executeQuery((Context)this.ctx, (String)this.sql);
            }
            catch (Exception e1) {
                StringBuffer errorMsg = new StringBuffer();
                errorMsg.append("exeQueryException,checkItem number\uff1a").append(this.checkItemInfo.getNumber()).append(",name:").append(this.checkItemInfo.getName()).append("\nSQL:").append(this.checkItemInfo.getSql()).append("\n" + e1.getMessage());
                logger.error((Object)errorMsg);
                return returnMap;
            }
            ArrayList rowDatas = new ArrayList();
            IRowSetMetaData rowSetMetaData = rs.getRowSetMetaData();
            if (rs.size() > 0) {
                ArrayList<String> columnData = new ArrayList<String>();
                columnData.add("\u5e8f\u53f7");
                for (int j = 1; j <= rowSetMetaData.getColumnCount(); ++j) {
                    String fieldsName = rowSetMetaData.getColumnName(j);
                    columnData.add(fieldsName);
                }
                rowDatas.add(columnData);
            }
            int index = 0;
            while (rs.next()) {
                ArrayList<String> rowData = new ArrayList<String>();
                rowData.add(++index + "");
                for (int j = 1; j <= rowSetMetaData.getColumnCount(); ++j) {
                    String fieldsName = rowSetMetaData.getColumnName(j);
                    String value = rs.getString(fieldsName);
                    rowData.add(value);
                }
                rowDatas.add(rowData);
            }
            if (rowDatas.size() > 0) {
                returnMap.put(this.checkItemInfo.getName(), rowDatas);
            }
            return returnMap;
        }
    }
}

