/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.common.perf.app.util.MessageInfo;
import com.kingdee.eas.basedata.common.perf.app.util.MessageUtil;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.arap.invoiceMatch.IInvoiceMatchRecord;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchException;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordCollection;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordEntryCollection;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordEntryInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordFactory;
import com.kingdee.eas.fi.arap.invoiceMatch.MatchBillConfigInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.RecordMatchTypeEnum;
import com.kingdee.eas.fi.arap.invoiceMatch.app.AbstractInvoiceMatchFacadeControllerBean;
import com.kingdee.eas.fi.arap.invoiceMatch.config.AbstractConfigHelper;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import com.kingdee.eas.fi.arap.invoiceMatch.util.RecordToBillParams;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.report.util.DBUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceMatchFacadeControllerBean
extends AbstractInvoiceMatchFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.invoiceMatch.app.InvoiceMatchFacadeControllerBean");

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        Connection con = null;
        try {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            AbstractConfigHelper helper = (AbstractConfigHelper)params.getObject(MatchConstant.CONFIGHELPER);
            if (helper == null) {
                RptParams rptParams = params;
                return rptParams;
            }
            con = this.getConnection(ctx);
            String tempTable = pool.createTempTable(helper.getCreateTableSql());
            helper.setTempTable(tempTable);
            DBUtils.execute((String)helper.initTableDataSql(), (Connection)con);
            SQLUtils.cleanup((Connection)con);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new InvoiceMatchException(InvoiceMatchException.ERRORMSG, new Object[]{e.getMessage()});
        }
        finally {
            SQLUtils.cleanup(con);
        }
        return params;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        AbstractConfigHelper helper = (AbstractConfigHelper)params.getObject(MatchConstant.CONFIGHELPER);
        String querySql = helper.getQuerySql();
        RptRowSet rowSet = this.executeQuery(querySql, null, from, len, ctx);
        helper.setRowSet(rowSet);
        return params;
    }

    @Override
    protected Map _invoiceMatch(Context ctx, Map matchParams) throws BOSException, EASBizException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        AbstractConfigHelper helper = (AbstractConfigHelper)matchParams.get(MatchConstant.CONFIGHELPER);
        MatchBillConfigInfo config = helper.getConfig();
        InvoiceMatchRecordCollection records = (InvoiceMatchRecordCollection)((Object)matchParams.get(MatchConstant.MATCHRECORDCOLL));
        Map extParamsMap = (Map)matchParams.get(MatchConstant.EXT_PARAMS);
        int sucCount = 0;
        int errCount = 0;
        StringBuffer errMsg = new StringBuffer();
        HashSet<String> failID = new HashSet<String>();
        HashSet<String> failKey = new HashSet<String>();
        HashSet<String> failNum = new HashSet<String>();
        IInvoiceMatchRecord iInvoiceMatchRecord = InvoiceMatchRecordFactory.getLocalInstance(ctx);
        ArrayList<RecordToBillParams> paramsList = new ArrayList<RecordToBillParams>();
        HashSet<String> invoiceSet = new HashSet<String>();
        for (int i = 0; i < records.size(); ++i) {
            RecordToBillParams params = new RecordToBillParams();
            params.setRecord(records.get(i));
            params.setDestBosType(config.getDestBosType());
            params.setRecordMatchType(records.get(i).getRecordMatchType());
            if (RecordMatchTypeEnum.AUTOGEN.equals((Object)records.get(i).getRecordMatchType())) {
                String createUserId;
                if (extParamsMap != null && !StringUtils.isEmpty((String)(createUserId = (String)extParamsMap.get(MatchConstant.CREATE_USER_ID)))) {
                    params.setCreaterUserId(createUserId);
                }
                String botpId = records.get(i).get(MatchConstant.BOTP_ID).toString();
                params.setBotpID((IObjectPK)new ObjectUuidPK(botpId));
            } else {
                params.setBotpID((IObjectPK)new ObjectUuidPK(helper.getBotpID()));
            }
            params.setEntrieNames(helper.getEntrieNames());
            for (int j = 0; j < records.get(i).getEntry().size(); ++j) {
                InvoiceMatchRecordEntryInfo entryInfo = records.get(i).getEntry().get(j);
                if (MatchConstant.BOSTYPE_INCOMEINVOICE.equals(entryInfo.getBillBosType())) {
                    if (!StringUtils.isEmpty((String)entryInfo.getBillID())) {
                        invoiceSet.add(entryInfo.getBillID());
                        params.getInvoiceIDSet().add(entryInfo.getBillID());
                        continue;
                    }
                    if (!RecordMatchTypeEnum.AUTOGEN.equals((Object)records.get(i).getRecordMatchType()) || StringUtils.isEmpty((String)entryInfo.getBillNumber())) continue;
                    params.getInvoiceNumberList().add(entryInfo.getBillNumber());
                    params.getInvoiceCodeList().add(entryInfo.get(MatchConstant.INVOICE_CODE).toString());
                    continue;
                }
                params.setBillBosType(entryInfo.getBillBosType());
                params.getBillIDList().add(entryInfo.getBillID());
                String entryID = entryInfo.getBillEntryID();
                params.getBillEntryIDList().add(entryID);
                if (params.getMatchedQty().containsKey(entryID)) {
                    params.getMatchedQty().put(entryID, params.getMatchedQty().get(entryID).add(entryInfo.getMatchedQty()));
                    params.getMatchedAmt().put(entryID, params.getMatchedAmt().get(entryID).add(entryInfo.getMatchedAmt()));
                    continue;
                }
                params.getMatchedQty().put(entryID, entryInfo.getMatchedQty());
                params.getMatchedAmt().put(entryID, entryInfo.getMatchedAmt());
            }
            paramsList.add(params);
        }
        HashMap<String, String> codeMap = new HashMap<String, String>();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        HashMap<String, PayInvoiceTypeEnum> typeMap = new HashMap<String, PayInvoiceTypeEnum>();
        if (invoiceSet.size() > 0) {
            StringBuffer selectSql = new StringBuffer();
            selectSql.append(" Select to_char(FInvoiceCode) as FInvoiceCode, to_char(FInvoiceNumber) as FInvoiceNumber , to_char(FInvoiceType) as FInvoiceType, FID From T_IM_IncomeInvoice where ");
            selectSql.append(MatchUtils.buildIn("FID", invoiceSet.toArray()));
            selectSql.append(" UNION ALL ");
            selectSql.append(" Select to_char(FInvoiceCode) as FInvoiceCode, to_char(FInvoiceNo) FInvoiceNumber, to_char(FInvoiceType) as FInvoiceType, FID From T_TM_FullElectricInvoice where ");
            selectSql.append(MatchUtils.buildIn("FID", invoiceSet.toArray()));
            IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)selectSql.toString(), null);
            try {
                while (rs.next()) {
                    String invoiceCode = rs.getString("FInvoiceCode");
                    if (StringUtils.isEmpty((String)invoiceCode)) {
                        invoiceCode = "FULL";
                    }
                    codeMap.put(rs.getString("FID"), invoiceCode);
                    numberMap.put(rs.getString("FID"), rs.getString("FInvoiceNumber"));
                    typeMap.put(rs.getString("FID"), PayInvoiceTypeEnum.getEnum((String)MatchUtils.convertTMInvoiceTypeToPayInvoiceTypeEnum(rs.getString("FInvoiceType"))));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        ArrayList<String> destNumberList = new ArrayList<String>();
        HashMap destInfoMap = new HashMap();
        for (RecordToBillParams params : paramsList) {
            IObjectPK recordID = null;
            try {
                LinkedHashSet<String> invoiceIDSet = params.getInvoiceIDSet();
                for (String id : invoiceIDSet) {
                    if (StringUtils.isEmpty((String)((String)codeMap.get(id))) || StringUtils.isEmpty((String)((String)numberMap.get(id)))) continue;
                    params.getInvoiceCodeList().add(codeMap.get(id));
                    params.getInvoiceNumberList().add(numberMap.get(id));
                    params.getInvoiceTypeList().add((PayInvoiceTypeEnum)typeMap.get(id));
                }
                if (config.isIsNeedRecord()) {
                    recordID = iInvoiceMatchRecord.addnew(params.getRecord());
                    params.getRecord().setId(BOSUuid.read((String)recordID.toString()));
                }
                IObjectCollection coll = this.mapppingToBills(ctx, params, helper);
                ArrayList<String> numbers = new ArrayList<String>();
                ArrayList<CoreBaseInfo> destInfos = new ArrayList<CoreBaseInfo>();
                for (CoreBaseInfo info : coll) {
                    destInfos.add(info);
                    numbers.add(info.get("number").toString());
                }
                String key = params.getInvoiceNumberList().toString().trim() + "_" + params.getInvoiceCodeList().toString().trim();
                destInfoMap.put(key, destInfos);
                destNumberList.addAll(numbers);
                ++sucCount;
            }
            catch (Exception e) {
                if (recordID != null) {
                    try {
                        Method method = IInvoiceMatchRecord.class.getDeclaredMethod("delete", IObjectPK.class);
                        method.setAccessible(true);
                        EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)iInvoiceMatchRecord);
                        txInvoker.invoke(method, new Object[]{recordID}, 3);
                    }
                    catch (Throwable e1) {
                        logger.error((Object)e1.getMessage());
                    }
                }
                failKey.add(params.getRecord().getCompany().getId().toString() + params.getRecord().getSupplier().getId().toString());
                InvoiceMatchRecordEntryCollection entry = params.getRecord().getEntry();
                for (int j = 0; j < entry.size(); ++j) {
                    failNum.add(entry.get(j).getBillEntryID());
                }
                failID.add(params.getRecord().getId().toString());
                errMsg.append(e.getMessage()).append('\n');
                ++errCount;
            }
        }
        this.sendMsg(ctx, destNumberList, config.getDestBillName(), errMsg.toString());
        result.put(MatchConstant.DESTBILLINFOS, destInfoMap);
        result.put(MatchConstant.SUCCOUNT, sucCount);
        result.put(MatchConstant.ERRCOUNT, errCount);
        result.put(MatchConstant.ERRMSG, errMsg.toString());
        result.put(MatchConstant.FAILID, failID);
        result.put(MatchConstant.FAILKEY, failKey);
        result.put(MatchConstant.FAILNUM, failNum);
        return result;
    }

    private void sendMsg(Context ctx, List<String> obNumberList, String billName, String execption) {
        MessageInfo info = new MessageInfo();
        info.setUserID(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        info.setOrgNumber(company.getName(ctx.getLocale()) + "(" + company.getNumber() + ")");
        info.setSendMsg(true);
        if (execption.isEmpty()) {
            info.setSuccessed(true);
            info.setbizAction(MatchUtils.getString(MatchConstant.INVOICEMATCH_RESOURCE, "Msg_GenerateBill", ctx.getLocale(), new Object[]{billName, Arrays.toString(obNumberList.toArray())}));
        } else {
            info.setSuccessed(false);
            info.setbizAction(MatchUtils.getString(MatchConstant.INVOICEMATCH_RESOURCE, "Title_GenerateBill", ctx.getLocale(), new Object[]{billName}));
            info.setExecption(execption);
        }
        MessageUtil.sendMsg((Context)ctx, (MessageInfo)info);
    }

    private IObjectCollection mapppingToBills(Context ctx, RecordToBillParams params, AbstractConfigHelper helper) throws Exception {
        try {
            CoreBillBaseInfo info;
            ctx.put((Object)MatchConstant.MATCHBOTP, (Object)MatchConstant.MATCHBOTP);
            ctx.put((Object)MatchConstant.MATCHPARAMS, (Object)params);
            logger.error((Object)("[mapppingToBills] Start : " + new Date()));
            LowTimer timer = new LowTimer();
            IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
            IBOTMapping iBOTMapping = BOTMappingFactory.getLocalInstance((Context)ctx);
            BOTMappingInfo mappingInfo = iBOTMapping.getMappingInfoByPK(params.getBotpID());
            CoreBillBaseCollection cbc = iBOTMapping.getNewBillCollectionByType(mappingInfo.getSrcEntityName(), params.getBillIDList().toArray(new String[params.getBillIDList().size()]), params.getEntrieNames(), params.getBillEntryIDList(), null);
            logger.error((Object)("[mapppingToBills] 1 : " + timer.msValue() + " ms"));
            logger.error((Object)("[mapppingToBills] 2 : " + timer.msValue() + " ms"));
            BTPTransformResult btpResult = iBTPManager.transformForBotp(cbc, params.getDestBosType(), params.getBotpID());
            if (btpResult == null) {
                throw new InvoiceMatchException(InvoiceMatchException.BOTPNOBILL);
            }
            logger.error((Object)("[mapppingToBills] 3 : " + timer.msValue() + " ms count : " + btpResult.getBills().size()));
            IDynamicObject dynamicObject = DynamicObjectFactory.getLocalInstance((Context)ctx);
            for (int i = 0; !(i >= btpResult.getBills().size() || (info = (CoreBillBaseInfo)btpResult.getBills().getObject(i)).getId() != null && dynamicObject.exists(info.getBOSType(), (IObjectPK)new ObjectUuidPK(info.getId().toString()))); ++i) {
                iBTPManager.saveRelations(info, btpResult.getBOTRelationCollection());
            }
            logger.error((Object)("[mapppingToBills] 4 : " + timer.msValue() + " ms count : " + btpResult.getBills().size()));
            IObjectCollection iObjectCollection = btpResult.getBills();
            return iObjectCollection;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ctx.remove((Object)MatchConstant.MATCHBOTP);
            ctx.remove((Object)MatchConstant.MATCHPARAMS);
        }
    }

    @Override
    protected Set _getBotpRelations(Context ctx, String id) throws BOSException, EASBizException {
        HashSet<String> traceID = new HashSet<String>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append(" Select FID from T_BOT_Relation where FDestEntityID = '1343913D' ").append("\n");
            sql.append(" and FSrcObjectID = '").append(id).append("' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                traceID.add(rs.getString("FID"));
            }
        }
        catch (Exception e) {
            throw new InvoiceMatchException(InvoiceMatchException.ERRORMSG, new Object[]{e.getMessage()});
        }
        return traceID;
    }

    @Override
    protected void _removeBotpRelations(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null || idSet.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete from T_BOT_Relation where ").append(MatchUtils.buildIn("FID", idSet.toArray()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    @Override
    protected void _updateConfigBotp(Context ctx, String configId, String botpId) throws BOSException, EASBizException {
        if (configId == null || botpId == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_ARAP_MatchBillConfig  set FBotpID=? where FID=?");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{botpId, configId});
    }
}

