/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.IMRecordSrcSystemEnum;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchException;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordCollection;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordEntryCollection;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordEntryInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.app.AbstractInvoiceMatchRecordControllerBean;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceMatchRecordControllerBean
extends AbstractInvoiceMatchRecordControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.invoiceMatch.app.InvoiceMatchRecordControllerBean");

    @Override
    protected Map _batchAddnew(Context ctx, InvoiceMatchRecordCollection records) throws BOSException, EASBizException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        int success = 0;
        int error = 0;
        HashSet<String> failID = new HashSet<String>();
        HashSet<String> failKey = new HashSet<String>();
        HashSet<String> failNum = new HashSet<String>();
        StringBuffer errorMsg = new StringBuffer();
        for (int i = 0; i < records.size(); ++i) {
            InvoiceMatchRecordInfo info = records.get(i);
            try {
                this._addnew(ctx, (IObjectValue)info);
                ++success;
                continue;
            }
            catch (Exception e) {
                failKey.add(info.getCompany().getId().toString() + info.getSupplier().getId().toString());
                InvoiceMatchRecordEntryCollection entry = info.getEntry();
                for (int j = 0; j < entry.size(); ++j) {
                    failNum.add(entry.get(j).getBillEntryID());
                }
                failID.add(info.getId().toString());
                errorMsg.append(e.getMessage()).append('\n');
                ++error;
            }
        }
        result.put(MatchConstant.SUCCOUNT, success);
        result.put(MatchConstant.ERRCOUNT, error);
        result.put(MatchConstant.ERRMSG, errorMsg.toString());
        result.put(MatchConstant.FAILID, failID);
        result.put(MatchConstant.FAILKEY, failKey);
        result.put(MatchConstant.FAILNUM, failNum);
        return result;
    }

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceMatchRecordInfo info = (InvoiceMatchRecordInfo)model;
        InvoiceMatchRecordEntryCollection entry = info.getEntry();
        if (info.getNumber() == null) {
            info.setNumber(this.getNewNumber(ctx, info, this.getCU(ctx, (ObjectBaseInfo)info).getId().toString()));
        }
        IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"addnew", (BOSObjectType)BOSObjectType.create((String)"6359D9C5"), null, (String)info.getNumber(), (String)"ap_invoiceMatch_match", (String)info.getCompany().getId().toString());
        BigDecimal billQty = BigDecimal.ZERO;
        BigDecimal billAmt = BigDecimal.ZERO;
        BigDecimal invoiceQty = BigDecimal.ZERO;
        BigDecimal invoiceAmt = BigDecimal.ZERO;
        ArrayList<InvoiceMatchRecordEntryInfo> billList = new ArrayList<InvoiceMatchRecordEntryInfo>();
        ArrayList<InvoiceMatchRecordEntryInfo> invoiceList = new ArrayList<InvoiceMatchRecordEntryInfo>();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        try {
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "ap_invoiceMatch_match");
        }
        catch (Exception e) {
            throw new InvoiceMatchException(InvoiceMatchException.ERRORMSG, new Object[]{e.getMessage()});
        }
        for (int i = 0; i < entry.size(); ++i) {
            InvoiceMatchRecordEntryInfo recordEntryInfo = entry.get(i);
            if (MatchConstant.BOSTYPE_INCOMEINVOICE.equals(recordEntryInfo.getBillBosType())) {
                invoiceQty = invoiceQty.add(recordEntryInfo.getMatchedQty());
                invoiceAmt = invoiceAmt.add(recordEntryInfo.getMatchedAmt());
                invoiceList.add(recordEntryInfo);
                continue;
            }
            billQty = billQty.add(recordEntryInfo.getMatchedQty());
            billAmt = billAmt.add(recordEntryInfo.getMatchedAmt());
            billList.add(recordEntryInfo);
        }
        this.checkBeforeSave(ctx, invoiceList);
        info.setBillQtyTotal(billQty);
        info.setBillAmtTotal(billAmt);
        info.setInvoiceQtyTotal(invoiceQty);
        info.setInvoiceAmtTotal(invoiceAmt);
        if (info.getBizDate() == null) {
            info.setBizDate(new Date());
        }
        IObjectPK pk = super._addnew(ctx, model);
        ArrayList<String[]> params = new ArrayList<String[]>();
        for (int i = 0; i < billList.size(); ++i) {
            for (int j = 0; j < invoiceList.size(); ++j) {
                if (StringUtils.isEmpty((String)invoiceList.get(j).getBillID())) continue;
                String[] param = new String[]{((InvoiceMatchRecordEntryInfo)billList.get(i)).getBillBosType(), invoiceList.get(j).getBillBosType(), ((InvoiceMatchRecordEntryInfo)billList.get(i)).getBillID(), invoiceList.get(j).getBillID(), MatchConstant.OPERATORID};
                params.add(param);
            }
        }
        MatchUtils.buildBOTPRelation(ctx, params);
        LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        return pk;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        HashSet<String> invoiceIDs = new HashSet<String>();
        InvoiceMatchRecordInfo info = (InvoiceMatchRecordInfo)this.getValue(ctx, pk);
        InvoiceMatchRecordEntryCollection entry = info.getEntry();
        for (int i = 0; i < entry.size(); ++i) {
            InvoiceMatchRecordEntryInfo recordEntryInfo = entry.get(i);
            if (!MatchConstant.BOSTYPE_INCOMEINVOICE.equals(recordEntryInfo.getBillBosType())) continue;
            invoiceIDs.add(recordEntryInfo.getBillID());
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" Delete from T_BOT_Relation where FOperatorID = '").append(MatchConstant.OPERATORID).append("' and ");
        sql.append(MatchUtils.buildIn("FDESTObjectID", invoiceIDs.toArray()));
        DbUtil.execute((Context)ctx, (String)sql.toString());
        super._delete(ctx, pk);
    }

    private String getNewNumber(Context ctx, InvoiceMatchRecordInfo info, String CUID) throws BOSException, EASBizException {
        String number;
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule((IObjectValue)info, CUID);
        if (codingRule == null) {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            number = df.format(new Date());
        } else {
            number = iCodingRuleManager.getNumber((IObjectValue)info, CUID);
        }
        return number;
    }

    private void checkBeforeSave(Context ctx, ArrayList<InvoiceMatchRecordEntryInfo> invoiceList) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        ArrayList<String> invId = new ArrayList<String>();
        for (int i = 0; i < invoiceList.size(); ++i) {
            invId.add(invoiceList.get(i).getBillID());
        }
        sb.append(" SELECT FBillNumber FROM T_ARAP_InvoiceMatchRecordEntry where ");
        sb.append(MatchUtils.buildIn("FBillID", invId.toArray()));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        HashSet<String> invNumbers = new HashSet<String>();
        try {
            while (rs.next()) {
                invNumbers.add(rs.getString("FBillNumber"));
            }
            if (!invNumbers.isEmpty()) {
                throw new InvoiceMatchException(InvoiceMatchException.INVOICEMATCHED, invNumbers.toArray());
            }
        }
        catch (SQLException e) {
            throw new InvoiceMatchException(InvoiceMatchException.ERRORMSG, new Object[]{e.getMessage()});
        }
    }

    @Override
    protected Map _antiMatch(Context ctx, ArrayList ids, boolean isFromAP) throws BOSException, EASBizException {
        HashMap<String, Comparable<StringBuffer>> ret = new HashMap<String, Comparable<StringBuffer>>();
        StringBuffer errMsg = new StringBuffer();
        HashSet invoiceIDs = new HashSet();
        ArrayList<ObjectUuidPK> pkList = new ArrayList<ObjectUuidPK>();
        int successed = 0;
        int failed = 0;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
        view.setFilter(filter);
        InvoiceMatchRecordCollection coll = this.getInvoiceMatchRecordCollection(ctx, view);
        if (ids.size() != coll.size()) {
            throw new InvoiceMatchException(InvoiceMatchException.RECORDNOTFOUND);
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        ObjectUuidPK userPk = new ObjectUuidPK(BOSUuid.read((String)userInfo.getId().toString()));
        for (int i = 0; i < coll.size(); ++i) {
            StringBuffer errorBuffer = new StringBuffer();
            InvoiceMatchRecordInfo info = coll.get(i);
            try {
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)userPk, (IObjectPK)new ObjectUuidPK(info.getCompany().getId()), "ap_invoiceMatchRecord_antiMatch");
            }
            catch (Exception e) {
                errorBuffer.append(info.getNumber()).append(":").append(e.getMessage()).append("\n");
                errMsg.append(errorBuffer);
                LogUtil.beginLog((Context)ctx, (String)"antiMatch", (BOSObjectType)BOSObjectType.create((String)"6359D9C5"), null, (String)errorBuffer.toString(), (String)"ap_invoiceMatchRecord_antimatch");
                ++failed;
                continue;
            }
            if (!IMRecordSrcSystemEnum.MANUAL.equals((Object)info.getSrcSystem())) {
                errorBuffer.append(info.getNumber()).append(":").append(ResourceBase.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Error_NotManual", (Locale)ctx.getLocale())).append("\n");
                errMsg.append(errorBuffer);
                ++failed;
                LogUtil.beginLog((Context)ctx, (String)"antiMatch", (BOSObjectType)BOSObjectType.create((String)"6359D9C5"), null, (String)errorBuffer.toString(), (String)"ap_invoiceMatchRecord_antimatch");
                continue;
            }
            String rid = info.getId().toString();
            Map<String, Object> result = new HashMap<String, Object>();
            try {
                Method method = InvoiceMatchRecordControllerBean.class.getDeclaredMethod("deleteAPOB", Context.class, InvoiceMatchRecordInfo.class, Set.class, Boolean.TYPE);
                method.setAccessible(true);
                EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)new InvoiceMatchRecordControllerBean());
                result = (Map)txInvoker.invoke(method, new Object[]{ctx, info, invoiceIDs, isFromAP}, 3);
            }
            catch (Throwable e) {
                logger.error((Object)e);
                result.put("result", false);
                result.put("errMsg", e.getMessage());
            }
            if (((Boolean)result.get("result")).booleanValue()) {
                ++successed;
                pkList.add(new ObjectUuidPK(rid));
                IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"antiMatch", (BOSObjectType)BOSObjectType.create((String)"6359D9C5"), null, (String)info.getNumber(), (String)"ap_invoiceMatchRecord_antimatch");
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
                continue;
            }
            ++failed;
            errorBuffer.append(info.getNumber()).append(":").append(ResourceBase.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Error_DeleteBill", (Locale)ctx.getLocale(), (Object[])new Object[]{result.get("errMsg").toString()})).append("\n");
            errMsg.append(errorBuffer);
            LogUtil.beginLog((Context)ctx, (String)"antiMatch", (BOSObjectType)BOSObjectType.create((String)"6359D9C5"), null, (String)errorBuffer.toString(), (String)"ap_invoiceMatchRecord_antimatch");
        }
        if (invoiceIDs.size() > 0) {
            StringBuffer sql = new StringBuffer();
            sql.append(" Delete from T_BOT_Relation where FOperatorID = '").append(MatchConstant.OPERATORID).append("' and ");
            sql.append(MatchUtils.buildIn("FDESTObjectID", invoiceIDs.toArray()));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        IObjectPK[] pks = new IObjectPK[pkList.size()];
        for (int i = 0; i < pkList.size(); ++i) {
            pks[i] = (IObjectPK)pkList.get(i);
        }
        if (pkList.size() > 0) {
            super._delete(ctx, pks);
        }
        ret.put("errMsg", errMsg);
        ret.put("successed", Integer.valueOf(successed));
        ret.put("failed", Integer.valueOf(failed));
        return ret;
    }

    @Override
    protected Map _antiMatch(Context ctx, ArrayList ids) throws BOSException, EASBizException {
        return this._antiMatch(ctx, ids, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map deleteAPOB(Context ctx, InvoiceMatchRecordInfo info, Set invoiceIDs, boolean isFromAp) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        if (isFromAp) {
            ret.put("result", true);
            return ret;
        }
        try {
            ctx.put((Object)MatchConstant.ANTIMATCH, (Object)MatchConstant.ANTIMATCH);
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT distinct fbillid FROM T_ARAP_InvoiceMatchRecordEntry where fparentid = '");
            sql.append(info.getId().toString());
            sql.append("' and FBILLBOSTYPE = '1343913D' ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            String invId = "";
            while (rs.next()) {
                invId = rs.getString("fbillid");
                invoiceIDs.add(rs.getString("fbillid"));
            }
            if (StringUtils.isEmpty((String)invId)) {
                sql.append(" SELECT fid id from T_AP_OTHERBILL other").append('\n');
                sql.append(" where other.fnumber = '").append(info.getDestBillNumber()).append("' ");
                sql.append(" and other.fCompanyId = '").append(info.getCompany().getId().toString()).append("' ");
            } else {
                sql.append(" SELECT ob.fid as id FROM T_BOT_Relation botp ").append('\n');
                sql.append(" inner join T_AP_OTHERBILL ob on  botp.FSRCOBJECTID = ob.fid ").append('\n');
                sql.append(" inner join T_IM_IncomeInvoice invoice on invoice.fid =  botp.FDESTOBJECTID ").append('\n');
                sql.append(" where invoice.fid = '").append(invId).append("' ");
                sql.append(" union all ");
                sql.append(" SELECT ob.fid as id FROM T_BOT_Relation botp ").append('\n');
                sql.append(" inner join T_AP_OTHERBILL ob on  botp.FSRCOBJECTID = ob.fid ").append('\n');
                sql.append(" inner join T_TM_FullElectricInvoice invoice on invoice.fid =  botp.FDESTOBJECTID ").append('\n');
                sql.append(" where invoice.fid = '").append(invId).append("' ");
            }
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                ObjectUuidPK pk = new ObjectUuidPK(rs.getString("id"));
                OtherBillInfo otherBillInfo = OtherBillFactory.getLocalInstance(ctx).getOtherBillInfo((IObjectPK)pk);
                if (info.getDestBillNumber() != null && !otherBillInfo.getNumber().equals(info.getDestBillNumber())) continue;
                OtherBillFactory.getLocalInstance(ctx).delete((IObjectPK)pk);
            }
            ret.put("result", true);
        }
        catch (Exception e) {
            logger.error((Object)e);
            ret.put("result", false);
            ret.put("errMsg", e.getMessage() == null ? "NullPointerException" : e.getMessage());
        }
        finally {
            ctx.remove((Object)MatchConstant.ANTIMATCH);
        }
        return ret;
    }

    @Override
    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, String permItem) throws BOSException, EASBizException {
        OrgUnitCollection collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)orgType, (String)permItem);
        return SCMGroupServerUtils.getOrgUnitInfosByType((Context)ctx, (OrgUnitCollection)collection, (OrgType)orgType);
    }
}

