/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.util;

import com.kingdee.eas.fi.rpt.RptPeriodTypeEnum;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public class RPTDateUtil
implements Serializable {
    private static int[] monthLength = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static int[] leapYearMonthLength = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    public static Date getPeriodFirstDate(int year, int period, RptPeriodTypeEnum periodType) {
        int month = 0;
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        switch (periodType.getValue()) {
            case 1: {
                calendar.set(1, year);
                calendar.set(6, period);
                return calendar.getTime();
            }
            case 3: {
                if (period == 13) {
                    return RPTDateUtil.getPeriodLastDate(year, period, periodType);
                }
                calendar.set(year, period - 1, 1);
                return calendar.getTime();
            }
            case 4: {
                month = period * 3 - 3;
                calendar.set(year, month, 1);
                return calendar.getTime();
            }
            case 5: {
                month = period * 6 - 6;
                calendar.set(year, month, 1);
                return calendar.getTime();
            }
            case 2: {
                calendar.set(1, year);
                calendar.set(3, period);
                calendar.set(7, 1);
                return calendar.getTime();
            }
            case 6: {
                calendar.set(year, 0, 1);
                return calendar.getTime();
            }
        }
        return null;
    }

    public static Date getPeriodLastDate(int year, int period, RptPeriodTypeEnum periodType) {
        int month = 0;
        int date = 0;
        Calendar calendar = RPTDateUtil.getCalendarTimeIsZero();
        calendar.clear();
        boolean isLeapYear = RPTDateUtil.isLeapYear(year);
        switch (periodType.getValue()) {
            case 1: {
                calendar.set(1, year);
                calendar.set(6, period);
                return calendar.getTime();
            }
            case 3: {
                if (period > 13) {
                    return null;
                }
                if (period == 13) {
                    period = 12;
                }
                date = isLeapYear ? leapYearMonthLength[period - 1] : monthLength[period - 1];
                calendar.set(year, period - 1, date);
                return calendar.getTime();
            }
            case 4: {
                month = period * 3 - 1;
                if (month > 12) {
                    return null;
                }
                date = isLeapYear ? leapYearMonthLength[month] : monthLength[month];
                calendar.set(year, month, date);
                return calendar.getTime();
            }
            case 5: {
                month = period * 6 - 1;
                if (month > 12) {
                    return null;
                }
                date = isLeapYear ? leapYearMonthLength[month] : monthLength[month];
                calendar.set(year, month, date);
                return calendar.getTime();
            }
            case 2: {
                calendar.set(1, year);
                calendar.set(3, period);
                calendar.set(7, 7);
                return calendar.getTime();
            }
            case 6: {
                calendar.set(year, 11, 31);
                return calendar.getTime();
            }
        }
        return null;
    }

    private static Calendar getCalendarTimeIsZero() {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        return calendar;
    }

    public static boolean isLeapYear(int year) {
        return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
    }
}

