/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.DefineSysEnum;
import com.kingdee.bos.metadata.bot.IBOTMapping;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.JoinInfo;
import com.kingdee.bos.metadata.query.JoinQueryInfo;
import com.kingdee.bos.metadata.query.PropertyRefInfo;
import com.kingdee.bos.metadata.query.PropertyUnitInfo;
import com.kingdee.bos.metadata.query.QueryFieldInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.SubEntityInfo;
import com.kingdee.bos.metadata.query.SubObjectInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.JoinType;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.WfException;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.wssc.CallSSCInterfaceFacadeFactory;
import com.kingdee.eas.base.wssc.ICallSSCInterfaceFacade;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountCurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.AccountingCurrencyEnum;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingInfo;
import com.kingdee.eas.cp.bc.IExpenseTypeSubjectMapping;
import com.kingdee.eas.fi.ap.ApVerificationFacadeFactory;
import com.kingdee.eas.fi.ap.IApVerificationFacade;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ar.AccountBadDebtException;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArVerificationFacadeFactory;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.IArVerificationFacade;
import com.kingdee.eas.fi.ar.IOtherBillentry;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.ar.OtherBillentryInfo;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApConstants;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.BaseServiceFacadeFactory;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.IBaseServiceFacade;
import com.kingdee.eas.fi.arap.VerificationBillBaseEntryInfo;
import com.kingdee.eas.fi.arap.util.ArApAmountFactory;
import com.kingdee.eas.fi.arap.util.ArApPeriodHelper;
import com.kingdee.eas.fi.arap.util.DBUtil;
import com.kingdee.eas.fi.cas.IPaymentBillType;
import com.kingdee.eas.fi.cas.IReceivingBillType;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMIsqlFacadeFactory;
import com.kingdee.eas.fm.common.IFMIsqlFacade;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.BillEntryBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.util.entity.EntityObjectInfoHelp;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class ArApBillUtil {
    public static final Locale L1 = LocaleUtils.locale_L1;
    public static final Locale L2 = LocaleUtils.locale_L2;
    public static final Locale L3 = LocaleUtils.locale_L3;
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String RES = "com.kingdee.eas.fi.cas.CasResources";
    public static Map<BOSObjectType, EntityObjectInfo> entityObjectCache = new HashMap<BOSObjectType, EntityObjectInfo>();
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.util.ArApBillUtil");
    static final Class[] PK_TYPE = new Class[]{IObjectPK.class};
    static final Class[] PKArray_TYPE = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class};
    static final Class[] Set_TYPE = new Class[]{IObjectPK[].class, CoreBillBaseCollection.class};
    private static Cache<String, IObjectValue> cusstAcctCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.HOURS).build();

    public static CurrencyInfo getBaseCurrency(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company == null || company.getBaseCurrency() == null) {
            throw new IllegalArgumentException();
        }
        ICurrency currency = null;
        currency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
        return currency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
    }

    public static boolean arBillIsVerified(String[] idList) throws BOSException, EASBizException {
        IArVerificationFacade iVerifyFacade = ArVerificationFacadeFactory.getRemoteInstance();
        boolean isVerified = false;
        for (int i = 0; i < idList.length; ++i) {
            if (!iVerifyFacade.isVerified(idList[i])) continue;
            isVerified = true;
        }
        return isVerified;
    }

    public static boolean apBillIsVerified(Context ctx, String[] idList) throws BOSException, EASBizException {
        IApVerificationFacade iVerifyFacade = null;
        iVerifyFacade = ctx == null ? ApVerificationFacadeFactory.getRemoteInstance() : ApVerificationFacadeFactory.getLocalInstance(ctx);
        boolean isVerified = false;
        for (int i = 0; i < idList.length; ++i) {
            if (!iVerifyFacade.isVerified(idList[i])) continue;
            isVerified = true;
        }
        return isVerified;
    }

    public static Date getBeforeSysDate(PeriodInfo period) {
        Date beforeStartDate = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(period.getBeginDate());
        cal.add(5, -1);
        beforeStartDate = cal.getTime();
        return beforeStartDate;
    }

    public static boolean isContainsArInitTransactBill(Context ctx, Set idSet, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (ArApPeriodHelper.getArStartPeriod(ctx, company) == null) {
            return false;
        }
        Date sysStartDate = ArApPeriodHelper.getArStartPeriod(ctx, company).getBeginDate();
        IOtherBillentry iOtherBillEntry = null;
        iOtherBillEntry = ctx == null ? OtherBillentryFactory.getRemoteInstance() : OtherBillentryFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("head.id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("head.billDate", (Object)sysStartDate, CompareType.LESS));
        ev.setFilter(filter);
        OtherBillentryCollection col = iOtherBillEntry.getOtherBillentryCollection(ev);
        for (int i = 0; i < col.size(); ++i) {
            OtherBillentryInfo entryInfo = col.get(i);
            BigDecimal hisUnVerifyAmt = entryInfo.getHisUnVerifyAmount();
            BigDecimal unLockAmt = entryInfo.getLockUnVerifyAmt();
            hisUnVerifyAmt = hisUnVerifyAmt == null ? SysConstant.BIGZERO : hisUnVerifyAmt;
            BigDecimal bigDecimal = unLockAmt = unLockAmt == null ? SysConstant.BIGZERO : unLockAmt;
            if (hisUnVerifyAmt.compareTo(SysConstant.BIGZERO) == 0 || hisUnVerifyAmt.compareTo(unLockAmt) == 0) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsApInitTransactBill(Context ctx, Set idSet, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        if (ArApPeriodHelper.getApStartPeriod(ctx, company) == null) {
            return false;
        }
        com.kingdee.eas.fi.ap.IOtherBillentry iOtherBillEntry = null;
        iOtherBillEntry = ctx == null ? com.kingdee.eas.fi.ap.OtherBillentryFactory.getRemoteInstance() : com.kingdee.eas.fi.ap.OtherBillentryFactory.getLocalInstance(ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("head.id", (Object)idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("head.isInitializeBill", (Object)Boolean.TRUE, CompareType.EQUALS));
        ev.setFilter(filter);
        com.kingdee.eas.fi.ap.OtherBillentryCollection col = iOtherBillEntry.getOtherBillentryCollection(ev);
        for (int i = 0; i < col.size(); ++i) {
            com.kingdee.eas.fi.ap.OtherBillentryInfo entryInfo = col.get(i);
            BigDecimal hisUnVerifyAmt = entryInfo.getHisUnVerifyAmount();
            BigDecimal unLockAmt = entryInfo.getLockUnVerifyAmt();
            hisUnVerifyAmt = hisUnVerifyAmt == null ? SysConstant.BIGZERO : hisUnVerifyAmt;
            BigDecimal bigDecimal = unLockAmt = unLockAmt == null ? SysConstant.BIGZERO : unLockAmt;
            if (hisUnVerifyAmt.compareTo(SysConstant.BIGZERO) == 0 || hisUnVerifyAmt.compareTo(unLockAmt) == 0) continue;
            return true;
        }
        return false;
    }

    public static void canEdit(ArApBillBaseInfo info, ArApSysParamInfo cache) throws EASBizException {
        if (!info.isIsInitializeBill() && BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            throw new OtherBillBizException(OtherBillBizException.BILLISAUDITED);
        }
        if (info.isIsImportBill() && !cache.isImportBillModifiable()) {
            throw new OtherBillBizException(OtherBillBizException.IMPORTBILL);
        }
        AbstractObjectCollection coll = info.getEntries();
        for (int i = 0; i < coll.size(); ++i) {
            ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)coll.getObject(i);
            BigDecimal hisUnVerifyAmt = entryInfo.getHisUnVerifyAmount();
            BigDecimal unLockAmt = entryInfo.getLockUnVerifyAmt();
            hisUnVerifyAmt = hisUnVerifyAmt == null ? SysConstant.BIGZERO : hisUnVerifyAmt;
            BigDecimal bigDecimal = unLockAmt = unLockAmt == null ? SysConstant.BIGZERO : unLockAmt;
            if (hisUnVerifyAmt.compareTo(SysConstant.BIGZERO) == 0 || hisUnVerifyAmt.compareTo(unLockAmt) == 0) continue;
            throw new OtherBillBizException(OtherBillBizException.HASNEXTBIZACTION);
        }
    }

    public static boolean isMaterialBill(int billType) {
        int[] notMaterialType = new int[]{101, 103, 201, 203};
        for (int i = 0; i < notMaterialType.length; ++i) {
            if (billType != notMaterialType[i]) continue;
            return false;
        }
        return true;
    }

    public static String getAsstActName(IObjectValue ov, Locale locale) {
        return ov.get("name", locale) != null ? ov.get("name", locale).toString() : null;
    }

    public static boolean isRelatedAccount(SystemEnum sysEnum, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        return SystemStatusCtrolUtils.isRelAccount(null, (SystemEnum)sysEnum, (CompanyOrgUnitInfo)company);
    }

    public static Object getCompareValue(FilterItemCollection filters, String propName, CompareType compareType) {
        Object obj = null;
        compareType = compareType == null ? CompareType.EQUALS : compareType;
        for (FilterItemInfo filterInfo : filters) {
            if (filterInfo == null || !propName.equalsIgnoreCase(filterInfo.getPropertyName()) || !compareType.equals((Object)filterInfo.getCompareType())) continue;
            obj = filterInfo.getCompareValue();
        }
        return obj;
    }

    public static AdminOrgUnitInfo getAdminOrgUnitByPerson(PersonInfo newPersonInfo) throws EASBizException, BOSException {
        if (newPersonInfo == null) {
            return null;
        }
        try {
            AdminOrgUnitInfo adminOrgUnit = PersonFactory.getRemoteInstance().getPrimaryAdminOrgUnit(newPersonInfo.getId());
            return adminOrgUnit;
        }
        catch (EASBizException e) {
            return null;
        }
        catch (BOSException e) {
            return null;
        }
    }

    public static Date createDate() {
        Date date = new Date();
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date createDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static BigDecimal getBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal qty) {
        BigDecimal baseQty = new BigDecimal("0.00000");
        if (qty != null) {
            baseQty = qty;
        } else {
            qty = baseQty;
        }
        try {
            BigDecimal coefficient;
            MultiMeasureUnitInfo mulUnit = ArApBillUtil.getMulUnit(mui, mi);
            if (mulUnit != null && (coefficient = mulUnit.getBaseConvsRate()) != null) {
                baseQty = qty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getRemoteInstance();
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = ArApBillUtil.getMulUnit(baseUnit, mi);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
            return baseQty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static BigDecimal getAssUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) throws BaseException {
        BigDecimal assQty = ZERO;
        if (baseQty != null) {
            assQty = baseQty;
        } else {
            baseQty = assQty;
        }
        MultiMeasureUnitInfo mulUnit = ArApBillUtil.getMulUnit(mui, mi);
        if (mulUnit != null) {
            BigDecimal coefficient = mulUnit.getBaseConvsRate();
            int precision = mulUnit.getQtyPrecision();
            if (coefficient != null) {
                assQty = baseQty.divide(coefficient, precision, 4);
            }
        } else {
            assQty = ZERO;
        }
        return assQty;
    }

    public static BigDecimal getBaseQtyByAssUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal assistQty) throws BaseException {
        BigDecimal baseQty = ZERO;
        if (assistQty != null) {
            baseQty = assistQty;
        } else {
            assistQty = baseQty;
        }
        MultiMeasureUnitInfo mulUnit = ArApBillUtil.getMulUnit(mui, mi);
        if (mulUnit != null) {
            BigDecimal coefficient = mulUnit.getBaseConvsRate();
            if (coefficient != null) {
                baseQty = assistQty.multiply(coefficient);
                MeasureUnitInfo baseUnit = mi.getBaseUnit();
                if (baseUnit == null) {
                    IMaterial im = MaterialFactory.getRemoteInstance();
                    baseUnit = im.getMaterialInfo((IObjectPK)new ObjectUuidPK(mi.getId())).getBaseUnit();
                }
                mulUnit = ArApBillUtil.getMulUnit(baseUnit, mi);
                int precision = mulUnit.getQtyPrecision();
                baseQty = baseQty.setScale(precision, 4);
            }
        } else {
            baseQty = ZERO;
        }
        return baseQty;
    }

    public static BigDecimal getQtyByBaseUnitQty(MeasureUnitInfo mui, MaterialInfo mi, BigDecimal baseQty) {
        BigDecimal qty = new BigDecimal("0.00000");
        if (baseQty != null) {
            qty = baseQty;
        } else {
            baseQty = qty;
        }
        try {
            MultiMeasureUnitInfo mulUnit = ArApBillUtil.getMulUnit(mui, mi);
            if (mulUnit != null) {
                BigDecimal coefficient = mulUnit.getBaseConvsRate();
                int precision = mulUnit.getQtyPrecision();
                if (coefficient != null) {
                    qty = baseQty.divide(coefficient, precision, 4);
                }
            }
            return qty;
        }
        catch (BaseException e) {
            ExceptionHandler.handle((Throwable)e);
            return null;
        }
    }

    public static MultiMeasureUnitInfo getMulUnit(MeasureUnitInfo mui, MaterialInfo mi) throws BaseException {
        MultiMeasureUnitInfo mulUnit = null;
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getRemoteInstance();
        if (mui != null && mi != null) {
            mulUnit = immu.getMultiUnit(mi.getId().toString(), mui.getId().toString());
        }
        return mulUnit;
    }

    public static Set convertObjectToSet(Object[] obj) {
        HashSet<Object> set = new HashSet<Object>();
        int length = obj.length;
        for (int i = 0; i < length; ++i) {
            set.add(obj[i]);
        }
        return set;
    }

    public static String convertSetToString(Set idSet) {
        StringBuffer idString = new StringBuffer("");
        if (idSet.size() > 0) {
            Iterator iterator = idSet.iterator();
            idString.append("(");
            while (iterator.hasNext()) {
                idString.append("'").append(iterator.next().toString()).append("'").append(",");
            }
            idString.deleteCharAt(idString.length() - 1);
            idString.append(")");
        }
        return idString.toString();
    }

    public static void checkCompany(Component uiComp, CompanyOrgUnitInfo companyInfo) {
        boolean expired;
        if (companyInfo == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            MsgBox.showWarning((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_AlertMsg"));
            SysUtil.abort();
        }
        Date curDate = new Date();
        Date invalidDate = companyInfo.getInvalidDate();
        boolean bl = expired = invalidDate != null && curDate.after(invalidDate);
        if (expired) {
            MsgBox.showInfo((Component)uiComp, (String)EASResource.getString((String)RES, (String)"Company_InvalidMsg"));
            SysUtil.abort();
        }
    }

    public static String getDateFormatString() {
        return CtrlFormatUtilities.getDateFormatString();
    }

    public static SelectorItemCollection getArApBillSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        sic.add(new SelectorItemInfo("asstActType.id"));
        sic.add(new SelectorItemInfo("asstActID"));
        sic.add(new SelectorItemInfo("asstActNumber"));
        sic.add(new SelectorItemInfo("paymentType.id"));
        sic.add(new SelectorItemInfo("paymentType.number"));
        sic.add(new SelectorItemInfo("amountLocal"));
        sic.add(new SelectorItemInfo("isReverseBill"));
        sic.add(new SelectorItemInfo("isTransBill"));
        sic.add(new SelectorItemInfo("isAllowanceBill"));
        sic.add(new SelectorItemInfo("isImportBill"));
        sic.add(new SelectorItemInfo("isInitializeBill"));
        sic.add(new SelectorItemInfo("isCoopBuild"));
        sic.add(new SelectorItemInfo("isBizBill"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("AsstActID_SourceBill"));
        sic.add(new SelectorItemInfo("billStatus"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("isTransOtherBill"));
        sic.add(new SelectorItemInfo("iscreatedbyapelecinvoice"));
        sic.add(new SelectorItemInfo("entry.coreBillType"));
        return sic;
    }

    public static SelectorItemCollection getVerifiactionSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("mainAcctCussType.id"));
        sic.add(new SelectorItemInfo("secondAcctCussType.id"));
        sic.add(new SelectorItemInfo("verificationType"));
        sic.add(new SelectorItemInfo("isSameCode"));
        sic.add(new SelectorItemInfo("mainBillType"));
        sic.add(new SelectorItemInfo("mainAcctCussID"));
        sic.add(new SelectorItemInfo("mainThisVerificateAmtLoc"));
        sic.add(new SelectorItemInfo("secondBillType"));
        sic.add(new SelectorItemInfo("secondAcctCussID"));
        sic.add(new SelectorItemInfo("secondThisVerificateAmtLoc"));
        sic.add(new SelectorItemInfo("entrys.billID"));
        sic.add(new SelectorItemInfo("entrys.billDate"));
        sic.add(new SelectorItemInfo("entrys.billNumber"));
        sic.add(new SelectorItemInfo("entrys.billType"));
        sic.add(new SelectorItemInfo("entrys.thisVerificateAmtLoc"));
        sic.add(new SelectorItemInfo("entrys.acctCussID"));
        sic.add(new SelectorItemInfo("isCashSalePur"));
        sic.add(new SelectorItemInfo("company.id"));
        sic.add(new SelectorItemInfo("company.number"));
        return sic;
    }

    public static AccountViewInfo getKAClassAccount(Context ctx, String companyID, String asstActId, boolean isArBill, boolean isArSystem, int isPreRecPay) throws Exception {
        IArApBillBase iArAp = ctx != null ? (isArBill ? OtherBillFactory.getLocalInstance(ctx) : com.kingdee.eas.fi.ap.OtherBillFactory.getLocalInstance(ctx)) : (isArBill ? OtherBillFactory.getRemoteInstance() : com.kingdee.eas.fi.ap.OtherBillFactory.getRemoteInstance());
        AccountViewInfo account = new AccountViewInfo();
        IRowSet accountResult = iArAp.getKAClassAccount(companyID, asstActId, isArBill, isArSystem, isPreRecPay);
        if (accountResult == null) {
            return null;
        }
        accountResult.beforeFirst();
        while (accountResult.next()) {
            account.setId(BOSUuid.read((String)accountResult.getString("account_id")));
            account.setNumber(accountResult.getString("account_number"));
            account.setName(accountResult.getString("account_name"));
            account.setAccountingcurrency(AccountingCurrencyEnum.getEnum((int)accountResult.getInt("accounting_currency")));
            if (accountResult.getString("account_currency") == null) continue;
            AccountCurrencyInfo accCurInfo = new AccountCurrencyInfo();
            CurrencyInfo cur = new CurrencyInfo();
            cur.setId(BOSUuid.read((String)accountResult.getString("account_currency")));
            accCurInfo.setCurrency(cur);
            account.getAccountCurrency().add(accCurInfo);
        }
        if (account.getId() == null) {
            return null;
        }
        return account;
    }

    public static AccountViewInfo deriveOppAccountFromExpenseType(boolean isAr, String expenseTypeId, String companyId) throws BOSException {
        ExpenseTypeSubjectMappingInfo info = ArApBillUtil.getExpenseTypeSubjectMappingInfo(expenseTypeId, companyId);
        AccountViewInfo account = null;
        try {
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            if (info != null) {
                String strIdLists;
                List accountIDs;
                account = info.getAccountId();
                IArApBillFacade iArApBillFacade = ArApBillFacadeFactory.getRemoteInstance();
                Map accountMap = iArApBillFacade.getContrastAccount(isAr, companyInfo, account.getAccountTableID().getId().toString(), null);
                if (accountMap != null && (accountIDs = (List)accountMap.get("accountIDs")).size() > 0 && (strIdLists = StringUtils.arrayToString((Object[])accountIDs.toArray(), (String)",")).indexOf(account.getId().toString()) > -1) {
                    account = null;
                }
                if (account != null && (account.isIsGFreeze() || account.isIsCFreeze())) {
                    account = null;
                }
            }
        }
        catch (EASBizException e) {
            throw new BOSException(e.getCause());
        }
        return account;
    }

    public static ExpenseTypeSubjectMappingInfo getExpenseTypeSubjectMappingInfo(String expenseTypeId, String companyId) throws BOSException {
        IExpenseTypeSubjectMapping rmi = ExpenseTypeSubjectMappingFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo("expenseTypeId", (Object)expenseTypeId));
        fic.add(new FilterItemInfo("company", (Object)companyId));
        SelectorItemCollection sic = new SelectorItemCollection();
        String ssic = "loanAccountID";
        sic.add(ssic + ".id");
        sic.add(ssic + ".number");
        sic.add(ssic + ".name");
        ssic = "accountId";
        sic.add(ssic + ".id");
        sic.add(ssic + ".number");
        sic.add(ssic + ".name");
        sic.add(ssic + ".isCFreeze");
        sic.add(ssic + ".isGFreeze");
        sic.add(ssic + ".accountTableID.id");
        ev.setFilter(fi);
        ev.setSelector(sic);
        ExpenseTypeSubjectMappingCollection col = rmi.getExpenseTypeSubjectMappingCollection(ev);
        ExpenseTypeSubjectMappingInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        return info;
    }

    public static String getFormatPattern(int scale, boolean isDisplayZero) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        String zeroStr = null;
        if (scale == 0) {
            pattern = "#,##0";
            zeroStr = "0";
        } else {
            pattern = "#,##0." + end;
            zeroStr = "0." + end;
        }
        pattern = pattern + ";-" + pattern + ";";
        if (isDisplayZero) {
            pattern = pattern + zeroStr;
        }
        return pattern;
    }

    public static String getSqlIDs(Set<String> idSet) {
        StringBuilder sb = new StringBuilder();
        if (idSet == null || idSet.size() == 0) {
            return "";
        }
        for (String pk : idSet) {
            if (sb.length() > 0) {
                sb.append(",'").append(pk).append("'");
                continue;
            }
            sb.append("'").append(pk).append("'");
        }
        return sb.toString();
    }

    public static Set getOrgByRelation(String orgId, int typeFrom, int typeTo) throws BOSException {
        HashSet<String> orgIds = new HashSet<String>();
        IOrgUnitRelation iOrgUnitRel = OrgUnitRelationFactory.getRemoteInstance();
        try {
            OrgUnitCollection orgIdColl = iOrgUnitRel.getFromUnit(orgId, typeTo, typeFrom);
            for (int i = 0; orgIdColl != null && i < orgIdColl.size(); ++i) {
                orgIds.add(orgIdColl.get(i).getId().toString());
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        return orgIds;
    }

    public static String printExceptionMsg(Exception e) {
        String msg = e.getMessage();
        if (msg == null) {
            StackTraceElement[] stack = e.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                msg = msg + stack[i] + "\n";
            }
        }
        return msg;
    }

    public static boolean isBillInShareFlow(Context ctx, boolean isBillInShareFlow, String billID, int billStatusval, int sumbitStatusval) throws BOSException, WfException, EASBizException {
        if (billStatusval >= sumbitStatusval) {
            ProcessInstInfo instInfo = null;
            IEnactmentService service = ctx == null ? EnactmentServiceFactory.createRemoteEnactService() : EnactmentServiceFactory.createEnactService((Context)ctx);
            ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(billID);
            int n = procInsts.length;
            for (int i = 0; i < n; ++i) {
                if (!"open.running".equals(procInsts[i].getState()) && !"open.not_running.suspended".equals(procInsts[i].getState())) continue;
                instInfo = procInsts[i];
            }
            if (null != instInfo) {
                String procInstId = instInfo.getProcInstId();
                ICallSSCInterfaceFacade callSSCInterfaceFacade = null;
                callSSCInterfaceFacade = ctx == null ? CallSSCInterfaceFacadeFactory.getRemoteInstance() : CallSSCInterfaceFacadeFactory.getLocalInstance((Context)ctx);
                isBillInShareFlow = callSSCInterfaceFacade.isShareCenter(procInstId);
            }
        }
        return isBillInShareFlow;
    }

    public static SupplierCompanyBankInfo fetchSupplierCompanyBank(Context ctx, String supplierCompanyID, String bankAccountNumber, String bankName) throws BOSException, EASBizException {
        SupplierCompanyBankInfo sCBankInfo = null;
        if (StringUtils.isEmpty((String)supplierCompanyID)) {
            return sCBankInfo;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("bank");
        view.getSelector().add("beneficiaryBankCode");
        view.getSelector().add("bankAccount");
        view.getSelector().add("bankAddress");
        view.getSelector().add("beneficiary");
        view.getSelector().add("isDefault");
        view.getSelector().add("supplierCompanyInfo.id");
        view.getSelector().add("supplierCompanyInfo.email");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("supplierCompanyInfo.id", (Object)supplierCompanyID, CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)bankAccountNumber)) {
            filter.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)bankAccountNumber, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)bankName)) {
            filter.getFilterItems().add(new FilterItemInfo("bank", (Object)bankName, CompareType.EQUALS));
        }
        view.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("seq");
        sorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterItemInfo);
        SupplierCompanyBankCollection supplierCompanyBankColl = SupplierCompanyBankFactory.getLocalInstance((Context)ctx).getSupplierCompanyBankCollection(view);
        if (null == supplierCompanyBankColl || supplierCompanyBankColl.size() <= 0) {
            return sCBankInfo;
        }
        int size = supplierCompanyBankColl.size();
        for (int i = 0; i < size; ++i) {
            sCBankInfo = supplierCompanyBankColl.get(i);
            if (!StringUtils.isEmpty((String)bankAccountNumber) || !StringUtils.isEmpty((String)bankName) || sCBankInfo.isIsDefault()) break;
            sCBankInfo = null;
        }
        if (null == sCBankInfo) {
            sCBankInfo = supplierCompanyBankColl.get(0);
        }
        return sCBankInfo;
    }

    public static CustomerCompanyBankInfo fetchCustomerCompanyBank(Context ctx, String customerCompanyID, String bankAccountNumber, String bankName) throws BOSException, EASBizException {
        CustomerCompanyBankInfo cCBankInfo = null;
        if (StringUtils.isEmpty((String)customerCompanyID)) {
            return cCBankInfo;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("bank");
        view.getSelector().add("beneficiaryBankCode");
        view.getSelector().add("bankAccount");
        view.getSelector().add("bankAddress");
        view.getSelector().add("beneficiary");
        view.getSelector().add("isDefault");
        view.getSelector().add("customerCompanyInfo.id");
        view.getSelector().add("customerCompanyInfo.email");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("customerCompanyInfo.id", (Object)customerCompanyID, CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)bankAccountNumber)) {
            filter.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)bankAccountNumber, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)bankName)) {
            filter.getFilterItems().add(new FilterItemInfo("bank", (Object)bankName, CompareType.EQUALS));
        }
        view.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo();
        sorterItemInfo.setPropertyName("seq");
        sorterItemInfo.setSortType(SortType.ASCEND);
        view.getSorter().add(sorterItemInfo);
        CustomerCompanyBankCollection customerCompanyBankColl = CustomerCompanyBankFactory.getLocalInstance((Context)ctx).getCustomerCompanyBankCollection(view);
        if (null == customerCompanyBankColl || customerCompanyBankColl.size() <= 0) {
            return cCBankInfo;
        }
        int size = customerCompanyBankColl.size();
        for (int i = 0; i < size; ++i) {
            cCBankInfo = customerCompanyBankColl.get(i);
            if (!StringUtils.isEmpty((String)bankAccountNumber) || !StringUtils.isEmpty((String)bankName) || cCBankInfo.isIsDefault()) break;
            cCBankInfo = null;
        }
        if (null == cCBankInfo) {
            cCBankInfo = customerCompanyBankColl.get(0);
        }
        return cCBankInfo;
    }

    public static AccountBankInfo fetchAccountBank(Context ctx, String companyId, String bankAccountNumber, String bankName) throws BOSException, EASBizException {
        AccountBankInfo accountBankInfo = null;
        if (StringUtils.isEmpty((String)companyId)) {
            return accountBankInfo;
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("acctName"));
        sic.add(new SelectorItemInfo("bankAccountNumber"));
        sic.add(new SelectorItemInfo("bank.id"));
        sic.add(new SelectorItemInfo("bank.name"));
        sic.add(new SelectorItemInfo("bank.number"));
        evi.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)bankAccountNumber)) {
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)bankAccountNumber, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)bankName)) {
            filter.getFilterItems().add(new FilterItemInfo("bank.name", (Object)bankName, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)0, CompareType.EQUALS));
        evi.setFilter(filter);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
        sorterItemInfo.setSortType(SortType.ASCEND);
        evi.getSorter().add(sorterItemInfo);
        AccountBankCollection accountBankColls = AccountBankFactory.getLocalInstance((Context)ctx).getAccountBankCollection(evi);
        if (accountBankColls != null && accountBankColls.size() > 0) {
            accountBankInfo = accountBankColls.get(0);
        }
        return accountBankInfo;
    }

    public static Map getBankInfoByPayee(Context ctx, String payeeType, String payeeID, String companyID) throws EASBizException, BOSException {
        AccountBankInfo accountBankInfo;
        IRowSet rowSet;
        String sql;
        HashMap<String, String> bankInfo = new HashMap<String, String>();
        String oql = "select id, name, number, isInternalCompany, internalCompany.id where id = '" + payeeID + "'";
        String payeeBank = "";
        String bankAccount = "";
        String email = "";
        String internalCompanyId = "";
        boolean isCS122 = true;
        if ("t_bd_supplier".equalsIgnoreCase(payeeType)) {
            SupplierInfo supplierInfo = SupplierFactory.getLocalInstance((Context)ctx).getSupplierInfo(oql);
            if (supplierInfo.isIsInternalCompany() && null != supplierInfo.getInternalCompany() && null != supplierInfo.getInternalCompany().getId()) {
                internalCompanyId = supplierInfo.getInternalCompany().getId().toString();
            }
            String supplierCompanyID = "";
            sql = "SELECT FID FROM T_BD_SUPPLIERCOMPANYINFO WHERE FCOMORGID = '" + companyID + "' AND FSUPPLIERID= '" + payeeID + "'";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowSet.next()) {
                    supplierCompanyID = rowSet.getString("FID");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (StringUtils.isEmpty((String)supplierCompanyID)) {
                return bankInfo;
            }
            SupplierCompanyBankInfo supBankInfo = ArApBillUtil.fetchSupplierCompanyBank(ctx, supplierCompanyID, null, null);
            if (null != supBankInfo) {
                payeeBank = supBankInfo.getBank();
                bankAccount = supBankInfo.getBankAccount();
                email = supBankInfo.getSupplierCompanyInfo() != null ? supBankInfo.getSupplierCompanyInfo().getEmail() : null;
                bankInfo.put("payeeBank", payeeBank);
                bankInfo.put("bankAccount", bankAccount);
                bankInfo.put("email", email);
                bankInfo.put("bankNumber", supBankInfo.getBeneficiaryBankCode());
                if (isCS122) {
                    if (!StringUtils.isEmpty((String)supBankInfo.getBeneficiary())) {
                        bankInfo.put("bankAccountName", supBankInfo.getBeneficiary());
                    } else {
                        bankInfo.put("bankAccountName", supplierInfo.getName());
                    }
                }
                if (supplierInfo.isIsInternalCompany() && !StringUtils.isEmpty((String)internalCompanyId) && null != (accountBankInfo = ArApBillUtil.fetchAccountBank(ctx, internalCompanyId, null, null))) {
                    bankInfo.put("payeeAccountBankO", (String)accountBankInfo);
                }
            } else if (supplierInfo.isIsInternalCompany() && null != (accountBankInfo = ArApBillUtil.getDefaultAcct(ctx, internalCompanyId))) {
                payeeBank = accountBankInfo.getBank().getName();
                bankAccount = accountBankInfo.getBankAccountNumber();
                bankInfo.put("bankNumber", accountBankInfo.getBank().getNumber());
                bankInfo.put("payeeBank", payeeBank);
                bankInfo.put("bankAccount", bankAccount);
                bankInfo.put("payeeAccountBankO", (String)accountBankInfo);
                if (isCS122) {
                    if (!StringUtils.isEmpty((String)accountBankInfo.getAcctName())) {
                        bankInfo.put("bankAccountName", accountBankInfo.getAcctName());
                    } else {
                        bankInfo.put("bankAccountName", supplierInfo.getName());
                    }
                }
            }
        }
        if ("t_bd_customer".equalsIgnoreCase(payeeType)) {
            CustomerInfo customerInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo(oql);
            if (customerInfo.isIsInternalCompany() && null != customerInfo.getInternalCompany() && null != customerInfo.getInternalCompany().getId()) {
                internalCompanyId = customerInfo.getInternalCompany().getId().toString();
            }
            String customerCompanyID = "";
            sql = "SELECT FID FROM T_BD_CUSTOMERCOMPANYINFO WHERE FCOMORGID = '" + companyID + "' AND FCUSTOMERID = '" + payeeID + "'";
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
            try {
                if (rowSet.next()) {
                    customerCompanyID = rowSet.getString("FID");
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (StringUtils.isEmpty((String)customerCompanyID)) {
                return bankInfo;
            }
            CustomerCompanyBankInfo custBankInfo = ArApBillUtil.fetchCustomerCompanyBank(ctx, customerCompanyID, null, null);
            if (null != custBankInfo) {
                payeeBank = custBankInfo.getBank();
                bankAccount = custBankInfo.getBankAccount();
                email = custBankInfo.getCustomerCompanyInfo() != null ? custBankInfo.getCustomerCompanyInfo().getEmail() : null;
                bankInfo.put("payeeBank", payeeBank);
                bankInfo.put("bankAccount", bankAccount);
                bankInfo.put("email", email);
                bankInfo.put("bankNumber", custBankInfo.getBeneficiaryBankCode());
                if (isCS122) {
                    if (!StringUtils.isEmpty((String)custBankInfo.getBeneficiary())) {
                        bankInfo.put("bankAccountName", custBankInfo.getBeneficiary());
                    } else {
                        bankInfo.put("bankAccountName", customerInfo.getName());
                    }
                }
                if (customerInfo.isIsInternalCompany() && !StringUtils.isEmpty((String)internalCompanyId) && null != (accountBankInfo = ArApBillUtil.fetchAccountBank(ctx, internalCompanyId, null, null))) {
                    bankInfo.put("payeeAccountBankO", (String)accountBankInfo);
                }
            } else if (customerInfo.isIsInternalCompany() && null != (accountBankInfo = ArApBillUtil.getDefaultAcct(ctx, internalCompanyId))) {
                bankInfo.put("payeeAccountBankO", (String)accountBankInfo);
                payeeBank = accountBankInfo.getBank().getName();
                bankAccount = accountBankInfo.getBankAccountNumber();
                bankInfo.put("bankNumber", accountBankInfo.getBank().getNumber());
                bankInfo.put("payeeBank", payeeBank);
                bankInfo.put("bankAccount", bankAccount);
                if (isCS122) {
                    if (!StringUtils.isEmpty((String)accountBankInfo.getAcctName())) {
                        bankInfo.put("bankAccountName", accountBankInfo.getAcctName());
                    } else {
                        bankInfo.put("bankAccountName", accountBankInfo.getName());
                    }
                }
            }
        }
        return bankInfo;
    }

    public static SelectorItemCollection margeSelector(SelectorItemCollection s1, SelectorItemCollection s2) {
        int i;
        SelectorItemCollection margeSelector = new SelectorItemCollection();
        if (s1 != null) {
            for (i = 0; i < s1.size(); ++i) {
                margeSelector.add(s1.get(i));
            }
        }
        if (s2 != null) {
            for (i = 0; i < s2.size(); ++i) {
                margeSelector.add(s2.get(i));
            }
        }
        return margeSelector;
    }

    @Deprecated
    public static void setAsstActNameMultiLang(Context ctx, String AsstActID, VerificationBillBaseEntryInfo info) throws BOSException {
        if (null == AsstActID) {
            return;
        }
        IObjectValue ov = (IObjectValue)cusstAcctCache.getIfPresent((Object)AsstActID);
        if (ov == null) {
            BOSUuid uuid = BOSUuid.read((String)AsstActID);
            BOSObjectType objType = uuid.getType();
            IDynamicObject dynamicObject = null == ctx ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
            ov = dynamicObject.getValue(objType, "select name where id = '" + AsstActID + "'");
            cusstAcctCache.put((Object)AsstActID, (Object)ov);
        }
        info.setAcctCussName(ArApBillUtil.getAsstActName(ov, ArApConstants.L1), ArApConstants.L1);
        info.setAcctCussName(ArApBillUtil.getAsstActName(ov, ArApConstants.L2), ArApConstants.L2);
        info.setAcctCussName(ArApBillUtil.getAsstActName(ov, ArApConstants.L3), ArApConstants.L3);
    }

    public static void setAsstActNameMultiLang(Context ctx, IObjectValue asstActObj, VerificationBillBaseEntryInfo info) throws BOSException {
        if (null == asstActObj) {
            return;
        }
        info.setAcctCussName(ArApBillUtil.getAsstActName(asstActObj, ArApConstants.L1), ArApConstants.L1);
        info.setAcctCussName(ArApBillUtil.getAsstActName(asstActObj, ArApConstants.L2), ArApConstants.L2);
        info.setAcctCussName(ArApBillUtil.getAsstActName(asstActObj, ArApConstants.L3), ArApConstants.L3);
    }

    public static Map<String, IObjectValue> batchGetAsstAct(Context ctx, Set<String> ids) throws BOSException {
        HashMap<String, IObjectValue> asstActMap = null;
        if (null == ids || ids.size() == 0) {
            return asstActMap;
        }
        IDynamicObject dynamicObject = null == ctx ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
        HashMap typeMap = new HashMap();
        for (String key : ids) {
            BOSUuid uuid = BOSUuid.read((String)key);
            BOSObjectType objType = uuid.getType();
            if (!typeMap.containsKey(objType)) {
                typeMap.put(objType, new HashSet(ids.size()));
            }
            ((Set)typeMap.get(objType)).add(key);
        }
        if (typeMap.size() == 0) {
            return asstActMap;
        }
        asstActMap = new HashMap<String, IObjectValue>(ids.size());
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection sic = ev.getSelector();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        for (BOSObjectType bostype : typeMap.keySet()) {
            fic.clear();
            fic.add(new FilterItemInfo("id", typeMap.get(bostype), CompareType.INCLUDE));
            ev.setFilter(filter);
            IObjectCollection objCol = dynamicObject.getCollection(bostype, ev);
            for (int i = 0; i < objCol.size(); ++i) {
                IObjectValue obj = objCol.getObject(i);
                asstActMap.put(obj.getString("id"), obj);
            }
        }
        return asstActMap;
    }

    public static void setAsstActNameMultiLang(String AsstActID, VerificationBillBaseEntryInfo info) throws BOSException {
        ArApBillUtil.setAsstActNameMultiLang(null, AsstActID, info);
    }

    public static void checkBadAccountParam(Context ctx, CompanyOrgUnitInfo company, ArApSysParamInfo cache, boolean isBadAcct) throws BOSException, EASBizException {
        AccountViewInfo account = ArApBillUtil.getBadAccountParam(ctx, company, cache, isBadAcct);
        if (account == null) {
            throw new AccountBadDebtException(AccountBadDebtException.NO_SET_PARAM);
        }
    }

    public static AccountViewInfo getBadAccountParam(Context ctx, CompanyOrgUnitInfo company, ArApSysParamInfo cache, boolean isBadAcct) throws BOSException, EASBizException {
        if (company == null) {
            return null;
        }
        company = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId())) : CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
        AccountViewInfo account = null;
        if (cache == null) {
            cache = ctx == null ? ArApBillFacadeFactory.getRemoteInstance().getSysParams(company, ArApBillUtil.getUIParam()) : ArApBillFacadeFactory.getLocalInstance((Context)ctx).getSysParams(company, ArApBillUtil.getUIParam());
        }
        String accuralParam = cache.getBadAccountFacadeAccuralParam();
        if (cache.isDerectorTransferCancelMethod()) {
            account = ArApBillUtil.getBadAcctPrepareAccount("arap001002005", cache.getBadAccountFacadeParams());
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(2))) {
            account = isBadAcct ? ArApBillUtil.getBadAcctPrepareAccount("arap001001002003", cache.getBadAccountFacadeParams()) : ArApBillUtil.getBadAcctPrepareAccount("arap001002002004", cache.getBadAccountFacadeParams());
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(5))) {
            account = isBadAcct ? ArApBillUtil.getBadAcctPrepareAccount("arap001001002001", cache.getBadAccountFacadeParams()) : ArApBillUtil.getBadAcctPrepareAccount("arap001002002002", cache.getBadAccountFacadeParams());
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(6))) {
            account = isBadAcct ? ArApBillUtil.getBadAcctPrepareAccount("arap001001002", cache.getBadAccountFacadeParams()) : ArApBillUtil.getBadAcctPrepareAccount("arap001002002", cache.getBadAccountFacadeParams());
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(3))) {
            account = isBadAcct ? ArApBillUtil.getBadAcctPrepareAccount("arap001001003", cache.getBadAccountFacadeParams()) : ArApBillUtil.getBadAcctPrepareAccount("arap001002003", cache.getBadAccountFacadeParams());
        } else if (accuralParam.equalsIgnoreCase(String.valueOf(1))) {
            account = isBadAcct ? ArApBillUtil.getBadAcctPrepareAccount("arap001001001", cache.getBadAccountFacadeParams()) : ArApBillUtil.getBadAcctPrepareAccount("arap001002001", cache.getBadAccountFacadeParams());
        }
        return account;
    }

    private static AccountViewInfo getBadAcctPrepareAccount(String key, Map countBadDebtMethodOptions) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = null;
        if (countBadDebtMethodOptions.get(key) != null && ((ParamItemInfo)countBadDebtMethodOptions.get(key)).getValue() != null && ((ParamItemInfo)countBadDebtMethodOptions.get(key)).getValue().toString().length() != 0) {
            accountViewInfo = ArApBillUtil.getBadDebtPrepareAccount(countBadDebtMethodOptions, key);
        }
        return accountViewInfo;
    }

    public static AccountViewInfo getBadDebtPrepareAccount(Map value, String key) throws BOSException, EASBizException {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (value.size() <= 0) {
            throw new IllegalArgumentException();
        }
        ParamItemInfo accountIDItem = null;
        accountIDItem = (ParamItemInfo)value.get(key);
        if (accountIDItem == null) {
            throw new AccountBadDebtException(AccountBadDebtException.PREPARE_SUBJECT_NOT_EXISTS);
        }
        String accountIDString = "";
        if (accountIDItem.getValue() == null) {
            throw new AccountBadDebtException(AccountBadDebtException.NO_SET_PARAM);
        }
        accountIDString = accountIDItem.getValue();
        BOSUuid accountID = BOSUuid.read((String)accountIDString);
        ObjectUuidPK accountPK = new ObjectUuidPK(accountID);
        AccountViewInfo account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)accountPK);
        return account;
    }

    private static HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysEnum", SystemEnum.ACCOUNTSRECEIVABLE);
        map.put("isSCM", Boolean.FALSE);
        map.put("isInit", Boolean.FALSE);
        map.put("isBadAcctLoss", Boolean.TRUE);
        return map;
    }

    public static Boolean isTypeOfDigit(String str) {
        boolean isInteger = true;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isDigit(str.charAt(i))) continue;
            isInteger = false;
            break;
        }
        return isInteger;
    }

    public static void handleAsstInfoByType(Context ctx, ArApBillBaseInfo info) throws BOSException {
        ObjectUuidPK pk;
        BOSObjectType bosType;
        String tableName;
        IFMIsqlFacade ifmIsqlFacade = ctx != null ? FMIsqlFacadeFactory.getLocalInstance((Context)ctx) : FMIsqlFacadeFactory.getRemoteInstance();
        if (info.getAsstActType() != null && info.getAsstActID() != null && (tableName = ifmIsqlFacade.getTableNameByBosType(bosType = (pk = new ObjectUuidPK(info.getAsstActID())).getObjectType())) != null && !tableName.equals(info.getAsstActType().getRealtionDataObject())) {
            info.setAsstActID(null);
            info.setAsstActName(null);
            info.setAsstActNumber(null);
        }
    }

    public static List<String> getListFromString(String s, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        String[] strArray = StringUtils.split((String)s, (String)separator);
        for (int i = 0; i < strArray.length; ++i) {
            list.add(strArray[i]);
        }
        return list;
    }

    public static String[] convertListToStringArray(List idSet) {
        String[] idString = new String[]{};
        int i = 0;
        if (idSet.size() > 0) {
            idString = new String[idSet.size()];
            Iterator iterator = idSet.iterator();
            while (iterator.hasNext()) {
                idString[i] = iterator.next().toString();
                ++i;
            }
        }
        return idString;
    }

    public static Map getSummaryData4TempTable(Context ctx, String tableName, String[] fields, String filter) throws BOSException {
        HashMap<String, BigDecimal> sumData = new HashMap<String, BigDecimal>();
        StringBuilder sql = new StringBuilder(100);
        sql.append("SELECT ");
        for (int i = 0; i < fields.length; ++i) {
            sql.append(" SUM(" + fields[i] + ") as " + fields[i]);
            if (i == fields.length - 1) continue;
            sql.append(",");
        }
        sql.append(" FROM " + tableName);
        if (filter != null) {
            sql.append(" WHERE " + filter);
        }
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                for (int i = 0; i < fields.length; ++i) {
                    sumData.put(fields[i], rs.getBigDecimal(fields[i]));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return sumData;
    }

    public static BOTMappingCollection handleBotMappingInfo(Context ctx, String srcBillType, String targetBosType, String[] ids, String[] entryName) throws BOSException, BOTPException, BTPException {
        BOTMappingCollection botMappingColl = null;
        IBOTMapping iBOTMapping = ctx == null ? BOTMappingFactory.getRemoteInstance() : BOTMappingFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection botpSelectors = new SelectorItemCollection();
        botpSelectors.add("*");
        botpSelectors.add("rules.ruleSegments.*");
        botMappingColl = iBOTMapping.getMappingCollectionForSelectUseRuleFilter(srcBillType, targetBosType, DefineSysEnum.BTP, null, ids, entryName, new ArrayList(), botpSelectors);
        return botMappingColl;
    }

    public static FilterInfo getDefaultFilterForQuery(CompanyOrgUnitCollection companyColl) {
        FilterInfo fi = null;
        fi = new FilterInfo();
        if (companyColl.size() == 0) {
            return fi;
        }
        FilterItemCollection fic = fi.getFilterItems();
        HashSet<String> companyIdSet = new HashSet<String>();
        HashSet<String> companyCUIdSet = new HashSet<String>();
        HashSet<String> cuNumberSet = new HashSet<String>();
        HashSet<String> lnUps = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        StringBuffer upperOrgLongNumberSet = new StringBuffer();
        for (int i = 0; i < companyColl.size(); ++i) {
            CompanyOrgUnitInfo company = companyColl.get(i);
            CtrlUnitInfo ctrlUnit = company.getCU();
            companyIdSet.add(company.getId().toString());
            companyCUIdSet.add(company.getCU().getId().toString());
            String ln = company.getLongNumber();
            String[] lnSecs = ln.split("!");
            int size = lnSecs.length;
            for (int j = 0; j < size; ++j) {
                if (j != 0) {
                    sb.append("!");
                    upperOrgLongNumberSet.append(",");
                }
                sb.append(lnSecs[j]);
                upperOrgLongNumberSet.append("'").append(sb).append("'");
                if (j >= size - 1) continue;
                lnUps.add(sb.toString());
            }
            String cuLongNumber = ctrlUnit.getLongNumber();
            String[] cuNumbers = cuLongNumber.split("!");
            for (int j = 0; j < cuNumbers.length; ++j) {
                cuNumberSet.add(cuNumbers[j]);
            }
        }
        fic.add(new FilterItemInfo("company.id", companyIdSet, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
        fic.add(new FilterItemInfo("glAsstActTypeGrp.id", null, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("glAsstActTypeGrp.shareTactic", (Object)String.valueOf(3), CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("CU.id", companyCUIdSet, CompareType.INCLUDE));
        fic.add(new FilterItemInfo("glAsstActTypeGrp.id", null, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("glAsstActTypeGrp.shareTactic", (Object)String.valueOf(3), CompareType.EQUALS));
        fic.add(new FilterItemInfo("id", (Object)("select FAsstActTypeID from T_BD_AsstActTypeReference where FAssignCompanyID in (select fid from t_org_company where flongnumber in(" + upperOrgLongNumberSet.toString() + "))"), CompareType.INNER));
        if (lnUps.size() != 0) {
            fic.add(new FilterItemInfo("company.longNumber", lnUps, CompareType.INCLUDE));
            fic.add(new FilterItemInfo("glAsstActTypeGrp.id", null));
            fic.add(new FilterItemInfo("glAsstActTypeGrp.shareTactic", (Object)String.valueOf(5)));
            fic.add(new FilterItemInfo("CU.number", cuNumberSet, CompareType.INCLUDE));
            fic.add(new FilterItemInfo("id", (Object)("select FAsstActTypeID  from T_BD_AsstActTypeDefault where FISACCOUNTCUSSENT = 1 and fCompanyId in" + ListUtil.transList2String(companyIdSet)), CompareType.INNER));
            fi.setMaskString("(#0 or (#1 and #2 and #3) or (#4 and #5 and #6) or #7 or (#8 and #9) or (#10 and #11)) and #12");
        } else {
            fic.add(new FilterItemInfo("glAsstActTypeGrp.shareTactic", (Object)String.valueOf(5)));
            fic.add(new FilterItemInfo("CU.number", cuNumberSet, CompareType.INCLUDE));
            fic.add(new FilterItemInfo("id", (Object)("select FAsstActTypeID  from T_BD_AsstActTypeDefault where FISACCOUNTCUSSENT = 1 and fCompanyId in" + ListUtil.transList2String(companyIdSet)), CompareType.INNER));
            fi.setMaskString("(#0 or (#1 and #2 and #3) or (#4 and #5 and #6) or #7 or (#8 and #9)) and #10");
        }
        return fi;
    }

    public static AsstActTypeCollection getDefaultAsstActTypeColl(Context ctx, Set companyIds) throws BOSException {
        ICompanyOrgUnit iCompanyOrgUnit;
        IAsstActType iAsstActType;
        AsstActTypeCollection asstActTypeColl = new AsstActTypeCollection();
        EntityViewInfo ev = new EntityViewInfo();
        EntityViewInfo companyEV = new EntityViewInfo();
        if (ctx == null) {
            iAsstActType = AsstActTypeFactory.getRemoteInstance();
            iCompanyOrgUnit = CompanyOrgUnitFactory.getRemoteInstance();
        } else {
            iAsstActType = AsstActTypeFactory.getLocalInstance((Context)ctx);
            iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        }
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection companySelectors = new SelectorItemCollection();
        companySelectors.add("id");
        companySelectors.add("name");
        companySelectors.add("longNumber");
        companySelectors.add("CU.id");
        companySelectors.add("CU.name");
        companySelectors.add("CU.longNumber");
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)companyIds, CompareType.INCLUDE));
        companyEV.setFilter(filterInfo);
        companyEV.setSelector(companySelectors);
        CompanyOrgUnitCollection companyColl = iCompanyOrgUnit.getCompanyOrgUnitCollection(companyEV);
        ev.setFilter(ArApBillUtil.getDefaultFilterForQuery(companyColl));
        ev.getSorter().add(new SorterItemInfo("number"));
        asstActTypeColl = iAsstActType.getAsstActTypeCollection(ev);
        return asstActTypeColl;
    }

    public static Set getAsstActUpdateCompany(Context ctx) throws BOSException {
        HashSet<BOSUuid> companyIdSet = new HashSet<BOSUuid>();
        ICompanyOrgUnit iCompanyOrgUnit = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"SELECT FCOMPANYID FROM T_BD_SYSTEMSTATUSCTROL t1 INNER JOIN T_BD_SYSTEMSTATUS  t2 on t1.FSYSTEMSTATUSID = t2.FID where t2.FNAME in (12,13) and t1.FISSTART = 1\n", CompareType.INNER));
        ev.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        ev.setSelector(selector);
        CompanyOrgUnitCollection company = iCompanyOrgUnit.getCompanyOrgUnitCollection(ev);
        for (int i = 0; i < company.size(); ++i) {
            companyIdSet.add(company.get(i).getId());
        }
        return companyIdSet;
    }

    public static FilterInfo addFilter(FilterInfo filter, FilterItemInfo filterItem, Integer index, String expr) {
        FilterItemCollection filterColl = filter.getFilterItems();
        String oldMaskString = filter.getMaskString();
        String filterMask = "( #" + index + " " + expr + " #" + (index + 1) + " )";
        oldMaskString = ArApBillUtil.replaceMaskString(oldMaskString, index + 1, filterColl.size());
        filterColl.addObject(index.intValue(), (IObjectValue)filterItem);
        oldMaskString = oldMaskString.replaceFirst("#" + index, filterMask);
        filter.setMaskString(oldMaskString);
        return filter;
    }

    public static String replaceMaskString(String maskString, Integer index, Integer maxIndex) {
        for (int i = maxIndex.intValue(); i >= index; --i) {
            String currentIndex = "#" + i;
            String nextIndex = "#" + (i + 1);
            maskString = maskString.replaceFirst(currentIndex, nextIndex);
        }
        return maskString;
    }

    public static DataBaseCollection getCustomRecPayBillType(Context ctx) throws BOSException {
        int i;
        IReceivingBillType iReceivingBillType;
        IPaymentBillType iPaymentBillType;
        DataBaseCollection recPayTypeColl = new DataBaseCollection();
        if (ctx == null) {
            iPaymentBillType = PaymentBillTypeFactory.getRemoteInstance();
            iReceivingBillType = ReceivingBillTypeFactory.getRemoteInstance();
        } else {
            iPaymentBillType = PaymentBillTypeFactory.getLocalInstance((Context)ctx);
            iReceivingBillType = ReceivingBillTypeFactory.getLocalInstance((Context)ctx);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("isPreSet", (Object)0, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
        HashSet<Integer> sourceTypeEnumSet = new HashSet<Integer>();
        sourceTypeEnumSet.add(100);
        sourceTypeEnumSet.add(101);
        filterInfo.getFilterItems().add(new FilterItemInfo("sourceSysType", sourceTypeEnumSet, CompareType.INCLUDE));
        ev.setFilter(filterInfo);
        PaymentBillTypeCollection payBillTypeColl = iPaymentBillType.getPaymentBillTypeCollection(ev);
        ReceivingBillTypeCollection recBillTypeColl = iReceivingBillType.getReceivingBillTypeCollection(ev);
        for (i = 0; i < payBillTypeColl.size(); ++i) {
            recPayTypeColl.add((DataBaseInfo)payBillTypeColl.get(i));
        }
        for (i = 0; i < recBillTypeColl.size(); ++i) {
            recPayTypeColl.add((DataBaseInfo)recBillTypeColl.get(i));
        }
        return recPayTypeColl;
    }

    public static Map getParamValueMap(Context ctx, String paramNumber, Set orgIds) throws BOSException, EASBizException {
        IParamControl iParamControl = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        HashMap<String, String> paramValueMap = new HashMap<String, String>();
        for (Object orgId : orgIds) {
            String value = iParamControl.getParamValue((IObjectPK)new ObjectUuidPK(orgId.toString()), paramNumber);
            paramValueMap.put(orgId.toString(), value);
        }
        return paramValueMap;
    }

    public static Boolean checkBigDecimal(BigDecimal amount) throws EASBizException {
        if (amount == null) {
            return true;
        }
        if (amount.scale() > 4 || amount.precision() - amount.scale() > 13) {
            return false;
        }
        return true;
    }

    public static AccountBankInfo getDefaultAcct(Context ctx, String companyId) throws BOSException {
        IAccountBank iAccountBank = ctx == null ? AccountBankFactory.getRemoteInstance() : AccountBankFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("company.*");
        selector.add("bank.*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isDefaultPayment", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)0));
        view.setFilter(filter);
        AccountBankCollection coll = iAccountBank.getAccountBankCollection(view);
        if (coll.size() > 0) {
            return coll.get(0);
        }
        return null;
    }

    public static Boolean isClosedBankAccount(Context ctx, String bankAccountNumber) {
        HashSet<String> bankAccountNumberSet = new HashSet<String>();
        bankAccountNumberSet.add(bankAccountNumber);
        return ArApBillUtil.isClosedBankAccount(ctx, bankAccountNumberSet).get(bankAccountNumber);
    }

    public static Map<String, Boolean> isClosedBankAccount(Context ctx, Set<String> bankAccountNumberSet) {
        HashMap<String, Boolean> isClosedMap = new HashMap<String, Boolean>();
        if (bankAccountNumberSet == null || bankAccountNumberSet.size() == 0) {
            return isClosedMap;
        }
        Iterator<String> it = bankAccountNumberSet.iterator();
        while (it.hasNext()) {
            isClosedMap.put(it.next(), false);
        }
        IAccountBank accountBank = null;
        AccountBankCollection accountBankCollection = null;
        try {
            accountBank = ctx == null ? AccountBankFactory.getRemoteInstance() : AccountBankFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("isClosed");
            sic.add("bankAccountNumber");
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bankAccountNumber", bankAccountNumberSet, CompareType.INCLUDE));
            evi.setFilter(filterInfo);
            accountBankCollection = accountBank.getAccountBankCollection(evi);
            if (accountBankCollection != null) {
                for (int i = 0; i < accountBankCollection.size(); ++i) {
                    AccountBankInfo bankInfo = accountBankCollection.get(i);
                    if (!bankInfo.isIsClosed()) continue;
                    isClosedMap.put(bankInfo.getBankAccountNumber(), true);
                }
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage());
        }
        return isClosedMap;
    }

    public static Boolean isUseOldShowHead(Context ctx) throws EASBizException, BOSException {
        IBaseServiceFacade iBaseServiceFacade = ctx == null ? BaseServiceFacadeFactory.getRemoteInstance() : BaseServiceFacadeFactory.getLocalInstance(ctx);
        String paramValue = iBaseServiceFacade.getCommonParamValue("ISUSE_OLD_SHOWEHEAD");
        if (paramValue != null) {
            return Boolean.valueOf(paramValue);
        }
        return false;
    }

    public static Boolean verifyAsstActIgnore(Context ctx, CompanyOrgUnitInfo company, String asstActId, Boolean isAp) throws EASBizException, BOSException {
        Boolean isIgnore = true;
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)asstActId, (boolean)true);
        if (bosType == null) {
            return isIgnore;
        }
        EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)bosType);
        String tableName = entity.getTable().getName().toLowerCase(Locale.ENGLISH);
        if ("t_bd_customer".equals(tableName) || "t_bd_supplier".equals(tableName)) {
            String sql = "select fid from " + tableName + " where FUSEDSTATUS <> 1 and fid = '" + asstActId + "'";
            IFMIsqlFacade iSql = ctx == null ? FMIsqlFacadeFactory.getRemoteInstance() : FMIsqlFacadeFactory.getLocalInstance((Context)ctx);
            try {
                String cusSql;
                IRowSet rs = iSql.executeQuery(sql, null);
                if (rs.next()) {
                    isIgnore = false;
                }
                if (isIgnore.booleanValue() && "t_bd_supplier".equals(tableName) && company != null) {
                    String apSql = "SELECT fid FROM T_BD_SUPPLIERCOMPANYINFO  where FSUPPLIERID = '" + asstActId + "'\tand FCOMORGID = '" + company.getId().toString();
                    apSql = isAp != false ? apSql + "' and (FISFREEZEPAYMENT = 1 or FUsingStatus = 1)" : apSql + "' and  FUsingStatus = 1 ";
                    rs = iSql.executeQuery(apSql, null);
                    if (rs.next()) {
                        isIgnore = false;
                    }
                }
                if (isIgnore.booleanValue() && "t_bd_customer".equals(tableName) && company != null && (rs = iSql.executeQuery(cusSql = "SELECT fid FROM T_BD_CUSTOMERCOMPANYINFO  where FCUSTOMERID = '" + asstActId + "'\tand FCOMORGID = '" + company.getId().toString() + "' and  FUsingStatus = 1", null)).next()) {
                    isIgnore = false;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isIgnore;
    }

    public static void setDefaultValueZero(Context ctx, BillBaseInfo info) {
        Map<String, List<String>> amtFields = ArApBillUtil.getCheckFieldsMap(info, false);
        Map<String, List<String>> localAmtFields = ArApBillUtil.getCheckFieldsMap(info, true);
        for (Map.Entry<String, List<String>> e : localAmtFields.entrySet()) {
            if (amtFields.containsKey(e.getKey())) {
                amtFields.get(e.getKey()).addAll((Collection<String>)e.getValue());
                continue;
            }
            amtFields.put(e.getKey(), e.getValue());
        }
        for (Map.Entry<String, List<String>> e : amtFields.entrySet()) {
            if ("bill".equals(e.getKey())) {
                ArApBillUtil.setBillZero((AbstractObjectValue)info, e.getValue());
                continue;
            }
            ArApBillUtil.setEntryZero((AbstractObjectCollection)info.get(e.getKey()), e.getValue());
        }
    }

    private static void setBillZero(AbstractObjectValue objectValue, List<String> fields) {
        if (objectValue == null || fields == null) {
            return;
        }
        for (String field : fields) {
            BigDecimal value = objectValue.getBigDecimal(field);
            if (!objectValue.containsKey(field) || value != null) continue;
            objectValue.setBigDecimal(field, BigDecimal.ZERO);
        }
    }

    private static void setEntryZero(AbstractObjectCollection entryColl, List<String> fields) {
        if (entryColl == null) {
            return;
        }
        for (int i = 0; i < entryColl.size(); ++i) {
            BillEntryBaseInfo entryInfo = (BillEntryBaseInfo)entryColl.getObject(i);
            ArApBillUtil.setBillZero((AbstractObjectValue)entryInfo, fields);
        }
    }

    public static void checkAmtAndAmtLocalPrecision(Context ctx, BillBaseInfo info, CurrencyInfo currency) throws EASBizException, BOSException {
        int basePrecision = 0;
        int precision = 0;
        CompanyOrgUnitInfo company = info.getCompany();
        if (company.getBaseCurrency() == null || company.getBaseCurrency().get("precision") == null) {
            ICompanyOrgUnit iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            basePrecision = iCompany.getCompanyOrgUnitInfo("select baseCurrency.precision where id = '" + company.getId().toString() + "'").getBaseCurrency().getPrecision();
        } else {
            basePrecision = company.getBaseCurrency().getPrecision();
        }
        if (currency.get("precision") == null) {
            ICurrency iCurrency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("precision"));
            precision = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currency.getId()), sic).getPrecision();
        } else {
            precision = currency.getPrecision();
        }
        Map<String, List<String>> amtFields = ArApBillUtil.getCheckFieldsMap(info, false);
        Iterator<Map.Entry<String, List<String>>> it = amtFields.entrySet().iterator();
        StringBuilder errorMsg = new StringBuilder();
        StringBuilder amountErrorgMsg = new StringBuilder();
        while (it.hasNext()) {
            Map.Entry<String, List<String>> e = it.next();
            if ("bill".equals(e.getKey())) {
                ArApBillUtil.checkPrecision((AbstractObjectValue)info, e.getValue(), precision, amountErrorgMsg);
                if (!(info instanceof OtherBillInfo) || ((OtherBillInfo)info).getPayerCurrency() == null) continue;
                CurrencyInfo payerCurrency = ((OtherBillInfo)info).getPayerCurrency();
                int payerCurrencyPrecision = 0;
                if (payerCurrency.getId().equals((Object)currency.getId())) {
                    payerCurrencyPrecision = precision;
                } else if (payerCurrency.get("precision") == null) {
                    ICurrency iCurrency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("precision"));
                    payerCurrencyPrecision = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(payerCurrency.getId()), sic).getPrecision();
                } else {
                    payerCurrencyPrecision = payerCurrency.getPrecision();
                }
                ArrayList<String> checkFields = new ArrayList<String>();
                checkFields.add("payerAmount");
                ArApBillUtil.checkPrecision((AbstractObjectValue)info, checkFields, payerCurrencyPrecision, errorMsg);
                continue;
            }
            ArApBillUtil.checkEntryPrecision((AbstractObjectCollection)info.get(e.getKey()), e.getValue(), precision, amountErrorgMsg);
        }
        if (amountErrorgMsg.length() > 0) {
            errorMsg.append(ArApBillUtil.getResourceStr(ctx, "BILLFIELDS_GT_CURRENCYPRECISION", new Object[]{precision})).append("\r\n");
            errorMsg.append((CharSequence)amountErrorgMsg);
        }
        amountErrorgMsg.setLength(0);
        Map<String, List<String>> amtLocalFields = ArApBillUtil.getCheckFieldsMap(info, true);
        for (Map.Entry<String, List<String>> e : amtLocalFields.entrySet()) {
            if ("bill".equals(e.getKey())) {
                ArApBillUtil.checkPrecision((AbstractObjectValue)info, e.getValue(), basePrecision, amountErrorgMsg);
                continue;
            }
            ArApBillUtil.checkEntryPrecision((AbstractObjectCollection)info.get(e.getKey()), e.getValue(), basePrecision, amountErrorgMsg);
        }
        if (amountErrorgMsg.length() > 0) {
            errorMsg.append(ArApBillUtil.getResourceStr(ctx, "BILLFIELDS_GT_BASECURRENCYPRECISION", new Object[]{basePrecision})).append("\r\n");
            errorMsg.append((CharSequence)amountErrorgMsg);
        }
        if (errorMsg.length() > 0) {
            throw new OtherBillBizException(OtherBillBizException.COMMON, new Object[]{errorMsg.toString()});
        }
    }

    private static Map<String, List<String>> getCheckFieldsMap(BillBaseInfo info, boolean isLocalAmount) {
        HashMap<String, List<String>> fieldsMap = new HashMap<String, List<String>>();
        String bosType = info.getBOSType().toString();
        List<String> amountFields = null;
        if ("FC910EF3".equals(bosType)) {
            amountFields = ArApAmountFactory.getArOtherbillAmountFields(isLocalAmount);
        } else if ("48DA3A71".equals(bosType)) {
            amountFields = ArApAmountFactory.getApOtherbillAmountFields(isLocalAmount);
            amountFields.remove("payerAmount");
        } else if ("D001019A".equals(bosType)) {
            amountFields = ArApAmountFactory.getPayRequestBillAmountFields(isLocalAmount);
        } else if ("FA44FD5B".equals(bosType)) {
            amountFields = ArApAmountFactory.getReceivingBillAmountFields(isLocalAmount);
        } else if ("40284E81".equals(bosType)) {
            amountFields = ArApAmountFactory.getPaymentBillAmountFields(isLocalAmount);
        } else {
            return fieldsMap;
        }
        for (String field : amountFields) {
            ArrayList<String> fieldList;
            if (StringUtils.isEmpty((String)field)) continue;
            String[] fieldArr = field.split("\\.");
            if (fieldArr.length == 1) {
                if (fieldsMap.get("bill") == null) {
                    fieldList = new ArrayList<String>();
                    fieldList.add(fieldArr[0]);
                    fieldsMap.put("bill", fieldList);
                    continue;
                }
                ((List)fieldsMap.get("bill")).add(fieldArr[0]);
                continue;
            }
            if (fieldArr.length != 2) continue;
            if (fieldsMap.get(fieldArr[0]) == null) {
                fieldList = new ArrayList();
                fieldList.add(fieldArr[1]);
                fieldsMap.put(fieldArr[0], fieldList);
                continue;
            }
            ((List)fieldsMap.get(fieldArr[0])).add(fieldArr[1]);
        }
        return fieldsMap;
    }

    private static void checkEntryPrecision(AbstractObjectCollection entryColl, List<String> fields, int precision, StringBuilder errorMsg) throws BOSException {
        if (entryColl == null) {
            return;
        }
        for (int i = 0; i < entryColl.size(); ++i) {
            BillEntryBaseInfo entryInfo = (BillEntryBaseInfo)entryColl.getObject(i);
            ArApBillUtil.checkPrecision((AbstractObjectValue)entryInfo, fields, precision, errorMsg);
        }
    }

    private static void checkPrecision(AbstractObjectValue objectValue, List<String> fields, int precision, StringBuilder errorMsg) throws BOSException {
        if (objectValue == null || fields == null) {
            return;
        }
        Iterator<String> it = fields.iterator();
        boolean hasError = false;
        EntityObjectInfo billEntryEntity = null;
        while (it.hasNext()) {
            String field = it.next();
            BigDecimal value = objectValue.getBigDecimal(field);
            if (value == null || (value = value.stripTrailingZeros()).scale() <= precision) continue;
            if (!hasError) {
                try {
                    BOSObjectType bosType = objectValue.getBOSType();
                    if (entityObjectCache.get(bosType) == null) {
                        billEntryEntity = EntityObjectInfoHelp.getEntity((BOSObjectType)objectValue.getBOSType());
                        entityObjectCache.put(bosType, billEntryEntity);
                    } else {
                        billEntryEntity = entityObjectCache.get(bosType);
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                String billAlias = billEntryEntity.getAlias();
                errorMsg.append("\u3010" + billAlias + "\u3011:").append("\u3010");
            }
            hasError = true;
            try {
                PropertyInfo propertyInfo = billEntryEntity.getFieldByFullName(field);
                String fieldsAlias = propertyInfo.getAlias();
                errorMsg.append(fieldsAlias).append(":").append(value.toPlainString()).append(",");
            }
            catch (InvalidDAOMetaDataException e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (hasError) {
            errorMsg.deleteCharAt(errorMsg.length() - 1);
            errorMsg.append("\u3011").append("\r\n");
        }
    }

    public static String getResourceStr(Context ctx, String key, Object[] params) {
        String res = "com.kingdee.eas.fi.arap.ArapResource";
        if (ctx != null) {
            return ResourceBase.getString((String)res, (String)key, (Locale)ctx.getLocale(), (Object[])params);
        }
        return EASResource.getString((String)res, (String)key, (Object[])params);
    }

    public static String check4InvoiceExchange(Context ctx, OtherBillInfo info) {
        String msg = "";
        if (!BillStatusEnum.AUDITED.equals((Object)info.getBillStatus())) {
            msg = ArApBillUtil.getResourceStr(ctx, "UNAUDIT_CANNOT_CHANGE_INVOICE", null);
        }
        if (info.isIsBizBill()) {
            msg = ArApBillUtil.getResourceStr(ctx, "BIZBILL_CANNOUT_CHANGE_INVOICE", null);
        }
        if (info.isIsMatchGenerate()) {
            msg = ArApBillUtil.getResourceStr(ctx, "MATCHBILL_CANNOT_CHANGE_INVOICE", null);
        }
        if (info.isIsReverseBill()) {
            msg = ArApBillUtil.getResourceStr(ctx, "REVERSEBILL_CANNOT_CHANGE_INVOICE", null);
        }
        return msg;
    }

    public static EntityObjectInfo getEntityObjectInfoByBOSUuid(Context ctx, BOSUuid id) {
        IMetaDataLoader loader = ctx != null ? MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx) : MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo info = loader.getEntity(id.getType());
        return info;
    }

    public static EntityObjectInfo getEntityObjectInfoByBOSType(Context ctx, String bosType) {
        IMetaDataLoader loader = ctx != null ? MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx) : MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo info = loader.getEntity(new BOSObjectType(bosType));
        return info;
    }

    public static ICoreBase getBizInterfaceByBOSUuid(Context ctx, BOSUuid id) throws BOSException {
        try {
            EntityObjectInfo info = ArApBillUtil.getEntityObjectInfoByBOSUuid(ctx, id);
            String factoryClassName = info.getBusinessImplFactory();
            Class<?> factoryClass = Class.forName(factoryClassName);
            if (ctx != null) {
                Method method = factoryClass.getMethod("getLocalInstance", Context.class);
                Object[] ctxArgs = new Context[]{ctx};
                Object obj = method.invoke(null, ctxArgs);
                return (ICoreBase)obj;
            }
            Method method = factoryClass.getMethod("getRemoteInstance", null);
            Object obj = method.invoke(null, null);
            return (ICoreBase)obj;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public static ICoreBase getBizInterfaceByBOSType(Context ctx, String bosType) throws BOSException {
        try {
            EntityObjectInfo info = ArApBillUtil.getEntityObjectInfoByBOSType(ctx, bosType);
            String factoryClassName = info.getBusinessImplFactory();
            Class<?> factoryClass = Class.forName(factoryClassName);
            if (ctx != null) {
                Method method = factoryClass.getMethod("getLocalInstance", Context.class);
                Object[] ctxArgs = new Context[]{ctx};
                Object obj = method.invoke(null, ctxArgs);
                return (ICoreBase)obj;
            }
            Method method = factoryClass.getMethod("getRemoteInstance", null);
            Object obj = method.invoke(null, null);
            return (ICoreBase)obj;
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    public static BigDecimal getAmtFromBillInfo(IObjectValue billInfo, String field) {
        BigDecimal res = BigDecimal.ZERO;
        if (field.indexOf(".") > -1) {
            String[] fieldArr = field.split(".");
            if (fieldArr.length == 2) {
                IObjectCollection entryColl = (IObjectCollection)billInfo.get(fieldArr[0]);
                for (int i = 0; i < entryColl.size(); ++i) {
                    BigDecimal entryAmt = entryColl.getObject(i).getBigDecimal(fieldArr[1]);
                    res = res.add(entryAmt);
                }
            }
        } else {
            return (BigDecimal)billInfo.get(field);
        }
        return res;
    }

    public static Set getFieldSetFromBill(IObjectValue billInfo, String field) {
        String[] fieldArr;
        HashSet<Object> res = new HashSet<Object>();
        if (field.indexOf(".") > -1 && (fieldArr = field.split("\\.")).length == 2) {
            IObjectCollection entryColl = (IObjectCollection)billInfo.get(fieldArr[0]);
            for (int i = 0; i < entryColl.size(); ++i) {
                res.add(entryColl.getObject(i).get(fieldArr[1]));
            }
        }
        return res;
    }

    public static Object getFieldFromBill(IObjectValue billInfo, String field, Integer index) {
        Object value = null;
        if (field.indexOf(".") > -1) {
            String[] fieldArr = field.split("\\.");
            IObjectValue parentValue = billInfo;
            for (int i = 0; i < fieldArr.length; ++i) {
                value = parentValue.get(fieldArr[i]);
                if (value instanceof IObjectValue) {
                    parentValue = (IObjectValue)value;
                    continue;
                }
                if (!(value instanceof IObjectCollection)) continue;
                parentValue = ((IObjectCollection)value).getObject(index.intValue());
            }
        } else {
            value = billInfo.get(field);
        }
        return value;
    }

    public static void addSubEntityByField(JoinQueryInfo query, SubEntityInfo subEntity, String field, Boolean isSelector) throws BOSException {
        EntityObjectInfo clientEntity = subEntity.getEntityRef();
        SubEntityInfo clientSubEntity = subEntity;
        if (query.getUnits().get(field) != null) {
            return;
        }
        if (field.indexOf(".") > -1) {
            String[] fieldArr = field.split("\\.");
            String subObjectName = fieldArr[0];
            for (int i = 0; i < fieldArr.length - 1; ++i) {
                SubEntityInfo supplierSubEntityInfo;
                LinkPropertyInfo supplierProp = (LinkPropertyInfo)clientEntity.getPropertyByName(fieldArr[i]);
                EntityObjectInfo supplierEntity = supplierProp.getRelationship().getSupplierObject();
                if (query.getSubObjects().get(subObjectName) == null) {
                    supplierSubEntityInfo = new SubEntityInfo((QueryInfo)query, supplierEntity);
                    supplierSubEntityInfo.setName(subObjectName);
                    query.getSubObjects().add((SubObjectInfo)supplierSubEntityInfo);
                } else {
                    supplierSubEntityInfo = (SubEntityInfo)query.getSubObjects().get(subObjectName);
                }
                JoinInfo join = query.getJoinWithEntities(clientSubEntity, supplierSubEntityInfo, JoinType.INNERJOIN, supplierProp);
                query.getJoins().add(join);
                if (i == fieldArr.length - 2) {
                    PropertyRefInfo pr = new PropertyRefInfo(null, supplierSubEntityInfo, supplierEntity.getPropertyByName(fieldArr[i + 1]));
                    QueryFieldInfo queryField = new QueryFieldInfo();
                    queryField.setName(field);
                    queryField.getPropertyRefs().add(pr);
                    if (isSelector.booleanValue()) {
                        queryField.setIsSelector(true);
                        queryField.setIsFilter(true);
                    } else {
                        queryField.setIsSelector(false);
                        queryField.setIsFilter(true);
                    }
                    query.getUnits().add((PropertyUnitInfo)queryField);
                }
                subObjectName = subObjectName + "." + fieldArr[i + 1];
                clientEntity = supplierEntity;
                clientSubEntity = supplierSubEntityInfo;
            }
        } else {
            PropertyRefInfo pr = new PropertyRefInfo(null, clientSubEntity, clientEntity.getPropertyByName(field));
            QueryFieldInfo queryField = new QueryFieldInfo();
            queryField.setName(field);
            queryField.setIsSelector(true);
            queryField.setIsFilter(true);
            queryField.getPropertyRefs().add(pr);
            query.getUnits().add((PropertyUnitInfo)queryField);
            if (isSelector.booleanValue()) {
                queryField.setIsSelector(true);
                queryField.setIsFilter(true);
            } else {
                queryField.setIsSelector(false);
                queryField.setIsFilter(true);
            }
        }
    }
}

