/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ArApMaterialHelper {
    public static HashMap getMultiMeasureUnits(MaterialInfo[] materialInfos, MeasureUnitInfo[] measureUnitInfos) throws BOSException {
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getRemoteInstance();
        String oqlWhere = ArApMaterialHelper.getMultiMeasureUnitOQL(materialInfos, measureUnitInfos);
        HashMap<String, MultiMeasureUnitInfo> mulUnitsMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return mulUnitsMap;
        }
        MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oqlWhere);
        MultiMeasureUnitInfo mulUnitInfo = null;
        int num = mulUnits.size();
        for (int i = 0; i < num; ++i) {
            mulUnitInfo = mulUnits.get(i);
            mulUnitsMap.put(mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString(), mulUnitInfo);
        }
        return mulUnitsMap;
    }

    public static Map getMultiMeasrueUnits(Context ctx, List materialUnits) throws BOSException {
        HashMap mulUnitsMap = new HashMap();
        StringBuffer sbsql = new StringBuffer();
        boolean isFirst = true;
        String materialID = null;
        String measureUnitID = null;
        int i = 0;
        for (Object[] objs : materialUnits) {
            if (objs[0] == null || objs[1] == null) continue;
            materialID = ((BOSUuid)objs[0]).toString();
            measureUnitID = ((BOSUuid)objs[1]).toString();
            if (isFirst) {
                isFirst = false;
                sbsql.append("( material.id = '");
                sbsql.append(materialID);
                sbsql.append("' and measureUnit.id = '");
                sbsql.append(measureUnitID);
                sbsql.append("')");
            } else {
                sbsql.append(" or (material.id = '");
                sbsql.append(materialID);
                sbsql.append("' and measureUnit.id = '");
                sbsql.append(measureUnitID);
                sbsql.append("')");
            }
            if (i % 100 == 99) {
                ArApMaterialHelper.loadMmuData(ctx, mulUnitsMap, sbsql);
                isFirst = true;
                sbsql.setLength(0);
            }
            ++i;
        }
        ArApMaterialHelper.loadMmuData(ctx, mulUnitsMap, sbsql);
        return mulUnitsMap;
    }

    private static void loadMmuData(Context ctx, HashMap mulUnitsMap, StringBuffer sbsql) throws BOSException {
        if (sbsql.length() == 0) {
            return;
        }
        String oql = null;
        oql = "select material.id, measureUnit.id, qtyPrecision where " + sbsql.toString();
        MultiMeasureUnitCollection mulUnits = null;
        MultiMeasureUnitInfo mulUnitInfo = null;
        IMultiMeasureUnit imultiUnit = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        mulUnits = imultiUnit.getMultiMeasureUnitCollection(oql);
        int num = mulUnits.size();
        for (int j = 0; j < num; ++j) {
            mulUnitInfo = mulUnits.get(j);
            mulUnitsMap.put(mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString(), mulUnitInfo);
        }
    }

    public static Map getMultiMeasrueUnits(Context ctx, String billid) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> mulUnitsMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (StringUtils.isEmpty((String)billid)) {
            return mulUnitsMap;
        }
        String sql = null;
        String sTableName = "";
        BOSObjectType billtype = BOSUuid.read((String)billid).getType();
        sTableName = "48DA3A71".equals(billtype.toString()) ? "t_ap_otherbillentry" : "t_ar_otherbillentry";
        sql = " Select Material.FID as FID, Material.FMaterialID as FMaterialID,  Material.FMeasureUnitID as FMeasureUnitID,Material.FQtyPrecision as FQtyPrecision  From T_BD_MultiMeasureUnit Material  Inner Join " + sTableName + " OtherbillEntry on Material.FMaterialID = OtherbillEntry.FMaterialID            And Material.FMeasureUnitID=OtherbillEntry.FMeasureUnitID  Where OtherbillEntry.FParentID='" + billid + "'";
        try {
            IRowSet rowset = null;
            if (ctx == null) {
                ISQLExecutor sqlexecutor = SQLExecutorFactory.getRemoteInstance((String)sql);
                rowset = sqlexecutor.executeSQL();
            } else {
                rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
            }
            if (rowset != null && rowset.size() > 0) {
                while (rowset.next()) {
                    MultiMeasureUnitInfo mulUnitInfo = new MultiMeasureUnitInfo();
                    String id = rowset.getString("FID");
                    String materialID = rowset.getString("FMaterialID");
                    String measureUnitID = rowset.getString("FMeasureUnitID");
                    int qtyPrecision = rowset.getInt("FQtyPrecision");
                    if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)materialID) || StringUtils.isEmpty((String)measureUnitID)) continue;
                    mulUnitInfo.setId(BOSUuid.read((String)id));
                    MaterialInfo materialInfo = new MaterialInfo();
                    materialInfo.setId(BOSUuid.read((String)materialID));
                    mulUnitInfo.setMaterial(materialInfo);
                    MeasureUnitInfo measureUnitInfo = new MeasureUnitInfo();
                    measureUnitInfo.setId(BOSUuid.read((String)measureUnitID));
                    mulUnitInfo.setMeasureUnit(measureUnitInfo);
                    mulUnitInfo.setQtyPrecision(qtyPrecision);
                    mulUnitsMap.put(materialID + measureUnitID, mulUnitInfo);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("sql excute error in getMultiMeasrueUnits()", (Throwable)e);
        }
        return mulUnitsMap;
    }

    private static String getMultiMeasureUnitOQL(MaterialInfo[] materialInfos, MeasureUnitInfo[] measureUnitInfos) {
        String oqlWhere = "";
        boolean isFirst = true;
        String materialID = null;
        String mesureUnitID = null;
        int size = materialInfos.length;
        for (int i = 0; i < size; ++i) {
            if (materialInfos[i] == null || measureUnitInfos[i] == null) continue;
            materialID = materialInfos[i].getId().toString();
            mesureUnitID = measureUnitInfos[i].getId().toString();
            if (StringUtils.isEmpty((String)materialID) || StringUtils.isEmpty((String)mesureUnitID)) continue;
            if (isFirst) {
                isFirst = false;
                oqlWhere = "(material.id = '" + materialID + "' and measureUnit.id = '" + mesureUnitID + "')";
                continue;
            }
            oqlWhere = oqlWhere + " or (material.id = '" + materialID + "' and measureUnit.id = '" + mesureUnitID + "')";
        }
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return oqlWhere;
        }
        oqlWhere = "select material.id, measureUnit.id, qtyPrecision where " + oqlWhere;
        return oqlWhere;
    }
}

