/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.transaction.EJBTransactionProxy;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class DBUtil
extends DbUtil {
    private static final int MAX_STATMENT = 200;
    private static final String NEWLINE = "\t\n";
    public static Map<String, String> tabMap = new HashMap<String, String>();

    public static int[] execute(Context ctx, String[] sql) throws BOSException {
        Connection conn = null;
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        int[] results = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.createStatement();
            if (sql != null) {
                for (int i = 0; i < sql.length; ++i) {
                    statement.addBatch(sql[i]);
                    sqlstr.append(sql[i]).append(NEWLINE);
                }
            }
            results = statement.executeBatch();
            statement.clearBatch();
        }
        catch (SQLException exc) {
            try {
                throw new BOSException("Sql execute exception : " + sqlstr, (Throwable)exc);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
        return results;
    }

    public static Object takeValue(Context ctx, String sql) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        Connection conn;
        block6: {
            Object object;
            block5: {
                conn = null;
                stmt = null;
                rs = null;
                conn = EJBFactory.getConnection((Context)ctx);
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs != null) break block5;
                Object var5_5 = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
                return var5_5;
            }
            try {
                if (!rs.next()) break block6;
                object = rs.getObject(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, stmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
            return object;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return null;
    }

    public static void dropTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        if (tempTableName != null) {
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).releaseTemporaryTableName(tempTableName);
        }
    }

    public static void releaseTempTable(Context ctx, String tempTableName) throws BOSException, EASBizException {
        if (tempTableName != null) {
            Connection con = null;
            try {
                con = EJBFactory.getConnection((Context)ctx);
                TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
                tmpPool.releaseTable(tempTableName);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)con);
            }
        }
    }

    public static String createTempTable(Context ctx, String serial, String[][] tableFields) throws BOSException {
        String tempTableName = "tempTableName";
        String sqlcreatetable = DBUtil.transCreateTable(ctx, DBUtil.getCreateTableSQl(tempTableName, tableFields).toString());
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tempTableName = tmpPool.createTempTable(sqlcreatetable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    public static String transCreateTable(Context ctx, String sql) {
        if (ctx.get((Object)"dbType") != null) {
            String dbType = (String)ctx.get((Object)"dbType");
            if ((dbType = dbType.toLowerCase()).indexOf("db2") > -1) {
                sql = sql.toLowerCase();
                sql = sql.replaceAll("numeric\\(28,16\\)", "numeric(21,8)");
                sql = sql.replaceAll("numeric\\(19,4\\)", "numeric(17,4)");
            }
        }
        return sql;
    }

    public static StringBuffer getCreateTableSQl(String tempTableName, String[][] fields) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(tempTableName);
        sql.append("(");
        for (int i = 0; i < fields.length; ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(fields[i][0]);
            sql.append(" ");
            sql.append(fields[i][1]);
        }
        sql.append(")");
        return sql;
    }

    public static void close(Connection conn, PreparedStatement[] pm, ResultSet[] rs) throws BOSException {
        try {
            int i;
            for (i = 0; null != rs && i < rs.length; ++i) {
                if (null == rs[i]) continue;
                rs[i].close();
            }
            for (i = 0; null != pm && i < pm.length; ++i) {
                if (null == pm[i]) continue;
                pm[i].close();
            }
            if (null != conn) {
                conn.close();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void close(Connection conn, Statement stm) throws BOSException {
        try {
            if (null != conn) {
                conn.close();
            }
            if (null != stm) {
                stm.close();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void execBatchSql(Context ctx, ArrayList sqlList, boolean isUpdateBill) throws BOSException {
        if (isUpdateBill || sqlList.size() >= 200) {
            DBUtil.execute(ctx, sqlList.toArray(new String[sqlList.size()]));
            sqlList.clear();
        }
    }

    public static void execBatchSql(Connection conn, ArrayList sqlList, boolean isUpdateBill) throws BOSException, SQLException {
        if (isUpdateBill || sqlList.size() >= 200) {
            DBUtil.execute(conn, sqlList.toArray(new String[sqlList.size()]));
            sqlList.clear();
        }
    }

    public static void execute(Connection conn, String[] sql) throws BOSException, SQLException {
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            statement = conn.createStatement();
            if (sql != null) {
                for (int i = 0; i < sql.length; ++i) {
                    statement.addBatch(sql[i]);
                    sqlstr.append(sql[i]).append(NEWLINE);
                }
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            throw new SQLException(e + EASResource.getString((String)"com.kingdee.eas.scm.cal.CALAutoGenerateResource", (String)"233_DBUtil") + sqlstr.toString());
        }
        finally {
            if (statement != null) {
                statement.clearBatch();
                statement.close();
            }
        }
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique) throws BOSException {
        DBUtil.createTempTableIndex(ctx, tableName, columns, isUnique, false);
    }

    public static void createTempTableIndex(Context ctx, String tableName, String columns, boolean isUnique, boolean isClustered) throws BOSException {
        try {
            TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
            tmpPool.createIndex(tableName, columns, isUnique, isClustered);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void execute(Connection conn, String sql) throws BOSException, SQLException {
        Statement statement = null;
        StringBuffer sqlstr = new StringBuffer();
        try {
            statement = conn.createStatement();
            statement.execute(sql);
        }
        catch (SQLException e) {
            throw new SQLException(e + "SQL:" + sqlstr.toString());
        }
        finally {
            if (statement != null) {
                statement.clearBatch();
                statement.close();
            }
        }
    }

    public static Object takeValue(Connection conn, String sql) throws BOSException {
        ResultSet rs;
        PreparedStatement stmt;
        block6: {
            Object object;
            block5: {
                stmt = null;
                rs = null;
                stmt = conn.prepareStatement(sql);
                rs = stmt.executeQuery();
                if (rs != null) break block5;
                Object var4_4 = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
                return var4_4;
            }
            try {
                if (!rs.next()) break block6;
                object = rs.getObject(1);
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException("Sql execute exception : " + sql, (Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)stmt);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
            return object;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt);
        return null;
    }

    public static String createTempTable(Context ctx, String sql) throws BOSException {
        TempTablePool tmpPool = TempTablePool.getInstance((Context)ctx);
        try {
            return tmpPool.createTempTable(sql);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static void AnalyseTable(Context ctx, Connection con, String table) throws SQLException {
        TempTablePool.getInstance((Context)ctx).analyzeTable(con, table);
    }

    public static String transIds2TempTable(Context ctx, Collection ids, String id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" create table temp (").append(id).append(" varchar(44) )");
        String tempTable = DBUtil.createTempTable(ctx, sql.toString());
        DBUtil.createTempTableIndex(ctx, tempTable, id, false);
        sql.setLength(0);
        sql.append(" insert into ").append(tempTable).append(" values (?)");
        Connection conn = null;
        PreparedStatement statement = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            statement = conn.prepareStatement(sql.toString());
            String fid2 = "";
            int i = 0;
            for (String fid2 : ids) {
                statement.setString(1, fid2);
                statement.addBatch();
                if (++i < 500) continue;
                statement.executeBatch();
                statement.clearBatch();
                i = 0;
            }
            statement.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtil.close(conn, new PreparedStatement[]{statement}, null);
                throw throwable;
            }
        }
        DBUtil.close(conn, new PreparedStatement[]{statement}, null);
        return tempTable;
    }

    public static String getTableNameById(Context ctx, String pk) {
        if (StringUtils.isEmpty((String)pk)) {
            return null;
        }
        BOSObjectType bosType = BOSUuid.getBOSObjectType((String)pk, (boolean)true);
        if (null == bosType) {
            return null;
        }
        String type = bosType.toString();
        String tableName = tabMap.get(type);
        if (StringUtils.isEmpty((String)tableName)) {
            IMetaDataLoader loader = null;
            loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            EntityObjectInfo entity = loader.getEntity(bosType);
            tableName = entity.getTable().getName();
            tabMap.put(type, tableName);
        }
        return tableName;
    }

    public static String convertToIDStr(IObjectPK[] pks) {
        if (null == pks) {
            return null;
        }
        StringBuilder lockIDs = new StringBuilder(pks.length * 44);
        IObjectPK pk2 = null;
        for (IObjectPK pk2 : pks) {
            if (null == pk2 || StringUtils.isEmpty((String)pk2.toString())) continue;
            if (lockIDs.length() > 0) {
                lockIDs.append(",");
            }
            lockIDs.append("'").append(pk2.toString()).append("'");
        }
        return lockIDs.toString();
    }

    public static void addSQLLock(Context ctx, IObjectPK[] pks) throws BOSException {
        if (null == pks) {
            return;
        }
        IObjectPK pk = pks[0];
        String lockIDs = DBUtil.convertToIDStr(pks);
        if (null == pk || !BOSUuid.isValid((String)pk.toString(), (boolean)true) || StringUtils.isEmpty((String)lockIDs)) {
            return;
        }
        String tableName = DBUtil.getTableNameById(ctx, pk.toString());
        String lock = " UPDATE " + tableName + " SET FID = FID WHERE FID in (" + lockIDs + ")";
        DBUtil.execute((Context)ctx, (String)lock);
    }

    public static void execute4TxAction(Context ctx, String[] sql, int txAction) throws BOSException {
        try {
            if (null == sql || sql.length == 0) {
                return;
            }
            Method method = DBUtil.class.getMethod("execute", Context.class, String[].class);
            DBUtil util = new DBUtil();
            EJBTransactionProxy txInvoker = EJBFactory.getEJBTransactionProxy((Object)((Object)util));
            txInvoker.invoke(method, new Object[]{ctx, sql}, txAction);
        }
        catch (Throwable e) {
            StringBuilder buf = new StringBuilder(300);
            buf.append("exception: [sql] is [").append(NEWLINE);
            for (int i = 0; i < sql.length; ++i) {
                buf.append(sql[i]).append(NEWLINE);
            }
            buf.append("], [txAction] is [").append(txAction).append("]");
            throw new BOSException(buf.toString(), e);
        }
    }
}

