/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashSet;

public abstract class Helper {
    public static IObjectValue getDynamicObject(Context ctx, String bosId) throws BOSException {
        IObjectValue objectValue = null;
        if (bosId != null && bosId.trim().length() != 0) {
            BOSUuid uuid = BOSUuid.read((String)bosId);
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            BOSObjectType objType = uuid.getType();
            IDynamicObject dynamicObject = null;
            dynamicObject = ctx == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)ctx);
            objectValue = dynamicObject.getValue(objType, (IObjectPK)pk);
        }
        return objectValue;
    }

    public static PersonInfo getPersonInfo_OnlyPK(String pk) {
        PersonInfo person = null;
        if (pk != null) {
            person = new PersonInfo();
            person.setId(BOSUuid.read((String)pk));
        }
        return person;
    }

    public static AdminOrgUnitInfo getAdminOrgUnitInfo_OnlyPK(String pk) {
        AdminOrgUnitInfo adminOrgInfo = null;
        if (pk != null) {
            adminOrgInfo = new AdminOrgUnitInfo();
            adminOrgInfo.setId(BOSUuid.read((String)pk));
        }
        return adminOrgInfo;
    }

    public static CompanyOrgUnitInfo getCompanyOrgUnitInfo_OnlyPK(String pk) {
        CompanyOrgUnitInfo companyOrgInfo = null;
        if (pk != null) {
            companyOrgInfo = new CompanyOrgUnitInfo();
            companyOrgInfo.setId(BOSUuid.read((String)pk));
        }
        return companyOrgInfo;
    }

    public static AccountViewInfo getAccountViewInfo_OnlyPK(String pk) {
        AccountViewInfo account = null;
        if (pk != null) {
            account = new AccountViewInfo();
            account.setId(BOSUuid.read((String)pk));
        }
        return account;
    }

    public static CurrencyInfo getCurrencyInfo_OnlyPK(String pk) {
        CurrencyInfo currency = null;
        if (pk != null) {
            currency = new CurrencyInfo();
            currency.setId(BOSUuid.read((String)pk));
        }
        return currency;
    }

    public static AsstActTypeInfo getAcctCussTypeInfo_OnlyPK(String pk) {
        AsstActTypeInfo asstActType = null;
        if (pk != null) {
            asstActType = new AsstActTypeInfo();
            asstActType.setId(BOSUuid.read((String)pk));
        }
        return asstActType;
    }

    public static VerificateBillTypeEnum changeBillType(boolean isArBill, int billType) {
        VerificateBillTypeEnum billTypeEnum = null;
        if (isArBill) {
            switch (billType) {
                case 102: {
                    billTypeEnum = VerificateBillTypeEnum.SaleInvoice;
                    break;
                }
                case 103: {
                    billTypeEnum = VerificateBillTypeEnum.SaleChargeInvoice;
                    break;
                }
                case 101: {
                    billTypeEnum = VerificateBillTypeEnum.OtherReceiveBill;
                    break;
                }
                case 104: {
                    billTypeEnum = VerificateBillTypeEnum.AR_DebitAdjust;
                }
            }
        } else {
            switch (billType) {
                case 202: {
                    billTypeEnum = VerificateBillTypeEnum.PurInvoice;
                    break;
                }
                case 203: {
                    billTypeEnum = VerificateBillTypeEnum.PurChargeInvoice;
                    break;
                }
                case 201: {
                    billTypeEnum = VerificateBillTypeEnum.OtherPaymentBill;
                    break;
                }
                case 204: {
                    billTypeEnum = VerificateBillTypeEnum.AP_DebitAdjust;
                }
            }
        }
        return billTypeEnum;
    }

    public static FilterInfo getCsspGrpFilter(Context ctx, String csspGrpId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)csspGrpId)) {
            return null;
        }
        FilterInfo filter = new FilterInfo();
        CSSPGroupInfo grpInfo = new CSSPGroupInfo();
        grpInfo.put("id", (Object)csspGrpId);
        ICSSPGroup iCsspGrp = null;
        iCsspGrp = ctx != null ? CSSPGroupFactory.getLocalInstance((Context)ctx) : CSSPGroupFactory.getRemoteInstance();
        TreeBaseCollection csspGrps = iCsspGrp.getAllChildren((TreeBaseInfo)grpInfo);
        String propName = "browseGroup.id";
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(csspGrpId);
        for (CSSPGroupInfo info : csspGrps) {
            idSet.add(info.getId().toString());
        }
        filter.getFilterItems().add(new FilterItemInfo(propName, idSet, CompareType.INCLUDE));
        return filter;
    }

    public static VerificateBillTypeEnum getRecPayVeriBillTypeEnum(boolean isRec, String str, BigDecimal val) {
        VerificateBillTypeEnum veriType = VerificateBillTypeEnum.PAY_AP_STOCK_PAYMENT;
        String[] paybillTypeNumbers = new String[]{"201", "202", "205", "203", "204", "206", "210", "211", "221"};
        String[] recBillTypeNumbers = new String[]{"100", "101", "104", "103", "102", "105", "121"};
        String[] sys = null;
        if (isRec) {
            sys = recBillTypeNumbers;
            veriType = val != null && val.signum() > 0 ? VerificateBillTypeEnum.REC_AR_SELL_REC : VerificateBillTypeEnum.REC_AR_REFUNDMENT_SELL_REC;
        } else {
            sys = paybillTypeNumbers;
            veriType = val != null && val.signum() > 0 ? VerificateBillTypeEnum.PAY_AP_STOCK_PAYMENT : VerificateBillTypeEnum.PAY_AP_REFUNDMENT_STOCK_PAYMENT;
        }
        if (str != null) {
            for (int i = 0; i < sys.length; ++i) {
                if (!str.equals(sys[i])) continue;
                veriType = VerificateBillTypeEnum.getEnum((int)Integer.parseInt(str));
                break;
            }
        }
        return veriType;
    }
}

