/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.Constant;
import com.kingdee.eas.fi.arap.util.NumericBizCalculator;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Map;

public abstract class QuantityMeasureUtils {
    public static final int POSINDEX_SOURCEBASERATE = 0;
    public static final int POSINDEX_TARGETBASERATE = 1;
    private static Map mulUnits = new Hashtable();

    public static BigDecimal getUnitBaseExchangeRate(MaterialInfo material, MeasureUnitInfo unit) throws EASBizException, BOSException {
        String materialId = material == null ? null : material.getId().toString();
        String unitId = unit == null ? null : unit.getId().toString();
        return QuantityMeasureUtils._getMultiUnitBaseExchangeRates(null, materialId, unitId);
    }

    public static BigDecimal[] getMultiUnitBaseExchangeRates(MaterialInfo material, MeasureUnitInfo srcUnit, MeasureUnitInfo targetUnit) throws EASBizException, BOSException {
        String materialId = material == null ? null : material.getId().toString();
        String srcUnitId = srcUnit == null ? null : srcUnit.getId().toString();
        String targetUnitId = srcUnit == null ? null : srcUnit.getId().toString();
        return QuantityMeasureUtils.getMultiUnitBaseExchangeRates(materialId, srcUnitId, targetUnitId);
    }

    public static BigDecimal[] getMultiUnitBaseExchangeRates(String materialId, String srcUnitId, String targetUnitId) throws EASBizException, BOSException {
        return new BigDecimal[]{QuantityMeasureUtils._getMultiUnitBaseExchangeRates(null, materialId, srcUnitId), QuantityMeasureUtils._getMultiUnitBaseExchangeRates(null, materialId, targetUnitId)};
    }

    public static BigDecimal[] getMultiUnitBaseExchangeRates(Context ctx, String materialId, String srcUnitId, String targetUnitId) throws EASBizException, BOSException {
        return new BigDecimal[]{QuantityMeasureUtils._getMultiUnitBaseExchangeRates(ctx, materialId, srcUnitId), QuantityMeasureUtils._getMultiUnitBaseExchangeRates(ctx, materialId, targetUnitId)};
    }

    private static BigDecimal _getMultiUnitBaseExchangeRates(Context ctx, String materialId, String unitId) throws EASBizException, BOSException {
        BigDecimal rate = QuantityMeasureUtils.effectualExchangeRate(null);
        if (materialId != null && unitId != null) {
            if (mulUnits.containsKey(materialId)) {
                Map ls = (Map)mulUnits.get(materialId);
                if (ls.containsKey(unitId)) {
                    rate = (BigDecimal)ls.get(unitId);
                } else {
                    MultiMeasureUnitInfo mulUnit = QuantityMeasureUtils.getRemoteInterface(ctx).getMultiUnit(materialId, unitId);
                    if (mulUnit != null && NumericBizCalculator.isDistrustExchangeRate(mulUnit.getBaseConvsRate())) {
                        rate = mulUnit.getBaseConvsRate();
                        ls.put(unitId, rate);
                    }
                }
            } else {
                MultiMeasureUnitInfo mulUnit = QuantityMeasureUtils.getRemoteInterface(ctx).getMultiUnit(materialId, unitId);
                if (mulUnit != null && NumericBizCalculator.isDistrustExchangeRate(mulUnit.getBaseConvsRate())) {
                    Hashtable<String, BigDecimal> ls = new Hashtable<String, BigDecimal>();
                    rate = mulUnit.getBaseConvsRate();
                    ls.put(unitId, rate);
                    mulUnits.put(materialId, ls);
                }
            }
        }
        return rate;
    }

    private static IMultiMeasureUnit getRemoteInterface(Context ctx) throws BOSException {
        IMultiMeasureUnit ie = null;
        ie = ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        return ie;
    }

    public static BigDecimal effectualExchangeRate(BigDecimal v) {
        return NumericBizCalculator.equalsZero(v) ? Constant.EXCHANGERATE_DEFAULT : v;
    }
}

