/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util.cor;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.CurrencyExchangeRateUtils;
import com.kingdee.eas.fi.arap.util.NumericBizCalculator;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.arap.util.QuantityMeasureUtils;
import com.kingdee.eas.fi.arap.util.cor.HandlerNode;
import java.math.BigDecimal;
import java.util.HashMap;

public class Latitude
extends HashMap {
    private static final long serialVersionUID = -3004667329264546335L;
    public static final String LATITUDE_MATERIAL = "material";
    public static final String LATITUDE_MATERIALPRICEPRECISION = "material_price_precision";
    public static final String LATITUDE_MATERIALUNITPRECISION = "material_unit_precision";
    public static final String LATITUDE_COMPANY = "company";
    public static final String LATITUDE_CURRENCY = "currency";
    public static final String LATITUDE_EXCHANGERATE = "exchangerate";
    public static final String LATITUDE_CONVERTMODE = "convertmode";
    public static final String LATITUDE_CURRENCYPRECISION = "currency_precision";
    public static final String LATITUDE_MEASUREUNIT = "measureunit";
    public static final String LATITUDE_NEWMEASUREUNIT = "new_measureunit";
    public static final String LATITUDE_QTYEXCHANGERATE = "qty_exchangerate";
    public static final String LATITUDE_NEWQTYEXCHANGERATE = "new_qty_exchangerate";
    public static final String LATITUDE_QUANTITY = "quantity";
    public static final String LATITUDE_PRICE = "price";
    public static final String LATITUDE_TAXRATE = "taxrate";
    public static final String LATITUDE_TAXPRICE = "taxprice";
    public static final String LATITUDE_DISCOUNTRATE = "discountrate";
    public static final String LATITUDE_REALTAXPRICE = "realtaxprice";
    public static final String LATITUDE_DISCOUNTAMOUNT = "discountamount";
    public static final String LATITUDE_AMOUNT = "amount";
    public static final String LATITUDE_AMOUNTLOCAL = "amountlocal";
    public static final String LATITUDE_TAX = "tax";
    public static final String LATITUDE_TAXLOCAL = "taxlocal";
    public static final String LATITUDE_AMOUNTTAX = "amounttax";
    public static final String LATITUDE_AMOUNTTAXLOCAL = "amounttaxlocal";
    public static final String LATITUDE_AMOUNTTAXTOTAL = "amounttax_total";
    public static final String LATITUDE_AMOUNTTAXLOCALTOTAL = "amounttaxlocal_total";
    public static final String LATITUDE_VERIFYAMOUNT = "verifyamount";
    public static final String LATITUDE_VERIFYAMOUNTLOCAL = "verifyamountlocal";
    public static final String LATITUDE_UNVERIFYAMOUNT = "unverifyamount";
    public static final String LATITUDE_UNVERIFYAMOUNTLOCAL = "unverifyamountlocal";
    public static final String LATITUDE_VERIFYAMOUNTTOTAL = "verifyamount_total";
    public static final String LATITUDE_VERIFYAMOUNTLOCALTOTAL = "verifyamountlocal_total";
    public static final String LATITUDE_UNVERIFYAMOUNTTOTAL = "unverifyamount_total";
    public static final String LATITUDE_UNVERIFYAMOUNTLOCALTOTAL = "unverifyamountlocal_total";
    public static final String LATITUDE_BADAMOUNT = "badamount";
    public static final String LATITUDE_BADAMOUNTLOCAL = "badamountlocal";
    public static final String LATITUDE_BADAMOUNTTOTAL = "badamount_total";
    public static final String LATITUDE_BADAMOUNTLOCALTOTAL = "badamountlocal_total";
    private HandlerNode entruestNode = null;

    public Latitude() {
    }

    protected Latitude(HandlerNode node) {
        this.entruestNode = node;
    }

    protected void setEntrustNode(HandlerNode node) {
        this.entruestNode = node;
    }

    public MaterialInfo visitMaterial() {
        return (MaterialInfo)this.get(LATITUDE_MATERIAL);
    }

    public CurrencyInfo visitCurrency() {
        return (CurrencyInfo)this.get(LATITUDE_CURRENCY);
    }

    public int visitCurrencyPrecision() throws EASBizException, BOSException {
        int scale = PrecisionFormatUtils.effectualPrecision(-1);
        if (this.containsKey(LATITUDE_CURRENCYPRECISION)) {
            scale = PrecisionFormatUtils.effectualPrecision(this.visitInt(LATITUDE_CURRENCYPRECISION));
        } else if (this.containsKey(LATITUDE_CURRENCY)) {
            scale = PrecisionFormatUtils.getCurrencyPrecision(this.visitCurrency());
            this.put(LATITUDE_CURRENCYPRECISION, new Integer(scale));
        }
        return scale;
    }

    public int visitMaterialPricePrecision() throws EASBizException, BOSException {
        int scale = PrecisionFormatUtils.effectualPrecision(-1);
        if (this.containsKey(LATITUDE_MATERIALPRICEPRECISION)) {
            scale = PrecisionFormatUtils.effectualPrecision(this.visitInt(LATITUDE_MATERIALPRICEPRECISION));
        } else if (this.containsKey(LATITUDE_MATERIAL)) {
            scale = PrecisionFormatUtils.getMaterialPricePrecision(this.visitMaterial());
            this.put(LATITUDE_MATERIALPRICEPRECISION, new Integer(scale));
        }
        return scale;
    }

    public int visitMaterialUnitPrecision() throws EASBizException, BOSException {
        int scale = PrecisionFormatUtils.effectualPrecision(-1);
        if (this.containsKey(LATITUDE_MATERIALUNITPRECISION)) {
            scale = PrecisionFormatUtils.effectualPrecision(this.visitInt(LATITUDE_MATERIALUNITPRECISION));
        } else if (this.containsKey(LATITUDE_MATERIAL) && this.containsKey(LATITUDE_NEWMEASUREUNIT)) {
            scale = PrecisionFormatUtils.getQuantityPrecision(this.visitMaterial(), this.visitMeasureUnit(LATITUDE_NEWMEASUREUNIT));
            this.put(LATITUDE_MATERIALUNITPRECISION, new Integer(scale));
        }
        return scale;
    }

    public BigDecimal visitOldUnitBaseExchangeRate() throws EASBizException, BOSException {
        BigDecimal rate = NumericBizCalculator.effectualExchangeRate(null);
        if (this.containsKey(LATITUDE_QTYEXCHANGERATE)) {
            rate = this.visitExchangeRate(LATITUDE_QTYEXCHANGERATE);
        } else if (this.containsKey(LATITUDE_MATERIAL) && this.containsKey(LATITUDE_MEASUREUNIT)) {
            rate = QuantityMeasureUtils.getUnitBaseExchangeRate(this.visitMaterial(), this.visitMeasureUnit(LATITUDE_MEASUREUNIT));
            this.put(LATITUDE_QTYEXCHANGERATE, rate);
        }
        return rate;
    }

    public BigDecimal visitUnitBaseExchangeRate() throws EASBizException, BOSException {
        BigDecimal rate = NumericBizCalculator.effectualExchangeRate(null);
        if (this.containsKey(LATITUDE_NEWQTYEXCHANGERATE)) {
            rate = this.visitExchangeRate(LATITUDE_NEWQTYEXCHANGERATE);
        } else if (this.containsKey(LATITUDE_MATERIAL) && this.containsKey(LATITUDE_NEWMEASUREUNIT)) {
            rate = QuantityMeasureUtils.getUnitBaseExchangeRate(this.visitMaterial(), this.visitMeasureUnit(LATITUDE_NEWMEASUREUNIT));
            this.put(LATITUDE_NEWQTYEXCHANGERATE, rate);
        }
        return rate;
    }

    public int visitConvertmode() throws EASBizException, BOSException {
        if (this.containsKey(LATITUDE_CONVERTMODE)) {
            return this.visitInt(LATITUDE_CONVERTMODE);
        }
        if (this.containsKey(LATITUDE_CURRENCY)) {
            ExchangeRateInfo ri = CurrencyExchangeRateUtils.getExchangeRate(this.visitCurrency());
            int mode = CurrencyExchangeRateUtils.visitCovertMode(ri);
            this.put(LATITUDE_CONVERTMODE, new Integer(mode));
            return mode;
        }
        return 0;
    }

    public MeasureUnitInfo visitMeasureUnit(String unitKey) {
        return (MeasureUnitInfo)this.get(unitKey);
    }

    public CompanyOrgUnitInfo visitCompany() {
        return (CompanyOrgUnitInfo)this.get(LATITUDE_COMPANY);
    }

    public BigDecimal visitExchangeRate(String rateKey) {
        return NumericBizCalculator.effectualExchangeRate(this.visitNumeric(rateKey));
    }

    public BigDecimal visitNumeric(String key) {
        BigDecimal value = NumericBizCalculator.effectualNumeric(null);
        if (this.containsKey(key)) {
            value = NumericBizCalculator.effectualNumeric((BigDecimal)this.get(key));
        } else if (this.entruestNode != null) {
            value = this.entruestNode.getNodeValue(key);
        }
        return value;
    }

    public int visitInt(String key) {
        Object o = this.get(key);
        if (o != null) {
            return Integer.valueOf(o.toString());
        }
        return -1;
    }
}

