/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.IEASBillEntryInfo;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.scm.sd.sale.OrderException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;

public class SaleContractDisposer
implements IReceivingDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal arAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        IEASBillHeadInfo receivingBillInfo;
        if (action.getDestBill() != null && action.getDestBill().getBOSType().toString().equals(new BOSObjectType("FA44FD5B").toString()) && (receivingBillInfo = (IEASBillHeadInfo)action.getDestBill()).getId() != null) {
            String receivingBillId = receivingBillInfo.getId().toString();
            String contractId = null;
            IObjectCollection receiveEntryNum = receivingBillInfo.getEntries();
            if (receiveEntryNum != null && receiveEntryNum.size() > 0) {
                IEASBillEntryInfo receivingEnInfo = (IEASBillEntryInfo)receiveEntryNum.getObject(0);
                contractId = receivingEnInfo.getSourceBillId();
            }
            if (contractId != null && contractId.trim().length() != 0 && receivingBillId != null && receivingBillId.trim().length() != 0) {
                String sp = " \r\n";
                StringBuffer strSQL = new StringBuffer();
                if (action.getActionType().getValue() == 5) {
                    this.checkAdvance(receivingBillInfo, ctx, contractId, receivingBillId);
                    strSQL.append("UPDATE T_SD_SaleContract").append(sp);
                    strSQL.append("SET FPreReceived =").append(sp);
                    strSQL.append("          (SELECT T_SD_SaleContract.FPreReceived + Sum(IsNull(rb.FAmount, 0)) ").append(sp);
                    strSQL.append("               AS FPreReceived").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rb").append(sp);
                    strSQL.append("         WHERE rb.FReceivingBillID = ? AND T_SD_SaleContract.FID = ?)").append(sp);
                    strSQL.append("WHERE (T_SD_SaleContract.FID = ?)").append(sp);
                    DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{receivingBillId, contractId, contractId});
                    strSQL.setLength(0);
                    strSQL.append("UPDATE T_SD_SaleContractEntry").append(sp);
                    strSQL.append("SET FPreReceived =").append(sp);
                    strSQL.append("          (SELECT T_SD_SaleContractEntry.FPreReceived + Sum(IsNull(rbe.FAmount, 0)) ").append(sp);
                    strSQL.append("               AS FPreReceived ").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FSourceBillEntryId = T_SD_SaleContractEntry.FID AND rbe.FReceivingBillID = '").append(receivingBillId).append("')").append(sp);
                    strSQL.append("WHERE T_SD_SaleContractEntry.FID IN").append(sp);
                    strSQL.append("          (SELECT rbe.FSourceBillEntryId ").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FReceivingBillID = '").append(receivingBillId).append("' )").append(sp);
                    DbUtil.execute((Context)ctx, (String)strSQL.toString());
                    strSQL.setLength(0);
                    strSQL.append("UPDATE T_SD_SaleContractEntry").append(sp);
                    strSQL.append("SET FUnPrereceivedAmount =").append(sp);
                    strSQL.append("          (SELECT DISTINCT T_SD_SaleContractEntry.FPrepayment - T_SD_SaleContractEntry.FPreReceived ").append(sp);
                    strSQL.append("               AS FUnPrereceivedAmount").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FSourceBillEntryId = T_SD_SaleContractEntry.FID AND rbe.FReceivingBillID = '").append(receivingBillId).append("')").append(sp);
                    strSQL.append("WHERE T_SD_SaleContractEntry.FID IN").append(sp);
                    strSQL.append("          (SELECT rbe.FSourceBillEntryId ").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FReceivingBillID = '").append(receivingBillId).append("' )").append(sp);
                    DbUtil.execute((Context)ctx, (String)strSQL.toString());
                    strSQL.setLength(0);
                } else if (action.getActionType().getValue() == 6) {
                    strSQL.append("UPDATE T_SD_SaleContract").append(sp);
                    strSQL.append("SET FPreReceived =").append(sp);
                    strSQL.append("          (SELECT T_SD_SaleContract.FPreReceived -  Sum(IsNull(rb.FAmount, 0))").append(sp);
                    strSQL.append("               AS FPreReceived").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rb").append(sp);
                    strSQL.append("         WHERE rb.FReceivingBillID = ? AND T_SD_SaleContract.FID = ?)").append(sp);
                    strSQL.append("WHERE (T_SD_SaleContract.FID = ?)").append(sp);
                    DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{receivingBillId, contractId, contractId});
                    strSQL.setLength(0);
                    strSQL.append("UPDATE T_SD_SaleContractEntry").append(sp);
                    strSQL.append("SET FPreReceived =").append(sp);
                    strSQL.append("          (SELECT T_SD_SaleContractEntry.FPreReceived - Sum(IsNull(rbe.FAmount, 0)) ").append(sp);
                    strSQL.append("               AS FPreReceived ").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FSourceBillEntryId = T_SD_SaleContractEntry.FID AND rbe.FReceivingBillID = '").append(receivingBillId).append("')").append(sp);
                    strSQL.append("WHERE T_SD_SaleContractEntry.FID IN").append(sp);
                    strSQL.append("          (SELECT rbe.FSourceBillEntryId ").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FReceivingBillID = '").append(receivingBillId).append("' )").append(sp);
                    DbUtil.execute((Context)ctx, (String)strSQL.toString());
                    strSQL.setLength(0);
                    strSQL.append("UPDATE T_SD_SaleContractEntry").append(sp);
                    strSQL.append("SET FUnPrereceivedAmount =").append(sp);
                    strSQL.append("          (SELECT DISTINCT T_SD_SaleContractEntry.FPrepayment - T_SD_SaleContractEntry.FPreReceived ").append(sp);
                    strSQL.append("               AS FUnPrereceivedAmount").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FSourceBillEntryId = T_SD_SaleContractEntry.FID AND rbe.FReceivingBillID = '").append(receivingBillId).append("')").append(sp);
                    strSQL.append("WHERE T_SD_SaleContractEntry.FID IN").append(sp);
                    strSQL.append("          (SELECT rbe.FSourceBillEntryId ").append(sp);
                    strSQL.append("         FROM T_CAS_ReceivingBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FReceivingBillID = '").append(receivingBillId).append("' )").append(sp);
                    DbUtil.execute((Context)ctx, (String)strSQL.toString());
                    strSQL.setLength(0);
                }
            }
        }
    }

    private void checkAdvance(IEASBillHeadInfo receivingBillInfo, Context ctx, String contractId, String receivingBillId) throws EASBizException, BOSException {
        try {
            BigDecimal ZERO = new BigDecimal("0.00");
            boolean isAllowed = this.getParamValue(receivingBillInfo, ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select sc.fprepayment,Sum(IsNull(rbe.FAmount, 0)),sc.FPrereceived from T_SD_SaleContract sc,T_CAS_ReceivingBillEntry rbe ");
            sql.append(" WHERE rbe.FReceivingBillID = '").append(receivingBillId).append("'");
            sql.append(" AND sc.FID ='").append(contractId).append("'");
            sql.append(" group by sc.fid,sc.fprepayment,sc.FPrereceived");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (!isAllowed) {
                while (rs.next()) {
                    if (rs.getBigDecimal(1).compareTo(rs.getBigDecimal(2).abs()) >= 0) continue;
                    throw new OrderException(OrderException.PREPAID_CANNNOT_GREATER_THAN_PRRECMENT);
                }
            } else {
                while (rs.next() && rs.getBigDecimal(2).compareTo(ZERO) < 0) {
                    if (rs.getBigDecimal(3).compareTo(rs.getBigDecimal(2).abs()) >= 0) continue;
                    throw new OrderException(OrderException.CAN_NOT_RETURN_MORE);
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException("Sql222 execute exception : " + e);
        }
    }

    private boolean getParamValue(IEASBillHeadInfo receivingBillInfo, Context ctx) throws EASBizException, BOSException {
        boolean allowed = false;
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)receivingBillInfo.getObjectValue("company");
        if (companyInfo == null) {
            return allowed;
        }
        ObjectUuidPK pk = new ObjectUuidPK(companyInfo.getId());
        String param = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "AR_PreRecOverOrder");
        if (param != null && param.length() != 0) {
            allowed = Boolean.valueOf(param);
        }
        return allowed;
    }
}

