/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.ArApParamHelper;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.scm.common.app.util.SCMServerUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;

public class PurContractDisposer
implements IPaymentDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        if (action.getDestBill() != null && action.getDestBill() instanceof PaymentBillInfo) {
            PaymentBillInfo paymentBillInfo = (PaymentBillInfo)action.getDestBill();
            boolean isPrePay = paymentBillInfo.getPayBillType().isIsPrePay();
            if (!isPrePay) {
                return;
            }
            if (paymentBillInfo.getId() != null) {
                String paymentBillId = paymentBillInfo.getId().toString();
                String purContractId = null;
                HashSet<String> purContractIdSet = new HashSet<String>();
                PaymentBillEntryCollection paymentEntryNum = paymentBillInfo.getEntries();
                if (paymentEntryNum != null && paymentEntryNum.size() > 0) {
                    for (int i = 0; i < paymentEntryNum.size(); ++i) {
                        if (StringUtils.isEmpty((String)paymentEntryNum.get(i).getSourceBillId())) continue;
                        purContractIdSet.add(paymentEntryNum.get(i).getSourceBillId());
                    }
                }
                if ((purContractId = ArApBillUtil.getSqlIDs(purContractIdSet).trim()) != null && purContractId.trim().length() != 0 && paymentBillId != null && paymentBillId.trim().length() != 0) {
                    SCMServerUtil.addSQLLock((Context)ctx, purContractIdSet);
                    String sp = " \r\n";
                    StringBuffer strSQL = new StringBuffer();
                    if (action.getActionType().getValue() == 7) {
                        this.checkAdvance((IEASBillHeadInfo)paymentBillInfo, ctx, purContractId, paymentBillId);
                        strSQL.append("UPDATE T_SM_PurContractEntry").append(sp);
                        strSQL.append("SET (FPreReceived) =").append(sp);
                        strSQL.append("          (SELECT T_SM_PurContractEntry.FPreReceived + IsNull(rbe.FAmount, 0) ").append(sp);
                        strSQL.append("               AS FPreReceived").append(sp);
                        strSQL.append("         FROM t_cas_PaymentBillEntry rbe").append(sp);
                        strSQL.append("         WHERE rbe.FSourceBillEntryId = T_SM_PurContractEntry.FID AND rbe.FPaymentBillID = '").append(paymentBillId).append("')").append(sp);
                        strSQL.append("WHERE T_SM_PurContractEntry.FID IN").append(sp);
                        strSQL.append("          (SELECT rbe.FSourceBillEntryId ").append(sp);
                        strSQL.append("         FROM t_cas_PaymentBillEntry rbe").append(sp);
                        strSQL.append("         WHERE rbe.FPaymentBillID = '").append(paymentBillId).append("' )").append(sp);
                        DbUtil.execute((Context)ctx, (String)strSQL.toString());
                        strSQL.setLength(0);
                    } else if (action.getActionType().getValue() == 8) {
                        strSQL.append("UPDATE T_SM_PurContractEntry").append(sp);
                        strSQL.append("SET (FPreReceived) =").append(sp);
                        strSQL.append("          (SELECT T_SM_PurContractEntry.FPreReceived - IsNull(rbe.FAmount, 0) ").append(sp);
                        strSQL.append("               AS FPreReceived ").append(sp);
                        strSQL.append("         FROM t_cas_PaymentBillEntry rbe").append(sp);
                        strSQL.append("         WHERE rbe.FSourceBillEntryId = T_SM_PurContractEntry.FID AND rbe.FPaymentBillID = '").append(paymentBillId).append("')").append(sp);
                        strSQL.append("WHERE T_SM_PurContractEntry.FID IN").append(sp);
                        strSQL.append("          (SELECT rbe.FSourceBillEntryId ").append(sp);
                        strSQL.append("         FROM t_cas_PaymentBillEntry rbe").append(sp);
                        strSQL.append("         WHERE rbe.FPaymentBillID = '").append(paymentBillId).append("' )").append(sp);
                        DbUtil.execute((Context)ctx, (String)strSQL.toString());
                        strSQL.setLength(0);
                    }
                    strSQL.append("UPDATE T_SM_PurContractEntry").append(sp);
                    strSQL.append("SET FUnPrereceivedAm = FPrepayment - FPreReceived").append(sp);
                    strSQL.append("WHERE T_SM_PurContractEntry.FID IN").append(sp);
                    strSQL.append("          (SELECT rbe.FSourceBillEntryId ").append(sp);
                    strSQL.append("         FROM t_cas_PaymentBillEntry rbe").append(sp);
                    strSQL.append("         WHERE rbe.FPaymentBillID = '").append(paymentBillId).append("' )").append(sp);
                    DbUtil.execute((Context)ctx, (String)strSQL.toString());
                    strSQL.setLength(0);
                }
            }
        }
    }

    private void checkAdvance(IEASBillHeadInfo billInfo, Context ctx, String orderId, String billId) throws EASBizException, BOSException {
        try {
            CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)billInfo.getObjectValue("company");
            boolean allowed = ArApParamHelper.isPrePayAmtCanOverPurContractAmt(ctx, companyInfo.getId().toString());
            IRowSet rs = null;
            if (!allowed) {
                rs = this.getRowSetBy(ctx, billId, orderId);
                this.isPrepaymentGreaterThanPrepayment(ctx, rs);
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql222 execute exception : " + exc);
        }
    }

    private void isPrepaymentGreaterThanPrepayment(Context ctx, IRowSet rs) throws BOSException, EASBizException {
        BigDecimal beenPaid = null;
        BigDecimal shouldPaid = null;
        try {
            while (rs.next()) {
                beenPaid = rs.getBigDecimal(1);
                shouldPaid = rs.getBigDecimal(2).subtract(rs.getBigDecimal(3));
                if (beenPaid == null || shouldPaid == null || beenPaid.signum() <= 0 || beenPaid.compareTo(shouldPaid) != 1) continue;
                throw new EASBizException(new NumericExceptionSubItem("603", ResourceBase.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"FPreReceivedBiggerPreAmount", (Locale)ctx.getLocale())));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IRowSet getRowSetBy(Context ctx, String billId, String orderId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(b.FAmount) as amount,sum(isnull(a.FPrepayment,0)) as prepaymen,sum(isnull(a.FPreReceived,0)) as preReceived from T_SM_PurContractEntry a ").append(" inner join T_CAS_PaymentBillEntry b on a.fid=b.fsourcebillentryid").append(" inner join T_SM_PurContract c on c.fid=b.fsourcebillid").append(" where b.fpaymentBillID='").append(billId).append("' and c.fid in (").append(orderId).append(")").append(" group by b.fsourcebillid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }
}

