/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutingHelper;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.arap.ARAPScmOrderException;
import com.kingdee.eas.fi.cas.PaymentBillEntryCollection;
import com.kingdee.eas.fi.cas.PaymentBillEntryFactory;
import com.kingdee.eas.fi.cas.PaymentBillEntryInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.PaymentReceivingMatchBusinessProcessorBuilder;
import com.kingdee.eas.scm.framework.log.listener.SCMBizLogAdapter;
import com.kingdee.eas.scm.sm.pur.PaymentMatchCollection;
import com.kingdee.eas.scm.sm.pur.PaymentMatchEntryCollection;
import com.kingdee.eas.scm.sm.pur.PaymentMatchEntryInfo;
import com.kingdee.eas.scm.sm.pur.PaymentMatchFactory;
import com.kingdee.eas.scm.sm.pur.PaymentMatchInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPaymentMatchControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PaymentMatchControllerBean
extends AbstractPaymentMatchControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PaymentMatchControllerBean");
    private static final BigDecimal zero = new BigDecimal("0.00");

    @Override
    protected void _antiAudit(Context ctx, String orderId) throws BOSException, EASBizException {
        PaymentMatchInfo mm = this._getMatchInfo(ctx, orderId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        CoreBillBaseInfo purOrder = (CoreBillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(orderId), (SelectorItemCollection)sic);
        if (mm.getId() != null) {
            if (!mm.isIsAudit()) {
                throw new ARAPScmOrderException(ARAPScmOrderException.ORDER_MATCH_HAS_UNAUDITED, new String[]{purOrder.getNumber()});
            }
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            mm.setAuditor(user);
            mm.setIsAudit(false);
            PaymentMatchFactory.getLocalInstance(ctx).save((CoreBaseInfo)mm);
        }
    }

    @Override
    protected void _antiMatch(Context ctx, String orderId) throws BOSException, EASBizException {
        PaymentMatchInfo paymentMatchInfo = this._getMatchInfo(ctx, orderId);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        CoreBillBaseInfo purOrder = (CoreBillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(orderId), (SelectorItemCollection)sic);
        if (paymentMatchInfo.isIsAudit()) {
            throw new ARAPScmOrderException(ARAPScmOrderException.ORDER_MATCH_HAS_AUDITED_REFUSE_ANTIMATCH);
        }
        Connection con = null;
        Statement statement = null;
        String sp = "\r\n";
        try {
            con = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append(" update T_SM_PurOrderEntry set FPreReceived = isnull(( select isnull(sum(pe.famount),0) ").append(sp);
            sql.append(" from T_CAS_PaymentBillEntry pe left join  T_CAS_PaymentBill p on pe.FPaymentBillID = p.fid ").append(sp);
            sql.append(" left join T_CAS_PaymentBillType pt on pt.FID=p.FPayBillTypeID ");
            sql.append(" left join T_CAS_PaymentBillType pt2 on pt2.FID=pt.FID ");
            sql.append(" where pe.fcorebillid = ? ");
            sql.append(" and (pt.FNumber='").append(202).append("' ");
            sql.append(" or pt2.FNumber='").append(202).append("')");
            sql.append(" and T_SM_PurOrderEntry.fid = pe.fcorebillentryid");
            sql.append(" and p.FbillStatus = 15");
            sql.append(" group by fcorebillentryid  ),0)");
            sql.append(" where FParentID = ? ");
            String orderIDStr = purOrder.getId().toString();
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orderIDStr, orderIDStr});
            sql.setLength(0);
            sql.append(" update T_SM_PurOrderEntry set FUnPrereceivedAm = isnull(FPrepayment,0) - isnull(FPreReceived,0) ");
            sql.append(" where fparentid = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orderIDStr});
            sql.setLength(0);
            sql.append(" update T_SM_PurOrder set FPrepaid = (select isnull(sum(FPreReceived),0) from T_SM_PurOrderEntry ");
            sql.append(" where FParentID=? )");
            sql.append(" where fid = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orderIDStr, orderIDStr});
            sql.setLength(0);
            sql.append(" update T_SM_PurOrder set FUnPrepaidAmount = isnull(FPrepayment,0) - isnull(FPrepaid,0), ");
            sql.append(" FIsMatched=0 ");
            sql.append(" where fid = ? ");
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orderIDStr});
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(statement, (Connection)con);
        }
        CoreBaseCollection cc = new CoreBaseCollection();
        for (int i = 0; i < paymentMatchInfo.getEntries().size(); ++i) {
            PaymentMatchEntryInfo paymentMatchEntryInfo = paymentMatchInfo.getEntries().get(i);
            PaymentBillEntryInfo paymentBillEntryInfo = paymentMatchEntryInfo.getPaymentBillEntry();
            paymentBillEntryInfo.setMatchedAmount(paymentBillEntryInfo.getMatchedAmount().subtract(paymentMatchEntryInfo.getAmount()));
            this.setMatchedAmountLocByRate(paymentBillEntryInfo);
            cc.add((CoreBaseInfo)paymentBillEntryInfo);
        }
        PaymentBillEntryFactory.getLocalInstance((Context)ctx).update(cc);
        this._delete(ctx, (IObjectPK)new ObjectUuidPK(paymentMatchInfo.getId()));
        this.writePaymentMatchBizLog(ctx, paymentMatchInfo, cc, "_antiMatch", "\u53cd\u5339\u914d\u9884\u4ed8\u6b3e");
    }

    private void setMatchedAmountLocByRate(PaymentBillEntryInfo paymentBillEntryInfo) {
        BigDecimal a = paymentBillEntryInfo.getAmount();
        if (a != null && a.doubleValue() > 0.0) {
            int scan = a.scale() + 1;
            if (scan < 3) {
                scan = 3;
            }
            BigDecimal rate = paymentBillEntryInfo.getActualLocAmt().divide(a, scan, 4);
            paymentBillEntryInfo.setMatchedAmountLoc(paymentBillEntryInfo.getMatchedAmount().multiply(rate));
        }
    }

    @Override
    protected void _audit(Context ctx, String orderId) throws BOSException, EASBizException {
        PaymentMatchInfo mm = this._getMatchInfo(ctx, orderId);
        String purOrderId = mm.getPurOrderID();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("id"));
        CoreBillBaseInfo purOrder = (CoreBillBaseInfo)BusinessProcessUtil.getValueByBosType((Context)ctx, (IObjectPK)new ObjectUuidPK(purOrderId), (SelectorItemCollection)sic);
        if (mm.getId() != null) {
            if (mm.isIsAudit()) {
                throw new ARAPScmOrderException(ARAPScmOrderException.ORDER_MATCH_HAS_AUDITED, new String[]{purOrder.getNumber()});
            }
            UserInfo user = new UserInfo();
            user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
            mm.setAuditor(user);
            mm.setIsAudit(true);
            PaymentMatchFactory.getLocalInstance(ctx).save((CoreBaseInfo)mm);
        }
    }

    @Override
    protected void _batchAntiAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            this._antiAudit(ctx, pks[i].toString());
        }
    }

    @Override
    protected void _batchAudit(Context ctx, String[] pks) throws BOSException, EASBizException {
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            this._audit(ctx, pks[i].toString());
        }
    }

    @Override
    protected PaymentMatchInfo _getMatchInfo(Context ctx, String orderId) throws BOSException, EASBizException {
        PaymentMatchInfo paymentMatchInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purOrderID", (Object)orderId));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("entries.*");
        selector.add("entries.paymentBillEntry.*");
        selector.add("entries.paymentBillEntry.paymentBill.*");
        selector.add("entries.paymentBillEntry.paymentBill.number");
        selector.add("entries.paymentBillEntry.paymentBill.payeeName");
        selector.add("entries.paymentBillEntry.paymentBill.payeeType.*");
        view.setSelector(selector);
        PaymentMatchCollection pmc = PaymentMatchFactory.getLocalInstance(ctx).getPaymentMatchCollection(view);
        paymentMatchInfo = pmc.size() > 0 ? pmc.get(0) : new PaymentMatchInfo();
        return paymentMatchInfo;
    }

    @Override
    protected boolean _haveAudited(Context ctx, String orderId) throws BOSException, EASBizException {
        String sql = "select FIsAudit from t_pur_paymentmatch where FPurOrderID=?";
        SqlParams sp = new SqlParams().addString(orderId);
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)sql, (SqlParams)sp, (Context)ctx);
            if (rs.next()) {
                return rs.getInt("FIsAudit") == 1;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return false;
    }

    @Override
    protected boolean _haveMatchRecord(Context ctx, String orderId, String paymentBillId, String paymentBillEntryId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) cc from T_PUR_PAYMENTMATCH A").append(" inner join T_PUR_PAYMENTMATCHENTRY B on B.Fparentid=A.FID").append(" inner join T_CAS_PAYMENTBILLENTRY C on C.Fid=B.PAYMENTBILLENTRYID").append(" where 1=1");
        SqlParams sp = new SqlParams();
        if (orderId != null) {
            sql.append(" and A.FPurOrderId=?");
            sp.addString(orderId);
        }
        if (paymentBillId != null) {
            sql.append(" and C.FPaymentBillId=?");
            sp.addString(paymentBillId);
        }
        if (paymentBillEntryId != null) {
            sql.append(" and C.FID=?");
            sp.addString(paymentBillEntryId);
        }
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)sql.toString(), (SqlParams)sp, (Context)ctx);
            rs.next();
            return rs.getInt("cc") > 0;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected boolean _haveMatchRecords(Context ctx, String[] orderIds, String[] paymentBillIds, String[] paymentBillEntryIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select count(1) cc from T_PUR_PAYMENTMATCH A").append(" inner join T_PUR_PAYMENTMATCHENTRY B on B.Fparentid=A.FID").append(" inner join T_CAS_PAYMENTBILLENTRY C on C.Fid=B.FPAYMENTBILLENTRYID").append(" where 1=1");
        SqlParams sp = new SqlParams();
        this.appendHaveMatchRecordsOrFilter("A.FPurOrderId", orderIds, sql, sp);
        this.appendHaveMatchRecordsOrFilter("C.FPaymentBillId", paymentBillIds, sql, sp);
        this.appendHaveMatchRecordsOrFilter("C.FID", paymentBillEntryIds, sql, sp);
        try {
            RptRowSet rs = DBUtilx.executeQuery((String)sql.toString(), (SqlParams)sp, (Context)ctx);
            rs.next();
            return rs.getInt("cc") > 0;
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    @Override
    protected void _match(Context ctx, String orderId, PaymentMatchInfo mm) throws BOSException, EASBizException {
        mm.setMatchDate(new Date());
        mm.setSourceBillId(mm.getPurOrderID());
        ApplicationContext applicationContext = new ApplicationContext();
        applicationContext.putData("purOrderID", (Object)mm.getPurOrderID());
        applicationContext.putData("matchedAmount", (Object)mm.getAmount());
        BatchActionResults batchResults = BusinessChainExecutingHelper.batchExecute((Context)ctx, (BizController)this, (BOSObjectType)this.getBOSType(), (Object[])new Object[]{mm.getPurOrderID()}, (BatchActionEnum)PaymentReceivingMatchBusinessProcessorBuilder.PAYMENT_MATCH, PaymentReceivingMatchBusinessProcessorBuilder.class, (ApplicationContext)applicationContext);
        HashSet<String> idSet = new HashSet<String>();
        int n = mm.getEntries().size();
        for (int i = 0; i < n; ++i) {
            idSet.add(mm.getEntries().get(i).getPaymentBillEntry().getId().toString());
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo ff = new FilterInfo();
        ev.setFilter(ff);
        ff.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        CoreBaseCollection cc = PaymentBillEntryFactory.getLocalInstance((Context)ctx).getCollection(ev);
        for (int i = 0; i < mm.getEntries().size(); ++i) {
            PaymentMatchEntryInfo e = mm.getEntries().get(i);
            PaymentBillEntryInfo ce = this.getPaymentBillEntryInfo(e.getPaymentBillEntry().getId().toString(), cc);
            ce.setMatchedAmount(ce.getMatchedAmount().add(e.getAmount()));
            this.setMatchedAmountLocByRate(ce);
        }
        PaymentBillEntryFactory.getLocalInstance((Context)ctx).update(cc);
        this.addnew(ctx, mm);
        this.writePaymentMatchBizLog(ctx, mm, cc, "_match", "\u5339\u914d\u9884\u4ed8\u6b3e");
    }

    private PaymentBillEntryInfo getPaymentBillEntryInfo(String id, CoreBaseCollection cc) {
        int n = cc.size();
        for (int i = 0; i < n; ++i) {
            PaymentBillEntryInfo info = (PaymentBillEntryInfo)cc.get(i);
            if (!id.equals(info.getId().toString())) continue;
            return info;
        }
        return null;
    }

    private void appendHaveMatchRecordsOrFilter(String linkField, String[] values, StringBuffer sql, SqlParams sp) {
        int n;
        if (values != null && (n = values.length) > 0) {
            sql.append(" and (");
            for (int i = 0; i < n; ++i) {
                sql.append(linkField).append("=?");
                sp.addString(values[i]);
                if (i == n - 1) continue;
                sql.append(" or ");
            }
            sql.append(")");
        }
    }

    private void writePaymentMatchBizLog(Context ctx, PaymentMatchInfo paymentMatchInfo, CoreBaseCollection cc, String methodName, String methodAlias) throws BOSException {
        if (paymentMatchInfo == null) {
            return;
        }
        String oql = " select number,purchaseOrgUnit.name,purchaseOrgUnit.number where id = '" + paymentMatchInfo.getPurOrderID() + "'";
        PurOrderCollection coll = PurOrderFactory.getLocalInstance((Context)ctx).getPurOrderCollection(oql);
        if (coll.size() > 0) {
            PurOrderInfo purOrderInfo = coll.get(0);
            HashMap idBosTypeMap = new HashMap();
            HashSet<String> idSet = new HashSet<String>();
            HashSet<String> tempSet = new HashSet<String>();
            PaymentMatchEntryCollection entrys = paymentMatchInfo.getEntries();
            int n = entrys.size();
            for (int i = 0; i < n; ++i) {
                tempSet.add(entrys.get(i).getPaymentBillEntry().getId().toString());
            }
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo ff = new FilterInfo();
            ev.setFilter(ff);
            ff.getFilterItems().add(new FilterItemInfo("id", tempSet, CompareType.INCLUDE));
            PaymentBillEntryCollection collection = PaymentBillEntryFactory.getLocalInstance((Context)ctx).getPaymentBillEntryCollection(ev);
            for (int i = 0; i < collection.size(); ++i) {
                PaymentBillEntryInfo ce = collection.get(i);
                if (ce == null || ce.getPaymentBill() == null) continue;
                idSet.add(ce.getPaymentBill().getId().toString());
            }
            BOSObjectType bosType = purOrderInfo.getBOSType();
            idBosTypeMap.put("40284E81", idSet);
            PurchaseOrgUnitInfo companyInfo = purOrderInfo.getPurchaseOrgUnit();
            HashMap<String, HashSet<String>> rootIdMap = new HashMap<String, HashSet<String>>();
            rootIdMap.put(purOrderInfo.getNumber(), idSet);
            EntityObjectInfo entityInfo = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx).getEntity(bosType);
            HashMap<String, String> hashLog = new HashMap<String, String>(10);
            hashLog.put("FEntityID", bosType.toString());
            hashLog.put("FEntityName", entityInfo.getName());
            hashLog.put("FEntityAlias", entityInfo.getAlias());
            hashLog.put("FMethodName", methodName);
            hashLog.put("FMethodAlias", methodAlias);
            hashLog.put("FOperateOrg", companyInfo.getNumber());
            hashLog.put("FOperateOrgName", companyInfo.getName());
            SCMBizLogAdapter.writeBizLog((Context)ctx, hashLog, (IObjectPK)new ObjectUuidPK(companyInfo.getId().toString()), idBosTypeMap, rootIdMap);
        }
    }
}

