/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.framework.cache.config.CacheConfigManager;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.fi.gl.GLException;
import com.kingdee.eas.base.core.fi.gl.GLUtil;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.uiframe.client.MainFrameCallBack;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.client.AccountClientUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AccountBooksException;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.IAcountScheme;
import com.kingdee.eas.fi.books.VoucherTranseException;
import com.kingdee.eas.fi.books.util.BooksRuleInfo;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class BooksUtil {
    private static final Logger logger = Logger.getLogger(BooksUtil.class);
    public static final String RES = "com.kingdee.eas.fi.books.AccountBooksResource";
    public static final String MESSAGERES = "com.kingdee.eas.fi.books.MessageResource";
    public static final String CWGXRESOURCE = "com.kingdee.eas.fi.gl.client.CWGXResource";
    private static String orgName = null;

    public static String getCurrentMasterCompanyID(Context ctx) {
        CompanyOrgUnitInfo currentCompany = null;
        AcountSchemeInfo currentBook = BooksUtil.getCurrentBook(ctx);
        if (ctx == null) {
            if (currentBook == null || currentBook.isIsMaster()) {
                currentCompany = SysContext.getSysContext().getCurrentFIUnit();
            } else {
                currentCompany = SysContext.getSysContext().getCurrentFIUnit().getMainOrg();
                if (currentCompany != null) {
                    try {
                        return currentCompany.getId().toString();
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                }
            }
        } else if (currentBook == null || currentBook.isIsMaster()) {
            currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        } else {
            currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx).getMainOrg();
            if (currentCompany != null) {
                try {
                    return currentCompany.getId().toString();
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        }
        return currentCompany != null ? currentCompany.getId().toString() : null;
    }

    public static CompanyOrgUnitInfo getCurrentMasterCompany(Context ctx) {
        CompanyOrgUnitInfo currentCompany = null;
        AcountSchemeInfo currentBook = BooksUtil.getCurrentBook(ctx);
        if (ctx == null) {
            if (currentBook == null || currentBook.isIsMaster()) {
                currentCompany = SysContext.getSysContext().getCurrentFIUnit();
            } else {
                currentCompany = SysContext.getSysContext().getCurrentFIUnit().getMainOrg();
                if (currentCompany != null) {
                    try {
                        return GLUtil.getCurrentCompany((Context)ctx, (String)currentCompany.getId().toString(), null, (boolean)true);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                } else {
                    currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
                }
            }
        } else if (currentBook == null || currentBook.isIsMaster()) {
            currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        } else {
            currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx).getMainOrg();
            if (currentCompany != null) {
                try {
                    return GLUtil.getCurrentCompany((Context)ctx, (String)currentCompany.getId().toString(), null, (boolean)true);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else {
                currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
        }
        return currentCompany;
    }

    public static CompanyOrgUnitInfo getUnMasterCompany(Context ctx, String bookId) throws BOSException {
        AcountSchemeInfo book = null;
        try {
            book = ctx == null ? (AcountSchemeInfo)AcountSchemeFactory.getRemoteInstance().getValue((IObjectPK)new ObjectUuidPK(bookId)) : (AcountSchemeInfo)AcountSchemeFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bookId));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return BooksUtil.getUnMasterCompany(ctx, book);
    }

    public static CompanyOrgUnitInfo getUnMasterCompany(Context ctx, AcountSchemeInfo book) throws BOSException {
        CompanyOrgUnitInfo masterCompany = BooksUtil.getCurrentMasterCompany(ctx);
        if (masterCompany == null) {
            return null;
        }
        ICompanyOrgUnit comCtrl = null;
        comCtrl = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GLUtil.getCompanySic());
        sic.add(new SelectorItemInfo("simpleName"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("code"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("accountScheme.id", (Object)book.getId().toString()));
        fic.add(new FilterItemInfo("mainOrg.id", (Object)masterCompany.getId().toString()));
        CompanyOrgUnitCollection col = comCtrl.getCompanyOrgUnitCollection(view);
        return col != null && col.size() > 0 ? col.get(0) : null;
    }

    public static boolean canCreateBook(Context ctx) throws BOSException, EASBizException {
        HashMap<String, Object> hmParamIn = new HashMap<String, Object>();
        hmParamIn.put("G012", null);
        IParamControl pc = null;
        pc = ctx != null ? ParamControlFactory.getLocalInstance((Context)ctx) : ParamControlFactory.getRemoteInstance();
        HashMap hmAllParam = pc.getParamHashMap(hmParamIn);
        boolean canCreateBook = false;
        if (hmAllParam.get("G012") != null) {
            canCreateBook = Boolean.valueOf(hmAllParam.get("G012").toString());
        }
        return canCreateBook;
    }

    public static void checkBook(Context ctx) throws EASBizException, BOSException {
        boolean canCreateBook = BooksUtil.canCreateBook(ctx);
        if (!canCreateBook) {
            throw new AccountBooksException(AccountBooksException.NONEBOOKS);
        }
    }

    public static void checkBookRule(Context ctx) throws EASBizException, BOSException {
        String bookId;
        String orgUnitId = BooksUtil.getCurrentMasterCompanyID(ctx);
        boolean hasEnableRule = BooksUtil.hasEnableBooksRule(ctx, orgUnitId, bookId = BooksUtil.getCurrentBook(ctx).getId().toString());
        if (!hasEnableRule) {
            throw new AccountBooksException(AccountBooksException.HASNOTRULEENABLE);
        }
    }

    public static void checkIsNotBook() throws EASBizException, BOSException {
        boolean isIsMaster = BooksUtil.isMasterBook(null);
        if (!isIsMaster) {
            throw new AccountBooksException(AccountBooksException.NOTMASTER);
        }
    }

    public static void switchAccountScheme() throws EASBizException, BOSException {
        AcountSchemeInfo curAccountScheme;
        IAcountScheme getBizInterface = AcountSchemeFactory.getRemoteInstance();
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        if (company != null && company.getAccountScheme() != null && company.getAccountScheme().getId() != null && !(curAccountScheme = (AcountSchemeInfo)getBizInterface.getValue((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentFIUnit().getAccountScheme().getId()))).isIsMaster()) {
            BooksUtil.switchAccountSchemeBySchemeId(curAccountScheme.getId().toString());
            return;
        }
        AcountSchemeInfo value = getBizInterface.switchMasterAccountScheme();
        if (value != null) {
            AcountSchemeInfo scheme = value;
            BooksUtil.setCurrentBook(null, scheme);
            BooksUtil.setOrgName(null);
        }
    }

    public static void switchAccountSchemeBySchemeId(String schemeId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo value = AcountSchemeFactory.getRemoteInstance().switchAccountScheme(schemeId);
        if (value != null) {
            CompanyOrgUnitInfo company = value;
            AcountSchemeInfo scheme = company.getAccountScheme();
            SysContext.getSysContext().setCurrentFIUnit(company);
            SysContext.getSysContext().setProperty((Object)"CurCompanyId", (Object)company.getId().toString());
            BooksUtil.setCurrentBook(null, scheme);
            FullOrgUnitInfo fullOrgUnit = FullOrgUnitFactory.getRemoteInstance().getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId()));
            SysContext.getSysContext().setCurrentOrgUnit((OrgUnitInfo)fullOrgUnit);
            OrgUnitInfo orgUnit = SysContext.getSysContext().getCurrentOrgUnit();
            if (SysContext.getSysContext().getCurrentAdminUnit() != null) {
                SysContext.getSysContext().getCurrentAdminUnit().setName(orgUnit.getName());
            }
            BooksUtil.setOrgName(orgUnit.getName());
            if (scheme.isIsMaster()) {
                orgUnit.setName(BooksUtil.getOrgName());
            } else {
                orgUnit.setName(BooksUtil.getOrgName() + "(" + scheme.getName() + ")");
            }
            MainFrameCallBack.firePropertyChange((String)"HRSwitchOrg", (Object)"old", (Object)company.getName());
            if (CacheConfigManager.getConfig() != null) {
                CacheServiceFactory.getInstance().discardAll();
            }
        }
    }

    public static boolean isSameLocalCurrency(Context ctx, AcountSchemeInfo book) {
        return true;
    }

    public static int getTransferStatus(Context ctx, String bookId) throws EASBizException, BOSException {
        BooksRuleInfo ruleInfo = AccountRuleFactory.getLocalInstance(ctx).getRuleS(bookId);
        if (ruleInfo.getProperties().get("B001") != null) {
            return "1".equals(ruleInfo.getVoucherStatus()) ? 1 : 0;
        }
        return 9999;
    }

    public static int getTransferStatus(Context ctx, String bookId, CompanyOrgUnitInfo masterCompany) throws EASBizException, BOSException {
        BooksRuleInfo ruleInfo = AccountRuleFactory.getLocalInstance(ctx).getRuleS(bookId, masterCompany);
        if (ruleInfo.getProperties().get("B001") != null) {
            return "1".equals(ruleInfo.getVoucherStatus()) ? 1 : 0;
        }
        return 9999;
    }

    public static String isUsedByCompany(Context ctx, String bookid) throws BOSException {
        ICompanyOrgUnit comCtrl = null;
        comCtrl = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.addObjectCollection((IObjectCollection)GLUtil.getCompanySic());
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("accountScheme.id", (Object)bookid));
        CompanyOrgUnitCollection col = comCtrl.getCompanyOrgUnitCollection(view);
        if (col != null && col.size() > 0) {
            return col.get(0).getMainOrg().getNumber() + col.get(0).getMainOrg().getName();
        }
        return null;
    }

    public static boolean isMasterBook(Context ctx) {
        CompanyOrgUnitInfo curCompany = null;
        curCompany = ctx == null ? SysContext.getSysContext().getCurrentFIUnit() : ContextUtil.getCurrentFIUnit((Context)ctx);
        boolean isAllowBoos = true;
        try {
            isAllowBoos = Boolean.valueOf((String)GLUtil.getParamByKey((Context)ctx, null, (String)"G012"));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (!isAllowBoos) {
            return true;
        }
        return BooksUtil.getCurrentBook(ctx).isIsMaster();
    }

    private static CompanyOrgUnitInfo getCurrentCompany(Context ctx, String curCompanyID) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("baseCurrency.id"));
        sic.add(new SelectorItemInfo("baseCurrency.number"));
        sic.add(new SelectorItemInfo("baseCurrency.name"));
        sic.add(new SelectorItemInfo("baseCurrency.precision"));
        sic.add(new SelectorItemInfo("baseCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("reportCurrency.id"));
        sic.add(new SelectorItemInfo("reportCurrency.number"));
        sic.add(new SelectorItemInfo("reportCurrency.name"));
        sic.add(new SelectorItemInfo("reportCurrency.precision"));
        sic.add(new SelectorItemInfo("reportCurrency.deletedStatus"));
        sic.add(new SelectorItemInfo("accountPeriodType.id"));
        sic.add(new SelectorItemInfo("accountPeriodType.number"));
        sic.add(new SelectorItemInfo("accountPeriodType.name"));
        sic.add(new SelectorItemInfo("isGrouping"));
        sic.add(new SelectorItemInfo("isGroup"));
        sic.add(new SelectorItemInfo("level"));
        sic.add(new SelectorItemInfo("isOnlyUnion"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        sic.add(new SelectorItemInfo("isCompanyOrgUnit"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("reportConvertMode"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("accountTable.id"));
        sic.add(new SelectorItemInfo("accountTable.name"));
        sic.add(new SelectorItemInfo("accountTable.number"));
        sic.add(new SelectorItemInfo("baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
        sic.add(new SelectorItemInfo("reportExchangeTable.id"));
        sic.add(new SelectorItemInfo("isAssistantOrg"));
        sic.add(new SelectorItemInfo("mainOrg.id"));
        sic.add(new SelectorItemInfo("mainOrg.name"));
        sic.add(new SelectorItemInfo("mainOrg.number"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.id"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.name"));
        sic.add(new SelectorItemInfo("mainOrg.accountTable.number"));
        sic.add(new SelectorItemInfo("accountScheme.id"));
        sic.add(new SelectorItemInfo("accountScheme.name"));
        sic.add(new SelectorItemInfo("accountScheme.number"));
        sic.add(new SelectorItemInfo("orgTypeStr"));
        ICompanyOrgUnit comCtrl = null;
        comCtrl = ctx != null ? CompanyOrgUnitFactory.getLocalInstance((Context)ctx) : CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo com = null;
        ObjectUuidPK comPK = null;
        try {
            comPK = new ObjectUuidPK(BOSUuid.read((String)curCompanyID));
            com = (CompanyOrgUnitInfo)comCtrl.getValue((IObjectPK)comPK, sic);
        }
        catch (Exception ex) {
            throw new GLException(GLException.NOCOMPANY, (Throwable)ex);
        }
        if (!com.isIsBizUnit()) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        return com;
    }

    public static boolean isMasterBook(Context ctx, String companyId) {
        boolean isAllowBoos = true;
        try {
            isAllowBoos = Boolean.valueOf((String)GLUtil.getParamByKey((Context)ctx, null, (String)"G012"));
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (!isAllowBoos) {
            return true;
        }
        return BooksUtil.getCurrentBook(ctx, companyId).isIsMaster();
    }

    private static void checkMasterBook(Context ctx, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (BooksUtil.isMasterBook(ctx, company.getId().toString())) {
            throw new AccountBooksException(AccountBooksException.BIZNOTMASTER);
        }
    }

    public static void checkBiz() throws Exception {
        BooksUtil.checkBiz(SysContext.getSysContext().getCurrentFIUnit());
    }

    public static void checkBiz(CompanyOrgUnitInfo company) throws Exception {
        BooksUtil.checkFIUnit(company, false);
        BooksUtil.checkBook(null);
        BooksUtil.checkMasterBook(null, company);
    }

    public static void checkFIUnit(boolean isSupportVirtual) throws Exception {
        BooksUtil.checkFIUnit(SysContext.getSysContext().getCurrentFIUnit(), isSupportVirtual);
    }

    public static void checkFIUnit(CompanyOrgUnitInfo company, boolean isSupportVirtual) throws Exception {
        if (company == null) {
            throw new GLException(GLException.NOCOMPANY);
        }
        if (!SysContext.getSysContext().getCurrentOrgUnit().isIsCompanyOrgUnit()) {
            throw new GLException(GLException.NOT_A_BIZUNIT);
        }
        if (!company.isIsBizUnit() && !isSupportVirtual) {
            throw new GLException(GLException.COMMUSTBEENTITY);
        }
        AccountClientUtils.checkCompanyAccountTable(null, (CompanyOrgUnitInfo)company);
    }

    public static void _checkPeriodValid(Context ctx, String bookid) throws EASBizException, BOSException {
        String sql = "select s.fnumber from t_bd_systemstatus a \t\t\tinner join t_bd_systemstatusctrol b on a.fid=b.fsystemstatusid\t\t\t\t\tinner join t_bd_period  s on s.fid=b.fstartperiodid\t\t\t\t\tinner join t_org_company c on c.fid=b.fcompanyid where c.faccountschemeid=?\t";
        IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bookid});
        try {
            if (set == null || !set.next()) {
                throw new AccountBooksException(AccountBooksException.STARTPERIOD);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static String getOrgName() {
        return orgName;
    }

    public static void setOrgName(String orgName) {
        BooksUtil.orgName = orgName;
    }

    public static String _getTranseAccount(Context ctx, String accountId) throws EASBizException, BOSException {
        IRowSet set = null;
        String srcTable = BooksUtil.getCurrentMasterCompany(ctx).getAccountTable().getId().toString();
        String objTable = ContextUtil.getCurrentFIUnit((Context)ctx).getAccountTable().getId().toString();
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String accountRef = null;
        try {
            if (srcTable.endsWith(objTable)) {
                return accountId;
            }
            String sql = " select fid from t_bd_acctrefcontrast where FEnabledAcctTableID=? and FDisabledAcctTableID=? and FIsEnabled=1 and FRefType=2 and Fcompanyid=? ";
            set = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{objTable, srcTable, companyId});
            if (set == null || !set.next()) {
                throw new VoucherTranseException(VoucherTranseException.CREATEREFCONTRAST);
            }
            accountRef = set.getString(1);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        String accountSql = " select fnewacctid from t_bd_acctrefcontrastentry where foldacctid=? and  FacctrefcontrastId = ? ";
        set = DbUtil.executeQuery((Context)ctx, (String)accountSql, (Object[])new Object[]{accountId, accountRef});
        try {
            if (set != null && set.next()) {
                return set.getString(1);
            }
            throw new VoucherTranseException(VoucherTranseException.ACCOUNTNOREFCONTRAST);
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isSameAccountTable(Context ctx) {
        CompanyOrgUnitInfo currentCompany = null;
        currentCompany = ctx != null ? ContextUtil.getCurrentFIUnit((Context)ctx).getMainOrg() : SysContext.getSysContext().getCurrentFIUnit();
        String srcTable = null;
        if (currentCompany.getMainOrg().getAccountTable() != null) {
            srcTable = currentCompany.getMainOrg().getAccountTable().getId().toString();
        } else {
            CompanyOrgUnitInfo masterCompany = null;
            try {
                masterCompany = GLUtil.getCurrentCompany((Context)ctx, (String)currentCompany.getMainOrg().getId().toString(), null, (boolean)true);
                srcTable = masterCompany.getId().toString();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        String objTable = currentCompany.getAccountTable().getId().toString();
        return objTable.equals(srcTable);
    }

    public static boolean hasEnableBooksRule(Context ctx, String orgUnitId, String bookid) throws BOSException, EASBizException {
        try {
            Object[] objectArray;
            IRowSet rs = null;
            if (bookid != null) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = orgUnitId;
                objectArray = objectArray2;
                objectArray2[1] = bookid;
            } else {
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                objectArray3[0] = orgUnitId;
            }
            Object[] param = objectArray;
            String sql = "select top 1 fid from t_bks_accountrule where fcompanyid=? and fisenable=1 " + (bookid != null ? " and faccountschemeid=? " : "");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])param);
            if (rs != null && rs.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new SQLAccessException(e);
        }
        return false;
    }

    public static Object getProperty(Object key) {
        return SysContext.getSysContext().getProperty(key);
    }

    private static void setProperty(Object key, Object value) {
        SysContext.getSysContext().setProperty(key, value);
    }

    private static AcountSchemeInfo getCurrentBook() {
        if (BooksUtil.getProperty("AccountScheme") == null) {
            BooksUtil.initCurrecntBook(null);
        }
        return (AcountSchemeInfo)BooksUtil.getProperty("AccountScheme");
    }

    private static void setCurrentBook(AcountSchemeInfo currenctBook) {
        BooksUtil.setProperty("AccountScheme", currenctBook);
    }

    private static void initCurrecntBook(Context ctx) {
        AcountSchemeInfo book = null;
        try {
            if (ctx == null) {
                IAcountScheme getBizInterface = AcountSchemeFactory.getRemoteInstance();
                CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                book = company != null && company.getAccountScheme() != null && company.getAccountScheme().getId() != null ? (AcountSchemeInfo)getBizInterface.getValue((IObjectPK)new ObjectUuidPK(company.getAccountScheme().getId())) : AcountSchemeFactory.getRemoteInstance().getMasterScheme();
                BooksUtil.setProperty("AccountScheme", book);
            } else {
                IAcountScheme getBizInterface = AcountSchemeFactory.getLocalInstance(ctx);
                CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
                book = company != null && company.getAccountScheme() != null && company.getAccountScheme().getId() != null ? (AcountSchemeInfo)getBizInterface.getValue((IObjectPK)new ObjectUuidPK(company.getAccountScheme().getId())) : AcountSchemeFactory.getLocalInstance(ctx).getMasterScheme();
                ctx.put((Object)"AccountScheme", (Object)book);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static AcountSchemeInfo getCurrentBook(Context ctx) {
        AcountSchemeInfo accountScheme = null;
        if (ctx == null) {
            if (BooksUtil.getProperty("AccountScheme") == null) {
                BooksUtil.initCurrecntBook(null);
            }
            accountScheme = (AcountSchemeInfo)BooksUtil.getProperty("AccountScheme");
        } else {
            if (ctx.get((Object)"AccountScheme") == null) {
                BooksUtil.initCurrecntBook(ctx);
            }
            accountScheme = (AcountSchemeInfo)ctx.get((Object)"AccountScheme");
        }
        return accountScheme;
    }

    public static AcountSchemeInfo getCurrentBook(Context ctx, String companyId) {
        AcountSchemeInfo book = null;
        try {
            CompanyOrgUnitInfo company = BooksUtil.getCurrentCompany(ctx, companyId);
            if (ctx == null) {
                IAcountScheme getBizInterface = AcountSchemeFactory.getRemoteInstance();
                book = company != null && company.getAccountScheme() != null && company.getAccountScheme().getId() != null ? (AcountSchemeInfo)getBizInterface.getValue((IObjectPK)new ObjectUuidPK(company.getAccountScheme().getId())) : AcountSchemeFactory.getRemoteInstance().getMasterScheme();
            } else {
                IAcountScheme getBizInterface = AcountSchemeFactory.getLocalInstance(ctx);
                book = company != null && company.getAccountScheme() != null && company.getAccountScheme().getId() != null ? (AcountSchemeInfo)getBizInterface.getValue((IObjectPK)new ObjectUuidPK(company.getAccountScheme().getId())) : AcountSchemeFactory.getLocalInstance(ctx).getMasterScheme();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return book;
    }

    public static void setCurrentBook(Context ctx, AcountSchemeInfo book) {
        try {
            if (ctx == null) {
                BooksUtil.setCurrentBook(book);
            } else {
                ctx.put((Object)"AccountScheme", (Object)book);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static CompanyOrgUnitInfo getCurrentMasterCompany(Context ctx, CompanyOrgUnitInfo company) {
        CompanyOrgUnitInfo currentCompany = null;
        AcountSchemeInfo currentBook = BooksUtil.getCurrentBook(ctx, company.getId().toString());
        if (ctx == null) {
            if (currentBook == null || currentBook.isIsMaster()) {
                currentCompany = company;
            } else {
                currentCompany = company.getMainOrg();
                if (currentCompany != null) {
                    try {
                        return GLUtil.getCurrentCompany((Context)ctx, (String)currentCompany.getId().toString(), null, (boolean)true);
                    }
                    catch (Exception e) {
                        logger.error((Object)"", (Throwable)e);
                    }
                } else {
                    currentCompany = SysContext.getSysContext().getCurrentFIUnit();
                }
            }
        } else if (currentBook == null || currentBook.isIsMaster()) {
            currentCompany = company;
        } else {
            currentCompany = company.getMainOrg();
            if (currentCompany != null) {
                try {
                    return GLUtil.getCurrentCompany((Context)ctx, (String)currentCompany.getId().toString(), null, (boolean)true);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                }
            } else {
                currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
            }
        }
        return currentCompany;
    }

    public static boolean checkSelectedCompany(Component component, CompanyOrgUnitInfo newOrg) {
        if (newOrg == null) {
            MsgBox.showWarning((Component)component, (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyIsNull"));
            return false;
        }
        try {
            CompanyOrgUnitInfo com = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(newOrg.getId().toString()), GlUtils.getCompanySic());
            if (com.getMainOrg() == null) {
                MsgBox.showWarning((Component)component, (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyMustTransferOrg"));
                return false;
            }
            if (!com.isIsBizUnit()) {
                MsgBox.showWarning((Component)component, (String)EASResource.getString((String)CWGXRESOURCE, (String)"mustSelectCompany"));
                return false;
            }
            if (com.isIsOUSealUp()) {
                MsgBox.showWarning((Component)component, (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyIsSealUp"));
                return false;
            }
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)com);
            if (startPeriod == null) {
                MsgBox.showWarning((Component)component, (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyHasNotStartPeriod"));
                return false;
            }
            if (com.getAccountTable() == null) {
                MsgBox.showWarning((Component)component, (String)EASResource.getString((String)CWGXRESOURCE, (String)"companyAccounttableIsNull"));
                return false;
            }
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"", (Throwable)e);
        }
        return true;
    }

    public static String getDecimalFormat(int scale) {
        StringBuffer sb = new StringBuffer("");
        StringBuffer fsb = new StringBuffer("-");
        sb.append("#,##");
        fsb.append("#,##");
        sb.append("0");
        fsb.append("0");
        if (scale > 0) {
            sb.append(".");
            fsb.append(".");
            for (int i = 0; i < scale; ++i) {
                sb.append("0");
                fsb.append("0");
            }
        }
        sb.append(";");
        sb.append(fsb);
        sb.append(";");
        return sb.toString();
    }
}

