/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.kscript.KScriptException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.formula.api.IFormulaFunctions;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.botp.util.BOTObjectCache;
import com.kingdee.eas.base.dap.DAPAssistant;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.fa.manage.FaLeaseDepCostSharingFactory;
import com.kingdee.eas.fi.fa.manage.FaLeaseNewDepCostSharingEntryFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FaNLMFormulaFunctions
implements IFormulaFunctions {
    private final Vector funcInfos = new Vector();
    private static final Logger logger = CoreUIObject.getLogger(FaNLMFormulaFunctions.class);
    private final Map cache = new HashMap();

    public FaNLMFormulaFunctions() {
        this.funcInfos.add(new FuncInfo("__BOTgetCurrExchangeRate", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"getCurrExchangeRate")));
        this.funcInfos.add(new FuncInfo("__BOTgetHGActItemForFl", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"75_FaNLMFormulaFunctions")));
        this.funcInfos.add(new FuncInfo("__BOTgetHGActItemForLeaseBill", FuncInfo.CATEGORY_OTHER, EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"76_FaNLMFormulaFunctions")));
    }

    public Object evalFunction(String func, List paramList) throws KScriptException {
        if ("__BOTgetCurrExchangeRate".equalsIgnoreCase(func)) {
            return this.getCurrExchangeRate(paramList);
        }
        if ("__BOTgetHGActItemForFl".equalsIgnoreCase(func)) {
            return this.getHGActItemForFl(paramList);
        }
        if ("__BOTgetHGActItemForLeaseBill".equalsIgnoreCase(func)) {
            return this.getHGActItemForLeaseBill(paramList);
        }
        if ("...".equalsIgnoreCase(func)) {
            // empty if block
        }
        return null;
    }

    public String[] getAllFuncNames() {
        String[] as = new String[this.funcInfos.size()];
        for (int i = 0; i < this.funcInfos.size(); ++i) {
            as[i] = ((FuncInfo)this.funcInfos.get((int)i)).funcName;
        }
        return as;
    }

    public String getFuncCategory(String s) {
        if (s == null) {
            return null;
        }
        for (Object funcInfo : this.funcInfos) {
            if (!s.equals(((FuncInfo)funcInfo).funcName)) continue;
            return ((FuncInfo)funcInfo).funcCategory;
        }
        return null;
    }

    public String getFuncDesc(String s) {
        if (s == null) {
            return null;
        }
        for (Object funcInfo : this.funcInfos) {
            if (!s.equals(((FuncInfo)funcInfo).funcName)) continue;
            return ((FuncInfo)funcInfo).funcDesc;
        }
        return null;
    }

    public boolean existFunction(String s) {
        if (s == null) {
            return false;
        }
        for (Object funcInfo : this.funcInfos) {
            if (!s.equals(((FuncInfo)funcInfo).funcName)) continue;
            return true;
        }
        return false;
    }

    private BigDecimal getCurrExchangeRate(List paramList) throws KScriptException {
        Context ctx = (Context)paramList.get(0);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        Object firstParam = paramList.get(1);
        if (firstParam instanceof CurrencyInfo) {
            CurrencyInfo currencyInfo = (CurrencyInfo)firstParam;
            if (EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.BASEDATAAutoGenerateResource", (String)"77_FaNLMFormulaFunctions").equals(currencyInfo.toString())) {
                return new BigDecimal("1");
            }
            try {
                IExchangeRate iExchangeRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("convertRate");
                selector.add("availTime");
                Date currentDate = new Date();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("exChangeAux.sourceCurrency.id", (Object)currencyInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("exChangeAux.targetCurrency.id", (Object)company.getBaseCurrency().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("availTime", (Object)currentDate, CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("invalidTime", (Object)currentDate, CompareType.GREATER));
                SorterItemCollection sorter = new SorterItemCollection();
                sorter.add(new SorterItemInfo("availTime"));
                EntityViewInfo view = new EntityViewInfo();
                view.setSelector(selector);
                view.setFilter(filter);
                view.setSorter(sorter);
                view.setTopCount(1);
                ExchangeRateCollection rateCol = iExchangeRate.getExchangeRateCollection(view);
                if (rateCol != null && rateCol.size() > 0) {
                    return rateCol.get(0).getConvertRate();
                }
            }
            catch (BOSException e) {
                throw new KScriptException(e.getMessage());
            }
        }
        return null;
    }

    private Object getHGActItemForFl(List paramList) throws KScriptException {
        if (paramList.size() != 3) {
            return null;
        }
        Context ctx = (Context)paramList.get(0);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        Object entryID = paramList.get(1);
        Object accountViewID = paramList.get(2);
        try {
            String asstitem = FaLeaseNewDepCostSharingEntryFactory.getLocalInstance((Context)ctx).getFaLeaseNewDepCostSharingEntryInfo((IObjectPK)new ObjectUuidPK(entryID.toString())).getFaLeaseAsstActComposit();
            if (asstitem != null && asstitem.length() > 0 && accountViewID != null) {
                String[] asstitemComp;
                AsstActTypeInfo acttypeInfo = null;
                IObjectValue asstActInfo = null;
                HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
                IAsstActType type = AsstActTypeFactory.getLocalInstance((Context)ctx);
                for (String actComposite : asstitemComp = asstitem.split("@")) {
                    String[] asstitemComp2;
                    if (actComposite == null || actComposite.length() <= 0 || (asstitemComp2 = actComposite.split("#")).length != 3) continue;
                    acttypeInfo = (AsstActTypeInfo)type.getValue("where id= '" + asstitemComp2[1] + "'");
                    asstActInfo = BOTObjectCache.getInstance((Context)ctx).get(asstitemComp2[2]);
                    map.put(acttypeInfo.getAsstHGAttribute(), asstActInfo);
                }
                return DAPAssistant.getAssistantHG2((Context)ctx, (String)accountViewID.toString(), map);
            }
            return null;
        }
        catch (Exception e) {
            throw new KScriptException(e.getMessage());
        }
    }

    private Object getHGActItemForLeaseBill(List paramList) throws KScriptException {
        if (paramList.size() != 3) {
            return null;
        }
        Context ctx = (Context)paramList.get(0);
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        Object entryID = paramList.get(1);
        Object accountViewID = paramList.get(2);
        try {
            String asstitem = FaLeaseDepCostSharingFactory.getLocalInstance((Context)ctx).getFaLeaseDepCostSharingInfo((IObjectPK)new ObjectUuidPK(entryID.toString())).getFaLeaseAsstActComposit();
            if (asstitem != null && asstitem.length() > 0 && accountViewID != null) {
                String[] asstitemComp;
                AsstActTypeInfo acttypeInfo = null;
                IObjectValue asstActInfo = null;
                HashMap<String, IObjectValue> map = new HashMap<String, IObjectValue>();
                IAsstActType type = AsstActTypeFactory.getLocalInstance((Context)ctx);
                for (String actComposite : asstitemComp = asstitem.split("@")) {
                    String[] asstitemComp2;
                    if (actComposite == null || actComposite.length() <= 0 || (asstitemComp2 = actComposite.split("#")).length != 3) continue;
                    acttypeInfo = (AsstActTypeInfo)type.getValue("where id= '" + asstitemComp2[1] + "'");
                    asstActInfo = BOTObjectCache.getInstance((Context)ctx).get(asstitemComp2[2]);
                    map.put(acttypeInfo.getAsstHGAttribute(), asstActInfo);
                }
                return DAPAssistant.getAssistantHG2((Context)ctx, (String)accountViewID.toString(), map);
            }
            return null;
        }
        catch (Exception e) {
            throw new KScriptException(e.getMessage());
        }
    }

    static class FuncInfo {
        public static final String CATEGORY_OTHER = EASResource.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"NLMPeriodCntFunction");
        String funcName;
        String funcCategory;
        String funcDesc;

        public FuncInfo(String name, String category, String desc) {
            this.funcName = name;
            this.funcCategory = category;
            this.funcDesc = desc;
        }

        public FuncInfo() {
        }

        public void setFuncName(String name) {
            this.funcName = name;
        }

        public void setFuncDesc(String desc) {
            this.funcDesc = desc;
        }

        public void setFuncCatetory(String category) {
            this.funcCategory = category;
        }
    }
}

