/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.BizBalanceException;
import com.kingdee.eas.common.BizCheckResult;
import com.kingdee.eas.common.BizHasDealException;
import com.kingdee.eas.common.BizReferenceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.app.IBizHasDeal;
import com.kingdee.eas.common.app.IBizReference;
import com.kingdee.eas.fi.fa.basedata.FaBasicException;
import com.kingdee.eas.fi.fa.manage.FaContrastCaclFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaDepCalFacadeFactory;
import com.kingdee.eas.fi.fa.manage.FaDepreciationFactory;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.fi.fa.manage.IFaDepCalFacade;
import com.kingdee.eas.fi.fa.manage.IFaDepreciation;
import com.kingdee.eas.fi.fa.manage.app.FaPeriodCloseFacadeControllerBean;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;

public class FaAccountSwap
implements IBizReference,
IBizHasDeal {
    private String[] bizTables = new String[]{"T_FA_FaCurCard", "T_FA_FaChangeBill", "T_FA_ClearBill", "T_FA_FaCombinBill", "T_FA_FaDecValue", "T_FA_FaDispatchBill", "T_FA_FaEvaluateBill", "T_FA_FaSplitBill", "T_FA_StocktakingTaskBill", "T_FA_FaDepreciation", "T_FA_FaLeaseBill", "T_FA_FaLeaseInBill"};
    private String[] unAuditResources = new String[]{"unAuditNewCard", "unAuditChange", "unAuditClean", "unAuditCombin", "unAuditDecValue", "unAuditDispatch", "unAuditEvalute", "unAuditSplit", "unAuditStockTask", "unAuditDepr", "unAudtiLeaseOut", "unAuditLeaseIn"};
    private String[] notVouchedResources = new String[]{"notVouchedNewCard", "notVouchedChange", "notVouchedClean", "notVouchedCombin", "notVouchedDecValue", "notVouchedDispatch", "notVouchedEvalute", "notVouchedSplit", "notVouchedStock", "notVouchedDepr", "notVouchedLeaseOut", "notVouchedLeaseIn"};

    public BizCheckResult checkReferenced(Context ctx, BOSUuid id) throws BizReferenceException {
        try {
            this.checkIsAdjustPeriod(ctx);
            this.bizVerify(ctx, id);
        }
        catch (EASBizException ex) {
            throw new BizReferenceException(new NumericExceptionSubItem(ex.getCode(), ex.getMessage()), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new BizReferenceException(BizBalanceException.SQL_ERR, (Throwable)ex);
        }
        return new BizCheckResult(false);
    }

    private void checkIsAdjustPeriod(Context ctx) throws BOSException, SQLException, BizReferenceException {
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        String fName = "FName_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct company.FID AS COMPANYID ,company.fnumber as number, company.").append(fName).append(" as name");
        sql.append(" FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(14);
        sql.append(" and company.fisonlyunion = 0 and period.fisadjustperiod = 0");
        sql.append(" and company.fid = '").append(currCompany.getId().toString()).append("'");
        sql.append(" and ssc.fisstart = 1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String strCompany = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"strCompany", (Locale)ctx.getOriginLocale());
        StringBuffer strCompanys = new StringBuffer();
        while (rowSet.next()) {
            strCompanys.append("\u3001");
            strCompanys.append(rowSet.getString("name"));
        }
        if (strCompanys.length() > 0) {
            FaBasicException e = new FaBasicException(FaBasicException.NOT_IS_ADJUST_PERIOD, new Object[]{strCompany + strCompanys.substring(1)});
            throw new BizReferenceException(new NumericExceptionSubItem(e.getCode(), e.getMessage()), (Throwable)((Object)e));
        }
    }

    private void bizVerify(Context ctx, BOSUuid id) throws EASBizException, BOSException {
        for (int i = 0; i < this.bizTables.length; ++i) {
            this.checkFaAuditBiz(ctx, this.bizTables[i], this.unAuditResources[i]);
        }
        if (this.isEnable(ctx, id)) {
            PeriodInfo currPeriod = this.getCurrPeriod(ctx);
            CompanyOrgUnitInfo[] companys = this.getCompanys(ctx);
            if (companys == null) {
                return;
            }
            for (int i = 0; i < companys.length; ++i) {
                String strCompany = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"strCompany", (Locale)ctx.getOriginLocale());
                StringBuffer strCompanys = new StringBuffer();
                strCompanys.append(companys[i].getName());
                HashMap hmPara = this.gethmParam(ctx, companys[i].getId().toString());
                String checkGL = (String)hmPara.get("FA_004");
                boolean isCheckGL = false;
                if (checkGL != null && checkGL.trim().length() > 0) {
                    isCheckGL = Boolean.valueOf(checkGL.trim());
                }
                if (isCheckGL) {
                    for (int j = 0; j < this.bizTables.length; ++j) {
                        if (!this.existNotVouchered(ctx, companys[i].getId().toString(), this.bizTables[j])) continue;
                        strCompanys.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", this.notVouchedResources[j]));
                        throw new EASBizException(new NumericExceptionSubItem("1", strCompany + strCompanys));
                    }
                    String checkDep = (String)hmPara.get("FA_005");
                    if (checkDep != null && checkDep.trim().length() > 0) {
                        boolean isCheckDep = Boolean.valueOf(checkDep.trim());
                        if (isCheckDep && this.isExitNoCal(ctx, companys[i], currPeriod)) {
                            strCompanys.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_NoDep"));
                            throw new EASBizException(new NumericExceptionSubItem("1", strCompany + strCompanys));
                        }
                        if (this.isNeedRedoDep(ctx, companys[i].getId().toString())) {
                            strCompanys.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", "needRedoDep"));
                            throw new EASBizException(new NumericExceptionSubItem("1", strCompany + strCompanys));
                        }
                    }
                }
                if (!isCheckGL) continue;
                boolean isRelAccount = SystemStatusCtrolUtils.isRelAccount((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companys[i]);
                boolean checkResult = FaContrastCaclFactory.getLocalInstance((Context)ctx).isAcctEquals(companys[i].getId().toString(), null);
                if (checkResult || !isRelAccount) continue;
                strCompanys.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.manage.FaPeriodClose", "forward_CheckGL"));
                throw new EASBizException(new NumericExceptionSubItem("1", strCompany + strCompanys));
            }
        }
    }

    private CompanyOrgUnitInfo[] getCompanys(Context ctx) throws BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String fName = "FName_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct company.fid as companyid,company.fnumber as fnumber, company.").append(fName).append(" as fname");
        sql.append(" from T_ORG_Company company");
        sql.append(" inner join T_BD_SystemStatusCtrol ssc on company.fid = ssc.fcompanyid");
        sql.append(" inner join T_BD_SystemStatus ss on ss.FID = ssc.FSystemStatusID");
        sql.append(" where ss.FName = ").append(14);
        sql.append(" and ssc.fisstart = 1 and company.fisonlyunion = 0");
        sql.append(" and company.fid ='").append(companyId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        ArrayList<CompanyOrgUnitInfo> companyList = new ArrayList<CompanyOrgUnitInfo>();
        try {
            while (rowSet.next()) {
                String id = rowSet.getString("companyid");
                String name = rowSet.getString("fname");
                String number = rowSet.getString("fnumber");
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)id));
                company.setName(name);
                company.setNumber(number);
                companyList.add(company);
            }
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        if (companyList.size() > 0) {
            CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companyList.size()];
            companyList.toArray(companys);
            return companys;
        }
        return null;
    }

    private void checkFaAuditBiz(Context ctx, String tableName, String resource) throws BOSException, EASBizException {
        StringBuffer strCompanys;
        String strCompany;
        CompanyOrgUnitInfo company = ContextUtil.getCurrentFIUnit((Context)ctx);
        String fName = "FName_" + ctx.getLocale().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct company.FID AS COMPANYID ,company.fnumber as fnumber, company.").append(fName).append(" as fname");
        sql.append(" FROM ").append(tableName).append(" as bill");
        sql.append(" INNER JOIN T_ORG_Company company ON bill.FCompanyID = company.FID");
        sql.append(" WHERE bill.fcheckedstatus = ").append(1);
        sql.append(" and bill.fcompanyid = '").append(company.getId().toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            strCompany = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"strCompany", (Locale)ctx.getOriginLocale());
            strCompanys = new StringBuffer();
            while (rowSet.next()) {
                strCompanys.append("\u3001");
                strCompanys.append(rowSet.getString("fname"));
            }
            if (strCompanys.length() > 0) {
                strCompanys.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", resource));
                throw new EASBizException(new NumericExceptionSubItem("1", strCompany + strCompanys.substring(1)));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if ("T_FA_StocktakingTaskBill".equalsIgnoreCase(tableName)) {
            sql = new StringBuffer();
            sql.append("SELECT distinct company.FID AS COMPANYID ,company.fnumber as fnumber, company.").append(fName).append(" as fname");
            sql.append(" FROM ").append(tableName).append(" as bill");
            sql.append(" INNER JOIN T_ORG_Company company ON bill.FCompanyID = company.FID");
            sql.append(" WHERE bill.fstocktakingStatus < ").append(4);
            sql.append(" and bill.fcompanyid = '").append(company.getId().toString()).append("'");
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            try {
                strCompany = ResourceBase.getString((String)"com.kingdee.eas.fi.fa.basedata.FaResource", (String)"strCompany", (Locale)ctx.getOriginLocale());
                strCompanys = new StringBuffer();
                while (rowSet.next()) {
                    strCompanys.append("\u3001");
                    strCompanys.append(rowSet.getString("fname"));
                }
                if (strCompanys.length() > 0) {
                    strCompanys.append(this.getResource(ctx, "com.kingdee.eas.fi.fa.basedata.FaBaseDataCommonResource", "unFinishStock"));
                    throw new EASBizException(new NumericExceptionSubItem("1", strCompany + strCompanys.substring(1)));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private boolean existNotVouchered(Context ctx, String companyId, String tableName) throws BOSException, EASBizException {
        if ("T_FA_FaCombinBill".equalsIgnoreCase(tableName) || "T_FA_FaSplitBill".equalsIgnoreCase(tableName) || "T_FA_FaDispatchBill".equalsIgnoreCase(tableName) || "T_FA_StocktakingBill".equalsIgnoreCase(tableName) || "T_FA_StocktakingTaskBill".equalsIgnoreCase(tableName)) {
            return false;
        }
        CompanyOrgUnitInfo currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT bill.fid as fid");
        sql.append(" FROM ").append(tableName).append(" as bill");
        if ("T_FA_FaChangeBill".equals(tableName)) {
            sql.append(" INNER JOIN t_fa_fachangebillentry entry ON bill.fid = entry.fchangebillid and bill.FBillType is null ");
        } else if ("T_FA_ClearBill".equals(tableName)) {
            sql.append(" INNER JOIN t_fa_clearbillentry entry ON bill.fid = entry.fentryid");
            sql.append(" INNER JOIN t_fa_facurcard card ON card.fid = entry.fcurcardid");
        }
        if ("T_FA_FaDepreciation".equals(tableName)) {
            sql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.fcompanyid = bill.fcompanyid and ssc.FCurrentPeriodID = bill.FPeriod ");
        } else {
            sql.append(" INNER JOIN T_BD_SystemStatusCtrol ssc on ssc.fcompanyid = bill.fcompanyid and ssc.FCurrentPeriodID = bill.FPeriodID ");
        }
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE bill.ffivouchered = 0 and ssc.fisrelaccount = 1");
        if ("T_FA_FaCurCard".equalsIgnoreCase(tableName)) {
            sql.append(" and bill.fassetValue != 0");
            sql.append(" and bill.foriginFlag != 0");
            sql.append(" and bill.foriginFlag != 6");
        } else if ("T_FA_ClearBill".equalsIgnoreCase(tableName)) {
            sql.append(" and card.fassetValue != 0");
        } else if ("T_FA_FaChangeBill".equals(tableName)) {
            sql.append(" and (entry.toriginChg != 0 or entry.taccuDeprChg != 0 or entry.tdecValueChg != 0)");
        }
        sql.append(" and ss.FName = ").append(14);
        sql.append(" and bill.fcompanyid = '").append(currCompany.getId().toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    private boolean isExitNoCal(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        IFaDepCalFacade depCal;
        FaCurCardCollection card;
        boolean hasDep = this.ifAlreadyCal(ctx, company, period);
        return !hasDep && (card = (depCal = FaDepCalFacadeFactory.getLocalInstance((Context)ctx)).getDepCardCollection(company)).size() > 0;
    }

    private boolean ifAlreadyCal(Context ctx, CompanyOrgUnitInfo company, PeriodInfo period) throws BOSException, EASBizException {
        if (period == null) {
            throw new BOSException("period is null");
        }
        IFaDepreciation iDep = FaDepreciationFactory.getLocalInstance((Context)ctx);
        String companyId = company.getId().toString();
        String periodId = period.getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)periodId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("depType", (Object)new Integer(0), CompareType.EQUALS));
        return iDep.exists(filterInfo);
    }

    private boolean isNeedRedoDep(Context ctx, String companyId) throws BOSException, EASBizException {
        IFaCurCard icard = FaCurCardFactory.getLocalInstance((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)companyId));
        filter.getFilterItems().add(new FilterItemInfo("isNeedReDepr", (Object)"1", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("deprMethod.number", (Object)"006", CompareType.NOTEQUALS));
        return icard.exists(filter);
    }

    public BizCheckResult checkHasDeal(Context ctx, BOSUuid id) throws BizHasDealException {
        try {
            boolean isEnable = this.isEnable(ctx, id);
            FaPeriodCloseFacadeControllerBean faPeriodCloseFacade = new FaPeriodCloseFacadeControllerBean();
            String acrefid = id.toString();
            this.FaAlterModeSwap(ctx, isEnable, acrefid);
            this.FaEvalSchemeSwap(ctx, isEnable, acrefid);
            this.FaCurCardSwap(ctx, isEnable, acrefid);
        }
        catch (BOSException e) {
            throw new BizHasDealException(BizBalanceException.SQL_ERR, (Throwable)e);
        }
        return new BizCheckResult(false);
    }

    private void FaAlterModeSwap(Context ctx, boolean isEnbale, String acrefID) throws BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String sAccountId = isEnbale ? "fnewacctid" : "foldacctid";
        String wAccountId = isEnbale ? "foldacctid" : "fnewacctid";
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_altermode set faccountid = (select max(e.").append(sAccountId).append(")");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and e.").append(wAccountId).append(" = t_fa_altermode.faccountid)");
        sql.append(" where fcompanyid = '" + companyId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void FaEvalSchemeSwap(Context ctx, boolean isEnbale, String acrefID) throws BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String sAccountId = isEnbale ? "fnewacctid" : "foldacctid";
        String wAccountId = isEnbale ? "foldacctid" : "fnewacctid";
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_faevascheme set fincrementAccountid = (select max(e.").append(sAccountId).append(")");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and e.").append(wAccountId).append(" = t_fa_faevascheme.fincrementAccountid)");
        sql.append(" where fcompanyid = '" + companyId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_fa_faevascheme set flossAccountid = (select max(e.").append(sAccountId).append(")");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and e.").append(wAccountId).append(" = t_fa_faevascheme.flossAccountid)");
        sql.append(" where fcompanyid = '" + companyId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_fa_faevascheme set fcommuteLossAccountid = (select max(e.").append(sAccountId).append(")");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and e.").append(wAccountId).append(" = t_fa_faevascheme.fcommuteLossAccountid)");
        sql.append(" where fcompanyid = '" + companyId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void FaCurCardSwap(Context ctx, boolean isEnbale, String acrefID) throws BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        String sAccountId = isEnbale ? "fnewacctid" : "foldacctid";
        String wAccountId = isEnbale ? "foldacctid" : "fnewacctid";
        StringBuffer sql = new StringBuffer();
        sql.append("update t_fa_facurcard set faccountAssetid = (select max(e.").append(sAccountId).append(")");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and e.").append(wAccountId).append(" = t_fa_facurcard.faccountAssetid)");
        sql.append(" where fcompanyid = '" + companyId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_fa_facurcard set faccountAccuDeprid = (select max(e.").append(sAccountId).append(")");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and e.").append(wAccountId).append(" = t_fa_facurcard.faccountAccuDeprid)");
        sql.append(" where fcompanyid = '" + companyId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_fa_facurcard set faccountDecValueid = (select max(e.").append(sAccountId).append(")");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and e.").append(wAccountId).append(" = t_fa_facurcard.faccountDecValueid)");
        sql.append(" where fcompanyid = '" + companyId + "'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql = new StringBuffer();
        sql.append("update t_fa_facurcostcenter set faccountviewid = (select max(e.").append(sAccountId).append(")");
        sql.append(" from t_bd_acctrefcontrast a inner join t_bd_acctrefcontrastentry e on a.fid = e.facctrefcontrastid");
        sql.append(" where a.fid = '" + acrefID + "' and e.").append(wAccountId).append(" = t_fa_facurcostcenter.faccountviewid)");
        sql.append(" where ffacurcardid in (select fid from t_fa_facurcard where fcompanyid = '" + companyId + "')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private boolean isEnable(Context ctx, BOSUuid id) throws BOSException {
        String sql = "select fisenabled from t_bd_acctrefcontrast where fid=? ";
        try {
            IRowSet set = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{id.toString()});
            if (set != null && set.next()) {
                return set.getBoolean("fisenabled");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private PeriodInfo getCurrPeriod(Context ctx) throws BOSException {
        String companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT distinct period.FID AS fid ,period.fTypeid as periodtypeid,period.fperiodyear as periodyear, period.fperiodnumber as periodnumber");
        sql.append(" FROM T_BD_SystemStatusCtrol ssc");
        sql.append(" INNER JOIN T_BD_Period period ON ssc.FCurrentPeriodID = period.FID");
        sql.append(" INNER JOIN T_ORG_Company company ON ssc.FCompanyID = company.FID");
        sql.append(" INNER JOIN T_BD_SystemStatus ss ON ss.FID = ssc.FSystemStatusID");
        sql.append(" WHERE ss.FName = ").append(14);
        sql.append(" and ssc.fisstart = 1");
        sql.append(" and company.fisonlyunion = 0");
        sql.append(" and company.fid = '").append(companyId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        PeriodInfo period = null;
        try {
            if (rowSet.next()) {
                period = new PeriodInfo();
                period.setId(BOSUuid.read((String)rowSet.getString("fid")));
                period.setPeriodYear(rowSet.getInt("periodyear"));
                period.setPeriodNumber(rowSet.getInt("periodnumber"));
                PeriodTypeInfo periodType = new PeriodTypeInfo();
                periodType.setId(BOSUuid.read((String)rowSet.getString("periodtypeid")));
                period.setPeriodType(periodType);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return period;
    }

    private HashMap gethmParam(Context ctx, String companyIds) throws BOSException, EASBizException {
        HashMap hmParam = null;
        ObjectUuidPK pk = new ObjectUuidPK(companyIds);
        HashMap<String, ObjectUuidPK> paramKeyMap = new HashMap<String, ObjectUuidPK>();
        paramKeyMap.put("FA_004", pk);
        paramKeyMap.put("FA_005", pk);
        paramKeyMap.put("FA_006", pk);
        IParamControl iParamControl = ParamControlFactory.getLocalInstance((Context)ctx);
        hmParam = iParamControl.getParamHashMap(paramKeyMap);
        return hmParam;
    }

    private String getResource(Context ctx, String s1, String s2) {
        Locale l = ctx.getOriginLocale();
        return ResourceBase.getString((String)s1, (String)s2, (Locale)l);
    }
}

