/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.def.app.common;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.def.DefSumSQLOptionProviderImpl;
import com.kingdee.eas.fi.fa.def.FaDefCommonFacadeFactory;
import com.kingdee.eas.fi.fa.def.FaDefPropertyCollection;
import com.kingdee.eas.fi.fa.def.FaDefPropertyInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.LocaleUtils;
import java.util.Locale;
import java.util.Map;

public class FaDaoDefPart {
    private static final String DEF_TABLE = "PV";
    private static final String DEF_TABLE_SUBTABLE = "PV_";
    private EntityViewInfo ev;
    private Context ctx;
    private FaDefPropertyCollection pc;
    private String loc;

    public FaDaoDefPart(EntityViewInfo ev, Context ctx) throws BOSException {
        this.ev = ev;
        this.ctx = ctx;
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        Map cond = this.ev != null ? (Map)this.ev.get("customcond") : null;
        String companyId = null;
        if (cond != null) {
            companyId = (String)cond.get("def_company_id");
        }
        if (companyId == null) {
            companyId = ContextUtil.getCurrentFIUnit((Context)ctx).getId().toString();
        }
        this.pc = FaDefCommonFacadeFactory.getLocalInstance(ctx).getProperties(companyId, true);
    }

    public DefSumSQLOptionProviderImpl getSumSQLOption(String sumDefName, boolean fieldBeWrapped) {
        if (!sumDefName.startsWith("def_")) {
            return null;
        }
        DefSumSQLOptionProviderImpl ss = new DefSumSQLOptionProviderImpl();
        String name = sumDefName.substring("def_".length());
        int n = this.pc.size();
        for (int i = 0; i < n; ++i) {
            FaDefPropertyInfo p = this.pc.get(i);
            if (!name.equals(p.getNumber())) continue;
            ss.select = sumDefName + "Name";
            ss.group = sumDefName + "Number";
            String sql = fieldBeWrapped ? DEF_TABLE_SUBTABLE + name : (p.isLinkProperty() ? this.getSubTableAlias(p) + ".FName_" + this.loc : "PV." + p.getColumnName());
            ss.selectSql = sql + " as " + ss.select;
            ss.groupSql = sql + " as " + ss.group;
            ss.columnName = p.getName();
            break;
        }
        return ss;
    }

    public String getSelectPart(String wrapTableAlias) {
        return this.getSelectPart(wrapTableAlias, "");
    }

    public String getSelectPart(String wrapTableAlias, String secondPrefix) {
        StringBuffer sb = new StringBuffer();
        int n = this.pc.size();
        for (int i = 0; i < n; ++i) {
            FaDefPropertyInfo p = this.pc.get(i);
            sb.append(",");
            if (wrapTableAlias == null) {
                if (p.isLinkProperty()) {
                    sb.append(secondPrefix + this.getSubTableAlias(p)).append(".FName_").append(this.loc);
                } else {
                    sb.append(secondPrefix + DEF_TABLE).append(".").append(p.getColumnName());
                }
                sb.append(" as ").append(secondPrefix + DEF_TABLE).append("_").append(p.getNumber());
                continue;
            }
            String prefix = wrapTableAlias.length() > 0 ? wrapTableAlias + "." : "";
            String field = prefix + secondPrefix + DEF_TABLE + "_" + p.getNumber();
            sb.append(field);
        }
        sb.append(" ");
        return sb.toString();
    }

    public String getSelectNoSumPart(String wrapTableAlias) {
        return this.getSelectSumPart(wrapTableAlias, "", true, false);
    }

    public String getSelectSumPart(String wrapTableAlias) {
        return this.getSelectSumPart(wrapTableAlias, "", true, true);
    }

    public String getSelectSumPart(String wrapTableAlias, String asPrefix) {
        return this.getSelectSumPart(wrapTableAlias, asPrefix, true, true);
    }

    public String getSelectSumPart(String wrapTableAlias, boolean emptyNonNumberField) {
        return this.getSelectSumPart(wrapTableAlias, "", true, true);
    }

    public String getSelectSumPart(String wrapTableAlias, String asPrefix, boolean emptyNonNumberField, boolean isSum) {
        StringBuffer sb = new StringBuffer();
        int n = this.pc.size();
        for (int i = 0; i < n; ++i) {
            FaDefPropertyInfo p = this.pc.get(i);
            sb.append(",");
            int type = p.getType().getValue();
            if (type == 2) {
                if (isSum) {
                    String prefix = (wrapTableAlias.length() > 0 ? wrapTableAlias + "." : "") + asPrefix;
                    sb.append("sum(isnull(").append(prefix).append(DEF_TABLE).append("_").append(p.getNumber());
                    sb.append(",0)) as ");
                } else {
                    sb.append("0 ");
                }
                sb.append(asPrefix).append(DEF_TABLE).append("_").append(p.getNumber());
                continue;
            }
            if (emptyNonNumberField) {
                sb.append("TO_CHAR(NULL) as ");
            }
            sb.append(asPrefix).append(DEF_TABLE).append("_").append(p.getNumber());
        }
        sb.append(" ");
        return sb.toString();
    }

    public String getGroupPart(String wrapTableAlias) {
        StringBuffer sb = new StringBuffer();
        int n = this.pc.size();
        for (int i = 0; i < n; ++i) {
            FaDefPropertyInfo p = this.pc.get(i);
            String prefix = wrapTableAlias.length() > 0 ? wrapTableAlias + "." : "";
            int type = p.getType().getValue();
            if (type == 2) continue;
            sb.append(",").append(prefix).append(DEF_TABLE).append("_").append(p.getNumber());
        }
        sb.append(" ");
        return sb.toString();
    }

    public String getNumFieldForSumPart() {
        StringBuffer sb = new StringBuffer();
        int n = this.pc.size();
        for (int i = 0; i < n; ++i) {
            FaDefPropertyInfo p = this.pc.get(i);
            int type = p.getType().getValue();
            if (type != 2) continue;
            sb.append(",").append(DEF_TABLE).append("_").append(p.getNumber());
        }
        sb.append(" ");
        return sb.toString();
    }

    private String getSubTableAlias(FaDefPropertyInfo p) {
        return DEF_TABLE_SUBTABLE + p.getNumber();
    }

    public String getJoinPart(String joinField) throws BOSException, EASBizException {
        return this.getJoinPart(joinField, "");
    }

    public String getJoinPart(String joinField, String secondJoinPrefix) throws BOSException, EASBizException {
        StringBuffer sb = new StringBuffer("\r\n left join t_fa_fadefPropertyValue " + secondJoinPrefix + DEF_TABLE + " on " + secondJoinPrefix + DEF_TABLE + ".FID=" + joinField);
        int n = this.pc.size();
        for (int i = 0; i < n; ++i) {
            FaDefPropertyInfo p = this.pc.get(i);
            int t = p.getType().getValue();
            String alias = secondJoinPrefix + this.getSubTableAlias(p);
            if (!p.isLinkProperty()) continue;
            String joinTable = null;
            if (t == 3) {
                joinTable = "t_fa_fadefPropertyEnum";
            } else if (t == 5) {
                IAsstActType it = AsstActTypeFactory.getLocalInstance((Context)this.ctx);
                AsstActTypeInfo actType = it.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(p.getAsstActType().getId()));
                joinTable = actType.getRealtionDataObject();
            }
            sb.append(" left join " + joinTable + " ").append(alias).append(" on ").append(alias).append(".FID=").append(secondJoinPrefix + DEF_TABLE).append(".").append(p.getColumnName());
        }
        sb.append(" ");
        return sb.toString();
    }

    public String property2FieldAtFilter(String filter) {
        return filter.replaceAll("PV\\.", "PV\\.f");
    }

    public String property2FieldAtFilterByWrapped(String filter) {
        return filter.replaceAll("PV\\.", DEF_TABLE_SUBTABLE);
    }

    public void dealWithFilter(FilterItemInfo filter) {
        String propertyName = filter.getPropertyName();
        if (propertyName.indexOf("PV.") < 0) {
            return;
        }
        try {
            if (filter.getCompareValue() != null && BOSObjectType.create((String)"DADD774B").equals((Object)BOSUuid.getBOSObjectType((String)filter.getCompareValue().toString(), (boolean)false))) {
                return;
            }
        }
        catch (Exception e) {
            int n = this.pc.size();
            for (int i = 0; i < n; ++i) {
                FaDefPropertyInfo p = this.pc.get(i);
                int t = p.getType().getValue();
                String alias = this.getSubTableAlias(p);
                if (!p.isLinkProperty() || propertyName.indexOf(p.getNumber()) == -1 || t != 3 && t != 5) continue;
                filter.setPropertyName(alias + ".fname_l2");
            }
        }
    }

    public String getSelectDefColumns(String wrapTableAlias, String secondPrefix) {
        StringBuffer sb = new StringBuffer();
        int n = this.pc.size();
        for (int i = 0; i < n; ++i) {
            FaDefPropertyInfo p = this.pc.get(i);
            sb.append(",");
            String prefix = wrapTableAlias != null && wrapTableAlias.length() > 0 ? wrapTableAlias + "." : "";
            String field = prefix + secondPrefix + DEF_TABLE + "_" + p.getNumber();
            sb.append(field);
        }
        sb.append(" ");
        return sb.toString();
    }

    public FaDefPropertyCollection getPc() {
        return this.pc;
    }
}

