/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountView;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.facade.FaXmlUtil;
import com.kingdee.eas.fi.fa.manage.FaBakCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBakCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBakCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaBakDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaBizCardFactory;
import com.kingdee.eas.fi.fa.manage.FaBizCardInfo;
import com.kingdee.eas.fi.fa.manage.FaBizCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaBizDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillCollection;
import com.kingdee.eas.fi.fa.manage.FaChangeBillFactory;
import com.kingdee.eas.fi.fa.manage.FaChangeBillInfo;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaCurAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCardCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaCurCardInfo;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaCurCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaCurDepartmentInfo;
import com.kingdee.eas.fi.fa.manage.FaMonAsstActCompositCollection;
import com.kingdee.eas.fi.fa.manage.FaMonAsstActCompositInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCardCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMonCardInfo;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterCollection;
import com.kingdee.eas.fi.fa.manage.FaMonCostCenterInfo;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentCollection;
import com.kingdee.eas.fi.fa.manage.FaMonDepartmentInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.tools.datatask.task.util.IAccountingDataInterface;
import com.kingdee.eas.tools.datatask.task.util.XMLElementAssembeler;
import com.kingdee.eas.tools.datatask.task.util.XMLGenerator;
import com.kingdee.util.UuidException;
import java.io.File;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Element;

public class FAXMLGenerator
extends XMLGenerator
implements IAccountingDataInterface {
    private String STANDARD_NUMBER = "GB/T 24589.1\u20142010";
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.facade.FAXMLGenerator");
    private CtrlUnitInfo ctrlUnitInfo;
    private String companyInfoId;
    private String[] changeContent = new String[]{"", ""};
    private final int ZERO = 0;
    private final int TWO = 2;
    private final int SIX = 6;

    public Document generateXML(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        throw new UnsupportedOperationException();
    }

    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, List<PeriodInfo> periodInfos) {
        String type = this.getTypeName(ctx);
        Element root = this.initHeadAndFileName(ctx, companyInfo, type);
        this.ctrlUnitInfo = this.getCtrlUnit(companyInfo, ctx);
        this.companyInfoId = companyInfo.getId().toString();
        for (int i = 0; i < periodInfos.size(); ++i) {
            PeriodInfo periodInfoObject = periodInfos.get(i);
            this.generateFAContrastScheme(root, ctx, companyInfo, periodInfoObject);
            this.generateFaCat(root, ctx, companyInfo, periodInfoObject);
            this.generateAlterMode(root, ctx, companyInfo, periodInfoObject);
            this.generateFaDeprMode(root, ctx, companyInfo, periodInfoObject);
            this.generateUseStatus(root, ctx, companyInfo, periodInfoObject);
            this.generateCardInfo(root, ctx, companyInfo, periodInfoObject);
            this.generateCardPracticality(root, ctx, companyInfo, periodInfoObject);
            this.generateCardUseInfo(root, ctx, companyInfo, periodInfoObject);
            this.generateDecline(root, ctx, companyInfo, periodInfoObject);
            this.generateDeclinePracticality(root, ctx, companyInfo, periodInfoObject);
            this.generateChangeInfo(root, ctx, companyInfo, periodInfoObject);
        }
        this.endElement();
        this.close();
        return this.file;
    }

    public File generate(Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        String type = this.getTypeName(ctx);
        Element root = this.initHeadAndFileName(ctx, companyInfo, type);
        this.ctrlUnitInfo = this.getCtrlUnit(companyInfo, ctx);
        this.companyInfoId = companyInfo.getId().toString();
        this.generateFAContrastScheme(root, ctx, companyInfo, periodinfo);
        this.generateFaCat(root, ctx, companyInfo, periodinfo);
        this.generateAlterMode(root, ctx, companyInfo, periodinfo);
        this.generateFaDeprMode(root, ctx, companyInfo, periodinfo);
        this.generateUseStatus(root, ctx, companyInfo, periodinfo);
        this.generateCardInfo(root, ctx, companyInfo, periodinfo);
        this.generateCardPracticality(root, ctx, companyInfo, periodinfo);
        this.generateCardUseInfo(root, ctx, companyInfo, periodinfo);
        this.generateDecline(root, ctx, companyInfo, periodinfo);
        this.generateDeclinePracticality(root, ctx, companyInfo, periodinfo);
        this.generateChangeInfo(root, ctx, companyInfo, periodinfo);
        this.endElement();
        this.close();
        return this.file;
    }

    private void generateFAContrastScheme(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                HashMap contrastScheme = new HashMap();
                contrastScheme.put("asset", "");
                contrastScheme.put("depr", "");
                contrastScheme.put("dec", "");
                boolean flag = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        String contrastXml = this.rowset.getString("contrastXml");
                        HashMap accountInfo = FAXMLGenerator.this.getAccountInfo(this.ctx, contrastXml);
                        if (((Boolean)accountInfo.get("isDefaultSoluion")).booleanValue()) {
                            contrastScheme = accountInfo;
                            flag = true;
                            continue;
                        }
                        if (flag) continue;
                        contrastScheme = accountInfo;
                        flag = true;
                    }
                }
                Element scheme = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u57fa\u7840\u4fe1\u606f");
                FAXMLGenerator.this.addStringElement(scheme, "\u56fa\u5b9a\u8d44\u4ea7\u5bf9\u8d26\u79d1\u76ee", contrastScheme.get("asset").toString(), 60, false);
                FAXMLGenerator.this.addStringElement(scheme, "\u51cf\u503c\u51c6\u5907\u5bf9\u8d26\u79d1\u76ee", contrastScheme.get("dec").toString(), 60, false);
                FAXMLGenerator.this.addStringElement(scheme, "\u7d2f\u8ba1\u6298\u65e7\u5bf9\u8d26\u79d1\u76ee", contrastScheme.get("depr").toString(), 60, false);
                FAXMLGenerator.this.endElement();
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select fparams as contrastXml from T_FA_FaContrastSolution where forgid = ?");
                this.setObjectList(new Object[]{this.companyInfo.getId().toString()});
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateFaCat(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String number = this.rowset.getString("number");
                        String name = this.rowset.getString("name");
                        Element cat = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u8bbe\u7f6e");
                        FAXMLGenerator.this.addStringElement(cat, "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u7f16\u7801\u89c4\u5219", "", 60, false);
                        FAXMLGenerator.this.addStringElement(cat, "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u7f16\u7801", number, 60, false);
                        FAXMLGenerator.this.addStringElement(cat, "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u540d\u79f0", name, 60, false);
                        FAXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    Element cat = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u8bbe\u7f6e");
                    FAXMLGenerator.this.addStringElement(cat, "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u7f16\u7801\u89c4\u5219", null, 60, false);
                    FAXMLGenerator.this.addStringElement(cat, "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(cat, "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u540d\u79f0", null, 60, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select fnumber as number,fname_l2 as name ");
                sql.append("  from t_fa_cat ");
                sql.append(" where fcompanyid = ? ");
                sql.append(" order by number ");
                this.setObjectList(new Object[]{this.companyInfo.getId().toString()});
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateAlterMode(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String number = this.rowset.getString("number");
                        String name = this.rowset.getString("name");
                        Element alterMode = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u65b9\u5f0f");
                        FAXMLGenerator.this.addStringElement(alterMode, "\u53d8\u52a8\u65b9\u5f0f\u7f16\u7801", number, 60, false);
                        FAXMLGenerator.this.addStringElement(alterMode, "\u53d8\u52a8\u65b9\u5f0f\u540d\u79f0", name, 60, false);
                        FAXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    Element alterMode = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u65b9\u5f0f");
                    FAXMLGenerator.this.addStringElement(alterMode, "\u53d8\u52a8\u65b9\u5f0f\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(alterMode, "\u53d8\u52a8\u65b9\u5f0f\u540d\u79f0", null, 60, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select fnumber as number,fname_l2 as name ");
                sql.append("  from T_FA_AlterMode ");
                sql.append(" where fcompanyid = ?");
                sql.append(" order by fnumber asc ");
                this.setObjectList(new Object[]{this.companyInfo.getId().toString()});
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateFaDeprMode(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        String number = this.rowset.getString("number");
                        String name = this.rowset.getString("name");
                        String formula = this.rowset.getString("formula");
                        Element deprMode = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u6298\u65e7\u65b9\u6cd5");
                        FAXMLGenerator.this.addStringElement(deprMode, "\u6298\u65e7\u65b9\u6cd5\u7f16\u7801", number, 60, false);
                        FAXMLGenerator.this.addStringElement(deprMode, "\u6298\u65e7\u65b9\u6cd5\u540d\u79f0", name, 60, false);
                        FAXMLGenerator.this.addStringElement(deprMode, "\u6298\u65e7\u516c\u5f0f", formula, 200, false);
                        FAXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    Element deprMode = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u6298\u65e7\u65b9\u6cd5");
                    FAXMLGenerator.this.addStringElement(deprMode, "\u6298\u65e7\u65b9\u6cd5\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(deprMode, "\u6298\u65e7\u65b9\u6cd5\u540d\u79f0", null, 60, false);
                    FAXMLGenerator.this.addStringElement(deprMode, "\u6298\u65e7\u516c\u5f0f", null, 60, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select fnumber as number,fname_l2 as name,fformula_l2 as formula ");
                sql.append("  from t_fa_depreciationmode ");
                sql.append("  order by number ");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateUseStatus(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String number = this.rowset.getString("number");
                        String name = this.rowset.getString("name");
                        Element useStatus = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u4f7f\u7528\u72b6\u51b5");
                        FAXMLGenerator.this.addStringElement(useStatus, "\u4f7f\u7528\u72b6\u51b5\u7f16\u7801", number, 60, false);
                        FAXMLGenerator.this.addStringElement(useStatus, "\u4f7f\u7528\u72b6\u51b5\u540d\u79f0", name, 60, false);
                        FAXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    Element useStatus = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u4f7f\u7528\u72b6\u51b5");
                    FAXMLGenerator.this.addStringElement(useStatus, "\u4f7f\u7528\u72b6\u51b5\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(useStatus, "\u4f7f\u7528\u72b6\u51b5\u540d\u79f0", null, 60, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select fnumber as number,fname_l2 as name ");
                sql.append("  from t_fa_usestatus ");
                sql.append(" where fcompanyid = ?");
                sql.append(" order by number ");
                this.setObjectList(new Object[]{this.companyInfo.getId().toString()});
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateCardInfo(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    hasRows = true;
                    while (this.rowset.next()) {
                        String cardId = this.rowset.getString("cardId");
                        String catNumber = this.rowset.getString("catNumber");
                        String cardNumber = this.rowset.getString("cardNumber");
                        String cardName = this.rowset.getString("cardName");
                        Date cardAccountDate = this.rowset.getDate("cardAccountDate");
                        int periodNumber = this.periodinfo.getPeriodNumber();
                        if (periodNumber > 12) {
                            periodNumber = 1200 + periodNumber - 12;
                        }
                        String period = "" + periodNumber;
                        String mesureUnit = this.rowset.getString("mesureUnit");
                        String cardAmt = this.rowset.getString("cardAmt");
                        cardAmt = FAXMLGenerator.this.scaleTrasmit(cardAmt, 6);
                        String originNumber = this.rowset.getString("originNumber");
                        String deprNumber = this.rowset.getString("deprNumber");
                        String useStatusNumber = this.rowset.getString("useStatusNumber");
                        String useTermCount = this.rowset.getString("useTermCount");
                        useTermCount = FAXMLGenerator.this.scaleTrasmit(useTermCount, 0);
                        String deprTermCount = this.rowset.getString("deprTermCount");
                        deprTermCount = FAXMLGenerator.this.scaleTrasmit(deprTermCount, 0);
                        String baseCurrencyId = this.companyInfo.getBaseCurrency().getId().toString();
                        String baseCurrency = " ";
                        try {
                            baseCurrency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)baseCurrencyId))).getNumber();
                        }
                        catch (EASBizException e) {
                            logger.info((Object)e);
                        }
                        catch (BOSException e) {
                            logger.info((Object)e);
                        }
                        catch (UuidException e) {
                            logger.info((Object)e);
                        }
                        String assetValue = this.rowset.getString("assetValue");
                        assetValue = FAXMLGenerator.this.scaleTrasmit(assetValue, 2);
                        String accudepr = this.rowset.getString("accudepr");
                        accudepr = FAXMLGenerator.this.scaleTrasmit(accudepr, 2);
                        String neatValue = this.rowset.getString("neatValue");
                        neatValue = FAXMLGenerator.this.scaleTrasmit(neatValue, 2);
                        String decValue = this.rowset.getString("decValue");
                        decValue = FAXMLGenerator.this.scaleTrasmit(decValue, 2);
                        String neatLeftRate = this.rowset.getString("neatLeftRate");
                        neatLeftRate = new BigDecimal(neatLeftRate).divide(new BigDecimal("100"), 4, 4).toString();
                        String neatRemValue = this.rowset.getString("neatRemValue");
                        neatRemValue = FAXMLGenerator.this.scaleTrasmit(neatRemValue, 2);
                        String mothDepreRate = this.rowset.getString("mothDepreRate");
                        mothDepreRate = new BigDecimal(mothDepreRate).divide(new BigDecimal("100"), 6, 4).toString();
                        String deprTTerm = this.rowset.getString("deprTTerm");
                        deprTTerm = FAXMLGenerator.this.scaleTrasmit(deprTTerm, 2);
                        String measureUnitWL = this.rowset.getString("measureUnitWL");
                        String workLoadUseTermCount = this.rowset.getString("workLoadUseTermCount");
                        workLoadUseTermCount = FAXMLGenerator.this.scaleTrasmit(workLoadUseTermCount, 2);
                        String workLoadDeprTermCount = this.rowset.getString("workLoadDeprTermCount");
                        workLoadDeprTermCount = FAXMLGenerator.this.scaleTrasmit(workLoadDeprTermCount, 2);
                        String assetAcount = this.rowset.getString("assetAcount");
                        String deprAccount = this.rowset.getString("deprAccount");
                        String decAccount = this.rowset.getString("decAccount");
                        Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247");
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", cardId, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u7f16\u7801", catNumber, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7f16\u7801", cardNumber, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0", cardName, 200, false);
                        FAXMLGenerator.this.addDateElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5165\u8d26\u65e5\u671f", cardAccountDate);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", period, 15, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u8ba1\u91cf\u5355\u4f4d", mesureUnit, 60, false);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6570\u91cf", cardAmt);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u53d8\u52a8\u65b9\u5f0f\u7f16\u7801", originNumber, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u6298\u65e7\u65b9\u6cd5\u7f16\u7801", deprNumber, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u4f7f\u7528\u72b6\u51b5\u7f16\u7801", useStatusNumber, 60, false);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u9884\u8ba1\u4f7f\u7528\u6708\u4efd", useTermCount);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u5df2\u8ba1\u63d0\u6708\u4efd", deprTermCount);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u672c\u4f4d\u5e01", baseCurrency, 30, false);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u539f\u503c", assetValue);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7d2f\u8ba1\u6298\u65e7", accudepr);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51c0\u503c", neatValue);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7d2f\u8ba1\u51cf\u503c\u51c6\u5907", decValue);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51c0\u6b8b\u503c\u7387", neatLeftRate);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51c0\u6b8b\u503c", neatRemValue);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6708\u6298\u65e7\u7387", mothDepreRate);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6708\u6298\u65e7\u989d", deprTTerm);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5de5\u4f5c\u91cf\u5355\u4f4d", measureUnitWL, 20, false);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5de5\u4f5c\u603b\u91cf", workLoadUseTermCount);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u7d2f\u8ba1\u5de5\u4f5c\u603b\u91cf", workLoadDeprTermCount);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5bf9\u8d26\u79d1\u76ee", assetAcount, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u51cf\u503c\u51c6\u5907\u5bf9\u8d26\u79d1\u76ee", decAccount, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u7d2f\u8ba1\u6298\u65e7\u5bf9\u8d26\u79d1\u76ee", deprAccount, 60, false);
                        FAXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247");
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7c7b\u522b\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0", null, 200, false);
                    FAXMLGenerator.this.addDateElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5165\u8d26\u65e5\u671f", null);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", null, 15, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u8ba1\u91cf\u5355\u4f4d", null, 60, false);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6570\u91cf", null);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u53d8\u52a8\u65b9\u5f0f\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u6298\u65e7\u65b9\u6cd5\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u4f7f\u7528\u72b6\u51b5\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u9884\u8ba1\u4f7f\u7528\u6708\u4efd", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u5df2\u8ba1\u63d0\u6708\u4efd", null);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u672c\u4f4d\u5e01", null, 30, false);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u539f\u503c", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7d2f\u8ba1\u6298\u65e7", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51c0\u503c", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7d2f\u8ba1\u51cf\u503c\u51c6\u5907", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51c0\u6b8b\u503c\u7387", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51c0\u6b8b\u503c", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6708\u6298\u65e7\u7387", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6708\u6298\u65e7\u989d", null);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5de5\u4f5c\u91cf\u5355\u4f4d", null, 20, false);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5de5\u4f5c\u603b\u91cf", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u7d2f\u8ba1\u5de5\u4f5c\u603b\u91cf", null);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5bf9\u8d26\u79d1\u76ee", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u51cf\u503c\u51c6\u5907\u5bf9\u8d26\u79d1\u76ee", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u7d2f\u8ba1\u6298\u65e7\u5bf9\u8d26\u79d1\u76ee", null, 60, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                PeriodInfo currentPeriod = this.periodinfo;
                try {
                    currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.companyInfo);
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
                boolean iscurPeriod = false;
                if (currentPeriod == null || currentPeriod.getId().toString().equals(this.periodinfo.getId().toString())) {
                    iscurPeriod = true;
                }
                StringBuffer sql = new StringBuffer();
                sql.append(" select ");
                sql.append(" card.fnumber as cardId, ");
                sql.append(" cat.fnumber as catNumber, ");
                sql.append(" card.fnumber as cardNumber, ");
                sql.append(" card.FAssetName as cardName, ");
                sql.append(" card.FFiAccountDate  as cardAccountDate, ");
                sql.append(" mesureUnit.fname_l2 as  mesureUnit, ");
                sql.append(" card.FAssetAmt  as cardAmt, ");
                sql.append(" alterMode.fnumber  as originNumber, ");
                sql.append(" deprMerhod.fnumber as deprNumber, ");
                sql.append(" useStatus.fnumber as useStatusNumber, ");
                sql.append(" case when deprMerhod.fnumber = '002' then 0 else card.FUseTermCount end as useTermCount, ");
                sql.append(" case when deprMerhod.fnumber = '002' then 0 else card.FdeprTermCount end as deprTermCount, ");
                sql.append(" card.FAssetValue as assetValue, ");
                sql.append(" card.FAccuDepr as accudepr, ");
                sql.append(" card.FNeatValue as neatValue, ");
                sql.append(" card.FDecValue as decValue, ");
                sql.append(" card.FNeatLeftRate as neatLeftRate, ");
                sql.append(" card.FNeatRemValue as neatRemValue, ");
                sql.append(" card.FMonthDepreRate as mothDepreRate, ");
                sql.append(" card.FDeprTTerm as deprTTerm, ");
                sql.append(" measureUnitWL.fname_l2 as measureUnitWL, ");
                sql.append(" case when deprMerhod.fnumber = '002' then card.FUseTermCount else 0 end  as workLoadUseTermCount, ");
                sql.append(" case when deprMerhod.fnumber = '002' then card.FdeprTermCount else 0 end as workLoadDeprTermCount, ");
                sql.append(" assetAccount.fnumber as assetAcount, ");
                sql.append(" deprAccount.fnumber as deprAccount, ");
                sql.append(" decAcount.fnumber as decAccount ");
                if (iscurPeriod) {
                    sql.append(" from t_fa_facurcard card  ");
                } else {
                    sql.append(" from t_fa_famoncard card  ");
                }
                sql.append(" inner join t_fa_cat cat on card.FAssetCatID = cat.fid ");
                sql.append(" inner join T_BD_MeasureUnit mesureUnit on card.FMeasureUnitID = mesureUnit.fid ");
                sql.append(" inner join T_FA_AlterMode alterMode on card.FOriginMethodID = alterMode.fid ");
                sql.append(" inner join T_FA_DepreciationMode deprMerhod on card.FDeprMethodID = deprMerhod.fid ");
                sql.append(" inner join T_FA_UseStatus useStatus on card.FUseStatusID = useStatus.fid ");
                sql.append(" left outer join T_BD_MeasureUnit measureUnitWL on card.FMeasureUnitWLID = measureUnitWL.fid ");
                sql.append(" left outer join T_BD_AccountView assetAccount on card.FAccountAssetID = assetAccount.fid ");
                sql.append(" left outer join T_BD_AccountView deprAccount on card.FAccountAccuDeprID = deprAccount.fid ");
                sql.append(" left outer join T_BD_AccountView decAcount on card.FAccountDecValueID = decAcount.fid ");
                sql.append(" where card.fcompanyid = '").append(this.companyInfo.getId().toString()).append("' ");
                if (!iscurPeriod) {
                    sql.append(" and card.ffaperiodid = '").append(this.periodinfo.getId().toString()).append("' ");
                }
                sql.append(" and card.fcheckedstatus = 2 ");
                sql.append(" and card.fdeletedstatus != 2 ");
                sql.append(" order by cardId asc ");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateDeclinePracticality(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        String cardId;
                        hasRows = true;
                        String number = this.rowset.getString("clearNumber");
                        String tag = cardId = this.rowset.getString("cardId");
                        int periodNumber = this.periodinfo.getPeriodNumber();
                        if (periodNumber > 12) {
                            periodNumber = 1200 + periodNumber - 12;
                        }
                        String period = "" + periodNumber;
                        Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u5b9e\u7269\u4fe1\u606f");
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u6d41\u6c34\u53f7", number, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", cardId, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", tag, 200, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", period, 14, false);
                        FAXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u5b9e\u7269\u4fe1\u606f");
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u6d41\u6c34\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", null, 200, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", null, 14, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append(" select ");
                sql.append(" head.fnumber as clearNumber, ");
                sql.append(" card.fnumber as cardId ");
                sql.append(" from t_fa_clearbill head  ");
                sql.append(" inner join t_fa_clearbillentry entry on entry.fentryid = head.fid  ");
                sql.append(" inner join t_fa_fabizcard card on entry.fbizcardid = card.fid ");
                sql.append(" where head.fcompanyid = '").append(this.companyInfo.getId().toString()).append("' ");
                sql.append(" and head.fperiodid = '").append(this.periodinfo.getId().toString()).append("' ");
                sql.append(" and head.fcheckedstatus = 2 ");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateDecline(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String number = this.rowset.getString("clearNumber");
                        Date bizDate = this.rowset.getDate("bizDate");
                        int periodNumber = this.periodinfo.getPeriodNumber();
                        if (periodNumber > 12) {
                            periodNumber = 1200 + periodNumber - 12;
                        }
                        String period = "" + periodNumber;
                        String clearMode = this.rowset.getString("clearMode");
                        String cardId = this.rowset.getString("cardId");
                        String cardName = this.rowset.getString("cardName");
                        String cardNumber = this.rowset.getString("cardNumber");
                        String clrQty = this.rowset.getString("clrQty");
                        clrQty = FAXMLGenerator.this.scaleTrasmit(clrQty, 6);
                        String clrOriginal = this.rowset.getString("clrOriginal");
                        clrOriginal = FAXMLGenerator.this.scaleTrasmit(clrOriginal, 2);
                        String clrDep = this.rowset.getString("clrDep");
                        clrDep = FAXMLGenerator.this.scaleTrasmit(clrDep, 2);
                        String clrDec = this.rowset.getString("clrDec");
                        clrDec = FAXMLGenerator.this.scaleTrasmit(clrDec, 2);
                        BigDecimal originValue = new BigDecimal(clrOriginal);
                        String clrRem = originValue.subtract(new BigDecimal(clrDep)).subtract(new BigDecimal(clrDec)).toString();
                        clrRem = FAXMLGenerator.this.scaleTrasmit(clrRem, 2);
                        String addon = this.rowset.getString("addon");
                        addon = FAXMLGenerator.this.scaleTrasmit(addon, 2);
                        String treatmentIncome = this.rowset.getString("treatmentIncome");
                        treatmentIncome = FAXMLGenerator.this.scaleTrasmit(treatmentIncome, 2);
                        String description = this.rowset.getString("description");
                        Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u60c5\u51b5");
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u6d41\u6c34\u53f7", number, 60, false);
                        FAXMLGenerator.this.addDateElement(settlementType, "\u51cf\u5c11\u53d1\u751f\u65e5\u671f", bizDate);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", period, 14, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u53d8\u52a8\u65b9\u5f0f\u7f16\u7801", clearMode, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", cardId, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0", cardName, 200, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7f16\u7801", cardNumber, 60, false);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u6570\u91cf", clrQty);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u539f\u503c", clrOriginal);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u7d2f\u8ba1\u6298\u65e7", clrDep);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u51cf\u503c\u51c6\u5907", clrDec);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u6b8b\u503c", clrRem);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u6e05\u7406\u6536\u5165", treatmentIncome);
                        FAXMLGenerator.this.addNumberElement(settlementType, "\u6e05\u7406\u8d39\u7528", addon);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u539f\u56e0", description, 200, false);
                        FAXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u60c5\u51b5");
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u6d41\u6c34\u53f7", null, 60, false);
                    FAXMLGenerator.this.addDateElement(settlementType, "\u51cf\u5c11\u53d1\u751f\u65e5\u671f", null);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", null, 14, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u53d8\u52a8\u65b9\u5f0f\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0", null, 200, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u6570\u91cf", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u539f\u503c", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u7d2f\u8ba1\u6298\u65e7", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u51cf\u503c\u51c6\u5907", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u6b8b\u503c", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u6e05\u7406\u6536\u5165", null);
                    FAXMLGenerator.this.addNumberElement(settlementType, "\u6e05\u7406\u8d39\u7528", null);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u51cf\u5c11\u539f\u56e0", null, 200, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append(" select ");
                sql.append(" head.fnumber as clearNumber, ");
                sql.append(" head.fcleardate as bizDate, ");
                sql.append(" clearMode.fnumber as clearMode, ");
                sql.append(" card.fnumber as cardId, ");
                sql.append(" card.fassetName as cardName, ");
                sql.append(" card.fnumber as cardNumber, ");
                sql.append(" entry.fclrQty as clrQty ,");
                sql.append(" entry.fclrOriginal as clrOriginal, ");
                sql.append(" entry.fclrAddupDep as clrDep, ");
                sql.append(" entry.fclrDecPrep as clrDec, ");
                sql.append(" entry.fprice as addon, ");
                sql.append(" entry.FSpilthIncome as treatmentIncome, ");
                sql.append(" head.fdescription as description ");
                sql.append(" from t_fa_clearbill head  ");
                sql.append(" inner join t_fa_clearbillentry entry on entry.fentryid = head.fid  ");
                sql.append(" inner join t_fa_alterMode clearMode on head.fclearModeId =clearMode.fid ");
                sql.append(" inner join t_fa_fabizcard card on entry.fbizcardid = card.fid ");
                sql.append(" where head.fcompanyid = '").append(this.companyInfo.getId().toString()).append("' ");
                sql.append(" and head.fperiodid = '").append(this.periodinfo.getId().toString()).append("' ");
                sql.append(" and head.fcheckedstatus = 2 ");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateCardPracticality(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String cardId = this.rowset.getString("cardId");
                        int periodNumber = this.periodinfo.getPeriodNumber();
                        if (periodNumber > 12) {
                            periodNumber = 1200 + periodNumber - 12;
                        }
                        String period = "" + periodNumber;
                        String tag = cardId;
                        String storeCity = this.rowset.getString("storeCity");
                        String specs = this.rowset.getString("specs");
                        Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u5b9e\u7269\u4fe1\u606f");
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", cardId, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", period, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", tag, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u4f4d\u7f6e", storeCity, 60, false);
                        FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u89c4\u683c\u578b\u53f7", specs, 60, false);
                        FAXMLGenerator.this.endElement();
                    }
                }
                if (!hasRows) {
                    Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u5b9e\u7269\u4fe1\u606f");
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u4f4d\u7f6e", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u89c4\u683c\u578b\u53f7", null, 60, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                PeriodInfo currentPeriod = this.periodinfo;
                try {
                    currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.companyInfo);
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
                boolean iscurPeriod = false;
                if (currentPeriod == null || currentPeriod.getId().toString().equals(this.periodinfo.getId().toString())) {
                    iscurPeriod = true;
                }
                StringBuffer sql = new StringBuffer();
                sql.append(" select ");
                sql.append(" card.fnumber as cardId, ");
                sql.append(" address.fname_l2 as storeCity, ");
                sql.append(" card.fspecs as specs ");
                if (iscurPeriod) {
                    sql.append(" from t_fa_facurcard card  ");
                } else {
                    sql.append(" from t_fa_famoncard card  ");
                }
                sql.append(" left outer join T_BD_Address address on card.FStoreCityID = address.fid ");
                sql.append(" where card.fcompanyid = '").append(this.companyInfo.getId().toString()).append("' ");
                if (!iscurPeriod) {
                    sql.append(" and card.ffaperiodid = '").append(this.periodinfo.getId().toString()).append("' ");
                }
                sql.append(" and card.fcheckedstatus = 2 ");
                sql.append(" and card.fdeletedstatus != 2 ");
                sql.append(" order by cardId asc ");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateCardUseInfo(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                int periodNumber;
                PeriodInfo currentPeriod = this.periodinfo;
                try {
                    currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.companyInfo);
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
                boolean iscurPeriod = false;
                if (currentPeriod == null || currentPeriod.getId().toString().equals(this.periodinfo.getId().toString())) {
                    iscurPeriod = true;
                }
                if ((periodNumber = this.periodinfo.getPeriodNumber()) > 12) {
                    periodNumber = 1200 + periodNumber - 12;
                }
                String period = "" + periodNumber;
                boolean hasRows = false;
                if (this.rowset != null) {
                    EntityViewInfo view;
                    HashSet<String> idSet = new HashSet<String>();
                    while (this.rowset.next()) {
                        hasRows = true;
                        String cardId = this.rowset.getString("cardId");
                        idSet.add(cardId);
                    }
                    if (iscurPeriod) {
                        view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                        SelectorItemCollection coll = FAXMLGenerator.this.getCurCardSelectors();
                        view.setSelector(coll);
                        view.setFilter(filter);
                        FaCurCardCollection curCardCollection = new FaCurCardCollection();
                        try {
                            curCardCollection = FaCurCardFactory.getLocalInstance((Context)this.ctx).getFaCurCardCollection(view);
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        for (int i = 0; i < curCardCollection.size(); ++i) {
                            String cardNumber;
                            FaCurCardInfo curCard = curCardCollection.get(i);
                            String tag = cardNumber = curCard.getNumber();
                            TreeMap<String, BigDecimal> departMap = new TreeMap<String, BigDecimal>();
                            ArrayList<String> departList = new ArrayList<String>();
                            String department = "";
                            FaCurDepartmentCollection curDepartmentCollection = curCard.getFaCurDepartment();
                            int departSize = curDepartmentCollection.size();
                            for (int j = 0; j < departSize - 1; ++j) {
                                FaCurDepartmentInfo curDepartment = curDepartmentCollection.get(j);
                                department = department + curDepartment.getUseDepartment().getNumber();
                                department = department + ",";
                                departMap.put(curDepartment.getUseDepartment().getId().toString(), new BigDecimal("0"));
                                departList.add(curDepartment.getUseDepartment().getId().toString());
                            }
                            FaCurDepartmentInfo curDepartment = curDepartmentCollection.get(departSize - 1);
                            department = department + curDepartment.getUseDepartment().getNumber();
                            departMap.put(curDepartment.getUseDepartment().getId().toString(), new BigDecimal("0"));
                            departList.add(curDepartment.getUseDepartment().getId().toString());
                            String cost = "";
                            boolean exist = false;
                            FaCurCostCenterCollection costCollecton = curCard.getFaCurCostCenter();
                            int costSize = costCollecton.size();
                            block9: for (int k = 0; k < costSize; ++k) {
                                FaCurCostCenterInfo costInfo = costCollecton.get(k);
                                BigDecimal ratio = new BigDecimal("0");
                                FaCurAsstActCompositCollection curAsst = costInfo.getFaCurAsstActComposit();
                                for (int m = 0; m < curAsst.size(); ++m) {
                                    FaCurAsstActCompositInfo asstInfo = curAsst.get(m);
                                    String asstId = asstInfo.getAsstActItem().getId().toString();
                                    if (!departMap.keySet().contains(asstId)) continue;
                                    exist = true;
                                    BigDecimal rat = (BigDecimal)departMap.get(asstId);
                                    rat = rat.add(costInfo.getApportionScale().divide(new BigDecimal("100"), 2, 4));
                                    departMap.put(asstId, rat);
                                    continue block9;
                                }
                            }
                            if (exist) {
                                for (int siz = 0; siz < departList.size(); ++siz) {
                                    String keyValue = departList.get(siz).toString();
                                    cost = cost + FAXMLGenerator.this.scaleTrasmit(departMap.get(keyValue).toString(), 2);
                                    cost = cost + ",";
                                }
                                cost = cost.substring(0, cost.length() - 1);
                            } else {
                                int num = departMap.size();
                                BigDecimal one = new BigDecimal("1");
                                BigDecimal number = new BigDecimal(num + "");
                                for (int l = 0; l < num; ++l) {
                                    cost = cost + FAXMLGenerator.this.scaleTrasmit(one.divide(number, 2, 4) + "", 2);
                                    cost = cost + ",";
                                }
                                cost = cost.substring(0, cost.length() - 1);
                            }
                            String[] departs = department.split(",");
                            String[] costs = cost.split(",");
                            for (int item = 0; item < departs.length; ++item) {
                                Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u4f7f\u7528\u4fe1\u606f");
                                FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", cardNumber, 60, false);
                                FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", tag, 200, false);
                                FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", period, 14, false);
                                FAXMLGenerator.this.addStringElement(settlementType, "\u90e8\u95e8\u7f16\u7801", departs[item], 60, false);
                                if (item > costs.length - 1) {
                                    FAXMLGenerator.this.addStringElement(settlementType, "\u6298\u65e7\u5206\u914d\u6bd4\u4f8b", costs[0], 60, false);
                                } else {
                                    FAXMLGenerator.this.addStringElement(settlementType, "\u6298\u65e7\u5206\u914d\u6bd4\u4f8b", costs[item], 60, false);
                                }
                                FAXMLGenerator.this.endElement();
                            }
                        }
                    } else {
                        view = new EntityViewInfo();
                        FilterInfo filter = new FilterInfo();
                        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                        SelectorItemCollection coll = FAXMLGenerator.this.getMonCardSelectors();
                        view.setSelector(coll);
                        view.setFilter(filter);
                        FaMonCardCollection monCardCollection = new FaMonCardCollection();
                        try {
                            monCardCollection = FaMonCardFactory.getLocalInstance((Context)this.ctx).getFaMonCardCollection(view);
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        for (int i = 0; i < monCardCollection.size(); ++i) {
                            String cardNumber;
                            FaMonCardInfo monCard = monCardCollection.get(i);
                            String tag = cardNumber = monCard.getNumber();
                            TreeMap<String, BigDecimal> departMap = new TreeMap<String, BigDecimal>();
                            ArrayList<String> departList = new ArrayList<String>();
                            String department = "";
                            FaMonDepartmentCollection monDepartmentCollection = monCard.getFaMonDepartment();
                            int departSize = monDepartmentCollection.size();
                            for (int j = 0; j < departSize - 1; ++j) {
                                FaMonDepartmentInfo monDepartment = monDepartmentCollection.get(j);
                                department = department + monDepartment.getUseDepartment().getNumber();
                                department = department + ",";
                                departMap.put(monDepartment.getUseDepartment().getId().toString(), new BigDecimal("0"));
                                departList.add(monDepartment.getUseDepartment().getId().toString());
                            }
                            FaMonDepartmentInfo monDepartment = monDepartmentCollection.get(departSize - 1);
                            department = department + monDepartment.getUseDepartment().getNumber();
                            departMap.put(monDepartment.getUseDepartment().getId().toString(), new BigDecimal("0"));
                            departList.add(monDepartment.getUseDepartment().getId().toString());
                            String cost = "";
                            boolean exist = false;
                            FaMonCostCenterCollection costCollecton = monCard.getFaMonCostCenter();
                            int costSize = costCollecton.size();
                            block16: for (int k = 0; k < costSize; ++k) {
                                FaMonCostCenterInfo costInfo = costCollecton.get(k);
                                BigDecimal ratio = new BigDecimal("0");
                                FaMonAsstActCompositCollection monAsst = costInfo.getFaMonAsstActComposit();
                                for (int m = 0; m < monAsst.size(); ++m) {
                                    FaMonAsstActCompositInfo asstInfo = monAsst.get(m);
                                    String asstId = asstInfo.getAsstActItem().getId().toString();
                                    if (!departMap.keySet().contains(asstId)) continue;
                                    exist = true;
                                    BigDecimal rat = (BigDecimal)departMap.get(asstId);
                                    rat = rat.add(costInfo.getApportionScale().divide(new BigDecimal("100"), 2, 4));
                                    departMap.put(asstId, rat);
                                    continue block16;
                                }
                            }
                            if (exist) {
                                for (int siz = 0; siz < departList.size(); ++siz) {
                                    String keyValue = departList.get(siz).toString();
                                    cost = cost + FAXMLGenerator.this.scaleTrasmit(departMap.get(keyValue).toString(), 2);
                                    cost = cost + ",";
                                }
                                cost = cost.substring(0, cost.length() - 1);
                            } else {
                                int num = departMap.size();
                                BigDecimal one = new BigDecimal("1");
                                BigDecimal number = new BigDecimal(num + "");
                                for (int l = 0; l < num; ++l) {
                                    cost = cost + FAXMLGenerator.this.scaleTrasmit(one.divide(number, 2, 4) + "", 2);
                                    cost = cost + ",";
                                }
                                cost = cost.substring(0, cost.length() - 1);
                            }
                            String[] departs = department.split(",");
                            String[] costs = cost.split(",");
                            for (int item = 0; item < departs.length; ++item) {
                                Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u4f7f\u7528\u4fe1\u606f");
                                FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", cardNumber, 60, false);
                                FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", tag, 200, false);
                                FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", period, 14, false);
                                FAXMLGenerator.this.addStringElement(settlementType, "\u90e8\u95e8\u7f16\u7801", departs[item], 60, false);
                                if (item > costs.length - 1) {
                                    FAXMLGenerator.this.addStringElement(settlementType, "\u6298\u65e7\u5206\u914d\u6bd4\u4f8b", costs[0], 60, false);
                                } else {
                                    FAXMLGenerator.this.addStringElement(settlementType, "\u6298\u65e7\u5206\u914d\u6bd4\u4f8b", costs[item], 60, false);
                                }
                                FAXMLGenerator.this.endElement();
                            }
                        }
                    }
                }
                if (!hasRows) {
                    Element settlementType = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u4f7f\u7528\u4fe1\u606f");
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", null, 200, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u4f1a\u8ba1\u671f\u95f4\u53f7", null, 14, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u90e8\u95e8\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(settlementType, "\u6298\u65e7\u5206\u914d\u6bd4\u4f8b", null, 60, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                PeriodInfo currentPeriod = this.periodinfo;
                try {
                    currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)this.ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)this.companyInfo);
                }
                catch (Exception e) {
                    logger.info((Object)e);
                }
                boolean iscurPeriod = false;
                if (currentPeriod == null || currentPeriod.getId().toString().equals(this.periodinfo.getId().toString())) {
                    iscurPeriod = true;
                }
                StringBuffer sql = new StringBuffer();
                sql.append(" select ");
                sql.append(" card.fid as cardId, ");
                sql.append(" card.fnumber as cardNumber ");
                if (iscurPeriod) {
                    sql.append(" from t_fa_facurcard card  ");
                } else {
                    sql.append(" from t_fa_famoncard card  ");
                }
                sql.append(" where card.fcompanyid = '").append(this.companyInfo.getId().toString()).append("' ");
                if (!iscurPeriod) {
                    sql.append(" and card.ffaperiodid = '").append(this.periodinfo.getId().toString()).append("' ");
                }
                sql.append(" and card.fcheckedstatus = 2 ");
                sql.append(" and card.fdeletedstatus != 2 ");
                sql.append(" order by cardId asc ");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    private void generateChangeInfo(Element root, Context ctx, CompanyOrgUnitInfo companyInfo, PeriodInfo periodinfo) {
        XMLElementAssembeler xmlea = new XMLElementAssembeler(root, ctx, companyInfo, periodinfo){

            public void addToElement() throws SQLException {
                HashSet<String> idSet = new HashSet<String>();
                boolean hasRows = false;
                if (this.rowset != null) {
                    while (this.rowset.next()) {
                        hasRows = true;
                        String changeBillId = this.rowset.getString("changeBillId");
                        idSet.add(changeBillId);
                    }
                }
                if (idSet.size() > 0) {
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    SelectorItemCollection coll = FAXMLGenerator.this.getChangeBillSelectors();
                    view.setSelector(coll);
                    view.setFilter(filter);
                    FaChangeBillCollection changeBill = new FaChangeBillCollection();
                    try {
                        changeBill = FaChangeBillFactory.getLocalInstance((Context)this.ctx).getChangeCollectionBySelector(view);
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                    }
                    for (int i = 0; i < changeBill.size(); ++i) {
                        FaChangeBillInfo changeInfo = changeBill.get(i);
                        String changeId = changeInfo.getNumber();
                        java.util.Date changeDate = changeInfo.getChangeDate();
                        int periodNumber = this.periodinfo.getPeriodNumber();
                        if (periodNumber > 12) {
                            periodNumber = 1200 + periodNumber - 12;
                        }
                        String period = "" + periodNumber;
                        String cardId = changeInfo.getChangeBillEntry().get(0).getBizCard().getNumber();
                        String cardNumber = changeInfo.getChangeBillEntry().get(0).getBizCard().getNumber();
                        String cardName = changeInfo.getChangeBillEntry().get(0).getBizCard().getAssetName();
                        String alterMode = changeInfo.getChangeMode().getNumber();
                        String tag = cardId;
                        String bakCardId = changeInfo.getChangeBillEntry().get(0).getBizCard().getFaBakCard().getId().toString();
                        String bizCardId = changeInfo.getChangeBillEntry().get(0).getBizCard().getId().toString();
                        FaBakCardInfo bakCard = null;
                        FaBizCardInfo bizCard = null;
                        try {
                            bakCard = FaBakCardFactory.getLocalInstance((Context)this.ctx).getFaBakCardInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bakCardId)), FAXMLGenerator.this.getbakCardSelector());
                            bizCard = FaBizCardFactory.getLocalInstance((Context)this.ctx).getFaBizCardInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bizCardId)), FAXMLGenerator.this.getbizCardSelector());
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        if (bakCard == null || bizCard == null) continue;
                        FAXMLGenerator.this.getChangeContent(bakCard, bizCard);
                        String alterReason = changeInfo.getDescription();
                        Element changeElement = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u60c5\u51b5");
                        FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u6d41\u6c34\u53f7", changeId, 60, false);
                        FAXMLGenerator.this.addDateElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u65e5\u671f", changeDate);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u4f1a\u8ba1\u671f\u95f4\u53f7", period, 14, false);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", cardId, 60, false);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u7f16\u7801", cardNumber, 60, false);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0", cardName, 60, false);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u53d8\u52a8\u65b9\u5f0f\u7f16\u7801", alterMode, 60, false);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", tag, 200, false);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u53d8\u52a8\u524d\u5185\u5bb9\u53ca\u6570\u503c", FAXMLGenerator.this.changeContent[0], 60, false);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u53d8\u52a8\u540e\u5185\u5bb9\u53ca\u6570\u503c", FAXMLGenerator.this.changeContent[1], 60, false);
                        FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u539f\u56e0", alterReason, 60, false);
                        FAXMLGenerator.this.endElement();
                        ((FAXMLGenerator)FAXMLGenerator.this).changeContent[0] = "";
                        ((FAXMLGenerator)FAXMLGenerator.this).changeContent[1] = "";
                    }
                }
                if (!hasRows) {
                    Element changeElement = FAXMLGenerator.this.startElement("\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u60c5\u51b5");
                    FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u6d41\u6c34\u53f7", null, 60, false);
                    FAXMLGenerator.this.addDateElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u65e5\u671f", null);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u4f1a\u8ba1\u671f\u95f4\u53f7", null, 14, false);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u7f16\u53f7", null, 60, false);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u540d\u79f0", null, 60, false);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u53d8\u52a8\u65b9\u5f0f\u7f16\u7801", null, 60, false);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u6807\u7b7e\u53f7", null, 200, false);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u53d8\u52a8\u524d\u5185\u5bb9\u53ca\u6570\u503c", null, 60, false);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u53d8\u52a8\u540e\u5185\u5bb9\u53ca\u6570\u503c", null, 60, false);
                    FAXMLGenerator.this.addStringElement(changeElement, "\u56fa\u5b9a\u8d44\u4ea7\u53d8\u52a8\u539f\u56e0", null, 60, false);
                    FAXMLGenerator.this.endElement();
                }
            }

            public String prePareSQL() {
                StringBuffer sql = new StringBuffer();
                sql.append("select fid as changeBillId ");
                sql.append("  from t_fa_fachangebill ");
                sql.append(" where fcompanyid = '").append(this.companyInfo.getId().toString()).append("' ");
                sql.append(" and fperiodid = '").append(this.periodinfo.getId().toString()).append("' ");
                sql.append(" and fcheckedstatus = 2 ");
                sql.append(" order by fnumber ");
                return sql.toString();
            }
        };
        xmlea.excuteAssemble();
    }

    public String getTypeName(Context ctx) {
        return "\u56fa\u5b9a\u8d44\u4ea7";
    }

    protected CurrencyInfo getCurrencyInfo(Context ctx, CompanyOrgUnitInfo companyInfo) {
        ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)companyInfo.getBaseCurrency().getId().toString()));
        CurrencyInfo currencyInfo = null;
        try {
            currencyInfo = (CurrencyInfo)CurrencyFactory.getLocalInstance((Context)ctx).getValue((IObjectPK)pk);
        }
        catch (EASBizException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return currencyInfo;
    }

    private HashMap getAccountInfo(Context ctx, String customerParams) {
        int i;
        String asset = "";
        String depr = "";
        String dec = "";
        boolean isdefault = false;
        HashMap<String, Object> accountInfo = new HashMap<String, Object>();
        CustomerParams cp = new CustomerParams();
        if (customerParams == null) {
            accountInfo.put("asset", asset);
            accountInfo.put("depr", depr);
            accountInfo.put("dec", dec);
            accountInfo.put("isDefaultSoluion", new Boolean(isdefault));
            return accountInfo;
        }
        try {
            cp = FaXmlUtil.TransStrToCustParams(customerParams);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        isdefault = cp.getBoolean("IsDefaultSolution");
        CustomerParams accountMap = cp.getMe("AccountMap");
        TreeSet assetKeySet = new TreeSet(accountMap.getMe("ASSET").getCustomerParamsHashMap().keySet());
        TreeSet decvalueKeySet = new TreeSet(accountMap.getMe("DECVALUE").getCustomerParamsHashMap().keySet());
        TreeSet depreKeySet = new TreeSet(accountMap.getMe("DEPRE").getCustomerParamsHashMap().keySet());
        HashMap<String, AccountViewInfo> accountInfoMap = new HashMap<String, AccountViewInfo>();
        HashSet<String> accountIdSet = new HashSet<String>();
        try {
            String value;
            int i2;
            IAccountView iAccount = AccountViewFactory.getLocalInstance((Context)ctx);
            for (i2 = 0; i2 < assetKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            for (i2 = 0; i2 < decvalueKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            for (i2 = 0; i2 < depreKeySet.size(); ++i2) {
                value = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i2]);
                accountIdSet.add(value);
            }
            if (accountIdSet.size() > 0) {
                EntityViewInfo v = new EntityViewInfo();
                FilterInfo f = new FilterInfo();
                v.setFilter(f);
                f.getFilterItems().add(new FilterItemInfo("id", accountIdSet, CompareType.INCLUDE));
                AccountViewCollection accounts = iAccount.getAccountViewCollection(v);
                for (int i3 = 0; i3 < accounts.size(); ++i3) {
                    accountInfoMap.put(accounts.get(i3).getId().toString(), accounts.get(i3));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        for (i = 0; i < assetKeySet.size(); ++i) {
            String value = (String)accountMap.getMe("ASSET").getCustomerParamsHashMap().get(assetKeySet.toArray()[i]);
            asset = asset + accountInfoMap.get(value).toString().split(" ")[0];
            if (i >= assetKeySet.size() - 1) continue;
            asset = asset + ",";
        }
        for (i = 0; i < depreKeySet.size(); ++i) {
            String value = (String)accountMap.getMe("DEPRE").getCustomerParamsHashMap().get(depreKeySet.toArray()[i]);
            depr = depr + accountInfoMap.get(value).toString().split(" ")[0];
            if (i >= depreKeySet.size() - 1) continue;
            depr = depr + ",";
        }
        for (i = 0; i < decvalueKeySet.size(); ++i) {
            String value = (String)accountMap.getMe("DECVALUE").getCustomerParamsHashMap().get(decvalueKeySet.toArray()[i]);
            dec = dec + accountInfoMap.get(value).toString().split(" ")[0];
            if (i >= decvalueKeySet.size() - 1) continue;
            dec = dec + ",";
        }
        accountInfo.put("asset", asset);
        accountInfo.put("depr", depr);
        accountInfo.put("dec", dec);
        accountInfo.put("isDefaultSoluion", new Boolean(isdefault));
        return accountInfo;
    }

    private SelectorItemCollection getChangeBillSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("changeMode.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.id"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.assetName"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.number"));
        sic.add(new SelectorItemInfo("changeBillEntry.bizCard.faBakCard.id"));
        return sic;
    }

    private SelectorItemCollection getbakCardSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assetCat.number"));
        sic.add(new SelectorItemInfo("faBakDepartment.*"));
        sic.add(new SelectorItemInfo("faBakDepartment.useDepartment.number"));
        sic.add(new SelectorItemInfo("faBakCostCenter.*"));
        sic.add(new SelectorItemInfo("faBakCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("useStatus.number"));
        sic.add(new SelectorItemInfo("economicPurp.number"));
        sic.add(new SelectorItemInfo("storeCity.number"));
        sic.add(new SelectorItemInfo("dept.number"));
        sic.add(new SelectorItemInfo("keeper.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("deprMethod.number"));
        sic.add(new SelectorItemInfo("accountAsset.number"));
        sic.add(new SelectorItemInfo("accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("accountDecValue.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        return sic;
    }

    private SelectorItemCollection getbizCardSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("assetCat.number"));
        sic.add(new SelectorItemInfo("faBizDepartment.*"));
        sic.add(new SelectorItemInfo("faBizDepartment.useDepartment.number"));
        sic.add(new SelectorItemInfo("faBizCostCenter.*"));
        sic.add(new SelectorItemInfo("faBizCostCenter.accountView.number"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("useStatus.number"));
        sic.add(new SelectorItemInfo("economicPurp.number"));
        sic.add(new SelectorItemInfo("storeCity.number"));
        sic.add(new SelectorItemInfo("dept.number"));
        sic.add(new SelectorItemInfo("keeper.number"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("deprMethod.number"));
        sic.add(new SelectorItemInfo("accountAsset.number"));
        sic.add(new SelectorItemInfo("accountAccuDepr.number"));
        sic.add(new SelectorItemInfo("accountDecValue.number"));
        sic.add(new SelectorItemInfo("evalDeprMode.number"));
        return sic;
    }

    private SelectorItemCollection getCurCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("faCurDepartment.*"));
        sic.add(new SelectorItemInfo("faCurDepartment.useDepartment.number"));
        sic.add(new SelectorItemInfo("faCurCostCenter.*"));
        sic.add(new SelectorItemInfo("faCurCostCenter.faCurAsstActComposit.*"));
        return sic;
    }

    private SelectorItemCollection getMonCardSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("faMonDepartment.*"));
        sic.add(new SelectorItemInfo("faMonDepartment.useDepartment.number"));
        sic.add(new SelectorItemInfo("faMonCostCenter.*"));
        sic.add(new SelectorItemInfo("faMonCostCenter.faMonAsstActComposit.*"));
        return sic;
    }

    private void getChangeContent(FaBakCardInfo bakCard, FaBizCardInfo bizCard) {
        int i;
        boolean continueProcess = true;
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u8d44\u4ea7\u7f16\u7801", this.changeBlank(bakCard.getNumber()), this.changeBlank(bizCard.getNumber()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u539f\u8d44\u4ea7\u7f16\u7801", this.changeBlank(bakCard.getOldNumber()), this.changeBlank(bizCard.getOldNumber()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u96c6\u56e2\u7f16\u7801", this.changeBlank(bakCard.getGroupNumber()), this.changeBlank(bizCard.getGroupNumber()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u8d44\u4ea7\u540d\u79f0", this.changeBlank(bakCard.getAssetName()), this.changeBlank(bizCard.getAssetName()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u8d44\u4ea7\u7c7b\u522b", this.changeBlank(bakCard.getAssetCat().getNumber()), this.changeBlank(bizCard.getAssetCat().getNumber()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u8d44\u4ea7\u6570\u91cf", this.changeBlank(bakCard.getAssetAmt()), this.changeBlank(bizCard.getAssetAmt()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u8ba1\u91cf\u5355\u4f4d", this.changeBlank(bakCard.getMeasureUnit().getNumber()), this.changeBlank(bizCard.getMeasureUnit().getNumber()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u4f7f\u7528\u72b6\u6001", this.changeBlank(bakCard.getUseStatus().getNumber()), this.changeBlank(bizCard.getUseStatus().getNumber()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7ecf\u6d4e\u7528\u9014", this.changeBlank(bakCard.getEconomicPurp().getNumber()), this.changeBlank(bizCard.getEconomicPurp().getNumber()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u5b58\u653e\u5730\u70b9", this.changeBlank(bakCard.getStoreCity().getNumber()), this.changeBlank(bizCard.getStoreCity().getNumber()));
        }
        if (continueProcess) {
            String bDepartInfo = "";
            String departInfo = "";
            FaBakDepartmentCollection bDepart = bakCard.getFaBakDepartment();
            for (int i2 = 0; i2 < bDepart.size(); ++i2) {
                bDepartInfo = bDepartInfo + bDepart.get(i2).getUseDepartment().getNumber();
                if (i2 == bDepart.size()) continue;
                bDepartInfo = bDepartInfo + ",";
            }
            FaBizDepartmentCollection depart = bizCard.getFaBizDepartment();
            for (i = 0; i < depart.size(); ++i) {
                departInfo = departInfo + depart.get(i).getUseDepartment().getNumber();
                if (i == depart.size()) continue;
                departInfo = departInfo + ",";
            }
            continueProcess = this.addChangeInfo("\u4f7f\u7528\u90e8\u95e8", this.changeBlank(bDepartInfo), this.changeBlank(departInfo));
        }
        if (continueProcess) {
            String bCostCenterInfo = "";
            String costCenterInfo = "";
            FaBakCostCenterCollection bCostCenter = bakCard.getFaBakCostCenter();
            for (int i3 = 0; i3 < bCostCenter.size(); ++i3) {
                bCostCenterInfo = bCostCenterInfo + bCostCenter.get(i3).getAccountView().getNumber();
                if (i3 == bCostCenter.size() - 1) continue;
                bCostCenterInfo = bCostCenterInfo + ",";
            }
            FaBizCostCenterCollection costCenter = bizCard.getFaBizCostCenter();
            for (i = 0; i < costCenter.size(); ++i) {
                costCenterInfo = costCenterInfo + costCenter.get(i).getAccountView().getNumber();
                if (i == costCenter.size() - 1) continue;
                costCenterInfo = costCenterInfo + ",";
            }
            continueProcess = this.addChangeInfo("\u6298\u65e7\u5206\u644a\u79d1\u76ee", this.changeBlank(bCostCenterInfo), this.changeBlank(costCenterInfo));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u89c4\u683c\u578b\u53f7", this.changeBlank(bakCard.getSpecs()), this.changeBlank(bizCard.getSpecs()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u4ea7\u5730", this.changeBlank(bakCard.getPArea()), this.changeBlank(bizCard.getPArea()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u5236\u9020\u5546", this.changeBlank(bakCard.getMfr()), this.changeBlank(bizCard.getMfr()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u51fa\u5382\u65e5\u671f", this.changeBlank(bakCard.getLevFrDate()), this.changeBlank(bizCard.getLevFrDate()));
        }
        if (continueProcess) {
            String bakDepMethod = bakCard.getDeprMethod() == null ? "" : bakCard.getDeprMethod().getNumber();
            String depMethod = bizCard.getDeprMethod() == null ? "" : bizCard.getDeprMethod().getNumber();
            continueProcess = this.addChangeInfo("\u6298\u65e7\u65b9\u6cd5", this.changeBlank(bakDepMethod), this.changeBlank(depMethod));
        }
        if (continueProcess) {
            String bakCurrency = bakCard.getCurrency() == null ? "" : bakCard.getCurrency().getNumber();
            String currency = bizCard.getCurrency() == null ? "" : bizCard.getCurrency().getNumber();
            continueProcess = this.addChangeInfo("\u5e01\u522b", this.changeBlank(bakCurrency), this.changeBlank(currency));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u539f\u5e01\u91d1\u989d", this.changeBlank(bakCard.getOriginAmt()), this.changeBlank(bizCard.getOriginAmt()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u8d44\u4ea7\u539f\u503c", this.changeBlank(bakCard.getAssetValue()), this.changeBlank(bizCard.getAssetValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u8d2d\u8fdb\u539f\u503c", this.changeBlank(bakCard.getBuyValue()), this.changeBlank(bizCard.getBuyValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u8d2d\u8fdb\u7d2f\u8ba1\u6298\u65e7", this.changeBlank(bakCard.getBuyAccuDepr()), this.changeBlank(bizCard.getBuyAccuDepr()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u4ea4\u4ed8\u65e5\u671f", this.changeBlank(bakCard.getDeliverDate()), this.changeBlank(bizCard.getDeliverDate()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u5f00\u59cb\u4f7f\u7528\u65e5\u671f", this.changeBlank(bakCard.getStartUseDate()), this.changeBlank(bizCard.getStartUseDate()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u9884\u8ba1\u4f7f\u7528\u5e74\u9650", this.changeBlank(bakCard.getUseYears()), this.changeBlank(bizCard.getUseYears()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u9884\u8ba1\u4f7f\u7528\u671f\u95f4\u6570", this.changeBlank(bakCard.getUseTermCount()), this.changeBlank(bizCard.getUseTermCount()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u5df2\u6298\u65e7\u671f\u95f4\u6570", this.changeBlank(bakCard.getDeprTermCount()), this.changeBlank(bizCard.getDeprTermCount()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7d2f\u8ba1\u6298\u65e7", this.changeBlank(bakCard.getAccuDepr()), this.changeBlank(bizCard.getAccuDepr()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7", this.changeBlank(bakCard.getAccuDeprTYear()), this.changeBlank(bizCard.getAccuDeprTYear()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u9884\u8ba1\u51c0\u6b8b\u503c", this.changeBlank(bakCard.getNeatRemValue()), this.changeBlank(bizCard.getNeatRemValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u9884\u8ba1\u51c0\u6b8b\u503c\u7387", this.changeBlank(bakCard.getNeatLeftRate()), this.changeBlank(bizCard.getNeatLeftRate()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u51c0\u503c", this.changeBlank(bakCard.getNeatValue()), this.changeBlank(bizCard.getNeatValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u51cf\u503c\u51c6\u5907", this.changeBlank(bakCard.getDecValue()), this.changeBlank(bizCard.getDecValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u51c0\u989d", this.changeBlank(bakCard.getNeatAmt()), this.changeBlank(bizCard.getNeatAmt()));
        }
        if (continueProcess) {
            String bakAssetAccount = bakCard.getAccountAsset() == null ? "" : bakCard.getAccountAsset().getNumber();
            String assetAccount = bizCard.getAccountAsset() == null ? "" : bizCard.getAccountAsset().getNumber();
            continueProcess = this.addChangeInfo("\u56fa\u5b9a\u8d44\u4ea7\u79d1\u76ee", this.changeBlank(bakAssetAccount), this.changeBlank(assetAccount));
        }
        if (continueProcess) {
            String bakDeprAccount = bakCard.getAccountAccuDepr() == null ? "" : bakCard.getAccountAccuDepr().getNumber();
            String deprAccount = bizCard.getAccountAccuDepr() == null ? "" : bizCard.getAccountAccuDepr().getNumber();
            continueProcess = this.addChangeInfo("\u7d2f\u8ba1\u6298\u65e7\u79d1\u76ee", this.changeBlank(bakDeprAccount), this.changeBlank(deprAccount));
        }
        if (continueProcess) {
            String bakDecAccount = bakCard.getAccountDecValue() == null ? "" : bakCard.getAccountDecValue().getNumber();
            String decAccount = bizCard.getAccountDecValue() == null ? "" : bizCard.getAccountDecValue().getNumber();
            continueProcess = this.addChangeInfo("\u51cf\u503c\u51c6\u5907\u79d1\u76ee", this.changeBlank(bakDecAccount), this.changeBlank(decAccount));
        }
        if (continueProcess) {
            String bakManageDepart = bakCard.getDept() == null ? "" : bakCard.getDept().getNumber();
            String manageDepart = bizCard.getDept() == null ? "" : bizCard.getDept().getNumber();
            continueProcess = this.addChangeInfo("\u7ba1\u7406\u90e8\u95e8", this.changeBlank(bakManageDepart), this.changeBlank(manageDepart));
        }
        if (continueProcess) {
            String bakKeeper = bakCard.getKeeper() == null ? "" : bakCard.getKeeper().getNumber();
            String keeper = bizCard.getKeeper() == null ? "" : bizCard.getKeeper().getNumber();
            continueProcess = this.addChangeInfo("\u4fdd\u7ba1\u4eba", this.changeBlank(bakKeeper), this.changeBlank(keeper));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u5361\u7247\u5907\u6ce8", this.changeBlank(bakCard.getRemark()), this.changeBlank(bizCard.getRemark()));
        }
        if (continueProcess) {
            String bakEvalDepMethod = bakCard.getEvalDeprMode() == null ? "" : bakCard.getEvalDeprMode().getNumber();
            String evalDepMethod = bizCard.getEvalDeprMode() == null ? "" : bizCard.getEvalDeprMode().getNumber();
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u6298\u65e7\u65b9\u6cd5", this.changeBlank(bakEvalDepMethod), this.changeBlank(evalDepMethod));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u8d44\u4ea7\u539f\u503c", this.changeBlank(bakCard.getEvalAssetValue()), this.changeBlank(bizCard.getEvalAssetValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u9884\u8ba1\u4f7f\u7528\u671f\u95f4\u6570", this.changeBlank(bakCard.getEvalUseTermCount()), this.changeBlank(bizCard.getEvalUseTermCount()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u5df2\u6298\u65e7\u671f\u95f4\u6570", this.changeBlank(bakCard.getEvalDeprPeriodNum()), this.changeBlank(bizCard.getEvalDeprPeriodNum()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u7d2f\u8ba1\u6298\u65e7", this.changeBlank(bakCard.getEvalAddDepr()), this.changeBlank(bizCard.getEvalAddDepr()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7", this.changeBlank(bakCard.getEvalYearDepr()), this.changeBlank(bizCard.getEvalYearDepr()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u9884\u8ba1\u51c0\u6b8b\u503c", this.changeBlank(bakCard.getEvalRemValue()), this.changeBlank(bizCard.getEvalRemValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u9884\u8ba1\u51c0\u6b8b\u503c\u7387", this.changeBlank(bakCard.getEvalNeatLeftRate()), this.changeBlank(bizCard.getEvalNeatLeftRate()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u51c0\u503c", this.changeBlank(bakCard.getEvalNeatValue()), this.changeBlank(bizCard.getEvalNeatValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u51cf\u503c\u51c6\u5907", this.changeBlank(bakCard.getEvalDecValue()), this.changeBlank(bizCard.getEvalDecValue()));
        }
        if (continueProcess) {
            continueProcess = this.addChangeInfo("\u7eb3\u7a0e\u51c0\u989d", this.changeBlank(bakCard.getEvalNeatAmt()), this.changeBlank(bizCard.getEvalNeatAmt()));
        }
    }

    private boolean canAdd(String bakString, String bizString, int maxLength) {
        return bakString.length() <= maxLength && bizString.length() <= maxLength;
    }

    private String changeBlank(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    private boolean addChangeInfo(String tag, String oldValue, String newValue) {
        if (!oldValue.equals(newValue)) {
            String changeInfo;
            String bChangeInfo = this.changeContent[0].length() == 0 ? this.changeContent[0] + tag + ":" + oldValue : this.changeContent[0] + ";" + tag + ":" + oldValue;
            if (this.canAdd(bChangeInfo, changeInfo = this.changeContent[0].length() == 0 ? this.changeContent[1] + tag + ":" + newValue : this.changeContent[1] + ";" + tag + ":" + newValue, 60)) {
                this.changeContent[0] = bChangeInfo;
                this.changeContent[1] = changeInfo;
                return true;
            }
            return false;
        }
        return true;
    }

    private String scaleTrasmit(String bigDecimalValue, int scale) {
        BigDecimal oldValue = bigDecimalValue == null ? new BigDecimal("0") : new BigDecimal(bigDecimalValue);
        BigDecimal newValue = oldValue.setScale(scale, 4);
        return newValue.toString();
    }

    public String getTypeName() {
        return null;
    }
}

