/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.SQLAccessException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.INewParamCheck;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.FaCurCardFactory;
import com.kingdee.eas.fi.fa.manage.FaMaintain;
import com.kingdee.eas.fi.fa.manage.FaManageUtils;
import com.kingdee.eas.fi.fa.manage.FaPeriodException;
import com.kingdee.eas.fi.fa.manage.FaPhysicalManageBaseException;
import com.kingdee.eas.fi.fa.manage.IFaCurCard;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FAParamCheck
implements INewParamCheck {
    private static final Logger logger = Logger.getLogger(FAParamCheck.class);
    private static Map validatorMap = new HashMap();

    public void check(Context ctx, ParamItemCollection modelCol) throws BOSException, EASBizException {
        if (modelCol == null || modelCol.size() == 0) {
            return;
        }
        ParamItemInfo model = modelCol.get(0);
        String number = model.getKeyID().getNumber();
        Object validator = validatorMap.get(number);
        if (validator != null) {
            if (validator instanceof MultiOrgValidator) {
                ((MultiOrgValidator)validator).check(ctx, modelCol);
            } else {
                int size = modelCol.size();
                for (int i = 0; i < size; ++i) {
                    ((SingleOrgValidator)validator).check(ctx, modelCol.get(i));
                }
            }
        }
    }

    static {
        validatorMap.put("FA_021", new Validator_FA021());
        validatorMap.put("FA_048", new Validator_FA048());
        validatorMap.put("FA_049", new Validator_FA049());
    }

    private static class Validator_FA049
    implements SingleOrgValidator {
        private Validator_FA049() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemInfo paramItem = iParamItem.getParamItemInfo((IObjectPK)new ObjectUuidPK(model.getId()));
            Boolean oldValue = Boolean.valueOf(paramItem.getValue());
            Boolean newValue = Boolean.valueOf(model.getValue());
            String companyId = paramItem.getOrgUnitID().getId().toString();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where id = '" + companyId + "' ");
            boolean sysWorkflow = FaManageUtils.isUseWorkflow((Context)ctx, (String)companyId, new FaMaintain().getClass());
            logger.info((Object)("1 model=" + model.getValue() + ",sysWorkflow=" + sysWorkflow));
            if (!sysWorkflow && !oldValue.booleanValue() && newValue.booleanValue() && oldValue == (newValue == false)) {
                logger.info((Object)("2 model=" + model.getValue() + ",sysWorkflow=" + sysWorkflow));
                CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
                Object[] params = new Object[]{currentCompany.isIsBizUnit() ? "" : companyInfo.getName(ctx.getLocale()) + "(" + companyInfo.getNumber() + ")"};
                throw new FaPhysicalManageBaseException(FaPhysicalManageBaseException.NOTOPENPARAM, params);
            }
        }
    }

    private static class Validator_FA048
    implements SingleOrgValidator {
        private Validator_FA048() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemInfo paramItem = iParamItem.getParamItemInfo((IObjectPK)new ObjectUuidPK(model.getId()));
            Boolean oldValue = Boolean.valueOf(paramItem.getValue());
            Boolean newValue = Boolean.valueOf(model.getValue());
            String companyId = paramItem.getOrgUnitID().getId().toString();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where id = '" + companyId + "' ");
            PeriodInfo periodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.FIXEDASSETS, (CompanyOrgUnitInfo)companyInfo);
            if (periodInfo != null) {
                IFaCurCard iFaCurCard = FaCurCardFactory.getLocalInstance((Context)ctx);
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("period", (Object)periodInfo.getId(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("company", (Object)companyInfo.getId(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(2), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("originFlag", (Object)new Integer(3), CompareType.EQUALS));
                String mask = "#0 and #1 and (#2 or #3)";
                filterInfo.setMaskString(mask);
                boolean hasSplitOrCombine = iFaCurCard.exists(filterInfo);
                if (hasSplitOrCombine && !oldValue.booleanValue() && newValue.booleanValue()) {
                    String strYear = Integer.toString(periodInfo.getPeriodYear());
                    String strNumber = Integer.toString(periodInfo.getPeriodNumber());
                    String currPeriod = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.fa.manage.FaDepreciationResource", (String)"FaDepMnt_DepPeriodNumber"), strYear, strNumber);
                    throw new FaPeriodException(FaPeriodException.SPLITORCOMBINENOT, new Object[]{companyInfo.getName(ctx.getLocale()), currPeriod});
                }
            }
        }
    }

    private static class Validator_FA021
    implements SingleOrgValidator {
        private Validator_FA021() {
        }

        @Override
        public void check(Context ctx, ParamItemInfo model) throws BOSException, EASBizException {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemInfo paramItem = iParamItem.getParamItemInfo((IObjectPK)new ObjectUuidPK(model.getId()));
            String companyId = paramItem.getOrgUnitID().getId().toString();
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo("where id = '" + companyId + "' ");
            if (model.getValue() != null && model.getValue().toString().equals("false")) {
                String sql = "select top 1 fid from t_fa_facurcard where fcompanyid = ? ";
                try {
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{companyId});
                    if (rs.next()) {
                        CompanyOrgUnitInfo currentCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
                        Object[] params = new Object[]{currentCompany.isIsBizUnit() ? "" : companyInfo.getName(ctx.getLocale()) + "(" + companyInfo.getNumber() + ")"};
                        throw new FaPeriodException(FaPeriodException.SHOWEVALPARAMCANNOTDISABLE, params);
                    }
                }
                catch (SQLException e) {
                    throw new SQLAccessException(e);
                }
            }
        }
    }

    private static interface MultiOrgValidator {
        public void check(Context var1, ParamItemCollection var2) throws BOSException, EASBizException;
    }

    private static interface SingleOrgValidator {
        public void check(Context var1, ParamItemInfo var2) throws BOSException, EASBizException;
    }
}

