/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.facade.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaResUtil;
import com.kingdee.eas.fi.fa.facade.FaLeaseSelectDateType;
import com.kingdee.eas.fi.fa.facade.app.AbstractFAReportCal;
import com.kingdee.eas.fi.fa.manage.FaLeaseRptDataTypeEnum;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class FL_FOG_CALCULATOR
extends AbstractFAReportCal {
    private static Logger logger = Logger.getLogger(FL_FOG_CALCULATOR.class);
    private CompanyOrgUnitInfo curCompany;

    public FL_FOG_CALCULATOR(ICalculateContextProvider provider, Context ctx) {
        super(provider, ctx);
    }

    @Override
    protected void execute(SortedParameterArray params) {
        try {
            for (int i = 0; i < params.size(); ++i) {
                Parameter param = params.getParameter(i);
                Object[] inputsArray = param.getArgs();
                Object[] inputs = (Object[])inputsArray[0];
                param.setValue((Object)this.calc(this.ctx, inputs));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"------------FL_FOG_CALCULATOR exception info start1---------------");
            logger.error((Object)e.getMessage());
            logger.error((Object)e.getCause());
            logger.error((Object)"------------FL_FOG_CALCULATOR exception info end1--------------");
        }
        catch (BOSException e) {
            logger.error((Object)"------------FL_FOG_CALCULATOR exception info start2---------------");
            logger.error((Object)e.getMessage());
            logger.error((Object)e.getCause());
            logger.error((Object)"------------FL_FOG_CALCULATOR exception info end2--------------");
        }
        catch (ParseException e) {
            logger.error((Object)"------------FL_FOG_CALCULATOR exception info start3---------------");
            logger.error((Object)e.getMessage());
            logger.error((Object)e.getCause());
            logger.error((Object)"------------FL_FOG_CALCULATOR exception info end3--------------");
        }
        catch (EASBizException e) {
            logger.error((Object)"------------FL_FOG_CALCULATOR exception info start4---------------");
            logger.error((Object)e.getMessage());
            logger.error((Object)e.getCause());
            logger.error((Object)"------------FL_FOG_CALCULATOR exception info end4--------------");
        }
    }

    protected BigDecimal calc(Context ctx, Object[] inputs) throws BOSException, SQLException, ParseException, EASBizException {
        Date endDateTwo;
        Date endDateOne;
        if (!this.isVariantValid((Variant)inputs[12])) {
            throw new BOSException(FaResUtil.getRes((String)"getNumberTypeIsNotNull"));
        }
        StringBuilder selectSQL = new StringBuilder("SELECT ");
        StringBuilder whereSQL = new StringBuilder("WHERE 1 = 1 \n");
        ArrayList<Object> params = new ArrayList<Object>();
        String companyNumber = null;
        String dataType = inputs[12].toString();
        if (FaLeaseRptDataTypeEnum.LIABILITY_BALANCE.getName().equalsIgnoreCase(dataType)) {
            selectSQL.append("SUM(entry.FEndLiabilityBalance) FEndLiabilityBalance \n");
        } else if (FaLeaseRptDataTypeEnum.UNCFM_FNC_COST.getName().equalsIgnoreCase(dataType)) {
            selectSQL.append("SUM(entry.FEndUnCfmFncCost) FEndUnCfmFncCost \n");
        } else if (FaLeaseRptDataTypeEnum.LIABILITY_PRINCIPAL.getName().equalsIgnoreCase(dataType)) {
            selectSQL.append("SUM(entry.FInitLiabilityPrincipal) FInitLiabilityPrincipal \n");
        } else {
            selectSQL.append("SUM(entry.FEndRightOfUseAsset) FEndRightOfUseAsset \n");
        }
        selectSQL.append("FROM T_FA_FAAMORTIZEDCOSTRPT rpt \n");
        selectSQL.append("LEFT JOIN T_FA_FaLeaseInBillNew leaseInBill ON rpt.FLeaseInBillID = leaseInBill.FID \n");
        if (this.isVariantValid((Variant)inputs[0])) {
            selectSQL.append("LEFT JOIN T_ORG_COMPANY com ON leaseInBill.FCompanyID = com.FID \n");
            whereSQL.append("AND com.FNumber = ? \n");
            companyNumber = inputs[0].toString();
            params.add(companyNumber);
        }
        if (this.isVariantValid((Variant)inputs[1])) {
            selectSQL.append("LEFT JOIN T_FA_FACONTRACTCAT cat ON cat.FID = leaseInBill.FContractCatID \n");
            whereSQL.append("AND cat.FLongNumber = ? \n");
            params.add(inputs[1].toString());
        }
        if (this.isVariantValid((Variant)inputs[2])) {
            whereSQL.append("AND leaseInBill.FNumber = ? \n");
            params.add(inputs[2].toString());
        }
        if (this.isVariantValid((Variant)inputs[3])) {
            whereSQL.append("AND leaseInBill.FContractNumber = ? \n");
            params.add(inputs[3].toString());
        }
        if (this.isVariantValid((Variant)inputs[4])) {
            whereSQL.append("AND leaseInBill.FDiscountRate = ? \n");
            params.add(((Variant)inputs[4]).getValue());
        }
        if (this.isVariantValid((Variant)inputs[5])) {
            selectSQL.append("LEFT JOIN T_BD_CURRENCY currency ON currency.FID = leaseInBill.FCurrencyID \n");
            whereSQL.append("AND currency.FNumber = ? \n");
            params.add(inputs[5].toString());
        }
        if (this.isVariantValid((Variant)inputs[6]) && FaLeaseSelectDateType.ONE_DAY.getName().equals(inputs[6].toString())) {
            if (this.isVariantValid((Variant)inputs[7])) {
                whereSQL.append("AND entry.FDate = ? \n");
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = sdf.parse(inputs[7].toString());
                params.add(new Timestamp(date.getTime()));
            }
        } else if (FaLeaseRptDataTypeEnum.LIABILITY_BALANCE.getName().equalsIgnoreCase(dataType)) {
            whereSQL.append("AND( (leaseInBill.FDepreciationMethod = '1' and entry.FDate = ?) or (leaseInBill.FDepreciationMethod = '2' and entry.FDate = ?) ) \n");
            endDateOne = this.changePeriodToDate(ctx, Integer.parseInt(inputs[9].toString()), Integer.parseInt(inputs[11].toString()), false);
            params.add(new Timestamp(endDateOne.getTime()));
            endDateTwo = this.changePeriodToDate(ctx, Integer.parseInt(inputs[9].toString()), Integer.parseInt(inputs[11].toString()), true);
            params.add(new Timestamp(endDateTwo.getTime()));
        } else if (FaLeaseRptDataTypeEnum.UNCFM_FNC_COST.getName().equalsIgnoreCase(dataType)) {
            whereSQL.append("AND( (leaseInBill.FDepreciationMethod = '1' and entry.FDate = ?) or (leaseInBill.FDepreciationMethod = '2' and entry.FDate = ?) ) \n");
            endDateOne = this.changePeriodToDate(ctx, Integer.parseInt(inputs[9].toString()), Integer.parseInt(inputs[11].toString()), false);
            params.add(new Timestamp(endDateOne.getTime()));
            endDateTwo = this.changePeriodToDate(ctx, Integer.parseInt(inputs[9].toString()), Integer.parseInt(inputs[11].toString()), true);
            params.add(new Timestamp(endDateTwo.getTime()));
        } else if (FaLeaseRptDataTypeEnum.LIABILITY_PRINCIPAL.getName().equalsIgnoreCase(dataType)) {
            whereSQL.append("AND( (leaseInBill.FDepreciationMethod = '1' and entry.FDate = ?) or (leaseInBill.FDepreciationMethod = '2' and entry.FDate = ?) ) \n");
            Date startDateOne = this.changePeriodToDate(ctx, Integer.parseInt(inputs[8].toString()), Integer.parseInt(inputs[10].toString()), true);
            params.add(new Timestamp(startDateOne.getTime()));
            Date startDateTwo = this.changePeriodToDate(ctx, Integer.parseInt(inputs[8].toString()), Integer.parseInt(inputs[10].toString()), true);
            params.add(new Timestamp(startDateTwo.getTime()));
        } else {
            whereSQL.append("AND( (leaseInBill.FDepreciationMethod = '1' and entry.FDate = ?) or (leaseInBill.FDepreciationMethod = '2' and entry.FDate = ?) ) \n");
            endDateOne = this.changePeriodToDate(ctx, Integer.parseInt(inputs[9].toString()), Integer.parseInt(inputs[11].toString()), false);
            params.add(new Timestamp(endDateOne.getTime()));
            endDateTwo = this.changePeriodToDate(ctx, Integer.parseInt(inputs[9].toString()), Integer.parseInt(inputs[11].toString()), true);
            params.add(new Timestamp(endDateTwo.getTime()));
        }
        selectSQL.append("LEFT JOIN T_FA_FAAMORTIZEDCOSTRPTENTRY entry ON rpt.FID = entry.FAmortizedCostRptID \n");
        int precision = this.getCurCompany(ctx, companyNumber) == null ? this.getCurCompany(ctx, null).getBaseCurrency().getPrecision() : this.curCompany.getBaseCurrency().getPrecision();
        BigDecimal ZERO = BigDecimal.ZERO.setScale(precision, RoundingMode.HALF_UP);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL.append(whereSQL.toString()).toString(), (Object[])params.toArray());
        if (rs.next()) {
            return rs.getBigDecimal(1) == null ? ZERO : rs.getBigDecimal(1).setScale(precision, RoundingMode.HALF_UP);
        }
        return ZERO;
    }

    private boolean isVariantValid(Variant v) {
        if (v == null || v.getValue() == null) {
            return false;
        }
        return !String.class.getName().equals(v.getType().getName()) || v.toString().trim().length() > 0;
    }

    private CompanyOrgUnitInfo getCurCompany(Context ctx, String number) {
        if (this.curCompany != null) {
            return this.curCompany;
        }
        try {
            SelectorItemCollection comSic = new SelectorItemCollection();
            comSic.add("id");
            comSic.add("number");
            comSic.add("name");
            comSic.add("baseCurrency.precision");
            if (number == null) {
                this.curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
                this.curCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.curCompany.getId()), comSic);
            } else {
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
                view.setSelector(comSic);
                view.setFilter(filter);
                CompanyOrgUnitCollection comCol = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitCollection(view);
                if (comCol != null && comCol.size() > 0) {
                    this.curCompany = comCol.get(0);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)(ResourceBase.getString((String)"com.kingdee.eas.fi.fa.facade.FACADEAutoGenerateResource", (String)"1_FL_FOG_CALCULATOR", (Locale)ctx.getLocale()) + e.getMessage()), (Throwable)e);
        }
        return this.curCompany;
    }

    private Date changePeriodToDate(Context ctx, int year, int period, boolean isStartType) throws EASBizException, BOSException, ParseException {
        CompanyOrgUnitInfo aCompanyOrgUnitInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
        PeriodInfo currentPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.getEnum((int)2001), (CompanyOrgUnitInfo)aCompanyOrgUnitInfo);
        Calendar currentPeriodDate = Calendar.getInstance();
        currentPeriodDate.set(currentPeriodInfo.getPeriodYear() + year, currentPeriodInfo.getPeriodNumber() - 1 + period, 1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateTmp = sdf.format(currentPeriodDate.getTime());
        Date date = sdf.parse(dateTmp);
        if (isStartType) {
            return FL_FOG_CALCULATOR.getMinMonthDate(date);
        }
        return FL_FOG_CALCULATOR.getMaxMonthDate(date);
    }

    public static Date getMinMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMaxMonthDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }
}

